	org	&h100
;
bDos	equ	5
;
; Change CPU - BiFi's version
;
; (c) BiFi'96
;
	jp	start
;
	db	"CPU V1.2 by BiFi'96",26
;
start:	call	dosVer	; Dos version first
	ld	a,1
	jr	z,setDos
	inc	a
setDos:	ld	(dosVerCode),a
	ld	hl,&h2d	; Check system version
	ld	a,(&hfcc1)
	call	&hc	; TurboR required
	cp	3
	jr	c,usage
	ld	hl,&h80	; Get length of parameters list
	ld	a,(hl)	; Check length
	and	a	; Print usage of no pars.
	jr	z,usage
	inc	hl	; Start of parameter list
	ld	de,checkList	; Start of check list
unSpace:	ld	a,(hl)	; Ignore previous spaces
	cp	" "
	jr	nz,nextCheck
	inc	hl
	jr	unSpace
nextCheck:	push	hl	; Prepare for next check :-)
checkLoop:	ld	a,(de)
	and	a	; Zero indicates end of item (found!)
	jr	z,goAddress	; Get and go to the address
	call	lowerCaseTwo
	cp	(hl)	; (de)=(hl)?
	jr	nz,nextInList	; Find next item in the list if not
	inc	de
	inc	hl
	jr	checkLoop	; Next character in item

nextInList:	ld	a,(de)	; Find zero
	inc	de
	and	a
	jr	nz,nextInList
	inc	de	; Ignore address
	inc	de
	ld	a,(de)	; Check end of check list
	inc	a
	jr	z,usage
	pop	hl	; Get start of list
	jr	nextCheck

goAddress:	pop	hl	; Restore stack
	ex	de,hl	; Get address in DE
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ex	de,hl	; Address in HL
	jp	(hl)	; That's why!
;
lowerCaseTwo:	ex	af,af
	ld	a,(hl)
	call	lowerCase
	ld	(hl),a
	ex	af,af
lowerCase:	cp	"A"
	ret	c
	cp	"Z"+1
	ret	nc
	or	32
	ret
;
checkList:	db	"r800d",0
	dw	r800d
	db	"r800",0
	dw	r800
	db	"z80",0
	dw	z80
	db	"now",0
	dw	now
	db	-1
dosVerCode:	db	0
;
usage:	ld	de,tUsage
print:	ld	c,9
	push	af	; Store TurboR info
	call	bDos
	pop	af	; Restore TurboR info
	jr	nc,abort
	ld	de,tTurboR
	ld	c,9
	call	bDos
abort:	ld	b,a
	ld	a,(dosVerCode)
	cp	2
	jr	c,endDos1
	ld	c,&h62	; Terminate
	call	bDos

endDos1:	rst	0
;
dosVer:	ld	c,&h6f	; Get DOS version
	call	bDos
	or	a	; Errors mean no DOS2
	jr	nz,noDos2
	ld	a,b	; Check version of kernel
	cp	2	; Less than 2?
	jr	c,noDos2
	xor	a
	dec	a
	ret

noDos2:	xor	a
	ret
;
tUsage:	db	13,10,"CPU V1.2 by BiFi'96",10
	db	13,10,"Usage: CPU <CPU-Type>",10
	db	13,10,"<CPU-Type> = Z80",9,"Z80 ROM mode"
	db	13,10,9,"   = R800",9,"R800 ROM mode"
	db	13,10,9,"   = R800D",9,"R800 DRAM mode"
	db	13,10,9,"   = NOW",9,"Get current CPU mode"
	db	13,10,"$"
tTurboR:	db	13,10,"By the way... CPU can only be used "
	db	"on a MSX-TurboR computer!",13,10,10,"$"
tActive:	db	" is now active...$"
setName:	db	"CPUMODE",0
setZ80:	db	"Z80 (ROM)",0
setR800:	db	"R800 (ROM)",0
setR800D:	db	"R800 DRAM",0
;
z80:	ld	a,128
	ld	de,setZ80
	jr	chgCpu
;
r800:	ld	a,129
	ld	de,setR800
	jr	chgCpu
;
r800d:	ld	a,130
	ld	de,setR800D
chgCpu:	ld	ix,&h180	; CHGCPU in Main-ROM
	push	de	; Store address
	call	biosRom
	pop	de	; Restore address

	ld	a,(dosVerCode)
	cp	2
	jr	c,dos1Show

	ld	c,&h6c	; Set environment item
	ld	hl,setName
	call	bDos
	jp	abort
;
now:	ld	ix,&h183
	call	biosRom
	and	a
	jr	z,z80
	dec	a
	jr	z,r800
	dec	a
	jr	z,r800d
	jp	usage
;
biosRom:	ld	iy,(&hfcc0)
	jp	&h1c
;
dos1Show:	ex	de,hl
dos1Loop:	ld	e,(hl)
	ld	a,e
	and	a
	jr	z,printActive
	inc	hl
	push	hl
	ld	c,2
	call	bDos
	pop	hl
	jr	dos1Loop

printActive:	ld	de,tActive
	jp	print
