	org	&h100
;
bDos	equ	5
useHook:	equ	&hf975
;
; Change CPU - BiFi's version
;
; (c) BiFi'96 / BiFi'98
;
	jp	start
;
	db	13,"CPU V1.3 by BiFi'96/'98",26
;
start:	call	dosVer	; Dos version first
	ld	a,1
	jr	z,setDos
	inc	a
setDos:	ld	(dosVerCode),a
	ld	hl,&h2d	; Check system version
	ld	a,(&hfcc1)
	call	&hc	; TurboR required
	cp	3
	jr	c,usage
	ld	hl,&h80	; Get length of parameters list
	push	hl
	call	chkOption	; Install or de-install resident part
	pop	hl
	ld	a,(hl)	; Check length
	and	a	; Print usage of no pars.
	jr	z,usage
	inc	hl	; Start of parameter list
	ld	de,checkList	; Start of check list
unSpace:	ld	a,(hl)	; Ignore previous spaces
	cp	" "
	jr	nz,nextCheck
	inc	hl
	jr	unSpace
nextCheck:	push	hl	; Prepare for next check :-)
checkLoop:	ld	a,(de)
	and	a	; Zero indicates end of item (found!)
	jr	z,goAddress	; Get and go to the address
	call	lowerCaseTwo
	cp	(hl)	; (de)=(hl)?
	jr	nz,nextInList	; Find next item in the list if not
	inc	de
	inc	hl
	jr	checkLoop	; Next character in item

nextInList:	ld	a,(de)	; Find zero
	inc	de
	and	a
	jr	nz,nextInList
	inc	de	; Ignore address
	inc	de
	ld	a,(de)	; Check end of check list
	inc	a
	jr	z,usage
	pop	hl	; Get start of list
	jr	nextCheck

goAddress:	pop	hl	; Restore stack
	ex	de,hl	; Get address in DE
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	ex	de,hl	; Address in HL
	jp	(hl)	; That's why!
;
lowerCaseTwo:	ex	af,af'
	ld	a,(hl)
	call	lowerCase
	ld	(hl),a
	ex	af,af'
lowerCase:	cp	"A"
	ret	c
	cp	"Z"+1
	ret	nc
	or	32
	ret
;
checkList:	db	"r800d",0
	dw	r800d
	db	"r800",0
	dw	r800
	db	"z80",0
	dw	z80
	db	"now",0
	dw	now
	db	-1
dosVerCode:	db	0
;
usage:	ld	de,tUsage
print:	ld	c,9
	push	af	; Store TurboR info
	call	bDos
	pop	af	; Restore TurboR info
	jr	nc,abort
	ld	de,tTurboR
	ld	c,9
	call	bDos
abort:	ld	b,a
	ld	a,(dosVerCode)
	cp	2
	jr	c,endDos1
	ld	c,&h62	; Terminate
	call	bDos

endDos1:	rst	0
;
dosVer:	ld	c,&h6f	; Get DOS version
	call	bDos
	or	a	; Errors mean no DOS2
	jr	nz,noDos2
	ld	a,b	; Check version of kernel
	cp	2	; Less than 2?
	jr	c,noDos2
	xor	a
	dec	a
	ret

noDos2:	xor	a
	ret
;
tUsage:	db	13,10,"Usage: CPU <CPU-Type> [/R]",10
	db	13,10,"<CPU-Type> = Z80",9,"Z80 ROM mode"
	db	13,10,9,"   = R800",9,"R800 ROM mode"
	db	13,10,9,"   = R800D",9,"R800 DRAM mode"
	db	13,10,9,"   = NOW",9,"Get current CPU mode",10
	db	13,10,9,"/R = Install or de-install resident part"
	db	13,10,"$"
tTurboR:	db	13,10,"By the way... CPU can only be used "
	db	"on a MSX-TurboR computer!",13,10,10,"$"
tActive:	db	" is now active...$"
setName:	db	"CPUMODE",0
setZ80:	db	"Z80 (ROM)",0
setR800:	db	"R800 (ROM)",0
setR800D:	db	"R800 DRAM",0
;
z80:	ld	a,128
	ld	de,setZ80
	jr	chgCpu
;
r800:	ld	a,129
	ld	de,setR800
	jr	chgCpu
;
r800d:	ld	a,130
	ld	de,setR800D
chgCpu:	ld	ix,&h180	; CHGCPU in Main-ROM
	push	de	; Store address
	call	biosRom
	pop	de	; Restore address

	ld	a,(dosVerCode)
	cp	2
	jr	c,dos1Show

	ld	c,&h6c	; Set environment item
	ld	hl,setName
	call	bDos
	jp	abort
;
now:	ld	ix,&h183
	call	biosRom
	and	a
	jr	z,z80
	dec	a
	jr	z,r800
	dec	a
	jr	z,r800d
	jp	usage
;
biosRom:	ld	iy,(&hfcc0)
	jp	&h1c
;
dos1Show:	ex	de,hl
dos1Loop:	ld	e,(hl)
	ld	a,e
	and	a
	jr	z,printActive
	inc	hl
	push	hl
	ld	c,2
	call	bDos
	pop	hl
	jr	dos1Loop

printActive:	ld	de,tActive
	jp	print
;
chkOption:	ld	c,(hl)
	ld	b,h
	inc	c
	dec	c
	ret	z

	inc	hl
	ld	a,"/"
	cpir
	ret	nz
	ret	po

	ld	a,(hl)
	cp	"R"
	jr	z,optionOk
	cp	"r"
	ret	nz

optionOk:	ld	a,(useHook)
	and	a
	jr	nz,resetHook

setHook:	di
	ld	bc,hookLength
	ld	de,useHook
	ld	hl,moveHook
	ldir

	ld	bc,5
	ld	de,oldHook
	ld	hl,&hfd9f
	push	hl,bc
	ldir
	pop	bc,de
	ld	hl,newHook
move:	ldir
	ei
	ret
;
resetHook:	di
	xor	a
	ld	(useHook),a

	ld	bc,5
	ld	de,&hfd9f
	ld	hl,oldHook
	jr	move
;
newHook:	jp	hook
	ret
	ret
;
moveHook	equ	$
	org	useHook
;
hook:	push	af,bc,de,hl
	di
	call	noKey
	jr	nz,checkNo

selCpuLoop:	call	yesKey
	jr	nz,endHook

	ld	a,(flags)
	and	4
	call	z,savePopUp

	ld	a,(flags)
	and	3
	inc	a
	cp	3
	jr	nz,modeOk
	xor	a
modeOk:	ld	b,a
	ld	a,(flags)
	and	252
	or	b
	ld	(flags),a
	and	3
	ld	hl,tCpuMode
	jr	z,baseCpuText
	ld	b,a
	ld	de,15
getCpuText:	add	hl,de
	djnz	getCpuText
baseCpuText:	call	printPopUp

	di
loseYes:	call	yesKey
	jr	z,loseYes
	jr	selCpuLoop
;
checkNo:	ld	a,(flags)
	and	4
	jr	z,endHook

	ld	a,(flags)
	and	251
	ld	(flags),a

	ld	a,(flags)
	and	3
	or	128
	call	&h180

	ld	a,(&hfcaf)
	cp	2
	jr	nc,endHook

	ld	bc,15
	ld	de,(&hf922)
	ld	hl,oldLine
	call	&h5c
	ei
endHook:	pop	hl,de,bc,af
oldHook:	ds	5,0
;
savePopUp:	call	&h183
	or	4
	ld	(flags),a

	ld	a,(&hfcaf)
	cp	2
	ret	nc

	ld	bc,15
	ld	de,oldLine
	ld	hl,(&hf922)
	jp	&h59
;
printPopUp:	ld	a,(&hfcaf)
	cp	2
	ret	nc

	ld	bc,15
	ld	de,(&hf922)
	jp	&h5c
;
yesKey:	ld	a,11
	call	snsMat
	and	2
	ret
;
noKey:	ld	a,11
	call	snsMat
	and	8
	ret
;
snsMat:	push	bc
	ld	c,a
	in	a,(&haa)
	and	240
	or	c
	out	(&haa),a
	nop
	nop
	in	a,(&ha9)
	pop	bc
	ret
;
flags:	db	0
oldLine:	ds	15,0
tCpuMode:	db	"Z80 (ROM) mode "
	db	"R800 (ROM) mode"
	db	"R800 DRAM mode "
;
hookLength	equ	$-hook
