	db	'MST TSR',cr,lf
	db	'MJV printbuf',ctrlz
	dw	&h0003
	dw	base
	dw	init
	dw	kill
	dw	drvEnt
	dw	tsrLen
	dw	iniLen

quitHook	equ	0
quitLoad	equ	0
introText	equ	1

bel	equ	7
tab	equ	9
lf	equ	10
cr	equ	13
ctrlz	equ	26

lpt_st	equ	&h90
lpt_dw	equ	&h91

calSlt	equ	&h1c
lptOut	equ	&ha5
breakx	equ	&hb7
valTyp	equ	&hf663
dac	equ	&hf7f6
h_timi	equ	&hfd9f
h_cmd	equ	&hfe0d
h_attr	equ	&hfe1c
h_lptO	equ	&hffb6
h_lptS	equ	&hffbb
expTbl	equ	&hfcc1
mainRom	equ	expTbl

alloc	equ	10
setRes	equ	11
deAlloc	equ	20
iniChk	equ	30
info	equ	50
getBasCall	equ	4
fastGetCur	equ	5
getID	equ	62
heapAlloc	equ	70
heapDeAlloc	equ	71

pbtVer	equ	&h0102
pbStackSize	equ	32

printToken	equ	&h91
clearToken	equ	&h92
freToken	equ	&h8f

mMan	macro	@fnc
	ld	e,@fnc
	call	&h4002
	endm

base	equ	$

doInt:	di
	push	af
	ld	a,(leegFl)
	or	a
	jr	z,quitInt
	in	a,(lpt_st)
	bit	1,a
	jr	nz,quitInt

outBuf:	call	getCur2
	ld	b,30
prtLoop:	push	bc
	ld	a,(botSeg)
	call	mmOut
	pop	bc
	ld	hl,(botPtr)
	ld	a,(hl)
	out	(lpt_dw),a
	xor	a
	out	(lpt_st),a
	dec	a
	out	(lpt_st),a
makRoom:	inc	hl
	bit	6,h
	ld	a,(botSeg)
	jr	z,noTop
	ld	hl,(maxSeg)
	cp	l
	ld	hl,&h8000
	inc	a
	jr	c,notMax
	xor	a
notMax:	ld	(botSeg),a
noTop:	ld	(botPtr),hl
	ld	de,(topSeg)
	cp	e
	jr	nz,next
	ld	de,(topPtr)
	sbc	hl,de
	jr	z,zetLeeg
next:	in	a,(lpt_st)
	bit	1,a
	jr	z,next1
	ld	hl,(waitMax)
outWait:	in	a,(lpt_st)
	bit	1,a
	jr	z,next1
	dec	l
	jr	nz,outWait
	jr	endWait
next1:	djnz	prtLoop
endWait:	call	rstCur2
quitInt:	sub	a
	ex	af,af'
	pop	af
	ret
zetLeeg:	xor	a
	ld	(leegFl),a
	jr	endWait

toBuf:	di
	ex	af,af'
	ld	a,(bufFl)
	or	a
	jr	nz,bufFnd
	ex	af,af'
	ret
bufFnd:	pop	ix
	ex	(sp),ix
	ex	af,af'
	push	hl
	push	de
	push	bc
	push	af
	ld	(lineBuf+1),a
	ld	a,1
	ld	(lineBuf+0),a
	call	lnToBuf
	pop	hl
	ld	a,h
	pop	bc
	pop	de
	pop	hl
	ex	af,af'
	ld	a,1
	ex	af,af'
	ret

lnToBuf:	xor	a
	ld	(linePnt),a
	inc	a
	ld	(leegFl),a
	call	getCur2
bufLnLp:	ld	hl,lineBuf
	ld	a,(linePnt)
	cp	(hl)
	jr	nz,chToBuf
	call	rstCur2
	or	a
	ret

chToBuf:	ld	a,(topSeg)
	call	mmOut
	ld	hl,(linePnt)
	ld	de,lineBuf+1
	add	hl,de
	ld	a,(hl)
	ld	hl,(topPtr)
	ld	(hl),a
	inc	hl
	bit	6,h
	ld	a,(topSeg)
	jr	z,nietVol
	ld	hl,(maxSeg)
	cp	l
	ld	hl,&h8000
	inc	a
	jr	c,nietMax
	xor	a
nietMax:	ld	(topSeg),a
nietVol:	ld	(topPtr),hl
	ld	de,(botSeg)
	cp	e
	jr	nz,nextChr
	ld	de,(botPtr)
	sbc	hl,de
	jr	nz,nextChr
	call	rstCur2
fulWait:	di
	ld	ix,breakx
	ld	iy,(mainRom-1)
	call	calSlt
	jr	c,ctrStop
	ei
	ld	hl,(topPtr)
	ld	de,(botPtr)
	sbc	hl,de
	jr	z,fulWait
	call	getCur2
nextChr:	ld	hl,linePnt
	inc	(hl)
	jr	bufLnLp
ctrStop:	xor	a
	ld	(leegFl),a
	scf
	ret

bufStat:	ex	af,af'
	ld	a,(bufFl)
	or	a
	ld	a,0
	jr	z,exRet
	pop	ix
	ex	(sp),ix
	ex	af,af'
	sub	a
	dec	a
	ex	af,af'
	ld	a,1
exRet:	ex	af,af'
	ret

cmd:	push	af
	push	hl
	call	testHelp
	cp	clearToken
	jr	z,clear
nextCmd:	sub	a
	ex	af,af'
	pop	hl
	pop	af
	ret
clear:	call	chkPbT
	pop	af
	ex	(sp),hl
	call	leegBuf
	pop	hl
	call	chrGtR
	jr	z,quitCmd
	call	evalInt
	push	hl
	call	instDE
	pop	hl
quitCmd:	pop	de
	pop	af
	push	de
	ld	a,1
	ex	af,af'
	ret

testHelp:	cp	'H'
	jr	nz,noHelp
	inc	hl
	ld	a,(hl)
	cp	'E'
	ret	nz
	inc	hl
	ld	a,(hl)
	cp	'L'
	ret	nz
	inc	hl
	ld	a,(hl)
	cp	'P'
	call	printHelp
	pop	af
	jr	nextCmd
noHelp:	ret

attr:	push	af
	push	hl
	call	chrGtR
	cp	255
	jr	nz,nextCmd
	call	chrGtR
	cp	freToken
	jr	nz,nextCmd
	call	chkPbT
	pop	af
	ex	(sp),hl
	ld	hl,valTyp
	ld	(hl),2
	ld	hl,(kbInst)
	ld	(dac + 2),hl
	pop	hl
	call	chrGtR
	jr	quitCmd

chkPbT:	call	chrGtR
	cp	printToken
	jr	nz,noPbT
	inc	hl
	ld	a,(hl)
	cp	'B'
	jr	nz,noPbT
	inc	hl
	ld	a,(hl)
	cp	'U'
	jr	nz,noPbT
	inc	hl
	ld	a,(hl)
	cp	'F'
	ret	z
noPbT:	pop	hl
	jp	nextCmd

printHelp:	ld	de,tHelp
printLp:	ld	a,(de)
	or	a
	ret	z
	rst	&h18
	inc	de
	jr	printLp

tHelp:	db	'MJV printbuf',cr,lf
	db	' <var> = ATTR$ FRE PRINTBUF',cr,lf
	db	' CMD CLEAR PRINTBUF [<var>]',cr,lf,0

leegBuf:	di
	ld	hl,(topPtr)
	ld	(botPtr),hl
	xor	a
	ld	(topSeg),a
	ld	(botSeg),a
	ld	(leegFl),a
	ret

evalInt:	call	frmEvl
	ld	de,(dac + 2)
	ld	a,(valTyp)
	cp	2
	ret	z
	push	hl
	call	frcInt
	ld	de,(dac + 2)
	pop	hl
	ret

frmEvl:	ld	ix,&h4c64
	jr	basicCall

chrGtR:	ld	ix,&h4666
	jr	basicCall

frcInt:	ld	ix,&h2f8a
basicCall:	call	0
	ei
	ret

instDE:	push	de
	call	killSeg
	pop	de
	ld	a,d
	or	e
	ret	z
	dec	de
	srl	d
	rr	e
	srl	d
	rr	e
	srl	d
	rr	e
	srl	d
	rr	e
	inc	e
	ld	a,e
	ld	(segInst),a

zoekMem:	ld	de,mmTabel
	ld	bc,(segInst)
	ld	b,0
	inc	c
	dec	c
	jr	nz,memMan2
	ld	c,128
memMan2:	push	de
	push	bc
	ld	b,2 or &b11000000
memMan3:	mMan	alloc
	pop	bc
	pop	de
	ld	a,h
	or	l
	jr	z,memMan4
	ex	de,hl
	ld	(hl),e
	inc	hl
	ld	(hl),d
	inc	hl
	ex	de,hl
	push	de
	push	bc
	mMan	setRes
	pop	bc
	pop	de
	inc	b
	ld	a,b
	cp	c
	jr	nz,memMan2
memMan4:	ld	a,b
	ld	(bufFl),a
	ld	h,a
	ld	l,a
	or	a
	jr	z,memMan5
	dec	a
	ld	(maxSeg),a
	inc	a
	ld	l,a
	xor	a
	sla	l
	rla
	sla	l
	rla
	sla	l
	rla
	sla	l
	rla
	ld	h,a
memMan5:	ld	(kbInst),hl
	ret

mmOut:	ld	b,a
	ld	a,(curMap)
	cp	b
	ld	a,b
	ret	z
	ld	(curMap),a
	ld	de,mmTabel
	ld	hl,(curMap)
	add	hl,hl
	add	hl,de
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	jr	fastUse2

getCur2:	di
	pop	hl
	ld	(savSp),sp
	ld	sp,(pbStack)
	push	hl
	ld	b,2
gtCurAd:	call	0
	ld	(oldSeg2),hl
	ld	a,-1
	ld	(curMap),a
	ret

rstCur2:	ld	hl,(oldSeg2)
	call	fastUse2
	pop	hl
	ld	sp,(savSp)
	jp	(hl)

fastUse2:	jp	0

drvEnt:	ld	b,d
	ld	c,e
	ex	de,hl
	or	a
	ld	hl,pbtVer
	ret	z
	dec	a
	jp	z,leegBuf
	dec	a
	jp	z,instDE
	dec	a
	ld	hl,(kbInst)
	ret	z
	dec	a
	jr	z,flushDE
	ret

flushDE:	bit	7,d
	jr	nz,tstBuf
	ld	de,ePage
	ld	bc,errLen
tstBuf:	ld	a,(bufFl)
	or	a
	jr	z,toLpt
flushLp:	ld	h,b
	ld	l,c
	ld	bc,255
	or	a
	sbc	hl,bc
	jr	nc,copyDta
	add	hl,bc
	ld	a,h
	or	l
	ret	z
	ld	b,h
	ld	c,l
	ld	hl,0
copyDta:	push	hl
	ld	hl,lineBuf
	ld	(hl),c
	inc	hl
	ex	de,hl
	ldir
	push	hl
	call	lnToBuf
	pop	de
	pop	bc
	jr	nc,flushLp
	ret

toLpt:	ld	a,b
	or	c
	ret	z
	ld	a,(de)
	ld	ix,lptOut
	ld	iy,(mainRom-1)
	call	calSlt
	ret	c
	inc	de
	dec	bc
	jr	toLpt

kill:	ld	hl,(heapPnt)
	mMan	heapDeAlloc

killSeg:	call	leegBuf
	ld	hl,bufFl
	ld	a,(hl)
	or	a
	ret	z
	ld	(hl),0
	ld	a,(maxSeg)
	inc	a
	ld	b,a
	ld	hl,mmTabel
freeLp:	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	push	hl
	push	bc
	ex	de,hl
	mMan	deAlloc
	pop	bc
	pop	hl
	djnz	freeLp
	ld	hl,0
	ld	(kbInst),hl
	ret

ePage:	db	bel,'PB TSR error: Data address below &H8000',cr,lf
errLen	equ	$-ePage

botPtr:	dw	&h8000
topPtr:	dw	&h8000
waitMax:	db	20
segInst:	db	4
bufFl:	db	1
kbInst:	dw	0
curMap:	dw	0
oldSeg2:	dw	0
mmTabel:	ds	256,0
savSp:	dw	0
pbStack:	dw	0
heapPnt:	dw	0
leegFl:	db	0
botSeg:	db	0
topSeg:	db	0
maxSeg:	db	0
bezig:	db	0
linePnt:	dw	0
lineBuf:	ds	1+255,0
tsrLen	equ	$-base

init:	ld	(initSp),sp
	ld	hl,tPbNaam
	mMan	getID
	jp	nc,pbDouble
	ld	b,2
	mMan	info
	ld	(fastUse2 + 1),hl
	ld	b,fastGetCur
	mMan	info
	ld	(gtCurAd+1),hl
	ld	b,getBasCall
	mMan	info
	ld	(basicCall+1),hl
	ld	hl,pbStackSize
	mMan	heapAlloc
	ld	a,h
	or	l
	jr	z,heapErr
	ld	(heapPnt),hl
	ld	de,pbStackSize
	add	hl,de
	ld	(pbStack),hl
	call	zoekMem
	ld	hl,(kbInst)
	call	deci
	ld	de,tIntro
	ld	a,2
	ret
pbDouble:	ld	a,cr
	ld	(tIntEnd),a
	ld	de,tIntro
	jr	prtEnd
heapErr:	ld	de,tHeap
prtEnd:	ld	sp,(initSp)
	ld	a,3
	ret

deci:	ld	de,tFree
	ld	b,5
	ld	a,' '
dc1:	ld	(de),a
	inc	de
	djnz	dc1
dc2:	ld	e,0
	ld	b,16
	or	a
dc3:	rl	l
	rl	h
	rl	e
	ld	a,e
	sub	10
	ccf
	jr	nc,dc4
	ld	e,a
dc4:	djnz	dc3
	rl	l
	rl	h
	ld	a,e
	add	a,'0'
	push	hl
	ld	hl,tFree+3
	ld	de,tFree+4
	ld	bc,4
	lddr
	ld	(tFree),a
	pop	hl
	ld	a,h
	or	l
	jr	nz,dc2
	ret

initSp:	dw	0

tIntro:	db	"   MSX Computer Magazine's",cr,lf
	db	'     Printer Buffer TSR',cr,lf
	db	'      13/4/91 - by MJV',cr,lf,lf
	db	'     11/10/93 - by ABP',cr,lf,lf
tFree:	db	'    0 kB buffer installed',cr,lf,lf
tIntEnd:	db	0
tDouble:	db	bel,'Printer buffer already installed.',cr,lf,0
tHeap:	db	bel,'Not enough heap-memory available.',cr,lf
	db	'PB needs 32 bytes heap-memory.',cr,lf
	db	'Use CFGMMAN to install more heap-memory.',cr,lf,lf,0
tPbNaam:	db	'MJV printbuf'
iniLen	equ	$-init

	TSRHOOKS

hokTab:	dw	endHT-$
	dw	h_timi
	dw	doInt
	dw	h_cmd
	dw	cmd
	dw	h_attr
	dw	attr
	dw	h_lptO
	dw	toBuf
	dw	h_lptS
	dw	bufStat
endHT	equ	$

	end		; PB.TSR
