; TSRFRAME - MST TSR
;
; Tsr frame file for COMPASS
;

; Macro definitions
;
tsrName	macro
	db	"BiFi PADKEY2"	; TSR ID-Name
	endm
;
mMan	macro	@fnc	; Macro for making MemMan
	ld	e,@fnc	; function calls
	call	&h4002
	endm


;--------------------------------------;
;    Header for the TSR file           ;
;--------------------------------------;
;
	db	"MST TSR",13,10	; TSR identifier
	tsrName		; ID-Name
	db	26	; ^Z
	dw	0003	; Header file versie, MemMan 2.4
	dw	base	; Code base address
	dw	init	; Init address
	dw	kill	; Kill address
	dw	talk	; TsrCall entry
	dw	tsrLen	; Programma code lengte
	dw	iniLen	; Init code lengte


;--------------------------------------;
;    Start of TSR-program code         ;
;--------------------------------------;
;
extBio	equ	&hffca	; EXTBIO hook
;
hook	equ	&hfd9f	; Dummy: Hook to be bend by this TSR
;
info	equ	50	; MemMan function
getMemManEnt	equ	6	; Info subfunction
getTsrID	equ	62
;

;
; TSR Base Address
;
base	equ	$	; First byte of program code
;
kill:	ret		; No destruction routine
;
talk:	ret		; No driver routine
;
program:	push	af,bc,de,hl	; Hook-processing program start
	xor	a	; Insert your own routine here
	call	pad
	jr	c,endHook	; Carry set when pad pressed
	ld	a,4	; Check port 2
	call	pad
	jr	c,endHook	; Carry set when pad pressed
	xor	a
	ld	(pressed),a
endHook:	pop	hl,de,bc,af
endProgram:	ex	af,af'	; Save AF
	ld	a,0	; Reset flags for TsrManager
	ex	af,af'	; Restore AF, flags to A'
	ret		; Return to TsrManager
;
getPad:	push	hl
	ld	hl,curPad
	ld	a,(hl)	; Get current pad register
	inc	(hl)	; Set next pad register
	call	&hdb	; Read pad
	pop	hl
	ret
;
curPad:	db	0
graphChar:	db	0	; Graphical character flag
pressed:	db	0	; Pad pressed flag
;
pad:	ld	(curPad),a	; Fill curPad for later use
	call	getPad	; Check if pad pressed
	or	a	; Force NC
	ret	z

	ld	a,(pressed)	; Check still pressed
	or	a	; Set flags and Carry if return
	scf
	ret	nz	; Return if pressed

	ld	a,-1	; Set pressed state
	ld	(pressed),a

	call	getPad	; Put X-coordinate in H
	ld	h,a
	call	getPad	; Put Y-coordinate in L
	ld	l,a
	call	getPad	; Write button text if pressed
	ld	(graphChar),a

	call	calcChar
	ld	b,a
	cp	32
	jr	nc,wrtKBB
	ld	a,(graphChar)
	and	a
	ld	a,b
	jr	z,wrtKBB
	ld	a,1
	call	wrtKBB
	ld	a,b
	add	a,64
	jr	wrtKBB
;
wrtKBB:	push	de,hl
	call	wrtBuf
	pop	hl,de
	scf
	ret
;
wrtBuf:	ld	hl,(&hf3f8)
	ld	(hl),a
	inc	hl
	ld	a,l
	cp	&h18
	jr	nz,noWrap
	ld	hl,&hfbf0
noWrap:	ld	de,(&hf3fa)
	rst	&h20
	ret	z
	ld	(&hf3f8),hl
	ret
;
calcChar:	ld	a,h	; A = HHHHLLLL
	and	240
	ld	b,a
	ld	a,l
	rrca
	rrca
	rrca
	rrca
	and	15
	or	b
	ret
;
tsrLen	equ	$-base	; Length of TSR programcode


;--------------------------------------;
;     Init-code                        ;
;--------------------------------------;
;
init:	ld	hl,tTsrName	; Pointer to TSR name-string
	mMan	getTsrID	; See if this TSR already exists
	jr	nc,initDouble	; Yes, => Double installed error

	ld	de,tIntro
	ld	a,2	; Flags in A, no messages
	ret		; Init ready, return to TsrLoad

initDouble:	ld	de,tDouble	; DE=Text pointer
	ld	a,3	; Flags for TL: Print text & Abort
	ret		; Return to TsrLoad

;
tTsrName:	tsrName		; Macro for tsr-name string
;
tIntro:	db	"PadKey version 2.0 - Written by: BiFi'98",13,10,10
	db	"This version of PadKey can produce every",13,10
	db	"ASCII-character and graphical lines by a",13,10
	db	"single push on the touchpad. The twobyte",13,10
	db	"graphical charatcers can be printed when",13,10
	db	"you push the leftmost 32 area's with one",13,10
	db	"of the action-buttons pressed",13,10,10,0
;
tDouble:	; Error text, 0-terminated
	db	'This TSR is already installed',13,10,10,0
;
iniLen	equ	$-init	; Length of init-code
;
;--------------------------------------;
;    Hook Table                        ;
;--------------------------------------;
;
	TSRHOOKS	; This is for COMPASS

hooks:	dw	hokTabLen	; Length of HokTab
	dw	hook
	dw	program
;
hokTabLen	equ	$-hooks	; Length of hook-table
;
;--------------------------------------;
;
	end		; TSRFRAME
;
