	org	&h100
;
; JANSI control tool - improved version of ANSI.COM
;
; Written by: BiFi'97
;
bDos	equ	5
extBio	equ	&hffca
;
	jp	start
	db	13,"JANSI.COM version 1.0 - Written by: BiFi'97",26
;
ansiState:	db	0
ansiOption:	db	0	; Bit 0 - MSX characterset
;                                      ; Bit 1 - IBM characterset
;                                      ; Bit 2 - CR = CR
;                                      ; Bit 3 - CR = CR-LF
;                                      ; Bit 4 - Store screen and attributes
;                                      ; Bit 5 - Restore screen and attributes
;                                      ; Bit 6 - Hard scroll screen
;                                      ; Bit 7 - Smooth scroll screen
;
start:	ld	de ,tIntro	; Write introduction text
	call	strOut

	xor	a	; See if MemMan is installed
	ld	de,"M"*256+30
	call	extBio
	cp	"M"	; MemMan installed?
	jp	nz,noMemMan	; No => Abort program

	ld	de,"M"*256+62	; See if JANSI.TSR is installed
	ld	hl,tJansiTsr
	call	extBio
	jp	c,noJansiTsr	; No => Abort

	ld	de,"M"*256+63
	ld	a,1
	call	extBio
	ld	a,l
	ld	(ansiState),a

	ld	hl,&h80	; Check for any parameters
	ld	c,(hl)	; Length in BC
	ld	b,0
	inc	c	; Is there anything to work with?
	dec	c
	jp	z,usage	; Show usage if not

	inc	hl	; Start of parameters
	push	hl

unSpace:	ld	a,(hl)	; Remove all leading spaces
	inc	hl
	cp	" "
	jr	z,unSpace

	ld	de,ansiLine
	call	setAnsi	; Set ansi mode (if specified)
	pop	hl

	ld	ix,ansiOption
	call	parseOptIni	; See which options are asked

	ld	a,(ansiOption)
	ld	hl,tAnsiMSX	; MSX characterset
	bit	0,a
	call	nz,printAnsi

	ld	hl,tAnsiIBM	; IBM characterset
	bit	1,a
	call	nz,printAnsi

	ld	hl,tAnsiCR	; CR = CR
	bit	2,a
	call	nz,printAnsi

	ld	hl,tAnsiCrLF	; CR = CR-LF
	bit	3,a
	call	nz,printAnsi

	ld	hl,tAnsiStor	; Store current screen
	bit	4,a
	call	nz,printAnsi

	ld	hl,tAnsiRest	; Restore current screen
	bit	5,a
	call	nz,printAnsi

	ld	hl,tAnsiScroll	; Hard scroll screen
	bit	6,a
	call	nz,printAnsi

	ld	hl,tAnsiSmooth	; Smooth scroll screen
	bit	7,a
	call	nz,printAnsi

	ld	a,"$"
	ld	(de),a
	ld	de,ansiLine
	jp	strOut
;
printAnsi:	push	af
printAnsiLp:	ld	a,(hl)
	inc	hl
	and	a
	jr	z,printAnsiDn
	ld	(de),a
	inc	de
	jr	printAnsiLp
printAnsiDn:	pop	af
	ret
;
tAnsiON:	db	27,"[0.",0
tAnsiOFF:	db	27,"[1.$",0
tAnsiMSX:	db	27,"[2.",0
tAnsiIBM:	db	27,"[3.",0
tAnsiCR:	db	27,"[4;0.",0
tAnsiCrLF:	db	27,"[4;1.",0
tAnsiStor:	db	27,"[5.",0
tAnsiRest:	db	27,"[6.",0
tAnsiScroll:	db	27,"[13;0.",0
tAnsiSmooth:	db	27,"[13;1.",0
;
setAnsi:	call	lowerCase
	cp	"o"
	ret	nz
	call	nextLower
	cp	"n"
	jr	z,setAnsiOn
	cp	"f"
	ret	nz
	call	nextLower
	cp	"f"
	ret	nz
	ld	hl,ansiState
	bit	0,(hl)
	ret	z
	res	1,(hl)
	ld	hl,tAnsiOFF
	jr	printAnsi
;
setAnsiOn:	ld	hl,ansiState
	bit	0,(hl)
	ret	nz
	set	1,(hl)
	ld	hl,tAnsiON
	jr	printAnsi
;
nextLower:	ld	a,(hl)
	inc	hl
	call	lowerCase
	ret
;
lowerCase:	cp	"A"
	ret	c
	cp	"Z"+1
	ret	nc
	or	32
	ret
;
parseOptIni:	ld	a,(ansiState)
	bit	1,a
	jr	nz,parseOption
	bit	0,a
	jr	z,noAnsi

parseOption:	ld	a,"/"
	cpir
	ret	nz
	ret	po

	ld	a,(hl)
	call	lowerCase

	cp	"m"
	jr	nz,parseNoMSX
	set	0,(ix+0)

parseNoMSX:	cp	"i"
	jr	nz,parseNoIBM
	set	1,(ix+0)

parseNoIBM:	cp	"c"
	jr	nz,parseNoCR
	set	2,(ix+0)

parseNoCR:	cp	"l"
	jr	nz,parseNoCrLF
	set	3,(ix+0)

parseNoCrLF:	cp	"s"
	jr	nz,parseNoStor
	set	4,(ix+0)

parseNoStor:	cp	"r"
	jr	nz,parseNoRest
	set	5,(ix+0)

parseNoRest:	cp	"1"
	jr	nz,parseNoSmoo
	set	7,(ix+0)

parseNoSmoo:	cp	"8"
	jr	nz,parseNoHard
	set	6,(ix+0)

parseNoHard:	jr	parseOption
;
noMemMan:	ld	de,tNoMman
	jr	strOut
;
noJansiTsr:	ld	de,tNoJansi
	jr	strOut
;
noAnsi:	ld	de,tNoAnsi
	pop	af	; Remove RET-address
	jr	strOut
;
usage:	ld	de,tUsage
;
strOut:	ld	c,9
	jp	bDos
;
; Texts
;
tJansiTsr:	db	"MST jANSI   "
tNoMman:	db	10,"MemMan not found!$"
tNoJansi:	db	10,"JANSI TSR not found!$"
tNoAnsi:	db	10,"ANSI screen required!$"
tIntro:	db	"JANSI.COM version 1.0 - Written by: BiFi'97",13,10,"$"
tUsage:	db	"Use: JANSI [{ON|OFF}] [/M][/I][/C][/L][/S][/R][/1][/8]"
	db	13,10,"{ON|OFF} - Switch ANSI screen on or off"
	db	13,10,"   /M    - MSX characterset"
	db	13,10,"   /I    - IBM characterset"
	db	13,10,"   /C    - CR=CR only"
	db	13,10,"   /L    - CR=CR-LF"
	db	13,10,"   /S    - Store current screen"
	db	13,10,"   /R    - Restore stored screen"
	db	13,10,"   /1    - Smooth scroll screen"
	db	13,10,"   /8    - Hard scroll screen"
	db	13,10,10,"Everything is optional!$"
;
ansiLine	equ	$
