; ET21 - The ultimate Error Translator version 2
;
; This final version was written by Albert Beevendorp.
; Original code ripped from the pure TSR "MvdK ET 1.0 " - Disassembled!
; Debugged and retranslated by Albert Beevendorp.
; Added errors from Disk-Basic 2.01... Source (c) 1994 by Olympiasoft PD

; Macro definitions
;
tsrName	macro
		db "ABP ErrTrans"	; TSR ID-Name
	endm
;
mMan	macro	@fnc	; Macro for making MemMan
		ld e,@fnc	; function calls
		call 4002h
	endm


;---------------------------------------;
;    Header for the TSR file            ;
;---------------------------------------;
;
	db	"MST TSR",13,10	; TSR identifier
	tsrName		; ID-Name
	db	26	; ^Z
	dw	0003	; Header file versie, MemMan 2.4
	dw	base	; Code base address
	dw	init	; Init address
	dw	kill	; Kill address
	dw	talk	; TsrCall entry
	dw	tsrLen	; Programma code lengte
	dw	iniLen	; Init code lengte


;---------------------------------------;
;    Start of TSR-program code          ;
;---------------------------------------;
;
extBio	equ	&hffca	; EXTBIO hook
;
hook0	equ	&hfedf
hook1	equ	&hff02
hook2	equ	&hff0c
;
info	equ	50	; MemMan function
getMemManEnt	equ	6	; Info subfunction
getTsrID	equ	62
;

;
; TSR Base Address
;
base	equ	$	; First byte of program code
;
kill:	ret		; No destruction code
;
talk:	ret		; No driver routine
;
program:			; Hook-processing program start
			; Insert your own routine here
	ei		; Put the interrupts on again
	and	a	; Set flags
	jr	nz,errBreak	; Hey! A is empty, so SEE YA!
	ex	af,af'	; Keep AF
	ex	de,hl	; Keep HL in DE
	ld	a,(&hf414)	; Read error code
	ld	hl,errList	; Point to top of list
	call	testUnprErr	; Test if it's out of normal range
	jr	c,parseErrTxt	; Time to parse if Carry is set
	ex	de,hl	; Get the shitty back in place
	xor	a	; empty for MemMan
	ex	af,af'
	ret		; See ya!

parseErrTxt:	ld	de,&hf605	; Start of error text buffer
	push	de	; Keep the bufferpointer
parseLp:	ld	a,(hl)	; Get character
	bit	7,a	; Is bit 7 set?
	jr	nz,endOfParse	; Yep! So that's the last character
	ld	(de),a	; Set character into buffer
	inc	hl	; Next char. in errList
	inc	de	; Next char. in buffer
	jr	parseLp	; do it again until bit 7 is set.

endOfParse:	res	7,a	; Reset bit 7 for original character
	ld	(de),a	; Set character into buffer
	inc	de	; Next char in buffer
	xor	a	; Add zero for end of text.
	ld	(de),a
	pop	hl	; Retrieve buffer-pointer for Basic
	ex	af,af'	; emtpy for MemMan (through xor a)
	ret		; See ya!

testUnprErr:	cp	28	; x Errors erbij = current + x
	jr	c,mvToErrTxt
	cp	50
	jr	c,unPrintAble
	cp	222	; RAM-disk foutmelding 
	jr	z,noFreSeg	; Hier hebben we wat aan... 
dos:	cp	76
	jr	nc,unPrintAble
	sub	22	; x Errors erbij = current - x
cont:	scf
mvToErrTxt:	dec	a	; Right error text pointer found (=0)?
	ret	z	; Yep! Bye!
mvLoop:	bit	7,(hl)	; Bit 7 set (end of errortext)?
	inc	hl	; Next char. if not
	jr	z,mvLoop	; Nope? Then test next char.
	jr	mvToErrTxt	; Hey! Go through next error text

unPrintAble:	ld	a,23
	jr	cont

noFreSeg:	ld	a,53	; Aanvullende foutmelding
	jr	cont
;
newPrompt:	ld	a,(&hf665)
	and	a
	jr	nz,endHook
	ld	hl,nedPrompt
outPrompt:	ld	a,(hl)
	and	a
	jr	z,endHook
	call	&ha2
	inc	hl
	jr	outPrompt

endHook:	ex	af,af'
	ld	a,0
	ex	af,af'
	ret
;
errBreak:	ld	hl,nedBreak
	jr	parseErrTxt
;
stkErr:	xor	a
	ld	(&hf665),a
	jr	endHook
;
; Nieuwe prompt tekst (overlapt oude prompt)
;
nedPrompt:	db	27,'A','En nu?',13,10,0
;
nedBreak:	dc	'Afgebroken'
nedInLine:	dc	' in regel '
;
; De vertaalde foutlijst. MSX BASIC version 1 en hoger
;
errList:	dc	'NEXT zonder FOR'
	dc	'Fout in schrijfwijze'
	dc	'RETURN zonder GOSUB'
	dc	'Geen DATA gevonden'
	dc	'Onjuiste functieaanroep'
	dc	'Buiten bereik'
	dc	'Geen vrij geheugen meer'
	dc	'Ongedefinieerd regelnummer'
	dc	'Indexnummer buiten bereik'
	dc	'Hergedimensioneerde lijstvariabele'
	dc	'Deling door nul'
	dc	'Rechtstreeks gebruik verboden'
	dc	'Ongelijke soort'
	dc	'Rijvariabele ruimte verbruikt'
	dc	'Rijvariabele te lang'
	dc	'Rijvariabele te complex'
	dc	'Programmahervatting onmogelijk'
	dc	'Ongedefinieerde gebruikersfunctie'
	dc	'Apparaat I/O fout'
	dc	'Controle fout'
	dc	'Geen RESUME'
	dc	'RESUME zonder ERROR'
	dc	'Onbeschrijfbare fout'
	dc	'Ontbrekende parameter'
	dc	'Regelbuffer buiten bereik'
	dc	'Geen SCC gevonden'	; Aanvulling REPLAY27.BIN
	dc	'Printer niet gereed'	; Aanvulling POL.TSR
	dc	'FIELD buiten bereik'
	dc	'Fout in het Basic vertaalprogramma'
	dc	'Verkeerd bestandsnummer'
	dc	'Bestand niet gevonden'
	dc	'Bestand reeds geopend'
	dc	'Invoer voorbij einde'
	dc	'Verkeerde bestandsnaam'
	dc	'Rechtstreeks bevel in bestand'
	dc	'Alleen achtereenvolgende I/O'
	dc	'Bestand niet geOPENd'
;
; Dit gedeelte gaat alleen op voor DOS 1
;
	dc	'Slechte FAT'
	dc	'Verkeerde bestandssoort'
	dc	'Onbekende drive'
	dc	'Sector buiten bereik'
	dc	'Bestand nog steeds geopend'
	dc	'Bestand bestaat reeds'
	dc	'Disk vol'
	dc	'Te veel bestanden'
	dc	'Disk schrijf beveiligd'
	dc	'Disk I/O fout'
	dc	'Disk niet gereed'
	dc	'Herbenoeming over twee drives'
;
; Dit gedeelte gaat alleen op voor DOS 2
;
	dc	'Bestand schrijf beveiligd'
	dc	'Directory bestaat reeds'
	dc	'Directory niet gevonden'
	dc	'RAM disk bestaat reeds'
	dc	'Geen vrije segmenten meer'	; RAM-disk foutmelding
;
tsrLen	equ	$-base	; Length of TSR programcode


;---------------------------------------;
;     Init-code                         ;
;---------------------------------------;
;
init:	ld	hl,tTsrName	; Pointer to TSR name-string
	mMan	getTsrID	; See if this TSR already exists
	jr	nc,initDouble	; Yes, => Double installed error

	ld	hl,tTsrEarlier
	mMan	getTsrID
	ld	de,tEarlier
	jr	nc,iniEarlier

	mMan	31	; Test DOS2 mapper support activity
	bit	0,a	; Here it will stand
	jr	nz,intro	; DOS2
	ld	a,72	; When not DOS2... Ignore DOS2 errors
	ld	(dos + 1),a	; DOS1

intro:	ld	de,tIntro
	ld	a,2	; Flags in A, no messages
	ret		; Init ready, return to TsrLoad

initDouble:	ld	de,tDouble	; DE=Text pointer
iniEarlier:	ld	a,3	; Flags for TL: Print text & Abort
	ret		; Return to TsrLoad
;
tTsrName:	tsrName		; Macro for tsr-name string
tTsrEarlier:	db	'MvdK ET 1.0 '
;
tIntro:	tsrName
	db	' - versie 2.12',13,10,10

	db	'Deze TSR vertaalt alle Basic, Disk-Basic 1'
	db	' en Disk-Basic 2',13,10
	db	'foutmeldingen van Engels naar het Nederlands.'
	db	13,10,10,'Deze nieuwe versie door A.Beevendorp -'
	db	' Olympiasoft PD 1994-1997',13,10,10,0
;
tDouble:			; Error text, 0-terminated
	db	7,'Deze TSR is reeds actief!',13,10,10,0
tEarlier:	db	7,'Een eerdere versie is reeds actief!',13,10,10,0
;
iniLen	equ	$-init	; Length of init-code
;
;---------------------------------------;
;    Hook Table                         ;
;---------------------------------------;
;
	TSRHOOKS
;
hooks:	dw	hokTabLen	; Length of HokTab
	dw	hook0
	dw	stkErr
	dw	hook1
	dw	program
	dw	hook2
	dw	newPrompt
;
hokTabLen	equ	$-hooks	; Length of hook-table
;
;---------------------------------------;
;
	end	 ; ET21.TSR
