; TSRFRAME - MST TSR
;
; Tsr frame file for GEN80 or M80 assemblers
;

; Macro definitions
;
tsrName	macro
	db	"ABP DiskStop"	; TSR ID-Name
	endm
;
mMan	macro	@fnc	; Macro for making MemMan
	ld	e,@fnc	; function calls
	call	&h4002
	endm


;---------------------------------------;
;    Header for the TSR file            ;
;---------------------------------------;
;
	db	"MST TSR",13,10	; TSR identifier
	tsrName		; ID-Name
	db	26	; ^Z
	dw	0003	; Header file versie, MemMan 2.4
	dw	base	; Code base address
	dw	init	; Init address
	dw	kill	; Kill address
	dw	talk	; TsrCall entry
	dw	tsrLen	; Programma code lengte
	dw	iniLen	; Init code lengte


;---------------------------------------;
;    Start of TSR-program code          ;
;---------------------------------------;
;
extBio	equ	&hffca	; EXTBIO hook
;
hook1	equ	&hfd9f	; Hook to be bend by this TSR
hook2	equ	&hfe0d	; Another hook for this one
hook3	equ	&hfe1c	; Ai. It's getting busy now
;
info	equ	50	; MemMan function
getMemManEnt	equ	6	; Info subfunction
getTsrID	equ	62
;
valTyp	equ	&hf663
dac	equ	&hf7f6
onToken	equ	&h95
offToken	equ	&heb
;
; TSR Base Address
;
base	equ	$	; First byte of program code
;
kill:	ret		; No destruction routine
;
program:	push	af	; Hook-processing program start
	push	bc	; Insert your own routine here
	ld	a,(dsFlag)	; Read flags
	bit	0,a	; Bit 0 low?
	jr	z,dsDone	; No? then the DS is on
	ld	a,(0f1c1h)	; Read motor status counter
	ld	b,a	; Keep it 4 a while
	ld	a,(curDSc)	; Get the current DiskStop timer
	cp	b	; Are they the same?
	jr	nz,dsDone	; No. Back to tsrManager
	ld	a,1	; Yes. Bring it down
	ld	(&hf1c1),a
dsDone:	pop	bc	; Get those regs back
	pop	af

endProgram:	ex	af,af'	; Save AF
	ld	a,0	; Reset flags for TsrManager
	ex	af,af'	; Restore AF, flags to A'
	ret		; Return to TsrManager
;
curDSc:	db	&h78	; current DiskStop counter (< 128)
dsFlag:	db	1	; current DS flag status (1 = On)
;
talk:	or	a	; Function 0
	jr	z,chgDSm	;	Change the DiskStop modus
	dec	a	; Function 1
	jr	z,reqDS	;	Request DiskStop
	dec	a	; Function 2
	jr	z,getDSc	;	Get the DiskStop timer
	dec	a	; Function 3
	jr	z,setDSc	;	Set the DiskStop timer
	ret		; End of driver routine
;
chgDSm:	ld	a,(dsFlag)	; Get the current situation
	xor	1	; Swap bit 0
	ld	(dsFlag),a	; Set new situation
	ret		; All done!
;
reqDS:	ld	a,1	; Prepare to stop!
	ld	(&hf1c1),a	; And quit the drive
	ret		; All done!
;
getDSc:	ld	a,(curDSc)	; Get it
	ret		; All done!
;
setDSc:	ld	a,b	; Stands in B
	or	a	; Is it 0?
	ret	z	; It seems that way.
	bit	7,a	; Test bit 7
	ret	nz	; Return when it's high (> 127)
	ld	(curDSc),a	; Set new counter
	ret		; All done!
;
tHelp:	tsrName
	db	13,10,' CMD DS',9,9,'Request DiskStop'
	db	13,10,' CMD DS ON',9,'Activate automatic DiskStop'
	db	13,10,' CMD DS OFF',9,'De-activate automatic DiskStop'
	db	13,10,' CMD DSC [<x>]',9,'Set or reset DiskStop counter'
	db	13,10,' LN=ATTR$ DSC',9,'Get the DiskStop counter'
	db	13,10,' ST=ATTR$ DSM',9,'Get the auto-DiskStop status'
	db	13,10,0	; That'z all 4 now!
;
testHelp:	cp	'H'	; It it an 'H'?
	ret	nz	; That'z no 'H'
	inc	hl	; It is... Test nxt 1
	ld	a,(hl)	; Read the char
	cp	'E'	; Is it an 'E'?
	ret	nz	; That'z no 'E'
	inc	hl	; It is... Test nxt 1
	ld	a,(hl)	; Read the char
	cp	'L'	; Is it an 'L'?
	ret	nz	; That'z no 'L'
	inc	hl	; It is... Test nxt 1
	ld	a,(hl)	; Read the char
	cp	'P'	; Is it an 'P'?
	ret	nz	; That'z no 'P'
			; It is... Write the HelpText
	ld	hl,tHelp	; Point 2 the HelpText
WrtLp:	ld	a,(hl)	; Get the 1st char
	or	a	; Is it zero?
	jr	z,doneHelp	; Yep! Then the HelpText is printed
	rst	&h18	; Strezz it on screen 'coz it was
	inc	hl	; Point 2 nxt 1
	jr	WrtLp	; Continuing the shit
doneHelp:	pop	hl	; Get the ret-address for nxt CMD's

nxtCmd:	pop	hl	; Get the saved regs.
	pop	af
	jp	endProgram	; End finish the job.
;
; CMD work
;
goCmd:	push	af
	push	hl
	call	testHelp
	cp	'D'
	jr	nz,nxtCmd
	call	chrGtR
	cp	'S'
	jr	nz,nxtCmd
	call	chrGtR
	jr	z,cmdReqDS
	cp	onToken
	jr	z,onToFlag
	cp	offToken
	jr	z,offToFlag
	cp	'C'
	jr	nz,nxtCmd
	call	chrGtR
	jr	z,setDef
	call	evalInt
	ld	b,e
	call	setDSc

quitCmd:	pop	af
	ex	(sp),hl
	pop	hl

quitAttr:	pop	de	; Get ret-addr
	pop	af	; Kill Basic-error
	push	de	; Set ret-addr
	ld	a,1	; quit the shitty cmd
	ex	af,af'	; In A'
	ret		; Bek 2 TSR-man

onToFlag:	ld	a,1
	jr	toFlag
offToFlag:	ld	a,0
toFlag:	ld	(dsFlag),a
	call	chrGtR
	jr	quitCmd

setDef:	ld	b,&h78
	call	setDSc
	jr	quitCmd

cmdReqDS:	call	reqDS
	jr	quitCmd
;
; ATTR$ work
;
goAttr:	push	af
	push	hl
	call	chrGtR
	cp	'D'
	jr	nz,nxtCmd
	call	chrGtR
	cp	'S'
	jr	nz,nxtCmd
	call	chrGtR
	cp	'C'
	jr	z,cntAttr
	cp	'M'
	jr	nz,nxtCmd
	jr	flgAttr
cntAttr:	pop	af
	ex	(sp),hl
	ld	a,(curDSc)
	ld	l,a
	ld	h,0
setFlg:	ld	(dac + 2),hl
	ld	hl,valTyp
	ld	(hl),2
HLtoDAC:	pop	hl
	call	chrGtR
	jr	quitAttr

flgAttr:	pop	af
	ex	(sp),hl
	ld	a,(dsFlag)	; Convert flag into boolean
	ld	hl,-1
	bit	0,a
	jr	nz,setFlg
	inc	hl
	jr	z,setFlg

evalInt:	ld	ix,&h4c64
	call	basicCall
	ld	de,(dac + 2)
	ld	a,(valTyp)
	cp	2
	ret	z
	push	hl
	ld	ix,&h2f8a
	call	basicCall
	ld	de,(dac + 2)
	pop	hl
	ret

chrGtR:	ld	ix,&h4666
basicCall:	call	0
	ei
	ret

tsrLen	equ	$-base	; Length of TSR programcode


;---------------------------------------;
;     Init-code                         ;
;---------------------------------------;
;
init:	ld	hl,tTsrName	; Pointer to TSR name-string
	mMan	getTsrID	; See if this TSR already exists
	jr	nc,initDouble	; Yes, => Double installed error

	ld	b,4
	mMan	info
	ld	(basicCall + 1),hl

	ld	de,tIntro	; Introtext pointer
	ld	a,2	; Flags in A. Print messie
	ret		; Init ready, return to TsrLoad

initDouble:	ld	de,tDouble	; DE=Text pointer
	ld	a,3	; Flags for TL: Print text & Abort
	ret		; Return to TsrLoad

tIntro:	db	'DiskStop TSR V#2.01',13,10
	db	'By A.Beevendorp',13,10,10
	db	'Counter is set on 120 interrupts before DiskStop.',13,10
	db	'DiskStop is now on...',13,10,10,0
;
tTsrName:	tsrName		; Macro for tsr-name string
;
tDouble:			; Error text, 0-terminated
	db	'This TSR is already installed',13,10,10,0
;
iniLen	equ	$-init	; Length of init-code
;
;---------------------------------------;
;    Hook Table                         ;
;---------------------------------------;
;
hooks:	dw	hokTabLen	; Length of HokTab
	dw	hook1
	dw	program
	dw	hook2
	dw	goCmd
	dw	hook3
	dw	goAttr
;
hokTabLen	equ	$-hooks	; Length of hook-table
;
;---------------------------------------;
;
	end		; ABP DiskStop
;
