	org	&hc000
;
; Sum hendy EQU's
;
rstPlt	equ	&h145
subRom	equ	&h15f
nSetWrt	equ	&h171
nRdVrm	equ	&h174
basErr	equ	&h406f
scrMod	equ	&hfcaf
;
; Conversieprogramma van SCREEN 8 (max. 16 kleuren) naar SCREEN 5
;
; Written by: BiFi'98
;
start:	ld	hl,convert
	ld	(&hf39a),hl
	ld	hl,show
	ld	(&hf39c),hl
	ret
;
convert:	ld	a,(scrMod)	; Check for SCREEN 8
	cp	8
	ld	e,5	; No SCREEN 8... "Illegal function call"
	jp	nz,basErr

	xor	a
	ld	(storeColor),a	; First position for new color storage
	ld	(nibble),a	; Nibble (0 = nnnn0000, 1 = 0000nnnn)
	ld	b,16
	ld	hl,colorTable	; Clear storage color table
colClrLoop:	ld	(hl),0
	inc	hl
	djnz	colClrLoop
	call	clearBank

	ld	a,2
	out	(&hfe),a
	ld	bc,&hd400	; Picture size
	ld	ix,&h8000
	ld	hl,0
readColor:	call	nRdVrm
	inc	hl
	call	findColor	; Find SCREEN 5 color code

	ld	a,(storeColor)
	cp	17
	jr	nc,cnvError

	ld	a,(nibble)
	and	1
	ld	a,d	; D = SCREEN 5 color code
	ld	e,(ix+0)
	jr	z,highNibble
	or	e
	ld	(ix+0),a
	inc	ix
	push	ix
	pop	de
	ld	a,d
	cp	192
	jr	c,nextColor
	ld	d,128
	push	de
	pop	ix
	ld	a,3
	out	(&hfe),a
nextColor:	ld	a,(nibble)
	xor	1
	ld	(nibble),a
	dec	bc
	ld	a,b
	or	c
	jr	nz,readColor

	ld	b,16
	ld	hl,colorTable
	ld	ix,&hb680
makeRGB:	ld	a,(hl)
	and	224
	rlca
	rlca
	rlca
	ld	(ix+1),a
	ld	a,(hl)
	and	28
	rlca
	rlca
	ld	c,a
	ld	a,(hl)
	and	3
	rlca
	or	c
	ld	(ix+0),a	; Red & Blue
	inc	hl
	inc	ix
	inc	ix
	djnz	makeRGB
	ld	a,1
	out	(&hfe),a
	ret
;
cnvError:	ld	a,1
	out	(&hfe),a
	ld	e,6	; Too many colors... "Overflow"
	jp	basErr

highNibble:	rlca
	rlca
	rlca
	rlca
	ld	(ix+0),a
	jr	nextColor
;
findColor:	push	bc,hl
	ld	d,a
	ld	a,(storeColor)
	and	a
	ld	a,d
	jr	z,addColor
getColor:	ld	b,17
	ld	d,0
	ld	hl,colorTable
fndColLoop:	cp	(hl)	; Check color
	jr	z,foundColor	; Found!
	inc	d	; Next color
	inc	hl
	djnz	fndColLoop
addColor:	push	af
	ld	hl,colorTable
	ld	a,(storeColor)
	ld	c,a
	ld	b,0
	add	hl,bc
	inc	a
	ld	(storeColor),a
	pop	af
	ld	(hl),a
	jr	getColor
foundColor:	pop	hl,bc
	ret
;
; Show converted
;
show:	ld	a,(scrMod)	; Check SCREEN 5
	cp	5
	ld	e,5
	jp	nz,basErr

	ld	a,2
	out	(&hfe),a
	ld	de,&h8000
	ld	hl,0	; Write to page 0
	call	copy

	ld	a,3
	out	(&hfe),a
	ld	de,&h8000
	ld	hl,&h4000
	call	copy

	ld	a,1
	out	(&hfe),a
	ld	ix,rstPlt
	jp	subRom
;
; Clear both user banks
;
clearBank:	ld	bc,514
clrBnkLoop:	push	bc
	ld	a,c
	out	(&hfe),a
	ld	bc,16383
	ld	de,&h8001
	ld	hl,&h8000
	ld	(hl),0
	ldir
	pop	bc
	inc	bc
	djnz	clrBnkLoop
	ret
;
; Spitt converted data to VRAM
;
copy:	call	nSetWrt
	ex	de,hl
	ld	b,64
copyLoop:	push	bc
	ld	bc,&h98
writeLoop:	otir
	pop	bc
	djnz	copyLoop
	ret
;
storeColor:	db	0
nibble:	db	0
colorTable:	ds	16,0
