	org	&hc000
;
; Some Handy EQU's
;
ldirMV	equ	&h59
bigFil	equ	&h16b
nSetRd	equ	&h16e
nSetWr	equ	&h171
scrMod:	equ	&hfcaf
;
; SCREEN5 to SCREEN8 convertor - High speed version
;
; Written by: BiFi'96 of T.N.I. - Compass 'conversion' in 1999
;
conVert:	ld	a,(scrMod)	; Check SCREEN mode
	cp	5	; SCREEN 5?
	ret	nz	; Return if not

	ld	hl,&h7680	; Move palette-values to RAM
	ld	de,palette
	ld	bc,32
	call	ldirMV

	in	a,(&hfe)	; Keep current mapper block
	push	af

	ld	hl,0	; Start of picture data
	call	nSetRd
	ld	b,4	; Number of pages for SCREEN8
	ld	a,4	; Start page in RAM for conversion

newPage:	push	af,bc	; Set new page
	ld	hl,&h8000	; Start of page 2 (mapper block)
	out	(&hfe),a	; Set RAM-page
	ld	a,(6)
	ld	c,a

nextColor:	in	a,(c)
	push	af	; Keep color for low nibble
	and	240
	rrca
	rrca
	rrca
	rrca
	call	getPalette	; Convert high nibble to SCREEN8 color
	ld	(hl),a
	inc	hl
	pop	af	; Restore color
	and	15
	call	getPalette	; Convert low nibble to SCREEN8 color
	ld	(hl),a
	inc	hl
	ld	a,h
	cp	192	; In page 3?
	jr	c,nextColor	; Next color(s) if not

	pop	bc,af
	inc	a
	djnz	newPage

	pop	af
	out	(&hfe),a
	ret		;                ; End of conversion
;
show:	ld	a,(scrMod)	; Check SCREEN mode
	cp	8	; SCREEN 8?
	ret	nz	; Return if not

	in	a,(&hfe)	; Keep current mapper block
	push	af

	ld	hl,0	; Start for picture data
	call	nSetWr
	ld	b,4
	ld	a,4

nextPage:	push	af,bc
	ld	hl,&h8000
	out	(&hfe),a
	ld	b,&h40	; 64 times

writeBlock:	push	bc
	ld	b,0	; 256 times
	ld	a,(7)
	ld	c,a
	otir		;                ; Output to VDP
	pop	bc
	djnz	writeBlock

	pop	bc,af
	inc	a
	djnz	nextPage

	ld	hl,&hd400	; Fill all BUT the picture with zero's
	ld	bc,&h2c00
	xor	a
	CALL	bigFil

	pop	af
	out	(&hfe),a
	ret		;                ; End of showing
;
getPalette:	push	bc
	ld	de,palette
	add	a,a
	add	a,e
	ld	e,a
	ld	a,(de)
	ld	b,a
	inc	de
	ld	a,(de)
	and	7	; Green
	rrca
	rrca
	rrca
	ld	c,a
	ld	a,b
	and	112	; Red
	rrca
	rrca
	or	c
	ld	c,a
	ld	a,b
	and	7	; Blue
	srl	a
	or	c
	pop	bc
	ret
;
palette:	ds	32,0
