	org	&hc000

rdSlt	equ	&hc
wrtSlt	equ	&h14
getCpu	equ	&h183
;
; Diverse S-RAMs gebruiken (van alles -voorlopig- 1)
;
; (c) 1995/1997 The New Image (FM-PAC S-RAM wordt in spellen gebruikt)
; Written by: Albert Beevendorp (BiFi'97) Sony HBI-55 Bugfixed!
;

; Interface: Sprongen naar S-RAM schakelroutines
;
	jp	setPac	; FM-PAC S-RAM inschakelen
	jp	resetPac	; FM-PAC S-RAM uitschakelen
	jp	setXanadu	; Xanadu S-RAM inschakelen
	jp	resetXanadu	; Xanadu S-RAM uitschakelen
	jp	setTurboR	; Turbo-R S-RAM inschakelen
	jp	resetTurboR	; Turbo-R S-RAM uitschakelen
;
; Interface: Sprongen naar S-RAM accessroutines
;
	jp	readPac	; FM-PAC S-RAM data read
	jp	writePac	; FM-PAC S-RAM data write
	jp	readXanadu	; Xanadu S-RAM data read
	jp	writeXanadu	; Xanadu S-RAM data write
	jp	readTurboR	; Turbo-R S-RAM data read
	jp	writeTurboR	; Turbo-R S-RAM data write
	jp	readHbi55	; Sony HBI-55 S-RAM data read
	jp	writeHbi55	; Sony HBI-55 S-RAM data write
;
; Interface: Sprongen naar S-RAM detectieroutines
;
	jp	findPac	; FM-PAC S-RAM detect
	jp	findXanadu	; Xanadu S-RAM detect
	jp	findTurboR	; Turbo-R S-RAM detect
	jp	findHbi55	; Sony HBI-55 S-RAM detect
;
; Schakel S-RAM van FM-PAC in gevonden slot op page 1-Low only
;
; Door: BiFi'97
;
setPac:	ld	de,&h694d	; Plaats "Mi" op &H5FFE
wrtToPac:	ld	a,(pacSlot)
	ld	hl,detectFlags
	bit	0,(hl)
	ret	z	; deze S-RAM was niet gevonden
	ld	hl,&h5ffe
	push	af
	push	de
	push	hl
	call	wrtSlt
	pop	hl
	pop	de
	pop	af
	ld	e,d	; Tweede byte interslot-POKEn
	inc	hl
	call	wrtSlt
	ei		; Interrupt weer aanzetten
	ret
;
; Schakel S-RAM van Xanadu in gevonden slot op page 2-Low
;
; Door: BiFi'97
;
setXanadu:	ld	e,&h20	; Plaats 32 op &H7000 voor page 2-Low
wrtToXanadu:	ld	a,(xanaduSlot)	; Plaats 32 op &H7800 voor page 2-High
	ld	hl,detectFlags
	bit	1,(hl)
	ret	z	; deze S-RAM was niet gevonden
	ld	hl,&h7000
	call	wrtSlt
	ei		; Interrupt weer aanzetten
	ret
;
; Schakel S-RAM in Turbo-R blok in slot 3-3 op page 1-Low only
;
; Door: BiFi'97 - Block in A (FS-A1ST => 0 of 1, FS-A1GT => 0 t/m 3)
;
setTurboR:	or	128	; Blocknummer in A
	ld	e,a
	ld	hl,detectFlags
	bit	2,(hl)
	ret	z	; No Turbo R
wrtToTurboR:	ld	a,&h8f	; Plaats A op &H6800
	ld	hl,&h6800
	call	wrtSlt
	ei		; Interrupts weer aanzetten
	ret
;
; Deze routines schakelen de diverse S-RAM's weer uit
;
; Door: BiFi'97
;
resetPac:	ld	de,0	; Beide nullen naar dezelfde adressen
	jr	wrtToPac
;
resetXanadu:	ld	e,0	; Waarde 0 naar hetzelfde adres
	jr	wrtToXanadu
;
resetTurboR:	ld	e,&hc	; Waarde 12 naar hetzelfde adres
	jr	wrtToTurboR
;
; Deze routines lezen uit de diverse S-RAM's
;
; Door: BiFi'97
;
readPac:	push	hl	; Keep address to read
	call	setPac
	pop	hl	; Restore address (offset)
	ret	z	; No FM-PAC detected
	res	7,h	; Start of page 1
	set	6,h
	ld	a,(pacSlot)
	call	rdSlt
	push	af	; Keep data read
	call	resetPac
	pop	af	; Restore data read
	ret
;
readXanadu:	push	hl	; Keep address to read
	call	setXanadu
	pop	hl	; Restore address (offset)
	ret	z	; No Xanadu detected
	set	7,h	; Start of page 2
	res	6,h
	ld	a,(xanaduSlot)
	call	rdSlt
	push	af	; Keep data read
	call	resetXanadu
	pop	af	; Restore data read
	ret
;
readTurboR:	ld	a,d	; Get block number
	and	1	; bit 0 only
	push	hl	; Keep address to read
	call	setTurboR
	pop	hl	; Restore address (offset)
	res	7,h	; Start of page 1
	set	6,h
	ld	a,&h8f
	call	rdSlt
	push	af	; Keep data read
	call	resetTurboR
	pop	af	; Restore data read
	ret
;
readHbi55:	ld	a,(detectFlags)
	bit	3,a
	ret	z	; This S-RAM was not found
	ld	a,&h89	; Put controler in Read mode
	out	(&hb3),a
	call	ioDelay
	ld	a,l	; Write Address
	out	(&hb0),a
	call	ioDelay
	ld	a,h	; Write Address and S-RAM Read mode
	and	15
	or	&hc0
	out	(&hb1),a
	call	ioDelay
	in	a,(&hb2)	; Read data
	jp	ioDelay
;
; Deze routines schrijven naar de diverse S-RAM's
;
; Door: BiFi'97
;
writePac:	push	hl	; Keep address to write
	push	de	; Keep data to write
	call	setPac
	pop	de	; Restore data
	pop	hl	; Restore address (offset)
	ret	z	; No FM-PAC detected
	res	7,h	; Start of page 1
	set	6,h
	ld	a,(pacSlot)
	call	wrtSlt
	jp	resetPac
;
writeXanadu:	push	hl	; Keep address to write
	push	de	; Keep data to write
	call	setXanadu
	pop	de	; Restore data
	pop	hl	; Restore address (offset)
	ret	z	; No Xanadu detected
	set	7,h	; Start of page 2
	res	6,h
	ld	a,(xanaduSlot)
	call	wrtSlt
	jp	resetPac
;
writeTurboR:	ld	a,d	; Get block number
	and	1	; bit 0 only
	push	hl	; Keep address to write
	push	de	; Keep data to write
	call	setTurboR
	pop	de	; Restore data
	pop	hl	; Restore address (offset)
	res	7,h	; Start of page 1
	set	6,h
	ld	a,&h8f
	call	wrtSlt
	jp	resetTurboR
;
writeHbi55:	ld	a,(detectFlags)
	bit	3,a
	ret	z	; This S-RAM was not found
	ld	a,&h80	; Put controler in Write mode
	out	(&hb3),a	; this is for the controler
	call	ioDelay
	ld	a,l	; Write address
	out	(&hb0),a
	call	ioDelay
	ld	a,e	; Write data
	out	(&hb2),a
	call	ioDelay
	ld	a,h	; Write address and S-RAM Write mode
	and	15
	or	&h40
	out	(&hb1),a
	call	ioDelay
	ld	a,&h80	; Complete write action
	out	(&hb1),a
	jp	ioDelay
;
; Deze routines kunnen de diverse S-RAM's detecteren
;
; Door: BiFi'97
;
findPac:	ld	hl,detectFlags
	res	0,(hl)
	ld	hl,pacSlot
	ld	(hl),0
	ld	b,4	; Number of primairy slots
	xor	a	; Start from slot 0
	ld	hl,&hfcc1
pacPrimLoop:	push	bc
	push	af
	push	hl
	call	pacSubTest	; Secundairy slot test
	pop	hl
	pop	af
	pop	bc
	inc	a
	inc	hl
	djnz	pacPrimLoop
	ei
	ret

pacSubTest:	or	(hl)
	jp	p,pacDoTest
	ld	b,4	; Number of secundairy slots
pacSubLoop:	push	bc
	push	af
	call	pacDoTest
	pop	af
	add	a,4	; Next sub-slot
	pop	bc
	djnz	pacSubLoop
	ret

pacDoTest:	ld	hl,&hf342	; Test RAM-slot
	cp	(hl)
	ret	z	; Return when it is
	ld	(tempSlot),a
	di
	ld	(tempStack),sp
	ld	sp,&hfc3f
	call	pacTest	; Test FM-PAC
	ld	sp,(tempStack)
	ret	nz
	ld	a,(tempSlot)
	ld	(pacSlot),a
	ld	hl,detectFlags	; Set detect-flag for FM-PAC S-RAM
	set	0,(hl)
	ret

pacTest:	ld	b,4
	ld	hl,&h4018
	ld	de,pacTestText
pacTestLoop:	push	bc
	push	de
	ld	a,(tempSlot)	; Read address
	call	rdSlt
	pop	de
	pop	bc
	ex	de,hl	; (HL) = (DE) ?
	cp	(hl)
	ex	de,hl
	ret	nz	; Return if not found (next slot)
	inc	de
	inc	hl
	djnz	pacTestLoop
	ret

pacTestText:	db	"PAC2"
;
tempSlot:	db	0
tempStack:	dw	0
;
findXanadu:	ld	hl,detectFlags
	res	1,(hl)
	ld	hl,xanaduSlot
	ld	(hl),0
	ld	b,4	; Number of primairy slots
	xor	a	; Start from slot 0
	ld	hl,&hfcc1
xanPrimLoop:	push	bc
	push	af
	push	hl
	call	xanSubTest	; Secundairy slot test
	pop	hl
	pop	af
	pop	bc
	inc	a
	inc	hl
	djnz	xanPrimLoop
	ei
	ret

xanSubTest:	or	(hl)
	jp	p,xanDoTest
	ld	b,4	; Number of secundairy slots 
xanSubLoop:	push	bc
	push	af
	call	xanDoTest
	pop	af
	add	a,4	; Next sub-slot 
	pop	bc
	djnz	xanSubLoop
	ret

xanDoTest:	ld	hl,&hf342	; Test RAM-slot
	cp	(hl)
	ret	z	; Return when it is 
	ld	(tempSlot),a
	di
	ld	(tempStack),sp
	ld	sp,&hfc3f
	call	xanTest	; Test Xanadu
	ld	sp,(tempStack)
	ret	c
	ld	a,(tempSlot)
	ld	(xanaduSlot),a
	ld	hl,detectFlags	; Set detect-flag for Xanadu S-RAM
	set	1,(hl)
	ret
;
xanTestRd:	ld	a,(tempSlot)
	jp	rdSlt

xanTestWrt:	ld	a,(tempSlot)
	jp	wrtSlt
;
xanTest:	ld	hl,&h7000
	ld	e,&h20	; Open possible S-RAM
	push	de
	call	xanTestWrt
	call	xanTestRd
	pop	de
	cp	e
	jr	z,setCarry	; RAM if equal!
	ld	hl,&h8000
	call	xanTestRd
	ld	d,a	; Keep value read
	ld	e,&h55
	push	de
	call	xanTestWrt
	call	xanTestRd
	pop	de
	cp	e
	jr	nz,setCarry
	ld	e,&haa
	push	de
	call	xanTestWrt
	call	xanTestRd
	pop	de
	cp	e
	jr	nz,setCarry
	ld	e,d
	call	xanTestWrt
	scf
	ccf		; Non-Carry when successfull
	ret
setCarry:	scf		; Carry when not found
	ret
;
findTurboR:	ld	hl,detectFlags
	res	2,(hl)
	ld	a,(&h2d)
	cp	3
	ret	c	; That's a fast check :-)
	ld	e,128
	ld	hl,&h6800
	ld	a,&h8f
	ld	(tempSlot),a
	push	de
	call	xanTestWrt
	call	xanTestRd
	pop	de
	cp	e
	ret	z	; RAM in slot 3-3 (Sony)
	ld	hl,&h4000
	call	xanTestRd
	ld	d,a
	ld	e,&h55
	push	de
	call	xanTestWrt
	call	xanTestRd
	pop	de
	cp	e
	ret	nz
	ld	e,&haa
	push	de
	call	xanTestWrt
	call	xanTestRd
	pop	de
	cp	e
	ret	nz
	ld	e,d
	call	xanTestWrt
	ld	hl,detectFlags
	set	2,(hl)
	ret
;
findHbi55:	ld	hl,detectFlags
	res	3,(hl)
	in	a,(&hb3)	; Check for HBI-55 S-RAM cartridge
	inc	a
	ret	z	; -1 + 1 = 0? Then not found
	set	3,(hl)
	ret
;
detectFlags:	db	0
pacSlot:	db	0
xanaduSlot:	db	0
;
; Delay for sequential IO-access in R-800 mode
;
ioDelay:	push	af
	ld	a,(&h2d)
	cp	3
	jr	c,ioDelayEnd
	call	getCpu
	and	a
	jr	z,ioDelayEnd
	ld	b,0
ioDelayLoop:	djnz	ioDelayLoop
ioDelayEnd:	pop	af
	ret
