	org	&hc000
;
; Percentage calculation
; In:         DE =>        Maximum value
;             HL =>        Current value
; Out:        AF =>   A -> Percentage
;
clcPerc:	ld	(maxValue),de
	ld	de,0
	ld	(maxValue+2),de
	call	muluw100	; Do CurValue * 100
	ld	(curValue),hl
	ld	(curValue+2),de
	call	divide32	; Do CurValue * 100 / MaxValue
	ld	a,(curValue)	; Percentage in CurValue
	exx
	push	de,hl	; Round Percentage accordingly
	exx
	pop	de,hl
	srl	h
	rr	l
	ex	de,hl
	sbc	hl,de	; Check whether HL > 0 (two's)
	ret	c
	inc	a
	ret
;
curValue:	dw	0,0
maxValue:	dw	0,0
;
; DEHL = HL * 100
;
; Written by: BiFi'98
;
; Uses: BC
;
muluw100:	ld	de,0
	ld	b,2
mul10Loop:	add	hl,hl	; DEHL = DEHL * 2
	call	addDE
	push	bc,de,hl
	adc	hl,hl	; DEHL = DEHL * 4
	call	addDE
	adc	hl,hl	; DEHL = DEHL * 8
	call	addDE
	pop	bc
	adc	hl,bc	; DEHL = DEHL * 10
	ex	de,hl
	pop	bc
	adc	hl,bc
	ex	de,hl
	pop	bc
	djnz	mul10Loop
	ret

addDE:	ex	de,hl
	adc	hl,hl
	ex	de,hl
	ret
;
; 32-bit division
;
divide32:	ld	hl,0
	ld	iy,(curValue)
	ld	de,(maxValue+2)
	and	a
	sbc	hl,hl
	ld	b,32
	exx
	ld	bc,(curValue+2)
	ld	de,(maxValue)
	sbc	hl,hl
	exx

div32Loop:	exx
	add	iy,iy
	rl	c
	rl	b
	adc	hl,hl
	exx
	adc	hl,hl
	exx
	sbc	hl,de
	exx
	sbc	hl,de
	inc	iy
	jr	nc,div32End
	dec	iy
	exx
	add	hl,de
	exx
	adc	hl,de
div32End:	djnz	div32Loop

	exx
	ld	(curValue+2),bc
	ld	(maxValue),hl
	exx
	ld	(maxValue+2),hl
	ld	(curValue),iy
	ret
