	org	&hc000
;
; Deel HL door DE (HL = HL div DE, rest DE) - Word versie!
;
; Bronvermelding: Deze routine is gebasseerd op de 16-bits deel-
; routine uit het boek 'Z80 Macinetaal Subroutines' van Lance A.
; Leventhal en Winthrop Saville.
;
; In : HL = Getal
;      DE = Deeltal
;
; Out: HL = Uitkomst
;      DE = Rest-waarde
;      Carry reset bij correcte berekening
;
; Chg: A, C
;
divWord:	ld	a,e	; Test op deling door nul
	or	d
	jr	nz,doDivide	; Ga door als deeltal <> 0
	ld	hl,0
	ld	de,0
	scf		; Zet Carry om fout aan te geven
	ret

doDivide:	ld	c,l	; AC = HL
	ld	a,h
	ld	hl,0	; HL = Rest-waarde
	ld	b,16	; 16-bit deling
	or	a	; Start met carry reset

divLoop:	rl	c	; AC = AC * 2
	rla		; (zet Carry naar bit 0)
	rl	l	; HL = HL * 2
	rl	h	; (zet Carry weer op nul (HL = 0))

	push	hl
	sbc	hl,de
	ccf		; Carry gezet indien Ok

	jr	c,endDiv	; Spring als Rest-waarde >= Getal
	ex	(sp),hl	; Herstel of Rest-waarde

endDiv:	inc	sp	; Haal Rest-waarde van de Stack
	inc	sp
	djnz	divLoop	; Herhalen voor alle bits

; Laatste Carry-bit doorschuiven naar Deeltal

	ex	de,hl	; DE = Rest-waarde
	rl	c	; Carry naar C
	ld	l,c	; HL = AC
	rla
	ld	h,a
	or	a	; Reset Carry (geldig resultaat)
	ret
