;
; 32-bit division - unsigned version (DEHL = DEHL / IXIY rest IXIY)
; In:         DE =>        MSW deeltal
;             HL =>        LSW deeltal
;             IX =>        MSW deler
;             IY =>        LSW deler
; Out:        DE =>        MSW result
;             HL =>        LSW result
;             IX =>        MSW rest
;             IY =>        LSW rest
; Uses:
;
divide32:	push	iy,de,ix,hl
	pop	iy,de
	and	a
	sbc	hl,hl
	ld	b,32
	exx
	pop	bc,de
	sbc	hl,hl
	exx

div32Loop:	exx
	add	iy,iy
	rl	c
	rl	b
	adc	hl,hl
	exx
	adc	hl,hl
	exx
	sbc	hl,de
	exx
	sbc	hl,de
	inc	iy
	jr	nc,div32End
	dec	iy
	exx
	add	hl,de
	exx
	adc	hl,de
div32End:	djnz	div32Loop

	exx
	push	bc,hl
	exx
	push	hl,iy
	pop	hl,ix,iy,de
	ret
