	org	&h100
;
; IDE Sector Viewer version 1.1 - Idea by: Jaap Mark
;
; Written by: BiFi'98
;
	jp	start
	db	13,"IDE Sector Viewer version 1.1 - (c) BiFi'98 & "
	db	"XLR-8. For internal use only!",26
;
start:	call	findIDE
	jr	z,noIDE
	call	initScreen
main1:	call	readSector
main2:	call	printSector
mainKey:	call	getKey
	call	lowerCase
	cp	27	; ESC key
	jr	z,quit
	cp	30	; Cursor-up key
	jp	z,prevSector
	cp	31	; Cursor-down key
	jp	z,nextSector
	cp	"p"
	jp	z,gotoPars
	cp	"q"
	jr	z,quit
	cp	"s"
	jp	z,gotoSector
	cp	"t"
	jp	z,toggle
	jr	mainKey

quit:	call	scRst
	ld	de,tExtro
abort:	ld	c,9
	call	5
	rst	0
;
noIDE:	ld	de,tNoIDE
	jr	abort
;
tExtro:	db	"IDE Sector Viewer version 1.1 - (c) 1998 BiFi & XLR-8"
	db	13,10,"All rights reserved. For internal use only!"
	db	13,10,10,"$"
tNoIDE:	db	13,10,"No IDE Interface found!$"
;
; Device I/O for IDE-Interface &H7F89, &H7F8C in IDE-Interface slot
; In:         AF =>   A = Device select (0 = Master, 1 = Slave)
;                     F = Action select (C = Write, NC = Read)
;             BC =>   B = Number of sectors to transfer (Disk size theory 8 GB)
;                     C = Sector number (bits 23 - 16)
;             DE =>       Sector number (bits 15 - 00)
;             HL =>       Transfer address
; Out:        Possibly identical to Disk-BIOS Disk I/O
; Use:        All
;
deviceIO:	ld	iy,(ideSlot - 1)
	ld	ix,&h7f8c
	jp	c,&h1c
	ld	ix,&h7f89
	jp	&h1c
;
; Find IDE-Interface
; In:         Nothing special
; Out:        AF =>   A = Slot of IDE-Interface
;                     F = Z  = No IDE-Interface found
;                         NZ = Interface found
; Use:        All
;
findIDE:	ld	bc,4*256
	ld	hl,&hfcc1
primSlotLp:	push	bc,hl
	ld	a,c
	call	chkSubSlot
	pop	hl,bc
	jr	z,foundIDE
	inc	c	; Next slot
	inc	hl
	djnz	primSlotLp
	xor	a
	ret
;
foundIDE:	and	a
	ret
;
chkSubSlot:	or	(hl)
	jp	p,check
	ld	b,4
subSlotLp:	push	af,bc,hl
	call	check
	pop	hl,bc
	ex	af,af'
	pop	af
	ex	af,af'
	ret	z
	ex	af,af'
	add	a,4
	djnz	subSlotLp
	ret

check:	ld	(ideSlot),a
	ld	hl,&h7f80
	ld	de,chkStr
	ld	b,3
chkLoop:	push	bc,de,hl
	ld	a,(ideSlot)
	call	&hc
	pop	de,hl,bc
	cp	(hl)
	ex	de,hl
	ret	nz
	inc	de
	inc	hl
	djnz	chkLoop
	ret
;
; HL = HL + (A * 16)
; In:         AF =>   A = Partition HGI-IDE like
;             HL =>       Base address
; Out:        HL =>       Calculated base address
; Use:        AF, BC, HL
;
mulup16:	cpl
	and	31
	add	a,a
	add	a,a
	add	a,a
	add	a,a
	ld	c,a
	ld	a,0
	adc	a,a
	ld	b,a
	add	hl,bc
	ret
;
ideSlot:	db	0
chkStr:	db	"ID#"
curSector:	dw	0,0
maxSector:	dw	-1,255
device:	db	0
sectFlag:	db	0	; Used to keep which half is viewed
printAdr:	dw	0
printChr:	dw	0
;
; Program specific routines
;
getKey:	rst	&h30
	db	&h80
	dw	&h9c
	jr	z,getKey
	rst	&h30
	db	&h80
	dw	&h9f
	ret
;
setWrt:	ld	a,l
	out	(&h99),a
	ld	a,h
	or	64
	out	(&h99),a
	ret
;
lowerCase:	cp	"A"
	ret	c
	cp	"Z"+1
	ret	nc
	or	32
	ret
;
upperCase:	cp	"a"
	ret	c
	cp	"z"+1
	ret	nc
	and	223
	ret
;
toggle:	ld	a,(&hf6a0)
	bit	1,a
	jp	z,main1
	ld	a,(device)
	xor	1
	ld	(device),a
	ld	hl,0
	ld	(curSector),hl
	ld	(curSector+2),hl
	xor	a
	ld	(sectFlag),a
	call	newDevice
	jp	main1
;
prevSector:	ld	hl,(curSector)
	ld	de,(curSector+2)
	ld	a,(sectFlag)
	ld	d,a
	ld	a,e	; Check sector 0 lower part
	or	h
	or	l
	or	d
	ld	d,0
	jp	z,mainKey	; Already set

	ld	a,(sectFlag)
	xor	1
	ld	(sectFlag),a
	jp	z,main2

	ld	bc,-1
	add	hl,bc
	jr	c,noMSW
	dec	de

noMSW:	ld	(curSector+2),de
	ld	(curSector),hl
	jp	main1
;
nextSector:	ld	hl,(curSector)
	ld	de,(curSector+2)
	ld	a,(sectFlag)
	neg
	ld	d,a
	ld	a,e	; Check last sector upper part
	and	h
	and	l
	and	d
	cp	-1
	ld	d,0
	jp	z,mainKey	; Already set

	ld	a,(sectFlag)
	xor	1
	ld	(sectFlag),a
	jp	nz,main2

	ld	bc,1
	add	hl,bc
	ld	bc,0
	ex	de,hl
	adc	hl,bc
	ex	de,hl

	ld	(curSector+2),de
	ld	(curSector),hl
	jp	main1
;
gotoSector:	call	sect2Hex
	call	updateHex
	ld	b,0
	call	inpHexSect
	call	getSector
	xor	a
	ld	(sectFlag),a
	jp	main1
;
gotoPars:	ld	hl,1743
	call	setWrt
	ld	hl,tPartition
	call	outAsciiZ
	xor	a
	ld	hl,tHexNumber+4
	call	conv2Hex
	ld	(hl),a
noPar:	ld	b,1
	call	outPars
	ld	hl,tHexNumber+4
	call	conv2Bin
	cp	31
	jr	nc,noPar
	ld	hl,dma+512
	call	mulup16
	ld	de,6
	add	hl,de
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	c,(hl)
	ld	b,0
	ld	(curSector),de
	ld	(curSector+2),bc
	ld	hl,1743
	call	setWrt
	ld	hl,tSector
	call	outAsciiZ
	xor	a
	ld	(sectFlag),a
	jp	main1
;
initScreen:	call	scInit
	ld	hl,scrMain
	call	scScr

	ld	hl,1743
	call	setWrt
	ld	hl,tSector
	call	outAsciiZ
	call	updateHex

reDevice:	ld	hl,194
	call	setWrt
	ld	hl,tDevice
	call	outAsciiZ
newDevice:	ld	hl,205
	call	setWrt
	ld	a,(device)
	add	a,"0"
	out	(&h98),a

	xor	a
	ld	a,(device)
	ld	bc,256
	ld	de,0
	ld	hl,dma+512
	jp	deviceIO
;
outAsciiZ:	ld	a,(hl)
	and	a
	ret	z
	out	(&h98),a
	inc	hl
	jr	outAsciiZ
;
readSector:	xor	a	; Read master device
	ld	a,(device)
	ld	de,(curSector)
	ld	bc,(curSector+2)
	ld	b,1
	ld	hl,dma
	jp	deviceIO
;
printSector:	ld	hl,323
	ld	b,16
	ld	a,(sectFlag)
	and	a
	ld	de,dma
	jr	z,highSect
	ld	de,dma+256
highSect:	ld	(printAdr),de
	ld	(printChr),de
newLine:	push	af,bc,hl
	call	setWrt
	ld	a,(sectFlag)
	add	a,"0"	; Print first/second 256 bytes
	out	(&h98),a
	pop	hl
	push	hl	; Print Hex bytes
	ld	de,6
	add	hl,de
	call	setWrt
	ld	b,16
fillLine1:	push	bc
	ld	de,(printAdr)
	ld	hl,tHexByte
	ld	a,(de)
	call	conv2Hex
	ld	(hl),a
	ld	hl,tHexByte
	call	outAsciiZ
	inc	de
	ld	(printAdr),de
	pop	bc
	ld	a,b
	cp	9
	call	z,addSpace
	djnz	fillLine1
	pop	hl
	push	hl
	ld	de,57
	add	hl,de
	call	setWrt
	ld	b,16
fillLine2:	ld	de,(printChr)
	ld	a,(de)
	out	(&h98),a
	inc	de
	ld	(printChr),de
	ld	a,b
	cp	9
	call	z,addSpace
	djnz	fillLine2
	pop	hl,bc,af
	ld	de,80
	add	hl,de
	djnz	newLine
	call	sect2Hex
	jp	updateHex
;
addSpace:	ld	a," "
	out	(&h98),a
	ret
;
sect2Hex:	ld	de,(curSector)
	ld	bc,(curSector+2)
	ld	a,c
	ld	hl,tHexNumber
	call	conv2Hex
	ld	(hl),a
	inc	hl
	ld	a,d
	call	conv2Hex
	ld	(hl),a
	inc	hl
	ld	a,e
	call	conv2Hex
	ld	(hl),a
	ret

conv2Hex:	ld	b,a
	rrca
	rrca
	rrca
	rrca
	call	convHex
	ld	(hl),a
	inc	hl
	ld	a,b
convHex:	and	15
	add	a,"0"
	cp	"9"+1
	ret	c
	add	a,7
	ret
;
getSector:	ld	hl,tHexNumber
	call	conv2Bin
	ld	c,a
	call	conv2Bin
	ld	d,a
	call	conv2Bin
	ld	e,a
	ld	b,0
	ld	(curSector),de
	ld	(curSector+2),bc
	ret
;
conv2Bin:	ld	a,(hl)
	inc	hl
	call	convBin
	rlca
	rlca
	rlca
	rlca
	ld	b,a
	ld	a,(hl)
	inc	hl
	call	convBin
	or	b
	ret
;
convBin:	sub	"0"
	cp	10
	ret	c
	sub	7
	ret
;
inpHexSect:	call	getKey
	cp	13
	ret	z
	call	upperCase
	cp	"0"
	jr	c,inpHexSect
	cp	"G"
	jr	nc,inpHexSect
	cp	"9"+1
	jr	c,addHex
	cp	"A"
	jr	nc,addHex
	jr	inpHexSect

addHex:	push	af,bc
	ld	bc,5
	ld	de,tHexNumber
	ld	hl,tHexNumber+1
	ldir
	pop	bc,af
	ld	(de),a
	ld	a,b
	and	a
	jr	nz,outPars
	call	updateHex
	jr	inpHexSect

outPars:	ld	hl,1755
	call	setWrt
	ld	hl,tHexNumber+4
	call	outAsciiZ
	jr	inpHexSect
;
updateHex:	ld	hl,1751
	call	setWrt
	ld	hl,tHexNumber
	jp	outAsciiZ
;
tDevice:	db	"Device ID:",0
tPartition:	db	" Partition: 00",0
tSector:	db	"Sector: ",0
tHexNumber:	db	"000000",0
tHexByte:	db	"00 ",0
;
; --- Deze routines zijn geschreven door Ramon van der Winkel ---
;
; scrinc.gen
;
; Dit is een includefile voor gen80. Deze routines doen het ondersteunende
; werk voor de Screen Editor Screens, Lines en Patterns.
; De volgende routines kunnen worden gebruikt:
;
; scInit - Deze routine initialiseert de VDP voor de juiste schermmode en
;          scherm instellingen. Deze routine moet bij het opstarten van de
;          applicatie eenmalig worden aangeroepen. 50/60 Hz niet aangepast.
;
; scRst  - Deze routine herstelt de schermmode naar de instellingen volgens
;          de klok-chip. Deze routine moet bij het verlaten van de applicatie
;          worden aangeroepen.
;
; scScr  - Deze routine maakt een screen actief. Het scherm wordt vanaf regel
;          0 (de bovenste regel) op het scherm gezet. Als het om een blok
;          gaat, dan moet de routine scBlok gebruikt worden. Er moet in
;          register [HL] worden opgegeven waar de scherm defintie staat. Zie
;          de opmerking onderaan over het toevoegen van schermen in de
;          applicatie code.
;
; scLns  - Deze routine doet hetzelfde als scShow, alleen dan voor lines.
;          In register [HL] moet worden opgegeven waar de blok-definitie data
;          staat. In register [A] moet het schermregelnummer worden opgegeven
;          waar vanaf het blok moet worden opgebouwd. Merk op dat deze routine
;          geen controle uitvoert op het overschrijden van de onderste scherm-
;          regel. Zie de opmerking onderaan over het toevoegen van schermen
;          in de applicatie code.
;
; scBlk  - Deze routine zet een blok op het scherm. In register [HL] moet
;          worden opgegeven waar de blok-defintie staat. In register [B] moet
;          de X en in register [C] de Y coordinaat van de linker bovenhoek
;          worden opgegeven. Als voor de X coordinaat -1 wordt opgegeven, dan
;          wordt het blok in het midden gezet. Bij de Y coordinaat geldt
;          hetzelfde.
;
; scPat  - Deze routine maakt een karakterset actief. Er moet in register [HL]
;          worden opgegeven waar de karakterset definitie begint. Zie de
;          opmerking hieronder over het invoegen van een karakterset in de
;          applicatie code.
;
; De karaktersets en schermen of scherm-delen data kunnen in de code van de
; applicatie worden opgenomen. Hiervoor moet de screen-convertor worden
; gebruikt, welke het scherm comprimeert en de source-tekst aflevert van het
; scherm of de karakterset. Deze source files moeten met het include commando
; in de source worden opgenomen. In de door de Screen Convertor aangemaakte
; source staat ook een label naam. Deze bestaat uit de drie beginletters
; scr, lns, blk of pat, met daar aanvast de bestandsnaam van de source tekst
; waaronder de Screen Converter de source heeft weggeschreven. Alleen de
; eerste letter van deze naam is in hoofdletters. Bijvoorbeeld als de Screen
; Convertor het bestand TEST.SCR geconverteerd heeft, dan staat de source nu
; in TEST.SXT en bevat deze het label met de naam scrTest.
;

; scInit
;
; Deze routine initialiseert de Text Mode 2 scherm mode door de VDP direct
; aan te sturen. De VDP-backup variabelen worden dus niet bijgehouden.
;
; - Width 80
; - Screen 0
; - 26.5 regels
; - Scherm constructie op 0000h
; - Inverse video op 0a00h
; - Karakter data op 1000h
; - Eigen pallet data
; - Kleuren 1,2,3,4
; - Karaterset uit het bios ophalen
; - Cursor teken vullen met 255-jes
;
scInit:	di		;Geen INT's tijdens VDP IO

	; wis het tekst en inverse scherm
	;
	sub	a	;Pagina 0 selecteren
	out	(099h),a	;Stuur het pagina nummer
	ld	a,128+14	;Via R#14
	out	(099h),a	;Stuur het commando + register nummer

	sub	a	;Startadres van het tekstscherm
	out	(099h),a	; selecteren
	or	40h	;Schrijf mode
	out	(099h),a

	ld	bc,27*80	;Zoveel tekens in het tekst scherm
scInitClrLp1:	ld	a," "	;Met spaties wissen
	out	(098h),a	;Stuur een spatie om te wissen
	dec	bc	;Een positie minder te wissen
	ld	a,b	;Nog meer posities wissen?
	or	c
	jr	nz,scInitClrLp1	;Ja, meer posities wissen

	sub	a	;Startadres van het inverse scherm
	out	(099h),a	; selecteren
	ld	a,40h+0ah	;Schrijf mode
	out	(099h),a

	ld	bc,27*10	;Zoveel tekens in het inverse scherm
scInitClrLp2:	sub	a	;Met 00-en wissen
	out	(098h),a	;Stuur een 00 om te wissen
	dec	bc	;Een positie minder te wissen
	ld	a,b	;Nog meer posities wissen?
	or	c
	jr	nz,scInitClrLp2	;Ja, meer posities wissen

	; eigen palletten initialiseren
	;
	ld	hl,scInitPalets	;Deze pallet kleuren initialiseren
	call	scPallet	;Maak de te gebruiken palleten zwart

	ei		;Klaar met VDP IO, INT's mogen weer

	; vdp registers aanpassen voor de juiste mode
	;
	ld	a,(0ffe8h)	;Stand van VDP(10) ophalen (50/60 Hz)
	ld	hl,stoReg9+1	;Daar de data opslaan
	or	(hl)	;Verander de settings
	ld	(hl),a	;Sla de nieuwe data op

	ld	hl,scInitRegs	;Te veranderen registers
scInitRegsLp:	ld	c,(hl)	;Register nummer ophalen
	inc	hl	;Naar de data in de tabel
	ld	b,(hl)	;Data ophalen
	inc	hl	;Pointer naar de volgende entry

	ld	ix,047h	;WrtVdp
	ld	iy,(0fcc1h-1)	;SlotID van het BIOS
	call	01ch	;Aanroepen via Interslot call

	ld	a,(hl)	;Volgende register ophalen
	inc	a	;Einde van de tabel? (-1)
	jr	nz,scInitRegsLp	;Meer registers schrijven
	ret

scInitRegs:	db	0,4	;Textmode 2 settings
	db	1,112	;Enable scr, ints; Textmode 2 settings
	db	8,8	;64x4 vram
stoReg9:	db	9,128	;26.5
	db	2,3	;Pattern name table at 0000
	db	3,47	;Color table at A00h
	db	10,0	; idem
	db	4,2	;Pattern generator table at 1000h
	db	13,0f0h	;Inverse-video: Always on, never off
	db	23,0	;Alles op zijn plek
	db	7,12h	;Tekst voor- en achtergrond kleuren
	db	12,34h	;Inverse voor- en achtergrond kleuren
	db	-1	;Einde van de tabel

scInitPalets:	db	0,0,0	;Default pallets voor de kleuren
	db	0,0,0	; die gebruikt worden. Er is expres
	db	0,0,0	; voor zwart gekozen, dan levert het
	db	0,0,0	; geen felle flits op. Aanpasbaar.

; scRst
;
; Deze routine herstelt de scherm mode volgens de instellingen in de klok
; chip. Dit gebeurt door de SubRom routine sDfScr aan te roepen. Op adres
; 0faf8h moet het SlotID van de SubRom staan. Op adres 01ch moet de
; InterSlotCall routine aanroepbaar zijn.
;
scRst:	sub	a	;VDP (14)=0
	ld	(0ffech),a	;Uitlezen gebeurt door sDfScr

	ld	ix,0185h	;sDfScr routine in de SubRom
	ld	iy,(0faf8h-1)	;SlotID van de SubRom ophalen
	jp	01ch	;Roep de routine aan

; scPallet
;
; Deze routine past de pallet kleuren aan er wordt aangeroepen vanuit scInit
; en scShow. De data moet bestaan uit 12 bytes, een R, G en B byte voor alle
; vier de kleuren. De palletten worden in de kleuren 1,2,3 en 4 geschreven.
;
; In: DI
;     HL = Pointer naar de data
;
scPallet:	ld	bc,0401h	;4 registers schrijven, begin bij nr 1
scShowPalLp:	push	bc	;Bewaar de tellers

	ld	d,c	;Color Pallette nummer naar [D]

	ld	a,(hl)	;Rood tint
	inc	hl
	rlca		;Naar hoge bits van [A]
	rlca
	rlca
	rlca

	ld	e,(hl)	;Groen tint naar [E]
	inc	hl

	or	(hl)	;Blauw tint naar lage bits van [A]
	inc	hl	;Naar het volgende pallet

	ld	ix,014dh	;SetPlt routine adres in sub-rom
	ld	iy,(0faf8h-1)	;SlotID van de sub-rom naar IYh
	call	01ch	;Roep de routine aan

	pop	bc	;Herstel de tellers
	inc	c	;Volgende pallet
	djnz	scShowPalLp	;Meer palletten veranderen
	ret

; scScr
;
; Deze routine bouwt een scherm op. Alle andere gegevens op het scherm worden
; gewist.
;
; In: HL = Pointer naar de scherm defintie
;      A = Regel waarop het schermdeel moet beginnen
;
scScr:	di		;Geen INT's tijdens VDP IO

	call	scPallet	;Schrijf de kleuren
	sub	a	;Begin op regel 0

scLns:	di		;Geen INT's tijdens VDP IO

	push	hl	;Bewaar de scherm definitie pointer

	ld	l,a	;Regelnummer naar een 16 bits register
	ld	h,0
	add	hl,hl	;*2
	ld	d,h	;Bewaar *2
	ld	e,l
	add	hl,hl	;*4
	add	hl,hl	;*8
	add	hl,de	;*8 + *2 = *10
	ld	d,h	;Bewaar *10
	ld	e,l
	add	hl,hl	;*20
	add	hl,hl	;*40
	add	hl,hl	;*80

	ld	a,l	;Selecteer het tekst vram adres
	out	(099h),a
	ld	a,h
	or	40h	;Schrijf mode
	out	(099h),a

	pop	hl	;Herstel de scherm defintie pointer
	push	de	;Bewaar de inverse vram offset

	call	scShowBlok	;Bouw het tekst scherm op

	ex	(sp),hl	;Herstel de offset, bewaar de pointer
	ld	de,0a00h	;Basis van het inverse scherm
	add	hl,de	;Bereken het inverse scherm entry adres

	ld	a,l	;Selecteer het inverse vram adres
	out	(099h),a
	ld	a,h
	or	40h	;Schrijf mode
	out	(099h),a

	pop	hl	;Herstel de defintie pointer
	call	scShowBlok	;Bouw het inverse scherm op

	ei		;Klaar met VDP IO, INT's mogen weer
	ret

scShowBlok:	ld	c,098h	;VDP datapoort
scShowBlokLp:	ld	a,(hl)	;Code / Lengte byte ophalen
	inc	hl	;Ophaal pointer naar de databyte
	and	a	;Einde van de definitie?
	ret	z	;Ja, tekst scherm is nu af

	cp	128	;128 of groter? (repeat)
	jr	c,scShowBlokOk	;Nee, dan gewoon x bytes sturen

	sub	128	;Wis het repeat-indicatie bit
	ld	b,a	;Aantal tekens te sturen
	ld	a,(hl)	;Te sturen teken ophalen
	inc	hl	;Ophaal pointer naar het volgende blok
scShwBlokLp2:	out	(098h),a	;Stuur 1 databyte
	djnz	scShwBlokLp2	;Meer databytes sturen

	jr	scShowBlokLp	;Meer gecompresseerde blokken verwerken

scShowBlokOk:	ld	b,a	;Aantal byte te sturen naar [B]
	otir		;Stuur het aantal databytes

	jr	scShowBlokLp	;Meer gecompresseerde blokken verwerken

; scPat
;
; Deze routine activeert de opgegeven karakterset.
;
; In: HL = Pointer naar de karakterset data.
;
scPat:	di		;Geen INT's tijdens VDP IO

	sub	a	;Selecteer adres 1000h
	out	(099h),a
	ld	a,10h.or.40h	;Schrijf mode
	out	(099h),a

	call	scShowBlok	;Karakterset naar het vram

	ei		;Klaar met VDP IO, INT's mogen weer
	ret

; Einde van de include file
;
; --- Einde van de routines van Ramon van der Winkel
;
; MAIN.SXT - created bij ScrCnvt - Adjusted by: BiFi'98
;
scrMain:	db	7,7,7,0,0,5,6,6,1,0,0,0
	db	128+81," "
	db	1,24,128+76,23,34
	db	25,"  ",22," IDE Sector Viewer version 1.1"
	db	128+16," ",34
	db	"By: BiFi'98 and JOM  (c) 1998 ",22,"  ",20
	db	128+5,23,1,18,128+50,23,1,18,128+19,23,62
	db	19,"  ",22," 000 ",22," 33 33 33 33 33 33 33 33  33 33 "
	db	"33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 010 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 020 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 030 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 040 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 050 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 060 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 070 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 080 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 090 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 0A0 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 0B0 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 0C0 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 0D0 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 0E0 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",63
	db	" ",22,"  ",22," 0F0 ",22," 33 33 33 33 33 33 33 33  33"
	db	" 33 33 33 33 33 33 33 ",22," "
	db	128+8,"3",1," ",128+8,"3",5," ",22,"  ",20
	db	128+5,23,1,17,128+50,23,1,17,128+19,23,59
	db	19,"  ",22," 000   00 01 02 03 04 05 06 07  08 09 0A 0B"
	db	" 0C 0D 0E 0F"
	db	128+21," ",4,22,"  ",20,128+76,23,84
	db	19,"  ",22," Up/Down = Chng sector, S = Goto sector, Q/"
	db	"ESC = Quit, T = Toggle, P = Pars ",22,"  ",26
	db	128+76,23,1,27,128+127," ",128+34," ",0
	db	128+127,0,128+127,0,128+16,0,0
;
; --- Einde van schermdata
dma	equ	$
