	org	&hc000
;
; The LED's which can be set or reset by user on the MSX-turboR
;
; Routines by: BiFi'97
;
capsAan:	in	a,(&haa)
	and	191
	out	(&haa),a
	ret
;
capsUit:	in	a,(&haa)
	or	64
	out	(&haa),a
	ret
;
kanaAan:	ld	a,15
	out	(&ha0),a
	in	a,(&ha2)
	and	127
	out	(&ha1),a
	ret
;
kanaUit:	ld	a,15
	out	(&ha0),a
	in	a,(&ha2)
	or	128
	out	(&ha1),a
	ret
;
pauseAan:	ld	a,(&hfcb1)
	or	1
	ld	(&hfcb1),a
	out	(&ha7),a
	ret
;
pauseUit:	ld	a,(&hfcb1)
	and	254
	ld	(&hfcb1),a
	out	(&ha7),a
	ret
;
turboAan:	ld	a,(&hfcb1)
	or	128
	ld	(&hfcb1),a
	out	(&ha7),a
	ret
;
turboUit:	ld	a,(&hfcb1)
	and	127
	ld	(&hfcb1),a
	out	(&ha7),a
	ret
;
counter:	db	0	; Bit 0 = LSB counter
;                                      ; Bit 1 = MSB counter
;                                      ; Bit 2 = Unused
;                                      ; Bit 3 = Unused
;                                      ; Bit 4 = Turbo LED
;                                      ; Bit 5 = Pause LED
;                                      ; Bit 6 = Kana  LED
;                                      ; Bit 7 = Caps  LED
;
start:	call	storeCur	; Keep current statuses

ledLoop:	ld	a,(counter)
	and	15	; Light LED's according to counter
	call	setLights

	ld	hl,counter	; Increase counter
	ld	a,(hl)
	and	240	; Mask current statuses
	ld	b,a
	ld	a,(hl)
	and	15	; Mask to rid statuses
	inc	a
	and	15	; Mask the shit
	or	b
	ld	(hl),a

wait:	ld	b,30
waitLoop:	ld	a,8
	call	&h141
	bit	0,a
	jr	z,restoreCur
	halt
	djnz	waitLoop
	jr	ledLoop
;
setLights:	ld	hl,counter
	bit	0,(hl)
	call	nz,turboAan
	bit	0,(hl)
	call	z,turboUit
	bit	1,(hl)
	call	nz,pauseAan
	bit	1,(hl)
	call	z,pauseUit
	bit	2,(hl)
	call	nz,kanaAan
	bit	2,(hl)
	call	z,kanaUit
	bit	3,(hl)
	call	nz,capsAan
	bit	3,(hl)
	call	z,capsUit
	ret
;
storeCur:	ld	hl,counter
	ld	(hl),0
	in	a,(&haa)	; Caps LED
	bit	6,a
	jr	nz,chkKana
	set	7,(hl)
chkKana:	ld	a,15	; Kana LED
	out	(&ha0),a
	in	a,(&ha2)
	bit	7,a
	jr	nz,chkPause
	set	6,(hl)
chkPause:	ld	a,(&hfcb1)	; Pause LED
	bit	0,a
	jr	z,chkTurbo
	set	5,(hl)
chkTurbo:	bit	7,a	; Turbo LED
	ret	z
	set	4,(hl)
	ret
;
restoreCur:	ld	hl,counter
	bit	7,(hl)	; Caps LED
	push	af
	call	nz,capsAan
	pop	af
	call	z,capsUit
	bit	6,(hl)	; Kana LED
	push	af
	call	nz,kanaAan
	pop	af
	call	z,kanaUit
	bit	5,(hl)	; Pause LED
	push	af
	call	nz,pauseAan
	pop	af
	call	z,pauseUit
	bit	4,(hl)	; Turbo LED
	push	af
	call	nz,turboAan
	pop	af
	call	z,turboUit
	ret
