	org	&h100
;
; Initialize MSX-MUSIC for sample replay
;
; Written by: BiFi 2000
;
	jp	start
	db	13,"MSX-MUSIC sample replay init by BiFi 2000",26
;
start:	call	storeCpu
	ld	bc,&h400	; Number of primary slots
	ld	hl,&hfcc1
priLoop:	push	bc,hl
	ld	a,c
	or	(hl)	; Check expanded slot
	jp	m,subSlot
	call	chkOpll
priNext:	pop	hl,bc
	jr	c,setOpll
	inc	hl
	inc	c
	djnz	priLoop
	jp	restCpu

subSlot:	call	subFind
	jr	priNext
subFind:	ld	b,4
subLoop:	push	bc
	call	chkOpll
	pop	bc
	ret	c
	add	a,4
	djnz	subLoop
	or	a
	ret

chkOpll:	ld	b,4
	ld	c,a
	ld	de,tOpll
	ld	hl,&h401c
chkLoop:	push	bc,de,hl
	ld	a,c
	call	&hc
	pop	hl,de,bc
	ex	de,hl
	cp	(hl)
	ex	de,hl
	ld	a,c
	ret	nz
	inc	de
	inc	hl
	djnz	chkLoop
	scf
	ret

tOpll:	db	"OPLL"
pcmData:	db	&h30,&hff,&h0f,&hef,&h20,&h1f,&h10,&h00
oldCpu:	db	0
;
setOpll:	ld	e,1
	ld	hl,&h7ff6
	call	&h14
	ld	b,4
	ld	hl,pcmData
pcmLoop:	ld	a,(hl)
	inc	hl
	out	(&h7c),a
	ld	a,(hl)
	inc	hl
	out	(&h7d),a
	djnz	pcmLoop

restCpu:	call	msxVer
	ret	c
	ld	a,(oldCpu)
setCpu:	or	128
	ld	ix,&h180
mainRom:	ld	iy,(&hfcc0)
	jp	&h1c

storeCpu:	call	msxVer
	ret	c
	ld	ix,&h183
	call	mainRom
	ld	(oldCpu),a
	xor	a
	jr	setCpu

msxVer:	ld	a,(&hfcc1)
	ld	hl,&h2d
	call	&hc
	cp	3
	ret
