	org	&h100
;
bDos	equ	5
extBio	equ	&hffca
;
; BIGECHO version 1.2 - You're not the only one Loenie ;-)
;
; Written by: BiFi'96
;
	jp	start

	db	13,"BIGECHO V1.2 (includes KANJI) - By BiFi'96",26
;
start:	ld	a,(&h80)	; Check length
	and	a
	ret	z	; No text means nothing to do

	call	getKanji	; Kanji-mode > 0?
	and	a	; Only ANK-mode will change a char.
	jr	nz,nextLine

	ld	hl,&h2b	; Get type of character set
	ld	a,(&hfcc1)
	call	&hc
	and	15
	ld	(charSetType),a	; Keep it in here
	jr	nz,nextLine

	ld	hl,(&hf924)	; Start of Character Pattern table
	ld	bc,254*8	; Character 254 is to be changed
	add	hl,bc
	ld	bc,8	; 8 bytes to fill
	ld	a,255	; Fill code 255
	ld	ix,&h56	; FILVRM BIOS routine
	ld	iy,(&hfcc0)
	call	&h1c
	ei

nextLine:	ld	hl,&h82
;
printText:	ld	a,(hl)	; Get chararcter
	and	a
	jr	z,endLine	; End when zero (DOS2 end)
	cp	13
	jr	z,endLine	; End when CR (DOS1 end)
	cp	1
	jr	z,grpChar
	cp	32
	jr	nc,outChar

	inc	hl
	jr	printText

grpChar:	inc	hl	; It's a graphical character
	ld	a,(hl)
	sub	64
;
outChar:	push	hl
	ld	e,a
	ld	d,0
	ld	hl,(&hf920)	; Start address of charset
	rl	e	; DE = DE * 8
	rl	d
	rl	e
	rl	d
	rl	e
	rl	d
	add	hl,de	; HL = <start_charset> + DE
	call	adjustLine	; Set current line in character
	ld	a,(&hf91f)	; Slot of charset 
	call	&hc	; Get the character
	ld	b,8
	push	af
	ld	a,(&hfcaf)
	and	a
	jr	nz,printBig
	call	getKanji
	and	1
	jr	nz,printBig
	ld	b,6
printBig:	pop	af
putLoop:	rlca
	push	af
	bit	0,a	; Rotate bit to check to bit 0 pos.
	ld	e,32
	jr	z,bitOff
	call	getKanji
	and	a
	jr	nz,noAnk
	ld	a,(charSetType)
	and	a
	ld	e,254
	jr	z,bitOff
	ld	e,219
bitOff:	push	bc
	push	hl
	call	conOut
	pop	hl
	pop	bc
	xor	a
noAnk:	call	nz,putKanji
	pop	af
	djnz	putLoop
	pop	hl
	inc	hl
	jr	printText
;
endLine:	push	hl
	ld	e,13
	call	conOut
	ld	e,10
	call	conOut
	ld	hl,numberLines	; Decrease number of lines to go
	dec	(hl)
	pop	hl
	jp	nz,nextLine	; Continue with next line when not zero
	rst	0
;
conOut:	ld	c,2	; Write character in E onto the screen
	jp	bDos
;
adjustLine:	ld	a,(numberLines)
	neg
	and	7
	ld	c,a
	ld	b,0
	add	hl,bc
	ret
;
getKanji:	ld	a,255
	ld	de,&h1100
	call	extBio
	bit	7,a
	ret	z
	inc	a
	ret
;
putKanji:	push	bc
	push	hl
	ld	a,254
	out	(&hf5),a
	ld	e,219
	call	conOut
	ld	a,255
	out	(&hf5),a
	pop	hl
	pop	bc
	ret
;
numberLines:	db	8	; 8 lines for the BIG ECHO
charSetType:	db	0	; Type of character set
