	org	&h100
;
; Banner printer V1.1 - commandline version
;
; Written by: BiFi'96
;
	jp	start
	db	13,"BANNER.COM V1.1 - Written by: BiFi'96",26
;
start:	ld	hl,&h80
	ld	b,(hl)	; Length of command line
	inc	b
	dec	b	; Check if it's zero
	jp	z,allDone	; There are no parameters, so end

	inc	hl	; Start of parameter string

	call	chkSpace	; must be at least one space
	call	chkEnd
	jr	z,abort

	call	readValue	; get height
	jr	nz,abort
	ld	(height),a

	call	chkSpace	; again at least one space
	call	chkEnd
	jr	z,abort

	call	readValue	; get width
	jr	nz,abort
	ld	(width),a

	call	chkSpace	; again at least one space
	call	chkEnd
	jr	z,abort

	ld	(curPointer),hl	; keep address in case of no option
	ld	de,"Ss"
	call	chkOption	; check for an option
	jr	nz,doPrinter

	inc	hl
	call	chkSpace
	call	chkEnd
	jr	z,abort

	ld	(curPointer),hl	; address after the option
	ld	a,1
	ld	(scrnFlag),a

doPrinter:	ld	hl,(curPointer)
	ld	de,"Cc"
	call	chkOption
	jr	nz,doBanner

	inc	hl
	call	chkSpace
	call	chkEnd
	jr	z,abort

	ld	(curPointer),hl
	ld	a,6
	ld	(charSize),a

doBanner:	ld	hl,(curPointer)
	ld	a,(hl)
	inc	hl
	ld	(curPointer),hl
	call	chkEnd
	jr	z,allDone

	push	af,bc,de,hl
	call	outBanner
	pop	hl,de,bc,af
	jr	doBanner
;
chkSpace:	ld	a,(hl)
	cp	32
	ret	nz
	inc	hl
	jr	chkSpace
;
chkEnd:	and	a
	ret	z
	cp	13
	ret
;
abort:	ld	c,9
	ld	de,tUsage
	call	5

allDone:	rst	0
;
scrnFlag:	db	0
tUsage:	db	"BANNER <height> <width> [{-S|/S}] [{-C|/C}] <bannertext>"
	db	13,10,10,"<height> = 1-9 dots"
	db	13,10,"<width> same as <height>"
	db	13,10,10,"-S or /S = redirect printing to screen"
	db	13,10,"-C or /C = print first 6 dots (default: 8 dots)"
	db	13,10,10,"When both used, S-option before C-option!"
	db	13,10,"$"
;
getChrPat:	ld	e,a
	ld	d,0
	ld	hl,(&hf920)	; Start address of charset
	rl	e	; DE = DE * 8
	rl	d
	rl	e
	rl	d
	rl	e
	rl	d
	add	hl,de	; HL = <start_charset> + DE
	ld	de,patWork
	ld	b,8
fetchPat:	push	bc
	ld	a,(&hf91f)	; Slot of charset 
	push	de
	call	&hc
	pop	de
	ld	(de),a
	pop	bc
	inc	hl
	inc	de
	djnz	fetchPat
	ret
;
patWork:	dw	0,0,0,0	; 8 bytes for pattern
;
readValue:	inc	hl
	cp	"1"
	jr	c,noValue
	cp	"9"+1
	jr	nc,noValue
	sub	"0"
	ld	b,a
	xor	a
	ld	a,b
	ret

noValue:	xor	a	; Make non-zero
	inc	a
	ret
;
chkOption:	ld	a,(hl)
	cp	"-"
	jr	z,option	; It's no option
	cp	"/"
	jr	nz,noValue
option:	inc	hl
	ld	a,(hl)
	cp	d
	ret	z
	cp	e
	ret	z
	jr	noValue
;
curPointer:	dw	0
outChar:	db	0
height:	db	0
width:	db	0
charSize:	db	8
;
selectOut:	ld	a,(scrnFlag)
	and	a
	ld	c,5	; Print to paper
	jr	z,bDosOut
	ld	c,2	; Print to screen
bDosOut:	jp	5
;
movePat:	ld	b,8
	ld	hl,patWork
moveAbit:	rlc	(hl)
	inc	hl
	djnz	moveAbit
	ret
;
outBanner:	ld	(outChar),a
	call	getChrPat
	ld	a,(charSize)
	ld	b,a
printBits:	push	af,bc,de,hl
	call	movePat	; Move pattern 1 bit to the left
	ld	b,8	; One pattern is 8 bytes
	ld	hl,patWork+7
	ld	de,outTable
	push	de
makeLine:	push	bc
	ld	a,(height)
	ld	b,a
	ld	a,(outChar)
	bit	0,(hl)
	jr	nz,bitHigh
	ld	a,32
bitHigh:	ld	(de),a
	inc	de
	djnz	bitHigh
	pop	bc
	dec	hl
	djnz	makeLine
	ld	a,13
	ld	(de),a
	inc	de
	ld	a,10
	ld	(de),a
	pop	de
	ld	a,(width)
	ld	b,a
nextLine:	push	de
multiPrint:	push	bc,de
	ld	a,(de)
	ld	e,a
	call	selectOut
	pop	de,bc
	ld	a,(de)
	inc	de
	cp	10
	jr	nz,multiPrint
	pop	de
	djnz	nextLine
	pop	hl,de,bc,af
	djnz	printBits
	ret
;
outTable	equ	$
