#include "stdio.h"
#include "string.h"
#include "scc.h"

#ifdef SIGNED_SAMPLES
	#define MAX_OUTPUT 0x7fff
#else
	#define MAX_OUTPUT 0xffff
#endif

#define STEP 0x8000

#define DATACONV(A) ((A) / (256))

#define SCC_AVOL 0x8a
#define SCC_BVOL 0x8b
#define SCC_CVOL 0x8c
#define SCC_DVOL 0x8d
#define SCC_EVOL 0x8e

#define SCC_ONOFF 0x8f

#define SCC_AFINE 0x80
#define SCC_ACOARSE 0x81
#define SCC_BFINE 0x82
#define SCC_BCOARSE 0x83
#define SCC_CFINE 0x84
#define SCC_CCOARSE 0x85
#define SCC_DFINE 0x86
#define SCC_DCOARSE 0x87
#define SCC_EFINE 0x88
#define SCC_ECOARSE 0x89

struct SCC
{
	int Channel;
	int SampleRate;
	int register_latch;
	int Regs[256];
        int Wave[32];
	unsigned int UpdateStep;
	int PeriodA,PeriodB,PeriodC,PeriodD,PeriodE;
	int CountA,CountB,CountC,CountD,CountE;
	unsigned int VolA,VolB,VolC,VolD,VolE;
	unsigned char OutputA,OutputB,OutputC,OutputD,OutputE;
	signed char CountEnv;
	unsigned char Hold,Alternate,Attack,Holding;
	int RNG;
	int VolTable[32];
        int va,vb,vc;
};

static struct SCC Scc;

void SccWriteReg(int reg, int data)
{
   int old;
   struct SCC *s=&Scc;
   s->Regs[reg]=data;
   if(reg<32) {s->Wave[reg]=data;}
   switch(reg)
   {
	case SCC_AVOL:
		s->Regs[SCC_AVOL] &= 0xf;
		s->VolA = s->VolTable[s->Regs[SCC_AVOL] ? s->Regs[SCC_AVOL]*2+1 : 0];
                s->va=data;
		break;
	case SCC_BVOL:
		s->Regs[SCC_BVOL] &= 0xf;
		s->VolB = s->VolTable[s->Regs[SCC_BVOL] ? s->Regs[SCC_BVOL]*2+1 : 0];
                s->vb=data;
		break;
	case SCC_CVOL:
		s->Regs[SCC_CVOL] &= 0xf;
		s->VolC = s->VolTable[s->Regs[SCC_CVOL] ? s->Regs[SCC_CVOL]*2+1 : 0];
                s->vc=data;

		break;
	case SCC_DVOL:
		s->Regs[SCC_DVOL] &= 0xf;
		s->VolD = s->VolTable[s->Regs[SCC_DVOL] ? s->Regs[SCC_DVOL]*2+1 : 0];
		break;
	case SCC_EVOL:
		s->Regs[SCC_EVOL] &= 0xf;
		s->VolE = s->VolTable[s->Regs[SCC_EVOL] ? s->Regs[SCC_EVOL]*2+1 : 0];
		break;


	case SCC_AFINE:
	case SCC_ACOARSE:
		s->Regs[SCC_ACOARSE] &= 0x0f;
		old = s->PeriodA;
		s->PeriodA = (s->Regs[SCC_AFINE] + 256 * s->Regs[SCC_ACOARSE]) * s->UpdateStep;
		if (s->PeriodA == 0) s->PeriodA = s->UpdateStep;
		s->CountA += s->PeriodA - old;
		if (s->CountA <= 0) s->CountA = 1;
		break;

        case SCC_BFINE:
	case SCC_BCOARSE:
		s->Regs[SCC_BCOARSE] &= 0x0f;
		old = s->PeriodB;
		s->PeriodB = (s->Regs[SCC_BFINE] + 256 * s->Regs[SCC_BCOARSE]) * s->UpdateStep;
		if (s->PeriodB == 0) s->PeriodB = s->UpdateStep;
		s->CountB += s->PeriodB - old;
		if (s->CountB <= 0) s->CountB = 1;
		break;

        case SCC_CFINE:
	case SCC_CCOARSE:
		s->Regs[SCC_CCOARSE] &= 0x0f;
		old = s->PeriodC;
		s->PeriodC = (s->Regs[SCC_CFINE] + 256 * s->Regs[SCC_CCOARSE]) * s->UpdateStep;
		if (s->PeriodC == 0) s->PeriodC = s->UpdateStep;
		s->CountC += s->PeriodC - old;
		if (s->CountC <= 0) s->CountC = 1;
		break;

        case SCC_DFINE:
	case SCC_DCOARSE:
		s->Regs[SCC_DCOARSE] &= 0x0f;
		old = s->PeriodD;
		s->PeriodD = (s->Regs[SCC_DFINE] + 256 * s->Regs[SCC_DCOARSE]) * s->UpdateStep;
		if (s->PeriodD == 0) s->PeriodD = s->UpdateStep;
		s->CountD += s->PeriodD - old;
		if (s->CountD <= 0) s->CountD = 1;
		break;
        case SCC_EFINE:
	case SCC_ECOARSE:
		s->Regs[SCC_ECOARSE] &= 0x0f;
		old = s->PeriodE;
		s->PeriodE = (s->Regs[SCC_EFINE] + 256 * s->Regs[SCC_ECOARSE]) * s->UpdateStep;
		if (s->PeriodE == 0) s->PeriodE = s->UpdateStep;
		s->CountE += s->PeriodE - old;
		if (s->CountE <= 0) s->CountE = 1;
		break;

        case SCC_ONOFF:
             break;
        }
}

void SccUpdate(void **buffer, int length)
{
   struct SCC *s=&Scc;
	unsigned char *buf1,*buf2,*buf3,*buf4,*buf5;
	int outn;
        static int tesa=0,mesa=0,tesb=0,mesb=0,cola=0,colb=0,tesc=0,mesc=0,colc=0,cold=0,cole=0,mesd=0,mese=0,tesd=0,tese=0;
        int vola,volb,volc;
//        tempodesom=uclock();
	buf1 = (unsigned char *)buffer[0];
	buf2 = (unsigned char *)buffer[1];
	buf3 = (unsigned char *)buffer[2];
        buf4 = (unsigned char *)buffer[3];
        buf5 = (unsigned char *)buffer[4];
//        tesa=0;mesa=0;
//        tesb=0;mesb=0;

        while (length)
        {
		int vola,volb,volc,vold,vole;
	int left=STEP;
        do
        {
                int nextevent;
                nextevent=0x8000;

		if (s->OutputA) vola += s->CountA;
		s->CountA -= nextevent;
		/* PeriodA is the half period of the square wave. Here, in each */
		/* loop I add PeriodA twice, so that at the end of the loop the */
		/* square wave is in the same status (0 or 1) it was at the start. */
		/* vola is also incremented by PeriodA, since the wave has been 1 */
		/* exactly half of the time, regardless of the initial position. */
		/* If we exit the loop in the middle, OutputA has to be inverted */
		/* and vola incremented only if the exit status of the square */
		/* wave is 1. */
		while (s->CountA <= 0)
                	{
			s->CountA += s->PeriodA;
			if (s->CountA > 0)
			{
				s->OutputA ^= 1;
                                //tesa+=1; if(tesa==32) tesa=0;
//                                if(s->OutputA == 32) s->OutputA=0;
				if (s->OutputA) vola += s->PeriodA;
				break;
			}
			s->CountA += s->PeriodA;
			vola += s->PeriodA;
                }
//                vola = s->Regs[s->OutputA+128];

		if (s->OutputB) volb += s->CountB;
		s->CountB -= nextevent;
		/* PeriodA is the half period of the square wave. Here, in each */
		/* loop I add PeriodA twice, so that at the end of the loop the */
		/* square wave is in the same status (0 or 1) it was at the start. */
		/* vola is also incremented by PeriodA, since the wave has been 1 */
		/* exactly half of the time, regardless of the initial position. */
		/* If we exit the loop in the middle, OutputA has to be inverted */
		/* and vola incremented only if the exit status of the square */
		/* wave is 1. */
		while (s->CountB <= 0)
                	{
			s->CountB += s->PeriodB;
			if (s->CountB > 0)
			{
				s->OutputB ^= 1;
//                                tesb+=1; if(tesb==32) tesb=0;
//                                if(s->OutputA == 32) s->OutputA=0;
				if (s->OutputB) volb += s->PeriodB;
				break;
			}
			s->CountB += s->PeriodB;
			volb += s->PeriodB;
                }

		if (s->OutputC) volc += s->CountC;
		s->CountC -= nextevent;
		/* PeriodA is the half period of the square wave. Here, in each */
		/* loop I add PeriodA twice, so that at the end of the loop the */
		/* square wave is in the same status (0 or 1) it was at the start. */
		/* vola is also incremented by PeriodA, since the wave has been 1 */
		/* exactly half of the time, regardless of the initial position. */
		/* If we exit the loop in the middle, OutputA has to be inverted */
		/* and vola incremented only if the exit status of the square */
		/* wave is 1. */
		while (s->CountC <= 0)
                	{
			s->CountC += s->PeriodC;
			if (s->CountC > 0)
			{
				s->OutputC ^= 1;
//                                tesb+=1; if(tesb==32) tesb=0;
//                                if(s->OutputC == 32) s->OutputC=0;
				if (s->OutputC) volc += s->PeriodC;
				break;
			}
			s->CountC += s->PeriodC;
			volc += s->PeriodC;
                }

		if (s->OutputD) vold += s->CountD;
		s->CountD -= nextevent;
		/* PeriodA is the half period of the square wave. Here, in each */
		/* loop I add PeriodA twice, so that at the end of the loop the */
		/* square wave is in the same status (0 or 1) it was at the start. */
		/* vola is also incremented by PeriodA, since the wave has been 1 */
		/* exactly half of the time, regardless of the initial position. */
		/* If we exit the loop in the middle, OutputA has to be inverted */
		/* and vola incremented only if the exit status of the square */
		/* wave is 1. */
		while (s->CountD <= 0)
                	{
			s->CountD += s->PeriodD;
			if (s->CountD > 0)
			{
				s->OutputD ^= 1;
//                                tesb+=1; if(tesb==32) tesb=0;
//                                if(s->OutputC == 32) s->OutputC=0;
				if (s->OutputD) vold += s->PeriodD;
				break;
			}
			s->CountD += s->PeriodD;
			vold += s->PeriodD;
                }
		if (s->OutputE) vole += s->CountE;
		s->CountE -= nextevent;
		/* PeriodA is the half period of the square wave. Here, in each */
		/* loop I add PeriodA twice, so that at the end of the loop the */
		/* square wave is in the same status (0 or 1) it was at the start. */
		/* vola is also incremented by PeriodA, since the wave has been 1 */
		/* exactly half of the time, regardless of the initial position. */
		/* If we exit the loop in the middle, OutputA has to be inverted */
		/* and vola incremented only if the exit status of the square */
		/* wave is 1. */
		while (s->CountE <= 0)
                	{
			s->CountE += s->PeriodE;
			if (s->CountE > 0)
			{
				s->OutputE ^= 1;
//                                tesb+=1; if(tesb==32) tesb=0;
//                                if(s->OutputC == 32) s->OutputC=0;
				if (s->OutputE) vole += s->PeriodE;
				break;
			}
			s->CountE += s->PeriodE;
			vole += s->PeriodE;
                }
//                vola = s->Regs[s->OutputA+128];

                left -= nextevent;
        } while (left > 0);

                if((s->OutputA!=cola)&& (SCC_ONOFF&1))tesa+=1;
                if(tesa==32)tesa=0;
                cola=s->OutputA;
                if((s->OutputB!=colb)&& (SCC_ONOFF&2))tesb+=1;
                if(tesb==32)tesb=0;
                colb=s->OutputB;
                if((s->OutputC!=colc)&& (SCC_ONOFF&4))tesc+=1;
                if(tesc==32)tesc=0;
                colc=s->OutputC;
                if((s->OutputD!=cold)&& (SCC_ONOFF&8))tesd+=1;
                if(tesd==32)tesd=0;
                cold=s->OutputD;
                if((s->OutputE!=cole)&& (SCC_ONOFF&16))tese+=1;
                if(tese==32)tese=0;
                cole=s->OutputE;

                mesa=s->Regs[tesa];
//                mesa&=0xff;
//                if(mesa>=128) mesa=127-mesa;
//                mesa+=128;

                mesb=s->Regs[tesb+32];
//                mesb&=0xff;
//                if(mesb>=128) mesb=127-mesb;
//                mesb+=128;

                mesc=s->Regs[tesc+64];
//                mesc&=0xff;
//                if(mesc>=128) mesc=127-mesc;
//                mesc+=128;

                mesd=s->Regs[tesd+96];
//                mesd&=0xff;
//                if(mesd>=128) mesd=127-mesd;
//                mesd+=128;

                mese=s->Regs[tese+96];
//                mese&=0xff;
//                if(mese>=128) mese=127-mese;
//                mese+=128;

                *(buf1++) = DATACONV((((s->VolA/1)* vola)/1));
		*(buf2++) = DATACONV((((s->VolB/1)* volb)/1));
		*(buf3++) = DATACONV((((s->VolC/1)* volc)/1));
		*(buf4++) = DATACONV((((s->VolD/1)* vold)/1));
		*(buf5++) = DATACONV((((s->VolE/1)* vole)/1));

		length--;

        }

}

void Scc_set_volume(int volume,int gain)
{
	int i;
	double out;
   struct SCC *s=&Scc;


//	stream_set_volume(PSG->Channel,volume);
//	stream_set_volume(PSG->Channel+1,volume);
//	stream_set_volume(PSG->Channel+2,volume);

	gain &= 0xff;

	/* increase max output basing on gain (0.2 dB per step) */
	out = MAX_OUTPUT;
	while (gain-- > 0)
		out *= 1.023292992;	/* = (10 ^ (0.2/20)) */

	/* calculate the volume->voltage conversion table */
	/* The AY-3-8910 has 16 levels, in a logarithmic scale (3dB per step) */
	/* The YM2149 still has 16 levels for the tone generators, but 32 for */
	/* the envelope generator (1.5dB per step). */
	for (i = 31;i > 0;i--)
	{
		/* limit volume to avoid clipping */
		if (out > MAX_OUTPUT) s->VolTable[i] = MAX_OUTPUT;
		else s->VolTable[i] = out;

		out /= 1.188502227;	/* = 10 ^ (1.5/20) = 1.5dB */
	}
	s->VolTable[0] = 0;
}

int Scc_init(const char *chipname,int clock,int sample_rate,int sample_bits)
{
	int i;
	char buf[3][40];
	const char *name[3];
   struct SCC *s=&Scc;


	memset(&Scc,0,sizeof(struct SCC));
	s->SampleRate = sample_rate;
	for (i = 0;i < 3;i++)
	{
		name[i] = buf[i];
		sprintf(buf[i],"%s Ch %c",chipname,'A'+i);
	}

/*	PSG->Channel = stream_init_multi(3,
			name,sample_rate,sample_bits,
			chip,(sample_bits == 16) ? AY8910Update_16 : AY8910Update_8);

	if (PSG->Channel == -1)
		return 1;        */

	Scc_set_clock(clock);
	Scc_set_volume(255,0);
	Scc_reset();

	return 0;

}

void Scc_reset(void)
{
	int i;
   struct SCC *s=&Scc;

	s->register_latch = 0;
	s->RNG = 1;
	s->OutputA = 0;
	s->OutputB = 0;
	s->OutputC = 0;
	s->OutputD = 0;
	s->OutputE = 0;
	for (i = 0;i < 256;i++)
		SccWriteReg(i,0);	/* AYWriteReg() uses the timer system; we cannot */
								/* call it at this time because the timer system */
								/* has not been initialized. */
}

void Scc_set_clock(int clock)
{
   struct SCC *s=&Scc;

	/* the step clock for the tone and noise generators is the chip clock    */
	/* divided by 8; for the envelope generator of the AY-3-8910, it is half */
	/* that much (clock/16), but the envelope of the YM2149 goes twice as    */
	/* fast, therefore again clock/8.                                        */
	/* Here we calculate the number of steps which happen during one sample  */
	/* at the given sample rate. No. of events = sample rate / (clock/8).    */
	/* STEP is a multiplier used to turn the fraction into a fixed point     */
	/* number.                                                               */
	s->UpdateStep = (int)(((double)STEP * s->SampleRate * 8) / clock);
}

