#include <pc.h>
#include <sys/farptr.h>
#include <sys/segments.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <time.h>
#include "allegro.h"
#include "audio.h"
#include "tipos.h"
#include "z80.h"
#include "vdp.h"
#include "AY8910.h"
#include "scc.h"
#include "debug.h"

#define TAMPPI 8
#define C8K 1
#define C16K0 2
#define C16K1 3
#define C16K2 4
#define C32K1 5
#define C32K0 6
#define C48K  7
#define C64K  8

#define NORMALX 0
#define DOUBLEX 1
#define INTERPX 2

#define NORMALY 0
#define SCANLINES 1
#define DOUBLEY 2
#define I50 3
#define I75 4
#define I87 5
#define INTERPY 6

#define MSX1ROM0  1
#define MSX1ROM1 2
#define CART1P0  3
#define CART1P1  4
#define CART1P2  5
#define CART1P3  6
#define CART2P0  7
#define CART2P1  8
#define CART2P2  9
#define CART2P3  10


#define Z80FREQ (3579545)

typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef unsigned long UINT32;

AUDIOINFO info;
AUDIOWAVE wave[9];
AUDIOWAVE quieto;
HAC voice[9];

int tratamenu(void);
int cartamenu(void);
int cartbmenu(void);
int diskamenu(void);
int diskbmenu(void);
int tapemenu(void);
int SaiMSX(void);
int aboutmenu(void);
int vidmenu(void);
int zeroframe(void);
int umframe(void);
int doisframe(void);
int tresframe(void);
int resetmenu(void);
int rendermenu(void);
int soundmenu(void);
int savescreenbmp(void);
int savescreenpcx(void);
int savescreentga(void);
int diskmanager(void);
int tapemanager(void);
int normalxmenu(void);
int doublexmenu(void);
int interpolaxmenu(void);
int normalymenu(void);
int doubleymenu(void);
int scanlinesmenu(void);
int i50menu(void);
int i75menu(void);
int i87menu(void);
int debug_menu(void);
int savestate(void);
int loadstate(void);
int savestatemesmo(char*);
int loadstatemesmo(char*);
void freememoria();
void setGUI(void);


void atualiza_vga();
void atualiza_v2_1_1();
void atualiza_v2_2_1();
void atualiza_v2_1_2s();
void atualiza_v2_2_2s();
void atualiza_v2_1_2d();
void atualiza_v2_2_2d();
void atualiza_v2_1_2t();
void atualiza_v2_2_2t();

void atualiza_v2_2i_1();
void atualiza_v2_2i_2s();
void atualiza_v2_2i_2t();
void atualiza_v2_2i_2d();
void atual_borda_s();
void disable_screen();


int atual_som_a(void* dp3, int d2);
int atual_som_b(void* dp3, int d2);
int atual_som_c(void* dp3, int d2);
int atual_som_ppi(void* dp3, int d2);
int atual_bal_a(void* dp3, int d2);
int atual_bal_b(void* dp3, int d2);
int atual_bal_c(void* dp3, int d2);
int atual_bal_ppi(void* dp3, int d2);
int atual_som_master(void* dp3, int d2);

void trocarenderxmode();
void trocarenderymode();

void ParaSom();
void ContSom();

UINT8 *cria_carrega_arq(FILE* fp, int tam);

void (*atualiza_tela)(void);

class VDP vdp;

void ((*linescreen[4]))(byte);
    

long AUDIOposition[9], chSize[9], chPosition[9];


static int tabinterpola[256];
static int tabatenua[256];

struct s_tabtoken
{
  char token[20];
  int posicao;
  int posicao2;
  int ps;
  int ss;
};

struct s_tabtoken tabtoken[512];
int postoken=0;

RGB msx_cores[]=
  {{0x00,0x00,0x00},
     {0x00,0x00,0x00},
     {0x20>>2,0xc0>>2,0x20>>2},
     {0x60>>2,0xe0>>2,0x60>>2},
     {0x20>>2,0x20>>2,0xe0>>2},
     {0x40>>2,0x60>>2,0xe0>>2},
     {0xa0>>2,0x20>>2,0x20>>2},
     {0x40>>2,0xc0>>2,0xe0>>2},
     {0xe0>>2,0x20>>2,0x20>>2},
     {0xe0>>2,0x60>>2,0x60>>2},
     {0xc0>>2,0xc0>>2,0x20>>2},
     {0xc0>>2,0xc0>>2,0x80>>2},
     {0x20>>2,0x80>>2,0x20>>2},
     {0xc0>>2,0x40>>2,0xa0>>2},
     {0xa0>>2,0xa0>>2,0xa0>>2},
     {0xe0>>2,0xe0>>2,0xe0>>2}};



int nvoices=4;

int iniciar_debugger;
int Placa, ResX, ResY, trocarres;
UINT32 Somligado;
BITMAP *minha_tela;
UINT32 Nframeskip;
UINT32 Tipomegarom;
UINT8 tipocartucho;
UINT8 megarom[4][4];
UINT8 megaram[4][4];
UINT8 mapper[4][4];
UINT8 memmapper[4][4][4]={{{3,2,1,0},{3,2,1,0},{3,2,1,0},{3,2,1,0}},
                          {{3,2,1,0},{3,2,1,0},{3,2,1,0},{3,2,1,0}},
                          {{3,2,1,0},{3,2,1,0},{3,2,1,0},{3,2,1,0}},
                          {{3,2,1,0},{3,2,1,0},{3,2,1,0},{3,2,1,0}}};

UINT8 memmegarom[4][4][8]={{{0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5}},

                           {{0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5}},

                           {{0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5}},

                           {{0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5},
                            {0,1,0,1,2,3,4,5}}};

UINT8 PSAtual[4];
UINT8 SSAtual[4];
int vdpline;
UINT8 mudoufundo=0;
UINT8 volumeMestre=100;
UINT8 resetar;
UINT8 *mem[8];
double numerodeframes;
int framespersecond;

extern int debug_linhas;
long int chunkPosition=0;


            //Depois a parte de memoria vai ficar assim
		 
UINT8 *Msx[4][4][8]={
 {{0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0}},
  
 {{0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0}},

 {{0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0}},

 {{0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0}}
};

UINT8 IsExpanded[4]={0,0,0,0};
UINT8 SlotExpanded[4]={0,0,0,0};

UINT8 RomP[4][4][8]={
{{1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1}},

{{1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1}},

{{1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1}},

{{1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1},
 {1,1,1,1,1,1,1,1}}
};

UINT8 RomPNow[8];


UINT8 *memoria[32]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
UINT8 *goon[4][4]= {{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}};
UINT8 *pmegaram[4][4]={{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}};
UINT8 *pmapper[4][4]= {{0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0}};
UINT8 *vazio;
UINT8 *msx_disk;
int Iniciox, Inicioy;
int Inicioxvdp, Inicioyvdp;
int contasamples;
int samplespassados;
int samplesfinal;
int auxcontaciclosz80;
UINT32 meusoundRate;
static int sndbackx[18];
static int sndbacky[18];
int z80perframe;
int z80pervdpline;
int CiclesVblank;

int Renderx=DOUBLEX;
int Rendery=I75;
int frameskip=0;
uclock_t relogio=0, relantigo=0, tempodeframe;
UINT8 linha_teclado=0;
UINT8 Porta_a8;
UINT8 Porta_a9;
UINT8 Porta_aa;
UINT8 Porta_ab;
UINT8 Porta_8e;

UINT8 *Nmdriveb, *Nmdrivea, *Nmtape, *Nmcarta, *Nmcartb;
Z80 *pointz80;
int ciclospassadosanterior;

FILE *trace;
FILE *tape;
FILE *drivea;
FILE *driveb;
UINT8 MSXDrive;
int driveawrite;
int diskPresentA;

UINT8 Porta_98;
UINT8 Porta_99;

void Out_aa(UINT16, UINT8);
void Out_a8(UINT16, UINT8);
void Out_98(UINT8);
void Out_99(UINT8);

UINT8 In_99();
UINT8 In_98();
UINT16 In_a8(UINT16);
UINT16 In_a9(UINT16);
UINT16 In_aa(UINT16);
UINT8 cpu_readop(UINT16);

static MENU menufile[]=
{
  {"CartA",      cartamenu,      NULL},
  {"CartB",      cartbmenu,      NULL},
  {"DiskA",      diskamenu,      NULL},
  {"DiskB",      diskbmenu,      NULL},
  {"Tape",       tapemenu,       NULL},
  {"Reset",      resetmenu,      NULL},
  {"Exit",       SaiMSX,         NULL},
  {NULL}
};

static MENU framemenu[]=
{
  {"0",      zeroframe, NULL, D_SELECTED},
  {"1",      umframe, NULL},
  {"2",      doisframe, NULL},
  {"3",      tresframe, NULL},
  {NULL}
};

static MENU gfxrendermenu[]=
{
  {"X render", NULL, NULL, D_DISABLED},
  {"Normal",   normalxmenu, NULL},
  {"Double",   doublexmenu, NULL},
  {"Interpolation",interpolaxmenu, NULL},
  {"Y render", NULL, NULL, D_DISABLED},
  {"Normal",   normalymenu, NULL},
  {"Double",   doubleymenu, NULL},
  {"Scanlines",scanlinesmenu, NULL},
  {"Intensity 50%",i50menu, NULL},
  {"Intensity 75%",i75menu, NULL},
  {"Intensity 87%",i87menu, NULL},
  {NULL}
};

static MENU menucfg[]=
{
  {"Frameskip",   NULL,      framemenu},
  {"Video",    vidmenu,      NULL},
  {"Render Mode", NULL,      gfxrendermenu},
  {"Sound",    soundmenu,      NULL},
  {"Keyboard", tratamenu,      NULL, D_DISABLED},
  {NULL}
};


static MENU menuhelp[]=
{
  {"About",     aboutmenu,      NULL},
  {NULL}
};

static MENU savescreenmenu[]=
{
  {"PCX", savescreenpcx, NULL},
  {"BMP", savescreenbmp, NULL},
  {"TGA", savescreentga, NULL},
  {NULL}
};

static MENU menutools[]=
{
  {"Save screen", NULL, savescreenmenu},
  {"Disk manager",diskmanager, NULL, D_DISABLED},
  {"Tape manager",tapemanager, NULL, D_DISABLED},
  {"Save state",savestate,NULL},
  {"Load state",loadstate,NULL},
  {"Debugger",debug_menu, NULL},
  {NULL}
};

static MENU msxmenu[]=
{
  {"File",        NULL,    menufile},
  {"Config",      NULL,    menucfg},
  {"Tools",       NULL,    menutools},
  {"Help",        NULL,    menuhelp},
  {NULL,          NULL,         NULL   }
};

static DIALOG msxgui[]=
{
  {
    d_menu_proc,
    0,0,0,0,
    0,0,
    65,
    0,
    0,0,
    msxmenu
  },
  {NULL}
};

static DIALOG snd_dialog[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp)     (dp2)          (dp3) */
   { d_shadow_box_proc, 0,   0,   200,   140,   1,    15},
   { d_slider_proc,     8,   32,   64,  8,   6,    14,    0,    0,       64,  64,    NULL,    atual_som_a },
   { d_slider_proc,     8,   48,   64,  8,   6,    14,    0,    0,       64,  64,    NULL,    atual_som_b },
   { d_slider_proc,     8,   64,   64,  8,   6,    14,    0,    0,       64,  64,    NULL,    atual_som_c },
   { d_slider_proc,     8,   80,   64,  8,   6,    14,    0,    0,       64,  64,    NULL,    atual_som_ppi },
   { d_slider_proc,     8,  96,   64,  8,   6,    14,    0,    0,       100,  100,    NULL,    atual_som_master },
   { d_slider_proc,     120, 32,  64,  8,   6,    14,    0,    0,       255,  128,    NULL,    atual_bal_a},
   { d_slider_proc,     120, 48,  64,  8,   6,    14,    0,    0,       255,  128,    NULL,    atual_bal_b},
   { d_slider_proc,     120, 64,  64,  8,   6,    14,    0,    0,       255,  128,    NULL,    atual_bal_c},
   { d_slider_proc,     120, 80,  64,  8,   6,    14,    0,    0,       255,  128,    NULL,    atual_bal_ppi},
   { d_text_proc,       16,16,    0,   0,   4,    15,    0,    0,        0,   0,     (void*)"Volume"},
   { d_text_proc,       130,16,   0,   0,   4,    15,    0,    0,        0,   0,     (void*)"Balance"},
   { d_text_proc,       76,  32,   0,    0,    4,  15,    0,    0,       0,    0,    (void*)"PSG A"  },
   { d_text_proc,       76,  48,   0,    0,    4,  15,    0,    0,       0,    0,    (void*)"PSG B"  },
   { d_text_proc,       76,  64,  0,    0,    4,  15,    0,    0,       0,    0,    (void*)"PSG C"  },
   { d_text_proc,       76,  80,  0,    0,    4,  15,    0,    0,       0,    0,    (void*)"PPI"  },
   { d_text_proc,       76,  96,  0,    0,    4,  15,    0,    0,       0,    0,    (void*)"Master"  },
   { d_button_proc,     90, 112,  32,   16,   1,  15,    0,    D_EXIT,       0,    0,   (void*)"Ok"},
   { NULL,              0,    0,    0,    0,    0,    15,    0,    0,       0,    0,    NULL }
};


int PPISound(char);
int DiskRead(int, UINT8*, int);
int DiskWrite(int, UINT8*, int);

void Desenha_tela(void);
void SomInit(void);
void SomPlay(void);
void SomSai(void);
void CarregaRom(FILE*, int, int);
void setscreen(int, int, int);



void AY8910Update_8(void **buffer,int length);
int AY8910_init(const char *chipname,int clock,int sample_rate,int sample_bits,
		int (*portAread)(int offset),int (*portBread)(int offset),
		void (*portAwrite)(int offset,int data),void (*portBwrite)(int offset,int data));

int PSG14Read(int offset);
void PSG14Write(int offset, int v);
int PSG15Read(int offset);
void PSG15Write(int offset,int v);



BEGIN_GFX_DRIVER_LIST
   GFX_DRIVER_VGA
   GFX_DRIVER_VESA2L
   GFX_DRIVER_VESA2B
   GFX_DRIVER_VESA1
END_GFX_DRIVER_LIST


BEGIN_MIDI_DRIVER_LIST
END_MIDI_DRIVER_LIST

BEGIN_DIGI_DRIVER_LIST
END_DIGI_DRIVER_LIST

BEGIN_JOYSTICK_DRIVER_LIST
END_JOYSTICK_DRIVER_LIST

UINT8 In_98()
{
  return vdp.in98();
}

UINT8 In_99()
{
  return vdp.in99();
}

void Out_98(UINT8 dado)
{
  vdp.out98(dado);
}


void Out_99(unsigned char dado)
{
  vdp.out99(dado);
}

int atual_som_a(void* dp3, int d2)
{
  ASetVoiceVolume(voice[0],d2);
  return D_O_K;
}

int atual_som_b(void* dp3, int d2)
{
  ASetVoiceVolume(voice[1],d2);
  return D_O_K;
}

int atual_som_c(void* dp3, int d2)
{
  ASetVoiceVolume(voice[2],d2);
  return D_O_K;
}

int atual_som_ppi(void* dp3, int d2)
{
  ASetVoiceVolume(voice[3],d2);
  return D_O_K;
}

int atual_bal_a(void* dp3, int d2)
{
  ASetVoicePanning(voice[0],d2);
  return D_O_K;
}

int atual_bal_b(void* dp3, int d2)
{
  ASetVoicePanning(voice[1],d2);
  return D_O_K;
}

int atual_bal_c(void* dp3, int d2)
{
  ASetVoicePanning(voice[2],d2);
  return D_O_K;
}

int atual_bal_ppi(void* dp3, int d2)
{
  ASetVoicePanning(voice[3],d2);
  return D_O_K;
}

int atual_som_master(void* dp3, int d2)
{
  volumeMestre=d2;
  return D_O_K;
}

byte RdZ80(word A)
{
  if(A!=0xFFFF)
    return(mem[A>>13][A&0x1FFF]);
  else if(IsExpanded[Porta_a8>>6]) return ~(SlotExpanded[Porta_a8>>6]);
       else return(mem[A>>13][A&0x1FFF]);
}

void WrZ80(register word end,register byte dado)
{
  int ddd;
  ddd=dado;
  if (end!=0xFFFF)
  {
    int sl;
    int tammega,tammegarom;
    sl=PSAtual[end>>14];
    if (!(tammegarom=megarom[sl][IsExpanded[sl]?(SlotExpanded[sl]>>(end>>14<<1))&3:0]))
    {
      if (!(tammega=megaram[sl][IsExpanded[sl]?(SlotExpanded[sl]>>(end>>14<<1))&3:0]))
      {
        if(!RomPNow[end>>13]) mem[end>>13][end&0x1FFF]=dado;
      }
      else
      {
        if(Porta_8e==0)
        {
          mem[end>>13][end&0x1FFF]=dado;
        }
        else
        {
          dado%=tammega;
          memmegarom[sl][IsExpanded[sl]?(SlotExpanded[sl]>>(end>>14<<1))&3:0][end>>13]=dado;
          mem[end>>13]=pmegaram[sl][(IsExpanded[sl]?SlotExpanded[sl]>>(end>>14<<1)&3:0)]+(dado<<13);
        }
      }
    }
    else
    {
      dado%=tammegarom;
      if (Tipomegarom==0)
      {
        if (end>=0x9800 && end<=0x98e0)
        {
          SccWriteReg(end-0x9800,ddd);
        }
        else
        {
          memmegarom[sl][IsExpanded[sl]?(SlotExpanded[sl]>>(end>>14<<1))&3:0][end>>13]=dado;
          mem[end>>13]=goon[sl][(IsExpanded[sl]?SlotExpanded[sl]>>(end>>14<<1)&3:0)]+(dado<<13);
        }
      }
      else if (Tipomegarom==1)
      {
        memmegarom[sl][IsExpanded[sl]?(SlotExpanded[sl]>>(end>>14<<1))&3:0][(end-0x2000)>>11]=dado;
        mem[(end>>11)-10]=goon[sl][(IsExpanded[sl]?SlotExpanded[sl]>>(end>>14<<1)&3:0)]+(dado<<13);
      }
      else if (Tipomegarom==2)
      {
        if(end>=0x6000 && end<=0x67ff) {
          memmegarom[sl][IsExpanded[sl]?(SlotExpanded[sl]>>(end>>14<<1))&3:0][2]=dado*2;
          memmegarom[sl][IsExpanded[sl]?(SlotExpanded[sl]>>(end>>14<<1))&3:0][3]=dado*2+1;
          mem[2]=goon[sl][(IsExpanded[sl]?SlotExpanded[sl]>>(end>>14<<1)&3:0)]+(dado<<14);
          mem[3]=goon[sl][(IsExpanded[sl]?SlotExpanded[sl]>>(end>>14<<1)&3:0)]+(dado<<14)+0x2000;
        }
        if(end>=0x7000 && end<=0x77ff) {
          memmegarom[sl][IsExpanded[sl]?(SlotExpanded[sl]>>(end>>14<<1))&3:0][4]=dado*2;
          memmegarom[sl][IsExpanded[sl]?(SlotExpanded[sl]>>(end>>14<<1))&3:0][5]=dado*2+1;
          mem[4]=goon[sl][(IsExpanded[sl]?SlotExpanded[sl]>>(end>>14<<1)&3:0)]+(dado<<14);
          mem[5]=goon[sl][(IsExpanded[sl]?SlotExpanded[sl]>>(end>>14<<1)&3:0)]+(dado<<14)+0x2000;
        }

      }
    }
  }
  else
  {
    int tammapper;
    if(IsExpanded[PSAtual[3]])
    {
//      fprintf(trace,"     FFFF=%X\n",dado);
      SlotExpanded[PSAtual[3]]=dado;
      SSAtual[0]=dado&3;
      SSAtual[1]=(dado>>2)&3;
      SSAtual[2]=(dado>>4)&3;
      SSAtual[3]=(dado>>6)&3;

      if((PSAtual[3])==(PSAtual[0]))
      {
      tammapper=(mapper[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]]&3):0]);
      if (tammapper)
        {
          mem[0]=pmapper[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]]&3):0] +((memmapper[PSAtual[0]][IsExpanded[PSAtual[0]]?SlotExpanded[PSAtual[0]]&3:0][0])<<14);
          mem[1]=pmapper[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]]&3):0]+ ((memmapper[PSAtual[0]][IsExpanded[PSAtual[0]]?SlotExpanded[PSAtual[0]]&3:0][0])<<14)+0x2000;
          RomPNow[0]=RomP[PSAtual[0]][SSAtual[0]][0];
          RomPNow[1]=RomP[PSAtual[0]][SSAtual[0]][1];
        }
        else
        {
          mem[0]=     Msx[PSAtual[3]][SSAtual[0]][0];
          mem[1]=     Msx[PSAtual[3]][SSAtual[0]][1];
          RomPNow[0]=RomP[PSAtual[3]][SSAtual[0]][0];
          RomPNow[1]=RomP[PSAtual[3]][SSAtual[0]][1];
        }
      }
      if((PSAtual[3])==(PSAtual[1]))
      {
        tammapper=(mapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0]);
        if (tammapper)
        {
          mem[2]=pmapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0]+((memmapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0][1])<<14);
          mem[3]=pmapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0]+((memmapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0][1])<<14)+0x2000;
          RomPNow[2]=RomP[PSAtual[3]][SSAtual[1]][2];
          RomPNow[3]=RomP[PSAtual[3]][SSAtual[1]][3];
        }
        else
        {
          mem[2]=     Msx[PSAtual[3]][SSAtual[1]][2];
          mem[3]=     Msx[PSAtual[3]][SSAtual[1]][3];
        }
      }
      if((PSAtual[3])==(PSAtual[2]))
      {
        tammapper=(mapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0]);
        if (tammapper)
        {
          mem[4]=pmapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0]+((memmapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0][2])<<14);
          mem[5]=pmapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0]+((memmapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0][2])<<14)+0x2000;
          RomPNow[4]=RomP[PSAtual[3]][SSAtual[2]][4];
          RomPNow[5]=RomP[PSAtual[3]][SSAtual[2]][5];
        }
        else
        {
          mem[4]=     Msx[PSAtual[3]][SSAtual[2]][4];
          mem[5]=     Msx[PSAtual[3]][SSAtual[2]][5];
          RomPNow[4]=RomP[PSAtual[3]][SSAtual[2]][4];
          RomPNow[5]=RomP[PSAtual[3]][SSAtual[2]][5];
        }
      }
      tammapper=(mapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0]);
      if (tammapper)
      {
          mem[6]=pmapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0]+((memmapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0][3])<<14);
          mem[7]=pmapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0]+((memmapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0][3])<<14)+0x2000;
          RomPNow[6]=RomP[PSAtual[3]][SSAtual[3]][6];
          RomPNow[7]=RomP[PSAtual[3]][SSAtual[3]][7];
      }
      else
      {
        mem[6]=     Msx[PSAtual[3]][SSAtual[3]][6];
        mem[7]=     Msx[PSAtual[3]][SSAtual[3]][7];
        RomPNow[6]=RomP[PSAtual[3]][SSAtual[3]][6];
        RomPNow[7]=RomP[PSAtual[3]][SSAtual[3]][7];
      }
    }
    else
      if(!RomPNow[3]) mem[7][0x1FFF]=dado;
  }
}

int tratamenu(void)
{
  text_mode(-1);
  return D_CLOSE;
}

int debug_menu(void)
{
  iniciar_debugger=1;
  return D_CLOSE;
}

int savestate(void)
{
  static char nome[120]="";
  if(file_select("Select file to Save", nome, "PWR"))
  {
    savestatemesmo(nome);
  }
  text_mode(-1);
  return D_CLOSE;
}

int loadstate(void)
{
  static char nome[120]="";
  if(file_select("Select file to Load", nome, "PWR"))
  {
    loadstatemesmo(nome);
  }
  text_mode(-1);
  return D_CLOSE;
}

int cartamenu(void)
{
  static char rom[120]="";
  FILE* fp;
//  rom[0]='\0';
  if(file_select("Select CartA ROM", rom, "ROM"))
  {
    fp=fopen(rom,"rb");
    CarregaRom(fp,1,0);
    fclose(fp);
    resetar=1;
  }
  text_mode(-1);
  clear_to_color(screen,1);
  return D_CLOSE;
}

int savestatemesmo(char *nm)
{
    int i,j,k;
    FILE* fp;
    fp=fopen(nm,"wb");
    fprintf(fp,"PowerMSX-Savestate");
    for(i=0;i<4;i++)
      for(j=0;j<4;j++)
        fprintf(fp,"%X,%X,%X,%X,%X,%X,%X,%X,",Msx[i][j][0]!=vazio,Msx[i][j][1]!=vazio,Msx[i][j][2]!=vazio,Msx[i][j][3]!=vazio,Msx[i][j][4]!=vazio,Msx[i][j][5]!=vazio,Msx[i][j][6]!=vazio,Msx[i][j][7]!=vazio);
    fprintf(fp,"%X,%X,%X,%X,",IsExpanded[0],IsExpanded[1],IsExpanded[2],IsExpanded[3]);
    for(i=0;i<4;i++)
    {
      fprintf(fp,"%X,%X,%X,%X,",goon[i][0]!=vazio,goon[i][1]!=vazio,goon[i][2]!=vazio,goon[i][3]!=vazio);

/*      if(goon[i][0]!=vazio)
      {
        n=-1;
        if(Msx[i][0][0]==goon[i][0]) n=0;
        if(Msx[i][0][1]==goon[i][0]) n=1;
        if(Msx[i][0][2]==goon[i][0]) n=2;
        if(Msx[i][0][3]==goon[i][0]) n=3;
        if(Msx[i][0][4]==goon[i][0]) n=4;
        fprintf(fp,"%X,",n);
      }
      if(goon[i][1]!=vazio)
      {
        n=-1;
        if(Msx[i][1][0]==goon[i][1]) n=0;
        if(Msx[i][1][1]==goon[i][1]) n=1;
        if(Msx[i][1][2]==goon[i][1]) n=2;
        if(Msx[i][1][3]==goon[i][1]) n=3;
        if(Msx[i][1][4]==goon[i][1]) n=4;
        fprintf(fp,"%X,",n);
      }
      if(goon[i][2]!=vazio)
      {
        n=-1;
        if(Msx[i][2][0]==goon[i][2]) n=0;
        if(Msx[i][2][1]==goon[i][2]) n=1;
        if(Msx[i][2][2]==goon[i][2]) n=2;
        if(Msx[i][2][3]==goon[i][2]) n=3;
        if(Msx[i][2][4]==goon[i][2]) n=4;
        fprintf(fp,"%X,",n);
      }
      if(goon[i][3]!=vazio)
      {
        n=-1;
        if(Msx[i][3][0]==goon[i][3]) n=0;
        if(Msx[i][3][1]==goon[i][3]) n=1;
        if(Msx[i][3][2]==goon[i][3]) n=2;
        if(Msx[i][3][3]==goon[i][3]) n=3;
        if(Msx[i][3][4]==goon[i][3]) n=4;
        fprintf(fp,"%X,",n);
      }      */
    }
    for(i=0;i<4;i++)
    {
      if(IsExpanded[i])
      {
      }
      else
      {
        for(k=0;k<8;k++)
        {
          if(goon[i][0]!=vazio)
          {
            fwrite(goon[i][0],32768,1,fp);
            break;
          }
          else if(Msx[i][0][k]!=vazio)
            fwrite(Msx[i][0][k],8192,1,fp);
        }
      }
    }
//    fwrite(vram,16384,1,fp);
    fprintf(fp,"%d,%d,%d,%d,%d,%d,%d,%d,",pointz80->PC.W,pointz80->SP.W,pointz80->AF.W,pointz80->BC.W,pointz80->DE.W,pointz80->HL.W,pointz80->I,pointz80->R);
    fprintf(fp,"%d,%d,%d,%d,%d,%d,%d,",pointz80->AF1.W,pointz80->BC1.W,pointz80->DE1.W,pointz80->HL1.W,pointz80->IX.W,pointz80->IY.W,pointz80->IFF);
//    fprintf(fp,"%d,%d,%d,%d,%d,%d,%d,%d,",vdp_modo[0],vdp_modo[1],vdp_modo[2],vdp_modo[3],vdp_modo[4],vdp_modo[5],vdp_modo[6],vdp_modo[7]);
//    fprintf(fp,"%d,",posvram);
    fprintf(fp,"%d",Porta_a8);
    fclose(fp);
    return 1;
}

int loadstatemesmo(char *nm)
{
    FILE* fp;
    int i,j,k;
    int pc,sp,af,bc,de,hl,ix,iy,af1,bc1,de1,hl1,im,r,iff;
    int pa8;
    int tb[4][4][8];
    int comc[4][4]={{2,2,2,2},{2,2,2,2},{2,2,2,2},{2,2,2,2}};
    fp=fopen(nm,"rb");
    fscanf(fp,"PowerMSX-Savestate");
    for(i=0;i<4;i++)
      for(j=0;j<4;j++)
        fscanf(fp,"%X,%X,%X,%X,%X,%X,%X,%X,",&tb[i][j][0],&tb[i][j][1],&tb[i][j][2],&tb[i][j][3],&tb[i][j][4],&tb[i][j][5],&tb[i][j][6],&tb[i][j][7]);
//    fscanf(fp,"%X,%X,%X,%X,",&IsExpanded[0],&IsExpanded[1],&IsExpanded[2],&IsExpanded[3]);
    for(i=0;i<4;i++)
    {
//      fscanf(fp,"%X,%X,%X,%X,",&goon[i][0],&goon[i][1],&goon[i][2],&goon[i][3]);
      if(!goon[i][0]) goon[i][0]=vazio;
//      else fscanf(fp,"%X,",&comc[i][0]);
      if(!goon[i][1]) goon[i][1]=vazio;
//      else fscanf(fp,"%X,",&comc[i][1]);
      if(!goon[i][2]) goon[i][2]=vazio;
//      else fscanf(fp,"%X,",&comc[i][2]);
      if(!goon[i][3]) goon[i][3]=vazio;
//      else fscanf(fp,"%X,",&comc[i][3]);
    }
    for(i=0;i<4;i++)
    {
      if(IsExpanded[i])
      {
      }
      else
      {
        for(k=0;k<8;k++)
        {
          if (goon[i][0]!=vazio)
          {
            goon[i][0]=(UINT8 *)malloc(32768);
            if(comc[i][0]!=-1)
            {
              fread(goon[i][0],32768,1,fp);
              Msx[i][0][comc[i][0]]=goon[i][0];
              Msx[i][0][comc[i][0]+1]=goon[i][0]+8192;
              Msx[i][0][comc[i][0]+2]=goon[i][0]+16384;
              Msx[i][0][comc[i][0]+3]=goon[i][0]+16384+8192;
            }
            break;
          }
          else if (tb[i][0][k])
            fread(Msx[i][0][k],8192,1,fp);
        }
      }
    }
//    fread(vram,16384,1,fp);
    fscanf(fp,"%d,%d,%d,%d,%d,%d,%d,%d,",&pc,&sp,&af,&bc,&de,&hl,&im,&r);
    fscanf(fp,"%d,%d,%d,%d,%d,%d,%d,",&af1,&bc1,&de1,&hl1,&ix,&iy,&iff);
//    fscanf(fp,"%d,%d,%d,%d,%d,%d,%d,%d,",&vdp_modo[0],&vdp_modo[1],&vdp_modo[2],&vdp_modo[3],&vdp_modo[4],&vdp_modo[5],&vdp_modo[6],&vdp_modo[7]);
//    fscanf(fp,"%d,",&pvram);
    fscanf(fp,"%d,",&pa8);
    Porta_a8=pa8;
//    posvram=pvram;
    pointz80->PC.W=pc;
    pointz80->SP.W=sp;
    pointz80->AF.W=af;
    pointz80->BC.W=bc;
    pointz80->DE.W=de;
    pointz80->HL.W=hl;
    pointz80->IX.W=ix;
    pointz80->IY.W=iy;
    pointz80->AF1.W=af1;
    pointz80->BC1.W=bc1;
    pointz80->DE1.W=de1;
    pointz80->HL1.W=hl1;
    pointz80->IFF=iff;
    pointz80->I=im;
    pointz80->R=r;
    Out_a8(0xa8,Porta_a8);
    for(i=0;i<8;i++)
    {
//      Out_99((unsigned char)vdp_modo[i]);
//      Out_99((unsigned char)0x80+i);
    }
    vdp.calc_screen();
    fclose(fp);
    return 1;
}

int cartbmenu(void)
{
  static char rom[120]="";
  FILE* fp;
  if(file_select("Select CartB ROM", rom, "ROM"))
  {
    fp=fopen(rom,"rb");
    CarregaRom(fp,2,0);
    fclose(fp);
    resetar=1;
  }
  text_mode(-1);
  clear_to_color(screen,1);
  return D_CLOSE;
}

int tapemenu(void)
{
  static char tp[120]="";
  if(file_select("Select Tape Image", tp, "CAS"))
  {
    strcpy((char *)Nmtape, tp);
    fclose(tape);
    tape=fopen(tp,"ab+");
  }
  text_mode(-1);
  clear_to_color(screen,1);
  return D_O_K;
}

int diskamenu(void)
{
  static char da[120]="";
  if(file_select("Select DiskA", da, "DSK;720"))
  {
    if (MSXDrive) fclose(drivea);
    if(access(da,W_OK))
    {
      drivea=fopen(da,"ab+");
      driveawrite=1;
    }
    else
    {
      drivea=fopen(da,"ab+");
      driveawrite=1;
    }
    diskPresentA=1;
  }
  text_mode(-1);
  clear_to_color(screen,1);
  return D_O_K;

}
int diskbmenu(void)
{
  static char da[120]="";
  if(file_select("Select DiskB", da, "DSK;720"))
  {
    if (MSXDrive>1) fclose(driveb);
    driveb=fopen(da,"ab+");
  }
  text_mode(-1);
  clear_to_color(screen,1);
  return D_O_K;

}

int aboutmenu(void)
{
  alert("Power MSX 0.07","By Alexandre M. Maoski","Compiled in 21/06/2000","Ok",NULL,65,66);
  return D_O_K;
}

int vidmenu(void)
{
  int card,x,y;
  if (gfx_mode_select(&card,&x,&y))
  {
    trocarres=1;
    Placa=card; ResX=x; ResY=y;
  }
//  setscreen(card,x,y);
  return D_CLOSE;
}

int zeroframe()
{
  int i;
  Nframeskip=0;
  for(i=0;i<4;i++) framemenu[i].flags=0;
  framemenu[0].flags=D_SELECTED;
  return D_CLOSE;
}

int umframe()
{
  int i;
  Nframeskip=1;
  for(i=0;i<4;i++) framemenu[i].flags=0;
  framemenu[1].flags=D_SELECTED;
  return D_CLOSE;
}

int doisframe()
{
  int i;
  Nframeskip=2;
  for(i=0;i<4;i++) framemenu[i].flags=0;
  framemenu[2].flags=D_SELECTED;
  return D_CLOSE;
}

int tresframe()
{
  int i;
  Nframeskip=3;
  for(i=0;i<4;i++) framemenu[i].flags=0;
  framemenu[3].flags=D_SELECTED;
  return D_CLOSE;
}

int resetmenu()
{
  resetar=1;
  return D_CLOSE;
}

int savescreenbmp()
{
  char da[128];
  da[0]='\0';
  PALETTE pal;
  get_palette(pal);
  if (file_select("Enter new BMP", da, "BMP"))
  {
    FILE* fp;
    fp=fopen(da,"wb");
    save_bmp(da, minha_tela, pal);
    fclose(fp);
  }
  return D_CLOSE;
}

int savescreentga()
{
  char da[128];
  da[0]='\0';
  PALETTE pal;
  get_palette(pal);
  if (file_select("Enter new TGA", da, "TGA"))
  {
    FILE* fp;
    fp=fopen(da,"wb");
    save_tga(da, minha_tela, pal);
    fclose(fp);
  }
  return D_CLOSE;
}

int savescreenpcx()
{
  char da[128];
  da[0]='\0';
  PALETTE pal;
  get_palette(pal);
  if (file_select("Enter new PCX", da, "PCX"))
  {
    FILE* fp;
    fp=fopen(da,"wb");
    save_pcx(da, minha_tela, pal);
    fclose(fp);
  }
  return D_CLOSE;
}


int diskmanager()
{
  return 0;
}

int tapemanager()
{
  return 0;
}

int normalxmenu(void)
{
  gfxrendermenu[2].flags=gfxrendermenu[3].flags=0;
  gfxrendermenu[1].flags=D_SELECTED;
  Renderx=NORMALX;
  trocarres=1;
  return D_O_K;
}

int doublexmenu(void)
{
  gfxrendermenu[1].flags=gfxrendermenu[3].flags=0;
  gfxrendermenu[2].flags=D_SELECTED;
  Renderx=DOUBLEX;
  trocarres=1;
  return D_O_K;
}

int interpolaxmenu(void)
{
  gfxrendermenu[1].flags=gfxrendermenu[2].flags=0;
  gfxrendermenu[3].flags=D_SELECTED;
  Renderx=INTERPX;
  trocarres=1;
  return D_O_K;
}

int normalymenu(void)
{
  gfxrendermenu[6].flags=gfxrendermenu[7].flags=gfxrendermenu[8].flags=gfxrendermenu[9].flags=gfxrendermenu[10].flags=0;
  gfxrendermenu[5].flags=D_SELECTED;
  Rendery=NORMALY;
  trocarres=1;
  return D_O_K;
}

int doubleymenu(void)
{
  gfxrendermenu[5].flags=gfxrendermenu[7].flags=gfxrendermenu[8].flags=gfxrendermenu[9].flags=gfxrendermenu[10].flags=0;
  gfxrendermenu[6].flags=D_SELECTED;
  Rendery=DOUBLEY;
  trocarres=1;
  return D_O_K;
}

int scanlinesmenu(void)
{
  gfxrendermenu[5].flags=gfxrendermenu[6].flags=gfxrendermenu[8].flags=gfxrendermenu[9].flags=gfxrendermenu[10].flags=0;
  gfxrendermenu[7].flags=D_SELECTED;
  Rendery=SCANLINES;
  trocarres=1;
  return D_O_K;
}

int i50menu(void)
{
  gfxrendermenu[5].flags=gfxrendermenu[6].flags=gfxrendermenu[7].flags=gfxrendermenu[9].flags=gfxrendermenu[10].flags=0;
  gfxrendermenu[8].flags=D_SELECTED;
  Rendery=I50;
  trocarres=1;
  return D_O_K;
}

int i75menu(void)
{
  gfxrendermenu[5].flags=gfxrendermenu[6].flags=gfxrendermenu[7].flags=gfxrendermenu[8].flags=gfxrendermenu[10].flags=0;
  gfxrendermenu[9].flags=D_SELECTED;
  Rendery=I75;
  trocarres=1;
  return D_O_K;
}

int i87menu(void)
{
  gfxrendermenu[5].flags=gfxrendermenu[6].flags=gfxrendermenu[7].flags=gfxrendermenu[8].flags=gfxrendermenu[9].flags=0;
  gfxrendermenu[10].flags=D_SELECTED;
  Rendery=I87;
  trocarres=1;
  return D_O_K;
}

int soundmenu(void)
{
  int i;
  for(i=0;i<18;i++)
  {
    snd_dialog[i].x=sndbackx[i]+Iniciox+20;
    snd_dialog[i].y=sndbacky[i]+Inicioy+20;
  }
  do_dialog(snd_dialog, 0);
  return D_EXIT;
}

void atualsom(int samplesupdate)
{
  void *buf[4];

  static long int position=0;
  static long int chunkSize;
  chunkSize=chSize[0];


  /* update the chunk of samples at 'chunkPosition' */
  AGetVoicePosition(voice[0], &position);
  if (position < chunkPosition || position >= chunkPosition + chunkSize) {
//    buf[0]=wave[0].lpData+chunkPosition+samplespassados;
//    buf[1]=wave[1].lpData+chunkPosition+samplespassados;
//    buf[2]=wave[2].lpData+chunkPosition+samplespassados;
    buf[0]=wave[0].lpData+chunkPosition;
    buf[1]=wave[1].lpData+chunkPosition;
    buf[2]=wave[2].lpData+chunkPosition;

    AY8910Update_8(buf,samplesupdate);
    /*PPIUpdate();*/
      
//    chunkPosition+=chunkSize;
//    AWriteAudioData(&wave[0], chunkPosition - chunkSize + position, samplesupdate);
//    AWriteAudioData(&wave[1], chunkPosition - chunkSize + position, samplesupdate);
//    AWriteAudioData(&wave[2], chunkPosition - chunkSize + position, samplesupdate);
//    chunkPosition-=chunkSize;
//    if (chunkPosition >= wave[0].dwLength)
//      chunkPosition = 0;
  }
//  AUpdateAudioEx(samplesupdate);


}

void atualiza_samples()
{
//  int ciclospassados;
//  int samplesupdate;
//  ciclospassados=CICLOS_Z80-(pointz80->ICount+auxcontaciclosz80);
//  if(ciclospassados-ciclospassadosanterior<1000) return;
//  samplesupdate=((ciclospassados-ciclospassadosanterior)*meusoundRate)/(double)(CICLOS_Z80*60);
//  samplespassados=(ciclospassadosanterior*meusoundRate)/(double)(CICLOS_Z80*60);
//  atualsom(samplesupdate);
//  samplesfinal=samplespassados+samplesupdate;
//  fprintf(trace,"%d\n",ciclospassados);
//  ciclospassadosanterior=ciclospassados;
}

void OutZ80(register word Port,unsigned char Value)
{
  int tammapper,i,j;
// fprintf(trace,"Out %x,%x\n",Port, Value);
  switch(Port)
    {
      case 0x98:
	Out_98(Value);
	return;
      case 0x99:
	Out_99(Value);
	return;
      case 0xa1:
//        atualiza_samples();
      case 0xa0:
	      AY8910Write(Port, Value);
	return;
      case 0xa8:
//  fprintf(trace,"a8=%x\n",Value);
	Out_a8(Port, Value);
	return;
      case 0xaa:
	Out_aa(Port, Value);
	return;
      case 0xab:
    	if (Value&1)
    	  Out_aa(0xaa,In_aa(0xaa)|(1<<((Value>>1)&7)));
    	else
    	  Out_aa(0xaa,In_aa(0xaa)&(~(1<<((Value>>1)&7))));
      return;
      case 0x8e:
        Porta_8e=1;
        return;
      case 0xfc:
      fprintf(trace,"Porta 0xfc");
      for(i=0;i<4;i++)
        for(j=0;j<4;j++)
          memmapper[i][j][0]=Value%(mapper[i][j]? mapper[i][j]: 1);
        tammapper=(mapper[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]]&3):0]);
        if (tammapper)
        {
          Value%=tammapper;
//          memmapper[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]]&3):0][0]=Value;
          mem[0]=pmapper[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]]&3):0] +((memmapper[PSAtual[0]][IsExpanded[PSAtual[0]]?SlotExpanded[PSAtual[0]]&3:0][0])<<14);
          mem[1]=pmapper[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]]&3):0]+ ((memmapper[PSAtual[0]][IsExpanded[PSAtual[0]]?SlotExpanded[PSAtual[0]]&3:0][0])<<14)+0x2000;
        }
      return;
      case 0xfd:
      fprintf(trace,"Porta 0xfd");
      for(i=0;i<4;i++)
        for(j=0;j<4;j++)
          memmapper[i][j][1]=Value%(mapper[i][j]? mapper[i][j]: 1);
        tammapper=(mapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0]);
        if (tammapper)
        {
          Value%=tammapper;
//          memmapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0][1]=Value;
          mem[2]=pmapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0]+((memmapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0][1])<<14);
          mem[3]=pmapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0]+((memmapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0][1])<<14)+0x2000;
        }
      return;
      case 0xfe:
      fprintf(trace,"Porta 0xfe");
      for(i=0;i<4;i++)
        for(j=0;j<4;j++)
          memmapper[i][j][2]=Value%(mapper[i][j]? mapper[i][j]: 1);
        tammapper=(mapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0]);
        if (tammapper)
        {
          Value%=tammapper;
//          memmapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0][2]=Value;
          mem[4]=pmapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0]+((memmapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0][2])<<14);
          mem[5]=pmapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0]+((memmapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0][2])<<14)+0x2000;
        }
      return;
      case 0xff:
      fprintf(trace,"Porta 0xff");
      for(i=0;i<4;i++)
        for(j=0;j<4;j++)
          memmapper[i][j][3]=Value%(mapper[i][j]? mapper[i][j]: 1);
        tammapper=(mapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0]);
        if (tammapper)
        {
          Value%=tammapper;
//          memmapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0][3]=Value;
          mem[6]=pmapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0]+((memmapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0][3])<<14);
          mem[7]=pmapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0]+((memmapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0][3])<<14)+0x2000;
        }
    }
}

byte InZ80(register word Port)
{
  // fprintf(trace,"In %x\n",Port);
  switch(Port)
    {
      case 0x98:
	return In_98();
      case 0x99:
	return In_99();
      case 0xa2:
	return AY8910Read();
      case 0xa8:
	return In_a8(Port);
      case 0xa9:
	return In_a9(Port);
      case 0xaa:
	return In_aa(Port);
      case 0x8e:
      Porta_8e=0;
      default:
	return 0;          //Porta nao implementada
    }
}

void PatchZ80(register Z80 *R)
{
  UINT8 header[]={0x1F,0xA6,0xDE,0xBA,0xCC,0x13,0x7D,0x74};


  static struct
  { int Sectors;byte Heads,Names,PerTrack,PerFAT,PerCluster; }
  Info[8] =
    {
      {  720,1,112,9,2,2 },
	{ 1440,2,112,9,3,2 },
	{  640,1,112,8,1,2 },
	{ 1280,2,112,8,2,2 },
	{  360,1, 64,9,2,1 },
	{  720,2,112,9,2,2 },
	{  320,1, 64,8,1,1 },
	{  640,2,112,8,1,2 }
    };
  //if (tape==0) return;
  switch(R->PC.W-2)
  {
    case 0xE1:
    {
      int i, ch;
      UINT32 cnt=0;
      R->AF.B.l|=C_FLAG;
//        R->AF.B.l&=~C_FLAG; //asdfasf
      i=0;
	
      while(1)
      {
      	ch=fgetc(tape);
	      cnt++;
      	if ((ch<0) ||(cnt>65536+1024)){return; }
      	if (ch==header[i]) i++; else i=0;
      	if (i==8) {R->AF.B.l&=~C_FLAG; return;}
      }
    
//    R->AF.B.l&=~C_FLAG;
    }
    break;
    case 0xE4:
    {
      int ch;
      R->AF.B.l|=C_FLAG;
      ch=fgetc(tape);
      if(ch<0) {fseek(tape,0,SEEK_SET); return;}
      R->AF.B.h=ch;
      R->AF.B.l&=~C_FLAG;
//   if(feof(tape)) R->AF.B.l|=C_FLAG;
    }
      break;
    case 0xE7:
      R->AF.B.l&=~C_FLAG;
      break;
    case 0xEA:
    {
      int i;
      R->AF.B.l&=~C_FLAG;
      for(i=0;i<8;i++)
       	fputc(header[i],tape);
    }
    break;
    case 0xED:
      R->AF.B.l&=~C_FLAG;
      fputc(R->AF.B.h,tape);
      break;
    case 0xF0:
   R->AF.B.l&=~C_FLAG;
   break;
  case 0xF3:
   R->AF.B.l&=~C_FLAG;

   break;
           // Esta rotina do Drive foi copiada do fMSX
           // So foi alterada para que rodasse o Konami Game Collection


   case 0x4010:
  R->IFF|=1;


  { UINT32 Addr, Count,PS,Sector,J;
    UINT8 Buf[512];
  Addr=R->HL.W;Count=R->BC.B.h;R->BC.B.h=0;
  Count&=0xff;
  if (diskPresentA==0) {R->AF.W=0x201; return; }
//  if(!DiskPresent(R->AF.B.h))
//  { R->AF.W=0x0201;return; }  /* No disk      -> "Not ready"        */
  if((int)(R->DE.W)+Count>(UINT32)Info[R->BC.B.l-0xF8].Sectors)
  { R->AF.W=0x0801;return; }  /* Wrong sector -> "Record not found" */

  /* If data does not fit into 64kB address space, trim it */
  if((int)(R->HL.W)+Count*512>0x10000) Count=(0x10000-R->HL.W)/512;

  PS=Porta_a8;//SS=SSLReg;           /* Save slot states */
  OutZ80(0xA8,0xFF);//SSlot(0xAA); /* Turn on RAM in all slots */

  if(R->AF.B.l&C_FLAG)
  {
    fputs("Tring to write do drivea",trace);
    if (driveawrite)
    {
      for(Sector=R->DE.W;Count--;Sector++) /* WRITE */
      {
        for(J=0;J<512;J++) Buf[J]=RdZ80(Addr++);
        if(DiskWrite(R->AF.B.h,Buf,Sector)) R->BC.B.h++;
        else { R->AF.W=0x0A01;/*SSlot(SS);*/OutZ80(0xA8,PS);return; }
      }
    }
    else
    {
      R->AF.W=0x0A01;
      return;  /*Return Failure*/
    }
  }
  else
    fputs("Tring to read from drivea",trace);
    for(Sector=R->DE.W;Count--;Sector++) /* READ */
    {
      if(DiskRead(R->AF.B.h,Buf,Sector)) R->BC.B.h++;
      else { R->AF.W=0x0401;/*SSlot(SS);*/OutZ80(0xA8,PS);return; }
      for(J=0;J<512;J++) WrZ80(Addr++,Buf[J]);
    }

/*  SSlot(SS);*/OutZ80(0xA8,PS);  /* Restore slot states */
  R->AF.B.l&=~C_FLAG;return; /* Return "Success" */
   }
   break;
  case 0x4013:
  R->BC.B.h=0;R->AF.B.l&=~C_FLAG;
   break;
  case 0x4016:
{
/** GETDPB: Disk format *****************************************
*** Input:                                                    ***
*** [A] Drive number   [B] 1st byte of FAT (media descriptor) ***
*** [C] Media descriptor  [HL] Base address of DPB            ***
*** Output:                                                   ***
*** [HL+1] .. [HL+18] = DPB for specified drive               ***
*** DPB consists of:                                          ***
*** Name   Offset Size Description                            ***
*** MEDIA    0     1   Media type (F8..FF)                    ***
*** SECSIZ   1     2   Sector size (must be 2^n)              ***
*** DIRMSK   3     1   (SECSIZE/32)-1                         ***
*** DIRSHFT  4     1   Number of one bits in DIRMSK           ***
*** CLUSMSK  5     1   (Sectors per cluster)-1                ***
*** CLUSSHFT 6     1   (Number of one bits in CLUSMSK)+1      ***
*** FIRFAT   7     2   Logical sector number of first FAT     ***
*** FATCNT   8     1   Number of FATs                         ***
*** MAXENT   A     1   Number of directory entries (max 254)  ***
*** FIRREC   B     2   Logical sector number of first data    ***
*** MAXCLUS  D     2   Number of clusters (not including      ***
***                    reserved, FAT and directory sectors)+1 ***
*** FATSIZ   F     1   Number of sectors used                 ***
*** FIRDIR   10    2   FAT logical sector number of start of  ***
***                    directory                              ***
****************************************************************/
  int BytesPerSector,SectorsPerDisk,SectorsPerFAT,ReservedSectors;
  UINT8 Buf[512]; int Addr,J,I;
  if (diskPresentA==0) {R->AF.W=0x201; return; }
  /* If no disk, return "Not ready": */
//  if(!DiskPresent(R->AF.B.h))    { R->AF.W=0x0201;return; }
  /* If can't read, return "Other error": */
  if(!DiskRead(R->AF.B.h,Buf,0)) { R->AF.W=0x0C01;return; }

  if(Buf[0x0C]!=1 &&Buf[0x0C]!=2) Buf[0x0C]=2;
  if(Buf[0x0B]) Buf[0x0B]=0;
  if(Buf[0x0D]) Buf[0x0D]=2;
  if(Buf[0x15]!=0xF9) Buf[0x15]=0xF9;
  BytesPerSector  = (int)Buf[0x0C]*256+Buf[0x0B];
  if(BytesPerSector!=512 && BytesPerSector!=256) BytesPerSector=512;
  SectorsPerDisk  = (int)Buf[0x14]*256+Buf[0x13];
  if(SectorsPerDisk!=1440 && SectorsPerDisk!=720) SectorsPerDisk=1440;
  SectorsPerFAT   = (int)Buf[0x17]*256+Buf[0x16];
  ReservedSectors = (int)Buf[0x0F]*256+Buf[0x0E];
  if (Buf[0x0D]!=1 || Buf[0x0D]!=2) Buf[0x0D]=2;

  Addr=R->HL.W+1;
//  WrZ80(Addr++,Buf[0x15]);             /* Format ID [F8h-FFh] */
  WrZ80(Addr++,Buf[0x15]);             /* Format ID [F8h-FFh] */
  WrZ80(Addr++,Buf[0x0B]);             /* Sector size         */
  WrZ80(Addr++,Buf[0x0C]);
  J=(BytesPerSector>>5)-1;
  if(J>0 && J<=31) for(I=0;J&(1<<I);I++);
  else I=0;
  WrZ80(Addr++,J);                     /* Directory mask/shft */
  WrZ80(Addr++,I);
  J=Buf[0x0D]-1;
  if(J>0 && J<=255) for(I=0;J&(1<<I);I++);
  else I=0;
  WrZ80(Addr++,J);                     /* Cluster mask/shift  */
  WrZ80(Addr++,I+1);
  WrZ80(Addr++,Buf[0x0E]);             /* Sector # of 1st FAT */
  WrZ80(Addr++,Buf[0x0F]);
  WrZ80(Addr++,Buf[0x10]);             /* Number of FATs      */
  WrZ80(Addr++,Buf[0x11]);             /* Number of dirent-s  */
  J=ReservedSectors+Buf[0x10]*SectorsPerFAT;
  if(BytesPerSector) J+=32*Buf[0x11]/BytesPerSector;
  WrZ80(Addr++,J&0xFF);                /* Sector # of data    */
  WrZ80(Addr++,(J>>8)&0xFF);
  if(Buf[0x0D]) J=(SectorsPerDisk-J)/Buf[0x0D];
  WrZ80(Addr++,J&0xFF);                /* Number of clusters  */
  WrZ80(Addr++,(J>>8)&0xFF);
  WrZ80(Addr++,Buf[0x16]);             /* Sectors per FAT     */
  J=ReservedSectors+Buf[0x10]*SectorsPerFAT;
  WrZ80(Addr++,J&0xFF);                /* Sector # of dir.    */
  WrZ80(Addr,(J>>8)&0xFF);
  R->AF.B.l&=~C_FLAG;return;           /* Return success      */
}
   break;
  case 0x4019:
   break;
  case 0x401C:
   break;
  case 0x401f:
   break;
  }

}
/*
byte DebugZ80(register Z80 *R)
{

// printf("%x:%x,%x\n",R->PC.W,RdZ80(R->PC.W),RdZ80(R->PC.W+1));
// textout(screen,font,"Des",256,10,15);
// if(key[KEY_F11]) {set_gfx_mode(GFX_VESA2L,320,240,0,0);R->Trace=0;}
return 1;

}
*/


UINT16 In_a8(UINT16 porta)
{
  return Porta_a8;
}

UINT16 In_a9(UINT16 porta)
{
  int num;
#define kk(k,b)  ((key[k]&1)<<b)
#define kl(k,b)  (((key[k]&2)>>1)<<b)
#define km(k,b)  (kk(k,b)|kl(k,b))
  switch(linha_teclado)
  {
    case 0:
      return 255-(kk(KEY_7,7)|kk(KEY_6,6)|kk(KEY_5,5)|kk(KEY_4,4)|kk(KEY_3,3)|kk(KEY_2,2)|kk(KEY_1,1)|kk(KEY_0,0));
      break;
    case 1:
      return 255-(kk(KEY_COLON,7)|kk(KEY_CLOSEBRACE,6)|kk(KEY_OPENBRACE,5)|kk(KEY_BACKSLASH,4)|kk(KEY_EQUALS,3)|kk(KEY_MINUS,2)|kk(KEY_9,1)|kk(KEY_8,0));
      break;
    case 2:
      return 255-(kk(KEY_B,7)|kk(KEY_A,6)|kk(KEY_COMMA,2)|kk(KEY_SLASH,4)|kk(KEY_STOP,3)|kk(KEY_COMMA,2)|kk(KEY_TILDE,1)|kk(KEY_QUOTE,0));
      break;
    case 3:
      return 255-(kk(KEY_J,7)|kk(KEY_I,6)|kk(KEY_H,5)|kk(KEY_G,4)|kk(KEY_F,3)|kk(KEY_E,2)|kk(KEY_D,1)|kk(KEY_C,0));
      break;
    case 4:
      return 255-(kk(KEY_R,7)|kk(KEY_Q,6)|kk(KEY_P,5)|kk(KEY_O,4)|kk(KEY_N,3)|kk(KEY_M,2)|kk(KEY_L,1)|kk(KEY_K,0));
      break;
    case 5:
      return 255-(kk(KEY_Z,7)|kk(KEY_Y,6)|kk(KEY_X,5)|kk(KEY_W,4)|kk(KEY_V,3)|kk(KEY_U,2)|kk(KEY_T,1)|kk(KEY_S,0));
      break;
    case 6:
      return 255-(kk(KEY_F3,7)|kk(KEY_F2,6)|kk(KEY_F1,5)|km(KEY_ALTGR,4)|kk(KEY_CAPSLOCK,3)|kk(KEY_ALT,2)|(km(KEY_LCONTROL,1)|km(KEY_RCONTROL,1))|kk(KEY_LSHIFT,0)|kk(KEY_RSHIFT,0));
      break;
    case 7:
      return 255-(km(KEY_ENTER,7)|km(KEY_PGDN,6)|kk(KEY_BACKSPACE,5)|km(KEY_PGUP,4)|kk(KEY_TAB,3)|kk(KEY_ESC,2)|kk(KEY_F5,1)|kk(KEY_F4,0));
      break;
    case 8:
      num=km(KEY_RIGHT,7)|km(KEY_DOWN,6)|km(KEY_UP,5)|km(KEY_LEFT,4)|
          km(KEY_6_PAD,7)|km(KEY_2_PAD,6)|km(KEY_8_PAD,5)|km(KEY_4_PAD,4)|
          km(KEY_DEL,3)|km(KEY_INSERT,2)|km(KEY_HOME,1)|kk(KEY_SPACE,0);
      return 255-num;
      break;
    case 9:
      break;
  }
  return 0xff;
#undef kk
#undef kl
#undef km
}

UINT16 In_aa(UINT16 porta)
{
  return Porta_aa;
}

void Out_aa(UINT16 porta, UINT8 dado)
{
  static int anterior=0;
  Porta_aa=dado;
  if((dado&0x80)!=(anterior&0x80)) PPISound(dado&0x80);
  linha_teclado=dado&15;
  anterior=dado;
}

int PPISound(char dado)
{
  int i;
  static int valor;
//  if(valor==0) valor =40; else valor =0;
  if (Somligado)
  {
    for(i=0;i<TAMPPI;i++)
      wave[3].lpData[i]=dado>>2;
    AWriteAudioData(&wave[3], 0, TAMPPI);
    AUpdateAudio();
  } 
  return 1;
}

void Out_a8(UINT16 porta, UINT8 dado)
{
  PSAtual[0]=dado&3;
  PSAtual[1]=(dado>>2)&3;
  PSAtual[2]=(dado>>4)&3;
  PSAtual[3]=(dado>>6)&3;
  if (megarom[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]])&3:0])
  {
    mem[0]=goon[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0]+ ((memmegarom[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][0])<<13);
    mem[1]=goon[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0]+ ((memmegarom[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][1])<<13);
  }
  else if (megaram[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]])&3:0])
  {
    mem[0]=pmegaram[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0]+ ((memmegarom[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][0])<<13);
    mem[1]=pmegaram[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0]+ ((memmegarom[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][1])<<13);
  }

  else if (mapper[PSAtual[0]][IsExpanded[PSAtual[0]]?(SlotExpanded[PSAtual[0]])&3:0])
  {
    mem[0]=pmapper[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0]+ ((memmapper[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][0])<<14);
    mem[1]=pmapper[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0]+ ((memmapper[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][0])<<14)+0x2000;
  }
  else
  {
    mem[0]=Msx[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][0];
    mem[1]=Msx[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][1];
  }


  if (megarom[PSAtual[1]][IsExpanded[PSAtual[1]]?((SlotExpanded[PSAtual[1]])>>2)&3:0])
  {
    mem[2]=goon[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0]+ ((memmegarom[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][2])<<13);
    mem[3]=goon[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0]+ ((memmegarom[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][3])<<13);
  }
  else if (megaram[PSAtual[1]][IsExpanded[PSAtual[1]]?((SlotExpanded[PSAtual[1]])>>2)&3:0])
  {
    mem[2]=pmegaram[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0]+ ((memmegarom[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][2])<<13);
    mem[3]=pmegaram[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0]+ ((memmegarom[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][3])<<13);
  }
  else if (mapper[PSAtual[1]][IsExpanded[PSAtual[1]]?(SlotExpanded[PSAtual[1]]>>2)&3:0])
  {
    mem[2]=pmapper[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0]+ ((memmapper[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][1])<<14);
    mem[3]=pmapper[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0]+ ((memmapper[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][1])<<14)+0x2000;
  }
  else
  {
    mem[2]=Msx[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][2];
    mem[3]=Msx[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][3];
  }

  if (megarom[PSAtual[2]][IsExpanded[PSAtual[2]]?((SlotExpanded[PSAtual[2]])>>4)&3:0])
  {
    mem[4]=goon[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0]+ ((memmegarom[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][4])<<13);
    mem[5]=goon[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0]+ ((memmegarom[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][5])<<13);
  }
  else if (megaram[PSAtual[2]][IsExpanded[PSAtual[2]]?((SlotExpanded[PSAtual[2]])>>4)&3:0])
  {
    mem[4]=pmegaram[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0]+ ((memmegarom[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][4])<<13);
    mem[5]=pmegaram[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0]+ ((memmegarom[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][5])<<13);
  }
  else if (mapper[PSAtual[2]][IsExpanded[PSAtual[2]]?(SlotExpanded[PSAtual[2]]>>4)&3:0])
  {
    mem[4]=pmapper[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0]+ ((memmapper[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][2])<<14);
    mem[5]=pmapper[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0]+ ((memmapper[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][2])<<14)+0x2000;
  }
  else
  {
    mem[4]=Msx[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][4];
    mem[5]=Msx[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][5];
  }

  if (megarom[PSAtual[3]][IsExpanded[PSAtual[3]]?((SlotExpanded[PSAtual[3]])>>6)&3:0])
  {
    mem[6]=goon[PSAtual[3]][IsExpanded[dado>>6]?(SlotExpanded[dado>>6]>>6)&3:0]+ ((memmegarom[PSAtual[3]][IsExpanded[(dado>>6)]?(SlotExpanded[(dado>>6)&3]>>6)&3:0][6])<<13);
    mem[7]=goon[PSAtual[3]][IsExpanded[dado>>6]?(SlotExpanded[dado>>6]>>6)&3:0]+ ((memmegarom[PSAtual[3]][IsExpanded[(dado>>6)]?(SlotExpanded[(dado>>6)&3]>>6)&3:0][7])<<13);
  }
  else if (mapper[PSAtual[3]][IsExpanded[PSAtual[3]]?(SlotExpanded[PSAtual[3]]>>6)&3:0])
  {
    mem[6]=pmapper[PSAtual[3]][IsExpanded[(dado>>6)&3]?(SlotExpanded[(dado>>6)&3]>>6)&3:0]+ ((memmapper[PSAtual[3]][IsExpanded[(dado>>6)&3]?(SlotExpanded[(dado>>6)&3]>>6)&3:0][3])<<14);
    mem[7]=pmapper[PSAtual[3]][IsExpanded[(dado>>6)&3]?(SlotExpanded[(dado>>6)&3]>>6)&3:0]+ ((memmapper[PSAtual[3]][IsExpanded[(dado>>6)&3]?(SlotExpanded[(dado>>6)&3]>>6)&3:0][3])<<14)+0x2000;
  }
  else
  {
    mem[6]=Msx[PSAtual[3]][IsExpanded[(dado>>6)&3]?(SlotExpanded[(dado>>6)&3]>>6)&3:0][6];
    mem[7]=Msx[PSAtual[3]][IsExpanded[(dado>>6)&3]?(SlotExpanded[(dado>>6)&3]>>6)&3:0][7];
  }

    RomPNow[0]=RomP[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][0];
    RomPNow[1]=RomP[PSAtual[0]][IsExpanded[dado&3]?SlotExpanded[dado&3]&3:0][1];
    RomPNow[2]=RomP[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][2];
    RomPNow[3]=RomP[PSAtual[1]][IsExpanded[(dado>>2)&3]?(SlotExpanded[(dado>>2)&3]>>2)&3:0][3];
    RomPNow[4]=RomP[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][4];
    RomPNow[5]=RomP[PSAtual[2]][IsExpanded[(dado>>4)&3]?(SlotExpanded[(dado>>4)&3]>>4)&3:0][5];
    RomPNow[6]=RomP[PSAtual[3]][IsExpanded[(dado>>6)&3]?(SlotExpanded[(dado>>6)&3]>>6)&3:0][6];
    RomPNow[7]=RomP[PSAtual[3]][IsExpanded[(dado>>6)&3]?(SlotExpanded[(dado>>6)&3]>>6)&3:0][7];

  Porta_a8=dado;
}


word LoopZ80(Z80 *R)
{
  vdpline++;
  if (vdpline==192+27+24)
  {
    if (Somligado) SomPlay();
    ciclospassadosanterior=0;
    contasamples=samplespassados=samplesfinal=0;

    relogio=uclock();

    //I am late
    if((long)relogio>(long)relantigo+(long)tempodeframe)
    {
//      relantigo=uclock();
    }
    else
    {
      while((long)uclock()<(long)relantigo+(long)tempodeframe) ;
//      relantigo=uclock();
    }
    relogio=uclock();
    numerodeframes=((double)tempodeframe/((double)((long)relogio-(long)relantigo)))*framespersecond;
    relantigo=uclock();
    if (frameskip==0)
    {
      if (!R->Trace)
      {
        char fr[40];
        sprintf(fr,"%3.00f%%(%3.00f/%d) fps",numerodeframes/framespersecond*100,ceil(numerodeframes), framespersecond);
        textout(minha_tela, font, fr, Inicioxvdp, Inicioyvdp,15);
        atualiza_tela();
      }
      frameskip=Nframeskip;
    }
    else
      frameskip--;

    if (key[KEY_F11])
    {
      trocarres=0;
      ParaSom();
      setGUI();
      if(resetar)
      {
        ResetZ80(pointz80);
        Out_a8(0,0);
      }
      text_mode(-1);
      if (trocarres)
      {
        trocarres=0;
        setscreen(Placa, ResX, ResY);
      }
      clear_to_color(screen,0);
      ContSom();
    }
    if (key[KEY_F12]) return INT_QUIT;
    if (key[KEY_F6] || iniciar_debugger) {iniciar_debugger=0;set_debugger();}
    if (key[KEY_F8]) fseek(tape,0,SEEK_SET);
    if (key[KEY_F7])
    {
      clear_to_color(screen,0);
      mudoufundo=1;
      savestate();
    }
    if (key[KEY_F9])
    {
      clear_to_color(screen,0);
      loadstate();
    }
    vdpline=-1;
    R->IPeriod=CiclesVblank;
    return INT_NONE;
//    R->IRequest= vdp.status&0x80?INT_IRQ:INT_NONE;
//    return vdp.status&0x80?INT_IRQ:INT_NONE;
  }
  if (vdpline<192+27+24)
  {
//    linescreen[vdp.calc_screen()](vdpline);
    if(vdp.calc_screen()==3) vdp.linescreen3(vdpline);
    else if(vdp.calc_screen()==2) vdp.linescreen2(vdpline);
    else if(vdp.calc_screen()==1) vdp.linescreen1(vdpline);
    else vdp.linescreen0(vdpline);
    if(vdpline==192+27)
    {
      auxcontaciclosz80=0;
      R->IPeriod=z80pervdpline;
      if(vdp.getReg(1)&0x20)
      {
        vdp.status|=0x80;
        R->IRequest=INT_IRQ;
        return INT_IRQ;
      }
//    vdp.setFrame(false);
//      R->IRequest=vdp.status&0x80?INT_IRQ:INT_NONE;
//      return vdp.status&0x80?INT_IRQ:INT_NONE;
	R->IRequest=INT_NONE;
	return INT_NONE;
    }
//    auxcontaciclosz80=CICLOS_VBLANK;
//    vdp.status&=0x7f;
    R->IPeriod=z80pervdpline;
    R->IRequest=INT_NONE;
    return INT_NONE;
  }
/*  if(vdpline==192+27+24+19)
  {

    vdpline=-1;
  } */
  R->IRequest=INT_NONE;
  return INT_NONE;
}

void SomInit()
{
  int i;
  if(AInitialize()) {Somligado=0; return;}
  info.nDeviceId = 1;//AUDIO_DEVICE_MAPPER;
  info.wFormat = AUDIO_FORMAT_16BITS | AUDIO_FORMAT_STEREO;
  info.nSampleRate = meusoundRate;
  AOpenAudio(&info);

  AOpenVoices(9);

  ACreateAudioVoice(&voice[0]);
  ACreateAudioVoice(&voice[1]);
  ACreateAudioVoice(&voice[2]);
  ACreateAudioVoice(&voice[3]);

  ACreateAudioVoice(&voice[4]);
  ACreateAudioVoice(&voice[5]);
  ACreateAudioVoice(&voice[6]);
  ACreateAudioVoice(&voice[7]);
  ACreateAudioVoice(&voice[8]);

  ASetVoiceVolume(voice[0], 48);
  ASetVoicePanning(voice[0], 128);
  
  ASetVoiceVolume(voice[1], 48);
  ASetVoicePanning(voice[1], 128);
  
  ASetVoiceVolume(voice[2], 48);
  ASetVoicePanning(voice[2], 128);
  
  ASetVoiceVolume(voice[3], 48);
  ASetVoicePanning(voice[3], 0);
  
  ASetVoiceVolume(voice[4], 24);
  ASetVoicePanning(voice[4], 128);
  ASetVoiceVolume(voice[5], 24);
  ASetVoicePanning(voice[5], 128);
  ASetVoiceVolume(voice[6], 24);
  ASetVoicePanning(voice[6], 128);
  ASetVoiceVolume(voice[7], 24);
  ASetVoicePanning(voice[7], 128);
  ASetVoiceVolume(voice[8], 24);
  ASetVoicePanning(voice[8], 128);

  chPosition[0]=chPosition[1]=chPosition[2]=chPosition[3]= 0;
  chPosition[4]=chPosition[5]=chPosition[6]=chPosition[7]=chPosition[8]=0;
  chSize[0]=chSize[1]=chSize[2]=chSize[3]=chSize[4]=chSize[5]=chSize[6]=chSize[7]=chSize[8]=info.nSampleRate / (framespersecond-5);


  for (i=0;i<9;i++)
    {
    /* create a looped sound buffer of 3 x 1/60th secs */
    wave[i].nSampleRate = info.nSampleRate;
    if (i!=3)wave[i].dwLength = 3 * chSize[0];
    else wave[i].dwLength=TAMPPI;
    wave[i].dwLoopStart = 0;
    wave[i].dwLoopEnd = wave[i].dwLength;
    wave[i].wFormat = AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO | AUDIO_FORMAT_LOOP;
    ACreateAudioData(&wave[i]);

    quieto.dwLength=2;
    quieto.dwLoopStart = 0;
    quieto.dwLoopEnd = 1;
    ACreateAudioData(&quieto);
    quieto.lpData[0]=0;
    quieto.lpData[1]=0;
    /* clean up sound buffer */
    memset(wave[i].lpData, 0, wave[i].dwLength);
    AWriteAudioData(&wave[i], 0, wave[i].dwLength);
  }
  ASetAudioMixerValue(AUDIO_MIXER_MASTER_VOLUME,200);
  for(i=0;i<9;i++)
    APlayVoice(voice[i], &wave[i]);

  AY8910_init("PSG",1789772/4,info.nSampleRate,8,PSG14Read,PSG15Read,PSG14Write,PSG15Write);
  Scc_init("SCC",1789772/4,info.nSampleRate,8);
}

void SomPlay(void)
{
  void *buf[4];
  void *bufscc[5];

  static UINT32 position=0;
  static UINT32 chunkSize;
  chunkSize=chSize[0];


  /* update the chunk of samples at 'chunkPosition' */
  AGetVoicePosition(voice[0],(long *) &position);
  if (position < (UINT32)chunkPosition || position >= (UINT32)chunkPosition + chunkSize) {
    buf[0]=wave[0].lpData+chunkPosition+samplesfinal;
    buf[1]=wave[1].lpData+chunkPosition+samplesfinal;
    buf[2]=wave[2].lpData+chunkPosition+samplesfinal;

   // bufscc[0]=wave[4].lpData+chunkPosition+samplesfinal;
   // bufscc[1]=wave[5].lpData+chunkPosition+samplesfinal;
   // bufscc[2]=wave[6].lpData+chunkPosition+samplesfinal;
   // bufscc[3]=wave[7].lpData+chunkPosition+samplesfinal;
   // bufscc[4]=wave[8].lpData+chunkPosition+samplesfinal;

    AY8910Update_8(buf,chunkSize-samplesfinal);
   // SccUpdate(bufscc,chunkSize-samplesfinal);

    /*PPIUpdate();*/

    chunkPosition+=chunkSize;
    AWriteAudioData(&wave[0], chunkPosition - chunkSize, chunkSize);
    AWriteAudioData(&wave[1], chunkPosition - chunkSize, chunkSize);
    AWriteAudioData(&wave[2], chunkPosition - chunkSize, chunkSize);

    AWriteAudioData(&wave[4], chunkPosition - chunkSize, chunkSize);
    AWriteAudioData(&wave[5], chunkPosition - chunkSize, chunkSize);
    AWriteAudioData(&wave[6], chunkPosition - chunkSize, chunkSize);
    AWriteAudioData(&wave[7], chunkPosition - chunkSize, chunkSize);
    AWriteAudioData(&wave[8], chunkPosition - chunkSize, chunkSize);

    if ((UINT32)chunkPosition >= wave[0].dwLength)
      chunkPosition = 0;
  }
  AUpdateAudioEx(chunkSize);

}

void SomSai(void)
{
  int i;
  for(i=0;i<9;i++) {
    /* stop playing the buffer */
    AStopVoice(voice[i]);
    /* release sound buffer */
    ADestroyAudioData(&wave[i]);

    /* release audio voices */
    ADestroyAudioVoice(voice[i]);
  }
  ACloseVoices();

  /* close audio device */
  ACloseAudio();
}

void CarregaRom(FILE* arq, int i, int j)
{
  int tamanho;
  int loop;
  for(loop=0;loop<8;loop++)
    Msx[i][j][loop]=vazio;

  tamanho=fread(goon[i][j],1,512*1024,arq);
  if (tamanho%0x2000)
  {
    puts("Cartucho invalido");
    exit(1);
  }
  if (tamanho==0x2000)
  {
    tipocartucho=C8K;
    Msx[i][j][2]=goon[i][j];
    megarom[i][j]=0;
  }
  if (tamanho==0x4000)
  {
    if (goon[i][j][3]>=0x80 && goon[i][j][3]<=0xbf)
    {
      Msx[i][j][4]=goon[i][j];
      Msx[i][j][5]=goon[i][j]+8192;
      tipocartucho=C16K2;
      megarom[i][j]=0;
    } else
    if (goon[i][j][3]>=0x40 && goon[i][j][3]<=0x7f)
    {
      Msx[i][j][2]=goon[i][j];
      Msx[i][j][3]=goon[i][j]+8192;
    	tipocartucho=C16K1;
      megarom[i][j]=0;
    }
    else
	  if (goon[i][j][3]==0 && goon[i][j][2]==0)
	  {
      Msx[i][j][4]=goon[i][j];
      Msx[i][j][5]=goon[i][j]+8192;
	    tipocartucho=C16K2;
	    megarom[i][j]=0;
	  }
	  else
	  {
      Msx[i][j][0]=goon[i][j];
      Msx[i][j][1]=goon[i][j]+8192;
	    tipocartucho=C16K0;
	    megarom[i][j]=0;
	  }
  }
  if (tamanho==0x8000)
  {
    if(goon[i][j][3]>=0x40)
    {
      tipocartucho=C32K1;
      megarom[i][j]=0;
      Msx[i][j][2]=goon[i][j];
      Msx[i][j][3]=goon[i][j]+8192;
      Msx[i][j][4]=goon[i][j]+16384;
      Msx[i][j][5]=goon[i][j]+16384+8192;
    }
    else
    {
      tipocartucho=C32K0; megarom[i][j]=0;
      Msx[i][j][0]=goon[i][j];
      Msx[i][j][1]=goon[i][j]+8192;
      Msx[i][j][2]=goon[i][j]+16384;
      Msx[i][j][3]=goon[i][j]+16384+8192;
    }
  }
  if (tamanho==0xC000)
  {
    Msx[i][j][2]=goon[i][j];
    Msx[i][j][3]=goon[i][j]+8192;
    Msx[i][j][4]=goon[i][j]+16384;
    Msx[i][j][5]=goon[i][j]+16384+8192;
    Msx[i][j][6]=32768+goon[i][j];
    Msx[i][j][7]=32768+goon[i][j]+8192;
    tipocartucho=C48K; megarom[i][j]=0;
  }
  if (tamanho==0x10000)
  {
    tipocartucho=C64K; megarom[i][j]=1;
/*    Msx[i][j][0]=goon[i][j];
    Msx[i][j][1]=goon[i][j]+8192;
    Msx[i][j][2]=goon[i][j]+16384;
    Msx[i][j][3]=goon[i][j]+16384+8192;
    Msx[i][j][4]=32768+goon[i][j];
    Msx[i][j][5]=32768+goon[i][j]+8192;
    Msx[i][j][6]=32768+goon[i][j]+16384;
    Msx[i][j][7]=32768+goon[i][j]+16384+8192;*/
  }
  if (tamanho==0x20000)
    {tipocartucho=0;megarom[i][j]=16;}
  if (tamanho==0x40000)
    {tipocartucho=0;megarom[i][j]=32;}
  if (tamanho==0x80000)
    {tipocartucho=0;megarom[i][j]=64;}

}

void setscreen(int card, int x, int y)
{
  int loop, tempx, tempy, gdrv;
  if (card)
  {
    gdrv=gfx_driver->id;
    tempx=SCREEN_W; tempy=SCREEN_H;
    if (set_gfx_mode(card,x,y,0,0)) {
      set_gfx_mode(gdrv, tempx, tempy, 0, 0);
      x=tempx;y=tempy; card=gdrv;
    }
  }
  else
  {
    if(set_gfx_mode(GFX_VESA2L, x=320,y=480,0,0))
    {
      if(set_gfx_mode(GFX_VGA, x=320,y=200,0,0))
        {puts("Couldn't open graphic screen");exit(1);}
      else {Iniciox=(320-284)>>1; Inicioxvdp=0; Inicioy=/*(200-243)>>1*/0; Inicioyvdp=0;}
    }
    else {Iniciox=(320-284)>>1; Inicioy=/*(240-243)>>1*/0; Inicioxvdp=0; Inicioyvdp=2;}
  }

  if (x<512)
  {
    normalxmenu();
    trocarres=0;
    gfxrendermenu[2].flags=gfxrendermenu[3].flags=D_DISABLED;
  } else
    trocarenderxmode();

  if (y<384)
  {
    normalymenu();
    trocarres=0;
    gfxrendermenu[6].flags=gfxrendermenu[7].flags=gfxrendermenu[8].flags=gfxrendermenu[9].flags=gfxrendermenu[10].flags=D_DISABLED;
  } else
    trocarenderymode();

  Iniciox=((x-284)/2);
  Inicioy=((y-243)/2);
  if(Iniciox<0) {Inicioxvdp=(-Iniciox); Iniciox=0;}
  else Inicioxvdp=0;
  if(Inicioy<0) {Inicioyvdp=(-Inicioy); Inicioy=0;}
  else Inicioyvdp=0;
  if (Rendery!=NORMALY) Inicioy=((y-(243*2))>>1);
  if (Renderx!=NORMALX) Iniciox=((x-(284*2))>>1);
  if(Iniciox<0) {Inicioxvdp=(-Iniciox); Iniciox=0;}
  if(Inicioy<0) {Inicioyvdp=(-Inicioy); Inicioy=0;}

  text_mode(-1);
  if(gfx_driver->id==GFX_VGA) atualiza_tela=atualiza_vga;
  if(gfx_driver->id==GFX_VESA2L || gfx_driver->id==GFX_VESA2B)
  {
    if (Renderx==INTERPX)
    {
      if (Rendery==NORMALY)
        atualiza_tela=atualiza_v2_2i_1;
      if (Rendery==SCANLINES)
        atualiza_tela=atualiza_v2_2i_2s;
      if (Rendery==I50 || Rendery==I75 || Rendery==I87)
        atualiza_tela=atualiza_v2_2i_2t;
      if (Rendery==DOUBLEY)
        atualiza_tela=atualiza_v2_2i_2d;
    }
    else if (Renderx==NORMALX)
    {
      if (Rendery==NORMALY)
        atualiza_tela=atualiza_v2_1_1;
      if (Rendery==SCANLINES)
        atualiza_tela=atualiza_v2_1_2s;
      if (Rendery==I50 || Rendery==I75 || Rendery==I87 || Rendery==DOUBLEY)
        atualiza_tela=atualiza_v2_1_2t;
    }
    else
    {
      if (Rendery==NORMALY)
        atualiza_tela=atualiza_v2_2_1;
      if (Rendery==SCANLINES)
        atualiza_tela=atualiza_v2_2_2s;
      if (Rendery==I50 || Rendery==I75 || Rendery==I87 || Rendery==DOUBLEY)
        atualiza_tela=atualiza_v2_2_2t;
    }
  }
//  set_clip(screen,Iniciox,Inicioy,Iniciox+255,Inicioy+191);
  for(loop=0;loop<256;loop++)
    set_color(loop,&(msx_cores[loop%16]));
  if (Rendery==I50)
  {
    RGB te;
    for(loop=0;loop<16;loop++)
    {
      te=msx_cores[loop];
      te.r>>=1;
      te.g>>=1;
      te.b>>=1;
      set_color(loop+16,&te);
    }
  }
  if (Rendery==I75)
  {
    RGB te;
    for(loop=0;loop<16;loop++)
    {
      te=msx_cores[loop];
      te.r=(int)((te.r>>1) + (te.r>>2));
      te.g=(int)((te.g>>1) + (te.g>>2));
      te.b=(int)((te.b>>1) + (te.b>>2));
      set_color(loop+16,&te);
    }
  }
  if (Rendery==I87)
  {
    RGB te;
    for(loop=0;loop<16;loop++)
    {
      te=msx_cores[loop];
      te.r=(int)((te.r>>1) + (te.r>>2) + (te.r>>3));
      te.g=(int)((te.g>>1) + (te.g>>2) + (te.g>>3));
      te.b=(int)((te.b>>1) + (te.b>>2) + (te.b>>3));
      set_color(loop+16,&te);
    }
  }
  if (Renderx==INTERPX || Rendery==INTERPY)
  {
     int cont,i,j;
     RGB t1, t2, te;
     cont=16;
     for(i=0;i<16;i++)
     {
       for(j=0;j<16;j++)
       {
         if (i==1 && j==0) cont=17;
         if(j>=i)
         {
           if (i==j)
             {tabinterpola[(i<<4)+j]=i; tabatenua[(i<<4)+j]=i+128;}
           else
           {
             tabinterpola[(i<<4)+j]=cont;
             tabatenua[(i<<4)+j]=cont+128;
             t1=msx_cores[i];
             t2=msx_cores[j];
             te.r=(int)((t1.r>>1) + (t2.r>>1));
             te.g=(int)((t1.g>>1) + (t2.g>>1));
             te.b=(int)((t1.b>>1) + (t2.b>>1));
             set_color(cont++, &te);
           }
         }
         else
         {
           tabinterpola[(i<<4)+j]=tabinterpola[(j<<4)+i];
           tabatenua[(i<<4)+j]=tabatenua[(j<<4)+i];
         }
       }
     }
     if (Rendery==I50 || Rendery==I75 || Rendery==I87)
     {
       double fator=0.0;
       if(Rendery==I50) fator=0.5;
       if(Rendery==I75) fator=0.75;
       if(Rendery==I87) fator=0.875;
       for(i=0;i<122;i++)
       {
         RGB te;
         get_color(i,&te);
         te.r=(int)(te.r*fator);
         te.g=(int)(te.g*fator);
         te.b=(int)(te.b*fator);
         set_color(i+128,&te);
       }
     }


  }
}

int SaiMSX()
{
  int i;
//  set_gfx_mode(GFX_TEXT, 0,0,0,0);
  allegro_exit();
  set_text_debugger( 25 );

  SomSai();

  fclose(tape);
  fclose(trace);
  if (MSXDrive) fclose(drivea);

//  free(mem);
//  free(msx_ram);
  free(msx_disk);
//  free(goon);
  free(vazio);
  freememoria();
//  printf("%d,%d-%d,%d\n",Iniciox,Inicioy,Inicioxvdp,Inicioyvdp);
//  for(i=0;i<30;i++) puts("");
//  printf("%d,%d-%d,%d\n",z80perframe,z80pervdpline,framespersecond,CiclesVblank);
  puts("PowerMSX V0.07");
  puts("By Alexandre M. Maoski in 21/06/2000");
  puts("Any bug reports or suggestions,");
  puts("my e-mail is: amaoski@ig.com.br");
  exit(0);
}

int DiskRead(int a, UINT8 buff[], int sec)
{
  if(a>1) return 0;
  if(a==0) {
    if (sec>1439 || sec<0) return 0;
    fseek(drivea,sec*512,SEEK_SET);
    fread(buff,1,512,drivea);
    return 1;
  }
  if(a==1) {
    if (sec>1439 || sec<0) return 0;
    fseek(driveb,sec*512,SEEK_SET);
    fread(buff,1,512,driveb);
    return 1;
  }
  return 0;
}

int DiskWrite(int a, UINT8 buff[], int sec)
{
  if(a>1) return 0;
  if(a==0) {
    if (sec>1439 || sec<0) return 0;
    fseek(drivea,sec*512,SEEK_SET);
    fwrite(buff,1,512,drivea);
    return 1;
  }
  return 0;
}


int PSG14Read(int offset){return 255;}
void PSG14Write(int offset, int v){}
int PSG15Read(int offset){return 255;}
void PSG15Write(int offset,int v){}

void setGUI()
{
  resetar=0;
  install_mouse();
  install_timer();
  gui_fg_color=1;
  gui_bg_color=15;
  show_mouse(NULL);
  do_dialog(msxgui,0);
  show_mouse(NULL);
  remove_timer();
  remove_mouse();
}

void ParaSom()
{
  uclock_t a;
  if (!Somligado) return;
  ASetAudioMixerValue(AUDIO_MIXER_MASTER_VOLUME,0);
  a=uclock();
  while(uclock()-a<TIMERS_PER_SECOND/10)
  {
    AUpdateAudio();
  }
}

void ContSom()
{
  int n;
//  AOpenAudio(&info);
  if (!Somligado) return;
  for(n=0;n<4;n++)
  {
//    ASetVoiceVolume(voice[n],63);
//    AStartVoice(voice[n]);
  }
  ASetAudioMixerValue(AUDIO_MIXER_MASTER_VOLUME,volumeMestre);
}

void atualiza_vga()
{
  blit(minha_tela,screen,0,0,Iniciox,Inicioy,284,243);
}

void atualiza_v2_1_1()
{
  blit(minha_tela,screen,Inicioxvdp,Inicioyvdp,Iniciox,Inicioy,284,243);
}

void atualiza_v2_2_1()
{
  int y; word *ad;
  int x;
  byte *pt;
  bmp_select(screen);
  for (y=0; y<243; y++)
  {
    pt=minha_tela->line[y+Inicioyvdp];
    ad=(UINT16 *)bmp_write_line(screen, y+Inicioy)+Iniciox;
    for(x=0;x<71*4;x++)
    {
      bmp_write16((unsigned long)screen->line[y+Inicioy]+Iniciox+(x*2), *(pt)<<8|*(pt));
      pt++;
    }
  }
}

void atualiza_v2_1_2s()
{
  int y; long ad;
  short meu,scr;
  int width4;
  unsigned long pt;
	width4 = 71;
  meu=_my_ds();
  scr=screen->seg;
  pt=(unsigned long)minha_tela->line[0];
  for (y=0; y<243; y++)
  {
    pt=(unsigned long)minha_tela->line[y+Inicioyvdp];
    ad=bmp_write_line(screen, y*2+Inicioy)+Iniciox;
    _movedatal(meu,pt,scr, ad,width4);
//    pt+=256;
  }
}

void atualiza_v2_2_2s()
{
  int y; word *ad;
  int x;
  byte *pt;
  bmp_select(screen);
  for (y=0; y<243; y++)
  {
    pt=minha_tela->line[y+Inicioyvdp];
    ad=(UINT16 *)bmp_write_line(screen, y+Inicioy)+Iniciox;
    for(x=0;x<71*4;x++)
    {
      bmp_write16((unsigned long)screen->line[y*2+Inicioy]+Iniciox+(x*2), *(pt)<<8|*(pt));
      pt++;
    }
  }
}

void atualiza_v2_1_2d()
{
  int y; long ad;
  short meu,scr;
  int width4;
  unsigned long pt;
	width4 = 71;
  meu=_my_ds();
  scr=screen->seg;
  pt=(unsigned long)minha_tela->line[0];
  for (y=0; y<243; y++)
  {
    pt=(unsigned long)minha_tela->line[y+Inicioyvdp];
    ad=bmp_write_line(screen, y*2+Inicioy)+Iniciox;
    _movedatal(meu,pt,scr, ad,width4);
//    ad=bmp_write_line(screen, y*2+Inicioy+1)+Iniciox;
//    _movedatal(meu,pt,scr, ad,width4);
  }
}


void atualiza_v2_2_2d()
{
  int y; word *ad;
  int x;
  byte *pt;
  bmp_select(screen);
  for (y=0; y<243; y++)
  {
    pt=minha_tela->line[y+Inicioyvdp];
    ad=(UINT16 *)bmp_write_line(screen, y+Inicioy)+Iniciox;
    for(x=0;x<71*4;x++)
    {
      bmp_write16((unsigned long)screen->line[y*2+Inicioy]+Iniciox+(x*2), *(pt)<<8|*(pt));
      bmp_write16((unsigned long)screen->line[y*2+1+Inicioy]+Iniciox+(x*2), *(pt)<<8|*(pt));
      pt++;
    }
  }
}


void atualiza_v2_1_2t()
{
  int y; long ad;
  register int x;
  int valor;
  short meu,scr;
  int width4;
  unsigned long pt;
  valor=0x10101010;
	width4 = 71;
  meu=_my_ds();
  scr=screen->seg;
  pt=(unsigned long)minha_tela->line[0];
  _farsetsel(scr);
  for (y=0; y<243; y++)
  {
    pt=(unsigned long)minha_tela->line[y+Inicioyvdp];
    ad=bmp_write_line(screen, y*2+Inicioy)+Iniciox;
    _movedatal(meu,pt,scr, ad,width4);

    ad=bmp_write_line(screen, y*2+Inicioy+1)+Iniciox;
    for(x=0;x<71;x++)
      _farnspokel(ad+(x<<2), *((unsigned long *)pt+x)|valor);

  }
}

void atualiza_v2_2_2t()
{
  int y; long ad;
  register int x;
  int valor;
  short meu,scr;
  int width4;
  unsigned long pt;
  valor=0x10101010;
	width4 = 71;
  meu=_my_ds();
  scr=screen->seg;
  pt=(unsigned long)minha_tela->line[0];
  _farsetsel(scr);
  for (y=0; y<243; y++)
  {
    unsigned long g;
    int v1,v2,v3,v4;
    pt=(unsigned long)minha_tela->line[y];
    ad=bmp_write_line(screen, y*2+Inicioy)+Iniciox;
    for(x=0;x<71;x++)
    {
      g=*((unsigned long *)pt+x);
      v1=g>>24;
      v2=(g>>16)&0xff;
      v3=(g>>8)&0xff;
      v4=g&0xff;
      _farnspokel(ad+(x<<3),  (v4)|(v4<<8)|(v3<<16)|(v3<<24));
      _farnspokel(ad+(x<<3)+4,(v2)|(v2<<8)|(v1<<16)|(v1<<24));
    }

    ad=bmp_write_line(screen, y*2+Inicioy+1)+Iniciox;
    for(x=0;x<71;x++)
    {
      g=*((unsigned long *)pt+x);
      v1=g>>24;
      v2=(g>>16)&0xff;
      v3=(g>>8)&0xff;
      v4=g&0xff;
      _farnspokel(ad+(x<<3),  (v4)|(v4<<8)|(v3<<16)|(v3<<24)|valor);
      _farnspokel(ad+(x<<3)+4,(v2)|(v2<<8)|(v1<<16)|(v1<<24)|valor);
    }
    pt+=256;
  }
}

void atualiza_v2_2i_1()
{
  int y; long ad;
  short meu,scr;
  int width4;
  unsigned long pt;
	width4 = 71;
  meu=_my_ds();
  scr=screen->seg;
  _farsetsel(scr);
  pt=(unsigned long)minha_tela->line[0];
  for (y=0; y<243; y++)
  {
    int x,v1,v2,v3,v4,vn,g;
    pt=(unsigned long)minha_tela->line[y+Inicioyvdp];
    ad=bmp_write_line(screen, y+Inicioy)+Iniciox;
    for(x=0;x<71;x++)
    {
      g=*((unsigned long *)pt+x);
      v1=g>>24;
      v2=(g>>16)&0x0f;
      v3=(g>>8)&0x0f;
      v4=g&0x0f;
      g=*((unsigned long *)pt+x+1);
      vn=g&0x0f;
      _farnspokel(ad+(x<<3),  (v4)|(tabinterpola[(v4<<4)+v3]<<8)|(v3<<16)|(tabinterpola[(v3<<4)+v2]<<24));
      _farnspokel(ad+(x<<3)+4,(v2)|(tabinterpola[(v2<<4)+v1]<<8)|(v1<<16)|(tabinterpola[(v1<<4)+vn]<<24));
    }
  }
}

void atualiza_v2_2i_2s()
{
  int y; long ad;
  short meu,scr;
  int width4;
  unsigned long pt;
	width4 = 71;
  meu=_my_ds();
  scr=screen->seg;
  _farsetsel(scr);
  pt=(unsigned long)minha_tela->line[0];
  for (y=0; y<243; y++)
  {
    int x,v1,v2,v3,v4,vn,g;
    pt=(unsigned long)minha_tela->line[y+Inicioyvdp];
    ad=bmp_write_line(screen, y*2+Inicioy)+Iniciox;
    for(x=0;x<71;x++)
    {
      g=*((unsigned long *)pt+x);
      v1=g>>24;
      v2=(g>>16)&0x0f;
      v3=(g>>8)&0x0f;
      v4=g&0x0f;
      g=*((unsigned long *)pt+x+1);
      vn=g&0x0f;
      _farnspokel(ad+(x<<3),  (v4)|(tabinterpola[(v4<<4)+v3]<<8)|(v3<<16)|(tabinterpola[(v3<<4)+v2]<<24));
      _farnspokel(ad+(x<<3)+4,(v2)|(tabinterpola[(v2<<4)+v1]<<8)|(v1<<16)|(tabinterpola[(v1<<4)+vn]<<24));
    }
  }
}

void atualiza_v2_2i_2d()
{
  int y; long ad;
  short meu,scr;
  int width4;
//  unsigned int valor=0x00000000;
  unsigned long pt;
	width4 = 71;
  meu=_my_ds();
  scr=screen->seg;
  _farsetsel(scr);
  pt=(unsigned long)minha_tela->line[0];
  for (y=0; y<243; y++)
  {
    int x,v1,v2,v3,v4,vn,g;
    pt=(unsigned long)minha_tela->line[y+Inicioyvdp];
    ad=bmp_write_line(screen, (y<<1)+Inicioy)+Iniciox;
    for(x=0;x<71;x++)
    {
      g=*((unsigned long *)pt+x);
      v1=g>>24;
      v2=(g>>16)&0x0f;
      v3=(g>>8)&0x0f;
      v4=g&0x0f;
      g=*((unsigned long *)pt+x+1);
      vn=g&0x0f;
      _farnspokel(ad+(x<<3),  (v4)|(tabinterpola[(v4<<4)+v3]<<8)|(v3<<16)|(tabinterpola[(v3<<4)+v2]<<24));
      _farnspokel(ad+(x<<3)+4,(v2)|(tabinterpola[(v2<<4)+v1]<<8)|(v1<<16)|(tabinterpola[(v1<<4)+vn]<<24));
      _farnspokel(ad+(x<<3)+SCREEN_W,  (v4)|(tabinterpola[(v4<<4)+v3]<<8)|(v3<<16)|(tabinterpola[(v3<<4)+v2]<<24));
      _farnspokel(ad+(x<<3)+SCREEN_W+4,(v2)|(tabinterpola[(v2<<4)+v1]<<8)|(v1<<16)|(tabinterpola[(v1<<4)+vn]<<24));
    }
  }
}

void atualiza_v2_2i_2t()
{
  int y; long ad;
  short meu,scr;
  int width4;
  unsigned int valor=0x00800080;
  unsigned long pt;
	width4 = 71;
  meu=_my_ds();
  scr=screen->seg;
  _farsetsel(scr);
  pt=(unsigned long)minha_tela->line[0];
  for (y=0; y<243; y++)
  {
    int v1,v2,v3,v4,vn,g;
    register int x;
    pt=(unsigned long)minha_tela->line[y+Inicioyvdp];
    ad=bmp_write_line(screen, (y<<1)+Inicioy)+Iniciox;
    for(x=0;x<71;x++)
    {
      g=*((unsigned long *)pt+x);
      v1=g>>24;
      v2=(g>>16)&0x0f;
      v3=(g>>8)&0x0f;
      v4=g&0x0f;
      g=*((unsigned long *)pt+x+1);
      vn=g&0x0f;
      _farnspokel(ad+(x<<3),  (v4)|(tabinterpola[(v4<<4)|v3]<<8)|(v3<<16)|(tabinterpola[(v3<<4)|v2]<<24));
      _farnspokel(ad+(x<<3)+4,(v2)|(tabinterpola[(v2<<4)|v1]<<8)|(v1<<16)|(tabinterpola[(v1<<4)|vn]<<24));

      _farnspokel(ad+(x<<3)+SCREEN_W,  (v4)|(tabatenua[(v4<<4)+v3]<<8)|(v3<<16)|(tabatenua[(v3<<4)|v2]<<24)|valor);
      _farnspokel(ad+(x<<3)+SCREEN_W+4,(v2)|(tabatenua[(v2<<4)+v1]<<8)|(v1<<16)|(tabatenua[(v1<<4)|vn]<<24)|valor);
    }
  }
}

void trocarenderxmode()
{
  switch(Renderx)
  {
    case NORMALX:
    normalxmenu();
    break;
    case DOUBLEX:
    doublexmenu();
    break;
    case INTERPX:
    interpolaxmenu();
  }
}

void trocarenderymode()
{
  switch(Rendery)
  {
    case NORMALY:
    normalymenu();
    break;
    case SCANLINES:
    scanlinesmenu();
    break;
    case DOUBLEY:
    doubleymenu();
    break;
    case I50:
    i50menu();
    break;
    case I75:
    i75menu();
    break;
    case I87:
    i87menu();
    break;
  }
}


void addmemoria(UINT8 *t)
{
  static int ct=0;
  memoria[ct++]=t;
}

void freememoria()
{
  int i;
  for(i=0;i<32;i++)
    if(memoria[i]) free(memoria[i]);
}

int analex(FILE* arq, char* token)
{
  int a;
  int bak;
  int cont=0;

  do
  {
    a=getc(arq);
    if (feof(arq)) return 0;
  } while (isspace(a));

  if(a=='/')
  {
    a=getc(arq);
    if (a!='*') {ungetc(a,arq); token[0]='/'; exit(1);token[1]='\0'; return 3;}

    a=getc(arq);
    do
    {
      bak=a;
      a=getc(arq);
      if(feof(arq)) exit(1);
    } while(a!='/' || bak!='*');
    token[0]='\0'; token[1]='\0';

  }

  if (isalpha(a))
  {
    while (isalpha(a) || isdigit(a))
    {
      token[cont++]=a;
      if(cont>70) break;
      a=getc(arq);
      if (feof(arq)) return 0;
    }
    ungetc(a,arq);
    token[cont]='\0';
    return 2;
  }
  else if(isdigit(a))
  {
    while (isdigit(a) || isalpha(a))
    {  token[cont++]=a;
      if(cont>70) break;
      a=getc(arq);
      if (feof(arq)) return 0;
    }
    ungetc(a,arq);
    token[cont]='\0';
    return 1;
  }
  else if(ispunct(a))
  {
    token[cont++]=a;
    token[cont++]='\0';
    return 3;
  }
  return 0;
}

UINT8 processaini(FILE* fp)
{
  char token[80];
  while(1)
  {
    analex(fp, token);
    if(!strcmp(token,"Width"))
    {
      analex(fp,token);
      if(token[0]!='=') exit(1);
      analex(fp,token);
      if(feof(fp)) exit(0);
      sscanf(token,"%d",&ResX);
    }
    if(!strcmp(token,"Height"))
    {
      analex(fp,token);
      if(token[0]!='=') exit(1);
      analex(fp,token);
      if(feof(fp)) exit(0);
      sscanf(token,"%d",&ResY);
    }
    if(!strcmp(token,"Renderx"))
    {
      analex(fp,token);
      if(token[0]!='=') exit(1);
      analex(fp,token);
      if(feof(fp)) exit(0);
      sscanf(token,"%d",&Renderx);
    }
    if(!strcmp(token,"Rendery"))
    {
      analex(fp,token);
      if(token[0]!='=') exit(1);
      analex(fp,token);
      if(feof(fp)) exit(0);
      sscanf(token,"%d",&Rendery);
    }
    if(!strcmp(token,"Vesa"))
    {
      analex(fp,token);
      if(token[0]!='=') exit(1);
      analex(fp,token);
      if(feof(fp)) exit(0);
      if(token[0]=='0')
        Placa=GFX_VGA;
      else
        Placa=GFX_VESA2L;
    }
    if(!strcmp(token,"Sound"))
    {
      analex(fp,token);
      if(token[0]!='=') exit(1);
      analex(fp,token);
      if(feof(fp)) exit(0);
      sscanf(token,"%ld",&Somligado);
    }
    if(!strcmp(token,"Soundrate"))
    {
      analex(fp,token);
      if(token[0]!='=') exit(1);
      analex(fp,token);
      if(feof(fp)) exit(0);
      sscanf(token,"%ld",&meusoundRate);
    }
    if(!strcmp(token,"Frameskip"))
    {
      analex(fp,token);
      if(token[0]!='=') exit(1);
      analex(fp,token);
      if(feof(fp)) exit(0);
      sscanf(token,"%ld",&Nframeskip);
    }
    if(!strcmp(token,"Debug"))
    {
      analex(fp,token);
      if(token[0]!='=') exit(1);
      analex(fp,token);
      if(feof(fp)) exit(0);
      sscanf(token,"%d",(int *)&pointz80->Trace);
    }

    if(feof(fp)) return 0;
  }
}
UINT8 *cria_carrega_arq(FILE* fp, int tam)
{
  UINT8 *p;
  p=(UINT8 *)malloc(tam);
  if(!p) exit(0);
  addmemoria(p);
  memset(p,0,tam);
  fread(p,1,tam,fp);
  return p;
}

int patch_com(FILE*arq, int ps, int ss)
{
  char token[80];
  int posicao=0;
  int numero;
  analex(arq, token);
  if(token[0]!='{') return 0;
  analex(arq, token);
  while (token[0]!='}')
  {
    sscanf(token,"%x",&posicao);
    analex(arq,token);
    if(token[0]!=':') return 0;
    analex(arq,token);
    while (token[0]!=';')
    {
      sscanf(token,"%x",&numero);
      Msx[ps][ss][posicao>>13][posicao&0x1FFF]=numero;
      posicao++;
      analex(arq,token);
      if(token[0]==',') analex(arq,token);
    }
    analex(arq,token);
  }
  return 1;
}

void addtoken(int posicao, int posicao2, char* token, int ps, int ss)
{
  tabtoken[postoken].posicao=posicao;
  tabtoken[postoken].posicao2=posicao2;
  strcpy(tabtoken[postoken].token,token);
  tabtoken[postoken].ps=ps;
  tabtoken[postoken].ss=ss;
  postoken++;
}

int buscatoken(int posicao, char* token, int ps, int ss)
{
  int i;
  for(i=0;i<postoken;i++)
    if(posicao>=tabtoken[i].posicao && posicao<=tabtoken[i].posicao2)
    {
      sprintf(token,"%s+%x",tabtoken[i].token,posicao-tabtoken[i].posicao);
      return 1;
    }
  return 0;
}
int debug_com(FILE*arq, int ps, int ss)
{
  char token[80];
  int posicao=0;
  int posicao2=0;
//  int numero;
  analex(arq, token);
  if(token[0]!='{') return 0;
  analex(arq, token);
  while (token[0]!='}')
  {
    posicao2=0;
    sscanf(token,"%x",&posicao);
    analex(arq,token);
    if(token[0]=='-')
    {
      analex(arq,token);
      sscanf(token,"%x",&posicao2);
      analex(arq,token);
    }
    if(token[0]!=':') return 0;
    analex(arq,token);
    if(posicao2==0) posicao2=posicao;
    addtoken(posicao,posicao2,token,ps,ss);
    analex(arq,token);
  }
  return 1;
}

int trataslot(FILE* arq, int ps, int ss)
{
  FILE* roms;
  UINT8 *pont;
  char token[80];
  char nomerom[80]="";
  int posicao=0;
  int tamanho=0;
//  set_gfx_mode(GFX_TEXT,0,0,0,0);
//  puts("trataslot");
//  exit(0);
  analex(arq, token);
  if(token[0]!='{') return 0;
  analex(arq,token);

  while (token[0]!='}')
  {
    if(!strcmp(token,"rom"))
    {
      analex(arq,token);
      if(token[0]!='\"') return 0;
      analex(arq,token);
      nomerom[0]='\0';
      while (token[0]!='\"')
      {
        strcat(nomerom,token);
        analex(arq,token);
        if (feof(arq)) return 0;
      }

//  set_gfx_mode(GFX_TEXT,0,0,0,0);
//  printf("%s\n",nomerom);
//  exit(0);

      roms=fopen(nomerom,"rb");
      if(roms==0) exit(1);
      analex(arq,token);
      sscanf(token,"%d",&tamanho);
      tamanho*=1024;
      if(tamanho<0 || tamanho+posicao>65536) return 0;
      pont=cria_carrega_arq(roms, tamanho);
      Msx[ps][ss][posicao>>13]=pont;
      if(tamanho>8192) Msx[ps][ss][(posicao>>13)+1]=pont+8192;
      if(tamanho>16384) Msx[ps][ss][(posicao>>13)+2]=pont+16384;
      if(tamanho>16384+8192) Msx[ps][ss][(posicao>>13)+3]=pont+16384+8192;
      fclose(roms);
      posicao+=tamanho;
    }
    if(!strcmp(token,"ram"))
    {
      if(analex(arq,token)!=1) return 0;
      sscanf(token,"%d",&tamanho);
      tamanho*=1024;
      pont=(UINT8 *)malloc(tamanho);
      addmemoria(pont);
      memset(pont,0,tamanho);
      Msx[ps][ss][posicao>>13]=pont;
      RomP[ps][ss][posicao>>13]=0;
      if(tamanho>8192)
      {
        Msx[ps][ss][(posicao>>13)+1]=pont+8192;
        RomP[ps][ss][(posicao>>13)+1]=0;
      }
      if(tamanho>16384)
      {
        Msx[ps][ss][(posicao>>13)+2]=pont+16384;
        RomP[ps][ss][(posicao>>13)+2]=0;
      }
      if(tamanho>16384+8192)
      {
        Msx[ps][ss][(posicao>>13)+3]=pont+16384+8192;
        RomP[ps][ss][(posicao>>13)+3]=0;
      }
      if(tamanho>32768)
      {
        Msx[ps][ss][(posicao>>13)+4]=pont+32768;
        RomP[ps][ss][(posicao>>13)+4]=0;
      }
      if(tamanho>32768+8192)
      {
        Msx[ps][ss][(posicao>>13)+5]=pont+32768+8192;
        RomP[ps][ss][(posicao>>13)+5]=0;
      }
      if(tamanho>32768+16384)
      {
        Msx[ps][ss][(posicao>>13)+6]=pont+32768+16384;
        RomP[ps][ss][(posicao>>13)+6]=0;
      }
      if(tamanho>32768+16384+8192)
      {
        Msx[ps][ss][(posicao>>13)+7]=pont+32768+16384+8192;
        RomP[ps][ss][(posicao>>13)+7]=0;
      }
      posicao+=tamanho;
    }
    if(!strcmp(token,"unused"))
    {
      if(analex(arq,token)!=1) return 0;
      sscanf(token,"%d",&tamanho);
      tamanho*=1024;
      posicao+=tamanho;
      if(posicao>32768+16384+8192) return 0;
    }
    if(!strcmp(token,"megaram"))
    {
      if(analex(arq,token)!=1) return 0;
      sscanf(token,"%d",&tamanho);
      tamanho*=1024;
      pont=(UINT8 *)malloc(tamanho);
      addmemoria(pont);
      memset(pont,0,tamanho);
      pmegaram[ps][ss]=pont;
      megaram[ps][ss]=tamanho/8192;
    }
    if(!strcmp(token,"mapper"))
    {
      if(analex(arq,token)!=1) return 0;
      sscanf(token,"%d",&tamanho);
      tamanho*=1024;
      pont=(UINT8 *)malloc(tamanho);
      addmemoria(pont);
      memset(pont,0x00,tamanho);
      pmapper[ps][ss]=pont;
      mapper[ps][ss]=tamanho/16384;

      RomP[ps][ss][0]=0;
      RomP[ps][ss][1]=0;
      RomP[ps][ss][2]=0;
      RomP[ps][ss][3]=0;
      RomP[ps][ss][4]=0;
      RomP[ps][ss][5]=0;
      RomP[ps][ss][6]=0;
      RomP[ps][ss][7]=0;

    }
    if(!strcmp(token,"patch"))
    {
      patch_com(arq,ps,ss);
    }
    if(!strcmp(token,"debug"))
    {
      debug_com(arq,ps,ss);
    }
  analex(arq,token);
  }


//  analex(arq,token);
//  if(token[0]!='}') return 0;
  return 1;
}

int rastreia_include(FILE** arq)
{
  FILE *final;
  FILE *inc;
  int aspas=0;
  char token[40];
  char nomerom[40];
  final=fopen("temp.tmp","wt+");
  for(;;)
  {
    analex(*arq,token);
    if (feof(*arq)) break;
    if(!strcmp(token,"include"))
    {
      analex(*arq,token);
      if(token[0]!='\"') return 0;
      analex(*arq,token);
      nomerom[0]='\0';
      while (token[0]!='\"')
      {
        strcat(nomerom,token);
        analex(*arq,token);
        if (feof(*arq)) return 0;
      }
      inc=fopen(nomerom,"rt");
      while(!feof(inc))
      {
        analex(*arq,token);
        if(token[0]=='\"') aspas^=1;
        if(aspas) fprintf(final,"%s",token);
        else fprintf(final,"%s\n ",token);
      }
      fclose(inc);
    }
    else
    {
      if(token[0]=='\"') aspas^=1;
      if(aspas) fprintf(final,"%s",token);
      else fprintf(final,"%s\n ",token);
    }
  }
  fclose(*arq);
  rewind(final);
  fclose(final);
  return 1;
//  return *arq;
}

int lescript(FILE* arq)
{
  char token[40];
//  rastreia_include(&arq);
//  arq=fopen("temp.tmp","rt");
  while(analex(arq,token))
  {
    if(!strcmp(token,"mapslots"))
    {
      if(analex(arq,token)==0) return 0;
      if(token[0]=='=')
      {
        int j;
        for(j=0;j<4;j++)
        {
          int k,num;
          if((k=analex(arq,token))==0) return 0;
          if(k==1) sscanf(token,"%d",&num);
          if(num<0 || num >1) return 0;
          IsExpanded[j]=num;
          if (j==3) continue;
          analex(arq,token);
          if(token[0]!=',') return 0;
        }
      }
    }
    if(!strcmp(token,"slot"))
    {
      int k,num,ps,ss;
      k=analex(arq,token);
      if(k!=1) return 0;
      sscanf(token,"%d",&num);
      if(num<0 || num>3) return 0;
      ps=num;
      k=analex(arq,token);
      if(token[0]!=',') return 0;
      k=analex(arq,token);
      if(k!=1) return 0;
      sscanf(token,"%d",&num);
      if(num<0 || num>3) return 0;
      ss=num;
      trataslot(arq,ps,ss);
    }
  }
  return 1;
}

int main(int argc, char* argv[])
{
  UINT16 Patdis[]={0x4010,0x4013,0x4016,0x4019,0x404c,0x404f,0x4052,0};
  int i;
  int retraceInicial;
  int loop;
  Z80 meuz80;
  FILE *fp;

  Nmtape=NULL;
  Nmdrivea=NULL;
  Nmdriveb=NULL;

  vdpline=-1;
  IsExpanded[0]=0;
  IsExpanded[1]=0;
  IsExpanded[2]=0;
  IsExpanded[3]=0;

  vazio=(UINT8 *)malloc(8*1024);
  if(!vazio) {puts("Nao consegui alocar memoria");exit(1);}
  memset(vazio,0x7F,8*1024);

  for(loop=0;loop<8;loop++)
  {
    for(i=0;i<4;i++)
    {
      Msx[0][i][loop]=vazio;
      Msx[1][i][loop]=vazio;
      Msx[2][i][loop]=vazio;
      Msx[3][i][loop]=vazio;
      goon[0][i]=vazio;
      goon[1][i]=vazio;
      goon[2][i]=vazio;
      goon[3][i]=vazio;
      pmegaram[0][i]=vazio;
      pmegaram[1][i]=vazio;
      pmegaram[2][i]=vazio;
      pmegaram[3][i]=vazio;
      pmapper[0][i]=vazio;
      pmapper[1][i]=vazio;
      pmapper[2][i]=vazio;
      pmapper[3][i]=vazio;
    }
  }

  for(loop=0;loop<4;loop++)
  {
    for(i=0;i<4;i++)
    {
      megarom[i][loop]=0;
      megaram[i][loop]=0;
      mapper[i][loop]=0;
    }
  }

  ResX=ResY=0;
  Placa=GFX_VGA;
  Somligado=1;
  meusoundRate=44100;
  diskPresentA=0;
  Nframeskip=0;
  framespersecond=60;
  pointz80=&meuz80;
  meuz80.Trace=0;
  meuz80.IAutoReset=1;
  AddWait();
  fp=fopen("msx.cfg","rb");
  if(fp)
  {
    lescript(fp);
    fclose(fp);
  }

  fp=fopen("pmsx.ini","rb");
  if(fp)
  {
    processaini(fp);
    fclose(fp);
  }

  allegro_init();
  
  Porta_8e=1;

  for(loop=0;loop<18;loop++)
  {
    sndbackx[loop]=snd_dialog[loop].x;
    sndbacky[loop]=snd_dialog[loop].y;
  }
//  vram=(UINT8 *)malloc(16*1024);
//  if(vram==0) {puts("Nao consegui alocar memoria");exit(1);}
//  memset(vram,0,16*1024);
  
//  msx_rom=(UINT8 *)malloc(32*1024);
//  if(msx_rom==0) {puts("Nao consegui alocar memoria");exit(1);}
//  memset(msx_rom,0,32*1024);
  
  goon[1][0]=(UINT8 *)malloc(512*1024);
  if(goon[1][0]==0) {puts("Nao consegui alocar memoria");exit(1);}
  memset(goon[1][0],0x7F,512*1024);

  goon[2][0]=(UINT8 *)malloc(512*1024);
  if(goon[2][0]==0) {puts("Nao consegui alocar memoria");exit(1);}
  memset(goon[2][0],0x7F,512*1024);

  msx_disk=(UINT8 *)malloc(16*1024);
  if(msx_disk==0) {puts("Nao consegui alocar Disk");exit(1);}
  memset(msx_disk,0,16*1024);

  MSXDrive=0x0;
  Tipomegarom=0;

  for(loop=1,i=0; loop<argc; loop++,i=0)
  {
    while(argv[loop][i]) {argv[loop][i]=tolower(argv[loop][i]); i++;}
    if(argv[loop][0]!='-') Nmcarta=(UINT8 *)argv[loop];
    else if(!strcmp(argv[loop],"-diska"))
      { MSXDrive=1; Nmdrivea=(UINT8 *)argv[loop+1]; loop++;}
    else if(!strcmp(argv[loop],"-diskb"))
      { MSXDrive=2; Nmdriveb=(UINT8 *)argv[loop+1]; loop++;}
    else if(!strcmp(argv[loop],"-tape"))
      { Nmtape=(UINT8 *)argv[loop+1]; loop++;}
    else if(!strcmp(argv[loop],"-ifreq"))
      { sscanf(argv[loop+1], "%d",&framespersecond); loop++;}
    else if(!strcmp(argv[loop],"-roma"))
      { sscanf(argv[loop+1], "%ld",&Tipomegarom); loop++;}
    else if(!strcmp(argv[loop],"-sr"))
      { sscanf(argv[loop+1],"%ld",&meusoundRate); loop++;}
    else if(!strcmp(argv[loop],"-fs"))
      { sscanf(argv[loop+1],"%ld",&Nframeskip); loop++;}
    else if(!strcmp(argv[loop],"-sound"))
      { sscanf(argv[loop+1],"%ld",&Somligado); loop++;}
    else if(isdigit(argv[loop][1]))
      { sscanf(argv[loop]+1,"%dx%d",&ResX,&ResY); Placa=GFX_VESA2L;}
  }

  tempodeframe=TIMERS_PER_SECOND/framespersecond;
  z80perframe=Z80FREQ/framespersecond;
  z80pervdpline=(int)(Z80FREQ/(1/((double)(63.695/1000000))));
  CiclesVblank=z80perframe-(243*z80pervdpline);

  if (CiclesVblank<=0) {puts("ifreq is too strange"); exit(1);}
  if(Nframeskip>3) Nframeskip=3;
  if(meusoundRate>44100) meusoundRate=44100;
  if(Somligado==0)
    menucfg[3].flags=D_DISABLED;

  if (Nmtape==NULL) fp=fopen("tape.cas","ab+");
  else fp=fopen((char *)Nmtape,"ab+");

  if (MSXDrive)
  {
    fp=fopen("disk.rom","rb");
    if(fp==0) {puts("Couldn't open DISK.ROM"); exit(1);}
    fread(msx_disk,1,16384,fp);
    fclose(fp);
  }
  

  joy_type=JOY_TYPE_STANDARD;
//  initialise_joystick();
  loop=0;

  meuz80.Trap=0xffff;
  if(meuz80.Trace) set_text_debugger(debug_linhas);
  ResetZ80(&meuz80);

  install_keyboard();


//  Msx[0][0][0]=msx_rom;
//  Msx[0][0][1]=msx_rom+8192;
//  Msx[0][0][2]=msx_rom+16384;
//  Msx[0][0][3]=msx_rom+16384+8192;
//  Msx[0][0][4]=0;
//  Msx[0][0][5]=0;
//  Msx[0][0][6]=0;
//  Msx[0][0][7]=0;
//  Msx[3][0][0]=msx_ram;
//  Msx[3][0][1]=msx_ram+8192;
//  Msx[3][0][2]=msx_ram+16384;
//  Msx[3][0][3]=msx_ram+16384+8192;
//  Msx[3][0][4]=msx_ram+32768;
//  Msx[3][0][5]=msx_ram+32768+8192;
//  Msx[3][0][6]=msx_ram+32768+16384;
//  Msx[3][0][7]=msx_ram+32768+16384+8192;

  if (Nmcarta)
  {
    fp=fopen((char *)Nmcarta,"rb");
    if (fp==0)
    {
      printf("%s not found",Nmcarta);
      exit(1);
    }
    CarregaRom(fp,1,0);
    fclose(fp);
  }  else tipocartucho=0;

  if (Nmcartb)
  {
    fp=fopen((char *)Nmcartb,"rb");
    if (fp==0)
    {
      printf("%s not found",Nmcartb);
      exit(1);
    }
    CarregaRom(fp,2,0);
    fclose(fp);
  }
  minha_tela=create_bitmap(342,262);
  if (!meuz80.Trace)
  {
    if(ResX==0 || ResY==0)
      setscreen(0,0,0);
    else setscreen(Placa,ResX,ResY);
  }
//  if (!meuz80.Trace) setGUI();

  retraceInicial=retrace_count;
  trace=fopen("log","wt");

//  for(loop=0;Pattap[loop];loop++)
//  {
//    msx_rom[Pattap[loop]]  =0xED;
//    msx_rom[Pattap[loop]+1]=0xFE;
//    msx_rom[Pattap[loop]+2]=0xC9;
//  }
  if(MSXDrive)
  {
    for(loop=0;Patdis[loop];loop++)
    {
      msx_disk[Patdis[loop]-0x4000]  =0xED;
      msx_disk[Patdis[loop]+1-0x4000]=0xFE;
      msx_disk[Patdis[loop]+2-0x4000]=0xC9;
    }
  }
  tape=fopen((char *)Nmtape,"ab+");
  if (MSXDrive)
  {
    if(access((char *)Nmdrivea,W_OK))
    {
      drivea=fopen((char *)Nmdrivea,"ab+");
      driveawrite=1;
    }
    else
    {
      drivea=fopen((char *)Nmdrivea,"ab+");
      diskPresentA=1;
      driveawrite=1;
    }
  }
  if (Nmdriveb) driveb=fopen((char *)Nmdriveb,"ab+");


  switch(Nframeskip)
  {
    case 0:
      zeroframe();
      break;
    case 1:
      umframe();
      break;
    case 2:
      doisframe();
      break;
    case 3:
      tresframe();
  }
  Out_a8(0,0);
  trocarenderxmode();
  trocarenderymode();
  if (!meuz80.Trace)
  {
    if (ResX==0 || ResY==0)
      setscreen(0,0,0);
    else setscreen(Placa, ResX, ResY);
  }
  trocarres=0;
  SomInit();
//  install_timer();

  RunZ80(&meuz80);
  
//  loop=retrace_count-retraceInicial;
  SaiMSX();
  return 1; //Nunca chega aqui, e' so' para compilar com -Wall
}

