/*****************************************************************************
 *
 *	 z80dasm.c
 *	 Portable Z80 disassembler
 *
 *	 Copyright (C) 1998 Juergen Buchmueller, all rights reserved.
 *
 *	 - This source code is released as freeware for non-commercial purposes.
 *	 - You are free to use and redistribute this code in modified or
 *	   unmodified form, provided you list me in the credits.
 *	 - If you modify this source code, you must add a notice to each modified
 *	   source file that it has been changed.  If you're a nice person, you
 *	   will clearly mark each change too.  :)
 *	 - If you wish to use this for commercial purposes, please contact me at
 *	   pullmoll@t-online.de
 *	 - The author of this copywritten work reserves the right to change the
 *     terms of its usage and license at any time, including retroactively
 *   - This entire notice must remain in the source code.
 *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#include <conio.h>

#include "allegro.h"
#include "debug.h"
#include "z80.h"
#include "vdp.h"

typedef unsigned char UINT8;
typedef signed char INT8;
typedef unsigned short UINT16;

extern int savestatemesmo(char*);
extern int loadstatemesmo(char*);
extern void setscreen(int, int, int);
//extern void Desenha_tela(void);
extern int SaiMSX(void);
extern int buscatoken(int, char*, int, int);
void monta_flags(char*);
extern void (*atualiza_tela)(void);

extern class VDP vdp;
extern int Placa, ResX, ResY;
extern int Porta_a8;
extern UINT8 vdpline;
extern UINT8 mapper[4][4];
extern UINT8 memmapper[4][4][4];
extern UINT8 megarom[4][4];
extern UINT8 memmegarom[4][4][8];
extern UINT8 IsExpanded[4];
extern UINT8 SlotExpanded[4];
extern int postoken;
extern struct s_tabtoken tabtoken[];

int ilegal_op;
extern int sujo;
extern Z80* pointz80;
int modo;
int graf_mode;
int posdisass;
int poscursor;
int posmemory;
int posregs;
int poscomando;
int numPassosTrace;
int debug_linhas=25;

enum e_mnemonics {
	zADC  ,zADD  ,zAND	,zBIT  ,zCALL ,zCCF  ,zCP	,zCPD  ,
	zCPDR ,zCPI  ,zCPIR ,zCPL  ,zDAA  ,zDB	 ,zDEC	,zDI   ,
	zDJNZ ,zEI	 ,zEX	,zEXX  ,zHLT  ,zIM	 ,zIN	,zINC  ,
	zIND  ,zINDR ,zINI	,zINIR ,zJP   ,zJR	 ,zLD	,zLDD  ,
	zLDDR ,zLDI  ,zLDIR ,zNEG  ,zNOP  ,zOR	 ,zOTDR ,zOTIR ,
	zOUT  ,zOUTD ,zOUTI ,zPOP  ,zPUSH ,zRES  ,zRET	,zRETI ,
	zRETN ,zRL	 ,zRLA	,zRLC  ,zRLCA ,zRLD  ,zRR	,zRRA  ,
	zRRC  ,zRRCA ,zRRD	,zRST  ,zSBC  ,zSCF  ,zSET	,zSLA  ,
	zSLL  ,zSRA  ,zSRL	,zSUB  ,zXOR
};

static char *s_mnemonic[] = {
	"adc", "add", "and", "bit", "call","ccf", "cp",  "cpd",
	"cpdr","cpi", "cpir","cpl", "daa", "db",  "dec", "di",
	"djnz","ei",  "ex",  "exx", "halt","im",  "in",  "inc",
	"ind", "indr","ini", "inir","jp",  "jr",  "ld",  "ldd",
	"lddr","ldi", "ldir","neg", "nop", "or",  "otdr","otir",
	"out", "outd","outi","pop", "push","res", "ret", "reti",
	"retn","rl",  "rla", "rlc", "rlca","rld", "rr",  "rra",
	"rrc", "rrca","rrd", "rst", "sbc", "scf", "set", "sla",
	"sll", "sra", "srl", "sub", "xor "
};

typedef struct {
	UINT8	access;
	UINT8	mnemonic;
	const char *arguments;
}	z80dasm;

typedef struct {
  int x;
  int y;
  int desl;
  int reg;
} tp_msxregs;

#define NUMREGS 48
#define MAXMEM 256

tp_msxregs msxregs[]={{0,0,3,0},{1,0,2,0},{2,0,1,0},{3,0,0,0},
                      {8,0,3,1},{9,0,2,1},{10,0,1,1},{11,0,0,1},
                      {16,0,3,2},{17,0,2,2},{18,0,1,2},{19,0,0,2},
                      {24,0,3,3},{25,0,2,3},{26,0,1,3},{27,0,0,3},
                      {32,0,3,4},{33,0,2,4},{34,0,1,4},{35,0,0,4},
                      {40,0,3,5},{41,0,2,5},{42,0,1,5},{43,0,0,5},

                      {0,1,3,6},{1,1,2,6},{2,1,1,6},{3,1,0,6},
                      {8,1,3,7},{9,1,2,7},{10,1,1,7},{11,1,0,7},
                      {16,1,3,8},{17,1,2,8},{18,1,1,8},{19,1,0,8},
                      {24,1,3,9},{25,1,2,9},{26,1,1,9},{27,1,0,9},
                      {32,1,3,10},{33,1,2,10},{34,1,1,10},{35,1,0,10},
                      {40,1,3,11},{41,1,2,11},{42,1,1,11},{43,1,0,11}
                      };
int basexregs=29;
int baseyregs=1;

int basexmem=31;
int baseymem=5;
int posxmem;
int posymem;
int basemem;
int basevram;

#define _0      0
#define _JP 1
#define _JR 2
#define _RM 3
#define _WM 4
#define _RW 5
#define _RP 6
#define _WP 7

#define DISASS 0
#define MSXREGS 1
#define MEMORY 2

#define MSXRAM 0
#define MSXVRAM 1

int tipomem=MSXRAM;

#define cpu_readop RdZ80
#define cpu_readop_arg RdZ80

static z80dasm mnemonic_xx_cb[256]= {
	{_RW,zRLC,"b=Y"},   {_RW,zRLC,"c=Y"},   {_RW,zRLC,"d=Y"},   {_RW,zRLC,"e=Y"},
	{_RW,zRLC,"h=Y"},   {_RW,zRLC,"l=Y"},   {_RW,zRLC,"Y"},     {_RW,zRLC,"a=Y"},
	{_RW,zRRC,"b=Y"},   {_RW,zRRC,"c=Y"},   {_RW,zRRC,"d=Y"},   {_RW,zRRC,"e=Y"},
	{_RW,zRRC,"h=Y"},   {_RW,zRRC,"l=Y"},   {_RW,zRRC,"Y"},     {_RW,zRRC,"a=Y"},
	{_RW,zRL,"b=Y"},    {_RW,zRL,"c=Y"},    {_RW,zRL,"d=Y"},    {_RW,zRL,"e=Y"},
	{_RW,zRL,"h=Y"},    {_RW,zRL,"l=Y"},    {_RW,zRL,"Y"},      {_RW,zRL,"a=Y"},
	{_RW,zRR,"b=Y"},    {_RW,zRR,"c=Y"},    {_RW,zRR,"d=Y"},    {_RW,zRR,"e=Y"},
	{_RW,zRR,"h=Y"},    {_RW,zRR,"l=Y"},    {_RW,zRR,"Y"},      {_RW,zRR,"a=Y"},
	{_RW,zSLA,"b=Y"},   {_RW,zSLA,"c=Y"},   {_RW,zSLA,"d=Y"},   {_RW,zSLA,"e=Y"},
	{_RW,zSLA,"h=Y"},   {_RW,zSLA,"l=Y"},   {_RW,zSLA,"Y"},     {_RW,zSLA,"a=Y"},
	{_RW,zSRA,"b=Y"},   {_RW,zSRA,"c=Y"},   {_RW,zSRA,"d=Y"},   {_RW,zSRA,"e=Y"},
	{_RW,zSRA,"h=Y"},   {_RW,zSRA,"l=Y"},   {_RW,zSRA,"Y"},     {_RW,zSRA,"a=Y"},
	{_RW,zSLL,"b=Y"},   {_RW,zSLL,"c=Y"},   {_RW,zSLL,"d=Y"},   {_RW,zSLL,"e=Y"},
	{_RW,zSLL,"h=Y"},   {_RW,zSLL,"l=Y"},   {_RW,zSLL,"Y"},     {_RW,zSLL,"a=Y"},
	{_RW,zSRL,"b=Y"},   {_RW,zSRL,"c=Y"},   {_RW,zSRL,"d=Y"},   {_RW,zSRL,"e=Y"},
	{_RW,zSRL,"h=Y"},   {_RW,zSRL,"l=Y"},   {_RW,zSRL,"Y"},     {_RW,zSRL,"a=Y"},
	{_RM,zBIT,"b=0,Y"}, {_RM,zBIT,"c=0,Y"}, {_RM,zBIT,"d=0,Y"}, {_RM,zBIT,"e=0,Y"},
	{_RM,zBIT,"h=0,Y"}, {_RM,zBIT,"l=0,Y"}, {_RM,zBIT,"0,Y"},   {_RM,zBIT,"a=0,Y"},
	{_RM,zBIT,"b=1,Y"}, {_RM,zBIT,"c=1,Y"}, {_RM,zBIT,"d=1,Y"}, {_RM,zBIT,"e=1,Y"},
	{_RM,zBIT,"h=1,Y"}, {_RM,zBIT,"l=1,Y"}, {_RM,zBIT,"1,Y"},   {_RM,zBIT,"a=1,Y"},
	{_RM,zBIT,"b=2,Y"}, {_RM,zBIT,"c=2,Y"}, {_RM,zBIT,"d=2,Y"}, {_RM,zBIT,"e=2,Y"},
	{_RM,zBIT,"h=2,Y"}, {_RM,zBIT,"l=2,Y"}, {_RM,zBIT,"2,Y"},   {_RM,zBIT,"a=2,Y"},
	{_RM,zBIT,"b=3,Y"}, {_RM,zBIT,"c=3,Y"}, {_RM,zBIT,"d=3,Y"}, {_RM,zBIT,"e=3,Y"},
	{_RM,zBIT,"h=3,Y"}, {_RM,zBIT,"l=3,Y"}, {_RM,zBIT,"3,Y"},   {_RM,zBIT,"a=3,Y"},
	{_RM,zBIT,"b=4,Y"}, {_RM,zBIT,"c=4,Y"}, {_RM,zBIT,"d=4,Y"}, {_RM,zBIT,"e=4,Y"},
	{_RM,zBIT,"h=4,Y"}, {_RM,zBIT,"l=4,Y"}, {_RM,zBIT,"4,Y"},   {_RM,zBIT,"a=4,Y"},
	{_RM,zBIT,"b=5,Y"}, {_RM,zBIT,"c=5,Y"}, {_RM,zBIT,"d=5,Y"}, {_RM,zBIT,"e=5,Y"},
	{_RM,zBIT,"h=5,Y"}, {_RM,zBIT,"l=5,Y"}, {_RM,zBIT,"5,Y"},   {_RM,zBIT,"a=5,Y"},
	{_RM,zBIT,"b=6,Y"}, {_RM,zBIT,"c=6,Y"}, {_RM,zBIT,"d=6,Y"}, {_RM,zBIT,"e=6,Y"},
	{_RM,zBIT,"h=6,Y"}, {_RM,zBIT,"l=6,Y"}, {_RM,zBIT,"6,Y"},   {_RM,zBIT,"a=6,Y"},
	{_RM,zBIT,"b=7,Y"}, {_RM,zBIT,"c=7,Y"}, {_RM,zBIT,"d=7,Y"}, {_RM,zBIT,"e=7,Y"},
	{_RM,zBIT,"h=7,Y"}, {_RM,zBIT,"l=7,Y"}, {_RM,zBIT,"7,Y"},   {_RM,zBIT,"a=7,Y"},
	{_WM,zRES,"b=0,Y"}, {_WM,zRES,"c=0,Y"}, {_WM,zRES,"d=0,Y"}, {_WM,zRES,"e=0,Y"},
	{_WM,zRES,"h=0,Y"}, {_WM,zRES,"l=0,Y"}, {_WM,zRES,"0,Y"},   {_WM,zRES,"a=0,Y"},
	{_WM,zRES,"b=1,Y"}, {_WM,zRES,"c=1,Y"}, {_WM,zRES,"d=1,Y"}, {_WM,zRES,"e=1,Y"},
	{_WM,zRES,"h=1,Y"}, {_WM,zRES,"l=1,Y"}, {_WM,zRES,"1,Y"},   {_WM,zRES,"a=1,Y"},
	{_WM,zRES,"b=2,Y"}, {_WM,zRES,"c=2,Y"}, {_WM,zRES,"d=2,Y"}, {_WM,zRES,"e=2,Y"},
	{_WM,zRES,"h=2,Y"}, {_WM,zRES,"l=2,Y"}, {_WM,zRES,"2,Y"},   {_WM,zRES,"a=2,Y"},
	{_WM,zRES,"b=3,Y"}, {_WM,zRES,"c=3,Y"}, {_WM,zRES,"d=3,Y"}, {_WM,zRES,"e=3,Y"},
	{_WM,zRES,"h=3,Y"}, {_WM,zRES,"l=3,Y"}, {_WM,zRES,"3,Y"},   {_WM,zRES,"a=3,Y"},
	{_WM,zRES,"b=4,Y"}, {_WM,zRES,"c=4,Y"}, {_WM,zRES,"d=4,Y"}, {_WM,zRES,"e=4,Y"},
	{_WM,zRES,"h=4,Y"}, {_WM,zRES,"l=4,Y"}, {_WM,zRES,"4,Y"},   {_WM,zRES,"a=4,Y"},
	{_WM,zRES,"b=5,Y"}, {_WM,zRES,"c=5,Y"}, {_WM,zRES,"d=5,Y"}, {_WM,zRES,"e=5,Y"},
	{_WM,zRES,"h=5,Y"}, {_WM,zRES,"l=5,Y"}, {_WM,zRES,"5,Y"},   {_WM,zRES,"a=5,Y"},
	{_WM,zRES,"b=6,Y"}, {_WM,zRES,"c=6,Y"}, {_WM,zRES,"d=6,Y"}, {_WM,zRES,"e=6,Y"},
	{_WM,zRES,"h=6,Y"}, {_WM,zRES,"l=6,Y"}, {_WM,zRES,"6,Y"},   {_WM,zRES,"a=6,Y"},
	{_WM,zRES,"b=7,Y"}, {_WM,zRES,"c=7,Y"}, {_WM,zRES,"d=7,Y"}, {_WM,zRES,"e=7,Y"},
	{_WM,zRES,"h=7,Y"}, {_WM,zRES,"l=7,Y"}, {_WM,zRES,"7,Y"},   {_WM,zRES,"a=7,Y"},
	{_WM,zSET,"b=0,Y"}, {_WM,zSET,"c=0,Y"}, {_WM,zSET,"d=0,Y"}, {_WM,zSET,"e=0,Y"},
	{_WM,zSET,"h=0,Y"}, {_WM,zSET,"l=0,Y"}, {_WM,zSET,"0,Y"},   {_WM,zSET,"a=0,Y"},
	{_WM,zSET,"b=1,Y"}, {_WM,zSET,"c=1,Y"}, {_WM,zSET,"d=1,Y"}, {_WM,zSET,"e=1,Y"},
	{_WM,zSET,"h=1,Y"}, {_WM,zSET,"l=1,Y"}, {_WM,zSET,"1,Y"},   {_WM,zSET,"a=1,Y"},
	{_WM,zSET,"b=2,Y"}, {_WM,zSET,"c=2,Y"}, {_WM,zSET,"d=2,Y"}, {_WM,zSET,"e=2,Y"},
	{_WM,zSET,"h=2,Y"}, {_WM,zSET,"l=2,Y"}, {_WM,zSET,"2,Y"},   {_WM,zSET,"a=2,Y"},
	{_WM,zSET,"b=3,Y"}, {_WM,zSET,"c=3,Y"}, {_WM,zSET,"d=3,Y"}, {_WM,zSET,"e=3,Y"},
	{_WM,zSET,"h=3,Y"}, {_WM,zSET,"l=3,Y"}, {_WM,zSET,"3,Y"},   {_WM,zSET,"a=3,Y"},
	{_WM,zSET,"b=4,Y"}, {_WM,zSET,"c=4,Y"}, {_WM,zSET,"d=4,Y"}, {_WM,zSET,"e=4,Y"},
	{_WM,zSET,"h=4,Y"}, {_WM,zSET,"l=4,Y"}, {_WM,zSET,"4,Y"},   {_WM,zSET,"a=4,Y"},
	{_WM,zSET,"b=5,Y"}, {_WM,zSET,"c=5,Y"}, {_WM,zSET,"d=5,Y"}, {_WM,zSET,"e=5,Y"},
	{_WM,zSET,"h=5,Y"}, {_WM,zSET,"l=5,Y"}, {_WM,zSET,"5,Y"},   {_WM,zSET,"a=5,Y"},
	{_WM,zSET,"b=6,Y"}, {_WM,zSET,"c=6,Y"}, {_WM,zSET,"d=6,Y"}, {_WM,zSET,"e=6,Y"},
	{_WM,zSET,"h=6,Y"}, {_WM,zSET,"l=6,Y"}, {_WM,zSET,"6,Y"},   {_WM,zSET,"a=6,Y"},
	{_WM,zSET,"b=7,Y"}, {_WM,zSET,"c=7,Y"}, {_WM,zSET,"d=7,Y"}, {_WM,zSET,"e=7,Y"},
	{_WM,zSET,"h=7,Y"}, {_WM,zSET,"l=7,Y"}, {_WM,zSET,"7,Y"},   {_WM,zSET,"a=7,Y"}
};

static z80dasm mnemonic_cb[256] = {
	{_0, zRLC,"b"},     {_0, zRLC,"c"},     {_0, zRLC,"d"},     {_0, zRLC,"e"},
	{_0, zRLC,"h"},     {_0, zRLC,"l"},     {_RW,zRLC,"(hl)"},  {_0, zRLC,"a"},
	{_0, zRRC,"b"},     {_0, zRRC,"c"},     {_0, zRRC,"d"},     {_0, zRRC,"e"},
	{_0, zRRC,"h"},     {_0, zRRC,"l"},     {_RW,zRRC,"(hl)"},  {_0, zRRC,"a"},
	{_0, zRL,"b"},      {_0, zRL,"c"},      {_0, zRL,"d"},      {_0, zRL,"e"},
	{_0, zRL,"h"},      {_0, zRL,"l"},      {_RW,zRL,"(hl)"},   {_0, zRL,"a"},
	{_0, zRR,"b"},      {_0, zRR,"c"},      {_0, zRR,"d"},      {_0, zRR,"e"},
	{_0, zRR,"h"},      {_0, zRR,"l"},      {_RW,zRR,"(hl)"},   {_0, zRR,"a"},
	{_0, zSLA,"b"},     {_0, zSLA,"c"},     {_0, zSLA,"d"},     {_0, zSLA,"e"},
	{_0, zSLA,"h"},     {_0, zSLA,"l"},     {_RW,zSLA,"(hl)"},  {_0, zSLA,"a"},
	{_0, zSRA,"b"},     {_0, zSRA,"c"},     {_0, zSRA,"d"},     {_0, zSRA,"e"},
	{_0, zSRA,"h"},     {_0, zSRA,"l"},     {_RW,zSRA,"(hl)"},  {_0, zSRA,"a"},
	{_0, zSLL,"b"},     {_0, zSLL,"c"},     {_0, zSLL,"d"},     {_0, zSLL,"e"},
	{_0, zSLL,"h"},     {_0, zSLL,"l"},     {_RW,zSLL,"(hl)"},  {_0, zSLL,"a"},
	{_0, zSRL,"b"},     {_0, zSRL,"c"},     {_0, zSRL,"d"},     {_0, zSRL,"e"},
	{_0, zSRL,"h"},     {_0, zSRL,"l"},     {_RW,zSRL,"(hl)"},  {_0, zSRL,"a"},
	{_0, zBIT,"0,b"},   {_0, zBIT,"0,c"},   {_0, zBIT,"0,d"},   {_0, zBIT,"0,e"},
	{_0, zBIT,"0,h"},   {_0, zBIT,"0,l"},   {_RM,zBIT,"0,(hl)"},{_0, zBIT,"0,a"},
	{_0, zBIT,"1,b"},   {_0, zBIT,"1,c"},   {_0, zBIT,"1,d"},   {_0, zBIT,"1,e"},
	{_0, zBIT,"1,h"},   {_0, zBIT,"1,l"},   {_RM,zBIT,"1,(hl)"},{_0, zBIT,"1,a"},
	{_0, zBIT,"2,b"},   {_0, zBIT,"2,c"},   {_0, zBIT,"2,d"},   {_0, zBIT,"2,e"},
	{_0, zBIT,"2,h"},   {_0, zBIT,"2,l"},   {_RM,zBIT,"2,(hl)"},{_0, zBIT,"2,a"},
	{_0, zBIT,"3,b"},   {_0, zBIT,"3,c"},   {_0, zBIT,"3,d"},   {_0, zBIT,"3,e"},
	{_0, zBIT,"3,h"},   {_0, zBIT,"3,l"},   {_RM,zBIT,"3,(hl)"},{_0, zBIT,"3,a"},
	{_0, zBIT,"4,b"},   {_0, zBIT,"4,c"},   {_0, zBIT,"4,d"},   {_0, zBIT,"4,e"},
	{_0, zBIT,"4,h"},   {_0, zBIT,"4,l"},   {_RM,zBIT,"4,(hl)"},{_0, zBIT,"4,a"},
	{_0, zBIT,"5,b"},   {_0, zBIT,"5,c"},   {_0, zBIT,"5,d"},   {_0, zBIT,"5,e"},
	{_0, zBIT,"5,h"},   {_0, zBIT,"5,l"},   {_RM,zBIT,"5,(hl)"},{_0, zBIT,"5,a"},
	{_0, zBIT,"6,b"},   {_0, zBIT,"6,c"},   {_0, zBIT,"6,d"},   {_0, zBIT,"6,e"},
	{_0, zBIT,"6,h"},   {_0, zBIT,"6,l"},   {_RM,zBIT,"6,(hl)"},{_0, zBIT,"6,a"},
	{_0, zBIT,"7,b"},   {_0, zBIT,"7,c"},   {_0, zBIT,"7,d"},   {_0, zBIT,"7,e"},
	{_0, zBIT,"7,h"},   {_0, zBIT,"7,l"},   {_RM,zBIT,"7,(hl)"},{_0, zBIT,"7,a"},
	{_0, zRES,"0,b"},   {_0, zRES,"0,c"},   {_0, zRES,"0,d"},   {_0, zRES,"0,e"},
	{_0, zRES,"0,h"},   {_0, zRES,"0,l"},   {_WM,zRES,"0,(hl)"},{_0, zRES,"0,a"},
	{_0, zRES,"1,b"},   {_0, zRES,"1,c"},   {_0, zRES,"1,d"},   {_0, zRES,"1,e"},
	{_0, zRES,"1,h"},   {_0, zRES,"1,l"},   {_WM,zRES,"1,(hl)"},{_0, zRES,"1,a"},
	{_0, zRES,"2,b"},   {_0, zRES,"2,c"},   {_0, zRES,"2,d"},   {_0, zRES,"2,e"},
	{_0, zRES,"2,h"},   {_0, zRES,"2,l"},   {_WM,zRES,"2,(hl)"},{_0, zRES,"2,a"},
	{_0, zRES,"3,b"},   {_0, zRES,"3,c"},   {_0, zRES,"3,d"},   {_0, zRES,"3,e"},
	{_0, zRES,"3,h"},   {_0, zRES,"3,l"},   {_WM,zRES,"3,(hl)"},{_0, zRES,"3,a"},
	{_0, zRES,"4,b"},   {_0, zRES,"4,c"},   {_0, zRES,"4,d"},   {_0, zRES,"4,e"},
	{_0, zRES,"4,h"},   {_0, zRES,"4,l"},   {_WM,zRES,"4,(hl)"},{_0, zRES,"4,a"},
	{_0, zRES,"5,b"},   {_0, zRES,"5,c"},   {_0, zRES,"5,d"},   {_0, zRES,"5,e"},
	{_0, zRES,"5,h"},   {_0, zRES,"5,l"},   {_WM,zRES,"5,(hl)"},{_0, zRES,"5,a"},
	{_0, zRES,"6,b"},   {_0, zRES,"6,c"},   {_0, zRES,"6,d"},   {_0, zRES,"6,e"},
	{_0, zRES,"6,h"},   {_0, zRES,"6,l"},   {_WM,zRES,"6,(hl)"},{_0, zRES,"6,a"},
	{_0, zRES,"7,b"},   {_0, zRES,"7,c"},   {_0, zRES,"7,d"},   {_0, zRES,"7,e"},
	{_0, zRES,"7,h"},   {_0, zRES,"7,l"},   {_WM,zRES,"7,(hl)"},{_0, zRES,"7,a"},
	{_0, zSET,"0,b"},   {_0, zSET,"0,c"},   {_0, zSET,"0,d"},   {_0, zSET,"0,e"},
	{_0, zSET,"0,h"},   {_0, zSET,"0,l"},   {_WM,zSET,"0,(hl)"},{_0, zSET,"0,a"},
	{_0, zSET,"1,b"},   {_0, zSET,"1,c"},   {_0, zSET,"1,d"},   {_0, zSET,"1,e"},
	{_0, zSET,"1,h"},   {_0, zSET,"1,l"},   {_WM,zSET,"1,(hl)"},{_0, zSET,"1,a"},
	{_0, zSET,"2,b"},   {_0, zSET,"2,c"},   {_0, zSET,"2,d"},   {_0, zSET,"2,e"},
	{_0, zSET,"2,h"},   {_0, zSET,"2,l"},   {_WM,zSET,"2,(hl)"},{_0, zSET,"2,a"},
	{_0, zSET,"3,b"},   {_0, zSET,"3,c"},   {_0, zSET,"3,d"},   {_0, zSET,"3,e"},
	{_0, zSET,"3,h"},   {_0, zSET,"3,l"},   {_WM,zSET,"3,(hl)"},{_0, zSET,"3,a"},
	{_0, zSET,"4,b"},   {_0, zSET,"4,c"},   {_0, zSET,"4,d"},   {_0, zSET,"4,e"},
	{_0, zSET,"4,h"},   {_0, zSET,"4,l"},   {_WM,zSET,"4,(hl)"},{_0, zSET,"4,a"},
	{_0, zSET,"5,b"},   {_0, zSET,"5,c"},   {_0, zSET,"5,d"},   {_0, zSET,"5,e"},
	{_0, zSET,"5,h"},   {_0, zSET,"5,l"},   {_WM,zSET,"5,(hl)"},{_0, zSET,"5,a"},
	{_0, zSET,"6,b"},   {_0, zSET,"6,c"},   {_0, zSET,"6,d"},   {_0, zSET,"6,e"},
	{_0, zSET,"6,h"},   {_0, zSET,"6,l"},   {_WM,zSET,"6,(hl)"},{_0, zSET,"6,a"},
	{_0, zSET,"7,b"},   {_0, zSET,"7,c"},   {_0, zSET,"7,d"},   {_0, zSET,"7,e"},
	{_0, zSET,"7,h"},   {_0, zSET,"7,l"},   {_WM,zSET,"7,(hl)"},{_0, zSET,"7,a"}
};

static z80dasm mnemonic_ed[256]= {
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_RP,zIN,"b,(c)"},  {_WP,zOUT,"(c),b"}, {_0, zSBC,"hl,bc"}, {_WM,zLD,"(W),bc"},
	{_0, zNEG,0},		{_0, zRETN,0},		{_0, zIM,"0"},      {_0, zLD,"i,a"},
	{_RP,zIN,"c,(c)"},  {_WP,zOUT,"(c),c"}, {_0, zADC,"hl,bc"}, {_RM,zLD,"bc,(W)"},
	{_0, zNEG,"*"},     {_0, zRETI,0},      {_0, zIM,"0"},      {_0, zLD,"r,a"},
	{_RP,zIN,"d,(c)"},  {_WP,zOUT,"(c),d"}, {_0, zSBC,"hl,de"}, {_WM,zLD,"(W),de"},
	{_0, zNEG,"*"},     {_0, zRETN,0},      {_0, zIM,"1"},      {_0, zLD,"a,i"},
	{_RP,zIN,"e,(c)"},  {_WP,zOUT,"(c),e"}, {_0, zADC,"hl,de"}, {_RM,zLD,"de,(W)"},
	{_0, zNEG,"*"},     {_0, zRETI,0},      {_0, zIM,"2"},      {_0, zLD,"a,r"},
	{_RP,zIN,"h,(c)"},  {_WP,zOUT,"(c),h"}, {_0, zSBC,"hl,hl"}, {_WM,zLD,"(W),hl"},
	{_0, zNEG,"*"},     {_0, zRETN,0},      {_0, zIM,"0"},      {_RW,zRRD,"(hl)"},
	{_RP,zIN,"l,(c)"},  {_WP,zOUT,"(c),l"}, {_0, zADC,"hl,hl"}, {_RM,zLD,"hl,(W)"},
	{_0, zNEG,"*"},     {_0, zRETI,0},      {_0, zIM,"0"},      {_RW,zRLD,"(hl)"},
	{_RP,zIN,"0,(c)"},  {_WP,zOUT,"(c),0"}, {_0, zSBC,"hl,sp"}, {_WM,zLD,"(W),sp"},
	{_0, zNEG,"*"},     {_0, zRETN,0},      {_0, zIM,"1"},      {_0, zDB,"?"},
	{_RP,zIN,"a,(c)"},  {_WP,zOUT,"(c),a"}, {_0, zADC,"hl,sp"}, {_RM,zLD,"sp,(W)"},
	{_0, zNEG,"*"},     {_0, zRETI,0},      {_0, zIM,"2"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_RW,zLDI,0},		{_RM,zCPI,0},		{_RP,zINI,0},		{_WP,zOUTI,0},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_RW,zLDD,0},		{_RM,zCPD,0},		{_RP,zIND,0},		{_WP,zOUTD,0},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_RW,zLDIR,0},		{_RM,zCPIR,0},		{_RP,zINIR,0},		{_WP,zOTIR,0},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_RW,zLDDR,0},		{_RM,zCPDR,0},		{_RP,zINDR,0},		{_WP,zOTDR,0},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"}
};

static z80dasm mnemonic_xx[256]= {
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zADD,"I,bc"},  {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zADD,"I,de"},  {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zLD,"I,N"},    {_WM,zLD,"(W),I"},  {_0, zINC,"I"},
	{_0, zINC,"Ih"},    {_0, zDEC,"Ih"},    {_0, zLD,"Ih,B"},   {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zADD,"I,I"},   {_RM,zLD,"I,(W)"},  {_0, zDEC,"I"},
	{_0, zINC,"Il"},    {_0, zDEC,"Il"},    {_0, zLD,"Il,B"},   {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_RW,zINC,"X"},     {_RW,zDEC,"X"},     {_WM,zLD,"X,B"},    {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zADD,"I,sp"},  {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zLD,"b,Ih"},   {_0, zLD,"b,Il"},   {_RM,zLD,"b,X"},    {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zLD,"c,Ih"},   {_0, zLD,"c,Il"},   {_RM,zLD,"c,X"},    {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zLD,"d,Ih"},   {_0, zLD,"d,Il"},   {_RM,zLD,"d,X"},    {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zLD,"e,Ih"},   {_0, zLD,"e,Il"},   {_RM,zLD,"e,X"},    {_0, zDB,"?"},
	{_0, zLD,"Ih,b"},   {_0, zLD,"Ih,c"},   {_0, zLD,"Ih,d"},   {_0, zLD,"Ih,e"},
	{_0, zLD,"Ih,Ih"},  {_0, zLD,"Ih,Il"},  {_RM,zLD,"h,X"},    {_0, zLD,"Ih,a"},
	{_0, zLD,"Il,b"},   {_0, zLD,"Il,c"},   {_0, zLD,"Il,d"},   {_0, zLD,"Il,e"},
	{_0, zLD,"Il,Ih"},  {_0, zLD,"Il,Il"},  {_RM,zLD,"l,X"},    {_0, zLD,"Il,a"},
	{_WM,zLD,"X,b"},    {_WM,zLD,"X,c"},    {_WM,zLD,"X,d"},    {_WM,zLD,"X,e"},
	{_WM,zLD,"X,h"},    {_WM,zLD,"X,l"},    {_0, zDB,"?"},      {_WM,zLD,"X,a"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zLD,"a,Ih"},   {_0, zLD,"a,Il"},   {_RM,zLD,"a,X"},    {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zADD,"a,Ih"},  {_0, zADD,"a,Il"},  {_RM,zADD,"a,X"},   {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zADC,"a,Ih"},  {_0, zADC,"a,Il"},  {_RM,zADC,"a,X"},   {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zSUB,"Ih"},    {_0, zSUB,"Il"},    {_RM,zSUB,"X"},     {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zSBC,"a,Ih"},  {_0, zSBC,"a,Il"},  {_RM,zSBC,"a,X"},   {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zAND,"Ih"},    {_0, zAND,"Il"},    {_RM,zAND,"X"},     {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zXOR,"Ih"},    {_0, zXOR,"Il"},    {_RM,zXOR,"X"},     {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zOR,"Ih"},     {_0, zOR,"Il"},     {_RM,zOR,"X"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zCP,"Ih"},     {_0, zCP,"Il"},     {_RM,zCP,"X"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"cb"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zPOP,"I"},     {_0, zDB,"?"},      {_RW,zEX,"(sp),I"},
	{_0, zDB,"?"},      {_0, zPUSH,"I"},    {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_JP,zJP,"(I)"},    {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zLD,"sp,I"},   {_0, zDB,"?"},      {_0, zDB,"?"},
	{_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"},      {_0, zDB,"?"}
};

static z80dasm mnemonic_main[256]= {
	{_0, zNOP,0},		{_0, zLD,"bc,N"},   {_WM,zLD,"(bc),a"}, {_0, zINC,"bc"},
	{_0, zINC,"b"},     {_0, zDEC,"b"},     {_0, zLD,"b,B"},    {_0, zRLCA,0},
	{_0, zEX,"af,af'"}, {_0, zADD,"hl,bc"}, {_RM,zLD,"a,(bc)"}, {_0, zDEC,"bc"},
	{_0, zINC,"c"},     {_0, zDEC,"c"},     {_0, zLD,"c,B"},    {_0, zRRCA,0},
	{_JR,zDJNZ,"O"},    {_0, zLD,"de,N"},   {_WM,zLD,"(de),a"}, {_0, zINC,"de"},
	{_0, zINC,"d"},     {_0, zDEC,"d"},     {_0, zLD,"d,B"},    {_0, zRLA,0},
	{_JR,zJR,"O"},      {_0, zADD,"hl,de"}, {_RM,zLD,"a,(de)"}, {_0, zDEC,"de"},
	{_0, zINC,"e"},     {_0, zDEC,"e"},     {_0, zLD,"e,B"},    {_0, zRRA,0},
	{_JR,zJR,"nz,O"},   {_0, zLD,"hl,N"},   {_WM,zLD,"(W),hl"}, {_0, zINC,"hl"},
	{_0, zINC,"h"},     {_0, zDEC,"h"},     {_0, zLD,"h,B"},    {_0, zDAA,0},
	{_JR,zJR,"z,O"},    {_0, zADD,"hl,hl"}, {_RM,zLD,"hl,(W)"}, {_0, zDEC,"hl"},
	{_0, zINC,"l"},     {_0, zDEC,"l"},     {_0, zLD,"l,B"},    {_0, zCPL,0},
	{_JR,zJR,"nc,O"},   {_0, zLD,"sp,N"},   {_WM,zLD,"(W),a"},  {_0, zINC,"sp"},
	{_RW,zINC,"(hl)"},  {_RW,zDEC,"(hl)"},  {_WM,zLD,"(hl),B"}, {_0, zSCF,0},
	{_0, zJR,"c,O"},    {_0, zADD,"hl,sp"}, {_RM,zLD,"a,(W)"},  {_0, zDEC,"sp"},
	{_0, zINC,"a"},     {_0, zDEC,"a"},     {_0, zLD,"a,B"},    {_0, zCCF,0},
	{_0, zLD,"b,b"},    {_0, zLD,"b,c"},    {_0, zLD,"b,d"},    {_0, zLD,"b,e"},
	{_0, zLD,"b,h"},    {_0, zLD,"b,l"},    {_RM,zLD,"b,(hl)"}, {_0, zLD,"b,a"},
	{_0, zLD,"c,b"},    {_0, zLD,"c,c"},    {_0, zLD,"c,d"},    {_0, zLD,"c,e"},
	{_0, zLD,"c,h"},    {_0, zLD,"c,l"},    {_RM,zLD,"c,(hl)"}, {_0, zLD,"c,a"},
	{_0, zLD,"d,b"},    {_0, zLD,"d,c"},    {_0, zLD,"d,d"},    {_0, zLD,"d,e"},
	{_0, zLD,"d,h"},    {_0, zLD,"d,l"},    {_RM,zLD,"d,(hl)"}, {_0, zLD,"d,a"},
	{_0, zLD,"e,b"},    {_0, zLD,"e,c"},    {_0, zLD,"e,d"},    {_0, zLD,"e,e"},
	{_0, zLD,"e,h"},    {_0, zLD,"e,l"},    {_RM,zLD,"e,(hl)"}, {_0, zLD,"e,a"},
	{_0, zLD,"h,b"},    {_0, zLD,"h,c"},    {_0, zLD,"h,d"},    {_0, zLD,"h,e"},
	{_0, zLD,"h,h"},    {_0, zLD,"h,l"},    {_RM,zLD,"h,(hl)"}, {_0, zLD,"h,a"},
	{_0, zLD,"l,b"},    {_0, zLD,"l,c"},    {_0, zLD,"l,d"},    {_0, zLD,"l,e"},
	{_0, zLD,"l,h"},    {_0, zLD,"l,l"},    {_RM,zLD,"l,(hl)"}, {_0, zLD,"l,a"},
	{_WM,zLD,"(hl),b"}, {_WM,zLD,"(hl),c"}, {_WM,zLD,"(hl),d"}, {_WM,zLD,"(hl),e"},
	{_WM,zLD,"(hl),h"}, {_WM,zLD,"(hl),l"}, {_0, zHLT,0},       {_WM,zLD,"(hl),a"},
	{_0, zLD,"a,b"},    {_0, zLD,"a,c"},    {_0, zLD,"a,d"},    {_0, zLD,"a,e"},
	{_0, zLD,"a,h"},    {_0, zLD,"a,l"},    {_RM,zLD,"a,(hl)"}, {_0, zLD,"a,a"},
	{_0, zADD,"a,b"},   {_0, zADD,"a,c"},   {_0, zADD,"a,d"},   {_0, zADD,"a,e"},
	{_0, zADD,"a,h"},   {_0, zADD,"a,l"},   {_RM,zADD,"a,(hl)"},{_0, zADD,"a,a"},
	{_0, zADC,"a,b"},   {_0, zADC,"a,c"},   {_0, zADC,"a,d"},   {_0, zADC,"a,e"},
	{_0, zADC,"a,h"},   {_0, zADC,"a,l"},   {_RM,zADC,"a,(hl)"},{_0, zADC,"a,a"},
	{_0, zSUB,"b"},     {_0, zSUB,"c"},     {_0, zSUB,"d"},     {_0, zSUB,"e"},
	{_0, zSUB,"h"},     {_0, zSUB,"l"},     {_RM,zSUB,"(hl)"},  {_0, zSUB,"a"},
	{_0, zSBC,"a,b"},   {_0, zSBC,"a,c"},   {_0, zSBC,"a,d"},   {_0, zSBC,"a,e"},
	{_0, zSBC,"a,h"},   {_0, zSBC,"a,l"},   {_RM,zSBC,"a,(hl)"},{_0, zSBC,"a,a"},
	{_0, zAND,"b"},     {_0, zAND,"c"},     {_0, zAND,"d"},     {_0, zAND,"e"},
	{_0, zAND,"h"},     {_0, zAND,"l"},     {_RM,zAND,"(hl)"},  {_0, zAND,"a"},
	{_0, zXOR,"b"},     {_0, zXOR,"c"},     {_0, zXOR,"d"},     {_0, zXOR,"e"},
	{_0, zXOR,"h"},     {_0, zXOR,"l"},     {_RM,zXOR,"(hl)"},  {_0, zXOR,"a"},
	{_0, zOR,"b"},      {_0, zOR,"c"},      {_0, zOR,"d"},      {_0, zOR,"e"},
	{_0, zOR,"h"},      {_0, zOR,"l"},      {_RM,zOR,"(hl)"},   {_0, zOR,"a"},
	{_0, zCP,"b"},      {_0, zCP,"c"},      {_0, zCP,"d"},      {_0, zCP,"e"},
	{_0, zCP,"h"},      {_0, zCP,"l"},      {_RM,zCP,"(hl)"},   {_0, zCP,"a"},
	{_0, zRET,"nz"},    {_0, zPOP,"bc"},    {_JP,zJP,"nz,A"},   {_JP,zJP,"A"},
	{_JP,zCALL,"nz,A"}, {_0, zPUSH,"bc"},   {_0, zADD,"a,B"},   {_JP,zRST,"V"},
	{_0, zRET,"z"},     {_0, zRET,0},       {_JP,zJP,"z,A"},    {_0, zDB,"cb"},
	{_JP,zCALL,"z,A"},  {_JP,zCALL,"A"},    {_0, zADC,"a,B"},   {_JP,zRST,"V"},
	{_0, zRET,"nc"},    {_0, zPOP,"de"},    {_JP,zJP,"nc,A"},   {_WP,zOUT,"(P),a"},
	{_JP,zCALL,"nc,A"}, {_0, zPUSH,"de"},   {_0, zSUB,"B"},     {_JP,zRST,"V"},
	{_0, zRET,"c"},     {_0, zEXX,0},       {_JP,zJP,"c,A"},    {_RP,zIN,"a,(P)"},
	{_JP,zCALL,"c,A"},  {_0, zDB,"dd"},     {_0, zSBC,"a,B"},   {_JP,zRST,"V"},
	{_0, zRET,"po"},    {_0, zPOP,"hl"},    {_JP,zJP,"po,A"},   {_RW,zEX,"(sp),hl"},
	{_JP,zCALL,"po,A"}, {_0, zPUSH,"hl"},   {_0, zAND,"B"},     {_JP,zRST,"V"},
	{_0, zRET,"pe"},    {_JP,zJP,"(hl)"},   {_JP,zJP,"pe,A"},   {_0, zEX,"de,hl"},
	{_JP,zCALL,"pe,A"}, {_0, zDB,"ed"},     {_0, zXOR,"B"},     {_JP,zRST,"V"},
	{_0, zRET,"p"},     {_0, zPOP,"af"},    {_JP,zJP,"p,A"},    {_0, zDI,0},
	{_JP,zCALL,"p,A"},  {_0, zPUSH,"af"},   {_0, zOR,"B"},      {_JP,zRST,"V"},
	{_0, zRET,"m"},     {_0, zLD,"sp,hl"},  {_JP,zJP,"m,A"},    {_0, zEI,0},
	{_JP,zCALL,"m,A"},  {_0, zDB,"fd"},     {_0, zCP,"B"},      {_JP,zRST,"V"}
};

static char sign(INT8 offset)
{
 return (offset < 0)? '-':'+';
}

static int offs(INT8 offset)
{
	if (offset < 0) return -offset;
	return offset;
}

/****************************************************************************
 * Disassemble opcode at PC and return number of bytes it takes
 ****************************************************************************/
unsigned DasmZ80( char *buffer, unsigned pc )
{
    z80dasm *d;
//	const char *symbol
    const char *src;
  char symbol[80];
	char *ixy, *dst;
	unsigned PC = pc;
	int size;
	INT8 offset = 0;
	UINT8 op, op1;
	UINT16 ea = 0, xy = 0;

  ilegal_op=0;
	ixy = "oops!!";
	dst = buffer;
	symbol[0]='\0';

	op = cpu_readop( pc++ );
    op1 = 0; /* keep GCC happy */

    switch (op)
	{
	case 0xcb:
		op = cpu_readop(pc++);
        d = &mnemonic_cb[op];
		break;
	case 0xed:
		op1 = cpu_readop(pc++);
        d = &mnemonic_ed[op1];
		break;
	case 0xdd:
		ixy = "ix";
		op1 = cpu_readop(pc++);
		if( op1 == 0xcb )
		{
			offset = (INT8) cpu_readop_arg(pc++);
			op1 = cpu_readop_arg(pc++); /* fourth byte from OP_RAM! */
			xy = pointz80->IX.W;
			ea = (xy + offset) & 0xffff;
			d = &mnemonic_xx_cb[op1];
		}
		else d = &mnemonic_xx[op1];
        break;
	case 0xfd:
		ixy = "iy";
		op1 = cpu_readop(pc++);
		if( op1 == 0xcb )
		{
			offset = (INT8) cpu_readop_arg(pc++);
			op1 = cpu_readop_arg(pc++); /* fourth byte from OP_RAM! */
			xy = pointz80->IY.W;
			ea = (ea + offset) & 0xffff;
			d = &mnemonic_xx_cb[op1];
		}
		else d = &mnemonic_xx[op1];
        break;
	default:
		d = &mnemonic_main[op];
		break;
	}

    if( d->arguments )
	{
		dst += sprintf(dst, "%-4s ", s_mnemonic[d->mnemonic]);
		src = d->arguments;
		while( *src )
		{
			switch( *src )
			{
			case '?':   /* illegal opcode */
				dst += sprintf( dst, "$%02x,$%02x", op, op1);
        ilegal_op=1;
				break;
			case 'A':
				ea = cpu_readop_arg(pc) + ( cpu_readop_arg((pc+1)&0xffff) << 8);
				pc += 2;
//				symbol = set_ea_info(0, ea, EA_UINT16, d->access);
        sprintf(symbol,"$%04X",ea);
				dst += sprintf( dst, "%s", symbol );
        break;
            case 'B':   /* Byte op arg */
				ea = cpu_readop_arg( pc++ );
//				symbol = set_ea_info(1, ea, EA_UINT8, EA_VALUE);
        sprintf(symbol,"$%02X",ea);
				dst += sprintf( dst, "%s", symbol );
				break;
			case '(':   /* Memory byte at (HL) */
                *dst++ = *src;
				if( !strncmp( src, "(bc)", 4) )
				{
					ea = pointz80->BC.W;//_get_reg( Z80_BC );
//					set_ea_info(0, ea, EA_UINT8, d->access);
				}
                else
				if( !strncmp( src, "(de)", 4) )
				{
					ea = pointz80->DE.W;//z80_get_reg( Z80_DE );
//					set_ea_info(0, ea, EA_UINT8, d->access);
                }
                else
                if( !strncmp( src, "(hl)", 4) )
				{
					ea = pointz80->HL.W;//z80_get_reg( Z80_HL );
					if( d->access == _JP/*EA_ABS_PC*/ )
//						set_ea_info(0, ea, EA_DEFAULT, EA_ABS_PC);
              ;
					else
//						set_ea_info(0, ea, EA_UINT8, d->access);
              ;
                }
				else
				if( !strncmp( src, "(sp)", 4) )
				{
					ea = pointz80->SP.W;//z80_get_reg( Z80_SP );
//					set_ea_info(0, ea, EA_UINT16, d->access);
                }
				else
				if( !strncmp( src, "(P)", 3) )
				{
					ea = (pointz80->AF.W/*z80_get_reg( Z80_AF )*/ & 0xff00) | cpu_readop_arg( pc );
//                    set_ea_info(0, ea, EA_UINT16, d->access);
                }
                else
                if( !strncmp( src, "(c)", 3) )
				{
					ea = pointz80->BC.W;//z80_get_reg( Z80_BC );
//					set_ea_info(0, ea, EA_UINT16, d->access);
                }
                else
				if( !strncmp( src, "(I)", 3) )
				{
					ea = xy;
//					set_ea_info(0, ea, EA_DEFAULT, d->access);
                }
                break;
			case 'N':   /* Immediate 16 bit */
				ea = cpu_readop_arg(pc) + ( cpu_readop_arg((pc+1)&0xffff) << 8 );
				pc += 2;
//				symbol = set_ea_info(1, ea, EA_UINT16, EA_VALUE );
          sprintf(symbol,"$%04X",ea);
				dst += sprintf( dst, "%s", symbol );
                break;
			case 'O':   /* Offset relative to PC */
				offset = (INT8) cpu_readop_arg(pc++);
//				symbol = set_ea_info(0, PC, offset + 2, d->access);
          sprintf(symbol,"$%04X",offset+pc);
				dst += sprintf( dst, "%s", symbol );
				break;
			case 'P':   /* Port number */
				ea = cpu_readop_arg( pc++ );
				dst += sprintf( dst, "$%02X", ea );
                break;
            case 'V':   /* Restart vector */
				ea = op & 0x38;
//				symbol = set_ea_info(0, ea, EA_UINT8, d->access);
          sprintf(symbol,"$%04X",ea);
				dst += sprintf( dst, "%s", symbol );
				break;
			case 'W':   /* Memory address word */
				ea = cpu_readop_arg(pc) + ( cpu_readop_arg((pc+1)&0xffff) << 8);
				pc += 2;
//				symbol = set_ea_info(0, ea, EA_UINT16, d->access);
          sprintf(symbol,"$%04X",ea);
				dst += sprintf( dst, "%s", symbol );
				break;
			case 'X':
				offset = (INT8) cpu_readop_arg(pc++);
                ea = (xy + offset) & 0xffff;
            case 'Y':
//				symbol = set_ea_info(0, ea, EA_UINT8, d->access);
          sprintf(symbol,"$%04X",ea);
				dst += sprintf( dst,"(%s%c$%02x)", ixy, sign(offset), offs(offset) );
				break;
			case 'I':
				dst += sprintf( dst, "%s", ixy);
				break;
			default:
				*dst++ = *src;
			}
			src++;
		}
		*dst = '\0';
	}
	else
	{
		dst += sprintf(dst, "%s", s_mnemonic[d->mnemonic]);
    }

    return pc - PC;
}

//#endif

 byte DebugZ80(register Z80 *R)
{
  char c[80];
  char comando[80];
  int ultlinha;
  if(numPassosTrace)
  {
    numPassosTrace--;
    pointz80->Trap=0xFFFF;
    pointz80->Trace=1;
    return 1;
  }
  clear_keybuf();
  modo=DISASS;
  if (graf_mode) {set_debugger(); graf_mode=0;}
  memset(comando,0,sizeof(comando));
  poscursor=pointz80->PC.W;
  set_windows();
  ultlinha=disassemble(posdisass,0);
  if (poscursor<posdisass || poscursor>ultlinha) posdisass=poscursor;
  ultlinha=disassemble(posdisass,1);
  show_regs();
  disp_memory();
  disp_msx();
  poscomando=0;
  clear_com(comando);
  ScreenSetCursor(24,0);
  for(;;)
  {
    int t,asc,sca;
    t=le_teclas();
    asc=t&0xFF;
    sca=t>>8;
    if ((asc>='A' && asc<='Z') || (asc>='a' && asc<='z') || (asc=='.')|| (asc==' ') || (asc>='0' && asc<='9'))
    {
      if(modo==DISASS)
      {
        ScreenPutChar(t,WHITE,poscomando,24);
        comando[poscomando++]=asc;
        ScreenSetCursor(24,poscomando);
      }
      if(modo==MSXREGS)
      {
        if((asc>='A' && asc<='F') || (asc>='a' && asc<='f') || (asc>='0' && asc<='9'))
        {
          if ((asc>='a') && (asc<='f')) asc=asc-'a'+'A';
          ScreenPutChar(asc,WHITE,msxregs[posregs].x+basexregs,msxregs[posregs].y+baseyregs);
          alterareg(asc);
          posregs++;
          if(posregs==NUMREGS) posregs=0;
          ScreenSetCursor(msxregs[posregs].y+baseyregs,msxregs[posregs].x+basexregs);
        }
      }
      if(modo==MEMORY)
      {
        if((asc>='A' && asc<='F') || (asc>='a' && asc<='f') || (asc>='0' && asc<='9'))
        {
          if ((asc>='a') && (asc<='f')) asc=asc-'a'+'A';
          asc=alteramem(asc,posmemory);
          ScreenPutChar(asc,WHITE,basexmem+posxmem,baseymem+posymem);
          posmemory++;
          if(posmemory>=MAXMEM)
          {
            posmemory--;
            posmemory&=0xffe0;
            basemem+=16;
            disp_memory();
          }
          posxmem=posmemory%32+((posmemory%32)/2);
          posymem=posmemory/32;
          ScreenSetCursor(baseymem+posymem, basexmem+posxmem);
        }
      }
    }
    if(sca==KEY_BACKSPACE)
    {
      if (poscomando)
      {
        poscomando--;
        ScreenPutChar(' ',WHITE,poscomando,24);
        comando[poscomando]='\0';
        ScreenSetCursor(24,poscomando);
      }
    }
    if(sca==KEY_F7) {exit_debugger();return 1;}
//    if(key[KEY_B]) {exit_debugger();return 1;}
    if(sca==KEY_ENTER)
    {
      if(comando[0]==0)
      {
        pointz80->Trap=0xFFFF;
        pointz80->Trace=1;
        return 1;
      }
      if(trata_comando(comando)) return 1;

    }
    if(sca==KEY_TAB)
    {
      modo=(modo+1)%3;
      init_modo(modo);
      if(modo==MSXREGS)
        ScreenSetCursor(msxregs[posregs].y+baseyregs,msxregs[posregs].x+basexregs);
      if(modo==MEMORY)
        ScreenSetCursor(baseymem,basexmem);
      if(modo==DISASS)
        ScreenSetCursor(24,poscomando);

    }
    if(sca==KEY_PGDN)
    {
      if (modo==DISASS)
      {
        posdisass=ultlinha;
        poscursor=ultlinha;
        for(;;)
        {
          ultlinha=disassemble(posdisass,0);
          if(ultlinha>65535) {posdisass-=1; poscursor=posdisass;} else break;
        }
        set_windows();
        ultlinha=disassemble(posdisass,1);
      }
      if (modo==MSXREGS)
      {
      }
      if (modo==MEMORY)
      {
        basemem+=128;
        if(basemem>65536-128) basemem=65536-128;
        disp_memory();
      }
    }
/*    if(sca==KEY_DEL)
    {
      if (modo==MEMORY)
      {
        tipomem=(tipomem+1)%2;
        set_windows();
        disp_memory();
      }
    }
    if(sca==KEY_INSERT)
    {
      if (modo==MEMORY)
      {
        tipomem=(tipomem+1)%2;
        set_windows();
        disp_memory();
      }
    }*/
    if(sca==KEY_HOME)
    {
      if (modo==MEMORY)
      {
        basemem-=8192;
        if(basemem<0) basemem=0;
        disp_memory();
      }
    }
    if(sca==KEY_END)
    {
      if (modo==MEMORY)
      {
        basemem+=8192;
        if(basemem>65536-128) basemem=65536-128;
        disp_memory();
      }
    }
    if(sca==KEY_PGUP)
    {
      if (modo==DISASS)
      {
        int t;
        t=0;
        posdisass=posdisass-22*2;
        t=DasmZ80(c,posdisass);
        t+=DasmZ80(c,posdisass+t);
        t+=DasmZ80(c,posdisass+t);
        posdisass+=t;
        if(posdisass<0) posdisass=0;
        poscursor=posdisass;
        set_windows();

        ultlinha=disassemble(posdisass,1);
      }
      if (modo==MSXREGS)
      {
      }
      if (modo==MEMORY)
      {
//        posmemory-=32;
//        if(posmemory<0)
//        {
//          posmemory+=32;
            basemem-=128;
            if(basemem<0) basemem=0;
            disp_memory();
//        }
            posxmem=posmemory%32+((posmemory%32)/2);
            posymem=posmemory/32;
            ScreenSetCursor(baseymem+posymem, basexmem+posxmem);

      }
    }
    if(sca==KEY_DOWN)
    {
      if(modo==MEMORY)
      {
        posmemory+=32;
        if(posmemory>=MAXMEM)
        {
          posmemory-=32;
          basemem+=16;
          if(basemem>65536-128) basemem=65536-128;
          disp_memory();
        }
  set_windows();

        posxmem=posmemory%32+((posmemory%32)/2);
        posymem=posmemory/32;
        ScreenSetCursor(baseymem+posymem, basexmem+posxmem);
      }
      if(modo==MSXREGS)
      {
        if(posregs>=24) posregs-=24;
        else posregs+=24;
        ScreenSetCursor(msxregs[posregs].y+baseyregs,msxregs[posregs].x+basexregs);
      }
      if(modo==DISASS)
      {
        if (poscursor<65535)
        {
          poscursor+=DasmZ80(c,poscursor);
          set_windows();
          if (poscursor>ultlinha) posdisass+=DasmZ80(c,posdisass);
          ultlinha=disassemble(posdisass,1);
        }
      }
    }
    if(sca==KEY_LEFT)
    {
      if(modo==MSXREGS)
      {
        posregs-=1;
        if (posregs<0) posregs=NUMREGS-1;
        ScreenSetCursor(msxregs[posregs].y+baseyregs,msxregs[posregs].x+basexregs);
      }
      if(modo==MEMORY)
      {
        posmemory-=1;
        if(posmemory<0)
        {
          posmemory++;
          if(basemem)
          {
            posmemory|=0x1f;
            basemem-=16;
            disp_memory();
          }
        }
        posxmem=posmemory%32+((posmemory%32)/2);
        posymem=posmemory/32;
        ScreenSetCursor(baseymem+posymem, basexmem+posxmem);
      }
    }
    if(sca==KEY_RIGHT)
    {
      if(modo==MSXREGS)
      {
        posregs+=1;
        if (posregs==NUMREGS) posregs=0;
        ScreenSetCursor(msxregs[posregs].y+baseyregs,msxregs[posregs].x+basexregs);
      }
      if(modo==MEMORY)
      {
        posmemory+=1;
        if(posmemory>=MAXMEM)
        {
          posmemory--;
          posmemory&=0xffe0;
          basemem+=16;
          disp_memory();
        }
        posxmem=posmemory%32+((posmemory%32)/2);
        posymem=posmemory/32;
        ScreenSetCursor(baseymem+posymem, basexmem+posxmem);
      }
    }
    if(sca==KEY_UP)
    {
      if(modo==MEMORY)
      {
        posmemory-=32;
        if(posmemory<0)
        {
          posmemory+=32;
          basemem-=16;
          if(basemem<0) basemem=0;
          disp_memory();
        }
        posxmem=posmemory%32+((posmemory%32)/2);
        posymem=posmemory/32;
        ScreenSetCursor(baseymem+posymem, basexmem+posxmem);
      }
      if(modo==MSXREGS)
      {
        if(posregs>=24) posregs-=24;
        else posregs+=24;
        ScreenSetCursor(msxregs[posregs].y+baseyregs,msxregs[posregs].x+basexregs);
      }
      if(modo==DISASS)
      {
        if(poscursor>0) {
          if(poscursor==posdisass)
          {
            int temp;
            temp=DasmZ80(c,posdisass-4);
            if (temp!=4 || ilegal_op==1)
            {
              temp=DasmZ80(c,posdisass-3);
              if(temp!=3 || ilegal_op==1)
              {
                temp=DasmZ80(c,posdisass-2);
                if(temp!=2 || ilegal_op==1)
                {
                  temp=DasmZ80(c,posdisass-1);
                }
              }
            }
          posdisass-=temp; poscursor-=temp;
          set_windows();
          disassemble(posdisass,1);
          }

        else
          {
            int temp=posdisass, temp2;
            while(1)
            {
              temp2=DasmZ80(c,temp);
              if(temp+temp2==poscursor) {poscursor=temp; break;}
              temp+=temp2;
            }
            set_windows();
            disassemble(posdisass,1);
          }
        }
      }
    }
  }
}

void init_modo(int i)
{
//  if (i==MSXREGS)
//    posregs=0;
//  if (i==MEMORY)
//    posmemory=0;
  set_windows();
}

int alteramem(char novo, int pos)
{
  UINT16 m;
  UINT8 valor;
  UINT8 p,ret;

  m=basemem+pos/2;
  if (novo>='0' && novo<='9') valor=novo-'0';
  else valor =10+novo-'A';
  p=RdZ80(m);
  p&=~(0x0F<<((1-(pos%2))<<2));
  p|=valor<<((1-(pos%2))<<2);
  WrZ80(m,p);
  ret=pos%2?RdZ80(m)&0xF:RdZ80(m)>>4;
  return ret<10?ret+'0':ret+'A'-10;
}

void alterareg(char novo)
{
  UINT16 *r;
  int j;
  int valor, mascara;
  switch(msxregs[posregs].reg)
  {
    case 0:
r=&pointz80->PC.W;
      break;
    case 1:
r=&pointz80->SP.W;
      break;
    case 2:
r=&pointz80->AF.W;
      break;
    case 3:
r=&pointz80->BC.W;
      break;
    case 4:
r=&pointz80->DE.W;
      break;
    case 5:
r=&pointz80->HL.W;
      break;
    case 6:
r=&pointz80->IX.W;
      break;
    case 7:
r=&pointz80->IY.W;
      break;
    case 8:
r=&pointz80->AF1.W;
      break;
    case 9:
r=&pointz80->BC1.W;
      break;
    case 10:
r=&pointz80->DE1.W;
      break;
    case 11:
r=&pointz80->HL1.W;
      break;
  }
  if (novo>='0' && novo<='9') valor=novo-'0';
  else valor =10+novo-'A';
  mascara=0xF<<(msxregs[posregs].desl<<2);
  (*r)&=((~mascara)&0xFFFF);
  (*r)|=(valor<<(msxregs[posregs].desl<<2));
//  (*r)=15;
}

void set_debugger()
{
  posdisass=pointz80->PC.W;
  numPassosTrace=0;
  posmemory=0;
  basemem=0;
  modo=DISASS;
  pointz80->Trace=1;
  set_text_debugger(debug_linhas);
  set_windows();
  disassemble(pointz80->PC.W,1);
  show_regs();
  disp_memory();
  disp_msx();
}

int trata_comando(char* com)
{
  char nome[30];
  if (com[0]=='T' || com[0]=='t')
  {
      if (strlen(com)==1)
      {
        pointz80->Trap=0xFFFF;
        pointz80->Trace=1;
        return 1;
      }
      else {
        sscanf(&com[1],"%d",&numPassosTrace);
        if(numPassosTrace>0)numPassosTrace--;
        pointz80->Trap=0xFFFF;
        pointz80->Trace=1;
        return 1;
      }
  }
  if (com[0]=='S' || com[0]=='s')
  {
    sscanf(&com[1],"%s",nome);
    savestatemesmo(nome);
  }
  if (com[0]=='L' || com[0]=='l')
  {
    sscanf(&com[1],"%s",nome);
    loadstatemesmo(nome);
  }
  if (com[0]=='B' || com[0]=='b')
  {
    sscanf(&com[1],"%X",&pointz80->Trap);
    pointz80->Trace=0;
    setscreen(Placa, ResX, ResY);
    graf_mode=1;
  }
  if (com[0]=='V' || com[0]=='v')
  {
    setscreen(Placa, ResX, ResY);
    atualiza_tela();
    while(!key[KEY_ENTER]) ;
    set_debugger();
    clear_com(com);
    poscomando=0;
    ScreenSetCursor(24,poscomando);
    return 0;
  }
  if (com[0]=='Q' || com[0]=='q')
  {
    SaiMSX();
  }
  return 1;
}

void clear_com(char *c)
{
  int j;
  for(j=0;j<80;j++)
  {
    ScreenPutChar(0,WHITE,j,24);
    *c++='\0';
  }
}

void set_text_debugger(int lin)
{
    union REGS r;
    gppconio_init();
    _set_screen_lines( lin );
    r.x.ax = 0x1003;   /* set intensity/blinking */
    r.x.bx = 0;        /* intensity mode */
    int86( 0x10, &r, &r );

//    gettextinfo( &textinfo );

}

void exit_debugger()
{
 pointz80->Trace=0;
 setscreen(Placa, ResX, ResY);
}

void entitula(char* t,char* l)
{
  char Ctitulo='';//alt+174
  char Ttitulo='';//alt+175
  int a;
  char *u;
  l[0]=Ctitulo;
  strcpy(&l[1],t);
  l[strlen(t)+1]=Ttitulo;
  l[strlen(t)+2]='\0';
}

void draw_window(int x, int y, int w, int h, char* t1, char* t2, int cor)
{
  char titulo[80];
  char outra[80];
  char Hline='';//alt+196
  char Vline='';//alt+179
  char ULborda='';//alt+218
  char URborda='';//alt+191
  char BLborda='';//alt+192
  char BRborda='';//alt+217
  char Ctitulo='';//alt+174
  char Ttitulo='';//alt+175
  int tams;
  int i,j;
  w--; h--;
  entitula(t1,titulo);
  entitula(t2,outra);
  tams=strlen(outra);
  for(i=x+1; i<x+w; i++)
  {
    if((i>=0) &&(i<80))
    {
//      if(i-x<tams+9 && (i-x>8))
      if(i-x<w && (i-x>w-tams-1))
        ScreenPutChar(outra[i-x-w+tams],YELLOW,i,y);
      else if(i-x<strlen(titulo)+2 && (i-x>1))
        ScreenPutChar(titulo[i-x-2],YELLOW,i,y);
      else
        ScreenPutChar(Hline,cor,i,y);
      ScreenPutChar(Hline,cor,i,y+h);
    }
  }
  for(i=y+1; i<y+h; i++)
  {
    if((i>=0) && (i<25))
    {
      ScreenPutChar(Vline,cor,x,i);
      ScreenPutChar(Vline,cor,x+w,i);
    }
  }
  ScreenPutChar(ULborda,cor,x,y);
  ScreenPutChar(URborda,cor,x+w,y);
  ScreenPutChar(BLborda,cor,x,y+h);
  ScreenPutChar(BRborda,cor,x+w,y+h);

}

void set_windows()
{
  char cic[80];
  char end[80];
  char mmmm[10];
  char tlinha[10];
  int scr;
  int linha;
  if(tipomem) strcpy(mmmm,"VRAM"); else strcpy(mmmm,"RAM");
  scr=vdp.calc_screen();
  if(vdpline<27) {strcpy(tlinha,"Top border"); linha=vdpline;}
  else if(vdpline<192+27) {strcpy(tlinha,"Active Display"); linha=vdpline-27;}
  else if(vdpline<192+27+24) {strcpy(tlinha,"Bottom border"); linha=vdpline-(192+27);}
  else {strcpy(tlinha,"Blanking"); linha=vdpline-(192+27+24);}
  sprintf(cic,"%d,%d,%d-%s",pointz80->ICount,scr,linha,tlinha);
  if (!(buscatoken(poscursor,end,0,0)))
    sprintf(end,"%x",poscursor);
  if(modo==DISASS)
  {
    draw_window(25,0,56,5,"Z80",cic,RED);
    draw_window(25,4,56,10,mmmm,"",RED);
    draw_window(-1,0,27,24,"Power",end,YELLOW);
  }
  if(modo==MSXREGS)
  {
    draw_window(-1,0,27,24,"Power",end,RED);
    draw_window(25,4,56,10,mmmm,"",RED);
    draw_window(25,0,56,5,"Z80",cic,YELLOW);
  }
  if(modo==MEMORY)
  {
    draw_window(25,0,56,5,"Z80",cic,RED);
    draw_window(-1,0,27,24,"Power",end,RED);
    draw_window(25,4,56,10,mmmm,"",YELLOW);
  }
}

int disassemble(int pos, int tipo)
{
  int j;
  int taminst;
  char code[80];
  char token[80];
  int cor;
  int t;
  int valor=pos;
  int prim=1;
  int ult=22;
  for (j=prim;j<=ult;j++)
  {
    cor=WHITE;
    if (valor==poscursor) cor=WHITE+16*RED;
    if(j==ult) t=valor;
    if(valor==pointz80->PC.W) cor=WHITE+16*BLUE;
    taminst=DasmZ80(code,valor);
    memset(token,32,sizeof(token));
    sprintf(token,"%04X: %s",valor,code);
    valor+=taminst;
    if (tipo) cprint(token,0,j,cor,25);
  }
  return t;
}

void show_regs()
{
  char flags[10];
  char token[80];
  int im;
  char inter[4];
  if(pointz80->IFF&1) strcpy(inter, "EI"); else strcpy(inter, "DI");
  im=(pointz80->IFF>>1)&3;
  monta_flags(flags);
  memset(token,32,sizeof(token));
  sprintf(token,"PC:%04X SP:%04X AF:%04X BC:%04X DE:%04X HL:%04X",pointz80->PC.W,pointz80->SP.W,pointz80->AF.W,pointz80->BC.W,pointz80->DE.W,pointz80->HL.W);
  cprint(token,26,1,WHITE,50);
  sprintf(token,"IX:%04X IY:%04X AF'%04X BC'%04X DE'%04X HL'%04X",pointz80->IX.W,pointz80->IY.W,pointz80->AF1.W,pointz80->BC1.W,pointz80->DE1.W,pointz80->HL1.W);
  cprint(token,26,2,WHITE,50);
  memset(token,32,sizeof(token));
  sprintf(token,"%s  IM:%02X   R:%02X  Flags:%s",inter, im, pointz80->R, flags);
  cprint(token,26,3,WHITE,50);

}

void monta_flags(char *f)
{
	char sim[]="SZ5H3PNC";
	char nao[]="........";
	int i;
	for(i=0; i<8; i++) {
		f[i]=pointz80->AF.B.l & (128>>i)?sim[i]:nao[i];
	}
	f[8]='\0';
}
void disp_memory()
{
  char token[80];
  if(tipomem==MSXRAM)
  {
    disp_rammsx();
//    sprintf(token,"%s","RAM");
  }
  if(tipomem==MSXVRAM)
  {
    disp_vrammsx();
//    sprintf(token,"%s","VRAM");
  }
//  cprint(token,30,4,YELLOW,4);
}

void disp_vrammsx()
{
  char token[80];
  int i,j;
  for(i=0;i<8;i++)
  {
    j=basevram+i*16;
    memset(token,32,sizeof(token));
    sprintf(token, "%04X:%02X %02X %02X %02X %02X %02X %02X %02X-%02X %02X %02X %02X %02X %02X %02X %02X",
           j, vdp.getVram(j),vdp.getVram(j+1),vdp.getVram(j+2),vdp.getVram(j+3),vdp.getVram(j+4),vdp.getVram(j+5),vdp.getVram(j+6),vdp.getVram(j+7),
           vdp.getVram(j+8),vdp.getVram(j+9),vdp.getVram(j+10),vdp.getVram(j+11),vdp.getVram(j+12),vdp.getVram(j+13),vdp.getVram(j+14),vdp.getVram(j+15));

    cprint(token,26,5+i,WHITE,53);
  }
}

void disp_rammsx()
{
  char token[80];
  int i,j;
  for(i=0;i<8;i++)
  {
    j=basemem+i*16;
    memset(token,32,sizeof(token));
    sprintf(token, "%04X:%02X %02X %02X %02X %02X %02X %02X %02X-%02X %02X %02X %02X %02X %02X %02X %02X",
           j, RdZ80(j),RdZ80(j+1),RdZ80(j+2),RdZ80(j+3),RdZ80(j+4),RdZ80(j+5),RdZ80(j+6),RdZ80(j+7),
           RdZ80(j+8),RdZ80(j+9),RdZ80(j+10),RdZ80(j+11),RdZ80(j+12),RdZ80(j+13),RdZ80(j+14),RdZ80(j+15));

    cprint(token,26,5+i,WHITE,53);
  }
}

void disp_msx()
{
  char token[80];
  int i;
  sprintf(token, "Map:%01X %01X %01X %01X",IsExpanded[0],IsExpanded[1],IsExpanded[2],IsExpanded[3]);
  cprint(token,60,14,WHITE,strlen(token));
  sprintf(token, "VDP:%02X %02X %02X %02X %02X %02X %02X %02X",vdp.getReg(0), vdp.getReg(1),vdp.getReg(2),vdp.getReg(3),vdp.getReg(4),vdp.getReg(5),vdp.getReg(6),vdp.getReg(7)); 
  cprint(token,26,18,WHITE,strlen(token));
  sprintf(token, "VDP:Status:%02X Vram:%04X Interrupt:%01X", vdp.status, vdp.vramPtr);
  cprint(token,26,19,WHITE,strlen(token));
  if (IsExpanded[Porta_a8&3])
  {
    sprintf(token, "Page 0=%01X,%01X  ",Porta_a8&3,SlotExpanded[Porta_a8&3]&3);
    cprint(token,26,14,WHITE,strlen(token));
  }
  else
  {
    sprintf(token, "Page 0=%01X  ",Porta_a8&3);
    cprint(token,26,14,WHITE,strlen(token));
  }
  if (IsExpanded[(Porta_a8>>2)&3])
  {
    sprintf(token, "Page 1=%01X,%01X  ",(Porta_a8>>2)&3,(SlotExpanded[(Porta_a8>>2)&3]>>2)&3);
    cprint(token,26,15,WHITE,strlen(token));
  }
  else
  {
    sprintf(token, "Page 1=%01X  ",(Porta_a8>>2)&3);
    cprint(token,26,15,WHITE,strlen(token));
  }
  if (IsExpanded[(Porta_a8>>4)&3])
  {
    sprintf(token, "Page 2=%01X,%01X  ",(Porta_a8>>4)&3,(SlotExpanded[(Porta_a8>>4)&3]>>4)&3);
    cprint(token,26,16,WHITE,strlen(token));
  }
  else
  {
    sprintf(token, "Page 2=%01X  ",(Porta_a8>>4)&3);
    cprint(token,26,16,WHITE,strlen(token));
  }
  if (IsExpanded[(Porta_a8>>6)&3])
  {
    sprintf(token, "Page 3=%01X,%01X  ",(Porta_a8>>6)&3,(SlotExpanded[(Porta_a8>>6)&3]>>6)&3);
    cprint(token,26,17,WHITE,strlen(token));
  }
  else
  {
    sprintf(token, "Page 3=%01X  ",(Porta_a8>>6)&3);
    cprint(token,26,17,WHITE,strlen(token));
  }
  for(i=0;i<3;i++)
  {
    if(mapper[i][0])
    {
      sprintf(token, "Mapper %01X,%01X,%01X:%02X",i,0,0,memmapper[i][0][0]);
      cprint(token,38,14,WHITE,strlen(token));
      sprintf(token, "Mapper %01X,%01X,%01X:%02X",i,0,1,memmapper[i][0][1]);
      cprint(token,38,15,WHITE,strlen(token));
      sprintf(token, "Mapper %01X,%01X,%01X:%02X",i,0,2,memmapper[i][0][2]);
      cprint(token,38,16,WHITE,strlen(token));
      sprintf(token, "Mapper %01X,%01X,%01X:%02X",i,0,3,memmapper[i][0][3]);
      cprint(token,38,17,WHITE,strlen(token));
    }
    if(megarom[i][0])
    {
      sprintf(token, "Megarom %01X,%01X,%01X:%02X",i,0,0,memmegarom[i][0][0]);
      cprint(token,38,14,WHITE,strlen(token));
      sprintf(token, "Megarom %01X,%01X,%01X:%02X",i,0,1,memmegarom[i][0][1]);
      cprint(token,38,15,WHITE,strlen(token));
      sprintf(token, "Megarom %01X,%01X,%01X:%02X",i,0,2,memmegarom[i][0][2]);
      cprint(token,38,16,WHITE,strlen(token));
      sprintf(token, "Megarom %01X,%01X,%01X:%02X",i,0,3,memmegarom[i][0][3]);
      cprint(token,38,17,WHITE,strlen(token));
      sprintf(token, "Megarom %01X,%01X,%01X:%02X",i,0,4,memmegarom[i][0][4]);
      cprint(token,38,18,WHITE,strlen(token));
      sprintf(token, "Megarom %01X,%01X,%01X:%02X",i,0,5,memmegarom[i][0][5]);
      cprint(token,38,19,WHITE,strlen(token));
      sprintf(token, "Megarom %01X,%01X,%01X:%02X",i,0,6,memmegarom[i][0][6]);
      cprint(token,38,20,WHITE,strlen(token));
      sprintf(token, "Megarom %01X,%01X,%01X:%02X",i,0,7,memmegarom[i][0][7]);
      cprint(token,38,21,WHITE,strlen(token));
    }
/*    if(megaram[i][0])
    {
      sprintf(token, "Megaram %01X,%01X,%01X:%02X",i,0,0,memmegarom[i][0][0]);
      cprint(token,36,14,WHITE,16);
      sprintf(token, "Megaram %01X,%01X,%01X:%02X",i,0,1,memmegarom[i][0][1]);
      cprint(token,36,15,WHITE,16);
      sprintf(token, "Megaram %01X,%01X,%01X:%02X",i,0,2,memmegarom[i][0][2]);
      cprint(token,36,16,WHITE,16);
      sprintf(token, "Megaram %01X,%01X,%01X:%02X",i,0,3,memmegarom[i][0][3]);
      cprint(token,36,17,WHITE,16);
      sprintf(token, "Megaram %01X,%01X,%01X:%02X",i,0,4,memmegarom[i][0][4]);
      cprint(token,36,18,WHITE,16);
      sprintf(token, "Megaram %01X,%01X,%01X:%02X",i,0,5,memmegarom[i][0][5]);
      cprint(token,36,19,WHITE,16);
      sprintf(token, "Megaram %01X,%01X,%01X:%02X",i,0,6,memmegarom[i][0][6]);
      cprint(token,36,20,WHITE,16);
      sprintf(token, "Megaram %01X,%01X,%01X:%02X",i,0,7,memmegarom[i][0][7]);
      cprint(token,36,21,WHITE,16);
    }*/

  }
}

void cprint(char *s,int x, int y, int attr, int tam)
{
  tam=x+tam;
  while(x<tam) ScreenPutChar(*s++,attr,x++,y);
}

void esp(int a)
{
  static int back=0;
  uclock_t b;
  b=uclock();
  while(key[a])
  {
    if(back)
    {
      if(uclock()>b+TIMERS_PER_SECOND/20) {back=a; return;}
    }
    else
    {
      if(uclock()>b+TIMERS_PER_SECOND/5) {back=a; return;}
    }
  }
  back=0;
  return;
}

int le_teclas()
{
  int t;
//  t='/';
  t=readkey();
/*  if(key[KEY_A]) t='a';
  if(key[KEY_B]) t='b';
  if(key[KEY_C]) t='c';
  if(key[KEY_D]) t='d';
  if(key[KEY_E]) t='e';
  if(key[KEY_F]) t='f';
  if(key[KEY_G]) t='g';
  if(key[KEY_H]) t='h';
  if(key[KEY_I]) t='i';
  if(key[KEY_J]) t='j';
  if(key[KEY_K]) t='k';
  if(key[KEY_L]) t='l';
  if(key[KEY_M]) t='m';
  if(key[KEY_N]) t='n';
  if(key[KEY_O]) t='o';
  if(key[KEY_P]) t='p';
  if(key[KEY_Q]) t='q';
  if(key[KEY_R]) t='r';
  if(key[KEY_S]) t='s';
  if(key[KEY_T]) t='u';
  if(key[KEY_V]) t='v';
  if(key[KEY_W]) t='w';
  if(key[KEY_X]) t='x';
  if(key[KEY_Y]) t='y';
  if(key[KEY_Z]) t='z';
  if(key[KEY_SPACE]) t=' ';
  if(key[KEY_0]) t='0';
  if(key[KEY_1]) t='1';
  if(key[KEY_2]) t='2';
  if(key[KEY_3]) t='3';
  if(key[KEY_4]) t='4';
  if(key[KEY_5]) t='5';
  if(key[KEY_6]) t='6';
  if(key[KEY_7]) t='7';
  if(key[KEY_8]) t='8';
  if(key[KEY_9]) t='9';*/
  return t;
}
