#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <conf.h>
#include "sysdeps.h"
#include "xmalloc.h"

#if defined __GLIBC__ || defined MALLOC_HOOKS
void
xminit(void)
{
}

void
xminfo(void)
{
	malloc_stats();
}

void
xmterm(void)
{
}
#else
void
xminit(void)
{
}

void
xminfo(void)
{
}
void
xmterm(void)
{
}
#endif

#define _L	 LOG_INTERNAL | LOG_INFO

void *
xmalloc(size_t sz)
{
	void       *ret;

	ret = malloc(sz);
	if (!ret)
	{
		fprintf(stderr, "xmalloc:  failed in allocation of %d bytes\n", sz);
		exit(23);
	}
	return ret;
}

void *
xcalloc(size_t sz)
{
	void       *ret;

	ret = calloc(sz, 1);
	if (!ret)
	{
		fprintf(stderr, "xcalloc:  failed in allocation of %d bytes\n\n", sz);
		exit(23);
	}
	return ret;
}

void *
xrealloc(void *ptr, size_t sz)
{
	void       *ret = realloc(ptr, sz);

	if (!ret)
	{
		fprintf(stderr, "xrealloc:  failed in reallocation to %d bytes\n\n",
			 sz);
		exit(23);
	}
	return ret;
}

void
xfree(void *ptr)
{
	if (ptr)
		free(ptr);
}

char *
xstrdup(const char *str)
{
	char       *ret;
	 
	if (str)
	{
		ret = (char *) strdup(str);
		if (!ret)
		{
			fprintf(stderr, "xstrdup:  failed to copy string\n\n");
			exit(23);
		}
		return ret;
	}
	else
		return 0L;
}

char *
xintdup(int x)
{
	char       *ret = (char *) xmalloc(sizeof(int));

	if (!ret)
	{
		fprintf(stderr, "xintdup:  failed to copy int\n\n");
		exit(23);
	}
	memcpy(ret, &x, sizeof(int));

	return ret;
}
