#ifndef __TIMER_H__
#define __TIMER_H__

#include "centry.h"

extern	int	TM_Installed;			/* 1 if timer going */

int		TM_Init(void);
void	TM_Kill(void);
int		TM_Start(void);
void	TM_TickHandler(int unused);
int		TM_Stop(void);
int		TM_GetTicks(void);

int		TM_UniqueTag(void);

//	ticks = hz * TM_HZ
int		TM_SetEvent(int tag,int ticks,int start,int flags,volatile void *flag);
int		TM_ResetEvent(int tag);

/*	flags for TM_SetEvent:	*/

#define	TM_REPEAT	1		/* repeat event */
#define	TM_FUNC		2		/* 'void *flag' is actually void (*flag)() */

typedef void (*tm_timer_func)(void);
#define TM_EVENT_FUNC(x)	(volatile void *)(x)

#if defined(UNDER_WIN32)
#define TM_HZ	100
#else
#define TM_HZ 	100			/* base clock freq */
#endif


#include "cexit.h"

#endif
