#include <conf.h>
#include "sysdeps.h"
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#if !HAVE_STRCASECMP
int
strcasecmp(const char *a, const char *b) 
{
	int        x;

	while ((x = tolower(*a) - tolower(*b)) == 0 && *a) {
		a++;
		b++;
	}
	return x;
}
#endif

#if !HAVE_STRNCASECMP
int
strncasecmp(const char *a, const char *b, int max)
{
	int        x = 0;

	while (max-- && (x = tolower(*a) - tolower(*b)) == 0 && *a) {
		a++;
		b++;
	}
	return x;
}
#endif 
   
#if !HAVE_STRDUP
char *
strdup(const char *s)
{
	int        len = strlen(s) + 1;
	char      *ret = (char *) malloc(len);

	if (ret)
		strcpy(ret, s);
	return ret;
}

#endif

#if !HAVE_SWAB
void
swab(const void *_src, void *_dst, int num)
{
	const char *src = (const char *)_src;
	char *dst = (char *)_dst;

	while (num > 2) {
		char       tmp;

		tmp = src[0];
		dst[0] = src[1];
		dst[1] = tmp;
		dst += 2;
		src += 2;
		num -= 2;
	}
} 
#endif 

#if !HAVE_STRUPR
char *
strupr(char *s)
{
	char      *orig = s;

	while (*s) {
		*s = toupper(*s);
		s++;
	}
	return orig;
}

#endif
