#
#  gtkcallbacks.c is generated with repeats of existing functions.
#
#  this script identifies the existing functions and deletes the
#  empty new ones.
#

%function_map = ();
$filename = $ARGV[0];

open(FILE, "<$filename") || die;
open(NEW, ">$filename.tmp") || die;

$changed = 0;

$ifcount = 0;
while (<FILE>) {
  my $line = $_;

  if ($line =~ /\#if/) {
	print NEW $line;
	$ifcount++;
	while ($ifcount) {
	  $line = <FILE>;
	  print NEW $line;
	  if ($line =~ /\#endif/) {
		$ifcount--;
	  } elsif ($line =~ /\#if/) {
		$ifcount++;
	  }
	}
  }

  # look for return type on one line, and decl on next
  elsif ($line =~ /^void|^gboolean/) {
	my $decl = <FILE>;
	if ($decl =~ /^(on_[^( ]*)/) {

#	  print "function '$1'\n";

	  if (defined($function_map{$1})) {
		print "duplicate '$1'!\n";
		# skip
		while (<FILE> !~ /^}/) { };
	    $changed = 1;
	  } else {
		$function_map{$1} = "1";
		print NEW $line;
		print NEW $decl;
	  }

	} else {
	  print NEW $line;
	  print NEW $decl;
	}
  } else {
	print NEW $line;
  }
}
close(FILE);
close(NEW);

if ($changed) {
  rename("$filename.old2", "$filename.old3");
  rename("$filename.old", "$filename.old2");
  rename("$filename", "$filename.old") || die;
  rename("$filename.tmp", "$filename") || die;
} else {
  print "No changes to $filename\n";
}
