#ifndef __COMMAND_LEXER_H__
#define __COMMAND_LEXER_H__

#include "OSLib.h"

#include "centry.h"

#ifdef __COMMAND_L__

typedef struct command_context {
	const struct command_context 
			*outer;			/* encasing context */
	char 	*name;			/* name of this buffer */
	OSHandle hand;			/* text data */
	OSSize	len;			/* length of data */
	int		offs;			/* current offset in data */
	int		line;			/* current line number */
	YY_BUFFER_STATE	yybuf;	/* yybuffer */
}	command_context;

#else

typedef struct command_context command_context;

#endif

/*	Defined in command.l */

void lexer_error(const char *format, ...);
void lexer_include(char *yy);

command_context	*lexer_push_text(const char *name, const char *data, int len);
command_context *lexer_push_file(const char *filename);
command_context *lexer_pop_context(void);

int yylex(void);

#include "cexit.h"	

#endif
