
/*
 *	WIN32 types
 */

#include <x86_prefix.h>
#include <windef.h>
#include <winerror.h>
#include <time.h>

#define OS_MAXPATHLEN 	(MAX_PATH-1)
#define OS_MAXNAMELEN	63
#define OS_MAXVOLLEN	63		/* why this long?  for network names */

#define OS_VOLSIZE		64
#define OS_NAMESIZE		64
#define OS_PATHSIZE		MAX_PATH

#define OS_PATHSEP		'\\'
#define OS_PDSTR		"..\\"
#define OS_CWDSTR		"."

#define OS_ENVSEP		';'
#define OS_ENVSEPLIST	";,"

#define	OS_IS_CASE_INSENSITIVE 1
#undef	OS_REL_PATH_HAS_SEP

/*	As used by CreateFile() */
typedef	
HANDLE					OSRef;		/*	file ref */

/*	C string ending in '\\' */
typedef
struct				OSPathSpec
{
	char			s[OS_PATHSIZE];
}					OSPathSpec;			/*  OS specifier for a path */

typedef
struct				OSNameSpec
{
	char			s[OS_NAMESIZE];
}					OSNameSpec;			/*  OS specifier for a name */

/*	As used by FindFirstFile()/FindNextFile() */
typedef
struct
{
	struct
	{
		HANDLE		handle;
		void		*ffd;			/* really WIN32_FIND_DATA* */
	}				dir;
	OSPathSpec		path;			/* original path */
}					OSDirRef;		/*	directory scan ref */

/*	As used by GlobalAlloc(), etc.  */
typedef
struct	OSHandle
{
	void	*glob;
	size_t	used;
}		OSHandle;						/*  memory handle */

/*	As used by GetLastError() */
typedef 
DWORD					OSError;		/*	error type */

/*	No-error code */
#define	OS_NOERR		NO_ERROR

/*	Does OSError report error? */
#define OS_ISERR(x)		((x)!=NO_ERROR)

/*	OSError representing 'file not found' */
#define OS_FNFERR		ERROR_FILE_NOT_FOUND

/*	OSError representing 'directory not found' */
#define OS_DNFERR		ERROR_PATH_NOT_FOUND

/*	OSError representing 'file is a directory' */
#define OS_FIDERR		ERROR_ACCESS_DENIED

/*	OSError representing 'file is not a directory' */
#define OS_FNIDERR		ERROR_DIRECTORY

/*	OSError representing 'filename too long' */
#define OS_FNTLERR		ERROR_BUFFER_OVERFLOW

/*	OSError representing 'out of memory' */
#define OS_MEMERR		ERROR_NOT_ENOUGH_MEMORY

/*	OSError representing 'permission denied' */
#define OS_PERMERR		ERROR_INVALID_ACCESS

/*	OSError representing 'busy' (as for handles) */
#define OS_BUSYERR		ERROR_SHARING_VIOLATION

/*	Meaningless. */
typedef	
int					OSFileType;		/*	way to identify a file's type */

extern				OSFileType OS_TEXTTYPE;			/* text file */

/*	Time; a replica of FILETIME, in Win32, 
	a 64-bit value counting nanoseconds since 1/1/1601 (obviously) */
typedef
struct
{
	DWORD			dwLowDateTime;
	DWORD			dwHighDateTime;
}					OSTime;

/*	As used by LoadLibrary, etc */
typedef
HINSTANCE				OSLibrary;		/*  library handle */

