#ifndef __9901_H__
#define __9901_H__

#include "v9t9_types.h"
#include "sound.h"
#include "command.h"

#include "centry.h"

/*	9901 stuff 	*/

int		setup_9901(void);
void	reset9901(void);

void	trigger9901int(u16 mask);	// set specific interrupt level
void	reset9901int(u16 mask);		// reset specific interrupt level
u16		read9901int(void);			// get level of most important interrupt 

void	handle9901tick(void);		// keyed off 3.0 MHz / 64 clock

void	setclockmode9901(u8 onoff);	// when accessing bit > 15 from CRU

#define M_INT_EXT	2	// peripheral
#define M_INT_VDP 	4	// VDP
#define M_INT_CLOCK 8	// clock

typedef struct hw9901state
{
/*	9901 stuff 	*/
	u16         int9901;		/* interrupt enable mask */
	u16         currentints;	/* current pending interrupts */
	u16         intlevel;		/* current top-level interrupt */

	u8          clockmode;		/* 0=ints enabled, 1=programming clock */

	u16         clockinvl;	/* clock interval, 0 to >3FFF */
	u16         timer;		/* countdown timer value (from clockinvl9901 -> 0) */

	u16         latchedtimer;	/* timer latch -- inverted */
	u16         latchedclockinvl;	/* clock interval latch -- inverted */

}	hw9901state;

extern AudioGate   audiogate;		/* audio gate info */

extern hw9901state hw9901;

DECL_SYMBOL_ACTION(hw9901_machine_state);

#include "cexit.h"

#endif
