
/*
		16BIT.H
		=======

*/

#ifndef __16BIT__
#define __16BIT__

#include "v9t9_types.h"

#include "centry.h"

#if defined(__i386__) || defined(__INTEL__)
#define SWAPPED
#else
#error unknown byte order
//#undef SWAPPED
#endif

/*  for byte arrays */

#define WORD(ar,ad) (*(u16 *)((ar)+((ad)&0xfffe)))

#ifdef SWAPPED
#define BYTE(ar,ad) (*(u8 *)((ar)+((ad)^1)))
#else
#define BYTE(ar,ad) (*(u8 *)((ar)+(ad)))
#endif

#define FLAT_BYTE(ar,ad) (*(u8 *)((ar)+(ad)))

#ifdef SWAPPED
#define TI2HOST(x) ( (((u16)(x) & 0xff) << 8) | (((u16)(x) >> 8) & 0xff) )
#define HOST2TI TI2HOST
#define SWAPTI(x) ((u16)(x))
#else
#define TI2HOST(x)	((u16)(x))
#define HOST2TI TI2HOST
#define SWAPTI(x) ( (((u16)(x) & 0xff) << 8) | (((u16)(x) >> 8) & 0xff) )
#endif

#include "cexit.h"
#endif
