/*
	Portable TI99 tape encoder/decoder

	wave.h: Header file for wave.c

	Raphael Nabet 2002
*/

typedef uint_fast32_t sample_pos_t;

typedef struct wave_file_in_t
{
	FILE *handle;

	/*uint_fast32_t len;*/			/* total file len in bytes, minus 8 (not used) */
	/*uint_fast32_t data_len;*/		/* lenght of data in bytes (not used) */
	uint_fast32_t sample_len;		/* lenght of data in samples */

	/* fmt fields */
	/*int_fast16_t formatTag;*/			/* data encoding (always PCM for now) */
	uint_fast16_t channels;			/* number of channels */
	uint_fast32_t samplesPerSec;	/* sampling rate */
	/*uint_fast32_t avgBytesPerSec;*/	/* for buffer estimation */
	uint_fast16_t blockAlign;		/* data block size */
	uint_fast16_t bitsPerSample;	/* bits per sample (PCM format) */

	int sample_padding;		/* padding for each sample */
	float multiplier;		/* normalization factor to have samples in [-1,+1] */

	sample_pos_t sample_pos;		/* current sample position in file */
	uint_fast32_t data_offset;		/* offset to start of sample data in file */
} wave_file_in_t;

error_t open_wave_in(FILE *handle, wave_file_in_t *wave_file);
error_t read_wave_sample(wave_file_in_t *wave_file, float *reply);
#define tell_wave_sample(wave_file) ((wave_file)->sample_pos)
error_t seek_wave_sample(wave_file_in_t *wave_file, uint_fast32_t sample_pos);

typedef struct wave_file_out_t
{
	FILE *handle;

	uint_fast32_t samplesPerSec;	/* sampling rate */


	sample_pos_t sample_pos;		/* current sample position in file */
	uint_fast32_t data_offset;		/* offset to start of sample data in file */
} wave_file_out_t;

error_t open_wave_out(FILE *handle, uint_fast32_t samplesPerSec, wave_file_out_t *wave_file);
error_t close_wave_out(wave_file_out_t *wave_file);
error_t write_wave_sample(wave_file_out_t *dst, int data);
