* Standard RS232 byte output routine
* Must be adapted to respective RS232 card (eg. CRU address)

* Author: Michael Zapf
* Created: 1998-06-06

* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301, USA
* http://www.fsf.org/licensing/licenses/gpl.html

******************************************************************

* Defines:    SLWRBT
*             Called via:    BLWP @SLWRBT

* References: none

* Byte to be written in R0
* Status: EQ=1 <=> Byte could not be sent
*                  because the last transmission is not over yet

       DEF  SLWRBT

H2000  DATA >2000
RSWS   BSS  32
SLWRBT DATA RSWS,$+2
       LIMI 0
       LI   R12,>1340         Set CRU (RS232/1)
       SBO  16                Set RTS (request to send)
       TB   27                Is DSR active?
       JNE  STALL
       TB   22                Is send buffer ready?
       JEQ  WRITE
STALL  SOCB @H2000,R15        Not ready for writing
       JMP  ENDWR
WRITE  MOVB *R13,R0           Get value
       LDCR R0,8              Write it to CRU
       SZCB @H2000,R15        Worked fine
ENDWR  SBZ  16                Reset RTS
       RTWP

       END
