* Serial Line Internet Protocol (SLIP) driver
* Receives and transmits data via the RS232
* Uses STD232O for outputting bytes

* Author: Michael Zapf
* Created: 1998-06-06 

* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301, USA
* http://www.fsf.org/licensing/licenses/gpl.html

******************************************************************

       DEF  SLINIT,SL0CHK,SL0OUT,SL0DQ
       REF  SLWRBT
       REF  VMBW,VMBR,DSRLNK

PABDAT DATA >8000,>1800,>FF00,>0000,>0017
       TEXT 'RS232.BA=9600.DA=8.PA=N'
       EVEN

SL0WS  BSS 32
CIBADR EQU >8300
CIBLEN EQU >8302
CIBBOT EQU >8303
CIBTOP EQU >8304

GBCNT  DATA 50
FBUF   BSS  256         * Buffer for CIB data
H2000  DATA >2000

INPQT1 DATA 0           * upper end, but not for SL0DQ
INPQB  DATA 0           * Input queue, lower end
INPQT  DATA 0           * Upper end
OUTPQB DATA 0           * Output queue, lower end
OUTPQT DATA 0           * Upper end

IQST   DATA >2800       * Address of input queue (3 KB, ends at >33FF)
IQLEN  DATA >0C00
IQEND  DATA >3400

OQST   DATA >3400       * Address of output queue (3 KB, ends at >3FFF)
OQLEN  DATA >0C00       * (REF/DEF table may be destroyed during run time)
OQEND  DATA >4000

* Routine to check if there are new data in the CIB
* If so, they are copied to FBUF (with leading length word)
* (if there are more than 64 bytes in the CIB or there are no new
* bytes after 50 checks)
* After that, the pointers are reset to the start of the CIB
* Sets EQ if there are new data; R2=length

GETBUF LIMI 0
       MOVB @CIBTOP,R2
       JEQ  GBNIX
       SRL  R2,8
       CI   R2,64
       JGT  GBHOL
       DEC  @GBCNT
       JNE  GBNIX
GBHOL  LI   R1,FBUF+2
       MOV  @CIBADR,R0
       INC  R0           * Ring buffer: R0 was below that.
       BLWP @VMBR
       LI   R0,50
       MOV  R0,@GBCNT
       MOVB R0,@CIBTOP
       MOV  R2,R2       * for getting EQ<>0
       JMP  GBEND
GBNIX  CLR  R2
GBEND  LIMI 2
       MOV  R2,@FBUF
       RT

* Check for new data and write data from the output queue

SL0CHK DATA SL0WS,$+2
       LIMI 2
SL01   BL   @GETBUF     Try to get CIB data. Nothing new?
       JEQ  SLTAS
       BLWP @PROCFB     Process FBUF. Is INPQ full?
       JNE  SLTAS
       BLWP @>0000      Fatal error, INPQ full. Exit.

* Check for data in the output queue

SLTAS  MOV  @OUTPQB,R1
       C    @OUTPQT,R1        Now data to be written?
       JEQ  NOWRT
       INC  R1
       C    R1,@OQEND
       JLT  $+6
       MOV  @OQST,R1
       MOVB *R1,R0
       BLWP @SLWRBT      Write R0HB. Was it transmitted?
       JEQ  NOTSNT       No, probably next time.
       MOV  R1,@OUTPQB   New lower end
NOTSNT NOP
NOWRT  RTWP

* Initialising the interface

SLINIT DATA SL0WS,$+2
       LIMI 0
       LI   R0,>0F80
       LI   R1,PABDAT
       LI   R2,33
       BLWP @VMBW            Write PAB

       LI   R0,>0F89
       MOV  R0,@>8356
       CLR  @>837C
       BLWP @DSRLNK          Open RS232. Was there an error?
       DATA 8
       JNE  SLOP
       SOCB @H2000,R15
       JMP  SL0INE

SLOP   LI   R0,>1000         CIB starts at >1000
       MOV  R0,@>8300
       LI   R1,>FF00         255 bytes long
       MOV  R1,@>8302        Write that and clear BUFBOT
       SWPB R1
       MOVB R1,@>8304        as well as BUFTOP

       MOV  @IQEND,R0
       DEC  R0
       MOV  R0,@INPQB        Queue is initialised as empty
       MOV  R0,@INPQT
       MOV  R0,@INPQT1

       MOV  @OQEND,R0         Same for the output queue
       DEC  R0
       MOV  R0,@OUTPQB
       MOV  R0,@OUTPQT

       SZCB @H2000,R15
       CLR  @PFSTA           Define starting state='outside'
       LI   R0,INPQB
       MOV  R0,@10000
SL0INE RTWP

* Dequeue frames from the input queue

SL0DQ  DATA SL0WS,$+2
       MOV  @INPQB,R4
       C    @INPQT,R4        Buffer empty?
       JEQ  SL0DQE

       INC  R4               BOT points *below* the data
       BL   @R4MOD

       MOV  @>0002(R13),R0   Get destination
       MOV  *R4+,R2
       MOV  R2,@>0004(R13)   Write length

SL0DQ1 BL   @R4MOD
       MOV  R2,R2
       JGT  SL0DQ2
       JMP  SL0DQ3
SL0DQ2 MOV  *R4+,*R0+        Copy words
       DECT R2
       JMP  SL0DQ1

SL0DQ3 C    R4,@IQST         could need to set it to IQEND-1
       JNE  SL0DQ4
       MOV  @IQEND,R4
SL0DQ4 DEC  R4
       MOV  R4,@INPQB        INPQB is always on an odd address
SL0DQE RTWP

* Put data in the output queue
* Structure similar to PROCFB
* Output buffer is a ring buffer, similar to INPQ
* However, it does not require a length word, because the
* output is just a byte stream
* (thus we also don't need word alignment)

SL0OUT DATA SL0WS,$+2
       MOV  @OUTPQT,R4
       MOV  @OUTPQB,R6
       S    R4,R6
       JGT  $+6
       A    @OQLEN,R6         R6 = free space+1
       SZCB @H2000,R15

       MOV  @>0002(R13),R1
       MOV  @>0004(R13),R2

* Write SLIP frame delimiter

       BL   @R4MINC
       JEQ  ENQFL
       MOVB @FRDLT,*R4

* SLIP frame content
* Escape mechanism: The frame delimiter code is reserved.
* Therefore, we need to 'escape' this code and the escape code when
* it appears in the data.

ENQ    BL   @R4MINC
       JEQ  ENQFL
       CB   *R1,@FRDLT        FRDLT => ESC,ESCFRD
       JNE  ENQESC
       MOVB @ESCFRD,R0
       JMP  ENQE1
ENQESC CB   *R1,@ESC          ESC => ESC,ESCESC
       JNE  ENQNRM
       MOVB @ESCESC,R0
ENQE1  MOVB @ESC,*R4
       BL   @R4MINC
       JEQ  ENQFL
       MOVB R0,*R4
       INC  R1
       JMP  ENQNX

ENQNRM MOVB *R1+,*R4
ENQNX  DEC  R2
       JNE  ENQ

* Write SLIP frame delimiter (end of frame)

ENQR   BL   @R4MINC
       JEQ  ENQFL
       MOVB @FRDLT,*R4
       MOV  R4,@OUTPQT
       JMP  SL0OEN
ENQFL  SOCB @H2000,R15
SL0OEN RTWP

* Modulo increment. R4 wraps around to the beginning if incremented
* past the end.

R4MINC INC  R4
       C    R4,@OQEND
       JLT  $+6
       MOV  @OQST,R4
       DEC  R6
       RT

* Process new data in FBUF
* This routine enqueues new frames in the input queue
* Does not require additional buffer for building the frame while
* de-escaping.

FRDLT  BYTE >C0          Frame delimiter

ESC    BYTE >DB          Escape byte
ESCFRD BYTE >DC          C0 escape value
ESCESC BYTE >DD          DB escape value

FRST   DATA 0            Address in INPQ where frame begins
PFWS   BSS  32
PFSTA  DATA 0            State of processing (inside/outside frame)

PROCFB DATA PFWS,PFSTRT

PFSTRT LI   R1,FBUF
       MOV  *R1+,R2

       MOV  @INPQT1,R4        * R4 = upper end of INPQ
       MOV  @INPQB,R6         * Insert at R4+1 mod IQLEN
       S    R4,R6
       JGT  $+6
       A    @IQLEN,R6
       DEC  R6                * R6 = free space in INPQ
       SZCB @H2000,R15

       MOV  @PFSTA,R0         * outside the frame?
       JNE  PFS3

* Start (before first frame or after last frame)
*   step forward to FRDLT
*   R1= current position in FBUF
*   R2 = number of bytes in FBUF
*   NOTE: FBUF is no ring buffer; thus does not need modulo calcs

PFS1   DEC  R2               * Part 1: Step forward to FRDLT
       JLT  FBEMPT
       MOVB *R1+,R3
       CB   R3,@FRDLT
       JNE  PFS1

* Frame delimiter found.

PFS2   CI   R6,3             * 2 bytes necessary for length word
       JLT  IQFULL           * (keep space for alignment)
       MOV  R4,R0
       SRL  R0,1             * Was R4 odd?
       JOC  PFS2EV
       INC  R4               * Word alignment
       BL   @R4MOD
       DEC  R6

PFS2EV INC  R4
       BL   @R4MOD
       DEC  R6
       MOV  R4,@FRST
       INC  R4               * Space for length word
       BL   @R4MOD           * NOTE: position *before* next free space!
       DECT R6

PFS21  CLR  R5               * Counter

       SETO @PFSTA           * Enter state 'inside'

* Inside frame.

PFS3   DEC  R2               * Bytes remaining in FBUF?
       JLT  FBEMPT
       MOVB *R1+,R3          * Next byte

       CB   R3,@FRDLT        * Frame delimiter?
       JEQ  PFS4

* Two ESCs leave the ESC mode.
* This situation is actually undefined.

       MOV  @PFSTA,R0         Outside ESC mode?
       JLT  PFS32
       CB   R3,@ESCFRD
       JNE  PFS31
       MOVB @FRDLT,R3
       JMP  PFS33
PFS31  CB   R3,@ESCESC
       JNE  PFS32
       MOVB @ESC,R3
       JMP  PFS33
PFS32  CB   R3,@ESC           Escape?
       JNE  PFS34
       NEG  @PFSTA            Escape mode (= +1)
       JMP  PFS3

PFS33  NEG  @PFSTA           Again outside the ESC mode
PFS34  LI   R6,2             No space left in INPQ?
       JLT  IQFULL
       INC  R4               Next position
       BL   @R4MOD

       DEC  R6               Decrement free space
       MOVB R3,*R4           Write into free space
       INC  R5               Increment number of written bytes
       JMP  PFS3

* End of frame

PFS4   MOV  @FRST,R0
       MOV  R5,*R0           Insert length word
       MOV  R4,@INPQT        Determine new TOP
       CLR  @PFSTA           Here we go again
       JMP  PFS1             to search the next frame start

IQFULL CLR  @PFSTA           Abort; no space left
       SOCB @H2000,R15
       JMP  PFQUIT

FBEMPT MOV  @PFSTA,R0        Buffer empty and frame complete?
       JNE  PFQUIT
       ORI  R4,>0001         Align before next word
       MOV  R4,@INPQT

PFQUIT MOV  R4,@INPQT1
       RTWP

R4MOD  C    R4,@IQEND
       JLT  $+6
       MOV  @IQST,R4
       RT

       END
