* Reassembly algorithm with demonstration program

* Author: Michael Zapf
* Created: 1998-06-07

* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301, USA
* http://www.fsf.org/licensing/licenses/gpl.html

************************************************************************
* To be started in MDOS by LDR

       B    @START

BUFFER BSS  80

* Our example has eight lines.
* Format of the reassembly buffer entry:
*
* ID | next buffer | hole index | text (length+2)
*
REASB  BSS  8*88
REASBE EQU  $

HEADLN EQU  6
TEXTLN EQU  82
LINELN EQU  HEADLN+TEXTLN

* The PAB for the sample file
* You may use any other path in the TEXT line; count its
* characters and put this value in hex at the end of the DATA line

PAB    DATA >0014,>0000,BUFFER,>0000,>0050,>0000,>0000,>000D
       TEXT 'DSK1.TESTFILE'

CRLF   BYTE >0D,>0A

VIDEO  DATA 6

START  LWPI >E000

       BLWP @DSR
       DATA >0000     Open the input file
       JEQ  FINISH      Exit on error

* --------------------------------------

SCHLF  BLWP @DSR
       DATA >0200           Read a record
       JEQ  FINISH
       LI   R1,BUFFER
       MOV  @PAB+2,R2
       BLWP @PARSE          Parse the read line

* Parse result:
* R1 = pointer to text fragment
* R2 = length of text fragment
* R3 = ID of text fragment
* R4 = offset from beginning
* R5 = 0 if no more fragments

       MOV  R5,R5          no more fragments?
       JNE  MOREFR
       MOV  R4,R4          And offset 0? (means: text was not fragmented)
       JEQ  NOFRAG

MOREFR BLWP @REASSM        Try to reassemble.
       JNE  SCHLF          If no line is completed, read next fragment.

* R1=pointer to text, R2=length

NOFRAG BLWP @SHOW
       JMP  SCHLF

* --------------------------------------

FINISH BLWP @DSR
       DATA >0100           Close the input file

       BLWP @>0000          Exit to command prompt

* Print the message pointed to in the DATA line

MESG   DATA >E040,$+2
       LI   R0,>27
       MOV  *R14+,R1
       CLR  R2
       XOP  @VIDEO,0
       RTWP

* DSR subroutine
* Just set pointers and call XOP
* DSR operation to be found in DATA line after BLWP @DSR

UTLWS  EQU  >E020
DSRCAL DATA 8
H2000  DATA >2000

DSR    DATA UTLWS,$+2
       SZCB @H2000,R15
       LI   R0,PAB
       MOVB *R14+,*R0
       INC  R14
       XOP  @DSRCAL,0
       MOVB @PAB+2,R1
       JEQ  DSREND
       SOCB @H2000,R15
DSREND RTWP

* Parse the line from the file
* The first two bytes are the ID, then there must be a blank
* The next two bytes are the offset, then a blank
* Then a quote initiates the string, which is terminated by a quote
* If a plus stands right after the last quote, this was not the
* end of the line.

QUOPLS DATA >222B               22=quote, 2B=plus
TEN    DATA 10
PARSE  DATA UTLWS,$+2
       MOV  @>0002(R13),R1      Buffer address
       MOV  @>0004(R13),R2      number of read bytes
       MOV  *R1+,@>0006(R13)    store ID as a word (not as a number)
       INC  R1                  skip next byte (blank)
       CLR  R5
PARSLP MOVB *R1+,R3             read (ascii) byte
       SRL  R3,8
       CI   R3,32               blank indicates end of offset
       JEQ  CONT
       MPY  @TEN,R5             shift left one decimal position
       MOV  R6,R5
       AI   R3,-48              subtract ascii offset
       A    R3,R5               add digit
       JMP  PARSLP
CONT   MOV  R5,@>0008(R13)      put offset in R4 of caller's WS
       LI   R5,80               text not longer than 80 chars
       MOV  R1,R2
WEI1   CB   *R1+,@QUOPLS        first quote
       JEQ  TXSTRT
       DEC  R5
       JNE  WEI1
       MOV  R2,R1               Did not find first quote. Make length=0.
       MOV  R1,@>0002(R13)      (see 'S R2,R1' below)
       JMP  WEI3
TXSTRT MOV  R1,@>0002(R13)      start of text
       LI   R5,80               max 80 chars
       MOV  R1,R2
WEI2   CB   *R1+,@QUOPLS        second quote
       JEQ  TXTEND
       DEC  R5
       JNE  WEI2
       MOV  R2,R1               Did not find second quote. Make length=0.
WEI3   INC  R1
TXTEND CLR  R5                  Clear R5
       CB   *R1,@QUOPLS+1       Is there a plus appended?
       JNE  NOMORE
       SETO R5                  Yes, this was not the end of the line.
NOMORE MOV  R5,@>000A(R13)
       S    R2,R1               Determine length.
       DEC  R1
       MOV  R1,@>0004(R13)
       RTWP

* Routine to show the line.
* Just calling appropriate XOP.
* (Output of strings with length in R2)

SHOW   DATA UTLWS,$+2
       LI   R0,>27
       MOV  @2(R13),R1
       MOV  @4(R13),R2
       JEQ  NOTXT
       XOP  @VIDEO,0
NOTXT  LI   R1,CRLF
       LI   R2,2
       XOP  @VIDEO,0
       RTWP

*****************************************************************
*
*  Reconstruction algorithm ---   RFC 815
*
*  Input (caller's WS)
*
*  R1   Pointer to the text
*  R2   Length of text
*  R3   Identification
*  R4   Offset
*  R5   More fragments (true/false)
*
*  Output (caller's WS)
*
*  R1   Pointer to reconstructed packet
*  R2   Length of reconstructed packet
*  EQ   1 if packet complete
*
*  Register usage
*
*  R4,R5   Pointer (physical addresses)
*  R6      Cursor (relative addresses)

* Just for the trace output: Ascii codes of numbers

STEP1T DATA >3100
STEP2T DATA >3200
STEP3T DATA >3300
STEP4T DATA >3400
STEP5T DATA >3500
STEP6T DATA >3600
STEP7T DATA >3700
STEP8T DATA >380D,>0A00

NEWBFT TEXT ' <alloc new buffer> '
       DATA 0
BUFFDT TEXT ' <found buffer> '
       DATA 0
IDT    TEXT 'ID: xx'
       DATA >0D0A,0
WERTT  TEXT 'Value=x'
       DATA >0D0A,0
NEWHOL TEXT ' <new hole> '
       DATA 0

STRPTR DATA 0

REASSM DATA UTLWS,$+2
       SZCB @H2000,R15

* Find the correct buffer
* Compare the IDs of the buffers with the ID of the fragment

       LI   R5,STRPTR
SIDLP  MOV  *R5,R1
       JEQ  EOLIST
       MOV  R1,R5
       BL   @CHCKID         Check the ID (easy in this example)
       JNE  SIDLP
       BLWP @MESG
       DATA BUFFDT          Yes, we know this ID already.
       AI   R5,4
FNDID  MOV  R5,@BASE
       JMP  REAS            Continue with the reassembly.

** No entry in the buffer for this ID.

EOLIST CI   R5,STRPTR
       JEQ  NEWLST
       MOV  R5,R4
       AI   R5,LINELN-2     Generate a new entry.
       CI   R5,REASBE       Hope there is enough room.
       JHE  REASBF
APPEND MOV  R5,*R4          Continue linked list.
       BLWP @MESG
       DATA NEWBFT          Tell us you've allocated a new buffer
       BL   @PUTID
       CLR  *R5+            Clear hole list pointer
       SETO *R5+

* Start of hole is determined by the position of the hole itself
       SETO *R5             End of hole is infinity (nearly)
       DECT R5
       JMP  FNDID

NEWLST LI   R5,REASB
       LI   R4,STRPTR
       JMP  APPEND

*** Buffer full

REASBF RTWP                 Don't panic, just throw fragment away.

* Application of the RFC 815 algorithm
*
* Buffer structure:
*
*                        +---------v          +------v
*   |Start|.......|next|last|///////|......|n|l|//////|......
*     +------------^ +----------------------^
*
*   Start/next = FFFF means: nil
*   Begin: Start = 0000, next=FFFF, last = FFFF
*   End: Start = FFFF
*
*   R7 = fragment.first (relativ to buffer)
*   R8 = fragment.length
*   R9 = fragment.last
*
*   R5 = Pointer to cur. position in buffer (initially at &ID+2)
*
*   NOTE: Offset is multiple of 8 in IP
*   Here it must be at least even.
*   (We should enforce it to be multiple of 8 as well!)
*
*   Note also the trick mentioned in RFC 815: The linked hole list
*   shares the same memory as the holes themselves! As each hole is
*   at least 8 bytes long, there is enough space to hold an entry
*   of a hole, namely exactly the hole starting at the position of
*   the hole list entry. After the linked list is updated, the entry
*   is simply overwritten by the fragment.

PREVNH DATA 0                  Pointer to last 'next' entry
PKGEND DATA 0
BASE   DATA 0

REAS   MOV  @>0008(R13),R7     offset==fragment.first
       MOV  @>0004(R13),R8     length
       MOV  R8,R9
       DEC  R9
       A    R7,R9              fragment.last

       MOV  @BASE,R5
       DECT R5                 points to hole list pointer

* Step 1:
* Select the next hole descriptor from the hole descriptor list.
* If there are no more entries, go to step 8.

STEP1  BLWP @MESG
       DATA STEP1T
       MOV  *R5,R1
       CI   R1,>FFFF            no more holes?
       JEQ  STEP8               Then we're done.

       MOV  R1,R10              hole.first
       MOV  R1,R4
       A    @BASE,R4            physical address of hole.first
       MOV  R5,@PREVNH
       MOV  R4,R5               R5 = hole.first (phys)
       INCT R4
       MOV  *R4,R11             R4 = hole.last (phys)

* Step 2:
* If fragments.first is greater than hole.last, go to step 1.

STEP2  BLWP @MESG
       DATA STEP2T
       C    R7,R11              fragment.first > hole.last?
       JH   STEP1

* Step 3:
* If fragment.last is less than hole.first, go to step 1.
* (If either step 2 or step 3 is true, then the newly arrived fragment
* does not overlap with the hole in any way, so we need pay no further
* attention to this hole. We return to the beginning of the algorithm
* where we select the next hole for examination.)

STEP3  BLWP @MESG
       DATA STEP3T
       C    R9,R10              fragment.last < hole.first?
       JL   STEP1

* Step 4:
* Delete the current entry from the hole descriptor list
* (Since neither step 2 nor step 3 was true, the newly arrived fragment
* does interact with this hole in some way. Therefore, the current
* descriptor will no longer be valid. We will destroy it, and in the
* next two steps we will determine whether or not it is necessary
* to create any new hole descriptors.)

STEP4  BLWP @MESG
       DATA STEP4T
       MOV  @PREVNH,R0          dequeue hole from list
       MOV  *R5,*R0

* Step 5:
* If fragment.first is greater than hole.first, then create a new hole
* descriptor "new_hole" with new_hole.first equal to hole.first, and
* new_hole.last equal to fragment.first minus 1
* (If the test in step 5 is true, then the first part of the original
* hole is not filled by this fragment. We create a new descriptor
* for this smaller hole.)

STEP5  BLWP @MESG
       DATA STEP5T
       C    R7,R10              fragment.first > hole.first?
       JLE  STEP6
       BLWP @MESG
       DATA NEWHOL
       MOV  @PREVNH,R0
       MOV  *R0,R1              previous_hole.next
       MOV  R1,*R5+             R4 is still hole.first (phys)
*                               new_hole.next = previous_hole.next
       MOV  R7,*R5
       DEC  *R5                 new_hole.last = fragment.first - 1
       DECT R5
       MOV  R10,*R0

* Step 6:
* If fragment.last is less than hole.last and fragment.more_fragments is
* true, then create a new hole descriptor "new_hole", with new_hole.first
* equal to fragment.last plus 1 and new_hole.last equal to hole.last
* (This test is the mirror of step 5 with one additional feature. Initially,
* we did not know how long the reassembled datagram would be, and therefore
* we created a hole reaching from zero to infinity. Eventually, we will
* receive the last fragment of the datagram. At this point, the hole
* descriptor which reaches from the last octet of the buffer to infinity
* can be discarded. The fragment which contains the last fragment indicates
* this fact by a flag in the internet header called "more fragments". The
* test of this bit in this statement prevents us from creating a descriptor
* for the unneeded hole which describes the space from the en\d of the
* datagram to infinity.)

STEP6  BLWP @MESG
       DATA STEP6T
       C    R9,R11              fragment.last < hole.last?
       JHE  STEP7
       MOV  @>000A(R13),R0      more_fragments==0?
       JEQ  STEP7
       BLWP @MESG
       DATA NEWHOL
       MOV  @PREVNH,R0
       MOV  *R0,R1
       MOV  R9,R2
       INC  R2
       MOV  R2,*R0
       A    @BASE,R2           actual position of new_hole.first=frag.last+1
       MOV  R1,*R2+            new_hole.next = previous_hole.next
       MOV  R11,*R2            new_hole.last = hole.last

* Step 7:
* Go to step 1

STEP7  BLWP @MESG
       DATA STEP7T
       B    @STEP1

* Step 8
* If the hole descriptor list is now empty, the datagram is complete. Pass
* it on to the higher level protocol processor for further handling.
* Otherwise, return.

STEP8  BLWP @MESG
       DATA STEP8T

** Write fragment in hole
** Hole list could be destroyed if this happened earlier!

       MOV  R8,R2
       MOV  @>0008(R13),R0
       A    @BASE,R0
       MOV  @>0002(R13),R1
STEP8A MOVB *R1+,*R0+
       DEC  R2
       JNE  STEP8A

       MOV  @>000A(R13),R0     more_fragments == false?
       JNE  $+6
       MOV  R9,@PKGEND         Then fragment.last is the end.
       MOV  @BASE,R2
       MOV  @>FFFE(R2),R1
       CI   R1,>FFFF           No more holes?
       JNE  REASEN

* Return the complete packet

       MOV  R2,@>0002(R13)
       MOV  @PKGEND,R2
       INC  R2
       MOV  R2,@>0004(R13)      was counted relatively (handy!)
       SOCB @H2000,R15
REASEN RTWP

* Check the ID. Very easy in this case because the ID can be stored
* in one word.

CHCKID C    *R5+,@>0006(R13)
       RT

* Write the ID. We used a BL call both times to allow a generic ID
* structure.

PUTID  MOV  @>0006(R13),*R5+
       CLR  *R5+                    End of the list
       RT

*
* End of the reconstruction algorithm
*********************************************************

       END
