* Test program for the sl0 driver
* Author: Michael Zapf
* Created: 1997-08-24

* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301, USA
* http://www.fsf.org/licensing/licenses/gpl.html

***********************************************************************
* This program replies to PING requests

* requires:
*
*   SL0D_X	 interface driver
*   SLCRC_X      cyclic redundancy check (not yet implemented)
*   STD232O_X    low-level RS232 byte output routine

       DEF  MAIN
       REF  SLINIT           initialize interface and driver
       REF  SL0CHK           check for new bytes in the buffer
       REF  SL0OUT           put a given string in the output queue
       REF  SL0DQ            fetch one frame from the input queue
       REF  VMBW,VMBR,VWTR

WINBTL EQU  23               Window bottom line 
WINWTH EQU  40               Window width
SCRWTH EQU  40               Screen width
WINLNS EQU  12               Number of lines of display window
WINLBR EQU  0                Left border
WINTL  EQU  11               Top line

SCRBUF BSS  WINWTH           Scroll buffer

LOCBUF EQU  >E000            Local frame contents buffer

H2000  DATA >2000

* Video registers for Text mode

VREG   DATA >0000,>0170,>0200,>030E
       DATA >0401,>0506,>0600,>07B1

* Special constants

ICMP   DATA >0100            Protocol type 01 = ICMP
PINGRQ DATA >0800            ICMP type 08 = PING request
PINGRP DATA >0000            ICMP type 00 = PING reply
FRDLT  DATA >C000            SLIP frame delimiter

NOICMP TEXT 'Not ICMP: msg discarded.'
NOPING TEXT 'Unrecognized ICMP message.'
PINGT  TEXT 'PING request received; replying'
TITLE  TEXT '** Test program for the sl0d driver **'
       EVEN

*** Start of main program ***

MAIN   LIMI 0              No interrupts during set-up.

* Switch to TEXT mode
* Not actually necessary, but I needed some trace output until it worked.
 
       LI   R1,VREG
       LI   R2,8
SETVR  MOV  *R1+,R0
       BLWP @VWTR
       DEC  R2
       JNE  SETVR
       LI   R1,VREG
       MOVB @>0003(R1),@>83D4

* Clear the screen

       LI   R0,>0040
       MOVB R0,@>8C02
       SWPB R0
       MOVB R0,@>8C02
       LI   R2,960
CLR    MOVB @H2000,@>8C00
       DEC  R2
       JNE  CLR

* Display the title

       LI   R0,121 
       LI   R1,TITLE
       LI   R2,38
       BLWP @VMBW

       BLWP @SLINIT          Initialize interface and driver
       JNE  MAINLP
       BLWP @>0000           Exit on error

* Main loop. Enable interrupts so that data can be received
* in the Circular Input Buffer (CIB)

MAINLP LIMI 2 
       BLWP @SL0CHK          Check for new data
       CLR  R2
       LI   R1,LOCBUF        
       BLWP @SL0DQ           Try to get one frame from the input queue
       MOV  R2,R2            Zero size indicates: no new data
       JEQ  MAINLP

* We got a new frame pointed to by R1, length in R2.
* For the sake of simplicity, let's just check if it's an ICMP message.

       MOV  R2,R7                        
       LI   R0,WINBTL*SCRWTH+WINLBR          Screen position for all messages
       CB   @>0009(R1),@ICMP                 Is it an ICMP message?
       JEQ  RCICMP
       LI   R1,NOICMP                        No, just ignore it. (This time.)
       LI   R2,24
       JMP  PRINT
RCICMP CB   @>0014(R1),@PINGRQ               Is it a PING request?
       JEQ  RCPING
       LI   R1,NOPING                        Can't process other messages, sorry.
       LI   R2,26
       JMP  PRINT

* It is a PING request. Let's reply!
* Our two communication peers have IP addresses that only differ in the last byte.

RCPING MOVB @>000F(R1),R2                    Exchange sender IP address
       MOVB @>0013(R1),@>000F(R1)            with receiver IP address
       MOVB R2,@>0013(R1)
       LI   R2,>0008
       MOVB R2,@>0014(R1)                    PING reply = 00
       SWPB R2
       A    R2,@>0016(R1)                    Correct checksum. (Guess what I forgot at first.)

* Encapsulate the reply in a SLIP frame. 

       MOV  R1,R8
       LI   R1,FRDLT
       LI   R2,1
       BLWP @SL0OUT           Put a frame delimiter in the output queue.
       MOV  R8,R1
       MOV  R7,R2
       BLWP @SL0OUT           Enqueue the message.
       LI   R1,FRDLT
       LI   R2,1
       BLWP @SL0OUT           And a closing frame delimiter.
       LI   R1,PINGT
       LI   R2,31
PRINT  LIMI 0
       BLWP @VMBW             Tell the user what you did just now.
       BL   @SCROLL           
       JMP  MAINLP

* Scroll the screen. 
* This is fairly straight-forward, so no remarks here.

SCROLL LI   R0,WINTL*SCRWTH
       LI   R1,SCRBUF
       LI   R2,WINWTH
SCRLP  AI   R0,2*SCRWTH
       LIMI 0
       BLWP @VMBR
       AI   R0,-SCRWTH
       BLWP @VMBW
       LIMI 2
       CI   R0,WINBTL*SCRWTH
       JNE  SCRLP
       ORI  R0,>4000
       SWPB R0
       LIMI 0
       MOVB R0,@>8C02
       SWPB R0
       MOVB R0,@>8C02
       LI   R2,WINWTH
SCRCL  MOVB @H2000,@>8C00
       DEC  R2
       JNE  SCRCL
       LIMI 2
       RT

       END

