* Pre-version of the IP driver                                   
* Does not support reassembly                                    
* Main program for testing the SLIP0 driver                      

* Author: Michael Zapf
* Created: 1998-06-06 

* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of 
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License 
* along with this program; if not, write to the Free Software 
* Foundation, Inc., 51 Franklin Street, Fifth Floor, 
* Boston, MA 02110-1301, USA 
* http://www.fsf.org/licensing/licenses/gpl.html

**********************************************************************
* Defines:      MAIN
*               Called via:  Editor/Assembler Option 3/4
*
*               SRCIP,DSTIP
*               Exported variables, two words each
*
*               CHKS1C  - One's complement checksum
*               Called via: BLWP
*
* References:   symbols from SLIP0_X, STD232O_X, PROT_X
*

       DEF  MAIN
       DEF  SRCIP,DSTIP,CHKS1C
       REF  SLINIT,SL0CHK,SL0OUT,SL0DQ
       REF  ICMP,TCP,UDP
       REF  VMBW,VMBR,KSCAN,VWTR

WINBTL EQU  23               * Lower row of viewing window
WINWTH EQU  40               * Window width
SCRWTH EQU  40               * Screen width
WINLNS EQU  12               * Window lines
WINLBR EQU  0                * Left border
WINTL  EQU  11               * Window top line

SCRBUF BSS  WINWTH           * Scroll buffer

LOCBUF EQU  >E000            * Local buffer
FRMLNG DATA 0

H2000  DATA >2000

VREG   DATA >0000,>0170,>0200,>030E     * Video registers for text mode
       DATA >0401,>0506,>0600,>07B1

IPVER  DATA >0400                       * IP version 4
PROT   DATA >0100,ICMP,ICMPT            * Valid protocols
       DATA >0600,TCP,TCPT,>1100,UDP,UDPT,0

SRCIP  BYTE >00,>00,>00,>00             * Source IP address
DSTIP  BYTE >00,>00,>00,>00             * Destination IP address

TITEL  TEXT 'Test program for the SLIP0 driver'

IPVERR TEXT '** Wrong IP version.'
       BYTE >00

CSERR  TEXT '** Invalid IP checksum.'
       BYTE >00

PRERR  TEXT '** Protocol not implemented.'
       BYTE >00

ICMPT  TEXT 'ICMP message'
       BYTE >00

TCPT   TEXT 'TCP message'
       BYTE >00

UDPT   TEXT 'UDP message'
       BYTE >00

* Main program loop

MAIN   LIMI 0

** Set video registers

       LI   R1,VREG
       LI   R2,8
SETVR  MOV  *R1+,R0
       BLWP @VWTR
       DEC  R2
       JNE  SETVR

** Clear screen

       LI   R0,>0040
       MOVB R0,@>8C02
       SWPB R0
       MOVB R0,@>8C02
       LI   R2,960
CLR    MOVB @H2000,@>8C00
       DEC  R2
       JNE  CLR

       LI   R1,VREG
       MOVB @>0003(R1),@>83D4

** Display title

       LI   R0,123
       LI   R1,TITEL
       LI   R2,33
       BLWP @VMBW

** Initialize SLIP driver

       BLWP @SLINIT
       JNE  MAINLP
       BLWP @>0000          Error occured, exit.

** Main loop

MAINLP LIMI 2
       BLWP @SL0CHK         Check for new data
       CLR  R2
       LI   R1,LOCBUF
       BLWP @SL0DQ          Try to dequeue a frame
       MOV  R2,R2
       JEQ  MAINLP
       MOV  R2,@FRMLNG

** There is a new frame
** Assumption: There was no fragmentation, so we don't need
** reassembly. In the next version of the IP driver, that will
** be included.

       MOVB *R1,R0
       SRL  R0,4
       CB   R0,@IPVER       Check the IP version
       JEQ  IPV4
       LI   R8,IPVERR
       JMP  ERROR

** Fine, it's IPv4

IPV4   LI   R2,20
       BLWP @CHKS1C
       MOV  R3,R3           Calculate the checksum
       JEQ  CHKSOK
       LI   R8,CSERR
       JMP  ERROR

** Checksum is OK

CHKSOK MOV  R1,R0
       AI   R0,12               Source IP address in frame
       LI   R3,SRCIP
       MOV  *R0+,*R3+           Copy source and destination address
       MOV  *R0+,*R3+
       MOV  *R0+,*R3+
       MOV  *R0,*R3

** Check the protocol

       LI   R3,PROT
FPR    MOV  *R3+,R0
       JNE  PROK
       LI   R8,PRERR
       JMP  ERROR
PROK   MOV  *R3+,R4
       MOV  *R3+,R8
       CB   R0,@>0009(R1)
       JNE  FPR

       MOV  @FRMLNG,R2

** We found the protocol. Now let's invoke the appropriate handler.
** These handlers are implemented in the PROT file
** R1 points to the frame, R2 is the length of the frame

       BLWP *R4

** Error/protocol output (R8 points to null-terminated string)

ERROR  LI   R0,WINBTL*SCRWTH+WINLBR
       ORI  R0,>4000
       SWPB R0
       LIMI 0
       MOVB R0,@>8C02
       SWPB R0
       MOVB R0,@>8C02
       NOP
       MOVB *R8+,@>8C00
       JNE  $-4
       BL   @SCROLL             Scroll the lines in the window
       JMP  MAINLP              End of main loop

* Scrolling routine
* Just straight-forward: Copy one line, write it back one row higher
* Take care of the output window!
* (No further comments; does not belong to the 'core')

SCROLL LI   R0,WINTL*SCRWTH
       LI   R1,SCRBUF
       LI   R2,WINWTH
SCRLP  AI   R0,2*SCRWTH
       LIMI 0
       BLWP @VMBR
       AI   R0,-SCRWTH
       BLWP @VMBW
       LIMI 2
       CI   R0,WINBTL*SCRWTH
       JNE  SCRLP
       ORI  R0,>4000
       SWPB R0
       LIMI 0
       MOVB R0,@>8C02
       SWPB R0
       MOVB R0,@>8C02
       LI   R2,WINWTH
SCRCL  MOVB @H2000,@>8C00
       DEC  R2
       JNE  SCRCL
       LIMI 2
       RT

* Calculation of the one's complement sum
* Pointer in R1, length in R2
* Result in R3
* R3 = 0 <=> Checksum valid
*
* Important: Routine must be *very* fast

CHKS1C DATA CHKWS,CHKST
CHKWS  BSS  32

CHKST  MOV  @>0002(R13),R1
       MOV  @>0004(R13),R2

* Little trick to cope with the case of an odd number of bytes: reduce
* the length by one at the beginning, then check if a byte is left after
* the loop

       MOV  R2,R4
       DEC  R2
       CLR  R3
CHKL   A    *R1+,R3
       JNC  $+4
       INC  R3              1's complement addition says that
       DECT R2              the carry must be added to the LSB
       JGT  CHKL

       SRL  R4,1            Now for the special case
       JNC  CHKE
       CLR  R2
       MOVB *R1,R2          Low byte is null
       A    R2,R3
       JNC  $+4
       INC  R3

* Now a very nice feature of the one's complement sum. If we don't
* check the sum, but we want to calculate it, then we set the checksum
* field to 0000 in the checksummed string. If we then insert the
* inverted value into this field, the next check will yield exactly 0.

CHKE   INV  R3
       MOV  R3,@>0006(R13)

       RTWP

       END
