DECLARE SUB GetVirtualZero (FileNum%, d$)
DECLARE SUB GetVirtualSect (FileNum%, Sektor%, d$)
DECLARE SUB ShortName (A$)
DECLARE SUB Fischio ()
DECLARE SUB ERRSOUND ()
DECLARE SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
DECLARE SUB ShowHex (A$, K$)
DECLARE FUNCTION CalcWord% (A$, P%)
DECLARE SUB box (Y%, X%, W%, H%)
' TI-99/4A Directory listing and Transfer File of a TI disk image file
' (obtained from TI99-PC.COM and saved as normal file on a PC)
' - Paolo Bagnaresi, May 2000 - e-mail: paolo_bagnaresi@libero.it
'
' This module can be Launched with a CHAIN qbasic instruction by a different qbasic program.
' Just add the same COMMON arrays to your launcher. (DIM Vector, MyName$, MyVal and the 3 corresponding COMMON Shared declarations).
' These arrays are used only as a parameter passing between chained qbasic programs.

' TI-Dir has the return program name stored in MyName$(11).  MyName$(11) is devoted exclusively to TI-Dir usage. 
' TI-Dir has the Disk image filename on which it will work upon stored in MyName$(12).  MyName$(11) is devoted exclusively to TI-Dir usage. 


DECLARE FUNCTION Shrink$ (In$)
DIM Vector(0 TO 10)      AS INTEGER
DIM MyName$(0 TO 30)
DIM MyVal(0 TO 10)      AS INTEGER

COMMON SHARED Vector() AS INTEGER
COMMON SHARED MyName$()
COMMON SHARED MyVal() AS INTEGER

DIM SHARED FC AS INTEGER
DIM SHARED BC AS INTEGER
DIM SHARED HFC AS INTEGER
DIM SHARED HBC AS INTEGER

FileNum% = 58   ' 1
NormForeColor = 10' Normal Foreground Color
NormBackColor = 0 ' Normal Background Color
FC = NormForeColor
BC = NormBackColor
HFC = 15          ' Higlighted Foreground Color
HBC = 10          ' Higlighted Background Color
DEFINT A-Z
DEFINT A-Z
' F1 help file. Record structure definition
		TYPE IDXType
		Section AS STRING * 20
		StartRec AS DOUBLE
		RecLength AS SINGLE
		END TYPE
		DIM SHARED IDXRecord AS IDXType
		TempArk$ = "~ARKTMP.TMP"
		
		DIM SHARED Gap1%            ' Start of track Gap
		DIM SHARED PreIDGap%           '
		DIM SHARED PreDatGap%
		DIM SHARED SLength%
		DIM SHARED TrkLen#
		DIM SHARED TrackSing(1) AS STRING * 3253
		DIM SHARED TrackDoub(1) AS STRING * 6872
		DIM SHARED V9T9Sekt(1) AS STRING * 256
		DIM SHARED OldTrack#
		DIM SHARED OldDskSide#
		DIM SHARED SideLen#

		DIM SHARED SekTrack%
		DIM SHARED FType$
		
		CLS
		COLOR FC, BC
		
		SourcePath$ = MyName$(12)
		IF SourcePath$ = "" THEN SourcePath$ = "C:\TEMP\9640NEWS.HD" ' "C:\PC99\DSK\T1.DSK"
		'DestinPath$ = MyName$(3)
		'PRINT  "SourcePath$=";  SourcePath$ ;"  - DestinPath$= " ;DestinPath$
		'INPUT "",c$
		
		REDIM FilName$(1)
		FOR T = LEN(DestinPath$) TO 1 STEP -1
		IF MID$(DestinPath$, T, 1) = "\" THEN GOTO BackFound
		NEXT T
		Path$ = DestinPath$
		GOTO BackFound2
BackFound:
		Path$ = LEFT$(DestinPath$, T)
BackFound2:
		GOTO OpenFile

' Exit point with F9
Abort:           'MyName$(12) = ""
		GOTO LeaveIt2

Leaveit:         'MyName$(12) = SourcePath$
LeaveIt2:        ERASE FilName$
		CLOSE #FileNum%
		COLOR 7, 0
		IF MyName$(11) = "" THEN CLS : SYSTEM  ELSE CHAIN MyName$(11)

OpenFile:      
		CALL ShortName(SourcePath$)
		ON ERROR GOTO FileNotFound
		SrcDOSName$=SourcePath$
		OPEN SrcDOSName$ FOR INPUT ACCESS READ AS #FileNum%   ' Avoid creation of file is file doesn't exist
		CLOSE #FileNum%
		'OPEN SourcePath$ FOR INPUT ACCESS READ AS #1   ' Avoid creation of file is file doesn't exist
		'CLOSE #1
		OPEN SrcDOSName$ FOR BINARY ACCESS READ AS #FileNum%
		LEN1# = LOF(FileNum%)
		'OPEN SourcePath$ FOR RANDOM ACCESS READ AS #1 LEN = 256
		ON ERROR GOTO 0
		
		CALL GetVirtualZero(FileNum%, d$)
		' FIELD #1, 256 AS d
		
		'GET #1, 1              ' Get Sector Zero
		DskName$ = MID$(d$, 1, 10)
		IF MID$(d$, 14, 3) = "DSK" THEN GOTO IdentFound

		
		PRINT TAB(10); "ͻ"
		PRINT TAB(10); " TI-99/4A DiskName:                                           "
		PRINT TAB(10); "                                                              "
		PRINT TAB(10); " Warning....                                                  "
		PRINT TAB(10); " This file doesn't appear to be a true TI99-PC image file     "
		PRINT TAB(10); " ('DSK' missing in sector 0).                                 "
		PRINT TAB(10); "                                                              "
		PRINT TAB(10); " Do you still want to go on? (Y/N)                            "
		PRINT TAB(10); "                                                              "
		PRINT TAB(10); "ͼ"
		LOCATE 2, 32, 1
		PRINT DskName$;
		LOCATE 8, 47, 1
		DO: C$ = INKEY$: LOOP UNTIL C$ <> ""
		IF UCASE$(C$) = "Y" THEN GOTO IdentFound ELSE GOTO Abort
		
FileNotFound:
		CALL box(1, 10, 66, 10)
		LOCATE 2, 12
		PRINT "TI-99/4A Disk Image Filename:"; SourcePath$
		LOCATE 4, 12
		PRINT "Error. The above filename doesn't exist"
		LOCATE 5, 12
		PRINT "Please correct and try again"
		LOCATE 7, 22
		PRINT "Press any key"
		BEEP
SomeMore:        DO: U$ = INKEY$: LOOP UNTIL U$ <> ""
		GOTO Abort
		
		
		
IdentFound:
		TotSect% = CalcWord(d$, 11)
		Tracks% = ASC(MID$(d$, 18, 1))
		Sides% = ASC(MID$(d$, 19, 1)): IF Sides% = 0 THEN Sides% = 1
		Dens% = ASC(MID$(d$, 20, 1)): IF Dens% = 0 THEN Dens% = 1
		
		SELECT CASE LEFT$(FType$,1)
		CASE "V"
		DiskType$="V9T9 or TI99-PC"
		CASE "P"
		DiskType$ ="PC99"
		CASE ELSE
		DiskType$="TI99-PC"
		END SELECT
		
		SideDensity$ = "(" + MID$("SD", Sides%, 1) + "S/" + MID$("SDH", Dens%, 1) + "D)"
		IF Tracks = 80 AND Dens% = 2 THEN MID$(SideDensity$, 5, 1) = "Q"
		
		CurrFileDescrIndex% = 1                        ' Sector containing the File Descriptor Index
		IF Tracks < 80 THEN GOTO NoSubDirExist           ' Only 80 track Geneve disks can have sudirectories
		ChosenDir% = 1                                 ' Array element that is the Chosen Directory
		ActiveDirs% = 0
		FOR T = 1 TO 3
		W = CalcWord(d$, 31 + (12 * (T - 1)))
		IF W = 0 THEN GOTO NextSubDir
		IF T = 1 THEN SubDirStAddr%(1) = 1: SubDirName$(1) = "Root_Dir": ActiveDirs% = ActiveDirs% + 1
		ActiveDirs% = ActiveDirs% + 1
		SubDirStAddr%(ActiveDirs%) = W: SubDirName$(ActiveDirs%) = MID$(d$, 21 + (12 * (T - 1)), 10)
NextSubDir:      NEXT T

NoSubDirExist:
		ErrSect$ = ""
		IF LEFT$(FType$,1) <>"V" THEN GOTO  NoSubDirPoss
		CALL GetVirtualSect(FileNum%, TotSect% + 1, d$)
		'GET #1, TotSect% + 1   ' Get 1st of the 2 last sectors beyond end of TI disk: Additional Bad Sector Table
		ErrSect$ = d$
		CALL GetVirtualSect(FileNum%, TotSect% + 2, d$)
		'GET #1, TotSect% + 2   ' Get 2nd of the 2 last sectors beyond end of TI disk: Additional Bad Sector Table
		ErrSect$ = ErrSect$ + d$
		CALL GetVirtualSect(FileNum%, TotSect% + 3, d$)
		'GET #1, TotSect% + 3   ' Get 3rd of the 2 last sectors beyond end of TI disk: Additional Bad Sector Table
		ErrSect$ = ErrSect$ + d$
		TotEr% = VAL(MID$(ErrSect$, 13, 8))
NoSubDirPoss:
		FirstDestinPath$ = DestinPath$ ' New Output Filename (just the name, nothing on disk!)
NewSubDir:
		CALL GetVirtualSect(FileNum%, CurrFileDescrIndex% + 1, d$)
		'GET #1, CurrFileDescrIndex% + 1            ' Get Sector 1: Filename Table, alphabetically ordered
		
		TFNames% = 1           ' We have to work out how many filenames there are
NextEl:          sn% = CalcWord(d$, (TFNames%) * 2 - 1)
		IF sn% <> 0 THEN TFNames% = TFNames% + 1: GOTO NextEl
		TFNames% = TFNames% - 1 + ActiveDirs%  ' Well this is how many filenames we've got
		
		REDIM FilName$(TFNames%)   ' DIM exactly our arrays
		REDIM StartSect%(TFNames%)
		REDIM CopyMark$(TFNames%)
		REDIM FileErrList$(TFNames%)

		FOR T = 1 TO TFNames%    ' Assume users doesn't want to Extract any file
		CopyMark$(T) = " "
		IF ActiveDirs% > 0 AND T = ChosenDir% THEN CopyMark$(T) = ">"
		NEXT T
		
		FOR T = 1 TO ActiveDirs%    ' If Active Directories exist
		FilName$(T) = SubDirName$(T)
		StartSect%(T) = SubDirStAddr%(T)
		NEXT T
		
		FOR T = ActiveDirs% + 1 TO TFNames% ' Memorize Starting Sector of all filenames
		StartSect%(T) = CalcWord(d$, (T - ActiveDirs%) * 2 - 1)
		NEXT T
		
		TotSectorFiles# = 0
		' Get all Filenames with vital parameters
		FOR T% = ActiveDirs% + 1 TO TFNames%
		CALL GetVirtualSect(FileNum%, StartSect%(T%) + 1, d$)
		'GET #1, StartSect%(T%) + 1
		FilName$(T%) = MID$(d$, 1, 20)
		
		
		TotSectorFiles# = TotSectorFiles# + CalcWord(FilName$(T%), 15)
		NEXT T%
		
		' CALL ShowHex(ErrSect$)
		' Work out which file has error, if any
		IF TotEr% = 0 THEN GOTO NoBadSector
		FOR J = 0 TO (TotSect% / 8) - 1
		T$ = MID$(ErrSect$, 33 + J, 1)
		IF ASC(T$) = 0 THEN GOTO NextByte
		FOR W = 0 TO 7
		IF ASC(T$) AND 2 ^ W THEN K = J * 8 + W: GOSUB WorkOutWhichFile
		NEXT W
NextByte:        NEXT J
		
NoBadSector:
		' Prepare to show all filenames
		
		CurrentScreenRow% = 1
		TotalScreenRows% = 13     ' Rows to display Filenames
		StartRow% = 7  ' Screen Start Row
		CurrentFilename% = 1
		TotFiles2Copy% = 0
		TotSizeFiles2Copy# = 0                         ' Added on August 27, 2003 from a tip of Ben Yates. Thank you, Ben!
		AllowedKey$ = CHR$(27)                         ' ESC
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(72) ' Arrow Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(80) ' Arrow Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(73) ' Page Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(81) ' Page Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(83) ' Del
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(71) ' Home
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(79) ' End
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(59) ' F1 = Help
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(61) ' F3 = Show Bad Sector
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(65) ' F7 = Show Bad Sector
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(66) ' F8 = Show ARK file directory, if applicable
		AllowedKey$ = AllowedKey$ + CHR$(21)           ' CTRL U = Unmark All
		AllowedKey$ = AllowedKey$ + CHR$(1)            ' CTRL A = Copy All
		AllowedKey$ = AllowedKey$ + CHR$(3)            ' CTRL C
		AllowedKey$ = AllowedKey$ + CHR$(13)           ' Enter = Execute
		AllowedKey$ = AllowedKey$ + "CcMm1234567890 "            ' CcMmXx + Blank +1234567890
		
		GOSUB TopScreen ' Display Top Part of Title Screen
		'GOSUB DispMem
		IF TFNames% = 0 THEN GOSUB AbsNoFiles: GOTO Leaveit

'===================================
' DISK CATALOG MAIN LOOP STARTS HERE
'===================================

NextFileName:
		COLOR FC, BC
		
		IF CurrentScreenRow% = 1 THEN FirstFilename% = CurrentFilename%   ' Get Number of first filename only
		GOSUB DisplayRow  ' Display Current Row

		CurrentFilename% = CurrentFilename% + 1 ' Next Filename


		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		CurrentScreenRow% = CurrentScreenRow% + 1  ' Next Screen Row
		IF CurrentScreenRow% < TotalScreenRows% + 1 AND CurrentFilename% <= TFNames% THEN GOTO NextFileName

'===================================
' DISK CATALOG MAIN LOOP ENDS HERE
'===================================
'
' End of filenames
		GOSUB BottomLine       ' Display Bottom Line
		LastFilename% = CurrentFilename% - 1' Get Number of Last used filename
		CurrentFilename% = FirstFilename%  ' Current filename is now first filename in screen

		CurrentScreenRow% = 1
		IF KeepCursBottom% = 0 THEN GOTO LocateCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last filename in Screen
		CurrentScreenRow% = TotalScreenRows%: KeepCursBottom% = 0: CurrentFilename% = LastFilename%
		GOTO LocateCursor2
		
LocateCursor:
		GOSUB RestoreColor

LocateCursor2:
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR HFC, HBC: GOSUB DisplayRow: COLOR FC, BC' Display Current Row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		OldScreenRow% = CurrentScreenRow%
		OldFilename% = CurrentFilename%
		IF GoToThisDir% <> 0 THEN CurrentFilename% = GoToThisDir%: GoToThisDir% = 0: GOTO Executit
		'GOSUB ShowValues    ' My little Debugger
		
DoitAgain:       DO: U$ = INKEY$: LOOP UNTIL U$ <> ""
		IF INSTR(AllowedKey$, U$) = 0 THEN GOTO DoitAgain

		' ESCape Key
		IF U$ = CHR$(27) THEN GOTO Abort
		' ENTER Key
		IF U$ <> CHR$(13) THEN GOTO IsArrowDown
		IF TotEr% > 0 AND FileErrList$(CurrentFilename%) <> "" THEN GOTO OtherKey9B
		IF CurrentFilename% > ActiveDirs% THEN GOTO StartCopying
		IF CurrentFilename% = ChosenDir% THEN GOTO StartCopying
		IF TotFiles2Copy% = 0 THEN GOTO ChangeDir
		'GOSUB GiveUpCopying: IF K$ <> "Y" THEN GOTO ReDraw
ChangeDir:       ChosenDir% = CurrentFilename%
		GoToThisDir% = CurrentFilename%
		CurrFileDescrIndex% = SubDirStAddr%(CurrentFilename%)
		CALL Fischio
		GOTO NewSubDir

IsArrowDown:     ' Arrow Down Key
		IF U$ <> CHR$(0) + CHR$(80) THEN GOTO OtherKey0
IsArrowDown1:    IF CurrentScreenRow% < LastScreenRow% THEN CurrentScreenRow% = CurrentScreenRow% + 1: CurrentFilename% = CurrentFilename% + 1: GOTO LocateCursor
		IF CurrentFilename% = TFNames% THEN GOTO LocateCursor
		CurrentFilename% = FirstFilename% + 1
		KeepCursBottom% = 1
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey0:         'Arrow up Key
		IF U$ <> CHR$(0) + CHR$(72) THEN GOTO OtherKey1
		IF CurrentFilename% = 1 THEN GOTO NoMatch
		IF CurrentScreenRow% > 1 THEN CurrentScreenRow% = CurrentScreenRow% - 1: CurrentFilename% = CurrentFilename% - 1: GOTO LocateCursor
		CurrentFilename% = FirstFilename% - 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey1:         ' Page Up Key
		IF U$ <> CHR$(0) + CHR$(73) THEN GOTO OtherKey2
		CurrentFilename% = FirstFilename% - TotalScreenRows%
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey2:         ' Page Down Key
		IF U$ <> CHR$(0) + CHR$(81) THEN GOTO OtherKey4
		IF LastFilename% + 1 + TotalScreenRows% > TFNames% THEN CurrentFilename% = TFNames% - TotalScreenRows% + 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1: GOTO Executit
		CurrentFilename% = FirstFilename% + TotalScreenRows%
		IF CurrentFilename% > TFNames% THEN CurrentFilename% = FirstFilename%
		GOTO Executit

OtherKey4:       ' C or c, M or m
		IF U$ <> "c" AND U$ <> "C" AND U$ <> "M" AND U$ <> "m" THEN GOTO OtherKey5
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# + SectorLength#
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR HFC, HBC
		CopyMark$(CurrentFilename%) = "C": PRINT "C";
		GOSUB DispFilestoCopy
		GOTO IsArrowDown1
		
OtherKey5:       ' CTRL U = Unmark all
		IF U$ <> CHR$(21) THEN GOTO OtherKey6
		FOR T = ActiveDirs% + 1 TO TFNames%  ' Assume users wants to Copy all files
		CopyMark$(T) = " "
		NEXT T

		TotFiles2Copy% = 0
		TotSizeFiles2Copy# = 0
		GOSUB RePaintScreen
		GOTO NoMatch

OtherKey6:       ' CTRL A = Mark all
		IF U$ <> CHR$(1) AND U$ <> CHR$(3) THEN GOTO OtherKey7
		FOR T = ActiveDirs% + 1 TO TFNames%  ' Assume users wants to Copy all files
		IF CopyMark$(T) = " " THEN CopyMark$(T) = "C"
		NEXT T
		
		TotFiles2Copy% = TFNames%
		TotSizeFiles2Copy# = TotSectorFiles#
		GOSUB RePaintScreen
		GOTO NoMatch
		
OtherKey7:         ' Home Key : simply move cursor to top
		IF U$ <> CHR$(0) + CHR$(71) THEN GOTO OtherKey8
		CurrentScreenRow% = 1: CurrentFilename% = FirstFilename%: GOTO LocateCursor


OtherKey8:         ' End Key : simply move cursor to bottom
		IF U$ <> CHR$(0) + CHR$(79) THEN GOTO OtherKey9
		CurrentScreenRow% = LastScreenRow%: CurrentFilename% = LastFilename%
		GOTO LocateCursor

OtherKey9:        ' F3 = Show Error List
		IF U$ <> CHR$(0) + CHR$(61) THEN GOTO OtherKey10
		IF TotEr% = 0 OR FileErrList$(CurrentFilename%) = "" THEN GOTO NoMatch
OtherKey9B:      GOSUB ShowErrorList
		GOSUB RePaintScreen
		GOTO NoMatch
		
		

OtherKey10:      ' F7 = Show Sector as Hex
		IF U$ <> CHR$(0) + CHR$(65) THEN GOTO OtherKey11
		IF CurrentFilename% <= ActiveDirs% THEN GOTO NoMatch
		GOSUB ShowSector
		GOSUB RePaintScreen
		GOTO NoMatch

OtherKey11:     ' 0-9 priority while copying
		IF U$ < "0" OR U$ > "9" THEN GOTO OtherKey12
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# + SectorLength#
		CopyMark$(CurrentFilename%) = U$
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR HFC, HBC
		PRINT CopyMark$(CurrentFilename%);
		GOSUB DispFilestoCopy
		GOTO IsArrowDown1
		
		
OtherKey12:     ' DEL key
		IF U$ <> " " AND U$ <> CHR$(0) + CHR$(83) THEN GOTO OtherKey13
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) <> " " THEN TotFiles2Copy% = TotFiles2Copy% - 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# - SectorLength#
		CopyMark$(CurrentFilename%) = " "
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR HFC, HBC
		PRINT CopyMark$(CurrentFilename%);
		GOSUB DispFilestoCopy
		GOTO IsArrowDown1
'========SHOW ARK FILE
OtherKey13:      IF U$ <> CHR$(0) + CHR$(66) THEN GOTO OtherKey14     ' F8 = I ARK file, display it
		IF CurrentFilename% <= ActiveDirs% THEN GOTO NoMatch
		
		IF ASC(MID$(FilName$(CurrentFilename%), 18, 1)) <> 128 THEN GOTO NoMatch
		FileType% = ASC(MID$(FilName$(CurrentFilename%), 13, 1))
		FileType% = FileType% AND &H8B
		FileType% = FileType% AND &HF7
		SELECT CASE FileType%
		CASE 0, 2 ' "Dis/Fix"
		GOSUB ARKextract
		CLS
		COLOR HFC, HBC
		
		PRINT TAB(15); "Catalog of Archive File: "; MID$(FilName$(CurrentFilename%), 1, 10)
		Exec$ = "Decomp4.com " + TempArk$ + " /s"
		SHELL Exec$
		COLOR FC, BC
		CLS
		END SELECT
		
		GOSUB RePaintScreen
		GOTO NoMatch
		
		
		
OtherKey14:     ' F1 (Help) key
		IF U$ <> CHR$(0) + CHR$(59) THEN GOTO OtherKey15
		CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "17.04.00")
		GOSUB RePaintScreen
		GOTO LocateCursor


OtherKey15:
		GOTO NoMatch
		
Redraw:          CurrentFilename% = FirstFilename%
Executit:
		CurrentScreenRow% = 1     ' Cursor on first screen row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		GOTO NextFileName   ' Start next round

StartCopying:
NoMatch:         GOTO LocateCursor

		'=================================
' DISPLAY TOP PART OF TITLE SCREEN
'=================================
TopScreen:
		LOCATE 1, 3, 1
		PRINT "TI DISK CATALOG FROM F5 KEY - NO SELECTION, NO ACTION, JUST TO VIEW FILE NAMES"
		LOCATE 2, 1
		PRINT "TI-99/4A DiskName:"; DskName$; "    Sectors:"; TotSect%; " Tracks:"; Tracks%; " Sides:"; Sides%; " Dens:"; Dens%;
		LOCATE 3, 1
		PRINT "PC Source File= "; SourcePath$;
		PRINT TAB(60); "Files="; TFNames%;
		PRINT TAB(71); SideDensity$
		LOCATE 4, 1
		
		PRINT "Disk Image File type = ";DiskType$;TAB(60); "Used:"; TAB(71); "Bad:"; TotEr%
		LOCATE 4, 65
		PRINT TotSectorFiles#
		LOCATE 5, 1
		PRINT "Ŀ"
		PRINT "  n. Filename  P TSect Length  Type           Select:      Sectors:        "
		PRINT "Ĵ"
		GOSUB DispFilestoCopy
		IF TotEr% = 0 THEN GOTO IfSomeFileName
		LOCATE 6, 51
		PRINT "- Bad Sectors Full List = F3";
		
IfSomeFileName:   
		LOCATE 23, 1
		'PRINT "Enter=Execute. C,M=Select, CTRL A=Select All, CTRL U=UnSel.All, 0=Served first,"
		PRINT "ESC=Exit, Cursor=ArrUp,Dwn,PagUp,Dwn. F1=Help. F7= File Hex Sector Viewer."
		LOCATE 24, 1
		'PRINT "1-9=Next to be served, C=Last to be served. Cursor=ArrUp,Dwn,PagUp,Dwn. "

		PRINT TAB(30); "F8= Cat ARK File.";
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRow:
		LOCATE StartRow% + CurrentScreenRow%, 1, 1
		'PRINT "                                                                              "
		PRINT ""; CopyMark$(CurrentFilename%); "";
		PRINT USING "###"; CurrentFilename%;
		PRINT ""; MID$(FilName$(CurrentFilename%), 1, 10);
		
		IF CurrentFilename% > ActiveDirs% THEN GOTO NoSubDirs
		IF CurrentFilename% = ChosenDir% THEN PRINT TAB(19); "< Active Dir >";
		PRINT TAB(34); ".. <Dir>.."; TAB(49); "";
		GOTO NoErrSectInFile
NoSubDirs:

		FileType% = ASC(MID$(FilName$(CurrentFilename%), 13, 1))
		FileType% = FileType% AND &H8B         ' Get rid of reserved bits: 2,4-6
		IF FileType% AND 8 THEN FileProt$ = "P" ELSE FileProt$ = "_"
		FileType% = FileType% AND 247

		SELECT CASE FileType%
		CASE 0
		FileType$ = "Dis/Fix"
		CASE 1
		FileType$ = "Program"
		CASE 2
		FileType$ = "Int/Fix"
		CASE 128
		FileType$ = "Dis/Var"
		CASE 130
		FileType$ = "Int/Var"
		CASE ELSE
		FileType$ = "unknown"
		END SELECT


		SectorLength# = CalcWord(FilName$(CurrentFilename%), 15) + 1
		EOFOffset% = ASC(MID$(FilName$(CurrentFilename%), 17, 1))
		FileLength# = SectorLength# - 1
		FileLength# = FileLength# * 256
		IF FileType% < 128 THEN FileLength# = FileLength# - 256 + EOFOffset%
		LogRecLength% = ASC(MID$(FilName$(CurrentFilename%), 18, 1))

		' PRINT EOFOffset%;
		PRINT " "; FileProt$;
		PRINT USING "####"; SectorLength#;
		PRINT USING "#########"; FileLength#;
		PRINT " "; FileType$;
		IF LogRecLength% > 0 THEN PRINT USING "####"; LogRecLength%;

		LOCATE StartRow% + CurrentScreenRow%, , 1
		PRINT TAB(49); "";
BadSectorList:
		IF FileErrList$(CurrentFilename%) = "" THEN GOTO NoErrSectInFile
		

		PRINT TAB(50); "Err=";
		FOR J = 1 TO LEN(FileErrList$(CurrentFilename%)) STEP 2
		IF J > 8 THEN PRINT ",..."; : GOTO NoErrSectInFile
		K = CalcWord(FileErrList$(CurrentFilename%), J)
		IF J > 1 THEN PRINT ",";
		PRINT RTRIM$(LTRIM$(STR$(K)));
		NEXT J
		
NoErrSectInFile:        
		
		PRINT TAB(80); "";
		RETURN
'====================
' DISPLAY BOTTOM LINE
'====================         
BottomLine:   
		PRINT
		PRINT ""
		
		LOCATE StartRow% + CurrentScreenRow% + 1, 1, 1

		IF CurrentScreenRow% > TotalScreenRows% THEN GOTO SkipClear ' Blank all unused screen rows, if any

		FOR V = CurrentScreenRow% TO TotalScreenRows%
		PRINT "                                                                                "
		NEXT V
SkipClear:
		RETURN

'=========================
' REDRAW THE ENTIRE SCREEN
'=========================
RePaintScreen:

		GOSUB TopScreen ' Display Top Part of Title Screen
		SaveCurrFilename% = CurrentFilename%
		SavCurrScreenRow% = CurrentScreenRow%
		CurrentFilename% = FirstFilename%
		FOR CurrentScreenRow% = 1 TO TotalScreenRows%
		GOSUB DisplayRow  ' Display Current Row
		CurrentFilename% = CurrentFilename% + 1 ' Next Filename
		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		IF CurrentFilename% > TFNames% THEN CurrentScreenRow% = CurrentScreenRow% + 1: GOTO RePaintScreen2
		NEXT CurrentScreenRow%   ' Next Screen Row
RePaintScreen2:              
		GOSUB BottomLine        ' Display Bottom Line
		CurrentFilename% = SaveCurrFilename%
		CurrentScreenRow% = SavCurrScreenRow%
		RETURN


RestoreColor:    TempScreenRow% = CurrentScreenRow%
		TempFilename% = CurrentFilename%
		CurrentScreenRow% = OldScreenRow%
		CurrentFilename% = OldFilename%
		COLOR FC, BC: GOSUB DisplayRow' Display Current Row
		CurrentScreenRow% = TempScreenRow%
		CurrentFilename% = TempFilename%
		RETURN


DispFilestoCopy: ' Display total files to be copied
		'LOCATE 4, 72, 1
		'PRINT TotFiles2Copy%; "  ";
		RETURN


'=====================================
' Work out which file has a bad sector
' ====================================     
WorkOutWhichFile:
		'INPUT "Each File", C$
		FOR FileToCopy% = 1 TO TFNames%
		CALL GetVirtualSect(FileNum%, StartSect%(FileToCopy%) + 1, d$)
		'GET #1, StartSect%(FileToCopy%) + 1
		FHeader$ = d$
		SectorCnt% = CalcWord(FHeader$, 15)
		OldOffs% = 0
		Z = 0
		
NextChain:
		GOSUB CalcClusters
		CurrOffs% = Offs% - OldOffs%
		IF StSec% = 0 THEN GOTO WorkOutNext
		'PRINT "A="; HEX$(a); a
		'PRINT "B="; HEX$(B); B
		'PRINT "C="; HEX$(c); c
		'PRINT "Start Sector="; StSec%;" >";HEX$(StSec%)
		'PRINT "Offset="; Offs%;" >";HEX$(Offs%)
		'INPUT "", c$
		IF K >= StSec% AND K <= StSec% + CurrOffs% THEN GOSUB MarkErrFile: GOTO WorkOutEnd
		OldOffs% = Offs%
		Z = Z + 3: GOTO NextChain
WorkOutNext: 
		NEXT FileToCopy%
WorkOutEnd: 
		RETURN

AbsNoFiles:
		PRINT ""
		A = 10
		CALL box(A, 18, 50, 8)
		LOCATE A + 2, 24: PRINT "THIS DISK, "; SourcePath$; " IS EMPTY. "
		LOCATE A + 3, 24: PRINT ""
		LOCATE A + 4, 30: PRINT "No files have been found."
		LOCATE A + 5, 32: PRINT "Press any key to exit"

		WHILE INKEY$ = "": WEND
		RETURN

SectorLength:    ' Calculate file length, in sectors
		SectorLength# = CalcWord(FilName$(CurrentFilename%), 15) + 1
		RETURN

ShowErrorList:
		CALL box(8, 20, 50, 13)
		LOCATE 9, 30: PRINT "Bad Sector List, File:"; MID$(FilName$(CurrentFilename%), 1, 10)
		LOCATE 11 + W, 22: PRINT ""
		W = 0: A = 0
		LOCATE 11 + W, 22
		
		FOR J = 1 TO LEN(FileErrList$(CurrentFilename%)) STEP 2
		IF W > 8 THEN PRINT "..."; : GOTO ShowErrorList2
		K = CalcWord(FileErrList$(CurrentFilename%), J)
		IF A > 0 THEN PRINT ",";
		PRINT RTRIM$(LTRIM$(STR$(K)));
		A = A + 1
		IF A > 8 THEN A = 0: W = W + 1: LOCATE 11 + W, 22
		NEXT J
ShowErrorList2:    
		WHILE INKEY$ = "": WEND
		
NoShowErrorList:         
		RETURN
'========SHOW SECTORS - ADD START            
ShowSector:      CALL box(8, 3, 76, 13)
		LOCATE 8, 30: COLOR HFC, HBC: PRINT " - HEX SECTOR VIEWER - "; : COLOR FC, BC
		CALL GetVirtualSect(FileNum%, StartSect%(CurrentFilename%) + 1, d$)
		'GET #1, StartSect%(CurrentFilename%) + 1
		FHeader$ = d$
		LOCATE 9, 5:  PRINT "File: "; MID$(FHeader$, 1, 10); "-Length:"; CalcWord(FHeader$, 15);
		SectorCnt% = CalcWord(FHeader$, 15)
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		Z = 0                      ' Offset in Input File Chain Pointer Block
		K$ = "Y"
ShowSector2:
		GOSUB CalcClusters
		IF StSec% > 0 THEN GOTO ShowSector3
		LOCATE 19, 30: PRINT " = End of File =";
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		IF K$ = CHR$(27) THEN GOTO ShowSectorEnd
		
ShowSector3:
		IF GlobalInpOffset% > Offs% THEN Z = Z + 3: GOTO ShowSector2
		CALL GetVirtualSect(FileNum%, StSec% + OffsVal% + 1, d$)
		'GET #1, StSec% + OffsVal% + 1

		LOCATE 9, 35: PRINT " -This Skt: "; StSec% + OffsVal%; " >"; HEX$(StSec% + OffsVal%); " - Skt Off.:"; GlobalInpOffset%;

		CALL ShowHex(d$, K$)
		IF K$ = CHR$(27) THEN GOTO ShowSectorEnd
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO ShowSector4
		IF GlobalInpOffset% > 0 THEN K$ = ""
		IF GlobalInpOffset% = 0 THEN GOTO ShowSector3
		GlobalInpOffset% = GlobalInpOffset% - 1
		OffsVal% = OffsVal% - 1
		IF OffsVal% < 0 THEN Z = Z - 3: GOTO ShowSector2
		GOTO ShowSector3
ShowSector4:                 
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO ShowSector3
		
ShowSectorEnd:       
		RETURN

' Prepare file to be cataloged upon by LZW decompressor
ARKextract:     CALL GetVirtualSect(FileNum%, StartSect%(CurrentFilename%) + 1, d$)
		'GET #1, StartSect%(CurrentFilename%) + 1
		FHeader$ = d$
		SectorLength# = CalcWord(FilName$(CurrentFilename%), 15) + 1
		Z = 0                      ' Offset in Input File Chain Pointer Block
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		SectorCnt% = SectorLength# - 1' Sector Length of this file
		OPEN TempArk$ FOR BINARY ACCESS WRITE AS #2
		GOSUB DoDisFix2
		RETURN

'===============================================
' CALCULATE CURRENT ENTRY IN CHAIN POINTER TABLE
'===============================================
' The second 3 nibble block contains the highest OFFSET within each Chain Block.
' This value must never be higher than SectorCnt% - 1, which is the file total length - 2,
' as it appears on Disk Catalog.
' This corrects the bug on 80 track disks, that have the last second 3 nibble block wrong on
' ODD LENGTH FILES (1 sector longer).
' If not corrected, this bug would create an error on lower size disks.

CalcClusters:
		A = ASC(MID$(FHeader$, 28 + 1 + Z, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z, 1))
		BA% = B MOD 16
		BB% = INT(B / 16)
		StSec% = BA% * 256 + A
		IF TotSect% > 3000 THEN StSec% = StSec% * 4
		Offs% = C * 16 + BB
		IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		OffsVal% = 0               ' Offset in EACH Input  File Chain Pointer Block
		
		GOTO CalcClustend     ' Skip the below check, which has been superseeded by the simpler
		' above approach:  IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		' Nonetheless, I leave it where it is because it might be still needed for some
		' 80 track disks that have a wrong file length, besides having
		' a wrong chain point table length.
		
' 
' Special case: in a 80 track Double Side Disk, when file length is EVEN (SectorLength# in my code), the
' Chain Point Table reports 1 sector more than what it should. When copying, we have to use avoid using
' that extra sector. Method: always check if there is a next Data Chain. If there is, do nothing. Otherwise,
' that means we are are the end of the Data Chain, and we have to use a sector less.
' SectorLength#

		
		IF Dens% < 2 OR Tracks < 80 THEN GOTO CalcClustend
		IF SectorLength# <> (INT(SectorLength# / 2)) * 2 THEN GOTO CalcClustend
		A = ASC(MID$(FHeader$, 28 + 1 + Z + 3, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z + 3, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z + 3, 1))
		IF A <> 0 OR B <> 0 OR C <> 0 THEN GOTO CalcClustend
		Offs% = Offs% - 1
CalcClustend:     
		
		RETURN
		
' Mark File containing Error: To save memory, a couple of bytes (CHR$) each bad sector     
MarkErrFile: 
		MSB% = INT(K / 256)
		LSB% = K MOD 256
		FileErrList$(FileToCopy%) = FileErrList$(FileToCopy%) + CHR$(MSB%) + CHR$(LSB%)
		RETURN
		
DoDisFix:        OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #2
DoDisFix2:       Z = 0: Tog% = 1: BytePos& = 1: Trecs& = 0
		TotRecs& = ASC(MID$(FHeader$, 20, 1)) * 256 + ASC(MID$(FHeader$, 19, 1))
		RecsInSect% = ASC(MID$(FHeader$, 14, 1))
		LogRecLength% = ASC(MID$(FHeader$, 18, 1))
		
		' Special case: Archiver III files are sometimes bugged. The Total Records (Bytes 19+20 in FDR)
		' sometimes report 256 records less than what it should.
		' The following patch compares the Total Records
		' with the Total Sector*2 which, in a dis/fix 128 record should be more or less comparable.
		' If this is not the case, adds 256 bytes to previous value
		' Trecs&=0:GOTO NextClusterDF
		
		IF LogRecLength% <> 128 THEN GOTO NextClusterDF
		T& = (SectorCnt% - 1) * 2
		IF T& <= TotRecs& THEN GOTO NextClusterDF
		TotRecs& = TotRecs& + 256
		' PRINT " (fixed!)";
		' print  "Total Records="; TotRecs&  :input c$
		
NextClusterDF:   GOSUB CalcClusters
		IF StSec% = 0 THEN GOTO EOThisFileDF
		'PRINT "A="; HEX$(a); a
		'PRINT "B="; HEX$(B); B
		'PRINT "C="; HEX$(c); c
		'PRINT "Start Sector="; StSec%;" >";HEX$(StSec%)
		'PRINT "Offset="; Offs%;" >";HEX$(Offs%)
		'PRINT "TotRecs&="; TotRecs&;" >";HEX$(TotRecs&)
		'INPUT "", c$
		
NextOffsValDF:
		
		IF GlobalInpOffset% > Offs% THEN Z = Z + 3: GOTO NextClusterDF
		CALL GetVirtualSect(FileNum%, StSec% + OffsVal% + 1, d$)
		'GET #1, StSec% + OffsVal% + 1

		GOSUB RecToDoDF
		IF TotRecs& < 1 THEN GOTO EOThisFileDF
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		
		' DoneSect=DoneSect+1: PRINT TotRecs&;DoneSect; GlobalInpOffset%
		
		GOTO NextOffsValDF

EOThisFileDF: 
		CLOSE #2
		
		RETURN

' Transfer a Dis/Var record (Text)
RecToDoDF:                  ROff% = 1

RecToDoDFAG:                FOR RT% = 1 TO RecsInSect%
		DFRec$ = MID$(d$, ROff%, LogRecLength%)
		PUT #2, BytePos&, DFRec$: BytePos& = BytePos& + LogRecLength%
		ROff% = ROff% + LogRecLength%
		TotRecs& = TotRecs& - 1
		Trecs& = Trecs& + 1
		IF TotRecs& < 1 THEN GOTO RecDoneDF
		NEXT RT%
		
RecDoneDF:                  RETURN

SUB box (Y, X, W, H)

		' Call Box(StartRow, StartColumn, Width, Hight)
		' Y=StartRow,X=StartColumn; W=Width,H=Hight)
		LOCATE Y, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";
		
		FOR V = 1 TO H - 2
		LOCATE Y + V, X
		PRINT ""; TAB(X + W - 1); : PRINT "";
		NEXT V

		LOCATE Y + H - 1, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";


END SUB

FUNCTION CalcWord (A$, P%)
		IF LEN(A$) < P% + 1 THEN INPUT "Wrong String in CalcWord Subroutine", C$: V% = 0: GOTO CalcWord1
		B1% = ASC(MID$(A$, P%, 1))
		B2% = ASC(MID$(A$, P% + 1, 1))
		V% = (B1% * 256) + B2%
CalcWord1:       CalcWord = (V%)
END FUNCTION

FUNCTION CalcDWord# (A$, P%)
		IF LEN(A$) < P% + 3 THEN INPUT "Wrong String in CalcDoubleWord Subroutine", C$: V# = 0: GOTO CalcDWord1
		
		B1# = ASC(MID$(A$, P%, 1))
		B2# = ASC(MID$(A$, P% + 1, 1))
		B3# = ASC(MID$(A$, P% + 2, 1))
		B4# = ASC(MID$(A$, P% + 3, 1))
		V# = (B1# * 16777216) + (B2# * 65536) + (B3# * 256) + B4#
		
CalcDWord1:      CalcDWord# = (V#)
		
END FUNCTION


SUB ERRSOUND
		SOUND 110, 4

END SUB

SUB Fischio
		IF MyVal(1) = 0 THEN EXIT SUB
		FOR i% = 3000 TO 4000 STEP 200
		SOUND i%, .1  'i% / 1000
		NEXT i%

END SUB

SUB ShortName (A$)
' Get short filename (8.3 characters)
		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT7160.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO ShortName2
		LINE INPUT #71, A$
ShortName2:     CLOSE #71
		KILL "--"
END SUB

SUB ShowHex (A$, K$)
' This is simply to help during debugging
' Syntax: CALL ShowHex(A$,K$) ' A$ usually contains an entire TI Sector (256 bytes)
		Col% = 3
		B$ = ""
		FOR T = 1 TO LEN(A$)
		C$ = HEX$(ASC(MID$(A$, T, 1))): IF LEN(C$) = 1 THEN C$ = "0" + C$
		B$ = B$ + C$ + " "
		NEXT T
		
		LOCATE 10, Col% + 2
		PRINT "Addr. 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ";
		
		IF K$ = "" THEN T = LEN(B$) - (8 * 16 * 3 - 1) ELSE T = 1
'===============LOOP STARTS HERE 
		
Repeat:  
		T$ = MID$(B$, T, 16 * 3)
		LOCATE 10 + 1 + Row%, Col% + 2:
		H$ = HEX$(T / 3): IF LEN(H$) = 1 THEN H$ = "0" + H$
		PRINT USING "\  \"; H$;
		LOCATE 10 + 1 + Row%, Col% + 5
		PRINT " - "; T$;
		PRINT "  ";
		FOR J = 1 TO 16
		J$ = MID$(A$, (T - 1) / 3 + J, 1)
		IF ASC(J$) < 32 OR ASC(J$) > 126 THEN PRINT " ";  ELSE PRINT J$;
		
		NEXT J
		
		Row% = Row% + 1: IF Row% < 8 THEN GOTO NextRow ELSE Row% = 0
		'locate 21,1: print len(B$)
		'locate 22,1: print t
		'locate 23,1: print (t-1)/(3*16)
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO GEXIT
		
		' Arrow Down
		IF K$ <> CHR$(0) + CHR$(80) THEN GOTO ArrowUPkey
		T = T - (16 * 3 * 6): IF T < 1 THEN T = 1
		GOTO Repeat
		
ArrowUPkey:      ' Arrow UP
		IF K$ <> CHR$(0) + CHR$(72) AND K$ <> CHR$(0) + CHR$(73) THEN GOTO NextRow
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO PageUPKey
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 8): IF T < 1 THEN T = 1
		GOTO Repeat
PageUPKey:           
		' Page UP
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 15): IF T < 1 THEN T = 1
		GOTO Repeat

NextRow: 
		T = T + (16 * 3)
		IF T < LEN(B$) THEN GOTO Repeat
		K$ = "Y"
'===============LOOP ENDS HERE
GEXIT:
END SUB

SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
		GOTO GetHelp

' Because of MS QBasic quirks, GetIDX routine has to be placed before the rest of the code.

' Get .IDX file values into an array, that is,
' Get Array Parameters from Index (IDX) file
GetIDX:       
		OPEN IDXFile$ FOR RANDOM ACCESS READ AS #3 LEN = LEN(IDXRecord)
		GET #3, , IDXRecord
		TLines% = IDXRecord.StartRec' First record is special: total records that follow
		
		
		REDIM IDXSect$(TLines%)
		REDIM IdxStart(TLines%)
		REDIM IdxLength(TLines%)
		FOR T = 1 TO TLines%
		GET #3, , IDXRecord
		IDXSect$(T) = LTRIM$(IDXRecord.Section)
		IdxStart(T) = IDXRecord.StartRec
		IdxLength(T) = IDXRecord.RecLength
		IDXSect$(T) = LTRIM$(RTRIM$(IDXSect$(T)))
		NEXT T
		CLOSE #3
		
		RETURN
		

		

GetHelp:        CLS
		LOCATE 1, 26: PRINT Banner$
		InizRw% = 2
		TotScrRws% = 12
		CurrScrRw% = 1
		
		GOSUB RedrawBox
		GOSUB GetIDX
		FOR Arg% = 1 TO TLines%
		IF Argum$ = IDXSect$(Arg%) THEN GOTO ArgFnd
		NEXT Arg%
		Arg% = 1
		
ArgFnd:         CurntLine% = Arg%
		RcLen% = 77 + 2
		OPEN DatFile$ FOR RANDOM ACCESS READ AS #59 LEN = RcLen%
		FIELD #59, RcLen% - 2 AS DL$
		FIELD #59, 2 AS CRLF$
		
'===================================
' MAIN LOOP STARTS HERE
'===================================     
NextLineName:
		COLOR FC, BC
		
		IF CurrScrRw% = 1 THEN FstLine% = CurntLine%   ' Get Number of first Line only
		GOSUB DisplayRw
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		CurrScrRw% = CurrScrRw% + 1  ' Next Screen Row
		IF CurrScrRw% < TotScrRws% + 1 AND CurntLine% <= TLines% THEN GOTO NextLineName
'===================================
' MAIN LOOP ENDS HERE
'===================================
'         
		GOSUB BotLine              ' Clear Unused Bottom Lines
		LastLine% = CurntLine% - 1
		CurntLine% = FstLine%  ' Current Line is now first Line in screen
		
		CurrScrRw% = 1
		IF KeepCursBot% = 0 THEN GOTO LocCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last Line in Screen
		CurrScrRw% = TotScrRws%: KeepCursBot% = 0: CurntLine% = LastLine%
		GOTO LocCursor2
		
LocCursor:
		GOSUB HeRestColor

LocCursor2:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		COLOR FC, BC: GOSUB DisplayRw: COLOR FC, BC' Display Current Row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		OldScrRw% = CurrScrRw%
		OldLine% = CurntLine%
		IF GoToThisDir% <> 0 THEN CurntLine% = GoToThisDir%: GoToThisDir% = 0: GOTO Exekit
		'GOSUB ShowValues    ' My little Debugger
		
		
DoHeAgain:      GOSUB GetChar

		' IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO DoHeAgain

		' ESCape Key
		IF UH$ = CHR$(27) THEN GOTO HAbort
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO IsArrDown
EnterKey:       CALL Fischio
		GOSUB ThisSect
		GOSUB RePaintHelp
		GOTO NMatch

IsArrDown:     ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO OthKey0
		IF CurrScrRw% < LastScrRw% THEN CurrScrRw% = CurrScrRw% + 1: CurntLine% = CurntLine% + 1: GOTO LocCursor
		IF CurntLine% = TLines% THEN GOTO LocCursor
		CurntLine% = FstLine% + 1
		KeepCursBot% = 1
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
OthKey0:         'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO OthKey1
		IF CurntLine% = 1 THEN GOTO NMatch
		IF CurrScrRw% > 1 THEN CurrScrRw% = CurrScrRw% - 1: CurntLine% = CurntLine% - 1: GOTO LocCursor
		CurntLine% = FstLine% - 1: IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
		
OthKey1:         ' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO OthKey2
		CurntLine% = FstLine% - TotScrRws%
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO OthKey7
		IF LastLine% + 1 + TotScrRws% > TLines% THEN CurntLine% = TLines% - TotScrRws% + 1: IF CurntLine% < 1 THEN CurntLine% = 1: GOTO Exekit
		CurntLine% = FstLine% + TotScrRws%
		IF CurntLine% > TLines% THEN CurntLine% = FstLine%
		GOTO Exekit
		
OthKey7:         ' Home Key : simply move cursor to top
		IF UH$ <> CHR$(0) + CHR$(71) THEN GOTO OthKey8
		CurrScrRw% = 1: CurntLine% = FstLine%: GOTO LocCursor

OthKey8:         ' End Key : simply move cursor to bottom
		IF UH$ <> CHR$(0) + CHR$(79) THEN GOTO OthKey9
		CurrScrRw% = LastScrRw%: CurntLine% = LastLine%
		GOTO LocCursor
		
OthKey9:        ' F3 = Show Error List
		IF UH$ <> CHR$(0) + CHR$(61) THEN GOTO OthKey10
		GOSUB RePaintHelp
		GOTO NMatch

OthKey10:       ' F7 = Show Sector as Hex
		IF UH$ <> CHR$(0) + CHR$(65) THEN GOTO OthKey11
		GOSUB RePaintHelp
		GOTO NMatch
		
OthKey11:       'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO OthKey12
		GOTO EnterKey
OthKey12:         
		GOTO NMatch


Exekit:         CurrScrRw% = 1     ' Cursor on first screen row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GOTO NextLineName   ' Start next round

NMatch:         GOTO LocCursor
		
RePaintHelp:   
		GOSUB RedrawBox
		SaveCurrLine% = CurntLine%
		SavCurrScrRw% = CurrScrRw%
		CurntLine% = FstLine%
		FOR CurrScrRw% = 1 TO TotScrRws%
		GOSUB DisplayRw  ' Display Current Row
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		IF CurntLine% > TLines% THEN CurrScrRw% = CurrScrRw% + 1: GOTO RePaintHelp2
		NEXT CurrScrRw%   ' Next Screen Row
		
RePaintHelp2:        
		
		CurntLine% = SaveCurrLine%
		CurrScrRw% = SavCurrScrRw%
		RETURN

HeRestColor:    TempScreenRw% = CurrScrRw%
		TempLine% = CurntLine%
		CurrScrRw% = OldScrRw%
		CurntLine% = OldLine%
		COLOR FC, BC: GOSUB DisplayRw' Display Current Row
		CurrScrRw% = TempScreenRw%
		CurntLine% = TempLine%
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRw:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GET #59, IdxStart(CurntLine%)
		TL$ = DL$
		FOR T = 1 TO LEN(TL$): IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO StrtFound
		NEXT T
StrtFound:      TL$ = RIGHT$(TL$, LEN(TL$) - T + 1)
		
		FOR T = LEN(TL$) TO 1 STEP -1: IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO EndFnd
		NEXT T
EndFnd:         TL$ = LEFT$(TL$, T)
		PRINT IDXSect$(CurntLine%); TAB(12); TL$; SPACE$(79 - 12 - LEN(TL$));
		RETURN
		
'====================
' CLEAR BOTTOM LINES
'====================     
BotLine:
		
		LOCATE InizRw% + CurrScrRw%, 2, 1

		IF CurrScrRw% >= TotScrRws% THEN GOTO HlpClear ' Blank all unused screen rows, if any

		FOR V = CurrScrRw% TO TotScrRws%
		LOCATE InizRw% + V, 2, 1
		PRINT "                                                                              "
		NEXT V
		
HlpClear:        LOCATE 23, 1: PRINT "Enter=Get Doc. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		RETURN

		
' Create Box
RedrawBox:      CALL box(2, 1, 80, TotScrRws% + 2)
		RETURN
Pranyk:

		PRINT "                         - press any key to return -"
		GOSUB GetChar
		RETURN
		
GetChar:
		DO: UH$ = INKEY$: LOOP UNTIL UH$ <> ""
		RETURN


ThisSect:       TotSectRws% = 19
		SectInizRw% = 2
		SectCurrRw% = 1
		SectStart# = IdxStart(CurntLine%)
		SectCount# = IdxLength(CurntLine%)
		SectCurr# = 0
		Blank$ = SPACE$(78)
		LOCATE 23, 1: PRINT "Enter=Line Down. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		CALL box(2, 1, 80, TotSectRws% + 2)
NewRound:           
		FirstRec# = SectCurr#
SectNewLine:           
		GET #59, SectStart# + SectCurr#
		LOCATE SectInizRw% + SectCurrRw%, 2, 1
		PRINT DL$;
		SectCurr# = SectCurr# + 1
		LastSectRw% = SectCurrRw%      ' Save last Screen Row used
		SectCurrRw% = SectCurrRw% + 1
		IF SectCurrRw% < TotSectRws% + 1 AND SectCurr# < SectCount# THEN GOTO SectNewLine
		
		FOR V = SectCurrRw% TO TotSectRws%
		LOCATE SectInizRw% + V, 2
		PRINT Blank$;
		NEXT V
		
GetAnother:     GOSUB GetChar
		'IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO GetAnother
		SectCurr# = FirstRec#
		SectCurrRw% = 1
		' ESC Key
		IF UH$ = CHR$(27) THEN GOTO SectExit
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO SectArrowDown
SectEnter:      IF SectCurr# < SectCount# - 6 THEN SectCurr# = SectCurr# + 1
		GOTO NewRound
		
SectArrowDown:  ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO SectKey0
		GOTO SectEnter
		
SectKey0:       'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO SectKey1
		IF SectCurr# > 0 THEN SectCurr# = SectCurr# - 1
		GOTO NewRound
SectKey1:         
		' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO SectKey2
SectPageUp:     SectCurr# = SectCurr# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO SectKey11
SectPageDown:   SectCurr# = SectCurr# + TotSectRws%
		IF SectCurr# > SectCount# - TotSectRws% THEN SectCurr# = SectCount# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey11:      'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO SectKey12
		GOTO SectPageDown
		
SectKey12:      'CTRL Page Up
		IF UH$ <> CHR$(0) + CHR$(132) THEN GOTO SectKey13
		GOTO SectPageUp
SectKey13:        
		GOTO NewRound
SectExit:             
		V = InizRw% + TotScrRws%
		LOCATE V, 1, 1
		IF V >= 22 THEN GOTO DontDoit ' Blank all unused screen rows, if any

		FOR V = V TO 23
		LOCATE V, 1, 1
		PRINT SPACE$(80)
		NEXT V
DontDoit:
		
		RETURN
HAbort:           
		CLOSE #59
END SUB

' READ A SECTOR FROM PC99 DISK
SUB GetVirtualSect (FileNum%, Sektor%, d$)
		Sekr% = Sektor% - 1
		
		IF FType$ <> "VS" THEN GOTO PC99disk            ' V-9T9 S-ingle density
		ByteOff&=Sekr%
		ByteOff&=ByteOff&*256
		GET #FileNum%, ByteOff& + 1, V9T9Sekt(1)
		d$= V9T9Sekt(1)
		GOTO GetSectExit
		
PC99disk:       Trk# = INT(Sekr% / SekTrack%)
		DskSide# = 0
		IF Trk# > 39 THEN Trk# = 79 - Trk#: DskSide# = 1
		Skt% = Sekr% MOD SekTrack%
		
		IF FType$ = "PD" THEN GOTO GetSectD
		IF FType$ = "PS" THEN GOTO GetSectS

'*** SINGLE DENSITY DISK ***
GetSectS:       IF Trk# = OldTrack# AND DskSide# = OldDskSide# THEN GOTO GetSectS03
		ByteOff& = SideLen# * DskSide# + Trk# * TrkLen#
		GET #FileNum%, ByteOff& + 1, TrackSing(1)
		OldTrack# = Trk#: OldDskSide# = DskSide#
		
GetSectS03:     FOR WHT% = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (WHT% - 1))
		A$ = MID$(TrackSing(1), P, 4)
		
		IF A$ <> CHR$(Trk#) + CHR$(DskSide#) + CHR$(Skt%) + CHR$(1) THEN GOTO GetSectS05
		d$ = MID$(TrackSing(1), 1 + Gap1% + PreDatGap% + (SLength% * (WHT% - 1)), 256)
		GOTO GetSectExit
		
GetSectS05:     NEXT WHT%
		
		GOTO GetSectBad:
		
'*** DOUBLE DENSITY DISK *** 
GetSectD:       IF Trk# = OldTrack# AND DskSide# = OldDskSide# THEN GOTO GetSectD03
		ByteOff& = SideLen# * DskSide# + Trk# * TrkLen#
		GET #FileNum%, ByteOff& + 1, TrackDoub(1)
		OldTrack# = Trk#: OldDskSide# = DskSide#
		
GetSectD03:     FOR WHT% = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (WHT% - 1))
		A$ = MID$(TrackDoub(1), P, 4)
		
		IF A$ <> CHR$(Trk#) + CHR$(DskSide#) + CHR$(Skt%) + CHR$(1) THEN GOTO GetSectD05
		d$ = MID$(TrackDoub(1), 1 + Gap1% + PreDatGap% + (SLength% * (WHT% - 1)), 256)
		GOTO GetSectExit
		
GetSectD05:     NEXT WHT%

GetSectBad:     d$ = ""
		
GetSectExit: 
END SUB

' ESTABLISH MEDIA OF A PC99 OR V9T9 DISK AND GET SECTOR ZERO
' Ex. Call GetVirtualZero (1, d$)
'       .... will return  
'FType$ = "VS" if V9T9 disk
'FType$ = "PS" if PC99 Single density disk
'FType$ = "PD" if PC99 Double density disk
'FType$ = "MH" if Mess Hard Disk

SUB GetVirtualZero (FileNum%, d$)
		ByteOff& = 1
		DIM DAT(1) AS STRING * 256
		
		GET #FileNum%, ByteOff&, DAT(1)
		IF MID$(DAT(1),1,8)<>"MComprHD" THEN GOTO DSKDetect
		FType$ = "MH" ' Mess Hard Disk
		MHTB# = CalcDWord# (DAT(1), 28 + 1) ' Get Total # of Blocks
		MHMapStart# = CalcDWord# (DAT(1), 8 + 1) ' Get Hard Disk Header Size
		MHMapEnd# = MHTB# * 8 +  MHMapStart# ' Get Total # of Blocks * 8 + Hard Disk Header Size
		MHSectZero# = MHMapEnd# + 8
		MHSecLen%= CalcDWord# (DAT(1), 76 + 1) ' Get Hard Disk Sector Len
		
		PRINT "FType$=";FType$
		PRINT "MHTB#=";MHTB#
		PRINT "MHMapStart#=";MHMapStart#
		PRINT "MHMapEnd#=";MHMapEnd#
		PRINT "MHSectZero#=";MHSectZero#
		PRINT "MHSecLen%=";MHSecLen%
		INPUT CCCCCCCCC$ :SYSTEM
		
		
		
DSKDetect:               
		
		IF MID$(DAT(1),14,3)<>"DSK" THEN GOTO PC99Detect
		FType$ = "VS"          ' V-9T9 S-ingle density
		d$=MID$(DAT(1),1,256)
		GOTO V9T9Found
		
		
PC99Detect:      P = INSTR(DAT(1), CHR$(&HFE)): IF P = 0 THEN GOTO EstMedAbort
		A$ = MID$(DAT(1), P + 4, 1)
		IF A$ <> CHR$(&H1) THEN GOTO EstMedAbort
		A$ = MID$(DAT(1), P - 3, 3)
		IF A$ = CHR$(&HA1) + CHR$(&HA1) + CHR$(&HA1) THEN GOTO DDens
		IF A$ <> CHR$(0) + CHR$(0) + CHR$(0) THEN GOTO EstMedAbort
'*** SINGLE DENSITY DISK ***          
SDens:     
		A$ = MID$(DAT(1), P + 4, 1)
		IF A$ <> CHR$(1) THEN GOTO EstMedAbort
		IF P <> 23 THEN GOTO EstMedAbort
		Gap1% = 16             ' Start of track Gap
		PreIDGap% = 7          '
		PreDatGap% = 31
		SLength% = 334
		SekTrack% = 9
		
		CONST TrkLenS% = 3253
		TrkLen# = TrkLenS%
		'REDIM TrackSing(1) AS STRING * TrkLenS
		GET #FileNum%, 1, TrackSing(1)
		d$ = TrackSing(1)
		FType$ = "PS"          ' P-C99 S-ingle density
		GOTO GetSZero1
		
'*** DOUBLE DENSITY DISK ***                  
DDens:     
		IF P <> 54 THEN GOTO EstMedAbort
		Gap1% = 40             ' Start of track Gap
		PreIDGap% = 14
		PreDatGap% = 58
		SLength% = 340
		SekTrack% = 18
		ERASE TrackSing
		CONST TrkLenD% = 6872
		TrkLen# = 6872
		'REDIM TrackDoub(1) AS STRING * TrkLenD
		GET #FileNum%, 1, TrackDoub(1)
		d$ = TrackDoub(1)
		FType$ = "PD"          ' P-C99 D-ouble density
		GOTO GetSZero2
GetSZero1:       ERASE TrackDoub
GetSZero2:
		OldTrack# = 0
		OldDskSide# = 0
		SideLen# = TrkLen#
		SideLen# = SideLen# * 40
		FOR T = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (T - 1))
		A$ = MID$(d$, P, 4)
		
		IF A$ = CHR$(0) + CHR$(0) + CHR$(0) + CHR$(1) THEN GOTO SZeroFnd
		NEXT T
		GOTO EstMedAbort
SZeroFnd:        P = 1 + Gap1% + PreDatGap% + (SLength% * (T - 1))
		d$ = MID$(d$, P, 256)
		'A$=MID$(DAT,14,3)
		'IF A$<>"DSK" THEN GOTO EstMedAbort
		GOTO EstMedExit
		
V9T9Found:       ERASE TrackSing
		ERASE TrackDoub
		GOTO EstMedExit
		
EstMedAbort:    FType$ = ""  : d$ = ""
EstMedExit:     ERASE DAT
END SUB
