' TI-99/4A Directory listing and Transfer File of a TI disk image file
' (obtained from TI99-PC.COM and saved as normal file on a PC)
' - Paolo Bagnaresi, May 2000 - e-mail: paolo_bagnaresi@libero.it
'
' This module can be Launched with a CHAIN qbasic instruction by a different qbasic program.
' Just add the same COMMON arrays to your launcher. (DIM Vector, MyName$, MyVal and the 3 corresponding COMMON Shared declarations).
' These arrays are used only as a parameter passing between chained qbasic programs.

' TI-Dir has the return program name stored in MyName$(11).  MyName$(11) is devoted exclusively to TI-Dir usage. 
' TI-Dir has the Disk image filename on which it will work upon stored in MyName$(12).  MyName$(11) is devoted exclusively to TI-Dir usage. 


DECLARE FUNCTION Shrink$ (In$)
DIM Vector(0 TO 10)      AS INTEGER
DIM MyName$(0 TO 30)
DIM MyVal(0 TO 10)      AS INTEGER

COMMON SHARED Vector() AS INTEGER
COMMON SHARED MyName$()
COMMON SHARED MyVal() AS INTEGER

DEFINT A-Z

		DIM SHARED FC AS INTEGER
		DIM SHARED BC AS INTEGER
		DIM SHARED HFC AS INTEGER
		DIM SHARED HBC AS INTEGER
		DIM SHARED MHTB&
		DIM SHARED MHSectZero&
		DIM SHARED MHSecLen%
		DIM SHARED MHSekt256(1) AS STRING * 256
		DIM SHARED MHSekt512(1) AS STRING * 512
		DIM SHARED MHFloppy$
		DIM SHARED SubDirStAddr(0 TO 10)  AS INTEGER
		DIM SHARED SubDirName$(0 TO 10)
		DIM SHARED SectPerAU%
		DIM SHARED SourcePath$

		FileNum% = 58   ' 1
		NormForeColor = 10' Normal Foreground Color
		NormBackColor = 0 ' Normal Background Color
		FC = NormForeColor
		BC = NormBackColor
		HFC = 15          ' Higlighted Foreground Color
		HBC = 10          ' Higlighted Background Color
DEFINT A-Z
' F1 help file. Record structure definition
		TYPE IDXType
		Section AS STRING * 20
		StartRec AS DOUBLE
		RecLength AS SINGLE
		END TYPE
		DIM SHARED IDXRecord AS IDXType
		DIM SHARED TempArk AS STRING
		TempArk = "~ARKTMP.TMP"
		
		DIM SHARED Gap1%            ' Start of track Gap
		DIM SHARED PreIDGap%           '
		DIM SHARED PreDatGap%
		DIM SHARED SLength%
		DIM SHARED TrkLen&
		DIM SHARED TrackSing(1) AS STRING * 3253
		DIM SHARED TrackDoub(1) AS STRING * 6872
		DIM SHARED V9T9Sekt(1) AS STRING * 256
		DIM SHARED OldTrack&
		DIM SHARED OldDskSide&
		DIM SHARED SideLen&

		DIM SHARED SekTrack%
		DIM SHARED FType$
		
		DIM SHARED Gap1W%            ' Start of track Gap
		DIM SHARED PreIDGapW%           '
		DIM SHARED PreDatGapW%
		DIM SHARED SLengthW%
		DIM SHARED TrkLenW&
		DIM SHARED TrackSingW(1) AS STRING * 3253
		DIM SHARED TrackDoubW(1) AS STRING * 6872
		DIM SHARED Bytes256(1) AS STRING * 256
		DIM SHARED OldTrackW&
		DIM SHARED OldDskSideW&
		DIM SHARED SideLenW&
		
		DIM SHARED SekTrackW%
		DIM SHARED FTypeW$
		
		DIM SHARED MHTBW&
		DIM SHARED MHSectZeroW&
		DIM SHARED MHSecLenW%
		DIM SHARED MHSekt256W(1) AS STRING * 256
		DIM SHARED MHSekt512W(1) AS STRING * 512
		
		DIM SHARED TiDSectorZero$
		DIM SHARED TiDCurrFileDescrIdx$
		
'- DEBUG AID n. 8 - OPEN "C:\TEMP\LOG.txt" FOR APPEND AS #111		
		CLS
		COLOR FC, BC
		SourcePath$ = MyName$(12)
		ON ERROR GOTO NoFileError
		OPEN  SourcePath$ FOR INPUT AS #FileNum%
		ON ERROR GOTO 0
		CLOSE #FileNum%
		CALL TiDir(SourcePath$)
		
		
		GOTO Leavit
		
NoFileError:    CALL box(1, 10, 66, 10)
		LOCATE 2, 12
		PRINT "TI-99/4A Disk Image Filename=    "
		LOCATE 4, 12
		PRINT  SourcePath$
		LOCATE 6, 12
		PRINT "Error. The above filename doesn't exist"
		LOCATE 7, 12
		PRINT "Please correct and try again"
		LOCATE 9, 32
		PRINT "Press any key"
		BEEP
		WHILE INKEY$ = "": WEND
		
Leavit:         CLOSE #FileNum%
'- DEBUG AID n. 8 - 		CLOSE # 111   
		COLOR 7, 0
		IF MyName$(11) = "" THEN CLS : SYSTEM ELSE CHAIN MyName$(11)
		
		
		
		

SUB box (Y, X, W, H)

		' Call Box(StartRow, StartColumn, Width, Hight)
		' Y=StartRow,X=StartColumn; W=Width,H=Hight)
		LOCATE Y, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";
		
		FOR V = 1 TO H - 2
		LOCATE Y + V, X
		PRINT ""; TAB(X + W - 1); : PRINT "";
		NEXT V

		LOCATE Y + H - 1, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";


END SUB

FUNCTION CalcWord& (A$, P%)
		IF LEN(A$) < P% + 1 THEN INPUT "Wrong String in CalcWord Subroutine", C$: V% = 0: GOTO CalcWord1
		B1& = ASC(MID$(A$, P%, 1))
		B2& = ASC(MID$(A$, P% + 1, 1))
		V& = (B1& * 256) + B2&
CalcWord1:      CalcWord& = (V&)
END FUNCTION

FUNCTION CalcDWord& (A$, P%)
		IF LEN(A$) < P% + 3 THEN INPUT "Wrong String in CalcDoubleWord Subroutine", C$: V& = 0: GOTO CalcDWord1
		
		B1& = ASC(MID$(A$, P%, 1))
		B2& = ASC(MID$(A$, P% + 1, 1))
		B3& = ASC(MID$(A$, P% + 2, 1))
		B4& = ASC(MID$(A$, P% + 3, 1))
		V& = (B1& * 16777216) + (B2& * 65536) + (B3& * 256) + B4&
		
CalcDWord1:      CalcDWord& = (V&)
		
END FUNCTION

FUNCTION Chop$(T$)
		A$ = ""
		PRINT "^^^^^^^^^^="
		FOR T=LEN(T$)-1 TO 1 STEP  -1
		PRINT MID$(T$,T,1);
		IF MID$(T$,T,1)="\" THEN GOTO Chop2
		NEXT T
		T$="\"
		GOTO ChopExit

Chop2:          T$=LEFT$(T$,T)
ChopExit:       Chop$=T$

END FUNCTION 

FUNCTION Shrink$ (In$)
		A$ = "": c1$ = " "
		FOR T = 1 TO LEN(In$): C$ = MID$(In$, T, 1): IF C$ = " " AND c1$ = " " THEN GOTO SKIP
		A$ = A$ + C$: c1$ = C$
SKIP:
		NEXT T
		A$ = LTRIM$(RTRIM$(A$))
		Shrink$ = A$
END FUNCTION

SUB ERRSOUND
		SOUND 110, 4

END SUB

SUB Fischio
		IF MyVal(1) = 0 THEN EXIT SUB
		FOR i% = 3000 TO 4000 STEP 200
		SOUND i%, .1  'i% / 1000
		NEXT i%

END SUB

SUB ShortName (A$)
' Get short filename (8.3 characters)
		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT7160.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO ShortName2
		LINE INPUT #71, A$
ShortName2:     CLOSE #71
		KILL "--"
END SUB

SUB ShowHex (A$, K$)
' This is simply to help during debugging
' Syntax: CALL ShowHex(A$,K$) ' A$ usually contains an entire TI Sector (256 bytes)
		Col% = 3
		B$ = ""
		FOR T = 1 TO LEN(A$)
		C$ = HEX$(ASC(MID$(A$, T, 1))): IF LEN(C$) = 1 THEN C$ = "0" + C$
		B$ = B$ + C$ + " "
		NEXT T
		
		LOCATE 10, Col% + 2
		PRINT "Addr. 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ";
		
		IF K$ = "" THEN T = LEN(B$) - (8 * 16 * 3 - 1) ELSE T = 1
'===============LOOP STARTS HERE 
		
Repeat:  
		T$ = MID$(B$, T, 16 * 3)
		LOCATE 10 + 1 + Row%, Col% + 2:
		H$ = HEX$(T / 3): IF LEN(H$) = 1 THEN H$ = "0" + H$
		PRINT USING "\  \"; H$;
		LOCATE 10 + 1 + Row%, Col% + 5
		PRINT " - "; T$;
		PRINT "  ";
		FOR J = 1 TO 16
		J$ = MID$(A$, (T - 1) / 3 + J, 1)
		IF ASC(J$) < 32 OR ASC(J$) > 126 THEN PRINT " ";  ELSE PRINT J$;
		
		NEXT J
		
		Row% = Row% + 1: IF Row% < 8 THEN GOTO NextRow ELSE Row% = 0
		'locate 21,1: print len(B$)
		'locate 22,1: print t
		'locate 23,1: print (t-1)/(3*16)
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO GEXIT
		
		' Arrow Down
		IF K$ <> CHR$(0) + CHR$(80) THEN GOTO ArrowUPkey
		T = T - (16 * 3 * 6): IF T < 1 THEN T = 1
		GOTO Repeat
		
ArrowUPkey:      ' Arrow UP
		IF K$ <> CHR$(0) + CHR$(72) AND K$ <> CHR$(0) + CHR$(73) THEN GOTO NextRow
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO PageUPKey
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 8): IF T < 1 THEN T = 1
		GOTO Repeat
PageUPKey:           
		' Page UP
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 15): IF T < 1 THEN T = 1
		GOTO Repeat

NextRow: 
		T = T + (16 * 3)
		IF T < LEN(B$) THEN GOTO Repeat
		K$ = "Y"
'===============LOOP ENDS HERE
GEXIT:
END SUB

SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
		GOTO GetHelp

' Because of MS QBasic quirks, GetIDX routine has to be placed before the rest of the code.

' Get .IDX file values into an array, that is,
' Get Array Parameters from Index (IDX) file
GetIDX:       
		OPEN IDXFile$ FOR RANDOM ACCESS READ AS #3 LEN = LEN(IDXRecord)
		GET #3, , IDXRecord
		TLines% = IDXRecord.StartRec' First record is special: total records that follow
		
		
		REDIM IDXSect$(TLines%)
		REDIM IdxStart(TLines%)
		REDIM IdxLength(TLines%)
		FOR T = 1 TO TLines%
		GET #3, , IDXRecord
		IDXSect$(T) = LTRIM$(IDXRecord.Section)
		IdxStart(T) = IDXRecord.StartRec
		IdxLength(T) = IDXRecord.RecLength
		IDXSect$(T) = LTRIM$(RTRIM$(IDXSect$(T)))
		NEXT T
		CLOSE #3
		
		RETURN
		

		

GetHelp:        CLS
		LOCATE 1, 26: PRINT Banner$
		InizRw% = 2
		TotScrRws% = 12
		CurrScrRw% = 1
		
		GOSUB RedrawBox
		GOSUB GetIDX
		FOR Arg% = 1 TO TLines%
		IF Argum$ = IDXSect$(Arg%) THEN GOTO ArgFnd
		NEXT Arg%
		Arg% = 1
		
ArgFnd:         CurntLine% = Arg%
		RcLen% = 77 + 2
		OPEN DatFile$ FOR RANDOM ACCESS READ AS #59 LEN = RcLen%
		FIELD #59, RcLen% - 2 AS DL$
		FIELD #59, 2 AS CRLF$
		
'===================================
' MAIN LOOP STARTS HERE
'===================================     
NextLineName:
		COLOR FC, BC
		
		IF CurrScrRw% = 1 THEN FstLine% = CurntLine%   ' Get Number of first Line only
		GOSUB DisplayRw
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		CurrScrRw% = CurrScrRw% + 1  ' Next Screen Row
		IF CurrScrRw% < TotScrRws% + 1 AND CurntLine% <= TLines% THEN GOTO NextLineName
'===================================
' MAIN LOOP ENDS HERE
'===================================
'         
		GOSUB BotLine              ' Clear Unused Bottom Lines
		LastLine% = CurntLine% - 1
		CurntLine% = FstLine%  ' Current Line is now first Line in screen
		
		CurrScrRw% = 1
		IF KeepCursBot% = 0 THEN GOTO LocCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last Line in Screen
		CurrScrRw% = TotScrRws%: KeepCursBot% = 0: CurntLine% = LastLine%
		GOTO LocCursor2
		
LocCursor:
		GOSUB HeRestColor

LocCursor2:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		COLOR FC, BC: GOSUB DisplayRw: COLOR FC, BC' Display Current Row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		OldScrRw% = CurrScrRw%
		OldLine% = CurntLine%
		IF GoToThisDir% <> 0 THEN CurntLine% = GoToThisDir%: GoToThisDir% = 0: GOTO Exekit
		'GOSUB ShowValues    ' My little Debugger
		
		
DoHeAgain:      GOSUB GetChar

		' IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO DoHeAgain

		' ESCape Key
		IF UH$ = CHR$(27) THEN GOTO HAbort
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO IsArrDown
EnterKey:       CALL Fischio
		GOSUB ThisSect
		GOSUB RePaintHelp
		GOTO NMatch

IsArrDown:     ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO OthKey0
		IF CurrScrRw% < LastScrRw% THEN CurrScrRw% = CurrScrRw% + 1: CurntLine% = CurntLine% + 1: GOTO LocCursor
		IF CurntLine% = TLines% THEN GOTO LocCursor
		CurntLine% = FstLine% + 1
		KeepCursBot% = 1
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
OthKey0:         'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO OthKey1
		IF CurntLine% = 1 THEN GOTO NMatch
		IF CurrScrRw% > 1 THEN CurrScrRw% = CurrScrRw% - 1: CurntLine% = CurntLine% - 1: GOTO LocCursor
		CurntLine% = FstLine% - 1: IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
		
OthKey1:         ' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO OthKey2
		CurntLine% = FstLine% - TotScrRws%
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO OthKey7
		IF LastLine% + 1 + TotScrRws% > TLines% THEN CurntLine% = TLines% - TotScrRws% + 1: IF CurntLine% < 1 THEN CurntLine% = 1: GOTO Exekit
		CurntLine% = FstLine% + TotScrRws%
		IF CurntLine% > TLines% THEN CurntLine% = FstLine%
		GOTO Exekit
		
OthKey7:         ' Home Key : simply move cursor to top
		IF UH$ <> CHR$(0) + CHR$(71) THEN GOTO OthKey8
		CurrScrRw% = 1: CurntLine% = FstLine%: GOTO LocCursor

OthKey8:         ' End Key : simply move cursor to bottom
		IF UH$ <> CHR$(0) + CHR$(79) THEN GOTO OthKey9
		CurrScrRw% = LastScrRw%: CurntLine% = LastLine%
		GOTO LocCursor
		
OthKey9:        ' F3 = Show Error List
		IF UH$ <> CHR$(0) + CHR$(61) THEN GOTO OthKey10
		GOSUB RePaintHelp
		GOTO NMatch

OthKey10:       ' F7 = Show Sector as Hex
		IF UH$ <> CHR$(0) + CHR$(65) THEN GOTO OthKey11
		GOSUB RePaintHelp
		GOTO NMatch
		
OthKey11:       'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO OthKey12
		GOTO EnterKey
OthKey12:         
		GOTO NMatch


Exekit:         CurrScrRw% = 1     ' Cursor on first screen row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GOTO NextLineName   ' Start next round

NMatch:         GOTO LocCursor
		
RePaintHelp:   
		GOSUB RedrawBox
		SaveCurrLine% = CurntLine%
		SavCurrScrRw% = CurrScrRw%
		CurntLine% = FstLine%
		FOR CurrScrRw% = 1 TO TotScrRws%
		GOSUB DisplayRw  ' Display Current Row
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		IF CurntLine% > TLines% THEN CurrScrRw% = CurrScrRw% + 1: GOTO RePaintHelp2
		NEXT CurrScrRw%   ' Next Screen Row
		
RePaintHelp2:        
		
		CurntLine% = SaveCurrLine%
		CurrScrRw% = SavCurrScrRw%
		RETURN

HeRestColor:    TempScreenRw% = CurrScrRw%
		TempLine% = CurntLine%
		CurrScrRw% = OldScrRw%
		CurntLine% = OldLine%
		COLOR FC, BC: GOSUB DisplayRw' Display Current Row
		CurrScrRw% = TempScreenRw%
		CurntLine% = TempLine%
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRw:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GET #59, IdxStart(CurntLine%)
		TL$ = DL$
		FOR T = 1 TO LEN(TL$): IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO StrtFound
		NEXT T
StrtFound:      TL$ = RIGHT$(TL$, LEN(TL$) - T + 1)
		
		FOR T = LEN(TL$) TO 1 STEP -1: IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO EndFnd
		NEXT T
EndFnd:         TL$ = LEFT$(TL$, T)
		PRINT IDXSect$(CurntLine%); TAB(12); TL$; SPACE$(79 - 12 - LEN(TL$));
		RETURN
		
'====================
' CLEAR BOTTOM LINES
'====================     
BotLine:
		
		LOCATE InizRw% + CurrScrRw%, 2, 1

		IF CurrScrRw% >= TotScrRws% THEN GOTO HlpClear ' Blank all unused screen rows, if any

		FOR V = CurrScrRw% TO TotScrRws%
		LOCATE InizRw% + V, 2, 1
		PRINT "                                                                              "
		NEXT V
		
HlpClear:        LOCATE 23, 1: PRINT "Enter=Get Doc. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		RETURN

		
' Create Box
RedrawBox:      CALL box(2, 1, 80, TotScrRws% + 2)
		RETURN
Pranyk:

		PRINT "                         - press any key to return -"
		GOSUB GetChar
		RETURN
		
GetChar:
		DO: UH$ = INKEY$: LOOP UNTIL UH$ <> ""
		RETURN


ThisSect:       TotSectRws% = 19
		SectInizRw% = 2
		SectCurrRw% = 1
		SectStart& = IdxStart(CurntLine%)
		SectCount& = IdxLength(CurntLine%)
		SectCurr& = 0
		Blank$ = SPACE$(78)
		LOCATE 23, 1: PRINT "Enter=Line Down. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		CALL box(2, 1, 80, TotSectRws% + 2)
NewRound:           
		FirstRec& = SectCurr&
SectNewLine:           
		GET #59, SectStart& + SectCurr&
		LOCATE SectInizRw% + SectCurrRw%, 2, 1
		PRINT DL$;
		SectCurr& = SectCurr& + 1
		LastSectRw% = SectCurrRw%      ' Save last Screen Row used
		SectCurrRw% = SectCurrRw% + 1
		IF SectCurrRw% < TotSectRws% + 1 AND SectCurr& < SectCount& THEN GOTO SectNewLine
		
		FOR V = SectCurrRw% TO TotSectRws%
		LOCATE SectInizRw% + V, 2
		PRINT Blank$;
		NEXT V
		
GetAnother:     GOSUB GetChar
		'IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO GetAnother
		SectCurr& = FirstRec&
		SectCurrRw% = 1
		' ESC Key
		IF UH$ = CHR$(27) THEN GOTO SectExit
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO SectArrowDown
SectEnter:      IF SectCurr& < SectCount& - 6 THEN SectCurr& = SectCurr& + 1
		GOTO NewRound
		
SectArrowDown:  ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO SectKey0
		GOTO SectEnter
		
SectKey0:       'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO SectKey1
		IF SectCurr& > 0 THEN SectCurr& = SectCurr& - 1
		GOTO NewRound
SectKey1:         
		' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO SectKey2
SectPageUp:     SectCurr& = SectCurr& - TotSectRws%
		IF SectCurr& < 0 THEN SectCurr& = 0
		GOTO NewRound
		
SectKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO SectKey11
SectPageDown:   SectCurr& = SectCurr& + TotSectRws%
		IF SectCurr& > SectCount& - TotSectRws% THEN SectCurr& = SectCount& - TotSectRws%
		IF SectCurr& < 0 THEN SectCurr& = 0
		GOTO NewRound
		
SectKey11:      'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO SectKey12
		GOTO SectPageDown
		
SectKey12:      'CTRL Page Up
		IF UH$ <> CHR$(0) + CHR$(132) THEN GOTO SectKey13
		GOTO SectPageUp
SectKey13:        
		GOTO NewRound
SectExit:             
		V = InizRw% + TotScrRws%
		LOCATE V, 1, 1
		IF V >= 22 THEN GOTO DontDoit ' Blank all unused screen rows, if any

		FOR V = V TO 23
		LOCATE V, 1, 1
		PRINT SPACE$(80)
		NEXT V
DontDoit:
		
		RETURN
HAbort:           
		CLOSE #59
END SUB

DEFINT A-Z
' TI-Dir has the return program name stored in MyName$(11).  MyName$(11) is devoted exclusively to TI-Dir usage.
' TI-Dir has the Disk image filename on which it will work upon stored in MyName$(12).  MyName$(11) is devoted exclusively to TI-Dir usage.
SUB TiDir (TiDDosFile$)

	TiDFileNum% = 58   ' 1
	TiDNormForeColor = 10' Normal Foreground Color
	TiDNormBackColor = 0 ' Normal Background Color
	FC = TiDNormForeColor
	BC = TiDNormBackColor
	HFC = 15          ' Higlighted Foreground Color
	HBC = 10          ' Higlighted Background Color
	DBLNULL$=CHR$(0) + CHR$(0)
	ABORT$=""	  ' if ABORT$<>"" then Abort
		
		CLS
		COLOR FC, BC
		
		TiDSourcePath$ = TiDDosFile$
		GOTO GoGetIt	
		
StartAgain:	DelDone$="Y"	
GoGetIt:	REDIM FilName$(1)
		REDIM StartSect&(0)
		REDIM CopyMark$(0)
		REDIM TiDFileErrList$(0)
		
		REDIM ActDirsCopyMark$(0)
		GOSUB TiDInit
		IF ABORT$<>"" THEN GOTO TiDAbort
TiDNewSubDir:	GOSUB ReadNewDir	' Read Directory pointed by TiDCurrFileDescrIndex&
		
		REDIM ActDirsCopyMark$(TiDActiveDirs%)
		' Prepare to show all filenames
		TiDCurScreenRow% = 1
		TiDTotalScreenRows% = 13     ' Rows to display Filenames
		TiDStartRow% = 7  ' Screen Start Row
		TiDCurFilename% = 1
		TiDTotFiles2Copy% = 0
		TiDTotSizeFiles2Copy& = 0                         ' Added on August 27, 2003 from a tip of Ben Yates. Thank you, Ben!
		TiDAllowedKey$ = CHR$(27)                         ' ESC
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(72) ' Arrow Up
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(80) ' Arrow Down
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(73) ' Page Up
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(81) ' Page Down
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(83) ' Del
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(71) ' Home
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(79) ' End
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(59) ' F1 = Help
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(61) ' F3 = Show Bad Sector
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(64) ' F6 = Proceed
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(65) ' F7 = Show Bad Sector
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(0) + CHR$(66) ' F8 = Show ARK file directory, if applicable
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(21)           ' CTRL U = Unmark All
		'TiDAllowedKey$ = TiDAllowedKey$ + CHR$(1)            ' CTRL A = Copy All
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(3)            ' CTRL C
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(4)            ' CTRL D
		TiDAllowedKey$ = TiDAllowedKey$ + CHR$(13)           ' Enter = Execute
		'TiDAllowedKey$ = TiDAllowedKey$ + "CM1234567890D "            ' CM + Blank +1234567890
		TiDAllowedKey$ = TiDAllowedKey$ + "D "            '
		GOSUB TiDTopScreen ' Display Top Part of Title Screen
		'GOSUB DispMem
		IF TiDTFNames% = 0 THEN GOSUB TiDAbsNoFiles: GOTO TiDAbort

'===================================
' DISK CATALOG MAIN LOOP STARTS HERE
'===================================

TiDNextFileName:
		COLOR FC, BC
		
		IF TiDCurScreenRow% = 1 THEN TiDFirstFilename% = TiDCurFilename%   ' Get Number of first filename only
		GOSUB TiDDisplayRow  ' Display Current Row

		TiDCurFilename% = TiDCurFilename% + 1 ' Next Filename


		TiDLastScreenRow% = TiDCurScreenRow%      ' Save last Screen Row used
		TiDCurScreenRow% = TiDCurScreenRow% + 1  ' Next Screen Row
		IF TiDCurScreenRow% < TiDTotalScreenRows% + 1 AND TiDCurFilename% <= TiDTFNames% THEN GOTO TiDNextFileName

'===================================
' DISK CATALOG MAIN LOOP ENDS HERE
'===================================
'
' End of filenames
		GOSUB TiDBottomLine       ' Display Bottom Line
		TiDLastFilename% = TiDCurFilename% - 1' Get Number of Last used filename
		TiDCurFilename% = TiDFirstFilename%  ' Current filename is now first filename in screen

		TiDCurScreenRow% = 1
		IF TiDKeepCursBottom% = 0 THEN GOTO TiDLocateCursor2
		' Last key used was Arrow Down. Move Cursor and TiDFileNumber pointer to last filename in Screen
		TiDCurScreenRow% = TiDTotalScreenRows%: TiDKeepCursBottom% = 0: TiDCurFilename% = TiDLastFilename%
		GOTO TiDLocateCursor2
		
TiDLocateCursor:
		GOSUB TiDRestoreColor

TiDLocateCursor2:
		LOCATE TiDStartRow% + TiDCurScreenRow%, 2, 1
		COLOR HFC, HBC: GOSUB TiDDisplayRow: COLOR FC, BC' Display Current Row
		LOCATE TiDStartRow% + TiDCurScreenRow%, 2, 1
		TiDOldScreenRow% = TiDCurScreenRow%
		TiDOldFilename% = TiDCurFilename%
		IF TiDGoToThisDir% <> 0 THEN TiDCurFilename% = TiDGoToThisDir%: TiDGoToThisDir% = 0: GOTO TiDExecutit
		'GOSUB ShowValues    ' My little Debugger
		
TiDDoitAgain:   DO: U$ = UCASE$(INKEY$): LOOP UNTIL U$ <> ""
		IF INSTR(TiDAllowedKey$, U$) = 0 THEN GOTO TiDDoitAgain

		' ESCape Key
		IF U$ = CHR$(27) THEN GOTO TiDAbort
		
		
		' ENTER Key
		IF U$ <> CHR$(13) THEN GOTO TiDIsArrowDown
		IF TiDTotEr% > 0 AND TiDFileErrList$(TiDCurFilename%) <> "" THEN GOTO TiDOtherKey9B
		IF TiDCurFilename% > TiDActiveDirs% THEN GOTO TiDStartCopying
		IF TiDCurFilename% = TiDChosenDir% THEN GOTO TiDStartCopying
		IF TiDTotFiles2Copy% = 0 THEN GOTO TiDChangeDir
		
TiDChangeDir:   TiDChosenDir% = TiDCurFilename%
		TiDGoToThisDir% = TiDCurFilename%
		TiDCurrFileDescrIndex& = SubDirStAddr(TiDCurFilename%)
		CALL Fischio
		GOTO TiDNewSubDir

TiDIsArrowDown: ' Arrow Down Key
		IF U$ <> CHR$(0) + CHR$(80) THEN GOTO TiDOtherKey0
TiDIsArrowDown1: IF TiDCurScreenRow% < TiDLastScreenRow% THEN TiDCurScreenRow% = TiDCurScreenRow% + 1: TiDCurFilename% = TiDCurFilename% + 1: GOTO TiDLocateCursor
		IF TiDCurFilename% = TiDTFNames% THEN GOTO TiDLocateCursor
		TiDCurFilename% = TiDFirstFilename% + 1
		TiDKeepCursBottom% = 1
		IF TiDCurFilename% < 1 THEN TiDCurFilename% = 1
		GOTO TiDExecutit

TiDOtherKey0:   'Arrow up Key
		IF U$ <> CHR$(0) + CHR$(72) THEN GOTO TiDOtherKey1
		IF TiDCurFilename% = 1 THEN GOTO TiDNoMatch
		IF TiDCurScreenRow% > 1 THEN TiDCurScreenRow% = TiDCurScreenRow% - 1: TiDCurFilename% = TiDCurFilename% - 1: GOTO TiDLocateCursor
		TiDCurFilename% = TiDFirstFilename% - 1: IF TiDCurFilename% < 1 THEN TiDCurFilename% = 1
		GOTO TiDExecutit

TiDOtherKey1:   ' Page Up Key
		IF U$ <> CHR$(0) + CHR$(73) THEN GOTO TiDOtherKey2
		TiDCurFilename% = TiDFirstFilename% - TiDTotalScreenRows%
		IF TiDCurFilename% < 1 THEN TiDCurFilename% = 1
		GOTO TiDExecutit

TiDOtherKey2:   ' Page Down Key
		IF U$ <> CHR$(0) + CHR$(81) THEN GOTO TiDOtherKey4
		IF TiDLastFilename% + 1 + TiDTotalScreenRows% > TiDTFNames% THEN TiDCurFilename% = TiDTFNames% - TiDTotalScreenRows% + 1: IF TiDCurFilename% < 1 THEN TiDCurFilename% = 1: GOTO TiDExecutit
		TiDCurFilename% = TiDFirstFilename% + TiDTotalScreenRows%
		IF TiDCurFilename% > TiDTFNames% THEN TiDCurFilename% = TiDFirstFilename%
		GOTO TiDExecutit

TiDOtherKey4:    ' C or M 
		IF U$ <> "C" AND U$ <> "M" THEN GOTO TiDOtherKey5
		IF TiDCurFilename% <= TiDActiveDirs% THEN CALL ERRSOUND: GOTO TiDNoMatch
		IF CopyMark$(TiDCurFilename%) = " " THEN TiDTotFiles2Copy% = TiDTotFiles2Copy% + 1: GOSUB TiDSectorLength: TiDTotSizeFiles2Copy& = TiDTotSizeFiles2Copy& + TiDSectorLength&
		LOCATE TiDStartRow% + TiDCurScreenRow%, 2, 1
		COLOR HFC, HBC
		IF CopyMark$(TiDCurFilename%) = " " THEN CopyMark$(TiDCurFilename%) = "C": PRINT "C";
		GOSUB TiDDispFilestoCopy
		GOTO TiDIsArrowDown1
		
		
TiDOtherKey5:   ' CTRL U = Unmark all
		IF U$ <> CHR$(21) THEN GOTO TiDOtherKey6
		IF TiDActiveDirs% >1 THEN T = 2 ELSE T = 1 
		FOR T = T TO TiDTFNames%  ' Assume users wants to Copy all files
		CopyMark$(T) = " "
		NEXT T
		
		ToBeFreed%=0
		TiDTotFiles2Del% = 0
		TiDTotFiles2Copy% = 0
		TiDTotSizeFiles2Copy& = 0
		GOSUB TiDRePaintScreen
		GOTO TiDNoMatch

TiDOtherKey6:   ' CTRL A = Mark all
		IF U$ <> CHR$(1) AND U$ <> CHR$(3) THEN GOTO TiDOtherKey7
		FOR T = TiDActiveDirs% + 1 TO TiDTFNames%  ' Assume users wants to Copy all files
		IF CopyMark$(T) = " " THEN CopyMark$(T) = "C"
		NEXT T
		
		TiDTotFiles2Copy% = TiDTFNames%
		TiDTotSizeFiles2Copy& = TiDTotSectorFiles&
		GOSUB TiDRePaintScreen
		GOTO TiDNoMatch
		
TiDOtherKey7:   ' Home Key : simply move cursor to top
		IF U$ <> CHR$(0) + CHR$(71) THEN GOTO TiDOtherKey8
		TiDCurScreenRow% = 1: TiDCurFilename% = TiDFirstFilename%: GOTO TiDLocateCursor


TiDOtherKey8:   ' End Key : simply move cursor to bottom
		IF U$ <> CHR$(0) + CHR$(79) THEN GOTO TiDOtherKey9
		TiDCurScreenRow% = TiDLastScreenRow%: TiDCurFilename% = TiDLastFilename%
		GOTO TiDLocateCursor

TiDOtherKey9:   ' F3 = Show Error List
		IF U$ <> CHR$(0) + CHR$(61) THEN GOTO TiDOtherKey10
		IF TiDTotEr% = 0 OR TiDFileErrList$(TiDCurFilename%) = "" THEN GOTO TiDNoMatch
TiDOtherKey9B:  GOSUB TiDShowErrorList
		GOSUB TiDRePaintScreen
		GOTO TiDNoMatch
		
		

TiDOtherKey10:  ' F7 = Show Sector as Hex
		IF U$ <> CHR$(0) + CHR$(65) THEN GOTO TiDOtherKey11
		IF TiDCurFilename% <= TiDActiveDirs% THEN GOTO TiDNoMatch
		GOSUB TiDShowSector
		GOSUB TiDRePaintScreen
		GOTO TiDNoMatch

TiDOtherKey11:  ' 0-9 priority while copying
		IF U$ < "0" OR U$ > "9" THEN GOTO TiDOtherKey12
		IF TiDCurFilename% <= TiDActiveDirs% THEN CALL ERRSOUND: GOTO TiDNoMatch
		IF CopyMark$(TiDCurFilename%) = " " THEN
		TiDTotFiles2Copy% = TiDTotFiles2Copy% + 1
		GOSUB TiDSectorLength
		TiDTotSizeFiles2Copy& = TiDTotSizeFiles2Copy& + TiDSectorLength&
		END IF
		CopyMark$(TiDCurFilename%) = U$
		LOCATE TiDStartRow% + TiDCurScreenRow%, 2, 1
		COLOR HFC, HBC
		PRINT CopyMark$(TiDCurFilename%);
		GOSUB TiDDispFilestoCopy
		GOTO TiDIsArrowDown1
		
		
TiDOtherKey12:  ' DEL key
		IF U$ <> " " AND U$ <> CHR$(0) + CHR$(83) THEN GOTO TiDOtherKey13
		IF TiDActiveDirs% >1 AND TiDCurFilename% = 1 THEN GOTO TiDIsArrowDown1
		IF TiDCurFilename% <= TiDActiveDirs% THEN CopyMark$(TiDCurFilename%) = " " : GOTO TiDIsArrowDown1
		IF CopyMark$(TiDCurFilename%) <> "D" THEN GOTO TiDOtherKey12b
		CopyMark$(TiDCurFilename%) = " " 
		TiDTotFiles2Del% = TiDTotFiles2Del% - 1 
		GOSUB TiDSectorLength
		IF TiDSectorLength& > 32767 THEN TiDSectorLength& = 0
		ToBeFreed% = ToBeFreed% - TiDSectorLength& 
		LOCATE 4,52 
		PRINT ToBeFreed%;SPACE$(6-LEN(STR$(ToBeFreed%)));
		GOTO TiDOtherKey12c
		
		
		
TiDOtherKey12b:	IF CopyMark$(TiDCurFilename%) <> " " THEN TiDTotFiles2Copy% = TiDTotFiles2Copy% - 1: GOSUB TiDSectorLength: TiDTotSizeFiles2Copy& = TiDTotSizeFiles2Copy& - TiDSectorLength&
		CopyMark$(TiDCurFilename%) = " "
TiDOtherKey12c:	LOCATE TiDStartRow% + TiDCurScreenRow%, 2, 1
		COLOR HFC, HBC
		PRINT CopyMark$(TiDCurFilename%);
		GOSUB TiDDispFilestoCopy
		GOTO TiDIsArrowDown1
		
'========SHOW ARK FILE
TiDOtherKey13:  IF U$ <> CHR$(0) + CHR$(66) THEN GOTO TiDOtherKey14     ' F8 = I ARK file, display it
		IF TiDCurFilename% <= TiDActiveDirs% THEN GOTO TiDNoMatch
		
		IF ASC(MID$(FilName$(TiDCurFilename%), 18, 1)) <> 128 THEN GOTO TiDNoMatch
		FileType% = ASC(MID$(FilName$(TiDCurFilename%), 13, 1))
		FileType% = FileType% AND &H8B
		FileType% = FileType% AND &HF7
		SELECT CASE FileType%
		CASE 0, 2 ' "Dis/Fix"
		GOSUB TiDARKextract
		CLS
		COLOR HFC, HBC
		
		PRINT TAB(15); "Catalog of Archive File: "; MID$(FilName$(TiDCurFilename%), 1, 10)
		Exec$ = "Decomp4.com " + TempArk + " /s"
		SHELL Exec$
		COLOR FC, BC
		CLS
		END SELECT
		
		GOSUB TiDRePaintScreen
		GOTO TiDNoMatch
		
		
		
TiDOtherKey14:  ' F1 (Help) key
		IF U$ <> CHR$(0) + CHR$(59) THEN GOTO TiDOtherKey15
		CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "19.01.00")
		GOSUB TiDRePaintScreen
		GOTO TiDLocateCursor


TiDOtherKey15:  ' D = Mark a a File or Directory for later Delete
		IF U$ <> "D" THEN GOTO TiDOtherKey16
		IF TiDCurFilename% <= TiDActiveDirs% AND TiDCurFilename%=1 THEN GOTO TiDIsArrowDown1
		IF CopyMark$(TiDCurFilename%) <> " " THEN GOTO TiDIsArrowDown1
		CopyMark$(TiDCurFilename%) = U$ : PRINT U$;
		IF TiDCurFilename% <= TiDActiveDirs% THEN GOTO TiDOtherKey15c
		TiDTotFiles2Del% = TiDTotFiles2Del% + 1: GOSUB TiDSectorLength
		IF TiDSectorLength& > 32767 THEN TiDSectorLength& = 0
		ToBeFreed% = ToBeFreed% + TiDSectorLength& 
		LOCATE 4,52 
		PRINT ToBeFreed%;SPACE$(6-LEN(STR$(ToBeFreed%)));
		LOCATE TiDStartRow% + TiDCurScreenRow%, 2, 1
		' COLOR HFC, HBC
		GOSUB TiDDispFilestoCopy
TiDOtherKey15c:	GOTO TiDIsArrowDown1	
		
TiDOtherKey15h:	TiDCurrFileDescrIndex& = SubDirStAddr(TiDCurFilename%)
		CALL RWVirtualSect(TiDFileNum%, SubDirStAddr(TiDCurFilename%) + 1, d$,"") 
		'print "Sector= 0"; Hex$(SubDirStAddr(TiDCurFilename%));"h -------- "; SubDirStAddr(TiDCurFilename%) " ---------"
		'print ' : WHILE INKEY$ = "": WEND
		'CALL ShowHex(d$, K$)
		IF MID$(d$, 1, 2) = DBLNULL$ THEN GOTO TiDOtherKey15j
		A=10
		LOCATE TiDStartRow% + TiDCurScreenRow%, 2, 1
		PRINT "D";
 		

TiDOtherKey15j:	GOTO TiDNoMatch	
		
		
TiDOtherKey16:	' F6 = Proceed
		IF U$ <> CHR$(0) + CHR$(64) THEN GOTO TiDOtherKey17 ' F6 = Proceed
		' IF TiDTotFiles2Del% = 0 THEN GOTO TiDNoMatch
 		StartAgain$=""
 		
 		A=10
 		CALL box(A, 15, 50, 6)
 		LOCATE A + 2, 21 : PRINT "Delete all the ";CHR$(34);"D";CHR$(34);" marked items,"
 		LOCATE A + 3, 21 : PRINT "including subdirectories, if any? (Y/N) Y" 
 		LOCATE A + 3, 61 : DO: K$ = UCASE$(INKEY$): LOOP UNTIL K$ <> ""
 		PRINT K$
 		IF K$<>"Y" AND K$<>CHR$(13) THEN GOSUB TiDRePaintScreen: GOTO TiDNoMatch
		GOSUB TiDDelAllFilEs ' Delete all marked files 
		FOR T=1 TO TiDActiveDirs%	' Save SubDir Copy Marks
		ActDirsCopyMark$(T)=CopyMark$(T)
		NEXT T 
		
		IF TiDActiveDirs% < 2 THEN GOTO TiDOtherKey16j
		FOR DelCurrDir%=TiDActiveDirs% TO 2 STEP -1 
		IF CopyMark$(DelCurrDir%)<>"D" THEN GOTO TiDOtherKey16d
		TiDCurFilename%=DelCurrDir%
		GOSUB TiDDelDir		' Delete TiDCurFilename% Directory 
		FOR T=1 TO TiDActiveDirs% ' Restore SubDir Copy Marks
		CopyMark$(T)=ActDirsCopyMark$(T)
		NEXT T 
		
		
TiDOtherKey16d:	NEXT DelCurrDir%
		
TiDOtherKey16j:	IF StartAgain$<>"" THEN CLOSE #TiDFileNum% : GOTO StartAgain	
		GOSUB TiDRePaintScreen	
		GOTO TiDNoMatch	
		
		
		
TiDOtherKey17:	' CTRL D = Mark all for a Delete
		IF U$ <> CHR$(4) THEN GOTO TiDOtherKey18
		SavTiDCurFilename%= TiDCurFilename%
		FOR TiDCurFilename% = TiDActiveDirs% + 1 TO TiDTFNames%  ' Assume users wants to Copy all files
		IF CopyMark$(TiDCurFilename%) <> " " THEN GOTO TiDOtherKey17b
		CopyMark$(TiDCurFilename%) = "D"
		TiDTotFiles2Del% = TiDTotFiles2Del% + 1
		GOSUB TiDSectorLength
		IF TiDSectorLength& > 32767 THEN TiDSectorLength& = 0
		ToBeFreed% = ToBeFreed% + TiDSectorLength& 
		
TiDOtherKey17b:	NEXT TiDCurFilename%
		LOCATE 4,52 
		PRINT ToBeFreed%;SPACE$(6-LEN(STR$(ToBeFreed%)));
		TiDCurFilename%= SavTiDCurFilename%
		LOCATE TiDStartRow% + TiDCurScreenRow%, 2, 1
		GOSUB TiDRePaintScreen	
		GOTO TiDNoMatch
		
TiDOtherKey18: GOTO TiDNoMatch
		
TiDExecutit:	
		TiDCurScreenRow% = 1     ' Cursor on first screen row
		LOCATE TiDStartRow% + TiDCurScreenRow%, 2, 1
		GOTO TiDNextFileName   ' Start next round

TiDStartCopying:
TiDNoMatch:     GOTO TiDLocateCursor

' ******************
' DELETE A DIRECTORY	
' ******************
TiDDelDir:	
		'TiDChosenDir% = TiDCurFilename%
		'TiDGoToThisDir% = TiDCurFilename%
		LOCATE 3, 1, 1
 		TiDChosenDir% = TiDCurFilename%
		TiDGoToThisDir% = TiDCurFilename%
		TiDCurrFileDescrIndex& = SubDirStAddr(TiDCurFilename%)
		CALL Fischio
		GOSUB ReadNewDir	' Read Directory pointed by TiDCurrFileDescrIndex&
 		FOR TiDGG = TiDActiveDirs% + 1 TO TiDTFNames%  ' Assume users wants to Copy all files
		IF CopyMark$(TiDGG) = " " THEN CopyMark$(TiDGG) = "D"
		NEXT TiDGG
		GOSUB TiDDelAllFiles ' Delete all marked files
 		 		
 		
TiDDelDir1j: 	' Free the Sector belonging to the File Descriptor Record in Sector Zero Free/Used Bit-Map
 		TiDCurFilename%=TiDChosenDir%
		TiDStSec&=StartSect&(TiDChosenDir%)
		TiDOffs&=0
		GOSUB FreeTheseSectrs	' Free all TiDOffs& sectors starting from TiDStSec& sector
				FOR T = 2 TO TiDActiveDirs%
		W = CalcWord&(TiDSectorZero$, 31 + (12 * (T - 2)))
		IF W = StartSect&(TiDCurFilename%) THEN GOTO TiDDelDir1p
TiDDelDir1m: 	NEXT T
		
		
		GOTO TiDDelDir1z

TiDDelDir1p: 	IF TiDActiveDirs% = 1 THEN W = 0 : GOTO TiDDelDir1z
		FOR W=T TO TiDActiveDirs% - 1
		
		A$=MID$(TiDSectorZero$, 21 + (12 * (W - 2)) + 12, 12)
		MID$(TiDSectorZero$, 21 + (12 * (W - 2)))=A$
		NEXT W
TiDDelDir1t:	MID$(TiDSectorZero$, 21 + (12 * (W - 2))) = STRING$(12,CHR$(0))
		'A=10
		'CALL box(A, 22, 50, 10)
 		'LOCATE A + 1, 30 : PRINT "The chosen directory"
 		'LOCATE A + 3, 30 : PRINT MID$(FilName$(TiDCurFilename%), 1, 10)
 		'LOCATE A + 5, 30 : PRINT "has been deleted"
 		'LOCATE A + 7, 30 : PRINT "---- Press any key ----"
 		'LOCATE A + 7, 53 : WHILE INKEY$ = "": WEND
		CALL RWVirtualSect(TiDFileNum%, 1, TiDSectorZero$,"W") ' Write sector zero

TiDDelDir1z:	StartAgain$="Y"
		RETURN
		
	
			

		
' *********************** 		
' DELETE ALL MARKED FILES
' ***********************
TiDDelAllFiles:	
		FOR This2Del% = TiDActiveDirs% + 1 TO TiDTFNames% ' 
		IF CopyMark$(This2Del%) <> "D" THEN GOTO TiDDelAllFil2
'- DEBUG AID n. 8 -  PRINT #111, "Filename= ";MID$(FilName$(This2Del%),1,10)
		
 		GOSUB DelThisFile
 		StartAgain$="Y"	' Flag: at least one file has been deleted
TiDDelAllFil2:	NEXT This2Del%
		
		' Update Sector containing the Alpahabetical Index (usually Sector One)
		A = 0
		B = 0
		C = 0
 
		FOR T = TiDActiveDirs% + 1 TO TiDTFNames% ' Update Aphabetical Index Table (Sector One)
		IF MID$(TiDCurrFileDescrIdx$,B + 1, 2)=DBLNULL$ THEN C = 1 : GOTO TiDDelAllFil4

		IF C<>0 THEN MID$(TiDCurrFileDescrIdx$,A+1,2)=MID$(TiDCurrFileDescrIdx$,B+1,2)	
		A = A + 2		
TiDDelAllFil4:	B = B + 2 
		NEXT T
		
		MID$(TiDCurrFileDescrIdx$, A + 1, 256 - A) = STRING$(256 , CHR$(0)) 
		
		CALL RWVirtualSect(TiDFileNum%, TiDCurrFileDescrIndex& + 1, TiDCurrFileDescrIdx$,"W") ' Write Sector 1: Filename Table, alphabetically ordered
		CALL RWVirtualSect(TiDFileNum%, 1, TiDSectorZero$,"W") ' Write sector zero
		
		RETURN

' ***********
' INITIALIZE DIRECTORY ROUTINE 
' ***********
TiDInit: 
		FOR T = LEN(TiDDestinPath$) TO 1 STEP -1
		IF MID$(TiDDestinPath$, T, 1) = "\" THEN GOTO TiDBackFound
		NEXT T
		TiDPath$ = TiDDestinPath$
		GOTO TiDBackFound2
		
TiDBackFound:	TiDPath$ = LEFT$(TiDDestinPath$, T)

TiDBackFound2:	CALL ShortName(TiDSourcePath$)
		TiDSrcDOSName$ = TiDSourcePath$
		OPEN TiDSrcDOSName$ FOR BINARY ACCESS READ WRITE AS #TiDFileNum%
		ON ERROR GOTO 0
 			
		CALL RWVirtualZero(TiDFileNum%, d$,FTypeW$)
		TiDDskName$ = MID$(d$, 1, 10)
		MHFloppy$ = MID$(d$, 14, 3)
		
		IF FType$ <> "MH" THEN GOTO TiDPOI
		CALL MessHDDir(TiDFileNum%, d$)
		GOTO TiDSAbort
TiDPOI:  
		IF MHFloppy$ = "DSK" THEN GOTO TiDIdentFound
		
		CALL box(1, 4, 72, 10)
		LOCATE 2, 6, 1
		PRINT "TI-99/4A DiskName: "; TiDDskName$;
		LOCATE 4, 6, 1
		PRINT "Warning....";
		LOCATE 5, 6, 1
		PRINT "This file doesn't appear to be a true TI99/Geneve Disk Image File";
		LOCATE 6, 6, 1
		PRINT "('DSK' or 'WIN' missing in sector 0).";
		LOCATE 8, 6, 1
		PRINT "Do you still want to go on? (Y/N)";
		LOCATE 8, 40, 1
		DO: C$ = INKEY$: LOOP UNTIL C$ <> ""
		IF UCASE$(C$) = "Y" THEN GOTO TiDIdentFound ELSE GOTO TiDSAbort
		
TiDIdentFound:	TiDSectorZero$=d$
		TiDTotSect& = CalcWord&(d$, 11)
		TiDTracks% = ASC(MID$(d$, 18, 1))
		TiDSides% = ASC(MID$(d$, 19, 1)): IF TiDSides% = 0 THEN TiDSides% = 1
		TiDDens% = ASC(MID$(d$, 20, 1)): IF TiDDens% = 0 THEN TiDDens% = 1
		
		SELECT CASE LEFT$(FType$, 1)
		CASE "V"
		DiskType$ = "V9T9"
		CASE "P"
		DiskType$ = "PC99"
		CASE ELSE
		DiskType$ = "TI99-PC"
		END SELECT
		
		
		SELECT CASE TiDTotSect&
		CASE 0 TO 1600
		SectPerAU% = 1
		CASE 1601 TO 3200
		SectPerAU% = 2
		CASE 3201 TO 6400
		SectPerAU% = 4
		CASE 6401 TO 12800
		SectPerAU% = 8
		CASE 12801 TO 25600
		SectPerAU% = 16
		CASE ELSE 
		PRINT "Unkown Disk Capacity (";TiDTotSect&;"bytes)" 
		PRINT "- Press any key to abort -"
		WHILE INKEY$ = "": WEND
		GOTO TiDSAbort
		END SELECT
		
		
		TiDSideDensity$ = "(" + MID$("SD", TiDSides%, 1) + "S/" + MID$("SDH", TiDDens%, 1) + "D)"
		IF TiDTracks = 80 AND TiDDens% = 2 THEN MID$(TiDSideDensity$, 5, 1) = "Q"
		
		TiDCurrFileDescrIndex& = 1                        ' Sector containing the File Descriptor Index
		IF TiDTracks < 80 THEN GOTO TiDNoSubDirExist           ' Only 80 track Geneve disks can have sudirectories
		TiDChosenDir% = 1                                 ' Array element that is the Chosen Directory
		TiDActiveDirs% = 0
		FOR T = 1 TO 3
		W = CalcWord&(d$, 31 + (12 * (T - 1)))
		IF W = 0 THEN GOTO NextSubDir
		IF T = 1 THEN SubDirStAddr(1) = 1: SubDirName$(1) = "Root_Dir": TiDActiveDirs% = TiDActiveDirs% + 1
		TiDActiveDirs% = TiDActiveDirs% + 1
		SubDirStAddr(TiDActiveDirs%) = W: SubDirName$(TiDActiveDirs%) = MID$(d$, 21 + (12 * (T - 1)), 10)
NextSubDir:     NEXT T

TiDNoSubDirExist:
		TiDErrSect$ = ""
		IF LEFT$(FType$, 1) <> "V" THEN GOTO TiDNoSubDirPoss
		CALL RWVirtualSect(TiDFileNum%, TiDTotSect& + 1, d$,"")
		TiDErrSect$ = d$
		CALL RWVirtualSect(TiDFileNum%, TiDTotSect& + 2, d$,"")
		TiDErrSect$ = TiDErrSect$ + d$
		CALL RWVirtualSect(TiDFileNum%, TiDTotSect& + 3, d$,"")
		TiDErrSect$ = TiDErrSect$ + d$
		TiDTotEr% = VAL(MID$(TiDErrSect$, 13, 8))
TiDNoSubDirPoss:
		TiDFirstDestinPath$ = TiDDestinPath$ ' New Output Filename (just the name, nothing on disk!)
		GOTO TiDInitZ
		
TiDSAbort:	ABORT$="Y" 	' Abort after returning

TiDInitZ:	RETURN 

' ********************
' READ NEW DIRECTORY
' *********************
ReadNewDir:	CALL RWVirtualSect(TiDFileNum%, TiDCurrFileDescrIndex& + 1, d$,"") ' Get Sector 1: Filename Table, alphabetically ordered
		TiDCurrFileDescrIdx$=d$
		TiDTFNames% = 1           ' We have to work out how many filenames there are
TiDNextEl:      sn% = CalcWord&(d$, (TiDTFNames%) * 2 - 1)
		IF sn% <> 0 THEN TiDTFNames% = TiDTFNames% + 1: GOTO TiDNextEl
		TiDTFNames% = TiDTFNames% - 1 + TiDActiveDirs%  ' Well this is how many filenames we've got
		
		REDIM FilName$(TiDTFNames%)   ' DIM exactly our arrays
		REDIM StartSect&(TiDTFNames%)
		REDIM CopyMark$(TiDTFNames%)
		REDIM TiDFileErrList$(TiDTFNames%)

		FOR T = 1 TO TiDTFNames%    ' Assume user doesn't want to Extract any file
		CopyMark$(T) = " "
		IF TiDActiveDirs% > 0 AND T = TiDChosenDir% THEN CopyMark$(T) = ">"
		NEXT T
		
		FOR T = 1 TO TiDActiveDirs%    ' If Active Directories exist
		FilName$(T) = SubDirName$(T)
		StartSect&(T) = SubDirStAddr(T)
		NEXT T
		
		FOR T = TiDActiveDirs% + 1 TO TiDTFNames% ' Memorize Starting Sector of all filenames
		StartSect&(T) = CalcWord&(d$, (T - TiDActiveDirs%) * 2 - 1)
		NEXT T
		
		TiDTotSectorFiles& = 0
		ToBeFreed% = 0 
		' Get all Filenames with vital parameters
		FOR T% = TiDActiveDirs% + 1 TO TiDTFNames%
		CALL RWVirtualSect(TiDFileNum%, StartSect&(T%) + 1, d$,"")
		FilName$(T%) = MID$(d$, 1, 20)
		
		IF CalcWord&(FilName$(T%), 15) > 32767 THEN GOTO TiDNextTotal   ' PB 2004.06.05 - Handle FDR Error (BABA)
		TiDTotSectorFiles& = TiDTotSectorFiles& + CalcWord&(FilName$(T%), 15) + 1 	' PB 2004.06.05 - Handle FDR Error (BABA)
TiDNextTotal:	NEXT T%
		
		' CALL ShowHex(TiDErrSect$)
		' Work out which file has error, if any
		IF TiDTotEr% = 0 THEN GOTO TiDNoBadSector
		FOR J = 0 TO (TiDTotSect& / 8) - 1
		T$ = MID$(TiDErrSect$, 33 + J, 1)
		IF ASC(T$) = 0 THEN GOTO TiDNextByte
		FOR W = 0 TO 7
		IF ASC(T$) AND 2 ^ W THEN K = J * 8 + W: GOSUB TiDWorkOutWhichFile
		NEXT W
TiDNextByte:    NEXT J
		
TiDNoBadSector:
		RETURN 

'==================
' DELETE THIS FILE 
'==================
DelThisFile: 	
 
		CALL RWVirtualSect(TiDFileNum%, StartSect&(This2Del%) + 1, TiDFHeader$,"")
		' PRINT "TiDCurFilename= ";This2Del%-TiDActiveDirs%: WHILE INKEY$ = "": WEND
		IF MID$(TiDFHeader$, 1, 10)=STRING$(10,CHR$(&HBA)) THEN GOTO DelThisFile9 '' PB 2004.06.05 - Handle FDR Error (BABA) - 		
		TiDSectorCnt& = CalcWord&(TiDFHeader$, 15)
		IF TiDSectorCnt& > 32767 THEN GOTO DelThisFile9 '' PB 2004.06.05 - Handle FDR Error (BABA) - 		
		
		' Free Sectors belonging to the body of file in Sector Zero Free/Used Bit-Map
		Z = 0                         ' TiDOffset in Input File Chain Pointer Block
DelThisFile1:	GOSUB TiDCalcClusters	' Returns --> TiDStSec&=Start Sector Absolute Value
					' and     --> TiDOffs&=Number of sectors in this block
		IF TiDStSec& = 0 THEN GOTO DelThisFile8
		GOSUB FreeTheseSectrs	' Free all TiDOffs& sectors starting from TiDStSec& sector

		' Free Sectors 
		Z = Z + 3 
		GOTO DelThisFile1		
DelThisFile8: 		
		' Free the Sector belonging to the File Descriptor Record in Sector Zero Free/Used Bit-Map
		TiDStSec&=StartSect&(This2Del%)
		TiDOffs&=0
		GOSUB FreeTheseSectrs	' Free all TiDOffs& sectors starting from TiDStSec& sector
DelThisFile9:	FileIdx%= This2Del%-TiDActiveDirs%-1	
		MID$(TiDCurrFileDescrIdx$, ((FileIdx%)*2)+1) = DBLNULL$ ' Update Sector 1 (File Descriptor Index Record)
		
		RETURN 
		
' Free all TiDOffs& sectors starting from TiDStSec& sector
FreeTheseSectrs:		
'- DEBUG AID n. 8 -  PRINT #111, " TiDStSec&="; TiDStSec& ; " - TiDOffs&="; TiDOffs& ; " - SectPerAU%="; SectPerAU% 
 		
 		FOR T = TiDStSec& TO TiDStSec& + TiDOffs& 
 		AA% = INT(INT(T / SectPerAU%) / 8) 
 		EE% = (INT(T / SectPerAU%)) MOD 8
 		FF% = 255 XOR (2 ^ EE%) 
 		X1 = ASC(MID$(TiDSectorZero$, 56 + 1 + AA%, 1))     
 		X = X1 AND FF%                                           
 		OUT$  = " - AA%="+ STR$(AA%)+ " - BB%="+ STR$(BB%) + " - CC%=" + STR$(CC%)+ " - DD%="+ STR$(DD%)+ " - EE%="+ STR$(EE%)+ " - FF%="+ STR$(FF%)+ " - X1= " + STR$(X1) + " - X= "+STR$(X)
'- DEBUG AID n. 8 - PRINT #111, OUT$
		MID$(TiDSectorZero$, 56 + 1 + AA%, 1) = CHR$(X)		

		NEXT T		
		RETURN 
		 		
  		
'=================================
' DISPLAY TOP PART OF TITLE SCREEN
'=================================
TiDTopScreen:
		LOCATE 1, 6, 1
		PRINT "===== TI DISK CATALOG FROM F5 KEY, TO VIEW OR DELETE FILE NAMES ====="
		LOCATE 2, 1
		PRINT "TI-99/4A DiskName:"; TiDDskName$; "    Sectors:"; TiDTotSect&; " TiDTracks:"; TiDTracks%; " TiDSides:"; TiDSides%; " TiDDens:"; TiDDens%;
		LOCATE 3, 1
		PRINT DiskType$;" Source File= "; TiDSourcePath$;
		PRINT TAB(60); "Files="; TiDTFNames%;
		PRINT TAB(71); TiDSideDensity$
		LOCATE 4, 1
		
		PRINT "Disk Image File type = "; DiskType$; TAB(40); "To be Freed:";ToBeFreed%; TAB(60); "Used:"; TAB(71); "Bad:"; TiDTotEr%
		LOCATE 4, 65
		PRINT TiDTotSectorFiles&
		LOCATE 5, 1
		PRINT "Ŀ"
		PRINT "  n. Filename  P TSect Length  Type           Select:      Sectors:        "
		PRINT "Ĵ"
		GOSUB TiDDispFilestoCopy
		IF TiDTotEr% = 0 THEN GOTO IfSomeFileName
		LOCATE 6, 51
		PRINT "- Bad Sectors Full List = F3";
		
IfSomeFileName:
		LOCATE 22, 1
		'PRINT "Enter=Execute. C,M=Select, CTRL A=Select All, CTRL U=UnSel.All, 0=Served first,"
		PRINT "ESC=Exit, Cursor=ArrUp,Dwn,PagUp,Dwn. F1=Help. F7= File Hex Sector Viewer,"
		LOCATE 23, 1
		PRINT "F8= Cat ARK File, D=Delete Mark, Ctrl D=Del All, Ctrl U=Unsel All, F6=Proceed.";
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
TiDDisplayRow:
		LOCATE TiDStartRow% + TiDCurScreenRow%, 1, 1
		'PRINT "                                                                              "
		PRINT ""; CopyMark$(TiDCurFilename%); "";
		PRINT USING "###"; TiDCurFilename%;
		PRINT ""; MID$(FilName$(TiDCurFilename%), 1, 10);
		
		IF MID$(FilName$(TiDCurrentFilename%), 1, 10)=STRING$(10,CHR$(&HBA)) THEN GOTO TiDBadSectorList '' PB 2004.06.05 - Handle FDR Error (BABA) - 		
		IF TiDCurFilename% > TiDActiveDirs% THEN GOTO TiDNoSubDirs
		IF TiDCurFilename% = TiDChosenDir% THEN PRINT TAB(19); "< Active Dir >";
		PRINT TAB(34); ".. <Dir>.."; TAB(49); "";
		GOTO NoTiDErrSectInFile
TiDNoSubDirs:

		FileType% = ASC(MID$(FilName$(TiDCurFilename%), 13, 1))
		FileType% = FileType% AND &H8B         ' Get rid of reserved bits: 2,4-6
		IF FileType% AND 8 THEN TiDFileProt$ = "P" ELSE TiDFileProt$ = "_"
		FileType% = FileType% AND 247

		SELECT CASE FileType%
		CASE 0
		FileType$ = "Dis/Fix"
		CASE 1
		FileType$ = "Program"
		CASE 2
		FileType$ = "Int/Fix"
		CASE 128
		FileType$ = "Dis/Var"
		CASE 130
		FileType$ = "Int/Var"
		CASE ELSE
		FileType$ = "unknown"
		END SELECT


		TiDSectorLength& = CalcWord&(FilName$(TiDCurFilename%), 15) + 1
		TiDEOFTiDOffset% = ASC(MID$(FilName$(TiDCurFilename%), 17, 1))
		TiDFileLength& = TiDSectorLength& - 1
		TiDFileLength& = TiDFileLength& * MHSecLen%
		IF FileType% < 128 THEN TiDFileLength& = TiDFileLength& - 256 + TiDEOFTiDOffset%
		TiDLogRecLength% = ASC(MID$(FilName$(TiDCurFilename%), 18, 1))

		' PRINT TiDEOFTiDOffset%;
		PRINT " "; TiDFileProt$;
		PRINT USING "####"; TiDSectorLength&;
		PRINT USING "#########"; TiDFileLength&;
		PRINT " "; FileType$;
		IF TiDLogRecLength% > 0 THEN PRINT USING "####"; TiDLogRecLength%;

		LOCATE TiDStartRow% + TiDCurScreenRow%, , 1
		PRINT TAB(49); "";
TiDBadSectorList:
		IF TiDFileErrList$(TiDCurFilename%) = "" THEN GOTO NoTiDErrSectInFile
		

		PRINT TAB(50); "Err=";
		FOR J = 1 TO LEN(TiDFileErrList$(TiDCurFilename%)) STEP 2
		IF J > 8 THEN PRINT ",..."; : GOTO NoTiDErrSectInFile
		K = CalcWord&(TiDFileErrList$(TiDCurFilename%), J)
		IF J > 1 THEN PRINT ",";
		PRINT RTRIM$(LTRIM$(STR$(K)));
		NEXT J
		
NoTiDErrSectInFile:
		
		PRINT TAB(80); "";
		RETURN
'====================
' DISPLAY BOTTOM LINE
'====================
TiDBottomLine:
		PRINT
		PRINT ""
		
		LOCATE TiDStartRow% + TiDCurScreenRow% + 1, 1, 1

		IF TiDCurScreenRow% > TiDTotalScreenRows% THEN GOTO DOSSkipClear ' Blank all unused screen rows, if any

		FOR V = TiDCurScreenRow% TO TiDTotalScreenRows%
		PRINT "                                                                                "
		NEXT V
DOSSkipClear:
		RETURN

'=========================
' REDRAW THE ENTIRE SCREEN
'=========================
TiDRePaintScreen:

		GOSUB TiDTopScreen ' Display Top Part of Title Screen
		TiDSaveCurrFilename% = TiDCurFilename%
		TiDSavCurrScreenRow% = TiDCurScreenRow%
		TiDCurFilename% = TiDFirstFilename%
		FOR TiDCurScreenRow% = 1 TO TiDTotalScreenRows%
		GOSUB TiDDisplayRow  ' Display Current Row
		TiDCurFilename% = TiDCurFilename% + 1 ' Next Filename
		TiDLastScreenRow% = TiDCurScreenRow%      ' Save last Screen Row used
		IF TiDCurFilename% > TiDTFNames% THEN TiDCurScreenRow% = TiDCurScreenRow% + 1: GOTO TiDRePaintScreen2
		NEXT TiDCurScreenRow%   ' Next Screen Row
TiDRePaintScreen2: 
		GOSUB TiDBottomLine        ' Display Bottom Line
		TiDCurFilename% = TiDSaveCurrFilename%
		TiDCurScreenRow% = TiDSavCurrScreenRow%
		RETURN


TiDRestoreColor: TiDTempScreenRow% = TiDCurScreenRow%
		TempFilename% = TiDCurFilename%
		TiDCurScreenRow% = TiDOldScreenRow%
		TiDCurFilename% = TiDOldFilename%
		COLOR FC, BC: GOSUB TiDDisplayRow' Display Current Row
		TiDCurScreenRow% = TiDTempScreenRow%
		TiDCurFilename% = TempFilename%
		RETURN


TiDDispFilestoCopy: ' Display total files to be copied
		'LOCATE 4, 72, 1
		'PRINT TiDTotFiles2Copy%; "  ";
		RETURN


'=====================================
' Work out which file has a bad sector
' ====================================
TiDWorkOutWhichFile:
		K$=STRING$(256,&HBA)			' PB 2004.06.05 - Handle FDR Error (BABA) - 
		FOR TiDFileToCopy% = 1 TO TiDTFNames%
		CALL RWVirtualSect(TiDFileNum%, StartSect&(TiDFileToCopy%) + 1, d$,"")
		TiDFHeader$ = d$
		IF TiDFHeader$=K$ THEN K = StartSect&(TiDFileToCopy%) : GOSUB TiDMarkErrFileIF : GOTO TiDWorkOutNext ' PB 2004.06.05 - Handle FDR Error (BABA) - 
		TiDSectorCnt& = CalcWord&(TiDFHeader$, 15)
		TiDOldOffs& = 0
		Z = 0
		
TiDNextChain:   IF Z > 227 THEN K = StartSect&(TiDFileToCopy%) : GOSUB TiDMarkErrFileIF : GOTO TiDWorkOutNext ' PB 2004.06.05 - Handle FDR Error (BABA) -         
		GOSUB TiDCalcClusters
		TiDCurrOffs& = TiDOffs& - TiDOldOffs&
		IF TiDStSec& = 0 THEN GOTO TiDWorkOutNext
		IF K >= TiDStSec& AND K <= TiDStSec& + TiDCurrOffs& THEN GOSUB TiDMarkErrFile: GOTO TiDWorkOutEnd
		TiDOldOffs& = TiDOffs&
		Z = Z + 3: GOTO TiDNextChain
TiDWorkOutNext:         
		NEXT TiDFileToCopy%
TiDWorkOutEnd:
		RETURN

TiDAbsNoFiles:
		IF DelDone$<>"" THEN CALL box(6, 1, 79, 16)
		A = 10
		CALL box(A, 10, 66, 8)
		A$="THIS DISK, "+ TiDSourcePath$ + " IS EMPTY"
		IF DelDone$<>"" THEN A$=A$ + " NOW"
		LOCATE A + 2, 14: PRINT A$
		
		LOCATE A + 3, 14: PRINT STRING$(LEN(A$),"")
		LOCATE A + 4, 14: PRINT "No file inside ";
		IF DelDone$<>"" THEN PRINT "any more" 
		LOCATE A + 5, 14: PRINT "Press any key to exit"
		WHILE INKEY$ = "": WEND
		
		RETURN

TiDSectorLength:    ' Calculate file length, in sectors
		TiDSectorLength& = CalcWord&(FilName$(TiDCurFilename%), 15) + 1
		RETURN

TiDShowErrorList:
		CALL box(8, 20, 50, 13)
		LOCATE 9, 30: PRINT "Bad Sector List, File:"; MID$(FilName$(TiDCurFilename%), 1, 10)
		LOCATE 11 + W, 22: PRINT ""
		W = 0: A = 0
		LOCATE 11 + W, 22
		
		FOR J = 1 TO LEN(TiDFileErrList$(TiDCurFilename%)) STEP 2
		IF W > 8 THEN PRINT "..."; : GOTO TiDShowErrorList2
		K = CalcWord&(TiDFileErrList$(TiDCurFilename%), J)
		IF A > 0 THEN PRINT ",";
		PRINT RTRIM$(LTRIM$(STR$(K)));
		A = A + 1
		IF A > 8 THEN A = 0: W = W + 1: LOCATE 11 + W, 22
		NEXT J
TiDShowErrorList2:
		WHILE INKEY$ = "": WEND
		
NoTiDShowErrorList:
		RETURN
		'========SHOW SECTORS 
TiDShowSector:  CALL box(8, 3, 76, 13)
   
		LOCATE 8, 30: COLOR HFC, HBC: PRINT " - HEX SECTOR VIEWER - "; : COLOR FC, BC
		CALL RWVirtualSect(TiDFileNum%, StartSect&(TiDCurFilename%) + 1, d$,"")
		TiDFHeader$ = d$
		IF CalcWord&(TiDFHeader$, 15) > 32767 GOTO TiDShowSectorEnd	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		FileLength%=CalcWord&(TiDFHeader$, 15)
		LOCATE 9, 5:  PRINT "File: "; MID$(TiDFHeader$, 1, 10); "-Length:";FileLength% ;
		TiDSectorCnt& = CalcWord&(TiDFHeader$, 15)
		TiDGlobalInpOffset& = 0       ' GLOBAL TiDOffset in Input  File Chain Pointer Block
		TiDBlockOffset& = 0           ' TiDOffset of all the blocks so far in Input  File Chain Pointer Block
		Z = 0                         ' TiDOffset in Input File Chain Pointer Block
		K$ = "Y"
		
TiDShowSector2: GOSUB TiDCalcClusters
		TiDBlockOffset& = TiDBlockOffset& + TiDOffs& 
TiDShowSector2z: IF TiDStSec& > 0 THEN GOTO TiDShowSector3
		LOCATE 19, 30: PRINT " = End of File =";
TiDShowSector2a:    DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		IF K$ = CHR$(27) THEN GOTO TiDShowSectorEnd
		IF K$ = CHR$(0) + CHR$(72) THEN GOTO TiDShowSector2b
		IF K$ = CHR$(0) + CHR$(73) THEN GOTO TiDShowSector2b
		GOTO TiDShowSector2a
TiDShowSector2b:  K$ = ""
		Z = Z - 3
		TiDGlobalInpOffset& = TiDGlobalInpOffset& - 1
		GOSUB TiDCalcClusters
		TiDOffsVal% = TiDOffs&
		GOTO TiDShowSector3a
		
TiDShowSector3:
		IF TiDGlobalInpOffset& > TiDBlockOffset& THEN Z = Z + 3: GOTO TiDShowSector2
TiDShowSector3a: CALL RWVirtualSect(TiDFileNum%, TiDStSec& + TiDOffsVal% + 1, d$,"")

TiDShowSector3a2:
		LOCATE 9, 35: PRINT " -This Skt: "; TiDStSec& + TiDOffsVal%; " >"; HEX$(TiDStSec& + TiDOffsVal%); " - Skt Off.:"; TiDGlobalInpOffset&;
		LOCATE 19, 30: PRINT "                      ";
		CALL ShowHex(d$, K$)
		IF K$ = CHR$(27) THEN GOTO TiDShowSectorEnd
		IF K$ = CHR$(0) + CHR$(72) THEN GOTO TiDShowSector3b
		IF K$ = CHR$(0) + CHR$(73) THEN GOTO TiDShowSector3b
		GOTO TiDShowSector4
TiDShowSector3b:      
		IF TiDGlobalInpOffset& > 0 THEN K$ = ""
		IF TiDGlobalInpOffset& = 0 THEN GOTO TiDShowSector3
TiDShowSector3c: TiDGlobalInpOffset& = TiDGlobalInpOffset& - 1
		TiDOffsVal% = TiDOffsVal% - 1
		IF TiDOffsVal% >= 0 THEN GOTO TiDShowSector3a
		Z = Z - 3
		TiDBlockOffset& = TiDBlockOffset& - TiDOffs& 
		GOSUB TiDCalcClusters
		TiDOffsVal% = TiDOffs&
		GOTO TiDShowSector2z
		
TiDShowSector4: 
		IF TiDGlobalInpOffset& < FileLength% THEN GOTO TiDShowSector5
		
		LOCATE 19, 30: PRINT " = End of This File =";
TiDShowSector4a: DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		IF K$ = CHR$(27) THEN GOTO TiDShowSectorEnd
		IF K$ = CHR$(0) + CHR$(72) THEN K$="" : GOTO TiDShowSector3a2:
		IF K$ = CHR$(0) + CHR$(73) THEN K$="" : GOTO TiDShowSector3c
		GOTO TiDShowSector4a
		
		
TiDShowSector5:		
		TiDOffsVal% = TiDOffsVal% + 1           ' TiDOffset in EACH Input  File Chain Pointer Block
		TiDGlobalInpOffset& = TiDGlobalInpOffset& + 1
		GOTO TiDShowSector3
		
TiDShowSectorEnd:
		RETURN

' Prepare file to be cataloged upon by LZW decompressor
TiDARKextract:  CALL RWVirtualSect(TiDFileNum%, StartSect&(TiDCurFilename%) + 1, d$,"")
		TiDFHeader$ = d$
		TiDSectorLength& = CalcWord&(FilName$(TiDCurFilename%), 15) + 1
		Z = 0                      ' TiDOffset in Input File Chain Pointer Block
		TiDGlobalInpOffset& = 0       ' GLOBAL TiDOffset in Input  File Chain Pointer Block
		TiDSectorCnt& = TiDSectorLength& - 1' Sector Length of this file
		OPEN TempArk FOR BINARY ACCESS WRITE AS #2
		CLOSE #2
		KILL TempArk
		OPEN TempArk FOR BINARY ACCESS WRITE AS #2
		GOSUB TiDDoDisFix2
		RETURN

' =============================================================================
' ' FREE SECTORS BELONGING TO THE BODY OF FILE IN SECTOR ZERO FREE/USED BIT-MAP
' =============================================================================
FreeSectors:	

		

		RETURN 





'===============================================
' CALCULATE CURRENT ENTRY IN CHAIN POINTER TABLE
'===============================================
' The second 3 nibble block contains the highest TiDOffsET within each Chain Block.
' This value must never be higher than TiDSectorCnt& - 1, which is the file total length - 2,
' as it appears on Disk Catalog.
' This corrects the bug on 80 track disks, that have the last second 3 nibble block wrong on
' ODD LENGTH FILES (1 sector longer).
' If not corrected, this bug would create an error on lower size disks.

TiDCalcClusters: IF Z > 227 THEN TiDStSec& = 0 : GOTO TiDCalcClustend  	' PB 2004.06.05 - Handle FDR Error (BABA) -    
		A = ASC(MID$(TiDFHeader$, 28 + 1 + Z, 1))
		B = ASC(MID$(TiDFHeader$, 29 + 1 + Z, 1))
		C = ASC(MID$(TiDFHeader$, 30 + 1 + Z, 1))
		BA% = B MOD 16
		BB% = INT(B / 16)
		TiDStSec& = BA% * 256 + A
		IF TiDTotSect& > 3000 THEN TiDStSec& = TiDStSec& * 4
		TiDOffs& = C * 16 + BB
		
		IF TiDOffs& > TiDSectorCnt& - 1 THEN TiDOffs& = TiDSectorCnt& - 1
		TiDOffsVal% = 0               ' TiDOffset in EACH Input  File Chain Pointer Block
		
		GOTO TiDCalcClustend     ' Skip the below check, which has been superseeded by the simpler
		' above approach:  IF TiDOffs& > TiDSectorCnt& - 1 THEN TiDOffs& = TiDSectorCnt& - 1
		' Nonetheless, I leave it where it is because it might be still needed for some
		' 80 track disks that have a wrong file length, beTiDSides having
		' a wrong chain point table length.
		
' 
' Special case: in a 80 track Double Side Disk, when file length is EVEN (TiDSectorLength& in my code), the
' Chain Point Table reports 1 sector more than what it should. When copying, we have to avoid using
' that extra sector. Method: always check if there is a next Data Chain. If there is, do nothing. Otherwise,
' that means we are are the end of the Data Chain, and we have to use a sector less.
' TiDSectorLength&

		
		IF TiDDens% < 2 OR TiDTracks < 80 THEN GOTO TiDCalcClustend
		IF TiDSectorLength& <> (INT(TiDSectorLength& / 2)) * 2 THEN GOTO TiDCalcClustend
		A = ASC(MID$(TiDFHeader$, 28 + 1 + Z + 3, 1))
		B = ASC(MID$(TiDFHeader$, 29 + 1 + Z + 3, 1))
		C = ASC(MID$(TiDFHeader$, 30 + 1 + Z + 3, 1))
		IF A <> 0 OR B <> 0 OR C <> 0 THEN GOTO TiDCalcClustend
		TiDOffs& = TiDOffs& - 1
TiDCalcClustend:
		
		RETURN
		
' Mark File containing Error: To save memory, a couple of bytes (CHR$) each bad sector
TiDMarkErrFile:
		MSB% = INT(K / 256)
		LSB% = K MOD 256
		TiDFileErrList$(TiDFileToCopy%) = TiDFileErrList$(TiDFileToCopy%) + CHR$(MSB%) + CHR$(LSB%)
		RETURN
		
' Mark File containing Error in FDR	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
TiDMarkErrFileIF:				' PB 2004.06.05 - Handle FDR Error (BABA) - 
		MSB% = INT(K / 256)	' PB 2004.06.05 - Handle FDR Error (BABA) - 
		LSB% = K MOD 256	' PB 2004.06.05 - Handle FDR Error (BABA) - 
		A$=CHR$(MSB%) + CHR$(LSB%)	' PB 2004.06.05 - Handle FDR Error (BABA) - 
		IF LEN(TiDFileErrList$(TiDFileToCopy%))>0 AND RIGHT$(TiDFileErrList$(TiDFileToCopy%),2)=A$ THEN GOTO TiDMarkErrFileIF2 ' PB 2004.06.05 - Handle FDR Error (BABA) - 
		TiDFileErrList$(TiDFileToCopy%)= TiDFileErrList$(TiDFileToCopy%)+ A$	' PB 2004.06.05 - Handle FDR Error (BABA) - 
TiDMarkErrFileIF2:	RETURN			' PB 2004.06.05 - Handle FDR Error (BABA) - 
					
		
TiDDoDisFix:    OPEN TiDPath$ + FOut$ FOR BINARY ACCESS WRITE AS #2
TiDDoDisFix2:   Z = 0: Tog% = 1: BytePos& = 1: TRecs& = 0
		TiDTotRecs& = ASC(MID$(TiDFHeader$, 20, 1)) * 256 + ASC(MID$(TiDFHeader$, 19, 1))
		TiDRecsInSect% = ASC(MID$(TiDFHeader$, 14, 1))
		TiDLogRecLength% = ASC(MID$(TiDFHeader$, 18, 1))
		
		' Special case: Archiver III files are sometimes bugged. The Total Records (Bytes 19+20 in FDR)
		' sometimes report 256 records less than what it should.
		' The following patch compares the Total Records
		' with the Total Sector*2 which, in a dis/fix 128 record should be more or less comparable.
		' If this is not the case, adds 256 bytes to previous value
		' TiDTotRecs&=0:GOTO TiDNextClusterDF
		
		IF TiDLogRecLength% <> 128 THEN GOTO TiDNextClusterDF
		T& = (TiDSectorCnt& - 1) * 2
		IF T& <= TiDTotRecs& THEN GOTO TiDNextClusterDF
		TiDTotRecs& = TiDTotRecs& + 256
		' PRINT " (fixed!)";
		' print  "Total Records="; TiDTotRecs&  :input c$
		
TiDNextClusterDF:   GOSUB TiDCalcClusters
		IF TiDStSec& = 0 THEN GOTO TiDEOThisFileDF
		
TiDNextOffsValDF:
		
		IF TiDGlobalInpOffset& > TiDOffs& THEN Z = Z + 3: GOTO TiDNextClusterDF
		CALL RWVirtualSect(TiDFileNum%, TiDStSec& + TiDOffsVal% + 1, d$,"")
		GOSUB TiDRecToDoDF
		IF TiDTotRecs& < 1 THEN GOTO TiDEOThisFileDF
		TiDOffsVal% = TiDOffsVal% + 1           ' TiDOffset in EACH Input  File Chain Pointer Block
		TiDGlobalInpOffset& = TiDGlobalInpOffset& + 1
		
		' DoneSect=DoneSect+1: PRINT TiDTotRecs&;DoneSect; TiDGlobalInpOffset&
		
		GOTO TiDNextOffsValDF

TiDEOThisFileDF:
		CLOSE #2
		
		RETURN

' Transfer a Dis/Var record (Text)
TiDRecToDoDF:               ROff% = 1

TiDRecToDoDFAG:             FOR RT% = 1 TO TiDRecsInSect%
		DFRec$ = MID$(d$, ROff%, TiDLogRecLength%)
		PUT #2, BytePos&, DFRec$: BytePos& = BytePos& + TiDLogRecLength%
		ROff% = ROff% + TiDLogRecLength%
		TiDTotRecs& = TiDTotRecs& - 1
		TRecs& = TRecs& + 1
		IF TiDTotRecs& < 1 THEN GOTO TiDRecDoneDF
		NEXT RT%
		
TiDRecDoneDF:                  RETURN

' Exit point with F9
TiDAbort:       'MyName$(12) = ""
     		'MyName$(12) = TiDSourcePath$
    		ERASE FilName$
		CLOSE #TiDFileNum%
		COLOR 7, 0
END SUB

DEFINT A-Z
SUB MessHDDir (FileNum%, d$) ' Parameters: Filenumber, Sector zero
		
		
		SectPerAU% = INT(ASC(MID$(d$, 17, 1)) / 16) + 1
		TotAU! = CalcWord&(d$, 11)
		TotSect& = TotAU! * SectPerAU%
		DskName$ = Shrink$(UCASE$(MID$(d$, 1, 10)))
		CurrFileDescrIndex& = 0
		SectTracks%=ASC(MID$(d$, 13, 1))
		Heads%=(ASC(MID$(d$, 17, 1)) AND 15 ) + 1
		MessPath$="\"
MHNewSubDir:
		CALL RWVirtualSect(FileNum%, CurrFileDescrIndex&, d$,"")
		MHFiles% = ASC(MID$(d$, 23, 1))                  ' Total Files in this directory
		MHSubDirs% = ASC(MID$(d$, 24, 1))                ' Total Directories in this directory
		MHFilesPtr& = CalcWord&(d$, 25) * SectPerAU%     ' Pointer to Filename Table in this directory
		MHDSK1EmulPtr& = CalcWord&(d$, 27) * SectPerAU%  ' Pointer to DSK1 Emulated in this directory
		NowDir$ = UCASE$(MID$(d$, 14, 3))
		
		DiskType$ = "MESS HARD DISK"
		
		'CALL  MHKeybSectr (FileNum%)
		
		
		
		CurrFileDescrIndex& = 1                        ' Sector containing the File Descriptor Index
		ChosenDir% = 1                                 ' Array element that is the Chosen Directory
		ActiveDirs% = MHSubDirs%
		IF NowDir$ <> "DIR" AND MHDSK1EmulPtr& <> 0 THEN ActiveDirs% = ActiveDirs% + 1
		IF UCASE$(MID$(d$, 14, 3)) = "DIR" THEN ActiveDirs% = ActiveDirs% + 1
		TFNames% = MHFiles% + ActiveDirs%
		
		REDIM FilName$(TFNames%)   ' DIM exactly our arrays
		REDIM StartSect&(TFNames%)
		REDIM CopyMark$(TFNames%)
		
		Z = 0
		IF NowDir$ = "DIR" THEN StartSect&(1) = MHDSK1EmulPtr&: FilName$(1) = "..": Z = Z + 1: GOTO MHNewSubDir2
		IF MHDSK1EmulPtr& = 0 THEN GOTO MHNewSubDir2
		StartSect&(1) = MHDSK1EmulPtr&
		CALL RWVirtualSect(FileNum%, MHDSK1EmulPtr&, Tmp$,"")
		FilName$(1) = MID$(Tmp$, 1, 10)
		Z = Z + 1
		
MHNewSubDir2:        
		ChosenDir% = 0
		
		FOR T = 1 TO MHSubDirs%
		Tmp& = CalcWord&(d$, 29 + ((T - 1) * 2)) * SectPerAU%
		CALL RWVirtualSect(FileNum%, Tmp&, Tmp$,"")
		StartSect&(T + Z) = Tmp&
		FilName$(T + Z) = MID$(Tmp$, 1, 10)
MHNextSubDir:    NEXT T
		
		'FOR T = 1 TO MHSubDirs% + 1
		'PRINT FilName$(T); StartSect&(T)
		'NEXT T
		'INPUT CCC$
:
		FirstDestinPath$ = DestinPath$ ' New Output Filename (just the name, nothing on disk!)

		FOR T = 1 TO TFNames%     ' Assume users doesn't want to Extract any file
		CopyMark$(T) = " "
		IF ActiveDirs% > 0 AND T = ChosenDir% THEN CopyMark$(T) = ">"
		NEXT T

		
		'FOR T = ActiveDirs% + 2 TO TFNames%  ' Memorize Starting Sector of all filenames
		
		'StartSect&(T) = CalcWord&(d$, (T - ActiveDirs%) * 2 - 1)
		'NEXT T
		
		TotSectorFiles& = 0
		CALL RWVirtualSect(FileNum%, MHFilesPtr&, d$,"")
		' Get all Filenames with vital parameters
		FOR T = 1 TO MHFiles%
		Tmp& = CalcWord&(d$, ((T - 1) * 2) + 1) * SectPerAU%
		CALL RWVirtualSect(FileNum%, Tmp&, Tmp$,"")
		StartSect&(ActiveDirs% + T) = Tmp&
		FilName$(ActiveDirs% + T) = MID$(Tmp$, 1, 40) ' 20 bytes more than on a Floppy
		
		
		TotSectorFiles& = TotSectorFiles& + CalcWord&(FilName$(ActiveDirs% + T%), 15)
		NEXT T
		
MHNoBadSector:
		' Prepare to show all filenames
		CurrentScreenRow% = 1
		CurrentFilename% = 1
		FirstFilename% = 1
		KeepCursBottom% = 0

		TotalScreenRows% = 13     ' Rows to display Filenames
		StartRow% = 7  ' Screen Start Row
		TotFiles2Copy% = 0
		TotSizeFiles2Copy& = 0                         ' Added on August 27, 2003 from a tip of Ben Yates. Thank you, Ben!
		AllowedKey$ = CHR$(27)                         ' ESC
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(72) ' Arrow Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(80) ' Arrow Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(73) ' Page Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(81) ' Page Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(83) ' Del
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(71) ' Home
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(79) ' End
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(59) ' F1 = Help
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(61) ' F3 = Show Bad Sector
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(65) ' F7 = Show Bad Sector
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(66) ' F8 = Show ARK file directory, if applicable
		AllowedKey$ = AllowedKey$ + CHR$(21)           ' CTRL U = Unmark All
		AllowedKey$ = AllowedKey$ + CHR$(1)            ' CTRL A = Copy All
		AllowedKey$ = AllowedKey$ + CHR$(3)            ' CTRL C
		AllowedKey$ = AllowedKey$ + CHR$(13)           ' Enter = Execute
		AllowedKey$ = AllowedKey$ + "CcMm1234567890 "            ' CcMmXx + Blank +1234567890
		
		GOSUB MHTopScreen ' Display Top Part of Title Screen
		'GOSUB DispMem
		IF TFNames% = 0 THEN GOSUB MHAbsNoFiles: GOTO MessHDDirExit

'===================================
' DISK CATALOG MAIN LOOP STARTS HERE
'===================================

MHNextFileName:
		COLOR FC, BC
		
		IF CurrentScreenRow% = 1 THEN FirstFilename% = CurrentFilename%   ' Get Number of first filename only
		GOSUB MHDisplayRow  ' Display Current Row

		CurrentFilename% = CurrentFilename% + 1 ' Next Filename


		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		CurrentScreenRow% = CurrentScreenRow% + 1  ' Next Screen Row
		IF CurrentScreenRow% < TotalScreenRows% + 1 AND CurrentFilename% <= TFNames% THEN GOTO MHNextFileName

'===================================
' DISK CATALOG MAIN LOOP ENDS HERE
'===================================
'
' End of filenames

		GOSUB MHBottomLine       ' Display Bottom Line
		LastFilename% = CurrentFilename% - 1' Get Number of Last used filename
		CurrentFilename% = FirstFilename%  ' Current filename is now first filename in screen

		CurrentScreenRow% = 1
		IF KeepCursBottom% = 0 THEN GOTO MHLocateCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last filename in Screen
		CurrentScreenRow% = TotalScreenRows%: KeepCursBottom% = 0: CurrentFilename% = LastFilename%
		
		GOTO MHLocateCursor2
		
MHLocateCursor:
		GOSUB MHRestoreColor

MHLocateCursor2:
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR HFC, HBC: GOSUB MHDisplayRow: COLOR FC, BC' Display Current Row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		OldScreenRow% = CurrentScreenRow%
		OldFilename% = CurrentFilename%
		'GOSUB ShowValues    ' My little Debugger
		
MHDoitAgain:     DO: U$ = INKEY$: LOOP UNTIL U$ <> ""
		IF INSTR(AllowedKey$, U$) = 0 THEN GOTO MHDoitAgain

		' ESCape Key
		IF U$ = CHR$(27) THEN GOTO MessHDDirExit
		' ENTER Key
		IF U$ <> CHR$(13) THEN GOTO MHIsArrowDown
		IF CurrentFilename% > ActiveDirs% THEN GOTO MHStartCopying
		IF CurrentFilename% = ChosenDir% THEN GOTO MHStartCopying
		A$=Shrink$(MID$(FilName$(CurrentFilename%), 1, 10))
		IF MID$(FilName$(CurrentFilename%), 1, 10)=".." THEN MessPath$=Chop$(MessPath$) ELSE MessPath$=MessPath$+A$+"\"
		GOTO MHChangeDir
		'IF TotFiles2Copy% = 0 THEN GOTO MHChangeDir
		'GOSUB GiveUpCopying: IF K$ <> "Y" THEN GOTO MHRedraw
MHChangeDir:     ChosenDir% = CurrentFilename%
		CurrFileDescrIndex& = StartSect&(CurrentFilename%)
		CALL Fischio
		GOTO MHNewSubDir

MHIsArrowDown:     ' Arrow Down Key
		IF U$ <> CHR$(0) + CHR$(80) THEN GOTO MHOtherKey0
MHIsArrowDown1:    IF CurrentScreenRow% < LastScreenRow% THEN CurrentScreenRow% = CurrentScreenRow% + 1: CurrentFilename% = CurrentFilename% + 1: GOTO MHLocateCursor
		IF CurrentFilename% = TFNames% THEN GOTO MHLocateCursor
		CurrentFilename% = FirstFilename% + 1
		KeepCursBottom% = 1
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO MHExecutit

MHOtherKey0:      'Arrow up Key
		IF U$ <> CHR$(0) + CHR$(72) THEN GOTO MHOtherKey1
		IF CurrentFilename% = 1 THEN GOTO MHNoMatch
		IF CurrentScreenRow% > 1 THEN CurrentScreenRow% = CurrentScreenRow% - 1: CurrentFilename% = CurrentFilename% - 1: GOTO MHLocateCursor
		CurrentFilename% = FirstFilename% - 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO MHExecutit

MHOtherKey1:         ' Page Up Key
		IF U$ <> CHR$(0) + CHR$(73) THEN GOTO MHOtherKey2
		CurrentFilename% = FirstFilename% - TotalScreenRows%
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO MHExecutit

MHOtherKey2:         ' Page Down Key
		IF U$ <> CHR$(0) + CHR$(81) THEN GOTO MHOtherKey4
		IF LastFilename% + 1 + TotalScreenRows% > TFNames% THEN CurrentFilename% = TFNames% - TotalScreenRows% + 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1: GOTO MHExecutit
		CurrentFilename% = FirstFilename% + TotalScreenRows%
		IF CurrentFilename% > TFNames% THEN CurrentFilename% = FirstFilename%
		GOTO MHExecutit

MHOtherKey4:       ' C or c, M or m
		IF U$ <> "c" AND U$ <> "C" AND U$ <> "M" AND U$ <> "m" THEN GOTO MHOtherKey5
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO MHNoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB MHSectorLength: TotSizeFiles2Copy& = TotSizeFiles2Copy& + SectorLength&
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR HFC, HBC
		CopyMark$(CurrentFilename%) = "C": PRINT "C";
		GOSUB MHDispFilestoCopy
		GOTO MHIsArrowDown1
		
MHOtherKey5:       ' CTRL U = Unmark all
		IF U$ <> CHR$(21) THEN GOTO MHOtherKey6
		FOR T = ActiveDirs% + 1 TO TFNames%  ' Assume users wants to Copy all files
		CopyMark$(T) = " "
		NEXT T

		TotFiles2Copy% = 0
		TotSizeFiles2Copy& = 0
		GOSUB MHRePaintScreen
		GOTO MHNoMatch

MHOtherKey6:       ' CTRL A = Mark all
		IF U$ <> CHR$(1) AND U$ <> CHR$(3) THEN GOTO MHOtherKey7
		FOR T = ActiveDirs% + 1 TO TFNames%  ' Assume users wants to Copy all files
		IF CopyMark$(T) = " " THEN CopyMark$(T) = "C"
		NEXT T
		
		TotFiles2Copy% = TFNames%
		TotSizeFiles2Copy& = TotSectorFiles&
		GOSUB MHRePaintScreen
		GOTO MHNoMatch
		
MHOtherKey7:         ' Home Key : simply move cursor to top
		IF U$ <> CHR$(0) + CHR$(71) THEN GOTO MHOtherKey8
		CurrentScreenRow% = 1: CurrentFilename% = FirstFilename%: GOTO MHLocateCursor


MHOtherKey8:         ' End Key : simply move cursor to bottom
		IF U$ <> CHR$(0) + CHR$(79) THEN GOTO MHOtherKey10
		CurrentScreenRow% = LastScreenRow%: CurrentFilename% = LastFilename%
		GOTO MHLocateCursor

		

MHOtherKey10:      ' F7 = Show Sector as Hex
		IF U$ <> CHR$(0) + CHR$(65) THEN GOTO MHOtherKey11
		IF CurrentFilename% <= ActiveDirs% THEN GOTO MHNoMatch
		GOSUB MHShowSector
		GOSUB MHRePaintScreen
		GOTO MHNoMatch

MHOtherKey11:     ' 0-9 priority while copying
		IF U$ < "0" OR U$ > "9" THEN GOTO MHOtherKey12
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO MHNoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB MHSectorLength: TotSizeFiles2Copy& = TotSizeFiles2Copy& + SectorLength&
		CopyMark$(CurrentFilename%) = U$
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR HFC, HBC
		PRINT CopyMark$(CurrentFilename%);
		GOSUB MHDispFilestoCopy
		GOTO MHIsArrowDown1
		
		
MHOtherKey12:     ' DEL key
		IF U$ <> " " AND U$ <> CHR$(0) + CHR$(83) THEN GOTO MHOtherKey13
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO MHNoMatch
		IF CopyMark$(CurrentFilename%) <> " " THEN TotFiles2Copy% = TotFiles2Copy% - 1: GOSUB MHSectorLength: TotSizeFiles2Copy& = TotSizeFiles2Copy& - SectorLength&
		CopyMark$(CurrentFilename%) = " "
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR HFC, HBC
		PRINT CopyMark$(CurrentFilename%);
		GOSUB MHDispFilestoCopy
		GOTO MHIsArrowDown1
'========SHOW ARK FILE
MHOtherKey13:      IF U$ <> CHR$(0) + CHR$(66) THEN GOTO MHOtherKey14     ' F8 = I ARK file, display it
		IF CurrentFilename% <= ActiveDirs% THEN GOTO MHNoMatch
		
		IF ASC(MID$(FilName$(CurrentFilename%), 18, 1)) <> 128 THEN GOTO MHNoMatch
		FileType% = ASC(MID$(FilName$(CurrentFilename%), 13, 1))
		FileType% = FileType% AND &H8B
		FileType% = FileType% AND &HF7
		SELECT CASE FileType%
		CASE 0, 2 ' "Dis/Fix"
		GOSUB MHARKextract
		CLS
		COLOR HFC, HBC
		
		PRINT TAB(15); "Catalog of Archive File: "; MID$(FilName$(CurrentFilename%), 1, 10)
		Exec$ = "Decomp4.com " + TempArk + " /s"
		SHELL Exec$
		COLOR FC, BC
		CLS
		END SELECT
		
		GOSUB MHRePaintScreen
		GOTO MHNoMatch
		
		
		
MHOtherKey14:     ' F1 (Help) key
		IF U$ <> CHR$(0) + CHR$(59) THEN GOTO MHOtherKey15
		CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "19.01.00")
		GOSUB MHRePaintScreen
		GOTO MHLocateCursor


MHOtherKey15:
		GOTO MHNoMatch
		
MHRedraw:          CurrentFilename% = FirstFilename%
MHExecutit:
		CurrentScreenRow% = 1     ' Cursor on first screen row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		GOTO MHNextFileName   ' Start next round

MHStartCopying:
MHNoMatch:         GOTO MHLocateCursor

		'=================================
' DISPLAY TOP PART OF TITLE SCREEN
'=================================
MHTopScreen:
		LOCATE 1, 3, 1
		PRINT "TI DISK CATALOG FROM F5 KEY - NO SELECTION, NO ACTION, JUST TO VIEW FILE NAMES"
		LOCATE 2, 1
		PRINT SPACE$(80)
		LOCATE 2, 1
		PRINT "TI-99/4A DiskName:"; DskName$; MessPath$
		LOCATE 3, 1
		PRINT DiskType$;" Source File= "; SourcePath$;
		
		PRINT TAB(71); SideDensity$
		LOCATE 4, 1
		
		PRINT DiskType$; " - Sectors:"; TotSect&; " Sect/Track:"; SectTracks%; " Heads:"; Heads%; ; "Files="; MHFiles%; "Used:" ; TotSectorFiles& ;
		LOCATE 5, 1
		PRINT "Ŀ"
		PRINT "  n. Filename  P TSect Length  Type           Select:      Sectors:        "
		PRINT "Ĵ"
		GOSUB MHDispFilestoCopy
		IF TotEr% = 0 THEN GOTO MHIfSomeFile
		LOCATE 6, 51
		PRINT "- Bad Sectors Full List = F3";
		
MHIfSomeFile:
		LOCATE 23, 1
		'PRINT "Enter=Execute. C,M=Select, CTRL A=Select All, CTRL U=UnSel.All, 0=Served first,"
		PRINT "ESC=Exit, Cursor=ArrUp,Dwn,PagUp,Dwn. F1=Help. F7= File Hex Sector Viewer."
		LOCATE 24, 1
		'PRINT "1-9=Next to be served, C=Last to be served. Cursor=ArrUp,Dwn,PagUp,Dwn. "

		PRINT TAB(30); "F8= Cat ARK File.";
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
MHDisplayRow:
		LOCATE StartRow% + CurrentScreenRow%, 1, 1
		'PRINT "                                                                              "
		PRINT ""; CopyMark$(CurrentFilename%); "";
		PRINT USING "###"; CurrentFilename%;
		PRINT ""; MID$(FilName$(CurrentFilename%), 1, 10);
		
		IF CurrentFilename% > ActiveDirs% THEN GOTO MHNoSubDirs
		IF CurrentFilename% > 1 THEN GOTO MHDisplayRow2
		IF NowDir$ = "DIR" THEN GOTO MHDisplayRow2
		IF MHDSK1EmulPtr& = 0 THEN GOTO MHDisplayRow2
		PRINT TAB(34); "=DSK1 EMUL";
		GOTO MHDisplayRow3
		
MHDisplayRow2:   PRINT TAB(34); ".. <Dir>..";

MHDisplayRow3:          
		PRINT TAB(49); "";
		GOTO MHNoErrSectInFile
MHNoSubDirs:

		FileType% = ASC(MID$(FilName$(CurrentFilename%), 13, 1))
		FileType% = FileType% AND &H8B         ' Get rid of reserved bits: 2,4-6
		IF FileType% AND 8 THEN FileProt$ = "P" ELSE FileProt$ = "_"
		FileType% = FileType% AND 247

		SELECT CASE FileType%
		CASE 0
		FileType$ = "Dis/Fix"
		CASE 1
		FileType$ = "Program"
		CASE 2
		FileType$ = "Int/Fix"
		CASE 128
		FileType$ = "Dis/Var"
		CASE 130
		FileType$ = "Int/Var"
		CASE ELSE
		FileType$ = "unknown"
		END SELECT

		'SectorLength& = INT(ASC(MID$(FilName$(CurrentFilename%), 39, 1))/16)
		'SectorLength& = SectorLength&*65536
		'SectorLength& = SectorLength& + CalcWord&(FilName$(CurrentFilename%), 15) + 1
		SectorLength& = INT(ASC(MID$(FilName$(CurrentFilename%), 39, 1)) / 16) * 65536 + CalcWord&(FilName$(CurrentFilename%), 15) + 1
		EOFOffset% = ASC(MID$(FilName$(CurrentFilename%), 17, 1))
		FileLength& = SectorLength& - 1
		FileLength& = FileLength& * MHSecLen%
		IF FileType% < 128 THEN FileLength& = FileLength& - 256 + EOFOffset%
		LogRecLength% = ASC(MID$(FilName$(CurrentFilename%), 18, 1))

		' PRINT EOFOffset%;
		PRINT " "; FileProt$;
		PRINT USING "####"; SectorLength&;
		PRINT USING "#########"; FileLength&;
		PRINT " "; FileType$;
		IF LogRecLength% > 0 THEN PRINT USING "####"; LogRecLength%;

		LOCATE StartRow% + CurrentScreenRow%, , 1
		PRINT TAB(49); "";

		
MHNoErrSectInFile:
		
		PRINT TAB(80); "";
		RETURN
'====================
' DISPLAY BOTTOM LINE
'====================
MHBottomLine:
		PRINT
		PRINT ""
		
		LOCATE StartRow% + CurrentScreenRow% + 1, 1, 1

		IF CurrentScreenRow% > TotalScreenRows% THEN GOTO MHSkipClear ' Blank all unused screen rows, if any

		FOR V = CurrentScreenRow% TO TotalScreenRows%
		PRINT "                                                                                "
		NEXT V
MHSkipClear:
		RETURN

'=========================
' REDRAW THE ENTIRE SCREEN
'=========================
MHRePaintScreen:

		GOSUB MHTopScreen ' Display Top Part of Title Screen
		SaveCurrFilename% = CurrentFilename%
		SavCurrScreenRow% = CurrentScreenRow%
		CurrentFilename% = FirstFilename%
		FOR CurrentScreenRow% = 1 TO TotalScreenRows%
		GOSUB MHDisplayRow  ' Display Current Row
		CurrentFilename% = CurrentFilename% + 1 ' Next Filename
		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		IF CurrentFilename% > TFNames% THEN CurrentScreenRow% = CurrentScreenRow% + 1: GOTO MHRePaintScreen2
		NEXT CurrentScreenRow%   ' Next Screen Row
MHRePaintScreen2: 
		GOSUB MHBottomLine        ' Display Bottom Line
		CurrentFilename% = SaveCurrFilename%
		CurrentScreenRow% = SavCurrScreenRow%
		RETURN


MHRestoreColor:    TempScreenRow% = CurrentScreenRow%
		TempFilename% = CurrentFilename%
		CurrentScreenRow% = OldScreenRow%
		CurrentFilename% = OldFilename%
		COLOR FC, BC: GOSUB MHDisplayRow' Display Current Row
		CurrentScreenRow% = TempScreenRow%
		CurrentFilename% = TempFilename%
		RETURN


MHDispFilestoCopy: ' Display total files to be copied
		'LOCATE 4, 72, 1
		'PRINT TotFiles2Copy%; "  ";
		RETURN


MHAbsNoFiles:
		PRINT ""
		A = 10
		CALL box(A, 18, 50, 8)
		LOCATE A + 2, 24: PRINT "THIS DISK, "; SourcePath$; " IS EMPTY. "
		LOCATE A + 3, 24: PRINT ""
		LOCATE A + 4, 30: PRINT "No files have been found."
		LOCATE A + 5, 32: PRINT "Press any key to exit"

		WHILE INKEY$ = "": WEND
		RETURN

MHSectorLength:    ' Calculate file length, in sectors
		SectorLength& = CalcWord&(FilName$(CurrentFilename%), 15) + 1
		RETURN

'========SHOW SECTORS - ADD START
MHShowSector:      CALL box(8, 3, 76, 13)
		LOCATE 8, 30: COLOR HFC, HBC: PRINT " - HEX SECTOR VIEWER - "; : COLOR FC, BC
		CALL RWVirtualSect(FileNum%, StartSect&(CurrentFilename%), FHeader$,"")
		' FHeader$ = d$
		LOCATE 9, 5:  PRINT "File: "; MID$(FHeader$, 1, 10); "-Length:"; CalcWord&(FHeader$, 15);
		SectorCnt& = CalcWord&(FHeader$, 15)
		OffsVal% = 0
		BlockOffset& = 0           ' Offset of all the blocks so far in Input  File Chain Pointer Block
		Z = 0                      ' Offset in Input File Chain Pointer Block
		K$ = "Y"
		MHShSectEOF$ = ""          ' Flag. If empty string, then EOF Not Reached yet.
		GlobalInpOffset& = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		GOSUB MHCalcClusters
		CALL RWVirtualSect(FileNum%, StSec& + OffsVal%, d$,"")
		GOSUB MHShowNow
		
		
		GOTO MHShowShSect1
		
MHShowShSect:    GOSUB MHShowNext
MHShowShSect1:   'IF MHShSectEOF$ <> "" THEN DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		IF K$ = CHR$(27) THEN GOTO MHShowShSectEnd
		IF K$ = CHR$(0) + CHR$(72) THEN K$ = "": GOTO MHShowShSect2
		IF K$ <> CHR$(0) + CHR$(73) THEN GOTO MHShowShSect
MHShowShSect2:   GOSUB MHShowPrevious
		GOTO MHShowShSect1
MHShowShSectEnd: RETURN

MHShowNext:      GOSUB MHNextCluster
		'IF MHShSectEOF$ = "Y" THEN K$=""
		GOSUB MHShowNow
		RETURN
		
MHShowPrevious:  MHShSectEOF$ = ""
		GOSUB MHPrevCluster:
		GOSUB MHShowNow
		RETURN
		
		
MHShowNow: 
		LOCATE 9, 33: PRINT " -This Skt: "; StSec& + OffsVal%; " >"; HEX$(StSec& + OffsVal%); " - Skt Off.:"; GlobalInpOffset&;
		IF MHShSectEOF$ <> "" THEN K$ = "": LOCATE 19, 30: PRINT " = End of File =";  ELSE LOCATE 19, 30: PRINT "                ";
		CALL ShowHex(d$, K$)
		
		RETURN
		
		
' Prepare file to be cataloged upon by LZW decompressor
MHARKextract:   CALL RWVirtualSect(FileNum%, StartSect&(CurrentFilename%), d$,"")
		FHeader$ = d$
		SectorLength& = CalcWord&(FilName$(CurrentFilename%), 15) + 1
		Z = 0                      ' Offset in Input File Chain Pointer Block
		GlobalInpOffset& = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		SectorCnt& = SectorLength& - 1' Sector Length of this file
		OPEN TempArk FOR BINARY ACCESS WRITE AS #2
		CLOSE #2
		KILL TempArk
		OPEN TempArk FOR BINARY ACCESS WRITE AS #2
		GOSUB MHDoDisFix2
		RETURN

'===============================================
' CALCULATE CURRENT ENTRY IN CHAIN POINTER TABLE
'===============================================

MHCalcClusters:  StSec& = CalcWord&(FHeader$, 41 + Z) * SectPerAU%
		EndSec& = CalcWord&(FHeader$, 43 + Z) * SectPerAU%
		Offs& = EndSec& - StSec& + 1
		OffsVal% = 0               ' Offset in EACH Input  File Chain Pointer Block
		IF StSec& = 0 THEN MHShSectEOF$ = "Y"
		RETURN

' GET THE NEXT OFFSET IN CHAIN POINTER, LOAD OFFSPRING FDR IF NECESSARY
MHNextCluster:   IF MHShSectEOF$ = "Y" THEN GOTO MHNextCluster4
		IF OffsVal% < Offs& THEN GOTO MHNextCluster3
		IF Z <= LEN(FHeader$) - 4 - 41 THEN Z = Z + 4: GOTO MHNextCluster2
		Z = 0
		ExtFDR& = CalcWord&(FHeader$, 33) * SectPerAU%
		IF ExtFDR& = 0 THEN HShSectEOF$ = "Y": GOTO MHNextCluster4
		CALL RWVirtualSect(FileNum%, ExtFDR&, FHeader$,"")
		
MHNextCluster2:  GOSUB MHCalcClusters
		IF MHShSectEOF$ = "Y" THEN GlobalInpOffset& = GlobalInpOffset& + 1: GOTO MHPrevCluster  ' MHNextCluster4
		
MHNextCluster3:  GlobalInpOffset& = GlobalInpOffset& + 1: OffsVal% = OffsVal% + 1
		CALL RWVirtualSect(FileNum%, StSec& + OffsVal%, d$,"")
MHNextCluster4:
		RETURN
		
		

' GET THE PREVIOUS OFFSET IN CHAIN POINTER, LOAD PARENT FDR IF NECESSARY
MHPrevCluster:   IF GlobalInpOffset& = 0 THEN K$ = "Y": GOTO MHPrevCluster4
		' PRINT "Z=";z ; "    OffsVal%="; OffsVal%; "    Offs&=";Offs&  :input CCC$
		IF OffsVal% > 0 THEN OffsVal% = OffsVal% - 1: GOTO MHPrevCluster3
		IF Z > 0 THEN Z = Z - 4: GOTO MHPrevCluster2
		ExtFDR& = CalcWord&(FHeader$, 31) * SectPerAU%
		IF ExtFDR& = 0 THEN GOTO MHPrevCluster2
		CALL RWVirtualSect(FileNum%, ExtFDR&, FHeader$,"")
		Z = LEN(FHeader$) - 4 - 41
		
MHPrevCluster2:  GOSUB MHCalcClusters
		OffsVal% = Offs&
MHPrevCluster3:  GlobalInpOffset& = GlobalInpOffset& - 1
		CALL RWVirtualSect(FileNum%, StSec& + OffsVal%, d$,"")
MHPrevCluster4:
		RETURN

		
MHDoDisFix:      OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #2
MHDoDisFix2:     Z = 0: Tog% = 1: BytePos& = 1: TRecs& = 0
		T1& = ASC(MID$(FHeader$, 20, 1))
		T2& = ASC(MID$(FHeader$, 19, 1))
		TotRecs& = T1& * 256 + T2&
		RecsInSect% = ASC(MID$(FHeader$, 14, 1))
		LogRecLength% = ASC(MID$(FHeader$, 18, 1))
		' Special case: Archiver III files are sometimes bugged. The Total Records (Bytes 19+20 in FDR)
		' sometimes report 256 records less than what it should.
		' The following patch compares the Total Records
		' with the Total Sector*2 which, in a dis/fix 128 record should be more or less comparable.
		' If this is not the case, adds 256 bytes to previous value
		' TotRecs&=0:GOTO MHNextClusterDF
		
		IF LogRecLength% <> 128 THEN GOTO MHNextClusterDF
		T& = (SectorCnt& - 1) * 2
		IF T& <= TotRecs& THEN GOTO MHNextClusterDF
		TotRecs& = TotRecs& + 256
		' PRINT " (fixed!)";
		' print  "Total Records="; TotRecs&  :input c$
		
MHNextClusterDF:   GOSUB MHCalcClusters
		IF StSec& = 0 THEN GOTO MHEOThisFileDF
		
MHNextOffsValDF:
		
		IF GlobalInpOffset& > Offs& THEN Z = Z + 4: GOTO MHNextClusterDF
		CALL RWVirtualSect(FileNum%, StSec& + OffsVal%, d$,"")
		GOSUB MHRecToDoDF
		IF TotRecs& < 1 THEN GOTO MHEOThisFileDF
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset& = GlobalInpOffset& + 1
		
		' DoneSect=DoneSect+1: PRINT TotRecs&;DoneSect; GlobalInpOffset&
		
		GOTO MHNextOffsValDF

MHEOThisFileDF:
		CLOSE #2
		
		RETURN

' Transfer a Dis/Var record (Text)
MHRecToDoDF:                  ROff% = 1

MHRecToDoDFAG:                FOR RT% = 1 TO RecsInSect%
		DFRec$ = MID$(d$, ROff%, LogRecLength%)
		PUT #2, BytePos&, DFRec$: BytePos& = BytePos& + LogRecLength%
		ROff% = ROff% + LogRecLength%
		TotRecs& = TotRecs& - 1
		TRecs& = TRecs& + 1
		IF TotRecs& < 1 THEN GOTO MHRecDoneDF
		NEXT RT%
		
MHRecDoneDF:                  RETURN

MessHDDirExit:
END SUB

SUB MHDisplaySectr (FileNum%, MySect&, K$)
' Show a sector 
		CALL RWVirtualSect(FileNum%, MySect&, d$,"")
		K$ = "1"
		CALL ShowHex(d$, K$)
		
END SUB

SUB MHKeybSectr (FileNum%)
' Show a sector from an AU #, input from keyboard
MHKeybSectr1:
		INPUT "Sector AU Hex Number (example FFFF)=", Numer$
		Numer$ = UCASE$(Numer$)
		PRINT Numer$
		MySect& = Hex2Dec&(Numer$) * SectPerAU%
		PRINT "Sector=     "; MySect&
		CALL MHDisplaySectr(FileNum%, MySect&, K$)
		IF K$ <> CHR$(27) THEN GOTO MHKeybSectr1
		
END SUB

DEFINT A-Z
FUNCTION Hex2Dec& (HexString$)
' Returns a 64 bits Hexadecimal Number (Long Word)
' From an Hexadecimal string
' Conversion is terminated as soon as a non hexadecimal
' character is found


'Example:       Decimal& = Hex2Dec& (HexString$)
		Dec& = 0
		FOR T = 1 TO LEN(HexString$)
		By$ = MID$(HexString$, T, 1)
		P = INSTR(1, "0123456789ABCDEF", By$)
		IF P = 0 THEN GOTO Hex2DecExit
		P = P - 1
		Dec& = Dec& * 16 + P
		'PRINT P; Dec&
		NEXT T
Hex2DecExit:
		Hex2Dec& = Dec&
END FUNCTION



DEFSNG A-Z

' WRITE OR READ A SECTOR TO/FROM ANY OF THE FOLLOWING : PC99 DISK, V9T9 DISK, TI99-PC DISK, MESS HARD DISK
' Call with: 
' Call RWVirtualSect (FileNumW%, Sektor&, wd$, WFlag$)
' where:
' FileNumW% = File number of a Image Disk file already opened FOR BINARY ACCESS READ WRITE
' Sektor&   = Sector # to be read from/written to
' wd$       = Data to be written to or read from the Disk Image file. Usually 256 bytes
' WFlag$    = Flag, if = "W" then it is a WRITE operation, 
'                   otherwise it is a READ operation.
'
' The following Shared parameters should also be set:
' 1) FTypeW$ - "MH" = Mess Hard Disk, "VS" = V9T9 Image Disk, "PS" = PC99 Single Density, "PD" = PC99 Double Density.
' For Mess Hard Disk only:
' a) MHSectZeroW& = Byte offset before Sector Zero 
' b) MHSecLenW%   = Length of sector (256 or 512)

' For PC99 Disk only:
' I)    SekTrackW% 
' II)   OldTrackW&
' III)  OldDskSideW&
' IV)   SideLenW&
' V)    Gap1W%       ' Start of track Gap
' VI)   PreIDGapW% 
' VII)  PreDatGapW%
' VIII) SLengthW% = 334
' IX)   SekTrackW% = 9
' X)    CONST TrkLenSW% = 3253
' XI)   TrackSingW(1) AS STRING * 3253    
' XII)  TrackDoubW(1) AS STRING * 6872
' XIII) MHSekt256W(1)
' XIV)  MHSekt512W(1)
' Also, the 
'
' For V9T9 Disk only:
' a)	V9T9SektW(1)
		
SUB RWVirtualSect (FileNumW%, Sektor&, wd$, WFlag$)
' SUB GetVirtualSect (FileNumW%, Sektor&, wd$)
 	
		Sekr& = Sektor& - 1

		IF FTypeW$ <> "MH" THEN GOTO RWNoMHDisk            ' See if it is a Mess Hard Disk

'*** MESS HARD DISK ***
		ByteOff& = Sekr& + 1
		ByteOff& = ByteOff& * MHSecLenW% + MHSectZeroW&
 
		IF WFlag$ ="W" THEN 
		PUT #FileNumW%, ByteOff& + 1, wd$
		GOTO RWSectExit
		ELSE 
		SELECT CASE MHSecLenW%
		CASE 256
		GET #FileNumW%, ByteOff& + 1, MHSekt256W(1)
		wd$ = MHSekt256W(1)
		CASE 512
		GET #FileNumW%, ByteOff& + 1, MHSekt512W(1)
		wd$ = MHSekt512W(1)
		CASE ELSE
		CALL Die(1)		
		END SELECT
		END IF 
	
		GOTO RWSectExit

RWNoMHDisk: 	

		IF FTypeW$ <> "VS" THEN GOTO RWPC99disk            ' V-9T9 S-ingle density

'*** V9T9 DISK ***
		ByteOff& = Sekr&
		ByteOff& = ByteOff& * MHSecLenW%
		
		IF WFlag$ ="W" THEN 
		PUT #FileNumW%, ByteOff& + 1, wd$
		ELSE 
		GET #FileNumW%, ByteOff& + 1, Bytes256(1)
		wd$ = Bytes256(1)
		END IF 
	
		GOTO RWSectExit

RWPC99disk:     
		Trk& = INT(Sekr& / SekTrackW%)
 'PRINT Trk& ; Sekr& ; SekTrackW% 
		
		DskSide& = 0
		IF Trk& > 39 THEN Trk& = 79 - Trk&: DskSide& = 1
		Skt% = Sekr& MOD SekTrackW%
		SideLenW& = TrkLenW& * 40
		ByteOff& = SideLenW& * DskSide& + Trk& * TrkLenW&
		
		IF FTypeW$ = "PD" THEN GOTO RWSectD
		IF FTypeW$ = "PS" THEN GOTO RWSectS
		GOTO RWSectBad
		
'*** PC99 SINGLE DENSITY DISK ***
RWSectS:        IF Trk& = OldTrackW& AND DskSide& = OldDskSideW& THEN GOTO RWSectS03
		GET #FileNumW%, ByteOff& + 1, TrackSingW(1)
		OldTrackW& = Trk&: OldDskSideW& = DskSide&

RWSectS03:      FOR WHT% = 1 TO SekTrackW%
		P = 1 + Gap1W% + PreIDGapW% + (SLengthW% * (WHT% - 1))
		A$ = MID$(TrackSingW(1), P, 4)

		IF A$ <> CHR$(Trk&) + CHR$(DskSide&) + CHR$(Skt%) + CHR$(1) THEN GOTO RWSectS05
		IF WFlag$ ="W" THEN 
		MID$(TrackSingW(1), 1 + Gap1W% + PreDatGapW% + (SLengthW% * (WHT% - 1)), 256) = wd$
		' PUT #FileNumW%, ByteOff& + 1, TrackSingW(1)
		PUT #FileNumW%, ByteOff& + 1 + Gap1W% + PreDatGapW% + (SLengthW% * (WHT% - 1)), wd$
		ELSE
		'GET #FileNumW%, ByteOff& + 1 + Gap1W% + PreDatGapW% + (SLengthW% * (WHT% - 1)), Bytes256(1)
		'wd$= Bytes256(1)
		wd$ = MID$(TrackSingW(1), 1 + Gap1W% + PreDatGapW% + (SLengthW% * (WHT% - 1)), 256)
		END IF 
		GOTO RWSectExit

RWSectS05:      NEXT WHT%
		GOTO RWSectBad:

'*** PC99 DOUBLE DENSITY DISK *** 
RWSectD:        IF Trk& = OldTrackW& AND DskSide& = OldDskSideW& THEN GOTO RWSectD03
		GET #FileNumW%, ByteOff& + 1, TrackDoubW(1)
		OldTrackW& = Trk&: OldDskSideW& = DskSide&
RWSectD03:      FOR WHT% = 1 TO SekTrackW%
		P = 1 + Gap1W% + PreIDGapW% + (SLengthW% * (WHT% - 1))
		A$ = MID$(TrackDoubW(1), P, 4)
		IF A$ <> CHR$(Trk&) + CHR$(DskSide&) + CHR$(Skt%) + CHR$(1) THEN GOTO RWSectD05
		IF WFlag$ ="W" THEN 
		MID$(TrackDoubW(1), 1 + Gap1W% + PreDatGapW% + (SLengthW% * (WHT% - 1)), 256) = wd$
		' PUT #FileNumW%, ByteOff& + 1, TrackDoubW(1)
		PUT #FileNumW%, ByteOff& + 1 + Gap1W% + PreDatGapW% + (SLengthW% * (WHT% - 1)), wd$
		ELSE
		'GET #FileNumW%, ByteOff& + 1 + Gap1W% + PreDatGapW% + (SLengthW% * (WHT% - 1)), Bytes256(1)
		'wd$= Bytes256(1)
		wd$ = MID$(TrackDoubW(1), 1 + Gap1W% + PreDatGapW% + (SLengthW% * (WHT% - 1)), 256)
		END IF 
		GOTO RWSectExit

RWSectD05:      NEXT WHT%

RWSectBad:      wd$ = ""

RWSectExit:
END SUB

' Setup parameters for Virtual Disk Image READ or WRITE sector
' Call RWVirtualZero(FTypeW$) 
' FTypeW$,  - "MH" = Mess Hard Disk, "VS" = V9T9 Image Disk, "PS" = PC99 Single Density, "PD" = PC99 Double Density.

SUB RWVirtualZero(FileNumW%, wd$, FTypeW$) 
'SUB GetVirtualZero (FileNumW%, wd$)
		
		ByteOff& = 1
		CALL TellWhatDisk(FileNumW%, wd$, WhatDisk$)
		FTypeW$=WhatDisk$
 
		IF FTypeW$<>"MH" THEN GOTO RWVrtZ100
'*** MESS HARD DISK ***
		ERASE Bytes256
		ERASE TrackSingW
		ERASE TrackDoubW

		MHB& = CalcDWord&(wd$, 28 + 1)  ' Get Total # of Blocks
		MHMStart& = CalcDWord&(wd$, 8 + 1)  ' Get Hard Disk Header Size
		MHMEnd& = MHB& * 8 + MHMStart&  ' Get Total # of Blocks * 8 + Hard Disk Header Size
		MHSectZeroW& = MHMEnd& + 8
		MHSecLenW% = CalcDWord&(wd$, 76 + 1) ' Get Hard Disk Sector Len
		
		ByteOff& = MHSectZeroW&
		IF MHSecLenW% = 256 THEN ERASE MHSekt512W ELSE ERASE MHSekt256W
		' CALL RWVirtualSect (FileNumW%, 0, wd$, "")
		CALL RWVirtualSect (FileNumW%, 0, wd$,"")
		GOTO RWVrtZExit
		
RWVrtZ100:		
		
		ERASE MHSekt256W
		ERASE MHSekt512W
		
		IF FTypeW$<>"VS" THEN GOTO RWVrtZ110
'*** V9T9 DISK ***			 		
		ERASE TrackSingW
		ERASE TrackDoubW
		MHSecLenW%= 256
' FOR V9T9 we have already done, wd$ contains Sector Zero.
		GOTO RWVrtZExit
RWVrtZ110: 	
		ERASE Bytes256
		IF FTypeW$<>"PS" THEN GOTO RWVrtZ160
		
'*** PC99 SINGLE DENSITY DISK ***		
		Gap1W% = 16             ' Start of track Gap
		PreIDGapW% = 7          '
		PreDatGapW% = 31
		SLengthW% = 334
		SekTrackW% = 9
		
		TrkLenW& = 3253
		OldDskSideW&=99999      ' Force new track read
		CALL RWVirtualSect (FileNumW%, 1, wd$, "")
		' CALL GetVirtualSect (FileNumW%, 1, wd$)
		GOTO RWVrtZExit
		
RWVrtZ160:		
		IF FTypeW$<>"PD" THEN GOTO RWVrtZAbort
'*** PC99 DOUBLE DENSITY DISK ***			
		ERASE TrackSingW

		
		Gap1W% = 40             ' Start of track Gap
		PreIDGapW% = 14
		PreDatGapW% = 58
		SLengthW% = 340
		SekTrackW% = 18
		TrkLenW& = 6872
		OldDskSideW&=99999      ' Force new track read
		CALL RWVirtualSect (FileNumW%, 1, wd$, "")
		' CALL GetVirtualSect (FileNumW%, 1, wd$)
		GOTO RWVrtZExit
		
RWVrtZAbort:	WhatDisk$ = ""  : wd$ = ""	
		
		
RWVrtZExit:	FType$=FTypeW$ 
 
END SUB 

' Returns what type of Disk Image file ( "MH" = Mess Hard Disk, "VS" = V9T9 Image Disk, "PS" = PC99 Single Density, "PD" = PC99 Double Density)
SUB TellWhatDisk(FileNumW%, d$, WhatDisk$)
		MHSecLen% = 256
		DIM DAT(1) AS STRING * 256
		GET #FileNumW%, 1, DAT(1)
		d$=DAT(1)
		IF MID$(DAT(1), 1, 8) <> "MComprHD" THEN GOTO TellDSKDetect
		WhatDisk$="MH" : GOTO TellWhatDExit
TellDSKDetect: 
		
		IF MID$(DAT(1), 14, 3) <> "DSK" THEN GOTO TellPC99Detect
		WhatDisk$="VS" : GOTO TellWhatDExit
TellPC99Detect: P = INSTR(DAT(1), CHR$(&HFE)): IF P = 0 THEN GOTO TellWhatDAbort
		A$ = MID$(DAT(1), P + 4, 1)
		IF A$ <> CHR$(&H1) THEN GOTO TellWhatDAbort
		A$ = MID$(DAT(1), P - 3, 3)
		IF A$ = CHR$(&HA1) + CHR$(&HA1) + CHR$(&HA1) THEN WhatDisk$="PD" : GOTO TellWhatDExit
		IF A$ <> CHR$(0) + CHR$(0) + CHR$(0) THEN GOTO TellWhatDAbort
		WhatDisk$="PS" : GOTO TellWhatDExit
		
TellWhatDAbort: WhatDisk$ = ""  : d$ = ""

TellWhatDExit:  ERASE DAT
END SUB 

SUB Die(T%)
		SELECT CASE T%
		CASE 1
		PRINT "Unexpected Sector Length in Mess Hard Disk. Program will be halted."
		END SELECT
		PRINT "- Press any key -"
        	DO: C$ = INKEY$: LOOP UNTIL C$ <> ""          
		SYSTEM
        					
END SUB 		
