
' Split a large disk image file (from opt. 1) into smaller disk image files
'
' - Paolo Bagnaresi, July 2000 - e-mail: paolo_bagnaresi@libero.it
'
' This module can be Launched with a CHAIN qbasic instruction by a different qbasic program.
' Just add the same COMMON arrays to your launcher. (DIM Vector, MyName$, MyVal and the 3 corresponding COMMON Shared declarations).
' These arrays are used only as a parameter passing between chained qbasic programs.

DIM Vector(0 TO 10)      AS INTEGER
DIM MyName$(0 TO 30)
DIM MyVal(0 TO 10)      AS INTEGER

COMMON SHARED Vector() AS INTEGER
COMMON SHARED MyName$()
COMMON SHARED MyVal() AS INTEGER


DEFINT A-Z
' F1 help file. Record structure definition
		TYPE IDXType
		Section AS STRING * 20
		StartRec AS DOUBLE
		RecLength AS SINGLE
		END TYPE
		DIM SHARED IDXRecord AS IDXType
		
' ===> ADDED CODE --> RETURN	FROM CHAINED PROGRAM - PART 1 OF 4 - START
		TempArk$ = "~ARKTMP.TMP"
' ===> ADDED CODE --> RETURN	FROM CHAINED PROGRAM - PART 1 OF 4 -  END 


		DIM SHARED FileNum AS INTEGER
		DIM SHARED Gap1%            ' Start of track Gap
		DIM SHARED PreIDGap%           '
		DIM SHARED PreDatGap%
		DIM SHARED SLength%
		DIM SHARED TrkLen&
		DIM SHARED TrackSing(1) AS STRING * 3253
		DIM SHARED TrackDoub(1) AS STRING * 6872
		DIM SHARED V9T9Sekt(1) AS STRING * 256
		DIM SHARED OldTrack&
		DIM SHARED OldDskSide&
		DIM SHARED SideLen&

		DIM SHARED SekTrack%
		DIM SHARED FType$       ' Disk Image Type for Read
		DIM SHARED FTypeW$      ' Disk Image Type for Write

		DIM SHARED MHTB&
		DIM SHARED MHSectZero&
		DIM SHARED MHSecLen%
		DIM SHARED MHSekt256(1) AS STRING * 256
		DIM SHARED MHSekt512(1) AS STRING * 512
		DIM SHARED MHFloppy$
		DIM SHARED SubDirStAddr(0 TO 10) AS INTEGER
		DIM SHARED SubDirName$(0 TO 10)
		DIM SHARED SectPerAU%
		DIM SHARED SourcePath$
		FileNum% = 1



		DIM DiskSize(1 TO 12)  AS INTEGER    ' Sectors per Disk. 360, 720, 1440, 2880
		DIM SecTrack(1 TO 12)  AS INTEGER    ' Sector per Track. 9 or 18
		DIM TrackSide(1 TO 12)  AS INTEGER   ' Track/side 40 or 80
		DIM NumSides(1 TO 12)  AS INTEGER    ' Number of Sides. 1= Single Side, 2=Double Side
		DIM DskDens(1 TO 12)  AS INTEGER     ' Disk Density. 1=Single Density, 2=Double Density
		DIM LowestSect(1 TO 12)  AS INTEGER  ' Lowest sector where to begin to copy Data Sectors
		DIM UpperABM(1 TO 12)  AS INTEGER    ' Highest byte in Allocation Bit Map in sector zero

		DiskSize(1) = 360  ' Sectors per Disk.
		DiskSize(2) = 720

		DiskSize(3) = 720
		DiskSize(4) = 1440

		DiskSize(5) = 1440
		DiskSize(6) = 2880

		DiskSize(7) = 720
		DiskSize(8) = 1440
		DiskSize(9) = 1440
		DiskSize(10)= 2880
		DiskSize(11)= 2880
		DiskSize(12)= 5760

		SecTrack(1) = 9    ' Sector per Track. 9 or 18
		SecTrack(2) = 9
		SecTrack(3) = 18
		SecTrack(4) = 18
		SecTrack(5) = 36
		SecTrack(6) = 36
		SecTrack(7) = 9
		SecTrack(8) = 9
		SecTrack(9) = 18
		SecTrack(10) = 18
		SecTrack(11) = 36
		SecTrack(12) = 36





		TrackSide(1) = 40  ' Track/side 40 or 80
		TrackSide(2) = 40
		TrackSide(3) = 40
		TrackSide(4) = 40
		TrackSide(5) = 40
		TrackSide(6) = 40

		TrackSide(7) = 80
		TrackSide(8) = 80
		TrackSide(9) = 80
		TrackSide(10) = 80
		TrackSide(11) = 80
		TrackSide(12) = 80


		NumSides(1) = 1    ' Number of Sides. 1= Single Side, 2=Double Side
		NumSides(2) = 2
		NumSides(3) = 1
		NumSides(4) = 2
		NumSides(5) = 1
		NumSides(6) = 2
		NumSides(7) = 1
		NumSides(8) = 2
		NumSides(9) = 1
		NumSides(10) = 2
		NumSides(11) = 1
		NumSides(12) = 2



		DskDens(1) = 1     ' Disk Density. 1=Single Density, 2=Double Density, 3=High Density
		DskDens(2) = 1
		DskDens(3) = 2
		DskDens(4) = 2
		DskDens(5) = 3
		DskDens(6) = 3
		DskDens(7) = 1
		DskDens(8) = 1
		DskDens(9) = 2
		DskDens(10) = 2
		DskDens(11) = 3
		DskDens(12) = 3



		LowestSect(1) = 34 ' Lowest sector where to begin to copy Data Sectors
		LowestSect(2) = 34
		LowestSect(3) = 34
		LowestSect(4) = 34
		LowestSect(5) = 34
		LowestSect(6) = 130
		LowestSect(7) = 34
		LowestSect(8) = 34
		LowestSect(9) = 34
		LowestSect(10) = 130
		LowestSect(11) = 130
		LowestSect(12) = 258


		UpperABM(1) = 45   ' Highest byte in Allocation Bit Map in sector zero
		UpperABM(2) = 90
		UpperABM(3) = 90
		UpperABM(4) = 180
		UpperABM(5) = 180
		UpperABM(6) = 180   ' With 2880 sectors each bit counts for 2 adjacent sectors

		UpperABM(7) = 90
		UpperABM(8) = 180
		UpperABM(9) = 180
		UpperABM(10) = 180  ' With 2880 sectors each bit counts for 2 adjacent sectors
		UpperABM(11) = 180  ' With 2880 sectors each bit counts for 2 adjacent sectors
		UpperABM(12) = 180  ' With 5760 sectors each bit counts for 4 adjacent sectors

		DummyRec$ = STRING$(256, CHR$(&HE5))


		CLS
		SourcePath$ = MyName$(3)
		DestinPath$ = MyName$(5)
		ReturnFile$= "~WhatWas.dat"
		
		REDIM FilName$(1)
		IF DestinPath$ = "" THEN DestinPath$ = SourcePath$: MID$(DestinPath$, LEN(DestinPath$), 1) = "1"
		CALL TellPathFrom(DestinPath$, MPath$, OutName$): OutPath$ = MPath$
		IF OutName$ = "" GOTO DestMissing
		CALL ShortName(OutPath$): DPath$ = OutPath$ + OutName$
		Incr% = 1  ' File Output number
		GOTO OpenFile

' Exit point with F9
Abort:          'MyName$(2) = ""
		GOTO LeaveIt2

Leaveit:        'MyName$(2) = SourcePath$
LeaveIt2:       ERASE FilName$

' ===> ADDED CODE --> RETURN	FROM CHAINED PROGRAM - PART 2 OF 4 - START
		ON ERROR GOTO LeaveIt3
		KILL ReturnFile$
		ON ERROR GOTO 0
		GOTO LeaveIt4
LeaveIt3:	RESUME LeaveIt4

LeaveIt4:	
' ===> ADDED CODE --> RETURN	FROM CHAINED PROGRAM - PART 2 OF 4 - END 
		CLOSE #1
		CHAIN MyName$(0)

OpenFile:       
		ON ERROR GOTO FileNotFound
		SrcDOSName$ = SourcePath$
		CALL ShortName(SrcDOSName$)
		OPEN SrcDOSName$ FOR INPUT ACCESS READ AS #1   ' Avoid creation of file is file doesn't exist
		CLOSE #1
		'OPEN SrcDOSName$ FOR RANDOM ACCESS READ AS #1 LEN = 256
		OPEN SrcDOSName$ FOR BINARY ACCESS READ AS #FileNum%
		ON ERROR GOTO 0
		'FIELD #1, 256 AS d$

		'GET #1, 1              ' Get Sector Zero
		CALL GetVirtualZero(FileNum%, d$)
		DskName$ = MID$(d$, 1, 10)
		IF MID$(d$, 14, 3) = "DSK" THEN GOTO IdentFound

		CALL box(1, 10, 66, 11)
		LOCATE 2, 12
		PRINT "TI-99/4A DiskName: "; DskName$;
		LOCATE 4, 12
		PRINT "Warning....";
		LOCATE 5, 12
		PRINT "This file doesn't appear to be a true TI99-PC image file ";
		LOCATE 6, 12
		PRINT "('DSK' missing in sector 0).";
		LOCATE 9, 12
		PRINT "Do you still want to go on? (Y/N) ";
		LOCATE 9, 46, 1
		DO: C$ = INKEY$: LOOP UNTIL C$ <> ""
		IF UCASE$(C$) = "Y" THEN GOTO IdentFound
		GOTO Abort

FileNotFound:   RESUME FileNotFound1
FileNotFound1:  ON ERROR GOTO 0  
		CALL box(1, 10, 66, 10)
		LOCATE 2, 12
		PRINT "TI-99/4A Disk Image Filename:"; SourcePath$
		LOCATE 4, 12
		PRINT "Error. The above filename doesn't exist"
FileNotFound2:   LOCATE 5, 12
		PRINT "Please correct and try again"
		LOCATE 7, 22
		PRINT "Press any key"
		BEEP
SomeMore:        DO: U$ = INKEY$: LOOP UNTIL U$ <> ""
		GOTO Abort

DestMissing:
		CALL box(1, 10, 66, 10)
		LOCATE 2, 12
		PRINT "Destination filename is missing:"
		LOCATE 3, 12
		PRINT DestinPath$
		GOTO FileNotFound2


IdentFound:
		TotSect% = CalcWord(d$, 11)
		Tracks% = ASC(MID$(d$, 18, 1))
		Sides% = ASC(MID$(d$, 19, 1)): IF Sides% = 0 THEN Sides% = 1
		Dens% = ASC(MID$(d$, 20, 1)): IF Dens% = 0 THEN Dens% = 1

		SideDensity$ = "(" + MID$("SD", Sides%, 1) + "S/" + MID$("SDH", Dens%, 1) + "D)"
		IF Tracks = 80 AND Dens% = 2 THEN MID$(SideDensity$, 5, 1) = "Q"

		SELECT CASE LEFT$(FType$, 1)
		CASE "V"
		DiskType$ = "V9T9"
		CASE "P"
		DiskType$ = "PC99"
		CASE ELSE
		DiskType$ = "TI99-PC"
		END SELECT


		CurrFileDescrIndex% = 1                        ' Sector containing the File Descriptor Index
		IF Tracks < 80 THEN GOTO NoSubDirExist           ' Only 80 track Geneve disks can have sudirectories
		ChosenDir% = 1                                 ' Array element that is the Chosen Directory
		ActiveDirs% = 0
		FOR T = 1 TO 3
		W = CalcWord(d$, 31 + (12 * (T - 1)))
		IF W = 0 THEN GOTO NextSubDir
		IF T = 1 THEN SubDirStAddr%(1) = 1: SubDirName$(1) = "Root_Dir": ActiveDirs% = ActiveDirs% + 1
		ActiveDirs% = ActiveDirs% + 1
		SubDirStAddr%(ActiveDirs%) = W: SubDirName$(ActiveDirs%) = MID$(d$, 21 + (12 * (T - 1)), 10)
NextSubDir:     NEXT T

NoSubDirExist:
		ErrSect$ = ""

		IF LEFT$(FType$, 1) <> "V" THEN GOTO NoSubDirPoss
		CALL GetVirtualSect(FileNum%, TotSect% + 1, d$)
		ErrSect$ = d$
		CALL GetVirtualSect(FileNum%, TotSect% + 2, d$)
		ErrSect$ = ErrSect$ + d$
		CALL GetVirtualSect(FileNum%, TotSect% + 3, d$)
		ErrSect$ = ErrSect$ + d$
		TotEr% = VAL(MID$(ErrSect$, 13, 8))


NoSubDirPoss:
		FirstDestinPath$ = DestinPath$ ' New Output Filename (just the name, nothing on disk!)
NewSubDir:       
		'GET #1, CurrFileDescrIndex% + 1            ' Get Sector 1: Filename Table, alphabetically ordered
		CALL GetVirtualSect(FileNum%,CurrFileDescrIndex% + 1, d$)  ' Get Sector 1: Filename Table, alphabetically ordered
		TFNames% = 1           ' We have to work out how many filenames there are
NextEl:          sn% = CalcWord(d$, (TFNames%) * 2 - 1)
		IF sn% <> 0 THEN TFNames% = TFNames% + 1: GOTO NextEl
		TFNames% = TFNames% - 1 + ActiveDirs%  ' Well this is how many filenames we've got

		REDIM FilName$(TFNames%)   ' DIM exactly our arrays
		REDIM StartSect%(TFNames%)
		REDIM CopyMark$(TFNames%)
		REDIM FileErrList$(TFNames%)

		FOR T = 1 TO TFNames%    ' Assume users doesn't want to Extract any file
		CopyMark$(T) = " "
		IF ActiveDirs% > 0 AND T = ChosenDir% THEN CopyMark$(T) = ">"
		NEXT T

		FOR T = 1 TO ActiveDirs%    ' If Active Directories exist
		FilName$(T) = SubDirName$(T)
		StartSect%(T) = SubDirStAddr%(T)
		NEXT T

		FOR T = ActiveDirs% + 1 TO TFNames% ' Memorize Starting Sector of all filenames
		StartSect%(T) = CalcWord(d$, (T - ActiveDirs%) * 2 - 1)
		NEXT T

		TotSectorFiles# = 0
		' Get all Filenames with vital parameters
		FOR T% = ActiveDirs% + 1 TO TFNames%
		'GET #1, StartSect%(T%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(T%) + 1, d$)
		FilName$(T%) = MID$(d$, 1, 20)
		J = CalcWord(FilName$(t%), 15) : IF J = -1 THEN J = 0   ' PB 2004.06.05 - Handle FDR Error (BABA)
		TotSectorFiles# = TotSectorFiles# + J			' PB 2004.06.05 - Handle FDR Error (BABA)
		NEXT T%

		' CALL ShowHex(ErrSect$)
		' Work out which file has error, if any
		IF TotEr% = 0 THEN GOTO NoBadSector
		FOR J = 0 TO (TotSect% / 8) - 1
		T$ = MID$(ErrSect$, 33 + J, 1)
		IF ASC(T$) = 0 THEN GOTO NextByte
		FOR W = 0 TO 7
		IF ASC(T$) AND 2 ^ W THEN K = J * 8 + W: GOSUB WorkOutWhichFile
		NEXT W
NextByte:        NEXT J

NoBadSector:
		' Prepare to show all filenames

		CurrentScreenRow% = 1
		TotalScreenRows% = 13     ' Rows to display Filenames
		StartRow% = 7  ' Screen Start Row
		CurrentFilename% = 1
		TotFiles2Copy% = 0
		TotSizeFiles2Copy# = 0                         ' Added on August 27, 2003 from a tip of Ben Yates. Thank you, Ben!
		AllowedKey$ = CHR$(27)                         ' ESC
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(72) ' Arrow Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(80) ' Arrow Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(73) ' Page Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(81) ' Page Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(83) ' Del
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(71) ' Home
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(79) ' End
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(59) ' F1 = Help
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(61) ' F3 = Show Bad Sector
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(64) ' F6 = Proceed
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(65) ' F7 = Show Bad Sector
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(66) ' F8 = Show ARK file directory, if applicable
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(68) ' F10= Trigger a child program (undeveloped)
		AllowedKey$ = AllowedKey$ + CHR$(21)           ' CTRL U = Unmark All
		AllowedKey$ = AllowedKey$ + CHR$(1)            ' CTRL A = Copy All
		AllowedKey$ = AllowedKey$ + CHR$(3)            ' CTRL C
		AllowedKey$ = AllowedKey$ + CHR$(13)           ' Enter = Execute
		AllowedKey$ = AllowedKey$ + "CcMm1234567890 "            ' CcMmXx + Blank +1234567890

		GOSUB TopScreen ' Display Top Part of Title Screen
		'GOSUB DispMem
		IF TFNames% = 0 THEN GOSUB AbsNoFiles: GOTO Leaveit

' ===> ADDED CODE --> RETURN	FROM CHAINED PROGRAM - PART 3 OF 4 -  START	
		ON ERROR GOTO NoChainProgram
		OPEN ReturnFile$ FOR INPUT AS #72
		ON ERROR GOTO 0
		INPUT #72, CurrentFilename% 
	 	INPUT #72, CurrentScreenRow%
	 	INPUT #72, FirstFilename% 
	 	INPUT #72, TotFiles2Copy% 
	 	INPUT #72, TotSizeFiles2Copy# 

                FOR T = 1 TO TFNames%  ' Assume users wants to Copy all files
		LINE INPUT #72,CopyMark$(T) 
		NEXT T
		CLOSE #72
		KILL ReturnFile$
		LastFilename%= FirstFilename% + TotalScreenRows% - 1
		GOSUB RePaintScreen
		GOTO LocateCursor2

		
NoChainProgram:	RESUME NoChainProgram2
NoChainProgram2: ON ERROR GOTO 0	
NoChainProgram3:		
' ===> ADDED CODE --> RETURN	FROM CHAINED PROGRAM - PART 3 OF 4 -  END 
		

'===================================
' DISK CATALOG MAIN LOOP STARTS HERE
'===================================

NextFileName:
		COLOR 7, 0

		IF CurrentScreenRow% = 1 THEN FirstFilename% = CurrentFilename%   ' Get Number of first filename only
		GOSUB DisplayRow  ' Display Current Row

		CurrentFilename% = CurrentFilename% + 1 ' Next Filename


		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		CurrentScreenRow% = CurrentScreenRow% + 1  ' Next Screen Row
		IF CurrentScreenRow% < TotalScreenRows% + 1 AND CurrentFilename% <= TFNames% THEN GOTO NextFileName

'===================================
' DISK CATALOG MAIN LOOP ENDS HERE
'===================================
'
' End of filenames
		GOSUB BottomLine       ' Display Bottom Line
		LastFilename% = CurrentFilename% - 1' Get Number of Last used filename
		CurrentFilename% = FirstFilename%  ' Current filename is now first filename in screen

		CurrentScreenRow% = 1
		IF KeepCursBottom% = 0 THEN GOTO LocateCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last filename in Screen
		CurrentScreenRow% = TotalScreenRows%: KeepCursBottom% = 0: CurrentFilename% = LastFilename%
		GOTO LocateCursor2

LocateCursor:
		GOSUB RestoreColor

LocateCursor2:
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7: GOSUB DisplayRow: COLOR 7, 0 ' Display Current Row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		OldScreenRow% = CurrentScreenRow%
		OldFilename% = CurrentFilename%
		IF GoToThisDir% <> 0 THEN CurrentFilename% = GoToThisDir%: GoToThisDir% = 0: GOTO Executit
		'GOSUB ShowValues    ' My little Debugger

DoitAgain:       DO: U$ = INKEY$: LOOP UNTIL U$ <> ""
		IF INSTR(AllowedKey$, U$) = 0 THEN GOTO DoitAgain

		' ESCape Key
		IF U$ = CHR$(27) THEN GOTO Abort
		' ENTER Key
		IF U$ <> CHR$(13) THEN GOTO IsArrowDown
		IF TotEr% > 0 AND FileErrList$(CurrentFilename%) <> "" THEN GOTO OtherKey9B
		IF CurrentFilename% > ActiveDirs% THEN GOTO StartCopying
		IF CurrentFilename% = ChosenDir% THEN GOTO StartCopying
ChangeDir:     
                ChosenDir% = CurrentFilename%
		GoToThisDir% = CurrentFilename%
		CurrFileDescrIndex% = SubDirStAddr%(CurrentFilename%)
		CALL Fischio
		GOTO NewSubDir

IsArrowDown:    ' Arrow Down Key
		IF U$ <> CHR$(0) + CHR$(80) THEN GOTO OtherKey0
IsArrowDown1:   IF CurrentScreenRow% < LastScreenRow% THEN CurrentScreenRow% = CurrentScreenRow% + 1: CurrentFilename% = CurrentFilename% + 1: GOTO LocateCursor
		IF CurrentFilename% = TFNames% THEN GOTO LocateCursor
		CurrentFilename% = FirstFilename% + 1
		KeepCursBottom% = 1
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey0:      'Arrow up Key
		IF U$ <> CHR$(0) + CHR$(72) THEN GOTO OtherKey1
		IF CurrentFilename% = 1 THEN GOTO NoMatch
		IF CurrentScreenRow% > 1 THEN CurrentScreenRow% = CurrentScreenRow% - 1: CurrentFilename% = CurrentFilename% - 1: GOTO LocateCursor
		CurrentFilename% = FirstFilename% - 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey1:      ' Page Up Key
		IF U$ <> CHR$(0) + CHR$(73) THEN GOTO OtherKey2
		CurrentFilename% = FirstFilename% - TotalScreenRows%
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey2:      ' Page Down Key
		IF U$ <> CHR$(0) + CHR$(81) THEN GOTO OtherKey4
		IF LastFilename% + 1 + TotalScreenRows% > TFNames% THEN CurrentFilename% = TFNames% - TotalScreenRows% + 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1: GOTO Executit
		CurrentFilename% = FirstFilename% + TotalScreenRows%
		IF CurrentFilename% > TFNames% THEN CurrentFilename% = FirstFilename%
		GOTO Executit

OtherKey4:      ' C or c, M or m
		IF U$ <> "c" AND U$ <> "C" AND U$ <> "M" AND U$ <> "m" THEN GOTO OtherKey5
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# + SectorLength#
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7
		CopyMark$(CurrentFilename%) = "C": PRINT "C";
		GOSUB DispFilestoCopy
		GOTO IsArrowDown1

OtherKey5:      ' CTRL U = Unmark all
		IF U$ <> CHR$(21) THEN GOTO OtherKey6
		FOR T = ActiveDirs% + 1 TO TFNames%  ' Assume users wants to Copy all files
		CopyMark$(T) = " "
		NEXT T

		TotFiles2Copy% = 0
		TotSizeFiles2Copy# = 0
		GOSUB RePaintScreen
		GOTO NoMatch

OtherKey6:      ' CTRL A = Mark all
		IF U$ <> CHR$(1) AND U$ <> CHR$(3) THEN GOTO OtherKey7
		FOR T = ActiveDirs% + 1 TO TFNames%  ' Assume users wants to Copy all files
		IF CopyMark$(T) = " " THEN CopyMark$(T) = "C"
		NEXT T

		TotFiles2Copy% = TFNames%
		TotSizeFiles2Copy# = TotSectorFiles#
		GOSUB RePaintScreen
		GOTO NoMatch

OtherKey7:      ' Home Key : simply move cursor to top
		IF U$ <> CHR$(0) + CHR$(71) THEN GOTO OtherKey8
		CurrentScreenRow% = 1: CurrentFilename% = FirstFilename%: GOTO LocateCursor


OtherKey8:      ' End Key : simply move cursor to bottom
		IF U$ <> CHR$(0) + CHR$(79) THEN GOTO OtherKey9
		CurrentScreenRow% = LastScreenRow%: CurrentFilename% = LastFilename%
		GOTO LocateCursor
        
OtherKey9:      ' F3 = Show Error List
		IF U$ <> CHR$(0) + CHR$(61) THEN GOTO OtherKey10
		IF TotEr% = 0 OR FileErrList$(CurrentFilename%) = "" THEN GOTO NoMatch
OtherKey9B:     GOSUB ShowErrorList
		GOSUB RePaintScreen
		GOTO NoMatch



OtherKey10:     ' F7 = Show Sector as Hex
		IF U$ <> CHR$(0) + CHR$(65) THEN GOTO OtherKey11
		IF CurrentFilename% <= ActiveDirs% THEN GOTO NoMatch
		GOSUB ShowSector
		GOSUB RePaintScreen
		GOTO NoMatch

OtherKey11:     ' 0-9 priority while copying
		IF U$ < "0" OR U$ > "9" THEN GOTO OtherKey12
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# + SectorLength#
		CopyMark$(CurrentFilename%) = U$
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7
		PRINT CopyMark$(CurrentFilename%);
		GOSUB DispFilestoCopy
		GOTO IsArrowDown1


OtherKey12:     ' DEL key
		IF U$ <> " " AND U$ <> CHR$(0) + CHR$(83) THEN GOTO OtherKey13
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) <> " " THEN TotFiles2Copy% = TotFiles2Copy% - 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# - SectorLength#
		CopyMark$(CurrentFilename%) = " "
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7
		PRINT CopyMark$(CurrentFilename%);
		GOSUB DispFilestoCopy
		GOTO IsArrowDown1
		
'========SHOW ARK FILE
OtherKey13:     IF U$ <> CHR$(0) + CHR$(66) THEN GOTO OtherKey14     ' F8 = I ARK file, display it
		IF CurrentFilename% <= ActiveDirs% THEN GOTO NoMatch

		IF ASC(MID$(FilName$(CurrentFilename%), 18, 1)) <> 128 THEN GOTO NoMatch
		FileType% = ASC(MID$(FilName$(CurrentFilename%), 13, 1))
		FileType% = FileType% AND &H8B
		FileType% = FileType% AND &HF7
		SELECT CASE FileType%
		CASE 0, 2 ' "Dis/Fix"
		GOSUB ARKextract
		CLS
		COLOR 14, 0

		PRINT TAB(15); "Catalog of Archive File: "; MID$(FilName$(CurrentFilename%), 1, 10)
		Exec$ = "Decomp4.com " + TempArk$ + " /s"
		SHELL Exec$
		COLOR 7, 0
		CLS
		END SELECT

		GOSUB RePaintScreen
		GOTO NoMatch



OtherKey14:     ' F1 (Help) key
		IF U$ <> CHR$(0) + CHR$(59) THEN GOTO OtherKey15
		CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "17.04.00")
		GOSUB RePaintScreen
		GOTO LocateCursor


OtherKey15:	' F10 = Triggers a child program (not fully developed yet)
		IF U$ <> CHR$(0) + CHR$(68) THEN GOTO OtherKey16

' ===> ADDED CODE --> RETURN	FROM CHAINED PROGRAM - PART 4 OF 4 - START		
		OPEN ReturnFile$ FOR OUTPUT AS #72
		
		PRINT #72, CurrentFilename% 
	 	PRINT #72, CurrentScreenRow%
	 	PRINT #72, FirstFilename% 
	 	PRINT #72, TotFiles2Copy% 
	 	PRINT #72, TotSizeFiles2Copy# 
	 	
	 	FOR T = 1 TO TFNames%  ' Assume users wants to Copy all files
		PRINT #72,CopyMark$(T) 
		NEXT T
		CLOSE #72
		CLOSE #FileNum%
		CHAIN "SplitimA.bas"
		GOTO NoMatch 
		
' ===> ADDED CODE --> RETURN	FROM CHAINED PROGRAM - PART 4 OF 4 - END 


OtherKey16:	' F6 = Proceed
		IF U$ <> CHR$(0) + CHR$(64) THEN GOTO OtherKey17
		GOTO StartCopying

OtherKey17:
		GOTO NoMatch

Redraw:          CurrentFilename% = FirstFilename%
Executit:
		CurrentScreenRow% = 1     ' Cursor on first screen row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		GOTO NextFileName   ' Start next round

NoMatch:         GOTO LocateCursor

'==========================
' COPY DISK STARTS HERE
'==========================

StartCopying:    CLS 
		IF TotFiles2Copy%>0 THEN GOTO NotEmpty
		CALL box(1, 1, 78, 11)
		LOCATE 3, 3
		PRINT "No filename has been selected"
		LOCATE 9, 3
		PRINT "Try again. "
		LOCATE 9, 17, 1
		DO: C$ = INKEY$: LOOP UNTIL C$ <> ""

		GOTO NoCopying

NotEmpty:       

		CALL box(1, 3, 76, 24)

		IF MyVal(1) <> 0 THEN BEEP
		LOCATE 2, 28: PRINT "AVAILABLE DISK SIZES"
		LOCATE 4, 5: PRINT " 1)   90K  - SSSD   -  360 sectors -  9 sctr/trk - 40 tracks"
		COLOR  14,0
		LOCATE 5, 5: PRINT " 2)  180K  - DSSD   -  720 sectors -  9 sctr/trk - 40 tracks <"
		COLOR 7,0
		LOCATE 6, 5: PRINT " 3)  180K  - SSDD   -  720 sectors - 18 sctr/trk - 40 tracks"
		COLOR  14,0
		LOCATE 7, 5: PRINT " 4)  360K  - DSDD   - 1440 sectors - 18 sctr/trk - 40 tracks <"
		COLOR 7,0
		LOCATE 8, 5: PRINT " 5)  360K  - SSHD   - 1440 sectors - 36 sctr/trk - 40 tracks"
		LOCATE 9, 5: PRINT " 6)  720K  - DSHD   - 2880 sectors - 36 sctr/trk - 40 tracks"


		LOCATE 11, 5: PRINT " 7)  180K  - SSSD   -  720 sectors -  9 sctr/trk - 80 tracks"
		LOCATE 12, 5: PRINT " 8)  360K  - DSSD   - 1440 sectors -  9 sctr/trk - 80 tracks"

		LOCATE 13, 5: PRINT " 9)  360K  - SSQD   - 1440 sectors - 18 sctr/trk - 80 tracks"
		LOCATE 14, 5: PRINT " A)  720K  - DSQD   - 2880 sectors - 18 sctr/trk - 80 tracks"

		LOCATE 15, 5: PRINT " B)  720K  - SSHD   - 2880 sectors - 36 sctr/trk - 80 tracks"
		LOCATE 16, 5: PRINT " C) 1440K  - DSHD   - 5760 sectors - 36 sctr/trk - 80 tracks"



UsrChoice:       COLOR  14,0
		LOCATE 21, 5: PRINT " < marks the most common formats"
		COLOR 7,0
		LOCATE 19, 6
		PRINT "Your choice: ";
		DO
		T$ = INKEY$
		LOOP UNTIL T$ <> ""
		IF T$=CHR$(0) + CHR$(59) THEN CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "18.04.03"): CLS: GOTO StartCopying
		IF T$ = CHR$(27) THEN GOTO NoCopying
		IF LEN(T$)>1 THEN GOTO NoCopying
		IF INSTR("abc",T$)>0 THEN T$=CHR$(ASC(RIGHT$(T$, 1) ) AND (255-32)) ' Force Uppercase
		Size=INSTR("123456789ABC",T$)
		IF Size=0 THEN GOTO NoCopying
		TmpSize = Size
		PRINT T$;

		GOTO StartCopying2

NoCopying:	CLS
		GOSUB RePaintScreen
		GOTO NoMatch


'===================
' START COPYING
'===================
StartCopying2:

		CLS

		' Get all Filenames with vital parameters

'********************************=
' CURRENT FILENAME : START OF LOOP
'********************************=   
		Skipped% = 0
		DisksRound% = 1
		FirstDisk$ = ""
		LowLimit% = INT(LowestSect(TmpSize) / 8)
		Remaindr% = LowestSect(TmpSize) MOD 8
		SelStr$ = "0123456789C"

		FOR Order% = 1 TO LEN(SelStr$)
		Tell$ = MID$(SelStr$, Order%, 1)
		AtLeast$ = ""


		FOR FileInArray% = ActiveDirs% + 1 TO TFNames%
		IF Tell$ <> CopyMark$(FileInArray%) THEN GOTO NextFile
		IF AtLeast$ = "" THEN GOSUB MakeOutfile: GOSUB CreateDisk: AtLeast$ = "X"
		FileToCopy% = FileInArray%
		GOSUB TxferThisFile

		IF C$ <> "" THEN GOTO GoLeaveIt
NextFile:        
		NEXT FileInArray%
		IF AtLeast$ <> "" THEN GOSUB CloseOutput
		NEXT Order%

		GOTO GoLeaveIt

'******************************=
' CURRENT FILENAME : END OF LOOP
'******************************=
EndForced:
		GOSUB CloseOutput              'Close Output file
GoLeaveIt:       PRINT
		PRINT "= WHAT HAPPENED IN THIS ROUND ="
		PRINT "- Total Files Copied   :"; TotFiles2Copy% - Skipped%
		PRINT "- Total Files Skipped  :"; Skipped%
		PRINT "- Total Disks          :"; DisksRound%
		PRINT "- First Disk name      : "; FirstDestinPath$
		PRINT "- Last  Disk name      : "; DestinPath$
		PRINT
		PRINT "Press any key to continue"
		CopiedDirs$(ChosenDir%) = "Y"
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		CLS
		'IF ActiveDirs% > 0 THEN GOSUB MakeOutfile: GOTO NoSubDirPoss ELSE GOTO Leaveit
		GOSUB MakeOutfile: GOTO NoSubDirPoss
'*************************
' TRANSFER THE FILE
'*************************       
TxferThisFile:


ThisFileAgain:
		LeftOver2880% = 0
		LeftOver5760% = 0  : LeftOver5760cnt%=0
		'GET #1, StartSect%(FileToCopy%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(FileToCopy%) + 1, d$)
		FHeader$ = d$
		FOut$ = MID$(FHeader$, 1, 10)


		OutFDRSectr$ = d$ ' Current File File Descriptor Record in Output File
		MID$(OutFDRSectr$, 29) = STRING$(228, CHR$(0))' Blank the Data Chain Pointer Block area
		FIDChain% = 29 ' Pointer to First In Data Chain Pointer Block in Output File Descriptor Record
		SectorLength# = CalcWord(FilName$(FileToCopy%), 15) + 1

		' OPEN   DestinPath$ FOR RANDOM ACCESS WRITE AS #2 LEN = 256

		' Check if file fits
		IF SectorLength# > DiskSize(TmpSize) - 2 THEN GOTO SkipThisFile
		IF StillFree% - SectorLength# < 0 THEN GOTO AbortThisFile

		PRINT "("; FileToCopy%; ") "; FOut$
		' Get a free block (2 consecutive bytes: 1-2, 3-4, and so on ..) in sector 1
		' File Descriptor Index Record

		FOR FDIRT% = 1 TO 254 STEP 2
		B1$ = MID$(OutSectrOne$, FDIRT%, 1): B2$ = MID$(OutSectrOne$, FDIRT% + 1, 1)
		IF ASC(B1$) = 0 AND ASC(B2$) = 0 THEN GOTO FreeEntryFound
		NEXT FDIRT%
		GOTO AbortThisFile


FreeEntryFound: ' Also, Find a free sector for FDR (File Descriptor Record)
		'
		FOR T% = 1 TO 200
		CV% = ASC(MID$(OutSectrZero$, 56 + T%, 1))
		IF CV% = 255 THEN GOTO NextBlock
		FOR ex% = 0 TO 7
		IF (CV% AND 2 ^ ex%) = 0 THEN GOTO GotFreeSec
		NEXT ex%

NextBlock:      NEXT T%
		BEEP
		INPUT "UNKNOWN ERROR IN ALLOCATION BIT MAP IN SECTOR ZERO. ", C$:
		GOSUB CloseOutput              'Close Output file
		GOTO GoLeaveXfer

GotFreeSec:     '*------- Update Sector Zero
		CV% = CV% + 2 ^ ex%
		MID$(OutSectrZero$, 56 + T%) = CHR$(CV%)' Mark that sector as used on Sector Zero
		NewFDR% = (T% - 1) * 8 + ex%   ' Get the free sector number (first sect. is sect. 0)

		IF DiskSize(TmpSize) = 2880 THEN NewFDR% = NewFDR% * 2: StillFree% = StillFree% - 1' Update Free sector/disk
		IF DiskSize(TmpSize) = 5760 THEN NewFDR% = NewFDR% * 4: StillFree% = StillFree% - 3' Update Free sector/disk
		'*------- Update Sector 1
		L1$ = CHR$(INT(NewFDR% / 256)): L2$ = CHR$(NewFDR% MOD 256)

		MID$(OutSectrOne$, FDIRT%) = L1$ + L2$' Update Sector 1 (File Descriptor Index Record)

		StillFree% = StillFree% - 1' Update Free sector/disk


		OldFreeSect% = 0           ' Old Current Output File New Sector
		Z = 0                      ' Offset in Input File Chain Pointer Block
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		GlobalOutOffset% = 0       ' GLOBAL Offset in Output File Chain Pointer Block
		SectorCnt% = SectorLength# - 1' Sector Length of this file


'++++++++++++++++++++++++++++++++++++++++
' CURRENT FILENAME : START OF CHAIN BLOCK
'++++++++++++++++++++++++++++++++++++++++    

NextClusterPr:
		GOSUB CalcClusters
		' If Chain doesn't exist for this Filename (Dummy Filename, very rare, maybe FAT error)
		IF StSec% = 0 AND OldFreeSect% = 0 THEN GOSUB WriteFDR: GOTO NotThisOne
		'
		IF StSec% = 0 THEN GOTO EOThisFilePr
		'PRINT "A="; HEX$(A); A
		'PRINT "B="; HEX$(b); b
		'PRINT "C="; HEX$(c); c
		'PRINT "Start Sector="; StSec%
		'PRINT "Offset="; Offs%
		'INPUT c$
		'<------------> START OF THE SAME CHAIN BLOCK

NextOffsVal:
		IF GlobalInpOffset% > Offs% THEN Z = Z + 3: GOTO NextClusterPr
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		IF OldFreeSect% = 0 THEN

		GOSUB GetAFreeSect         ' Get Current Output File New Sector
		IF NewFreeSect% = 0 THEN GOTO AbortThisFile
		FirstFreeSectIDC% = NewFreeSect% ' First Free sector for Data Chain Pointer Block
		OldFreeSect% = NewFreeSect%: GOTO SectorsInARow
		END IF

		GOSUB GetAFreeSect      ' Get Current Output File New Sector
		IF NewFreeSect% = 0 THEN GOTO AbortThisFile
		IF OldFreeSect% = NewFreeSect% THEN GOTO SectorsInARow

		GOSUB WriteChainPointers
		GlobalOutOffset% = GlobalOutOffset% + 1  ' Adjust Global Output Offset
		IF FIDChain% = 0 THEN GOTO NotThisOne  ' Error case: File Index Directory Table is full!

SectorsInARow:  LSET DataSec$ = d$
		PUT #2, NewFreeSect% + 1
		IF FileErrList$(FileToCopy%) = "" THEN GOTO NichtBadSect

		ErrOff% = INT((StSec% + OffsVal%) / 8)
		ErrBit% = (StSec% + OffsVal%) MOD 8
		IF (ASC(MID$(ErrSect$, 33 + ErrOff%, 1)) AND 2 ^ ErrBit%) = 0 THEN GOTO NichtBadSect
		' PRINT HEX$(ASC(MID$(ErrSect$, 33 + ErrOff%, 1))); " - ";StSec% + OffsVal%;ErrOff%;ErrBit%; :INPUT "Zero",c$
		' Update Output Error Table
		ErrOff% = INT((NewFreeSect%) / 8)
		ErrBit% = (NewFreeSect%) MOD 8
		T = ASC(MID$(OutErrTable$, 33 + ErrOff%, 1))
		T = T + (2 ^ ErrBit%)
		MID$(OutErrTable$, 33 + ErrOff%, 1) = CHR$(T)
		T = VAL(MID$(OutErrTable$, 13, 8))
		T = T + 1
		T$ = LTRIM$(RTRIM$(STR$(T))): T$ = SPACE$(8 - LEN(T$)) + T$
		MID$(OutErrTable$, 13, 8) = T$



NichtBadSect:   OldFreeSect% = OldFreeSect% + 1   ' Old Current Output File New Sector
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1: GOTO NextOffsVal

'+++++++++++++++++++++++++++++++++++++=
' CURRENT FILENAME : END OF CHAIN BLOCK
'+++++++++++++++++++++++++++++++++++++=

AbortThisFile:

		GOSUB CloseOutput   ' Close Output file
		GOSUB MakeOutfile   ' Get next output Filename
		GOSUB CreateDisk    ' Create and open next output Filename
		GOTO ThisFileAgain  ' Process current file again

SkipThisFile:   CALL ERRSOUND
		PRINT "File "; FOut$; " is too long ("; SectorLength#; "sectors) and doesn't fit into the chosen"
		PRINT "empty disk ("; DiskSize(TmpSize); " sectors). It will be skipped!"
		INPUT "", C$
		Skipped% = Skipped% + 1
		GOTO NotThisOne     ' Process Nextfile
EOThisFilePr:

		GOSUB UpdateChainPointers

NotThisOne:      C$ = "": GOTO TxferEnd
GoLeaveXfer:     C$ = "X"' Error condition: UNKNOWN ERROR IN ALLOCATION BIT MAP IN SECTOR ZERO
TxferEnd:
		RETURN

'=======================
' UDPADTE CHAIN POINTERS
'=======================

UpdateChainPointers:
		GOSUB WriteChainPointers       ' Update Data Chain Pointers
WriteFDR:      
		LSET DataSec$ = OutFDRSectr$
		PUT #2, NewFDR% + 1              ' Write FDR

		LSET DataSec$ = OutSectrZero$
		PUT #2, 1
		LSET DataSec$ = OutSectrOne$
		PUT #2, 2
		RETURN

'=================
'CLOSE OUTPUT FILE
'=================
CloseOutput:
		LSET DataSec$ = OutSectrZero$
		PUT #2, 1
		LSET DataSec$ = OutSectrOne$
		PUT #2, 2
		T$ = MID$(OutErrTable$, 1, 256)
		LSET DataSec$ = T$
		PUT #2, DiskSize(TmpSize) + 1
		T$ = MID$(OutErrTable$, 1 + 256, 256)
		LSET DataSec$ = T$
		PUT #2, DiskSize(TmpSize) + 2
		T$ = MID$(OutErrTable$, 1 + 256 + 256, 256)
		LSET DataSec$ = T$
		PUT #2, DiskSize(TmpSize) + 3


		CLOSE #2
		IF AppendF$="Y" THEN CALL AlphaDir(DxPath$) ' Order Alphabetically the filenames if it was an Append Disk operation

		RETURN

'===================================
' GET A NEW FREE SECTOR
'===================================
' To get a free sector we have to look up the Allocation Bit Map in Sector Zero.
' It starts at offset 56 from the beginning.
' Each bit is a sector
' +-----------------+---------------+
' |  1st byte = 0   | 1st byte = 1  |
' |  in sector      | in sector     |
' +-----------------+---------------+
' |  Offset = 56    | Offset =57    |
' +-----------------+---------------+
'


GetAFreeSect:          
		IF DiskSize(TmpSize) = 2880 AND LeftOver2880% <> 0 THEN NewFreeSect% = LeftOver2880%: LeftOver2880% = 0: GOTO NewFreeSectExit
		' 5760 sector handling
		IF DiskSize(TmpSize) <> 5760 THEN GOTO GetAFreeSect1
		IF LeftOver5760cnt%=0 THEN GOTO GetAFreeSect1
		LeftOver5760cnt%= LeftOver5760cnt%-1
		NewFreeSect% = LeftOver5760%
		IF LeftOver5760cnt%=0 THEN LeftOver5760%=0 ELSE LeftOver5760% = LeftOver5760% + 1
		GOTO NewFreeSectExit

GetAFreeSect1:           
		' Check first with remainder
		IF Remaindr% = 0 THEN GOTO GetAFreeSect2
		T% = LowLimit%
		CV% = ASC(MID$(OutSectrZero$, 57 + T%, 1))
		FOR ex% = Remaindr% TO 7
		IF (CV% AND 2 ^ ex%) = 0 THEN GOTO GotNewFreeSec
		NEXT ex%

		' Then, check starting from Lowest Data sector
GetAFreeSect2:
		FOR T% = LowLimit% + 1 TO UpperABM(TmpSize) - 1
		CV% = ASC(MID$(OutSectrZero$, 57 + T%, 1))
		IF CV% = 255 THEN GOTO GetAFreeSect3
		FOR ex% = 0 TO 7
		IF (CV% AND 2 ^ ex%) = 0 THEN GOTO GotNewFreeSec
		NEXT ex%

GetAFreeSect3:   NEXT T%

		' Finally , check the FDR area
		FOR T% = 0 TO LowLimit%
		CV% = ASC(MID$(OutSectrZero$, 57 + T%, 1))
		IF CV% = 255 THEN GOTO GetAFreeSect4
		FOR ex% = 0 TO 7
		IF (CV% AND 2 ^ ex%) = 0 THEN GOTO GotNewFreeSec
		NEXT ex%

GetAFreeSect4:   NEXT T%
		BEEP
		PRINT

		PRINT "ERROR: FREE SECTOR NOT FOUND IN ALLOCATION BIT MAP IN SECTOR ZERO. "
		PRINT "CURRENT FILE ON THIS DISK ("; DestinPath$; ") WILL BE ABORTED"; : INPUT "", C$
		GOSUB WriteChainPointers       ' Update Data Chain Pointers
		LSET DataSec$ = OutFDRSectr$
		PUT #2, NewFDR% + 1              ' Write FDR
		NewFreeSect% = 0
		GOTO NewFreeSectExit

GotNewFreeSec:    '*------- Update Sector Zero
		CV% = CV% + 2 ^ ex%
		MID$(OutSectrZero$, 57 + T%) = CHR$(CV%) ' Mark that sector as used on Sector Zero
		NewFreeSect% = T% * 8 + ex%   ' Get the free sector number
		IF DiskSize(TmpSize) = 2880 THEN NewFreeSect% = NewFreeSect% * 2: LeftOver2880% = NewFreeSect% + 1
		IF DiskSize(TmpSize) = 5760 THEN NewFreeSect% = NewFreeSect% * 4: LeftOver5760% = NewFreeSect% + 1: LeftOver5760cnt%=3
		IF FirstFreeSectIDC% = 0 THEN FirstFreeSectIDC% = NewFreeSect%

		StillFree% = StillFree% - 1' Update Free sector/disk
NewFreeSectExit:
		RETURN

' Prepare file to be cataloged upon by LZW decompressor
ARKextract:     'GET #1, StartSect%(CurrentFilename%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(CurrentFilename%) + 1, d$)
		FHeader$ = d$
		SectorLength# = CalcWord(FilName$(CurrentFilename%), 15) + 1
		Z = 0                      ' Offset in Input File Chain Pointer Block
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		SectorCnt% = SectorLength# - 1' Sector Length of this file
		OPEN TempArk$ FOR BINARY ACCESS WRITE AS #2
		GOSUB DoDisFix2
		RETURN


DoDisFix:        OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #2
DoDisFix2:       Z = 0: Tog% = 1: BytePos& = 1: Trecs& = 0
		TotRecs& = ASC(MID$(FHeader$, 20, 1)) * 256 + ASC(MID$(FHeader$, 19, 1))
		RecsInSect% = ASC(MID$(FHeader$, 14, 1))
		LogRecLength% = ASC(MID$(FHeader$, 18, 1))

		' Special case: Archiver III files are sometimes bugged. The Total Records (Bytes 19+20 in FDR)
		' sometimes report 256 records less than what it should.
		' The following patch compares the Total Records
		' with the Total Sector*2 which, in a dis/fix 128 record should be more or less comparable.
		' If this is not the case, adds 256 bytes to previous value
		' Trecs&=0:GOTO NextClusterDF

		IF LogRecLength% <> 128 THEN GOTO NextClusterDF
		T& = (SectorCnt% - 1) * 2
		IF T& <= TotRecs& THEN GOTO NextClusterDF
		TotRecs& = TotRecs& + 256
		' PRINT " (fixed!)";
		' print  "Total Records="; TotRecs&  :input c$

NextClusterDF:   GOSUB CalcClusters
		IF StSec% = 0 THEN GOTO EOThisFileDF
		'PRINT "A="; HEX$(a); a
		'PRINT "B="; HEX$(B); B
		'PRINT "C="; HEX$(c); c
		'PRINT "Start Sector="; StSec%;" >";HEX$(StSec%)
		'PRINT "Offset="; Offs%;" >";HEX$(Offs%)
		'PRINT "TotRecs&="; TotRecs&;" >";HEX$(TotRecs&)
		'INPUT "", c$

NextOffsValDF:

		IF GlobalInpOffset% > Offs% THEN Z = Z + 3: GOTO NextClusterDF

		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)


		GOSUB RecToDoDF
		IF TotRecs& < 1 THEN GOTO EOThisFileDF
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1

		' DoneSect=DoneSect+1: PRINT TotRecs&;DoneSect; GlobalInpOffset%

		GOTO NextOffsValDF

EOThisFileDF:  
		CLOSE #2

		RETURN

' Transfer a Dis/Var record (Text)
RecToDoDF:                  ROff% = 1

RecToDoDFAG:                FOR RT% = 1 TO RecsInSect%
		DFRec$ = MID$(d$, ROff%, LogRecLength%)
		PUT #2, BytePos&, DFRec$: BytePos& = BytePos& + LogRecLength%
		ROff% = ROff% + LogRecLength%
		TotRecs& = TotRecs& - 1
		Trecs& = Trecs& + 1
		IF TotRecs& < 1 THEN GOTO RecDoneDF
		NEXT RT%

RecDoneDF:                  RETURN

'===============================================
' CALCULATE CURRENT ENTRY IN CHAIN POINTER TABLE
'===============================================
' The second 3 nibble block contains the highest OFFSET within each Chain Block.
' This value must never be higher than SectorCnt% - 1, which is the file total length - 2,
' as it appears on Disk Catalog.
' This corrects the bug on 80 track disks, that have the last second 3 nibble block wrong on
' ODD LENGTH FILES (1 sector longer).
' If not corrected, this bug would create an error on lower size disks.

CalcClusters:	IF Z > 227 THEN StSec% = 0 : GOTO CalcClustend  	' PB 2004.06.05 - Handle FDR Error (BABA) -    
		A = ASC(MID$(FHeader$, 28 + 1 + Z, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z, 1))
		BA% = B MOD 16
		BB% = INT(B / 16)
		StSec% = BA% * 256 + A
		IF TotSect% > 3000 THEN StSec% = StSec% * 4
		Offs% = C * 16 + BB
		IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		OffsVal% = 0               ' Offset in EACH Input  File Chain Pointer Block

		GOTO CalcClustend     ' Skip the below check, which has been superseeded by the simpler
		' above approach:  IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		' Nonetheless, I leave it where it is because it might be still needed for some
		' 80 track disks that have a wrong file length, besides having
		' a wrong chain point table length.

' 
' Special case: in a 80 track Double Side Disk, when file length is EVEN (SectorLength# in my code), the
' Chain Point Table reports 1 sector more than what it should. When copying, we have to use avoid using
' that extra sector. Method: always check if there is a next Data Chain. If there is, do nothing. Otherwise,
' that means we are are the end of the Data Chain, and we have to use a sector less.
' SectorLength#


		IF Dens% < 2 OR Tracks < 80 THEN GOTO CalcClustend
		IF SectorLength# <> (INT(SectorLength# / 2)) * 2 THEN GOTO CalcClustend
		A = ASC(MID$(FHeader$, 28 + 1 + Z + 3, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z + 3, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z + 3, 1))
		IF A <> 0 OR B <> 0 OR C <> 0 THEN GOTO CalcClustend
		Offs% = Offs% - 1
CalcClustend:      

		RETURN

'===============================
' WRITE DATA CHAIN POINTER BLOCK
'===============================
WriteChainPointers:
		' IF OldFreeSect% = 0 THEN GOTO NoChainPointr
		IF FIDChain% < 253 THEN GOTO WriteChainP2
		PRINT "Data Chain Pointer Block Table Full for file: "; FOut$; ". Disk is too fractured!"
		PRINT "This file will be closed and will remain uncomplete.";
		INPUT "", C$
		LSET DataSec$ = OutFDRSectr$
		PUT #2, NewFDR% + 1               ' Write FDR
		FIDChain% = 0                  ' This to make the caller understand that table is full
		GOTO NoChainPointr

WriteChainP2:
		Other% = OldFreeSect% - FirstFreeSectIDC% - 1
		GlobalOutOffset% = GlobalOutOffset% + Other%
		FFreeSectIDC% = FirstFreeSectIDC%
		IF DiskSize(TmpSize) < 3000 THEN GOTO WriteChainP3 ' Special Case: DSHD disk (5760 Sectors) have chain block/4
		FFreeSectIDC% = INT(FirstFreeSectIDC% / 4)
WriteChainP3:
		ss3% = INT(FFreeSectIDC% / 256)
		ss1% = FFreeSectIDC% MOD 16
		ss2% = FFreeSectIDC% - (ss3% * 256) - ss1%
		ss2% = INT(ss2% / 16)

		of3% = INT(GlobalOutOffset% / 256)
		of1% = GlobalOutOffset% MOD 16
		of2% = GlobalOutOffset% - (of3% * 256) - of1%
		of2% = INT(of2% / 16)
		T$ = CHR$(ss2% * 16 + ss1%) + CHR$(of1% * 16 + ss3%) + CHR$(of3% * 16 + of2%)
		MID$(OutFDRSectr$, FIDChain%) = T$
		FIDChain% = FIDChain% + 3
		' BUG FIX      Sept 2003 - LeftOver2880% = 0                       ' No Left Over for 2880 sector disk on this Chain
		' BUG FIX      Sept 2003 - LeftOver5760% = 0  : LeftOver5760cnt%=0 ' No Left Over for 5760 sector disk on this Chain
		OldFreeSect% = NewFreeSect%
		FirstFreeSectIDC% = NewFreeSect%
NoChainPointr:
		RETURN

'============================
' CREATE OUTPUT FILENAME
'============================
MakeOutfile:     IF FirstDisk$ = "" THEN FirstDisk$ = "X": GOTO MakeOutfile3
		Incr% = Incr% + 1
		DisksRound% = DisksRound% + 1
		Last$ = MID$(OutName$, LEN(OutName$), 1)
		IF Last$ = "9" THEN Last$ = "A": GOTO MakeOutfile2
		IF Last$ = "Z" OR Last$ = "z" THEN Last$ = "A": GOTO MakeOutfile2
		Last$ = CHR$(ASC(Last$) + 1)
MakeOutfile2:    MID$(OutName$, LEN(OutName$), 1) = Last$
		DPath$ = OutPath$ + OutName$
		DestinPath$ = MPath$ + OutName$
MakeOutfile3:           
		RETURN

'=======================================
' CREATE VIRTUAL DISK (EMPTY IMAGE FILE)
'=======================================
CreateDisk:
		TmpSize = Size         ' User's Size
		AppendF$=""     ' Append Disk Flag
		PRINT "New Disk name: "; DestinPath$
		DxPath$=DestinPath$

		CALL CreateShortName(DxPath$,CR$)
		IF CR$<>"" then GOTO CreateGoOn3
		ON ERROR GOTO CreateNoExists
		OPEN DxPath$ FOR INPUT ACCESS READ AS #2   ' Avoid creation of file is file doesn't exist
		CLOSE #2: ON ERROR GOTO 0

CreateExists:   BEEP
CreateExists2:  CALL box(1, 1, 78, 14)
		LOCATE 2, 3: PRINT "The following disk image file:";
		LOCATE 3, 3: PRINT DestinPath$;
		LOCATE 4, 3: PRINT "already exists. ";
		LOCATE 6, 3: PRINT "You may:"
		LOCATE 7, 3: PRINT "- Overwrite [O]";
		LOCATE 8, 3: PRINT "- Skip      [S]"
		LOCATE 9, 3: PRINT "- Append    [A]"
		LOCATE 11, 42: PRINT "Your choice: O/S/A ? ";
		
		PRINT K$
		IF K$ = "O" THEN CLS : GOTO CreateGoOn2
		IF K$ <> "A" THEN GOTO NotAppend
		CLS : GOSUB CreateOpen: GOSUB SubtrUsdSectors
		IF AppendF$="Y" THEN RETURN
		CLOSE #2 :K$="S"  ' Else skip this file

NotAppend:      IF K$ = "S" THEN CLS : GOSUB MakeOutfile: DisksRound% = DisksRound% - 1 : GOTO CreateDisk' Try again withj new filename
		DO: K$ = INKEY$: LOOP UNTIL K$ <> "": K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO Leaveit
		CALL ERRSOUND: GOTO CreateExists2

CreateNoExists: RESUME CreateGoOn
CreateGoOn:     ON ERROR GOTO 0

CreateGoOn2:    OPEN DxPath$ FOR BINARY ACCESS WRITE AS #2
		CLOSE #2
		KILL DxPath$
		DxPath$=DestinPath$
		CALL CreateShortName(DxPath$,CR$)
CreateGoOn3:    OPEN DxPath$ FOR BINARY ACCESS WRITE AS #2
		Z = 0: Tog% = 1: BytePos& = 1

		' Add termination to TI99/4A filename '01', '02' and son on
		FOR T = 10 TO 1 STEP -1
		T$ = MID$(DskName$, T, 1):
		IF T$ = " " OR T$ = CHR$(0) THEN GOTO CreateDisk1 ELSE P = T + 1: GOTO CreateDisk2
CreateDisk1:     NEXT T: P = 1

CreateDisk2:    IF P > 8 THEN NewName$ = MID$(DskName$, 1, 8) ELSE NewName$ = MID$(DskName$, 1, P - 1)
		NewName$ = NewName$ + Incr$
		P = LEN(NewName$)
		IF P < 10 THEN NewName$ = NewName$ + STRING$(10 - P, " ")

		' Sector/ disk
		L1$ = CHR$(INT(DiskSize(TmpSize) / 256)): L2$ = CHR$(DiskSize(TmpSize) MOD 256)

		SectorZero$ = NewName$ + L1$ + L2$ + CHR$(SecTrack(TmpSize)) + "DSK " + CHR$(TrackSide(TmpSize)) + CHR$(NumSides(TmpSize)) + CHR$(DskDens(TmpSize))
		IF DiskSize(TmpSize) > = 2880 THEN T$ = CHR$(1) ELSE T$ = CHR$(3)
		'SectorZero$ = SectorZero$ + STRING$(36, CHR$(0)) + T$ + STRING$(199, CHR$(0))
		SectorZero$ = SectorZero$ + STRING$(36, CHR$(0)) + T$ + STRING$(UpperABM(TmpSize) - 1, CHR$(0))
		SectorZero$ = SectorZero$ + STRING$(256 - LEN(SectorZero$), CHR$(&HFF))

		PUT #2, BytePos&, SectorZero$: BytePos& = BytePos& + 256
		FillZero$ = STRING$(256, CHR$(0))
		PUT #2, BytePos&, FillZero$: BytePos& = BytePos& + 256

		FOR Record = 3 TO DiskSize(TmpSize) ' Sector 0 and 1 are already out, add remaining sectors
		PUT #2, BytePos&, DummyRec$: BytePos& = BytePos& + 256
		NEXT Record
		OutErrTable$ = FillZero$
		MID$(OutErrTable$, 1) = "Bad Sectors:       0"
		PUT #2, BytePos&, OutErrTable$: BytePos& = BytePos& + 256
		PUT #2, BytePos&, FillZero$: BytePos& = BytePos& + 256
		PUT #2, BytePos&, FillZero$: BytePos& = BytePos& + 256
		OutErrTable$ = OutErrTable$ + FillZero$ + FillZero$

		CLOSE #2
		GOSUB CreateOpen   ' Open Output file and get fundamental sectors (0 and 1)
		StillFree% = DiskSize(TmpSize) - 2
		RETURN

' Open Output file and get fundamental sectors
CreateOpen:     
		OPEN DxPath$ FOR RANDOM ACCESS READ WRITE AS #2 LEN = 256
		FIELD #2, 256 AS DataSec$
		GET #2, 1
		OutSectrZero$ = DataSec$
		GET #2, 2
		OutSectrOne$ = DataSec$


		RETURN

'SUBTRACT USED SECTORS FROM OPENED FILE         
SubtrUsdSectors:
		DSect = CalcWord(OutSectrZero$, 11)
		DTracks% = ASC(MID$(OutSectrZero$, 18, 1))
		DSides% = ASC(MID$(OutSectrZero$, 19, 1)): IF DSides% = 0 THEN DSides% = 1
		DDens%  = ASC(MID$(OutSectrZero$, 20, 1)): IF DDens% = 0 THEN DDens% = 1
		DSideDensity$=MID$("SD", DSides%, 1) + "S" + MID$("SDH", DDens%, 1) + "D"

		SELECT CASE DSideDensity$
		CASE "SSSD"
		TmpSize = 1
		CASE "DSSD"
		TmpSize = 2
		CASE "SSDD"
		TmpSize = 3
		CASE "DSDD"
		TmpSize = 4
		CASE "SSHD"
		TmpSize = 5
		CASE "DSHD"
		TmpSize = 6

		CASE ELSE
		CALL ERRSOUND: PRINT "Unknown disk size in SubtrUsdSectors: routine": INPUT C$: GOTO Leaveit
		END SELECT
  		TmpSize = TmpSize + ((ASC(MID$(OutSectrZero$,18,1))/40)-1)*6
		StillFree% = DiskSize(TmpSize)

		FOR J = 0 TO UpperABM(TmpSize)
		T$ = MID$(OutSectrZero$, 57 + J, 1)
		IF ASC(T$) = 0 THEN GOTO CrNextByte
		IF ASC(T$) < 255 THEN GOTO SubtrUsdSect2
		StillFree% = StillFree% - 8
		IF DiskSize(TmpSize) = 2880 THEN StillFree% = StillFree% - 8
		IF DiskSize(TmpSize) = 5760 THEN StillFree% = StillFree% - 24
		GOTO CrNextByte

SubtrUsdSect2: 
		FOR W = 0 TO 7
		IF ASC(T$) AND 2 ^ W THEN StillFree% = StillFree% - 1: IF DiskSize(TmpSize) = 2880 THEN StillFree% = StillFree% - 1 ELSE IF DiskSize(TmpSize) = 5760 THEN StillFree% = StillFree% - 3
		NEXT W
CrNextByte:      NEXT J
		' PRINT "StillFree%="; StillFree%; : INPUT "", C$
		PRINT "Disk to append to: "
		PRINT "Diskname     = " ; DxPath$
		PRINT "Disk Type    = "; DSideDensity$
		PRINT "Capacity     =";DSect;"sectors
		PRINT "Track/side   ="; ASC(MID$(OutSectrZero$,18,1))
		PRINT "sector/track =" ;ASC(MID$(OutSectrZero$,13,1))
		PRINT "Free sectors = "; StillFree%
		PRINT "Used sectors = "; DSect-StillFree%

		IF TmpSize<>Size THEN PRINT "The disk size doesn't match the disk size you've selected."
		PRINT
		PRINT "Do you want to use this disk ";
		IF TmpSize<>Size THEN PRINT "anyway (Y/N)?"; ELSE PRINT "(Y/N)?";
		DO: K$ = INKEY$: LOOP UNTIL K$ <> "": K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN K$="N"
		PRINT
		AppendF$= K$
		RETURN

SectorLength:    ' Calculate file length, in sectors
		SectorLength# = CalcWord(FilName$(CurrentFilename%), 15) + 1
		RETURN
DispFilestoCopy: ' Display total files to be copied
		LOCATE 6, 58, 1
		PRINT TotFiles2Copy%; " ";
		LOCATE 6, 73, 1
		PRINT TotSizeFiles2Copy#; " ";
		RETURN

'=================================             
' DISPLAY TOP PART OF TITLE SCREEN 
'=================================
TopScreen:
		LOCATE 1, 20, 1
		PRINT "SPLIT A LARGE DISK IMAGE FILE INTO SMALL ONES"
		LOCATE 2, 1
		PRINT "TI-99/4A DiskName:"; DskName$; "    Sectors:"; TotSect%; " Tracks:"; Tracks%; " Sides:"; Sides%; " Dens:"; Dens%;
		LOCATE 3, 1
		PRINT  DiskType$ ;" Source File= "; SourcePath$;
		PRINT TAB(60); "Files="; TFNames%;
		PRINT TAB(71); SideDensity$
		LOCATE 4, 1
		PRINT "PC First Split File= "; DestinPath$;
		PRINT TAB(60); "Used:"; TAB(71); "Bad:"; TotEr%;
		LOCATE 4, 65
		PRINT TotSectorFiles#
		LOCATE 5, 1
		PRINT "Ŀ"
		PRINT "  n. Filename  P TSect Length  Type           Select:      Sectors:        "
		PRINT "Ĵ"
		GOSUB DispFilestoCopy
		IF TotEr% = 0 THEN GOTO IfSomeFileName
		LOCATE 6, 51
		PRINT "Bad Sectors Full List = F3";

IfSomeFileName:
		LOCATE 22, 1
		PRINT "Enter=Execute. C,M=Select, CTRL A=Select All, CTRL U=UnSel.All, 0=Served first,"
		LOCATE 23, 1
		PRINT "1-9=Next to be served, C=Last to be served. Cursor=ArrUp,Dwn,PagUp,Dwn. "
		PRINT "    F1=Help. F7= File Hex Sector Viewer. F8= Cat ARK File.";
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRow:
		LOCATE StartRow% + CurrentScreenRow%, 1, 1
		'PRINT "                                                                              "
		PRINT ""; CopyMark$(CurrentFilename%); "";
		PRINT USING "###"; CurrentFilename%;
		PRINT ""; MID$(FilName$(CurrentFilename%), 1, 10);

 		IF MID$(FilName$(CurrentFilename%), 1, 10)=STRING$(10,CHR$(&HBA)) THEN GOTO BadSectorList '' PB 2004.06.05 - Handle FDR Error (BABA) - 		
		IF CurrentFilename% > ActiveDirs% THEN GOTO NoSubDirs
		IF CurrentFilename% = ChosenDir% THEN PRINT TAB(19); "< Active Dir >";
		PRINT TAB(34); ".. <Dir>.."; TAB(49); "";
		GOTO NoErrSectInFile
NoSubDirs:

		FileType% = ASC(MID$(FilName$(CurrentFilename%), 13, 1))
		FileType% = FileType% AND &H8B         ' Get rid of reserved bits: 2,4-6
		IF FileType% AND 8 THEN FileProt$ = "P" ELSE FileProt$ = "_"
		FileType% = FileType% AND 247

		SELECT CASE FileType%
		CASE 0
		FileType$ = "Dis/Fix"
		CASE 1
		FileType$ = "Program"
		CASE 2
		FileType$ = "Int/Fix"
		CASE 128
		FileType$ = "Dis/Var"
		CASE 130
		FileType$ = "Int/Var"
		CASE ELSE
		FileType$ = "unknown"
		END SELECT


		SectorLength# = CalcWord(FilName$(CurrentFilename%), 15) + 1
		EOFOffset% = ASC(MID$(FilName$(CurrentFilename%), 17, 1))
		FileLength# = SectorLength# - 1
		FileLength# = FileLength# * 256
		IF FileType% < 128 THEN FileLength# = FileLength# - 256 + EOFOffset%
		LogRecLength% = ASC(MID$(FilName$(CurrentFilename%), 18, 1))

		' PRINT EOFOffset%;
		PRINT " "; FileProt$;
		PRINT USING "####"; SectorLength#;
		PRINT USING "#########"; FileLength#;
		PRINT " "; FileType$;
		IF LogRecLength% > 0 THEN PRINT USING "####"; LogRecLength%;

		LOCATE StartRow% + CurrentScreenRow%, , 1
		PRINT TAB(49); "";
BadSectorList:
		IF FileErrList$(CurrentFilename%) = "" THEN GOTO NoErrSectInFile


		PRINT TAB(50); "Err=";
		FOR J = 1 TO LEN(FileErrList$(CurrentFilename%)) STEP 2
		IF J > 8 THEN PRINT ",..."; : GOTO NoErrSectInFile
		K = CalcWord(FileErrList$(CurrentFilename%), J)
		IF J > 1 THEN PRINT ",";
		PRINT RTRIM$(LTRIM$(STR$(K)));
		NEXT J

NoErrSectInFile:         

		PRINT TAB(80); "";
		RETURN
'====================
' DISPLAY BOTTOM LINE
'====================          
BottomLine:    
		PRINT
		PRINT ""

		LOCATE StartRow% + CurrentScreenRow% + 1, 1, 1

		IF CurrentScreenRow% > TotalScreenRows% THEN GOTO SkipClear ' Blank all unused screen rows, if any

		FOR V = CurrentScreenRow% TO TotalScreenRows%
		PRINT "                                                                                "
		NEXT V
SkipClear:
		RETURN

'=========================
' REDRAW THE ENTIRE SCREEN
'=========================
RePaintScreen:

		GOSUB TopScreen ' Display Top Part of Title Screen
		SaveCurrFilename% = CurrentFilename%
		SavCurrScreenRow% = CurrentScreenRow%
		CurrentFilename% = FirstFilename%
		FOR CurrentScreenRow% = 1 TO TotalScreenRows%
		GOSUB DisplayRow  ' Display Current Row
		CurrentFilename% = CurrentFilename% + 1 ' Next Filename
		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		IF CurrentFilename% > TFNames% THEN CurrentScreenRow% = CurrentScreenRow% + 1: GOTO RePaintScreen2
		NEXT CurrentScreenRow%   ' Next Screen Row
RePaintScreen2:               
		GOSUB BottomLine        ' Display Bottom Line
		CurrentFilename% = SaveCurrFilename%
		CurrentScreenRow% = SavCurrScreenRow%
		RETURN


RestoreColor:   TempScreenRow% = CurrentScreenRow%
		TempFilename% = CurrentFilename%
		CurrentScreenRow% = OldScreenRow%
		CurrentFilename% = OldFilename%
		COLOR 7, 0: GOSUB DisplayRow ' Display Current Row
		CurrentScreenRow% = TempScreenRow%
		CurrentFilename% = TempFilename%
		RETURN



		' My Little Debugger
ShowValues:
		CCursR = CSRLIN
		CCursC = POS(0)
		LOCATE 6, 55
		PRINT FirstFilename%; CurrentFilename%; LastFilename%; "   "
		LOCATE CCursR, CCursC

		RETURN


'=====================================
' Work out which file has a bad sector
' ====================================      
WorkOutWhichFile:
		K$=STRING$(256,&HBA)			' PB 2004.06.05 - Handle FDR Error (BABA) - 
		FOR FileToCopy% = 1 TO TFNames%
		'GET #1, StartSect%(FileToCopy%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(FileToCopy%) + 1, d$)
		FHeader$ = d$
		IF FHeader$=K$ THEN K = StartSect%(FileToCopy%) : GOSUB MarkErrFileIF : GOTO WorkOutNext ' PB 2004.06.05 - Handle FDR Error (BABA) - 
		SectorCnt% = CalcWord(FHeader$, 15)
		OldOffs% = 0
		Z = 0


NextChain:	IF Z > 227 THEN K = StartSect%(FileToCopy%) : GOSUB MarkErrFileIF : GOTO WorkOutNext ' PB 2004.06.05 - Handle FDR Error (BABA) - 
		GOSUB CalcClusters
		CurrOffs% = Offs% - OldOffs%
		IF StSec% = 0 THEN GOTO WorkOutNext
		'PRINT "A="; HEX$(a); a
		'PRINT "B="; HEX$(B); B
		'PRINT "C="; HEX$(c); c
		'PRINT "Start Sector="; StSec%;" >";HEX$(StSec%)
		'PRINT "Offset="; Offs%;" >";HEX$(Offs%)
		'INPUT "", c$
		IF K >= StSec% AND K <= StSec% + CurrOffs% THEN GOSUB MarkErrFile: GOTO WorkOutEnd
		OldOffs% = Offs%
		Z = Z + 3: GOTO NextChain
WorkOutNext:  
		NEXT FileToCopy%
WorkOutEnd:  
		RETURN

' Mark File containing Error: To save memory, a couple of bytes (CHR$) each bad sector      
MarkErrFile:  
		MSB% = INT(K / 256)
		LSB% = K MOD 256
		FileErrList$(FileToCopy%) = FileErrList$(FileToCopy%) + CHR$(MSB%) + CHR$(LSB%)
		RETURN
		
' Mark File containing Error in FDR	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
MarkErrFileIF:				' PB 2004.06.05 - Handle FDR Error (BABA) - 
		MSB% = INT(K / 256)	' PB 2004.06.05 - Handle FDR Error (BABA) - 
		LSB% = K MOD 256	' PB 2004.06.05 - Handle FDR Error (BABA) - 
		A$=CHR$(MSB%) + CHR$(LSB%)	' PB 2004.06.05 - Handle FDR Error (BABA) - 
		IF LEN(FileErrList$(FileToCopy%))>0 AND RIGHT$(FileErrList$(FileToCopy%),2)=A$ THEN GOTO MarkErrFileIF2 ' PB 2004.06.05 - Handle FDR Error (BABA) - 
		FileErrList$(FileToCopy%)= FileErrList$(FileToCopy%)+ A$	' PB 2004.06.05 - Handle FDR Error (BABA) - 
MarkErrFileIF2:	RETURN			' PB 2004.06.05 - Handle FDR Error (BABA) - 
			
		

'========SHOW SECTORS - ADD START             
ShowSector:      CALL box(8, 3, 76, 13)
		LOCATE 8, 30: COLOR 0, 7: PRINT " - HEX SECTOR VIEWER - "; : COLOR 7, 0
		'GET #1, StartSect%(CurrentFilename%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(CurrentFilename%) + 1, d$)
		FHeader$ = d$
		SectorCnt% = CalcWord(FHeader$, 15)		' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		LOCATE 9, 5:  PRINT "File: "; MID$(FHeader$, 1, 10); "-Length:"; SectorCnt%; ' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		IF SectorCnt% = -1 THEN GOTO ShowSectorEnd	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		Z = 0                      ' Offset in Input File Chain Pointer Block
		K$ = "Y"
ShowSector2:
		GOSUB CalcClusters
		IF StSec% > 0 THEN GOTO ShowSector3
		LOCATE 19, 30: PRINT " = End of File =";
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		IF K$ = CHR$(27) THEN GOTO ShowSectorEnd

ShowSector3:
		IF GlobalInpOffset% > Offs% THEN Z = Z + 3: GOTO ShowSector2
		' GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)

		LOCATE 9, 35: PRINT " -This Skt: "; StSec% + OffsVal%; " >"; HEX$(StSec% + OffsVal%); " - Skt Off.:"; GlobalInpOffset%;

		CALL ShowHex(d$, K$)
		IF K$ = CHR$(27) THEN GOTO ShowSectorEnd
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO ShowSector4
		IF GlobalInpOffset% > 0 THEN K$ = ""
		IF GlobalInpOffset% = 0 THEN GOTO ShowSector3
		GlobalInpOffset% = GlobalInpOffset% - 1
		OffsVal% = OffsVal% - 1
		IF OffsVal% < 0 THEN Z = Z - 3: GOTO ShowSector2
		GOTO ShowSector3
ShowSector4:                  
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO ShowSector3

ShowSectorEnd:        
		RETURN

'========SHOW SECTORS - ADD END        

ShowErrorList:
		CALL box(8, 20, 50, 13)
		LOCATE 9, 30: PRINT "Bad Sector List, File:"; MID$(FilName$(CurrentFilename%), 1, 10)
		LOCATE 11 + W, 22: PRINT ""
		W = 0: A = 0
		LOCATE 11 + W, 22

		FOR J = 1 TO LEN(FileErrList$(CurrentFilename%)) STEP 2
		IF W > 8 THEN PRINT "..."; : GOTO ShowErrorList2
		K = CalcWord(FileErrList$(CurrentFilename%), J)
		IF A > 0 THEN PRINT ",";
		PRINT RTRIM$(LTRIM$(STR$(K)));
		A = A + 1
		IF A > 8 THEN A = 0: W = W + 1: LOCATE 11 + W, 22
		NEXT J
ShowErrorList2:     
		WHILE INKEY$ = "": WEND

NoShowErrorList:          
		RETURN



DispMem:
		PRINT "String Space", FRE("")
		PRINT "Unused Stack Space", FRE(-2)
		PRINT "Array Space", FRE(-1)
		INPUT C$
		RETURN
AbsNoFiles:
		PRINT ""
		A = 10
		CALL box(A, 18, 50, 8)
		LOCATE A + 2, 24: PRINT "THIS DISK, "; SourcePath$; " IS EMPTY. "
		LOCATE A + 3, 24: PRINT ""
		LOCATE A + 4, 30: PRINT "No files have been found."
		LOCATE A + 5, 32: PRINT "Press any key to exit"

		WHILE INKEY$ = "": WEND
		RETURN


SUB AlphaDir (DestDisk$) ' Alphabetically reorder an Image Disk (Sector 1)
' Example:
' Call AlphaDir("C:\TEM\TI-PC.IMG")

		OPEN DestDisk$ FOR RANDOM ACCESS READ WRITE AS #9 LEN = 256
		FIELD #9, 256 AS DSec$
		GET #9, 2               ' Get Sector 1: Filename Table, alphabetically ordered
		SectrOne$ = DSec$

		TFNames% = 1           ' We have to work out how many filenames there are
NextFilNam:      sn% = CalcWord(SectrOne$, (TFNames%) * 2 - 1)
		IF sn% <> 0 THEN TFNames% = TFNames% + 1: GOTO NextFilNam
		TFNames% = TFNames% - 1  ' Well this is how many filenames we've got

		REDIM FilName$(TFNames%)   ' DIM exactly our arrays
		REDIM StSect$(TFNames%)   ' DIM exactly our arrays
		FOR T = 1 TO TFNames%
		StSect$(T) = MID$(SectrOne$, (T * 2 - 1), 2)
		StartSect% = CalcWord(SectrOne$, (T * 2 - 1))
		GET #9, StartSect% + 1
		FilName$(T) = MID$(DSec$, 1, 10)
		' print t; StartSect%;FilName$(T)
		NEXT T
		
	
		
		' AVOID DUP NAMES
		' Dup names will be renamed with a leading Tilde character ("~"), for instance: "~filename"
		L!=0
		FOR K = 1 to TFNames% - 1
		FOR T = K + 1 TO TFNames%
		IF FilName$(K) <> FilName$(T) THEN GOTO NoDup
		A1$ = RTRIM$(FilName$(T))
		IF LEN(A1$) < 10 THEN A1$ = "~" + A1$ + SPACE$(10 - LEN(A1$) - 1) ELSE A1$ = "~" + LEFT$(A1$,9)
		PRINT "Incoming file "; FilName$(T); " will be renamed as ";A1$;" to avoid a duplicate name"
		L! = L! + 1
		IF INT(L!/20) = L!/20 THEN CALL PressToContinue
		
		FilName$(T) = A1$
		StartSect% = CalcWord(StSect$(T),1)
		GET #9, StartSect% + 1
		A2$ = DSec$ 
		MID$(A2$, 1, 10) = FilName$(T)
		LSET DSec$ = A2$
		PUT #9, StartSect% + 1
		
NoDup:		NEXT T
		NEXT K
		IF L! = 0 THEN GOTO NoDupEnd
		PRINT L!; "filenames have been renamed to avoid duplicate names."
		CALL PressToContinue
		
		
NoDupEnd:		
		
		' REORDER ALPHABETICALLY
		' Find Lowest element. Start from element 1; compare all others with element 1. If lowest found, swap with element 1
		' Next round, Find lowest starting from element 2; compare all others with element 2. If lowest found, swap with element 2
		' Next round, Find lowest starting from element 3; compare all others with element 3. If lowest found, swap with element 3
		' Next round, ...
		K = 1
LoopBack:       L = K: T = K + 1
LoopBack2:      IF FilName$(L) <= FilName$(T) THEN GOTO InOrder
		L = T   ' New lowest element found
InOrder:        T = T + 1
		IF T <= TFNames% THEN GOTO LoopBack2
		IF L = K THEN GOTO InOrder2
		'Swap lowest element with first element
		A1$ = FilName$(K): A2$ = StSect$(K)
		FilName$(K) = FilName$(L): StSect$(K) = StSect$(L)
		FilName$(L) = A1$: StSect$(L) = A2$
InOrder2:              
		K = K + 1: IF K < TFNames% THEN GOTO LoopBack

		FOR T = 1 TO TFNames%
		MID$(SectrOne$, (T * 2 - 1), 2) = StSect$(T)
		NEXT T
		' CALL ShowHex(SectrOne$,K$)

		LSET DSec$ = SectrOne$
		PUT #9, 2                ' Write Sector 1: Filename Table, alphabetically ordered

		CLOSE #9

		ERASE FilName$  ' Free memory
		ERASE StSect$
END SUB

SUB box (Y, X, W, H)

		' Call Box(StartRow, StartColumn, Width, Hight)
		' Y=StartRow,X=StartColumn; W=Width,H=Hight)
		LOCATE Y, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";

		FOR V = 1 TO H - 2
		LOCATE Y + V, X
		PRINT ""; TAB(X + W - 1); : PRINT "";
		NEXT V

		LOCATE Y + H - 1, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";


END SUB

SUB PressToContinue
		PRINT " - Press any key to continue - "
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
END SUB

SUB ERRSOUND
		SOUND 110, 4

END SUB

SUB Fischio
		IF MyVal(1) = 0 THEN EXIT SUB
		FOR i% = 3000 TO 4000 STEP 200
		SOUND i%, .1  'i% / 1000
		NEXT i%

END SUB

SUB ShortName (A$)
' Get short filename (8.3 characters)
		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT7160.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO ShortName2
		LINE INPUT #71, A$
ShortName2:     CLOSE #71
		KILL "--"
ShortNameEnd:
END SUB

SUB CreateShortName (A$,B$)
' Get short filename (8.3 characters). If it fails, create that file with
' Long Filename, then return the corresponding  short filename. 
' If file has been created, a second record, containing the string "CR!"
' will be returned too. 
' If wrong path, no filename is returned.

		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT716C.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO CrShName2
		LINE INPUT #71, A$
		B$=""
		IF EOF(71) <> 0 THEN GOTO CrShName2
		LINE INPUT #71, B$
CrShName2:      CLOSE #71
		KILL "--"

END SUB

SUB ShowHex (A$, K$)
' This is simply to help during debugging
' Syntax: CALL ShowHex(A$,K$) ' A$ usually contains an entire TI Sector (256 bytes)
		Col% = 3
		B$ = ""
		FOR T = 1 TO LEN(A$)
		C$ = HEX$(ASC(MID$(A$, T, 1))): IF LEN(C$) = 1 THEN C$ = "0" + C$
		B$ = B$ + C$ + " "
		NEXT T

		LOCATE 10, Col% + 2
		PRINT "Addr. 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ";

		IF K$ = "" THEN T = LEN(B$) - (8 * 16 * 3 - 1) ELSE T = 1
'===============LOOP STARTS HERE  

Repeat:   
		T$ = MID$(B$, T, 16 * 3)
		LOCATE 10 + 1 + Row%, Col% + 2:
		H$ = HEX$(T / 3): IF LEN(H$) = 1 THEN H$ = "0" + H$
		PRINT USING "\  \"; H$;
		LOCATE 10 + 1 + Row%, Col% + 5
		PRINT " - "; T$;
		PRINT "  ";
		FOR J = 1 TO 16
		J$ = MID$(A$, (T - 1) / 3 + J, 1)
		IF ASC(J$) < 32 OR ASC(J$) > 126 THEN PRINT " ";  ELSE PRINT J$;

		NEXT J

		Row% = Row% + 1: IF Row% < 8 THEN GOTO NextRow ELSE Row% = 0
		'locate 21,1: print len(B$)
		'locate 22,1: print t
		'locate 23,1: print (t-1)/(3*16)
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO GEXIT

		' Arrow Down
		IF K$ <> CHR$(0) + CHR$(80) THEN GOTO ArrowUPkey
		T = T - (16 * 3 * 6): IF T < 1 THEN T = 1
		GOTO Repeat

ArrowUPkey:      ' Arrow UP
		IF K$ <> CHR$(0) + CHR$(72) AND K$ <> CHR$(0) + CHR$(73) THEN GOTO NextRow
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO PageUPKey
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 8): IF T < 1 THEN T = 1
		GOTO Repeat
PageUPKey:            
		' Page UP
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 15): IF T < 1 THEN T = 1
		GOTO Repeat

NextRow:  
		T = T + (16 * 3)
		IF T < LEN(B$) THEN GOTO Repeat
		K$ = "Y"
'===============LOOP ENDS HERE
GEXIT:
END SUB

SUB TellPathFrom (Full$, Path$, File$)
' Tell Path from File
		FOR T = LEN(Full$) TO 1 STEP -1
		IF MID$(Full$, T, 1) = "\" THEN GOTO TPath1
		NEXT T
		Path$ = "": File$ = Full$
		P = INSTR(File$, ":"): IF P > 0 THEN Path$ = LEFT$(Full$, P): File$ = RIGHT$(Full$, LEN(Full$) - P)
		GOTO TPath2

TPath1:          Path$ = LEFT$(Full$, T): File$ = RIGHT$(Full$, LEN(Full$) - T)
TPath2:
END SUB

SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
		GOTO GetHelp

' Because of MS QBasic quirks, GetIDX routine has to be placed before the rest of the code.

' Get .IDX file values into an array, that is,
' Get Array Parameters from Index (IDX) file
GetIDX:        
		OPEN IDXFile$ FOR RANDOM ACCESS READ AS #3 LEN = LEN(IDXRecord)
		GET #3, , IDXRecord
		TLines% = IDXRecord.StartRec' First record is special: total records that follow


		REDIM IDXSect$(TLines%)
		REDIM IdxStart(TLines%)
		REDIM IdxLength(TLines%)
		FOR T = 1 TO TLines%
		GET #3, , IDXRecord
		IDXSect$(T) = LTRIM$(IDXRecord.Section)
		IdxStart(T) = IDXRecord.StartRec
		IdxLength(T) = IDXRecord.RecLength
		IDXSect$(T) = LTRIM$(RTRIM$(IDXSect$(T)))
		NEXT T
		CLOSE #3

		RETURN




GetHelp:        CLS
		LOCATE 1, 26: PRINT Banner$
		InizRw% = 2
		TotScrRws% = 12
		CurrScrRw% = 1

		GOSUB RedrawBox
		GOSUB GetIDX
		FOR Arg% = 1 TO TLines%
		IF Argum$ = IDXSect$(Arg%) THEN GOTO ArgFnd
		NEXT Arg%
		Arg% = 1

ArgFnd:         CurntLine% = Arg%
		RcLen% = 77 + 2
		OPEN DatFile$ FOR RANDOM ACCESS READ AS #59 LEN = RcLen%
		FIELD #59, RcLen% - 2 AS DL$
		FIELD #59, 2 AS CRLF$

'===================================
' MAIN LOOP STARTS HERE
'===================================      
NextLineName:
		COLOR 7, 0

		IF CurrScrRw% = 1 THEN FstLine% = CurntLine%   ' Get Number of first Line only
		GOSUB DisplayRw
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		CurrScrRw% = CurrScrRw% + 1  ' Next Screen Row
		IF CurrScrRw% < TotScrRws% + 1 AND CurntLine% <= TLines% THEN GOTO NextLineName
'===================================
' MAIN LOOP ENDS HERE
'===================================
'          
		GOSUB BotLine              ' Clear Unused Bottom Lines
		LastLine% = CurntLine% - 1
		CurntLine% = FstLine%  ' Current Line is now first Line in screen

		CurrScrRw% = 1
		IF KeepCursBot% = 0 THEN GOTO LocCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last Line in Screen
		CurrScrRw% = TotScrRws%: KeepCursBot% = 0: CurntLine% = LastLine%
		GOTO LocCursor2

LocCursor:
		GOSUB HeRestColor

LocCursor2:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		COLOR 0, 7: GOSUB DisplayRw: COLOR 7, 0 ' Display Current Row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		OldScrRw% = CurrScrRw%
		OldLine% = CurntLine%
		IF GoToThisDir% <> 0 THEN CurntLine% = GoToThisDir%: GoToThisDir% = 0: GOTO Exekit
		'GOSUB ShowValues    ' My little Debugger


DoHeAgain:      GOSUB GetChar

		' IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO DoHeAgain

		' ESCape Key
		IF UH$ = CHR$(27) THEN GOTO HAbort

		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO IsArrDown
EnterKey:       CALL Fischio
		GOSUB ThisSect
		GOSUB RePaintHelp
		GOTO NMatch

IsArrDown:     ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO OthKey0
		IF CurrScrRw% < LastScrRw% THEN CurrScrRw% = CurrScrRw% + 1: CurntLine% = CurntLine% + 1: GOTO LocCursor
		IF CurntLine% = TLines% THEN GOTO LocCursor
		CurntLine% = FstLine% + 1
		KeepCursBot% = 1
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
OthKey0:         'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO OthKey1
		IF CurntLine% = 1 THEN GOTO NMatch
		IF CurrScrRw% > 1 THEN CurrScrRw% = CurrScrRw% - 1: CurntLine% = CurntLine% - 1: GOTO LocCursor
		CurntLine% = FstLine% - 1: IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey1:         ' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO OthKey2
		CurntLine% = FstLine% - TotScrRws%
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO OthKey7
		IF LastLine% + 1 + TotScrRws% > TLines% THEN CurntLine% = TLines% - TotScrRws% + 1: IF CurntLine% < 1 THEN CurntLine% = 1: GOTO Exekit
		CurntLine% = FstLine% + TotScrRws%
		IF CurntLine% > TLines% THEN CurntLine% = FstLine%
		GOTO Exekit

OthKey7:         ' Home Key : simply move cursor to top
		IF UH$ <> CHR$(0) + CHR$(71) THEN GOTO OthKey8
		CurrScrRw% = 1: CurntLine% = FstLine%: GOTO LocCursor

OthKey8:         ' End Key : simply move cursor to bottom
		IF UH$ <> CHR$(0) + CHR$(79) THEN GOTO OthKey9
		CurrScrRw% = LastScrRw%: CurntLine% = LastLine%
		GOTO LocCursor

OthKey9:        ' F3 = Show Error List
		IF UH$ <> CHR$(0) + CHR$(61) THEN GOTO OthKey10
		GOSUB RePaintHelp
		GOTO NMatch

OthKey10:       ' F7 = Show Sector as Hex
		IF UH$ <> CHR$(0) + CHR$(65) THEN GOTO OthKey11
		GOSUB RePaintHelp
		GOTO NMatch

OthKey11:       'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO OthKey12
		GOTO EnterKey
OthKey12:          
		GOTO NMatch


Exekit:         CurrScrRw% = 1     ' Cursor on first screen row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GOTO NextLineName   ' Start next round

NMatch:         GOTO LocCursor

RePaintHelp:    
		GOSUB RedrawBox
		SaveCurrLine% = CurntLine%
		SavCurrScrRw% = CurrScrRw%
		CurntLine% = FstLine%
		FOR CurrScrRw% = 1 TO TotScrRws%
		GOSUB DisplayRw  ' Display Current Row
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		IF CurntLine% > TLines% THEN CurrScrRw% = CurrScrRw% + 1: GOTO RePaintHelp2
		NEXT CurrScrRw%   ' Next Screen Row

RePaintHelp2:         

		CurntLine% = SaveCurrLine%
		CurrScrRw% = SavCurrScrRw%
		RETURN

HeRestColor:    TempScreenRw% = CurrScrRw%
		TempLine% = CurntLine%
		CurrScrRw% = OldScrRw%
		CurntLine% = OldLine%
		COLOR 7, 0: GOSUB DisplayRw ' Display Current Row
		CurrScrRw% = TempScreenRw%
		CurntLine% = TempLine%
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRw:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GET #59, IdxStart(CurntLine%)
		TL$ = DL$
		FOR T = 1 TO LEN(TL$): IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO StrtFound
		NEXT T
StrtFound:      TL$ = RIGHT$(TL$, LEN(TL$) - T + 1)

		FOR T = LEN(TL$) TO 1 STEP -1: IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO EndFnd
		NEXT T
EndFnd:         TL$ = LEFT$(TL$, T)
		PRINT IDXSect$(CurntLine%); TAB(12); TL$; SPACE$(79 - 12 - LEN(TL$));
		RETURN

'====================
' CLEAR BOTTOM LINES
'====================      
BotLine:

		LOCATE InizRw% + CurrScrRw%, 2, 1

		IF CurrScrRw% >= TotScrRws% THEN GOTO HlpClear ' Blank all unused screen rows, if any

		FOR V = CurrScrRw% TO TotScrRws%
		LOCATE InizRw% + V, 2, 1
		PRINT "                                                                              "
		NEXT V

HlpClear:        LOCATE 23, 1: PRINT "Enter=Get Doc. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		RETURN


' Create Box
RedrawBox:      CALL box(2, 1, 80, TotScrRws% + 2)
		RETURN
Pranyk:

		PRINT "                         - press any key to return -"
		GOSUB GetChar
		RETURN

GetChar:
		DO: UH$ = INKEY$: LOOP UNTIL UH$ <> ""
		RETURN


ThisSect:       TotSectRws% = 19
		SectInizRw% = 2
		SectCurrRw% = 1
		SectStart# = IdxStart(CurntLine%)
		SectCount# = IdxLength(CurntLine%)
		SectCurr# = 0
		Blank$ = SPACE$(78)
		LOCATE 23, 1: PRINT "Enter=Line Down. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		CALL box(2, 1, 80, TotSectRws% + 2)
NewRound:            
		FirstRec# = SectCurr#
SectNewLine:            
		GET #59, SectStart# + SectCurr#
		LOCATE SectInizRw% + SectCurrRw%, 2, 1
		PRINT DL$;
		SectCurr# = SectCurr# + 1
		LastSectRw% = SectCurrRw%      ' Save last Screen Row used
		SectCurrRw% = SectCurrRw% + 1
		IF SectCurrRw% < TotSectRws% + 1 AND SectCurr# < SectCount# THEN GOTO SectNewLine

		FOR V = SectCurrRw% TO TotSectRws%
		LOCATE SectInizRw% + V, 2
		PRINT Blank$;
		NEXT V

GetAnother:     GOSUB GetChar
		'IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO GetAnother
		SectCurr# = FirstRec#
		SectCurrRw% = 1
		' ESC Key
		IF UH$ = CHR$(27) THEN GOTO SectExit

		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO SectArrowDown
SectEnter:      IF SectCurr# < SectCount# - 6 THEN SectCurr# = SectCurr# + 1
		GOTO NewRound

SectArrowDown:  ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO SectKey0
		GOTO SectEnter

SectKey0:       'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO SectKey1
		IF SectCurr# > 0 THEN SectCurr# = SectCurr# - 1
		GOTO NewRound
SectKey1:          
		' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO SectKey2
SectPageUp:     SectCurr# = SectCurr# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound

SectKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO SectKey11
SectPageDown:   SectCurr# = SectCurr# + TotSectRws%
		IF SectCurr# > SectCount# - TotSectRws% THEN SectCurr# = SectCount# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound

SectKey11:      'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO SectKey12
		GOTO SectPageDown

SectKey12:      'CTRL Page Up
		IF UH$ <> CHR$(0) + CHR$(132) THEN GOTO SectKey13
		GOTO SectPageUp
SectKey13:         
		GOTO NewRound
SectExit:              
		V = InizRw% + TotScrRws%
		LOCATE V, 1, 1
		IF V >= 22 THEN GOTO DontDoit ' Blank all unused screen rows, if any

		FOR V = V TO 23
		LOCATE V, 1, 1
		PRINT SPACE$(80)
		NEXT V
DontDoit:

		RETURN
HAbort:            
		CLOSE #59
END SUB

DEFSNG A-Z
' READ A SECTOR FROM ANY OF THE FOLLOWING : PC99 DISK, V9T9 DISK, TI99-PC DISK, MESS HARD DISK
SUB GetVirtualSect (FileNum%, Sektor&, d$)
		Sekr& = Sektor& - 1

		IF FType$ <> "MH" THEN GOTO NoMHDisk            ' See if it is a Mess Hard Disk
		ByteOff& = Sekr& + 1
		ByteOff& = ByteOff& * MHSecLen% + MHSectZero&
		SELECT CASE MHSecLen%
		CASE 256
		GET #FileNum%, ByteOff& + 1, MHSekt256(1)
		d$ = MHSekt256(1)
		CASE 512
		GET #FileNum%, ByteOff& + 1, MHSekt512(1)
		d$ = MHSekt512(1)
		END SELECT
		GOTO GetSectExit



NoMHDisk: 
		IF FType$ <> "VS" THEN GOTO PC99disk            ' V-9T9 S-ingle density
		ByteOff& = Sekr&
		ByteOff& = ByteOff& * MHSecLen%
		GET #FileNum%, ByteOff& + 1, V9T9Sekt(1)
		d$ = V9T9Sekt(1)
		GOTO GetSectExit

PC99disk:       Trk& = INT(Sekr& / SekTrack%)
		DskSide& = 0
		IF Trk& > 39 THEN Trk& = 79 - Trk&: DskSide& = 1
		Skt% = Sekr& MOD SekTrack%

		IF FType$ = "PD" THEN GOTO GetSectD
		IF FType$ = "PS" THEN GOTO GetSectS

'*** SINGLE DENSITY DISK ***
GetSectS:       IF Trk& = OldTrack& AND DskSide& = OldDskSide& THEN GOTO GetSectS03
		ByteOff& = SideLen& * DskSide& + Trk& * TrkLen&
		GET #FileNum%, ByteOff& + 1, TrackSing(1)
		OldTrack& = Trk&: OldDskSide& = DskSide&

GetSectS03:     FOR WHT% = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (WHT% - 1))
		A$ = MID$(TrackSing(1), P, 4)

		IF A$ <> CHR$(Trk&) + CHR$(DskSide&) + CHR$(Skt%) + CHR$(1) THEN GOTO GetSectS05
		d$ = MID$(TrackSing(1), 1 + Gap1% + PreDatGap% + (SLength% * (WHT% - 1)), 256)
		GOTO GetSectExit

GetSectS05:     NEXT WHT%

		GOTO GetSectBad:

'*** DOUBLE DENSITY DISK ***
GetSectD:       IF Trk& = OldTrack& AND DskSide& = OldDskSide& THEN GOTO GetSectD03
		ByteOff& = SideLen& * DskSide& + Trk& * TrkLen&
		GET #FileNum%, ByteOff& + 1, TrackDoub(1)
		OldTrack& = Trk&: OldDskSide& = DskSide&

GetSectD03:     FOR WHT% = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (WHT% - 1))
		A$ = MID$(TrackDoub(1), P, 4)

		IF A$ <> CHR$(Trk&) + CHR$(DskSide&) + CHR$(Skt%) + CHR$(1) THEN GOTO GetSectD05
		d$ = MID$(TrackDoub(1), 1 + Gap1% + PreDatGap% + (SLength% * (WHT% - 1)), 256)
		GOTO GetSectExit

GetSectD05:     NEXT WHT%

GetSectBad:     d$ = ""

GetSectExit:
END SUB

' ESTABLISH MEDIA OF A PC99 OR V9T9 DISK AND GET SECTOR ZERO
' Ex. Call GetVirtualZero (1, d$)
'       .... will return
'FType$ = "VS" if V9T9 disk
'FType$ = "PS" if PC99 Single density disk
'FType$ = "PD" if PC99 Double density disk
'FType$ = "MH" if Messa Hard Disk
SUB GetVirtualZero (FileNum%, d$)
		ByteOff& = 1
		MHSecLen% = 256
		DIM DAT(1) AS STRING * 256

		GET #FileNum%, ByteOff&, DAT(1)
		IF MID$(DAT(1), 1, 8) <> "MComprHD" THEN GOTO DSKDetect

		ERASE V9T9Sekt
		ERASE TrackSing
		ERASE TrackDoub

		FType$ = "MH" ' Mess Hard Disk
		MHTB& = CalcDWord&(DAT(1), 28 + 1)  ' Get Total # of Blocks
		MHMapStart& = CalcDWord&(DAT(1), 8 + 1)  ' Get Hard Disk Header Size
		MHMapEnd& = MHTB& * 8 + MHMapStart&  ' Get Total # of Blocks * 8 + Hard Disk Header Size
		MHSectZero& = MHMapEnd& + 8
		MHSecLen% = CalcDWord&(DAT(1), 76 + 1) ' Get Hard Disk Sector Len

		ByteOff& = MHSectZero&
		IF MHSecLen% = 256 THEN ERASE MHSekt512 ELSE ERASE MHSekt256
		SELECT CASE MHSecLen%

		CASE 256
		GET #FileNum%, ByteOff& + 1, MHSekt256(1)
		d$ = MHSekt256(1)

		CASE 512
		GET #FileNum%, ByteOff& + 1, MHSekt512(1)
		d$ = MHSekt512(1)
		CASE ELSE
		PRINT "Unexpected Sector Length in Mess Hard Disk": SYSTEM
		END SELECT
		GOTO EstMedExit


DSKDetect: 



		IF MID$(DAT(1), 14, 3) <> "DSK" THEN GOTO PC99Detect
		FType$ = "VS"          ' V-9T9 S-ingle density
		d$ = MID$(DAT(1), 1, 256)
		GOTO V9T9Found


PC99Detect:     ERASE V9T9Sekt
		ERASE MHSekt256
		ERASE MHSekt512

		P = INSTR(DAT(1), CHR$(&HFE)): IF P = 0 THEN GOTO EstMedAbort
		A$ = MID$(DAT(1), P + 4, 1)
		IF A$ <> CHR$(&H1) THEN GOTO EstMedAbort
		A$ = MID$(DAT(1), P - 3, 3)
		IF A$ = CHR$(&HA1) + CHR$(&HA1) + CHR$(&HA1) THEN GOTO DDens
		IF A$ <> CHR$(0) + CHR$(0) + CHR$(0) THEN GOTO EstMedAbort
'*** SINGLE DENSITY DISK ***
SDens:
		A$ = MID$(DAT(1), P + 4, 1)
		IF A$ <> CHR$(1) THEN GOTO EstMedAbort
		IF P <> 23 THEN GOTO EstMedAbort
		Gap1% = 16             ' Start of track Gap
		PreIDGap% = 7          '
		PreDatGap% = 31
		SLength% = 334
		SekTrack% = 9

		CONST TrkLenS% = 3253
		TrkLen& = TrkLenS%
		'REDIM TrackSing(1) AS STRING * TrkLenS
		GET #FileNum%, 1, TrackSing(1)
		d$ = TrackSing(1)
		FType$ = "PS"          ' P-C99 S-ingle density
		GOTO GetSZero1

'*** DOUBLE DENSITY DISK ***  
DDens:
		IF P <> 54 THEN GOTO EstMedAbort
		Gap1% = 40             ' Start of track Gap
		PreIDGap% = 14
		PreDatGap% = 58
		SLength% = 340
		SekTrack% = 18
		ERASE TrackSing
		CONST TrkLenD% = 6872
		TrkLen& = 6872
		'REDIM TrackDoub(1) AS STRING * TrkLenD
		GET #FileNum%, 1, TrackDoub(1)
		d$ = TrackDoub(1)
		FType$ = "PD"          ' P-C99 D-ouble density
		GOTO GetSZero2
GetSZero1:      ERASE TrackDoub
GetSZero2:
		OldTrack& = 0
		OldDskSide& = 0
		SideLen& = TrkLen& * 40
		FOR T = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (T - 1))
		A$ = MID$(d$, P, 4)

		IF A$ = CHR$(0) + CHR$(0) + CHR$(0) + CHR$(1) THEN GOTO SZeroFnd
		NEXT T
		GOTO EstMedAbort
SZeroFnd:       P = 1 + Gap1% + PreDatGap% + (SLength% * (T - 1))
		d$ = MID$(d$, P, 256)
		'A$=MID$(DAT,14,3)
		'IF A$<>"DSK" THEN GOTO EstMedAbort
		GOTO EstMedExit

V9T9Found:      ERASE TrackSing
		ERASE TrackDoub
		ERASE MHSekt256
		ERASE MHSekt512
		GOTO EstMedExit

EstMedAbort:    FType$ = ""  : d$ = ""
EstMedExit:     ERASE DAT
END SUB

FUNCTION CalcDWord& (A$, P%)
		IF LEN(A$) < P% + 3 THEN INPUT "Wrong String in CalcDoubleWord Subroutine", C$: V& = 0: GOTO CalcDWord1

		B1& = ASC(MID$(A$, P%, 1))
		B2& = ASC(MID$(A$, P% + 1, 1))
		B3& = ASC(MID$(A$, P% + 2, 1))
		B4& = ASC(MID$(A$, P% + 3, 1))
		V& = (B1& * 16777216) + (B2& * 65536) + (B3& * 256) + B4&

CalcDWord1:     CalcDWord& = (V&)

END FUNCTION

FUNCTION CalcWord (A$, P%)
		IF LEN(A$) < P% + 1 THEN  GOTO CalcWord1	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		B1& = ASC(MID$(A$, P%, 1))			' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		B2& = ASC(MID$(A$, P% + 1, 1))			' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		V& = (B1& * 256) + B2&				' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		IF V&< 32768 THEN GOTO CalcWord2		' PB 2004.06.05 - Handle FDR Error (BABA) - 	
CalcWord1:	V& = -1					 	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
CalcWord2:      CalcWord = (V&)					' PB 2004.06.05 - Handle FDR Error (BABA) - 	
END FUNCTION		
