DECLARE SUB ShortName (A$)
DECLARE SUB TIGName (A$)
DECLARE SUB ARKName (A$)
DECLARE SUB IncName (A$, B$)

' EXTRACT FILE TO DOS AND TI-99/4A DIRECTORY LISTING OF A TI DISK IMAGE FILE
' (obtained from TI99-PC.COM and saved as normal file on a PC)
' - Paolo Bagnaresi, September 28, 2000, March 2002 - e-mail: paolo_bagnaresi@libero.it
'
' This module can be Launched with a CHAIN qbasic instruction by a different qbasic program.
' Just add the same COMMON arrays to your launcher. (DIM Vector, MyName$, MyVal and the 3 corresponding COMMON Shared declarations).
' These arrays are used only as a parameter passing between chained qbasic programs.
DECLARE SUB ReplaceChars (In$, Out$)
DECLARE SUB ERRSOUND ()
DECLARE FUNCTION CalcWord (A$, P%)
DECLARE SUB box (Y%, X%, W%, H%)
DECLARE SUB ShowHex (A$, K$)
DECLARE FUNCTION Xinput$ (Row%, Col%, FieldLen%, Default$, AllowCharsMask$, EndingKeys$, ExitKey$, RealStrLen%)
DECLARE SUB Fischio ()
DIM Vector(0 TO 10)      AS INTEGER
DIM MyName$(0 TO 30)
DIM MyVal(0 TO 10)      AS INTEGER
DEFINT A-Z
COMMON SHARED Vector() AS INTEGER
COMMON SHARED MyName$()
COMMON SHARED MyVal() AS INTEGER
		TYPE IDXType
		Section AS STRING * 20
		StartRec AS DOUBLE
		RecLength AS SINGLE
		END TYPE
		DIM SHARED IDXRecord AS IDXType
		
		
		
		DIM SHARED FileNum AS INTEGER
		DIM SHARED Gap1%            ' Start of track Gap
		DIM SHARED PreIDGap%           '
		DIM SHARED PreDatGap%
		DIM SHARED SLength%
		DIM SHARED TrkLen&
		DIM SHARED TrackSing(1) AS STRING * 3253
		DIM SHARED TrackDoub(1) AS STRING * 6872
		DIM SHARED V9T9Sekt(1) AS STRING * 256
		DIM SHARED OldTrack&
		DIM SHARED OldDskSide&
		DIM SHARED SideLen&

		DIM SHARED SekTrack%
		DIM SHARED FType$       ' Disk Image Type for Read
		DIM SHARED FTypeW$      ' Disk Image Type for Write

		DIM SHARED MHTB&
		DIM SHARED MHSectZero&
		DIM SHARED MHSecLen%
		DIM SHARED MHSekt256(1) AS STRING * 256
		DIM SHARED MHSekt512(1) AS STRING * 512
		DIM SHARED MHFloppy$
		DIM SHARED SubDirStAddr(0 TO 10) AS INTEGER
		DIM SHARED SubDirName$(0 TO 10)
		DIM SHARED SectPerAU%
		DIM SHARED SourcePath$
		FileNum% = 1		
		
                TempArk$ = "~~~~~.~K~"
                TmpFilName$ = "~tmpfil.tmp"
                
                Endk$ = CHR$(13) + CHR$(27) + CHR$(9) + CHR$(0) + CHR$(72) + CHR$(0) + CHR$(80) + CHR$(9) + CHR$(0) + CHR$(75) + CHR$(0) + CHR$(73) + CHR$(0) + CHR$(81) + CHR$(0) + CHR$(115)
                Allowed$ = " ABCDEFGHIJKLMNOPQRSTUVWYXZabcdefghijklmnopqrstuvwyxz1234567890.-_#@_`^~{}'"
                CA53$ = CHR$(&HCA) + CHR$(&H53)
                CA5310$ = CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$
                CA5364$ = CA5310$ + CA5310$ + CA5310$ + CA5310$ + CA5310$ + CA5310$ + CA53$ + CA53$ + CA53$ + CA53$
                CRLFeed$= CHR$(13)+CHR$(10)
                DEFINT A-Z
		CLS
		
		SourcePath$ = MyName$(3)
		DestinPath$ = MyName$(5)
		REDIM FilName$(1)

		FOR T = LEN(DestinPath$) TO 1 STEP -1
		IF MID$(DestinPath$, T, 1) = "\" THEN GOTO BackFound
		NEXT T
		Path$ = DestinPath$ + "\"
		GOTO BackFound2
BackFound:
		Path$ = LEFT$(DestinPath$, T)
		
BackFound2:      CALL ShortName(Path$)
		GOTO OpenFile

' Exit point with F9
Abort:           
LeaveIt:         
LeaveIt2:       ERASE FilName$
		CLOSE #1
		CHAIN MyName$(0)
		
OpenFile:       CALL ShortName(SourcePath$)
		ON ERROR GOTO FileNotFound
		OPEN SourcePath$ FOR INPUT ACCESS READ AS #1   ' Avoid creation of file is file doesn't exist
		CLOSE #1
		' OPEN SourcePath$ FOR RANDOM ACCESS READ AS #1 LEN = 256
		OPEN SourcePath$ FOR BINARY ACCESS READ AS #FileNum%
		ON ERROR GOTO 0
		' FIELD #1, 256 AS d$
		' GET #1, 1              ' Get Sector Zero
		CALL GetVirtualZero(FileNum%, d$)
		DskName$ = MID$(d$, 1, 10)
		IF MID$(d$, 14, 3) = "DSK" THEN GOTO IdentFound
		
		CALL box(1, 1, 78, 11)
		LOCATE 2, 3
		PRINT "TI-99/4A DiskName: "
		LOCATE 3, 3
		PRINT  DskName$;
		LOCATE 5, 3
		PRINT "Warning....";
		LOCATE 6, 3
		PRINT "This file doesn't appear to be a true TI99-PC image file ";
		LOCATE 7, 3
		PRINT "('DSK' missing in sector 0).";
		LOCATE 9, 3
		PRINT "Do you still want to go on? (Y/N) N";
		LOCATE 9, 37, 1
		DO: C$ = INKEY$: LOOP UNTIL C$ <> ""
		IF UCASE$(C$) = "Y"  THEN GOTO IdentFound
		GOTO Abort
		
FileNotFound:   RESUME FileNotFound1
FileNotFound1:  ON ERROR GOTO 0  
		CALL box(1, 1, 78, 10)
		LOCATE 2, 3
		PRINT "TI-99/4A Disk Image Filename:"
		LOCATE 4, 3
		PRINT SourcePath$
		LOCATE 6, 3
		PRINT "Error. The above filename doesn't exist"
Correct:        LOCATE 7, 3
		PRINT "Please correct and try again"
		LOCATE 9, 3
		PRINT "Press any key"
		BEEP
SomeMore:       DO: U$ = INKEY$: LOOP UNTIL U$ <> ""
		GOTO Abort

PathNotFound:   RESUME PathNotFound1
PathNotFound1:  ON ERROR GOTO 0  
		CALL ERRSOUND
		CALL box(1, 1, 78, 10)
		LOCATE 2, 3
		PRINT "Error. The following destination path doesn't exist:";
		LOCATE 3, 3
		PRINT Path$;
		GOTO Correct
		
IdentFound:
		
		TotSect% = CalcWord(d$, 11)
		Tracks% = ASC(MID$(d$, 18, 1))
		Sides% = ASC(MID$(d$, 19, 1)): IF Sides% = 0 THEN Sides% = 1
		Dens% = ASC(MID$(d$, 20, 1)): IF Dens% = 0 THEN Dens% = 1

'=====> SUBDIRECTORIES (TWO LINES) - CHANGED CODE                
		SideDensity$ = "(" + MID$("SD", Sides%, 1) + "S/" + MID$("SDH", Dens%, 1) + "D)"
		IF Tracks = 80 AND Dens% =2 THEN MID$(SideDensity$, 5, 1) = "Q"
		
'=====> SUBDIRECTORIES (START) - ADDED CODE
		CurrFileDescrIndex% = 1                        ' Sector containing the File Descriptor Index

		IF Tracks < 80 THEN GOTO NoSubDirExist         ' Only 80 track Geneve disks can have sudirectories
		ChosenDir% = 1                
                 ' Array element that is the Chosen Directory
		ActiveDirs% = 0
		FOR T = 1 TO 3
		W = CalcWord(d$, 31 + (12 * (T - 1)))
		IF W = 0 THEN GOTO NextSubDir
		IF T = 1 THEN SubDirStAddr%(1) = 1: SubDirName$(1) = "Root_Dir": ActiveDirs% = ActiveDirs% + 1
		ActiveDirs% = ActiveDirs% + 1
		SubDirStAddr%(ActiveDirs%) = W: SubDirName$(ActiveDirs%) = MID$(d$, 21 + (12 * (T - 1)), 10)
NextSubDir:     NEXT T

NoSubDirExist:  ErrSect$ = ""
		IF LEFT$(FType$, 1) <> "V" THEN GOTO NoSubDirPoss
		' Get 1st of the 3 last sectors beyond end of TI disk: Additional Bad Sector Table
		CALL GetVirtualSect(FileNum%, TotSect% + 1, d$)
		ErrSect$ = d$
		CALL GetVirtualSect(FileNum%, TotSect% + 2, d$)
		ErrSect$ = ErrSect$ + d$
		CALL GetVirtualSect(FileNum%, TotSect% + 3, d$)
		ErrSect$ = ErrSect$ + d$
		TotEr% = VAL(MID$(ErrSect$, 13, 8))

		
NoSubDirPoss:
'=====> SUBDIRECTORIES (END) - ADDED CODE
		
		
'=====> SUBDIRECTORIES (ONE LINE) - CHANGED CODE
		'GET #1, CurrFileDescrIndex% + 1            ' Get Sector 1: Filename Table, alphabetically ordered
		CALL GetVirtualSect(FileNum%,CurrFileDescrIndex% + 1, d$)  ' Get Sector 1: Filename Table, alphabetically ordered
		TFNames% = 1            ' We have to work out how many filenames there are
NextEl:         sn% = CalcWord(d$, (TFNames%) * 2 - 1)
		IF sn% <> 0 THEN TFNames% = TFNames% + 1: GOTO NextEl
		
		TFNames% = TFNames% - 1 + ActiveDirs%  ' Well this is how many filenames we've got
		' IF TFNames% = 0 THEN TFNames% = 1  ' Well this is how many filenames we've got
		
		REDIM FilName$(TFNames%)      ' Source Filenames
		REDIM OutFilName$(TFNames%)   ' Output Filenames
		REDIM StartSect%(TFNames%)    ' Starting sector for this filename
		REDIM CopyMark$(TFNames%)     ' "C" if copy enabled
		REDIM FileErrList$(TFNames%)  ' Error list of each filename

		FOR T = 1 TO TFNames%    ' Assume user doesn't want to Extract any file
		CopyMark$(T) = " "
		IF ActiveDirs% > 0 AND T = ChosenDir% THEN CopyMark$(T) = ">"
		NEXT T
		
		FOR T = 1 TO ActiveDirs%    ' If Active Directories exist
		FilName$(T) = SubDirName$(T)
		StartSect%(T) = SubDirStAddr%(T)
		NEXT T
		
		FOR T = ActiveDirs% + 1 TO TFNames% ' Memorize Starting Sector of all filenames
		StartSect%(T) = CalcWord(d$, (T - ActiveDirs%) * 2 - 1)
		NEXT T

		TotSectorFiles# = 0
		' Get all Filenames with vital parameters
		FOR T% = ActiveDirs% + 1 TO TFNames%
		'GET #1, StartSect%(T%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(T%) + 1, d$)
		FilName$(T%) = MID$(d$, 1, 20)
		J = CalcWord(FilName$(t%), 15) : IF J = -1 THEN J = 0   ' PB 2004.06.05 - Handle FDR Error (BABA)
		TotSectorFiles# = TotSectorFiles# + J			' PB 2004.06.05 - Handle FDR Error (BABA)
		NEXT T%
		
		' CALL ShowHex(ErrSect$)
		IF TotEr% = 0 THEN GOTO NoBadSector
		FOR J = 0 TO (TotSect% / 8) - 1
		T$ = MID$(ErrSect$, 33 + J, 1)
		IF ASC(T$) = 0 THEN GOTO NextByte
		FOR W = 0 TO 7
		IF ASC(T$) AND 2 ^ W THEN K = J * 8 + W: GOSUB WorkOutWhichFile
		NEXT W
NextByte:       NEXT J
		
NoBadSector:
		' Prepare to show all filenames
		
		CurrentScreenRow% = 1
		TotalScreenRows% = 13     ' Rows to display Filenames
		StartRow% = 7  ' Screen Start Row
		CurrentFilename% = 1
		TotFiles2Copy% = 0
		TotSizeFiles2Copy# = 0
		
		FOR T = ActiveDirs% + 1 TO TFNames%  ' Assume user wants to Copy all files
		CopyMark$(T) = " "
		ARKTot% = 0
		NEXT T
		
		AllowedKey$ = CHR$(27)                         ' ESC
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(72) ' Arrow Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(80) ' Arrow Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(77) ' Arrow Right
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(116)' CTRL Arrow Right
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(73) ' Page Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(81) ' Page Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(83) ' Del
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(71) ' Home
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(79) ' End
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(59) ' F1 = Help
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(61) ' F3 = Show Bad Sector
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(64) ' F6 = Proceed
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(65) ' F7 = Show Bad Sector
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(66) ' F8 = Show ARK file directory, if applicable
		AllowedKey$ = AllowedKey$ + CHR$(21)           ' CTRL U = Unmark All
		AllowedKey$ = AllowedKey$ + CHR$(1)            ' CTRL A = Copy All
		AllowedKey$ = AllowedKey$ + CHR$(9)            ' TAB
		AllowedKey$ = AllowedKey$ + CHR$(20)           ' CTRL T
		AllowedKey$ = AllowedKey$ + CHR$(3)            ' CTRL C
		AllowedKey$ = AllowedKey$ + CHR$(11)           ' CTRL K
		AllowedKey$ = AllowedKey$ + CHR$(13)           ' Enter = Execute
		AllowedKey$ = AllowedKey$ + "CMTKX "           ' Keys + Blank
		
		GOSUB TopScreen ' Display Top Part of Title Screen
		
		IF TFNames% = 0 THEN GOSUB AbsNoFiles: GOTO LeaveIt

'===================================
' DISK CATALOG MAIN LOOP STARTS HERE
'===================================

NextFileName:
		COLOR 7, 0
		GOSUB DispFilestoCopy
		IF CurrentScreenRow% = 1 THEN FirstFilename% = CurrentFilename%   ' Get Number of first filename only
		GOSUB DisplayRow  ' Display Current Row

		CurrentFilename% = CurrentFilename% + 1 ' Next Fielename


		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		CurrentScreenRow% = CurrentScreenRow% + 1  ' Next Screen Row
		IF CurrentScreenRow% < TotalScreenRows% + 1 AND CurrentFilename% <= TFNames% THEN GOTO NextFileName

'===================================
' DISK CATALOG MAIN LOOP ENDS HERE
'===================================
' End of filenames
		GOSUB BottomLine       ' Display Bottom Line
		LastFilename% = CurrentFilename% - 1' Get Number of Last used filename
		CurrentFilename% = FirstFilename%  ' Current filename is now first filename in screen

		CurrentScreenRow% = 1
		IF KeepCursBottom% = 0 THEN GOTO LocateCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last filename in Screen
		CurrentScreenRow% = TotalScreenRows%: KeepCursBottom% = 0: CurrentFilename% = LastFilename%
		GOTO LocateCursor2
LocateCursor:
		GOSUB RestoreColor

LocateCursor2:
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7: GOSUB DisplayRow: COLOR 7, 0 ' Display Current Row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		OldScreenRow% = CurrentScreenRow%
		OldFilename% = CurrentFilename%
		IF GoToThisDir% <> 0 THEN CurrentFilename% = GoToThisDir%: GoToThisDir% = 0: GOTO Executit
		'GOSUB ShowValues    ' My little Debugger

DoitAgain:      DO: U$ = INKEY$: LOOP UNTIL U$ <> "": U$ = UCASE$(U$)
		IF INSTR(AllowedKey$, U$) = 0 THEN GOTO DoitAgain

		' ESCape Key
		IF U$ = CHR$(27) THEN GOTO Abort
		
'=====> SUBDIRECTORIES (START) - CHANGED CODE
		' ENTER Key
		IF U$ <> CHR$(13) THEN GOTO IsArrowDown
		IF TotEr% > 0 AND FileErrList$(CurrentFilename%) <> "" THEN GOTO OtherKey9B
		IF CurrentFilename% > ActiveDirs% THEN GOTO StartCopying
		IF CurrentFilename% = ChosenDir% THEN GOTO StartCopying
		IF TotFiles2Copy% = 0 THEN GOTO ChangeDir
		GOSUB GiveUpCopying: IF K$ <> "Y" THEN GOTO ReDraw

ChangeDir:      ChosenDir% = CurrentFilename%
		GoToThisDir% = CurrentFilename%
		CurrFileDescrIndex% = SubDirStAddr%(CurrentFilename%)
		CALL Fischio
		GOTO NoSubDirPoss

IsArrowDown:    ' Arrow Down Key
'=====> SUBDIRECTORIES (END) - CHANGED CODE
		IF U$ <> CHR$(0) + CHR$(80) THEN GOTO OtherKey0
IsArrowDown1:   IF CurrentScreenRow% < LastScreenRow% THEN CurrentScreenRow% = CurrentScreenRow% + 1: CurrentFilename% = CurrentFilename% + 1: GOTO LocateCursor
		IF CurrentFilename% = TFNames% THEN GOTO LocateCursor
		CurrentFilename% = FirstFilename% + 1
		' IF CurrentFilename% > TFNames% - TotalScreenRows% + 1 THEN CurrentFilename% = FirstFilename% - 1 : goto LocateCursor
		KeepCursBottom% = 1
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey0:        'Arrow up Key
		IF U$ <> CHR$(0) + CHR$(72) THEN GOTO OtherKey1
		IF CurrentFilename% = 1 THEN GOTO NoMatch
		IF CurrentScreenRow% > 1 THEN CurrentScreenRow% = CurrentScreenRow% - 1: CurrentFilename% = CurrentFilename% - 1: GOTO LocateCursor
		CurrentFilename% = FirstFilename% - 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey1:        ' Page Up Key
		IF U$ <> CHR$(0) + CHR$(73) THEN GOTO OtherKey2
OtherKey1b:     CurrentFilename% = FirstFilename% - TotalScreenRows%
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey2:        ' Page Down Key
		IF U$ <> CHR$(0) + CHR$(81) THEN GOTO OtherKey3
OtherKey2b:     IF LastFilename% + 1 + TotalScreenRows% > TFNames% THEN CurrentFilename% = TFNames% - TotalScreenRows% + 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1: GOTO Executit
		CurrentFilename% = FirstFilename% + TotalScreenRows%
		IF CurrentFilename% > TFNames% THEN CurrentFilename% = FirstFilename%
		GOTO Executit

OtherKey3:      ' Blank or Del
		IF U$ <> " " AND U$ <> CHR$(0) + CHR$(83) THEN GOTO OtherKey4
'=====> SUBDIRECTORIES (ONE LINE) - ADDED CODE
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN GOTO LocateCursor
		TotFiles2Copy% = TotFiles2Copy% - 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# - SectorLength#
		IF CopyMark$(CurrentFilename%) <> "K" THEN GOTO OtherKey3c
		ARKTot% = ARKTot% - 1: IF ARKTot% < 1 THEN ARKTot% = 0
OtherKey3c:     CopyMark$(CurrentFilename%) = " ": PRINT " "; : GOSUB DispFilestoCopy
		
		GOTO IsArrowDown1


OtherKey4:      ' C or c, M or m
		IF U$ <> "C" AND U$ <> "M" THEN GOTO OtherKey5
'=====> SUBDIRECTORIES (ONE LINE) - ADDED CODE
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# + SectorLength#
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7
		CopyMark$(CurrentFilename%) = "C": PRINT "C";
		CALL ReplaceChars(FilName$(CurrentFilename%), OutFilName$(CurrentFilename%))'Replace MSDOS illegal characters
		GOSUB DispFilestoCopy
		GOTO IsArrowDown1
		
OtherKey4b:     LOCATE StartRow% + CurrentScreenRow%, 52, 1
		OutFilName$(CurrentFilename%) = RTRIM$(Xinput$(StartRow% + CurrentScreenRow%, 52, 25, OutFilName$(CurrentFilename%), Allowed$, Endk$, Exitk$, RealStrLen%))
		P = INSTR(1, OutFilName$(CurrentFilename%), "."): IF P < 10 THEN GOTO OtherKey4b1
		BEEP
		LOCATE StartRow% + CurrentScreenRow%, 68, 1: PRINT "Max 8.3 char";
		WHILE INKEY$ = "": WEND
		LOCATE StartRow% + CurrentScreenRow%, 68, 1: PRINT "            ";
		GOTO OtherKey4b
		
OtherKey4b1:    IF CopyMark$(CurrentFilename%) <>"K" THEN GOTO OtherKey4b2
		ARKN$=OutFilName$(CurrentFilename%)
		FOR UF% = ActiveDirs% + 1 TO TFNames%  ' Assume user wants to Ark all the files
		IF CopyMark$(UF%) ="K" THEN OutFilName$(UF%)=ARKN$
		NEXT UF%
		GOSUB RestoreColor
		GOSUB RePaintScreen
		
		
OtherKey4b2:    COLOR 7, 0

		IF Exitk$ <> CHR$(0) + CHR$(72) THEN GOTO OtherKey4c ' Arrow Up
		FOR FF% = CurrentFilename% - 1 TO ActiveDirs% + 1 STEP -1' Check all the lower filenames
		IF CopyMark$(FF%) <> " " THEN
		K = CurrentFilename% - FF%
		IF CurrentScreenRow% - K > 0 THEN
		CurrentScreenRow% = CurrentScreenRow% - K: CurrentFilename% = FF%
		GOSUB GoToThatLine
		GOTO OtherKey4b
		ELSE
		IF CurrentScreenRow% - K = 0 THEN
		GOSUB RestoreColor
		COLOR 7, 0
		CurrentFilename% = FirstFilename% - 1:
		FirstFilename% = FirstFilename% - 1
		CurrentScreenRow% = 1     ' Cursor on first screen row
		GOSUB RePaintScreen
		GOSUB GoToThatLine
		GOTO OtherKey4b
		END IF
		
		GOSUB RestoreColor
		COLOR 7, 0
		CurrentFilename% = FF%
		FirstFilename% = FF%
		CurrentScreenRow% = 1     ' Cursor on first screen row
		'CLS
		GOSUB RePaintScreen

		COLOR 0, 7
		GOSUB DisplayRow
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		OldScreenRow% = CurrentScreenRow%
		GOTO OtherKey4b
		END IF
		
		GOTO OtherKey4z
		END IF
		NEXT FF%: GOTO OtherKey4z
		
OtherKey4c:     IF Exitk$ <> CHR$(0) + CHR$(80) THEN GOTO OtherKey4d  ' Arrow Down
		FOR FF% = CurrentFilename% + 1 TO TFNames% ' Check all the UPPER filenames
		IF CopyMark$(FF%) <> " " THEN
		K = FF% - CurrentFilename%
		IF CurrentScreenRow% + K <= TotalScreenRows% THEN
		CurrentScreenRow% = CurrentScreenRow + K: CurrentFilename% = FF%
		GOSUB GoToThatLine
		GOTO OtherKey4b
		ELSE
		
		IF CurrentScreenRow% + K = TotalScreenRows% + 1 THEN
		GOSUB RestoreColor
		COLOR 7, 0
		CurrentFilename% = CurrentFilename% + K
		FirstFilename% = FirstFilename% + K
		CurrentScreenRow% = TotalScreenRows%   ' Cursor on first screen row
		GOSUB RePaintScreen
		GOSUB GoToThatLine
		GOTO OtherKey4b
		END IF
		
		GOSUB RestoreColor
		COLOR 7, 0
		CurrentFilename% = FF%
		FirstFilename% = FF% - TotalScreenRows% + 1
		IF FirstFilename% < ActiveDirs% + 1 THEN FirstFilename% = ActiveDirs% + 1
		CurrentScreenRow% = TotalScreenRows%   ' Cursor on first screen row
		'CLS
		GOSUB RePaintScreen
		
		
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7
		GOSUB DisplayRow:
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		OldScreenRow% = CurrentScreenRow%
		GOTO OtherKey4b
		END IF
		GOTO OtherKey4z
		END IF
		NEXT FF%: GOTO OtherKey4z
		
OtherKey4d:     IF Exitk$ <> CHR$(0) + CHR$(73) THEN GOTO OtherKey4e ' Page Up
		GOTO OtherKey1b
OtherKey4e:     IF Exitk$ <> CHR$(0) + CHR$(81) THEN GOTO OtherKey4z ' Page Down
		GOTO OtherKey2b
		
OtherKey4z:  
		GOTO LocateCursor

OtherKey5:      ' CTRL U = Unmark all
		IF U$ <> CHR$(21) THEN GOTO OtherKey6
		GOSUB UnselectAll
		GOTO NoMatch

OtherKey6:      ' CTRL A = Mark all
		IF U$ <> CHR$(1) AND U$ <> CHR$(3) THEN GOTO OtherKey7
'=====> SUBDIRECTORIES (ONE LINE) - CHANGED CODE
		FOR T = ActiveDirs% + 1 TO TFNames%  ' Assume user wants to Copy all files
		IF CopyMark$(T) = " " THEN CopyMark$(T) = "C"
		IF CopyMark$(T) = "C" THEN CALL ReplaceChars(FilName$(T), OutFilName$(T))'Replace MSDOS illegal characters
		NEXT T
		
		
		TotFiles2Copy% = TFNames%
		TotSizeFiles2Copy# = TotSectorFiles# + TFNames% - ActiveDirs%
		GOSUB RePaintScreen
		GOTO NoMatch

OtherKey7:        ' Home Key : simply move cursor to top
		IF U$ <> CHR$(0) + CHR$(71) THEN GOTO OtherKey8
		CurrentScreenRow% = 1: CurrentFilename% = FirstFilename%: GOTO LocateCursor


OtherKey8:        ' End Key : simply move cursor to bottom
		IF U$ <> CHR$(0) + CHR$(79) THEN GOTO OtherKey9
		CurrentScreenRow% = LastScreenRow%: CurrentFilename% = LastFilename%
		GOTO LocateCursor

OtherKey9:      ' F3 : Show full error list for this filename
		IF U$ <> CHR$(0) + CHR$(61) THEN GOTO OtherKey10
'=====> SUBDIRECTORIES (ONE LINE) - CHANGED CODE
		IF TotEr% = 0 OR FileErrList$(CurrentFilename%) = "" THEN GOTO NoMatch
OtherKey9B:     GOSUB ShowErrorList
		GOSUB RePaintScreen
		GOTO NoMatch
		
'========SHOW SECTORS - ADD START
		' F7 = Show Sector as Hex
OtherKey10:     IF U$ <> CHR$(0) + CHR$(65) THEN GOTO OtherKey11     
		IF CurrentFilename% <= ActiveDirs% THEN GOTO NoMatch
		GOSUB ShowSector
		GOSUB RePaintScreen
		GOTO NoMatch

OtherKey11:     ' Arrow Right
		IF U$ <> CHR$(0) + CHR$(77) AND U$ <> CHR$(9) AND U$ <> CHR$(0) + CHR$(116) THEN GOTO OtherKey12
		IF CopyMark$(CurrentFilename%) = " " THEN GOTO OtherKey12
		COLOR 0, 7
		GOTO OtherKey4b
		
OtherKey12:     ' T = Copy as TIFILES
		IF U$ <> "T" THEN GOTO OtherKey13
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# + SectorLength#
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7
		CopyMark$(CurrentFilename%) = "T": PRINT "T";
		IF OutFilName$(CurrentFilename%) = "" THEN CALL ReplaceChars(FilName$(CurrentFilename%), OutFilName$(CurrentFilename%))'Replace MSDOS illegal characters
		CALL TIGName(OutFilName$(CurrentFilename%))
		
		UF% = CurrentFilename%
		GOSUB AvoidDupNames
		GOSUB DispFilestoCopy
		GOTO IsArrowDown1
		
		
OtherKey13:     ' CTRL T = Mark all as TIFILES
		IF U$ <> CHR$(20) THEN GOTO OtherKey14
'=====> SUBDIRECTORIES (ONE LINE) - CHANGED CODE
		FOR UF% = ActiveDirs% + 1 TO TFNames%  ' Assume user wants to Copy all the files
		IF CopyMark$(UF%) = " " THEN CopyMark$(UF%) = "T" ELSE GOTO OtherKey13c
		IF OutFilName$(UF%) = "" THEN CALL ReplaceChars(FilName$(UF%), OutFilName$(UF%))'Replace MSDOS illegal characters
		
		CALL TIGName(OutFilName$(UF%))
		GOSUB AvoidDupNames
OtherKey13c:        
		NEXT UF%
		TotFiles2Copy% = TFNames%
		TotSizeFiles2Copy# = TotSectorFiles# + TFNames% - ActiveDirs%
		GOSUB RePaintScreen
		GOTO NoMatch
		
OtherKey14:     '  K = Mark file as an ARK FILE
		IF U$ <> "K" THEN GOTO OtherKey15

'=====> SUBDIRECTORIES (ONE LINE) - CHANGED CODE
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = "K" THEN GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# + SectorLength#
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7
		CopyMark$(CurrentFilename%) = "K": PRINT "K";
		IF ARKTot% <> 0 THEN GOTO OtherKey14b
		ARKTot% = ARKTot% + 1
		CALL ReplaceChars(FilName$(CurrentFilename%), OutFilName$(CurrentFilename%))
		CALL ARKName(OutFilName$(CurrentFilename%))
		UF% = CurrentFilename%
		GOSUB AvoidDupNames 'Replace MSDOS illegal characters
		ARKN$ = OutFilName$(CurrentFilename%)
		GOTO OtherKey14c
OtherKey14b:    OutFilName$(CurrentFilename%) = ARKN$ 'Replace MSDOS illegal characters
		ARKTot% = ARKTot% + 1

OtherKey14c:    GOSUB DispFilestoCopy
		'GOSUB RePaintScreen
		GOTO IsArrowDown1
		
OtherKey15:     ' CTRL K = Mark all as ARK FILES
		IF U$ <> CHR$(11) THEN GOTO OtherKey16
		
'=====> SUBDIRECTORIES (ONE LINE) - CHANGED CODE
		FOR UF% = ActiveDirs% + 1 TO TFNames%  ' Assume user wants to Ark all the files
		
		IF CopyMark$(UF%) = " " THEN CopyMark$(UF%) = "K" ELSE GOTO OtherKey15c
		IF ARKTot% <> 0 THEN GOTO OtherKey15b
		ARKTot% = ARKTot% + 1
		CALL ReplaceChars(FilName$(CurrentFilename%), OutFilName$(UF%))
		CALL ARKName(OutFilName$(UF%))
		GOSUB AvoidDupNames 'Replace MSDOS illegal characters
		ARKN$ = OutFilName$(UF%)
		GOTO OtherKey15c
OtherKey15b:   
		OutFilName$(UF%) = ARKN$ 'Replace MSDOS illegal characters
		ARKTot% = ARKTot% + 1

OtherKey15c:         
		NEXT UF%

		TotFiles2Copy% = TFNames%
		TotSizeFiles2Copy# = TotSectorFiles# + TFNames% - ActiveDirs%
		GOSUB RePaintScreen
		GOTO NoMatch



OtherKey16:     ' F1 (Help) key
		IF U$ <> CHR$(0) + CHR$(59)  THEN GOTO OtherKey17
		CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "17.03.00")
		GOSUB RePaintScreen
		GOTO LocateCursor
		GOTO NoMatch
		

ReDraw:         CurrentFilename% = FirstFilename%
Executit:
		CurrentScreenRow% = 1     ' Cursor on first screen row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		GOTO NextFileName   ' Start next round
		
		
'========SHOW ARK FILE
		' F8 = I ARK file, display it
OtherKey17:     IF U$ <> CHR$(0) + CHR$(66) THEN GOTO OtherKey18     
		IF CurrentFilename% <= ActiveDirs% THEN GOTO NoMatch
		
		IF ASC(MID$(FilName$(CurrentFilename%), 18, 1))<>128 THEN GOTO NoMatch
		FileType% = ASC(MID$(FilName$(CurrentFilename%), 13, 1))
		FileType% = FileType% AND &H8B
		FileType% = FileType% AND &HF7
		SELECT CASE FileType%
		CASE 0, 2 ' "Dis/Fix"
		GOSUB ARKextract
		cls
		COLOR 14,0
		
		PRINT TAB(15); "Catalog of Archive File: ";  MID$(FilName$(CurrentFilename%), 1, 10)
		Exec$="Decomp4.com "+ TempArk$ + " /s"
		Shell Exec$
		COLOR 7,0
		CLS
		END SELECT
		
		' GOSUB ShowSector
		GOSUB RePaintScreen
		GOTO NoMatch

OtherKey18:     ' X = Entirely unark an ARK file to its directory
		IF U$ <> "X" THEN GOTO OtherKey19
		'=====> SUBDIRECTORIES (ONE LINE) - ADDED CODE
		IF CurrentFilename% <= ActiveDirs% THEN CALL ERRSOUND: GOTO NoMatch
		IF CopyMark$(CurrentFilename%) = " " THEN TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB SectorLength: TotSizeFiles2Copy# = TotSizeFiles2Copy# + SectorLength#
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7
		CopyMark$(CurrentFilename%) = "X": PRINT "X";
		CALL ReplaceChars(FilName$(CurrentFilename%), OutFilName$(CurrentFilename%))'Replace MSDOS illegal characters
		GOSUB DispFilestoCopy
		GOTO IsArrowDown1




OtherKey19:     ' F6 = Proceed
		IF U$ <> CHR$(0) + CHR$(64) THEN GOTO OtherKey20     
		GOTO StartCopying
		
		
OtherKey20:		
NoMatch:        GOTO LocateCursor

StartCopying:   CALL box(8, 20, 50, 5)
		BEEP
		LOCATE 10, 32
		PRINT "Ready to Start ? (Y/N) Y" : LOCATE 10, 55
		DO
		K$ = UCASE$(INKEY$)
		LOOP UNTIL K$ <> ""
		PRINT K$;
		IF K$ = "Y" OR K$=CHR$(13) OR K$=CHR$(0) + CHR$(64) THEN GOTO StartCopying2
		
NoCopying:      GOSUB RePaintScreen
		GOTO NoMatch
'======================
' START COPY FILES
'======================
StartCopying2:

		
'=====> SUBDIRECTORIES (ONE LINE) - CHANGED CODE          
		IF TotFiles2Copy% = 0 THEN LOCATE 10, 32:  PRINT "No selected file          "; : INPUT "", C$: GOTO NoCopying
		
		CLS
		' Get all Filenames with vital parameters
		
		FOR FileToCopy% = ActiveDirs%+1 TO TFNames%
		
		IF CopyMark$(FileToCopy%) = " " THEN GOTO NotThisOne
		'GET #1, StartSect%(FileToCopy%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(FileToCopy%) + 1, d$)
		FOut$ = RTRIM$(LTRIM$(OutFilName$(FileToCopy%)))
		
		ON ERROR GOTO PathNotFound
		ON ERROR GOTO 0
		PRINT "("; LTRIM$(RTRIM$(STR$(FileToCopy%))); ") "; FOut$;
		
		
		FHeader$ = d$
		SectorLength# = CalcWord(FilName$(FileToCopy%), 15) + 1
		
		Z = 0                      ' Offset in Input File Chain Pointer Block
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		SectorCnt% = SectorLength# - 1' Sector Length of this file
		
		IF CopyMark$(FileToCopy%) = "K" THEN GOSUB ARKFILESxfer: GOTO NotThisOne
		IF CopyMark$(FileToCopy%) = "X" THEN uPath$=Path$ : Path$="": xOut$=FOut$ : FOut$=TmpFilName$  : GOTO StartCop3
		ON ERROR GOTO StartCop1
		OPEN Path$ + FOut$ + "\~~~Z.Z~~" FOR BINARY ACCESS WRITE AS #2
		CLOSE #2
		KILL Path$ + FOut$ + "\~~~Z.Z~~" 
		
		BEEP
		PRINT 
		PRINT "Error! There is a directory named as the new file to be created:";Path$ + FOut$
		PRINT "Rename the ";Path$ + FOut$;" directory and try again.": input ccc$ 
		GOTO NextFile
		
StartCop1:	RESUME StartCop2
StartCop2:	ON ERROR GOTO 0	
		OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #2    ' Do Away with pre-existing output files.
		CLOSE #2: ON ERROR GOTO 0                           ' Binary Access will only partially over write
		KILL Path$ + FOut$                                  ' existing long files.
		
		IF CopyMark$(FileToCopy%) = "T" THEN GOSUB TIFILESxfer: GOTO NotThisOne
StartCop3:      
		FileType% = ASC(MID$(FHeader$, 13, 1))
		FileType% = FileType% AND &H8B        ' Get rid of reserved bits: 2,4-6
		FileType% = FileType% AND &HF7        ' Get rid of bit: 3
		
		SELECT CASE FileType%
		CASE 0
		'FileType$ = "Dis/Fix"
		GOSUB DisFix
		CASE 1
		'FileType$ = "Program"
		GOSUB Program
		CASE 2
		'FileType$ = "Int/Fix"
		GOSUB DisFix
		'Int/Fix is handled as Dis/Fix
		CASE 128
		'FileType$ = "Dis/Var"
		GOSUB DisVar :  PRINT TAB(18); "- Total records="; Trecs&
		CASE 130
		'FileType$ = "Int/Var"
		GOSUB IntVar                   ' 5.5.2001 = Int/Var is now handled as Int/Var!
		CASE ELSE
		'FileType$ = "unknown"
		GOSUB Program                  ' unknown is handled as Program
		END SELECT
		
		IF CopyMark$(FileToCopy%) = "X" THEN GOSUB DEARKxfer:Path$=uPath$: GOTO NotThisOne

NotThisOne:     K$ = INKEY$: IF K$ = "" THEN GOTO NextFile

		PRINT "   -  A key has been pressed.   -"
		PRINT "Press any key to resume, ESC to exit."
WaitSome:       K$ = INKEY$: IF K$ = "" THEN GOTO WaitSome
		IF ASC(K$) = 27 THEN GOTO NoMoreFiles
		
NextFile:       NEXT FileToCopy%

' Handle ARK file, if opened

		IF ARKFL$ = "" THEN GOTO NoARKFile
		CLOSE #8
		FOut$=  ARKFL$
		
' Compress ARK file

		
		SHELLSTR$ = "comp2.com " + Path$ + FOut$ + "  " + Path$ + TempArk$
		SHELL SHELLSTR$
		
		KILL Path$ + FOut$
		OPEN Path$ + TempArk$ FOR BINARY ACCESS READ AS #8
		OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #2
		TLEN& = LOF(8)
		
' Add TIFILES Header to ARK file                              
		A$ = CHR$(7) + "TIFILES"
		T = INT(TLEN& / 256)' Total Sectors
		IF TLEN& MOD 256 > 0 THEN T = T + 1
		A$ = A$ + CHR$(INT(T / 256)) + CHR$(T MOD 256)' Bytes 15,16 (byte 1=first) = Filelength
		A$ = A$ + CHR$(&H2)                          ' Byte  13    (byte 1=first) = FileType >02=INT/FIX
		A$ = A$ + CHR$(&H2)                          ' Byte  14    (byte 1=first) = Max. numb. of records/sector or AU
		A$ = A$ + CHR$(&H0)                          ' Byte  17    (byte 1=first) = End of file Offset
		A$ = A$ + CHR$(&H80)                         ' Byte  18    (byte 1=first) = Logical record Length =128
		T = INT(TLEN& / 128)' Total Records
		IF TLEN& MOD 128 > 0 THEN T = T + 1
		A$ = A$ + CHR$(INT(T / 256)) + CHR$(T MOD 256)' Bytes 19,20 (byte 1=first) = Number of Fixed Length Record -OR- Number of Sectors used by variable Length Records
		A$ = A$ + LEFT$(CA5364$, 128 - LEN(A$))
		
		PUT #2, , A$

' Add body to ARK file        
		
		MAXSTRLEN% = 1000
		Chunk% = INT(TLEN& / MAXSTRLEN%)
		IF Chunk% = 0 THEN GOTO FIARC2
		FOR T = 1 TO Chunk%
		A$ = INPUT$(MAXSTRLEN%, #8)
		PUT #2, , A$
		NEXT T
		
FIARC2:         Remaindr% = TLEN& MOD MAXSTRLEN%
		IF Remaindr% = 0 THEN GOTO FIARC3
		A$ = INPUT$(Remaindr%, #8)
		PUT #2, , A$

' Pad with zeroes until last TI sector in file
FIARC3:         Remaindr% = TLEN& MOD 256
		IF Remaindr% = 0 THEN GOTO FIARC4
		Remaindr% = 256 - Remaindr%
		A$ = STRING$(Remaindr%, CHR$(0))
		PUT #2, , A$
FIARC4:         CLOSE #8
		CLOSE #2
		KILL Path$ + TempArk$
		A$ = ""
		ARKFL$ = ""
		
NoARKFile:      PRINT       
		PRINT "Total files just copied:"; TotFiles2Copy%
		PRINT "Total sectors just copied:"; TotSizeFiles2Copy#
		PRINT "Output Path .............: "; Path$
		PRINT TAB(10); "- Press any key to exit -"
		WHILE INKEY$ = "": WEND
		
NoMoreFiles:    IF ActiveDirs% > 0 THEN GOTO NoSubDirPoss
		GOSUB RePaintScreen
		GOTO NoMatch
		
		
		
		
' DIS/FIX type: each record has a leading record-lenghth byte. Records cannot cross sectors.
DisFix:         PRINT TAB(18); "- Total records"; 
		GOSUB DoDisFix
		PRINT "="; Trecs&
		RETURN
		
' Prepare file to be cataloged upon by LZW decompressor 
ARKextract:     'GET #1, StartSect%(CurrentFilename%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(CurrentFilename%) + 1, d$)
		FHeader$ = d$
		SectorLength# = CalcWord(FilName$(CurrentFilename%), 15) + 1
		Z = 0                      ' Offset in Input File Chain Pointer Block
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		SectorCnt% = SectorLength# - 1' Sector Length of this file
		OPEN TempArk$ FOR BINARY ACCESS WRITE AS #2
		GOSUB DoDisFix2
		RETURN

		
DoDisFix:       OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #2
DoDisFix2:      Z = 0: BytePos& = 1: Trecs& = 0
		TotRecs& = ASC(MID$(FHeader$, 20, 1)) * 256 + ASC(MID$(FHeader$, 19, 1))
		RecsInSect% = ASC(MID$(FHeader$, 14, 1))
		LogRecLength% = ASC(MID$(FHeader$, 18, 1))
		
		' Special case: Archiver III files are sometimes bugged. The Total Records (Bytes 19+20 in FDR)
		' sometimes report 256 records less than what it should.
		' The following patch compares the Total Records
		' with the Total Sector*2 which, in a dis/fix 128 record should be more or less comparable.
		' If this is not the case, adds 256 bytes to previous value
		' Trecs&=0:GOTO NextClusterDF
		
		IF LogRecLength% <> 128 THEN GOTO NextClusterDF
		T& = (SectorCnt% - 1) * 2
		IF T& <= TotRecs& THEN GOTO NextClusterDF
		TotRecs& = TotRecs& + 256
		' PRINT " (fixed!)";
		' print  "Total Records="; TotRecs&  :input c$
		
NextClusterDF:  GOSUB CalcClusters
		IF StSec% = 0 THEN GOTO EOThisFileDF
		
NextOffsValDF:
		
		IF GlobalInpOffset% > Offs% THEN Z = Z + 3: GOTO NextClusterDF
		
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		
		
		GOSUB RecToDoDF
		IF TotRecs& < 1 THEN GOTO EOThisFileDF
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		
		' DoneSect=DoneSect+1: PRINT TotRecs&;DoneSect; GlobalInpOffset%
		
		GOTO NextOffsValDF

EOThisFileDF:   
		CLOSE #2
		
		RETURN

' Transfer a Dis/Var record (Text)
RecToDoDF:      ROff% = 1

RecToDoDFAG:    FOR RT% = 1 TO RecsInSect%
		DFRec$ = MID$(d$, ROff%, LogRecLength%)
		PUT #2, BytePos&, DFRec$: BytePos& = BytePos& + LogRecLength%
		ROff% = ROff% + LogRecLength%
		TotRecs& = TotRecs& - 1
		Trecs& = Trecs& + 1
		IF TotRecs& < 1 THEN GOTO RecDoneDF
		NEXT RT%
		
RecDoneDF:      RETURN
		
		
' Program type: a collection of sectors
Program:
		OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #2
		Z = 0: BytePos& = 1
		Suspend$ = ""
NextClusterPr:
		GOSUB CalcClusters
		IF StSec% = 0 THEN GOTO EOThisFilePr
		IF Suspend$ <> "" THEN Suspend$ = "": PUT #2, BytePos&, d$: BytePos& = BytePos& + 256
		
NextOffsValPR:
		IF GlobalInpOffset% > Offs% - 1 THEN Z = Z + 3: GOTO LastClusterPR
		
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		PUT #2, BytePos&, d$: BytePos& = BytePos& + 256
		
		
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO NextOffsValPR

LastClusterPR:
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		Suspend$ = "Y"
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO NextClusterPr
		
EOThisFilePr:
		EOFOffset% = ASC(MID$(FHeader$, 17, 1))
		IF EOFOffset% = 0 THEN EOFOffset% = 256
		RealOut$ = LEFT$(d$, EOFOffset%)
		PUT #2, BytePos&, RealOut$: BytePos& = BytePos& + EOFOffset%
		PRINT " "
		CLOSE #2
		RETURN

' DIS/VAR type: each record has a leading record-lenghth byte. Records cannot cross sectors.
DisVar:
		OPEN Path$ + FOut$ FOR OUTPUT ACCESS WRITE AS #2
		Z = 0: EOFOffset% = 255: Trecs& = 0
		Suspend$ = ""
NextClusterDV:
		
		GOSUB CalcClusters
		IF StSec% = 0 THEN GOTO EOThisFileDV
		
		IF Suspend$ <> "" THEN Suspend$ = "": GOSUB RecToDoDV
NextOffsValDV:
		IF GlobalInpOffset% > Offs% - 1 THEN Z = Z + 3: GOTO LastClusterDV
		
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		GOSUB RecToDoDV
		
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO NextOffsValDV
		
LastClusterDV:	
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		
		Suspend$ = "Y"
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO NextClusterDV
		



EOThisFileDV:
		EOFOffset% = ASC(MID$(FHeader$, 17, 1))
		IF EOFOffset% = 0 THEN EOFOffset% = 256
		GOSUB RecToDoDV
		
		
		CLOSE #2
		RETURN

' Transfer a Dis/Var record (Text)
RecToDoDV:                  ROff% = 1

RecToDoDVAG:    RLen% = ASC(MID$(d$, ROff%, 1))
		IF RLen% = 255 THEN GOTO RecDoneDV:
		ROff% = ROff% + 1
		DVRec$ = MID$(d$, ROff%, RLen%)
		PRINT #2, DVRec$
		Trecs& = Trecs& + 1
		ROff% = ROff% + RLen%
		IF ROff% < EOFOffset% THEN GOTO RecToDoDVAG
RecDoneDV:      RETURN

'===========================================================================================
' INT/VAR type: each record has a leading record-lenghth byte. Records cannot cross sectors.
'
' Unlike DisVar, IntVar may have embedded characters below CHR$(32), such as CHR$(13) or
' CHR$(10). Thus, if we got rid of length byte and output the record as a DOS Text file, we
' would mess up the file content. We are forced to keep the length byte. Another option
' would be to transform each record as a DOS FIXED LENGTH Record. But because the real
' maximum length is unknown, we would have to default to the max. theoretical record length,
' i.e. 256, and this would prevent the file from being easily re-imported into a TI disk.
' Thus, we will:
' - Open the Output file as BINARY, since we do not want CHR$(13), CHR$(10) end of record.
' - Add the Record Length Byte before the record, thus keeping the TI Format.
'
' The only code portions that has been changed (with respect to DisVar) are:
' - The OPEN statement
' - The RecToDoIVAG routine

IntVar:         OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #2
		BytePos& = 1
		Z = 0: EOFOffset% = 255: Trecs& = 0
		Suspend$ = ""
NextClusterIV:
		
		GOSUB CalcClusters
		IF StSec% = 0 THEN GOTO EOThisFileIV
		
		IF Suspend$ <> "" THEN Suspend$ = "": GOSUB RecToDoIV
NextOffsValIV:
		IF GlobalInpOffset% > Offs% - 1 THEN Z = Z + 3: GOTO LastClusterIV

		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		GOSUB RecToDoIV
		
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO NextOffsValIV
		
LastClusterIV:	'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		Suspend$ = "Y"
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO NextClusterIV




EOThisFileIV:
		EOFOffset% = ASC(MID$(FHeader$, 17, 1))
		IF EOFOffset% = 0 THEN EOFOffset% = 256
		GOSUB RecToDoIV
		
		PRINT TAB(18); "- Total records="; Trecs&
		CLOSE #2
		RETURN

		' Transfer a Int/Var record (Text)
RecToDoIV:      ROff% = 1

RecToDoIVAG:    RLen% = ASC(MID$(d$, ROff%, 1))
		IF RLen% = 255 THEN GOTO RecDoneIV:
		DVRec$ = MID$(d$, ROff%, RLen% + 1)
		ROff% = ROff% + 1
		PUT #2, BytePos&, DVRec$: BytePos& = BytePos& + LEN(DVRec$)
		Trecs& = Trecs& + 1
		ROff% = ROff% + RLen%
		IF ROff% < EOFOffset% THEN GOTO RecToDoIVAG
RecDoneIV:      RETURN

'=============================
' TIFILES HEADER FILE TRANSFER
'=============================
TIFILESxfer:

		OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #2
		Z = 0: BytePos& = 1
		Suspend$ = ""
		
		A$ = CHR$(7) + "TIFILES"
		A$ = A$ + MID$(FHeader$, 15, 2)' Bytes 15,16 (byte 1=first) = Filelength
		A$ = A$ + MID$(FHeader$, 13, 1)' Byte  13    (byte 1=first) = FileType
		A$ = A$ + MID$(FHeader$, 14, 1)' Byte  14    (byte 1=first) = Max. numb. of records/sector or AU
		A$ = A$ + MID$(FHeader$, 17, 1)' Byte  17    (byte 1=first) = End of file Offset
		A$ = A$ + MID$(FHeader$, 18, 1)' Byte  18    (byte 1=first) = Logical record Length
		A$ = A$ + MID$(FHeader$, 19, 2)' Bytes 19,20 (byte 1=first) = Number of Fixed Length Record -OR- Number of Sectors used by variable Length Records
		A$ = A$ + MID$(FilName$(FileToCopy%), 1, 10)
		A$ = A$ + STRING$(&H70 - LEN(A$),CHR$(00))
		A$ = A$ + MID$(FHeader$, 21, 8)   ' Bytes 21,28 (byte 1=first) = Update Time + Date, Creation Time and Time, if any
		A$ = A$ + CHR$(&H00) + CHR$(&H00) + CHR$(&H00)+ CHR$(&H00)  ' 4 bytes for future versions
		A$ = A$ + CHR$(&H00) + CHR$(&H01)                            ' Version #= 0001
		A$ = A$ + CHR$(&HAA)+ CHR$(&HAA)                             ' hArAld glAAb (Harald Glaab) new TIFILES format Marker: AA55
		'A$ = A$ + LEFT$(CA5364$, 128 - LEN(A$))
		
		PUT #2, BytePos&, A$: BytePos& = BytePos& + 128
NextClusterTIF:
		GOSUB CalcClusters
		IF StSec% = 0 THEN GOTO EOThisFileTIF
		IF Suspend$ <> "" THEN Suspend$ = "": PUT #2, BytePos&, d$: BytePos& = BytePos& + 256
		
NextOffsValTIF:
		IF GlobalInpOffset% > Offs% - 1 THEN Z = Z + 3: GOTO LastClusterTIF

		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		PUT #2, BytePos&, d$: BytePos& = BytePos& + 256
		
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO NextOffsValTIF

LastClusterTIF:
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		Suspend$ = "Y"
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO NextClusterTIF
		
EOThisFileTIF:
		'EOFOffset% = ASC(MID$(FHeader$, 17, 1))
		'IF EOFOffset% = 0 THEN EOFOffset% = 256
		'RealOut$ = LEFT$(d$, EOFOffset%)
		'PUT #2, BytePos&, RealOut$: BytePos& = BytePos& + EOFOffset%
		PUT #2, BytePos&, d$: BytePos& = BytePos& + 256
		
		CLOSE #2
		RETURN


'=============================
' FULLY EXTRACT AN ARK FILE
'=============================
DEARKxfer:	
		CALL ReplaceChars(xOut$, xOut$)
		IF LEN(xOut$)>8 then xOut$=LEFT$(xOut$,8) +"."+MID$(xOut$,9,3)
		ON ERROR GOTO NoFileDir
		OPEN uPath$ + xOut$ FOR INPUT AS #8
		CLOSE #8
		BEEP
		PRINT 
		PRINT "Error! There is a file named as the new directory to be created:";uPath$ + xOut$
		PRINT "Rename the ";uPath$ + xOut$;" file and try again.": input ccc$ : GOTO DEARKxferEnd
NoFileDir:	RESUME NoFileDir2
NoFileDir2:	
		ON ERROR GOTO 0
		ON ERROR GOTO NoDir
		OPEN uPath$ + xOut$ + "\CON" FOR INPUT AS #8
		ON ERROR GOTO 0
		CLOSE #8
		'PRINT "Dir exists!"
		GOTO DEARKxfer02
		
NoDir:          RESUME NoDir2
NoDir2:         ON ERROR GOTO 0
		'PRINT "Dir *doesn't* exist!"
		MKDIR uPath$ + xOut$
DEARKxfer02:    xPath$ = uPath$ + xOut$ + "\"
		Exec$ = "Decomp4.com " + TmpFilName$ + " " + TempArk$ + " >NULL"
		Shell Exec$
	
		TFS% = 0' Count of Temporary File Sectors
		OutSect$ = ""
		OutLen% = 0
		TotRec% = 0
		' Now search the SubArk file inside the Ark File. Logic:
		' - 1) Read the first filename. Get sector count in SArkSektCnt. Compare to our filename.
		'      Match?
		' - 2) No, add Store sector count to Sectors2Skip accumulator and process next filename
		' - 3) Yes, Save Filename to first >100 bytes (FDR) of xPath$ output file.
		' - 4) Add all the FDR info (reclen, file record count, etc) and replace the file type
		'      with the one chosen by user
		' - 5) Go and find the "END!" string (End Of Filename Table Marker).
		' - 6) From End Of Table Marker skip as many sectors as those counted in in Sectors2Skip
		' - 7) Now, transfer as many sectors as those in SArkSektCnt to xPath$ output file
		' - 8) We're done
		Zero10$=STRING$(10,CHR$(0))
		OPEN TempArk$ FOR RANDOM ACCESS READ AS #8 LEN = 256
		Sectors2Skip = 0: ArkRecord = 0 : StartData& = 0
		FIELD #8, 256 AS Dat$

		' Search the first sector with Data (first sector after "END!" End of File Table Marker)
		WHILE NOT EOF(8)
		StartData&  = StartData&  + 1
		GET #8
		IF MID$(Dat$, 253, 4) = "END!" THEN GOTO DeArk05
		WEND
		PRINT : PRINT "Error. END! (End of Files Marker) not found inside " + xOut$ + " ARK file!": INPUT ccc$
		GOTO DEARKxferEnd
DeArk05: 
		T=Len(xPath$)+10
		PRINT "ARK file. ";TAB (T+15);  " Sectors-Records"
		' Search Filename in SubArkFile
		WHILE NOT EOF(8)
		ArkRecord = ArkRecord + 1
		GET #8, ArkRecord
		FdrRek$= Dat$
		
		FOR xaT = 1 TO 14 * 18 STEP 18
		TFS% = CalcWord(FdrRek$, xaT + 12)
		OTFS%=TFS%
		EOFOff% = ASC(MID$(FdrRek$, xaT+15, 1))
		NewOut$=MID$(FdrRek$, xaT, 10)
		LogRecLength% = ASC(MID$(FdrRek$, xaT+15, 1))
		IF NewOut$ = Zero10$ THEN GOTO DEARKxferEnd
		FileType% = ASC(MID$(FdrRek$, xaT + 10, 1))
		FileType% = FileType% AND &H8B        ' Get rid of reserved bits: 2,4-6
		FileType% = FileType% AND &HF7        ' Get rid of bit: 3
		
		GOSUB DeArkThis
		Sectors2Skip = Sectors2Skip + TFS%
		NEXT xaT
		IF MID$(FdrRek$, xaT, 253) ="END!" THEN GOTO DEARKxferEnd
		WEND
		
DEARKxferEnd:   TotFiles2Copy%=TotFiles2Copy%-1 ' Adjust count
		CLOSE #8
		RETURN

DeArkThis:      ' Make sure to Delete the temp file, if any
		CALL ReplaceChars(NewOut$, NewOut$)'Replace MSDOS illegal characters
		OPEN xPath$+NewOut$ FOR BINARY ACCESS WRITE AS #2
		CLOSE #2
		KILL xPath$+NewOut$
		
		OPEN xPath$+NewOut$ FOR BINARY ACCESS WRITE AS #2
		BytePos& = 1 : EOFOffset% = 255: Trecs& = 0
		SELECT CASE FileType%
		CASE 0
		FileType$ = "Dis/Fix"
		GOSUB xDisFix
		
		CASE 1
		FileType$ = "Program"
		GOSUB xProgram
		CASE 2
		FileType$ = "Int/Fix"
		GOSUB xDisFix
		'Int/Fix is handled as Dis/Fix
		CASE 128
		FileType$ = "Dis/Var"
		GOSUB xDisVar
		CASE 130
		FileType$ = "Int/Var"
		GOSUB xIntVar                   ' 5.5.2001 = Int/Var is now handled as Int/Var!
		CASE ELSE
		FileType$ = "unknown"
		GOSUB xProgram                  ' unknown is handled as Program
		END SELECT
		
		CLOSE #2
		PRINT xPath$;NewOut$;" - ";FileType$;
		
		IF  FileType%<>1 THEN PRINT Normalize$(LogRecLength%,4); ELSE PRINT "    ";
		PRINT " - "; Normalize$(OTFS%,6);
		T%=Trecs&
		IF  FileType%<>1 THEN  PRINT  Normalize$(T%,6)ELSE PRINT
		TotFiles2Copy%=TotFiles2Copy%+1
		TotSizeFiles2Copy#=TotSizeFiles2Copy#+OTFS%
		RETURN

' DIS-FIX *****************
xDisFix:
		TotRecs& = ASC(MID$(FdrRek$,xaT+ 17, 1)) * 256 + ASC(MID$(FdrRek$, xaT+16, 1))
		RecsInSect% = ASC(MID$(FdrRek$, xaT+11, 1))
		
		IF LogRecLength% <> 128 THEN GOTO xDisFix2
		IF TFS% * 2 <= TotRecs& THEN GOTO xDisFix2
		TotRecs& = TotRecs& + 256
		
xDisFix2:       WHILE 0<TFS% 
		GOSUB GetSect
		GOSUB xToDF
		IF TotRecs& < 1 THEN GOTO xToDFEnd
		WEND
xDisFixEnd:     RETURN 

' "PROGRAM" ******************
xProgram:       WHILE 1<TFS% 
		GOSUB GetSect
		PUT #2,BytePos&, Dat$ : BytePos& = BytePos& + 256
		WEND
		GOSUB GetSect
		DVRec$= MID$(Dat$, 1, EOFOff% ) ' On last sector, save only wht's necessary
		PUT #2,BytePos&, DVRec$
		RETURN


' DIS/VAR ********************
xDisVar:        WHILE 0<TFS% 
		IF TFS%=1 THEN EOFOffset%= EOFOff% : IF EOFOffset% = 0 THEN EOFOffset% = 256
		GOSUB GetSect
		GOSUB xToDV
		WEND
		RETURN
		

' "INT-VAR" ******************
xIntVar:        
		WHILE 0<TFS%
		IF TFS%=1 THEN  EOFOffset%= EOFOff% : IF EOFOffset% = 0 THEN EOFOffset% = 256
		GOSUB GetSect
		GOSUB xToIV
		WEND
		RETURN

' Transfer a Dis/Var record (Text)
xToDV:          ROff% = 1

xToDVAg:        RLen% = ASC(MID$(Dat$, ROff%, 1))
		IF RLen% = 255 THEN GOTO xToDVEnd:
		ROff% = ROff% + 1
		DVRec$ = MID$(Dat$, ROff%, RLen%)+CRLFeed$
		PUT #2,BytePos&, DVRec$ : BytePos& = BytePos& + RLen% +2
		Trecs& = Trecs& + 1
		ROff% = ROff% + RLen%
		IF ROff% < EOFOffset% THEN GOTO xToDVAg
xToDVEnd:       RETURN

' Transfer a Int/Var record
xToIV:          ROff% = 1

xToIVAg:        RLen% = ASC(MID$(Dat$, ROff%, 1))
		IF RLen% = 255 THEN GOTO xToIVEnd:
		DVRec$ = MID$(Dat$, ROff%, RLen%+1)
		ROff% = ROff% + 1
		PUT #2,BytePos&, DVRec$ : BytePos& = BytePos& + LEN(DVRec$)
		Trecs& = Trecs& + 1
		ROff% = ROff% + RLen%
		IF ROff% < EOFOffset% THEN GOTO xToIVAg
xToIVEnd:       RETURN

' Transfer a DIS/FIX record 
xToDF:          ROff% = 1
		
		FOR RT% = 1 TO RecsInSect%
		DFRec$ = MID$(Dat$, ROff%, LogRecLength%)
		PUT #2, BytePos&, DFRec$: BytePos& = BytePos& + LogRecLength%
		ROff% = ROff% + LogRecLength%
		TotRecs& = TotRecs& - 1
		Trecs& = Trecs& + 1
		IF TotRecs& < 1 THEN GOTO xToDFEnd
		NEXT RT%
xToDFEnd:       RETURN

' Get a sector from the opened TempArk$ file (contains unarked ARK file)
GetSect:        StartData& = StartData&  + 1
		Get #8, StartData&
		TFS% =TFS% -1
		RETURN


'=============================
' ARK FILE FILE TRANSFER
'=============================

ARKFILESxfer:   PRINT " <- "; MID$(FilName$(FileToCopy%), 1, 10)
		IF ARKFL$ <> "" THEN GOTO ARKFxfer2
		ARKFL$ = FOut$
		OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #8
		CLOSE #8
		KILL Path$ + FOut$
		
		OPEN Path$ + FOut$ FOR BINARY ACCESS WRITE AS #8
		' 14 Files/sector
		' ARKSect%=INT(ARKTot%/14)+1 'Total sector needed to contain all the Filenames for this ARK file
		T = INT(ARKTot% / 14)
		IF ARKTot% MOD 14 > 0 THEN T = T + 1
		ARKHeader$ = STRING$(256 * T, CHR$(0))
		MID$(ARKHeader$, LEN(ARKHeader$) - 3) = "END!"
		PUT #8, 1, ARKHeader$
		ARKBytPos& = LEN(ARKHeader$) + 1
		HeaderPos% = 1
		
ARKFxfer2:      Z = 0: Tog% = 1
		Suspend$ = ""
		A$ = MID$(FHeader$, 1, 10)     ' Filename
		A$ = A$ + MID$(FHeader$, 13, 1)' Byte  13    (byte 1=first) = FileType
		A$ = A$ + MID$(FHeader$, 14, 1)' Byte  14    (byte 1=first) = Max. numb. of records/sector or AU
		A$ = A$ + MID$(FHeader$, 15, 2)' Bytes 15,16 (byte 1=first) = Filelength, reversed bytes
		A$ = A$ + MID$(FHeader$, 17, 1)' Byte  17    (byte 1=first) = End of file Offset
		A$ = A$ + MID$(FHeader$, 18, 1)' Byte  18    (byte 1=first) = Logical record Length
		A$ = A$ + MID$(FHeader$, 19, 2)' Bytes 19,20 (byte 1=first) = Number of Fixed Length Record -OR- Number of Sectors used by variable Length Records
		
		PUT #8, HeaderPos%, A$: HeaderPos% = HeaderPos% + 18
		ARKCount% = ARKCount% + 1: IF ARKCount% MOD 14 = 0 THEN HeaderPos% = HeaderPos% + 4
		
ARKNextClusterTIF:
		GOSUB CalcClusters
		IF StSec% = 0 THEN GOTO ARKEOThisFileTIF
		IF Suspend$ <> "" THEN Suspend$ = "": PUT #8, ARKBytPos&, d$: ARKBytPos& = ARKBytPos& + 256
		
ARKNextOffsValTIF:
		IF GlobalInpOffset% > Offs% - 1 THEN Z = Z + 3: GOTO ARKLastClusterTIF
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		PUT #8, ARKBytPos&, d$: ARKBytPos& = ARKBytPos& + 256
		
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO ARKNextOffsValTIF

ARKLastClusterTIF:
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)
		Suspend$ = "Y"
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO ARKNextClusterTIF
		
ARKEOThisFileTIF:
		
		PUT #8, ARKBytPos&, d$: ARKBytPos& = ARKBytPos& + 256
		RETURN
		

'===============================================
' CALCULATE CURRENT ENTRY IN CHAIN POINTER TABLE
'===============================================
' The second 3 nibble block contains the highest OFFSET within each Chain Block.
' This value must never be higher than SectorCnt% - 1, which is the file total length - 2,
' as it appears on Disk Catalog.
' This corrects the bug on 80 track disks, that have the last second 3 nibble block wrong on
' ODD LENGTH FILES (1 sector longer).
' If not corrected, this bug would create an error on lower size disks.

CalcClusters:	IF Z > 227 THEN StSec% = 0 : GOTO CalcClustend  	' PB 2004.06.05 - Handle FDR Error (BABA) -    
		A = ASC(MID$(FHeader$, 28 + 1 + Z, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z, 1))
		BA% = B MOD 16
		BB% = INT(B / 16)
		StSec% = BA% * 256 + A
		IF TotSect% > 3000 THEN StSec% = StSec% * 4
		Offs% = C * 16 + BB
		IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		OffsVal% = 0               ' Offset in EACH Input  File Chain Pointer Block
		
		GOTO CalcClustend       ' Skip the below check, which has been superseeded by the simpler
		' above approach:  IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		' Nonetheless, I leave it where it is because it might be still needed for some
		' 80 track disks that have a wrong file length, besides having
		' a wrong chain point table length.
		
' 
' Special case: in a 80 track Double Side Disk, when file length is EVEN (SectorLength# in my code), the
' Chain Point Table reports 1 sector more than what it should. When copying, we have to use avoid using
' that extra sector. Method: always check if there is a next Data Chain. If there is, do nothing. Otherwise,
' that means we are are the end of the Data Chain, and we have to use a sector less.
' SectorLength#

		
		IF Dens% < 2 OR Tracks < 80 THEN GOTO CalcClustend
		IF SectorLength# <> (INT(SectorLength# / 2)) * 2 THEN GOTO CalcClustend
		A = ASC(MID$(FHeader$, 28 + 1 + Z + 3, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z + 3, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z + 3, 1))
		IF A <> 0 OR B <> 0 OR C <> 0 THEN GOTO CalcClustend
		Offs% = Offs% - 1
CalcClustend:
		
		RETURN
'=================================
' DISPLAY TOP PART OF TITLE SCREEN
'=================================
TopScreen:      
		LOCATE 1, 3, 1
		LOCATE 1, 3, 1
		PRINT "EXTRACT (TO DOS OR ARK FILE) SINGLE TI-FILES FROM TI99-PC DISK IMAGE FILE"
		LOCATE 2, 1
		PRINT "TI-99/4A DiskName:"; DskName$; "    Sectors:"; TotSect%; " Tracks:"; Tracks%; " Sides:"; Sides%; " Dens:"; Dens%;
		LOCATE 3, 1
		PRINT "PC Source File= "; SourcePath$;
		PRINT TAB(57); "Files="; TFNames%;
		PRINT TAB(70); " "; SideDensity$
		LOCATE 4, 1
		PRINT "Bad Sect:"; TotEr%; TAB(17); "Used Sectors:"; TAB(38); "Selected files n."; TAB(62); "sectors:"; TAB(78); "  ";
		LOCATE 4, 30
		PRINT TotSectorFiles#
		GOSUB DispFilestoCopy
		LOCATE 5, 1
		PRINT "Ŀ"
		PRINT "  n. Filename  P TSect Length  Type           Output filename              "
		PRINT "Ĵ"
		IF TotEr% = 0 THEN GOTO IfSomeFileName
'=====> SUBDIRECTORIES (TWO LINE) - CHANGED CODE
		LOCATE 6, 46
		PRINT "Err";
		
IfSomeFileName: LOCATE 22, 1
		PRINT "C,M=copy. Enter=Go. T=TIFILES. Blank,Del=Cancel. Move=Up,Down,PageUp,PageDown.";
		LOCATE 23, 1
		PRINT " CTRL A,T=copy,TIFILES All. CTRL U=Del All. Home,End=Top,Bottm Row. K=Create ARK";
		LOCATE 24, 1
		PRINT "file. CTRL K= All Arkfiles. X=Xtract ARK to Dir. F8= Cat ARK File. F1=Help.";
		'123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
		RETURN
		
		
'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRow:
		LOCATE StartRow% + CurrentScreenRow%, 1, 1
		PRINT ""; CopyMark$(CurrentFilename%); "";
		PRINT USING "###"; CurrentFilename%;
		PRINT ""; MID$(FilName$(CurrentFilename%), 1, 10);
		
		IF MID$(FilName$(CurrentFilename%), 1, 10)=STRING$(10,CHR$(&HBA)) THEN GOTO BadSectorList '' PB 2004.06.05 - Handle FDR Error (BABA) - 		
		IF CurrentFilename% > ActiveDirs% THEN GOTO NoSubDirs
		IF CurrentFilename% = ChosenDir% THEN PRINT TAB(19); "< Active Dir >";
		PRINT TAB(34); ".. <Dir>.."; TAB(49); ""; TAB(80); "";
		GOTO DisplayRowEnd
NoSubDirs:
		
		FileType% = ASC(MID$(FilName$(CurrentFilename%), 13, 1))
		IF FileType% AND 8 THEN FileProt$ = "P" ELSE FileProt$ = "_"
		FileType% = FileType% AND &H8B         ' Get rid of reserved bits: 2,4-6
		
		FileType% = FileType% AND &HF7

		SELECT CASE FileType%
		CASE 0
		FileType$ = "Dis/Fix"
		CASE 1
		FileType$ = "Program"
		CASE 2
		FileType$ = "Int/Fix"
		CASE 128
		FileType$ = "Dis/Var"
		CASE 130
		FileType$ = "Int/Var"
		CASE ELSE
		FileType$ = "unknown"
		END SELECT

		GOSUB SectorLength
		' ASC(MID$(FilName$(CurrentFilename%), 15, 1)) * 256 + ASC(MID$(FilName$(CurrentFilename%), 16, 1)) + 1
		EOFOffset% = ASC(MID$(FilName$(CurrentFilename%), 17, 1))

		FileLength# = SectorLength# - 1
		FileLength# = FileLength# * 256
		IF FileType% < 128 THEN FileLength# = FileLength# - 256 + EOFOffset%
		LogRecLength% = ASC(MID$(FilName$(CurrentFilename%), 18, 1))
		
		' PRINT EOFOffset%;
		PRINT " "; FileProt$;
		PRINT USING "####"; SectorLength#;
		PRINT USING "#########"; FileLength#;
		PRINT " "; FileType$;
		IF LogRecLength% > 0 THEN PRINT USING "####"; LogRecLength%;
		
BadSectorList:
		IF FileErrList$(CurrentFilename%) = "" THEN GOTO NoErrSectInFile
		LOCATE StartRow% + CurrentScreenRow%, , 1

		PRINT TAB(46); "F3";
		'FOR J = 1 TO LEN(FileErrList$(CurrentFilename%)) STEP 2
		'IF J > 8 THEN PRINT ",..."; : GOTO NoErrSectInFile
		'K = CalcWord(FileErrList$(CurrentFilename%), J)
		'IF J > 1 THEN PRINT ",";
		'PRINT RTRIM$(LTRIM$(STR$(K)));
		'NEXT J
NoErrSectInFile:
		PRINT TAB(49); "";
		IF CopyMark$(CurrentFilename%) <> " " THEN PRINT TAB(52); OutFilName$(CurrentFilename%);
		PRINT TAB(80); "";
DisplayRowEnd:  RETURN

'====================
' DISPLAY BOTTOM LINE
'====================
BottomLine:
		PRINT
		PRINT ""
		
		LOCATE StartRow% + CurrentScreenRow% + 1, 1, 1

		IF CurrentScreenRow% > TotalScreenRows% THEN GOTO SkipClear ' Blank all unused screen rows, if any

		FOR V = CurrentScreenRow% TO TotalScreenRows%
		PRINT "                                                                                "
		NEXT V
SkipClear:      RETURN

'=========================
' REDRAW THE ENTIRE SCREEN
'=========================
RePaintScreen:

		GOSUB TopScreen ' Display Top Part of Title Screen
		SaveCurrFilename% = CurrentFilename%
		SavCurrScreenRow% = CurrentScreenRow%
		CurrentFilename% = FirstFilename%
		FOR CurrentScreenRow% = 1 TO TotalScreenRows%
		GOSUB DisplayRow  ' Display Current Row
		CurrentFilename% = CurrentFilename% + 1 ' Next Filename
		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		IF CurrentFilename% > TFNames% THEN CurrentScreenRow% = CurrentScreenRow% + 1: GOTO RePaintScreen2
		NEXT CurrentScreenRow%   ' Next Screen Row
RePaintScreen2:  
		GOSUB BottomLine        ' Display Bottom Line
		CurrentFilename% = SaveCurrFilename%
		CurrentScreenRow% = SavCurrScreenRow%
		RETURN


RestoreColor:   TempScreenRow% = CurrentScreenRow%
		TempFilename% = CurrentFilename%
		CurrentScreenRow% = OldScreenRow%
		CurrentFilename% = OldFilename%
		COLOR 7, 0: GOSUB DisplayRow ' Display Current Row
		CurrentScreenRow% = TempScreenRow%
		CurrentFilename% = TempFilename%
		RETURN

DispFilestoCopy: ' Display total files to be copied
		LOCATE 4, 55, 1
		PRINT TotFiles2Copy%; "  ";
		LOCATE 4, 70, 1
		PRINT TotSizeFiles2Copy#; "   ";
		RETURN
		
SectorLength:   ' Calculate file length, in sectors
		SectorLength# = CalcWord(FilName$(CurrentFilename%), 15) + 1
		RETURN
		' My Little Debugger
ShowValues:
		CCursR = CSRLIN
		CCursC = POS(0)
		LOCATE 6, 55
		PRINT FirstFilename%; CurrentFilename%; LastFilename%; "   "
		LOCATE CCursR, CCursC

		RETURN
'=====================================
' GO TO THAT LINE
' ====================================        
GoToThatLine:   
		GOSUB RestoreColor
		COLOR 7, 0
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7
		GOSUB DisplayRow:
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		OldScreenRow% = CurrentScreenRow%
		OldFilename% = CurrentFilename%
		
		RETURN
'===========================
' AVOID DUPLICATED FILENAMES
' ==========================          
AvoidDupNames:
		FOR KK% = ActiveDirs% + 1 TO TFNames%
		IF KK% = UF% THEN GOTO AvoidDupNamesb
		' IF CopyMark$(KK%) = "C" THEN GOTO AvoidDupNamesb
		IF CopyMark$(KK%) = " " THEN GOTO AvoidDupNamesb
		IF OutFilName$(UF%) <> OutFilName$(KK%) THEN GOTO AvoidDupNamesb
		CALL IncName(OutFilName$(UF%), B$): IF B$ = "" THEN GOTO AvoidDupNames
		
		GOSUB RestoreColor
		COLOR 7, 0
		CurrentFilename% = UF%
		CurrentScreenRow% = 2     ' Cursor on second screen row
		FirstFilename% = UF% - 1: IF FirstFilename% <= ActiveDirs% + 1 THEN FirstFilename% = UF%: CurrentScreenRow% = 1
		'CLS
		GOSUB RePaintScreen

		COLOR 0, 7
		GOSUB DisplayRow
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		OldScreenRow% = CurrentScreenRow%
		BEEP
		LOCATE StartRow% + CurrentScreenRow%, 68, 1: PRINT "Dupl."; FirstFilename%;
		WHILE INKEY$ = "": WEND
		OutFilName$(CurrentFilename%) = RTRIM$(Xinput$(StartRow% + CurrentScreenRow%, 52, 25, OutFilName$(CurrentFilename%), Allowed$, Endk$, Exitk$, RealStrLen%))
		GOSUB RestoreColor
		COLOR 7, 0
AvoidDupNamesb: NEXT KK%
		RETURN
		
'=====================================
' Work out which file has a bad sector
' ====================================
WorkOutWhichFile:
		K$=STRING$(256,&HBA)			' PB 2004.06.05 - Handle FDR Error (BABA) - 
		FOR FileToCopy% = 1 TO TFNames%
		'GET #1, StartSect%(FileToCopy%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(FileToCopy%) + 1, d$)
		FHeader$ = d$
		IF FHeader$=K$ THEN K = StartSect%(FileToCopy%) : GOSUB MarkErrFileIF : GOTO WorkOutNext ' PB 2004.06.05 - Handle FDR Error (BABA) - 
		SectorCnt% = CalcWord(FHeader$, 15)
		OldOffs% = 0
		Z = 0
		
NextChain:	IF Z > 227 THEN K = StartSect%(FileToCopy%) : GOSUB MarkErrFileIF : GOTO WorkOutNext ' PB 2004.06.05 - Handle FDR Error (BABA) - 
		GOSUB CalcClusters
		CurrOffs% = Offs% - OldOffs%
		IF StSec% = 0 THEN GOTO WorkOutNext
		IF K >= StSec% AND K <= StSec% + CurrOffs% THEN GOSUB MarkErrFile: GOTO WorkOutEnd
		OldOffs% = Offs%
		Z = Z + 3: GOTO NextChain
WorkOutNext:
		NEXT FileToCopy%
WorkOutEnd:
		RETURN
		
' Mark File containing Error: To save memory, a couple of bytes (CHR$) each bad sector
MarkErrFile:
		MSB% = INT(K / 256)
		LSB% = K MOD 256
		FileErrList$(FileToCopy%) = FileErrList$(FileToCopy%) + CHR$(MSB%) + CHR$(LSB%)
		' PRINT MID$(FilName$(FileToCopy%), 1, 10)
		'INPUT C$
		RETURN
		
' Mark File containing Error in FDR	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
MarkErrFileIF:				' PB 2004.06.05 - Handle FDR Error (BABA) - 
		MSB% = INT(K / 256)	' PB 2004.06.05 - Handle FDR Error (BABA) - 
		LSB% = K MOD 256	' PB 2004.06.05 - Handle FDR Error (BABA) - 
		A$=CHR$(MSB%) + CHR$(LSB%)	' PB 2004.06.05 - Handle FDR Error (BABA) - 
		IF LEN(FileErrList$(FileToCopy%))>0 AND RIGHT$(FileErrList$(FileToCopy%),2)=A$ THEN GOTO MarkErrFileIF2 ' PB 2004.06.05 - Handle FDR Error (BABA) - 
		FileErrList$(FileToCopy%)= FileErrList$(FileToCopy%)+ A$	' PB 2004.06.05 - Handle FDR Error (BABA) - 
MarkErrFileIF2:	RETURN			' PB 2004.06.05 - Handle FDR Error (BABA) - 
		
		
'========SHOW SECTORS - ADD START           
ShowSector:     CALL box(8, 3, 76, 13)
		LOCATE 8, 30: COLOR 0, 7: PRINT " - HEX SECTOR VIEWER - "; : COLOR 7, 0
		'GET #1, StartSect%(CurrentFilename%) + 1
		CALL GetVirtualSect(FileNum%,StartSect%(CurrentFilename%) + 1, d$)
		FHeader$ = d$
		SectorCnt% = CalcWord(FHeader$, 15)		' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		LOCATE 9, 5:  PRINT "File: "; MID$(FHeader$, 1, 10); "-Length:"; SectorCnt%; ' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		IF SectorCnt% = -1 THEN GOTO ShowSectorEnd	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		Z = 0                      ' Offset in Input File Chain Pointer Block
		K$ = "Y"
ShowSector2:
		GOSUB CalcClusters
		IF StSec% > 0 THEN GOTO ShowSector3
		LOCATE 19, 30: PRINT " = End of File =";
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		IF K$ = CHR$(27) THEN GOTO ShowSectorEnd
		
ShowSector3:
		IF GlobalInpOffset% > Offs% THEN Z = Z + 3: GOTO ShowSector2
		'GET #1, StSec% + OffsVal% + 1
		CALL GetVirtualSect(FileNum%,StSec% + OffsVal% + 1, d$)

		LOCATE 9, 35: PRINT " -This Skt: "; StSec% + OffsVal%; " >"; HEX$(StSec% + OffsVal%); " - Skt Off.:"; GlobalInpOffset%;

		CALL ShowHex(d$, K$)
		IF K$ = CHR$(27) THEN GOTO ShowSectorEnd
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO ShowSector4
		IF GlobalInpOffset% > 0 THEN K$ = ""
		IF GlobalInpOffset% = 0 THEN GOTO ShowSector3
		GlobalInpOffset% = GlobalInpOffset% - 1
		OffsVal% = OffsVal% - 1
		IF OffsVal% < 0 THEN Z = Z - 3: GOTO ShowSector2
		GOTO ShowSector3
ShowSector4:               
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO ShowSector3
		
ShowSectorEnd:     
		RETURN
'========SHOW SECTORS - ADD END      

UnselectAll:        
		FOR T = ActiveDirs% + 1 TO TFNames%  ' Assume user wants to Copy all files
		CopyMark$(T) = " "
		ARKTot% = 0
		NEXT T
		
		
		TotFiles2Copy% = 0
		TotSizeFiles2Copy# = 0
		GOSUB RePaintScreen
		RETURN 
	
		
ShowErrorList:

'=====> SUBDIRECTORIES (ONE LINE) - DELETED CODE
		
		CALL box(8, 20, 50, 13)
		LOCATE 9, 30: PRINT "Bad Sector List, File:"; MID$(FilName$(CurrentFilename%), 1, 10)
		LOCATE 11 + W, 22: PRINT ""
		W = 0: A = 0
		LOCATE 11 + W, 22
		
		FOR J = 1 TO LEN(FileErrList$(CurrentFilename%)) STEP 2
		IF W > 8 THEN PRINT "..."; : GOTO ShowErrorList2
		K = CalcWord(FileErrList$(CurrentFilename%), J)
		IF A > 0 THEN PRINT ",";
		PRINT RTRIM$(LTRIM$(STR$(K)));
		A = A + 1
		IF A > 8 THEN A = 0: W = W + 1: LOCATE 11 + W, 22
		NEXT J
ShowErrorList2:
		WHILE INKEY$ = "": WEND
		
NoShowErrorList:
		RETURN

'=====> SUBDIRECTORIES (START LINE) - ADDED CODE  
GiveUpCopying:
		CALL ERRSOUND
		CALL box(8, 20, 55, 13)
		LOCATE 9, 40: PRINT "WARNING";
		LOCATE 11, 22: PRINT "You have chosen to change current directory:"; ' ChosenDir%; ' TotSizeFiles2Copy# = 0
		LOCATE 12, 40: PRINT UCASE$(SubDirName$(ChosenDir%))
		LOCATE 13, 22: PRINT "There are"; TotFiles2Copy%; "files you have already selected ";
		LOCATE 14, 22: PRINT "in this directory that will not be copied if you "
		LOCATE 15, 22: PRINT "change directory.";
		LOCATE 17, 22: PRINT " Proceed anyway? Y/N ";
		
		
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		K$ = UCASE$(K$)
		RETURN
'=====> SUBDIRECTORIES (END LINE) - ADDED CODE




AbsNoFiles:
		PRINT ""
		A = 10
		CALL box(A, 18, 50, 8)
		LOCATE A + 2, 24: PRINT "THIS DISK, "; SourcePath$; " IS EMPTY. "
		LOCATE A + 3, 24: PRINT ""
		LOCATE A + 4, 30: PRINT "No files have been found."
		LOCATE A + 5, 32: PRINT "Press any key to exit"

		WHILE INKEY$ = "": WEND
		

		RETURN

DEFSNG A-Z
'================================
' ADD .ARK TO A FILENAME
'================================
SUB ARKName (A$)
		A$ = RTRIM$(A$)
		P = INSTR(A$, ".")
		IF P > 0 AND P <= 9 THEN A$ = LEFT$(A$, P - 1): GOTO ARKName2 ELSE IF P > 0 AND P > 9 THEN A$ = LEFT$(A$, 8): GOTO ARKName2
		IF LEN(A$) > 8 THEN A$ = LEFT$(A$, 8)
		
ARKName2:       A$ = A$ + ".ARK"
		
END SUB

DEFINT A-Z
SUB box (Y, X, W, H)

		' Call Box(StartRow, StartColumn, Width, Hight)
		' Y=StartRow,X=StartColumn; W=Width,H=Hight)
		LOCATE Y, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";
		
		FOR V = 1 TO H - 2
		LOCATE Y + V, X
		PRINT ""; TAB(X + W - 1); : PRINT "";
		NEXT V

		LOCATE Y + H - 1, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";


END SUB

DEFSNG A-Z
FUNCTION CalcWord (A$, P%)
		IF LEN(A$) < P% + 1 THEN  GOTO CalcWord1	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		B1& = ASC(MID$(A$, P%, 1))			' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		B2& = ASC(MID$(A$, P% + 1, 1))			' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		V& = (B1& * 256) + B2&				' PB 2004.06.05 - Handle FDR Error (BABA) - 	
		IF V&< 32768 THEN GOTO CalcWord2		' PB 2004.06.05 - Handle FDR Error (BABA) - 	
CalcWord1:	V& = -1					 	' PB 2004.06.05 - Handle FDR Error (BABA) - 	
CalcWord2:      CalcWord = (V&)					' PB 2004.06.05 - Handle FDR Error (BABA) - 	
END FUNCTION

DEFINT A-Z
SUB ERRSOUND
		SOUND 110, 4

END SUB

SUB Fischio
		IF MyVal(1) = 0 THEN EXIT SUB
		FOR i% = 3000 TO 4000 STEP 200
		SOUND i%, .1  'i% / 1000
		NEXT i%

END SUB

DEFSNG A-Z
'=====================================================
' INCREMENT A  FILENAME, TO AVOID DUPLICATED FILENAMES
'=====================================================
SUB IncName (A$, B$)
		A$ = RTRIM$(A$)
		P = INSTR(A$, ".")
		IF P > 0 THEN P = P - 1 ELSE P = LEN(A$) - 1
		C = ASC(UCASE$(MID$(A$, P, 1)))
		IF C = ASC("9") THEN C = ASC("A"): GOTO IncName6
		IF C >= ASC("0") AND C <= ASC("9") THEN C = C + 1: GOTO IncName6
		IF C = ASC("Z") THEN C = ASC("_"): GOTO IncName6
		IF C >= ASC("A") AND C <= ASC("Z") THEN C = C + 1: GOTO IncName6
		Replace$ = "_-#@`^~{}"
		P2 = INSTR(Replace$, CHR$(C))
		IF P2 = LEN(Replace$) THEN B$ = "X": GOTO IncName7
		C = ASC(MID$(Replace$, P2 + 1, 1))

IncName6:       MID$(A$, P, 1) = CHR$(C): B$ = ""

IncName7:    
END SUB

'=================================
' Replace MSDOS illegal characters   
'=================================
SUB ReplaceChars (In$, Out$)

		Out$ = MID$(In$, 1, 10)
		NotAllowed$ = "=*\/,;:.><|[]+" + CHR$(34)
                Replacement$ = "_-_-#@_`^~-{}@'"
		FOR T = 1 TO LEN(NotAllowed$)
		T$ = MID$(NotAllowed$, T, 1)
LoopMore:       P = INSTR(1, Out$, T$): IF P > 0 THEN MID$(Out$, P) = MID$(Replacement$, T, 1): GOTO LoopMore
		NEXT T
END SUB

DEFINT A-Z
SUB ShortName (A$)
' Get short filename (8.3 characters)
		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT7160.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO ShortName2
		LINE INPUT #71, A$
ShortName2:     CLOSE #71
		KILL "--"
END SUB


SUB CreateShortName (A$,B$)
' Get short filename (8.3 characters). If it fails, create that file with
' Long Filename, then return the corresponding  short filename. 
' If file has been created, a second record, containing the string "CR!"
' will be returned too. 
' If wrong path, no filename is returned.

		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT716C.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO CrShName2
		LINE INPUT #71, A$
		B$=""
		IF EOF(71) <> 0 THEN GOTO CrShName2
		LINE INPUT #71, B$
CrShName2:      CLOSE #71
		KILL "--"

END SUB

SUB ShowHex (A$, K$)
' This is simply to help during debugging
' Syntax: CALL ShowHex(A$,K$) ' A$ usually contains an entire TI Sector (256 bytes)
		Col% = 3
		B$ = ""
		FOR T = 1 TO LEN(A$)
		C$ = HEX$(ASC(MID$(A$, T, 1))): IF LEN(C$) = 1 THEN C$ = "0" + C$
		B$ = B$ + C$ + " "
		NEXT T
		
		LOCATE 10, Col% + 2
		PRINT "Addr. 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ";
		
		IF K$ = "" THEN T = LEN(B$) - (8 * 16 * 3 - 1) ELSE T = 1
'===============LOOP STARTS HERE
		
Repeat: 
		T$ = MID$(B$, T, 16 * 3)
		LOCATE 10 + 1 + Row%, Col% + 2:
		H$ = HEX$(T / 3): IF LEN(H$) = 1 THEN H$ = "0" + H$
		PRINT USING "\  \"; H$;
		LOCATE 10 + 1 + Row%, Col% + 5
		PRINT " - "; T$;
		PRINT "  ";
		FOR J = 1 TO 16
		J$ = MID$(A$, (T - 1) / 3 + J, 1)
		IF ASC(J$) < 32 OR ASC(J$) > 126 THEN PRINT " ";  ELSE PRINT J$;
		
		NEXT J
		
		Row% = Row% + 1: IF Row% < 8 THEN GOTO NextRow ELSE Row% = 0
		'locate 21,1: print len(B$)
		'locate 22,1: print t
		'locate 23,1: print (t-1)/(3*16)
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO GEXIT
		
		' Arrow Down
		IF K$ <> CHR$(0) + CHR$(80) THEN GOTO ArrowUPkey
		T = T - (16 * 3 * 6): IF T < 1 THEN T = 1
		GOTO Repeat
		
ArrowUPkey:      ' Arrow UP
		IF K$ <> CHR$(0) + CHR$(72) AND K$ <> CHR$(0) + CHR$(73) THEN GOTO NextRow
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO PageUPKey
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 8): IF T < 1 THEN T = 1
		GOTO Repeat
PageUPKey:          
		' Page UP
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 15): IF T < 1 THEN T = 1
		GOTO Repeat

NextRow:
		T = T + (16 * 3)
		IF T < LEN(B$) THEN GOTO Repeat
		K$ = "Y"
'===============LOOP ENDS HERE
GEXIT:
END SUB

SUB TellPathFrom (Full$, Path$, File$)
' Tell Path from File
		FOR T = LEN(Full$) TO 1 STEP -1
		IF MID$(Full$, T, 1) = "\" THEN GOTO TPath1
		NEXT T
		Path$ = "": File$ = Full$
		P = INSTR(File$, ":"): IF P > 0 THEN Path$ = LEFT$(Full$, P): File$ = RIGHT$(Full$, LEN(Full$) - P)
		GOTO TPath2

TPath1:         Path$ = LEFT$(Full$, T): File$ = RIGHT$(Full$, LEN(Full$) - T)
TPath2:
END SUB

DEFSNG A-Z
'================================
' ADD .TIG TO A FILENAME
'================================
SUB TIGName (A$)
		A$ = RTRIM$(A$)
		P = INSTR(A$, ".")
		IF P > 0 AND P <= 9 THEN A$ = LEFT$(A$, P - 1): GOTO TIGName2 ELSE IF P > 0 AND P > 9 THEN A$ = LEFT$(A$, 8): GOTO TIGName2
		IF LEN(A$) > 8 THEN A$ = LEFT$(A$, 8)
		
TIGName2:       A$ = A$ + ".TIG"
		
END SUB

SUB ThisHelp(Banner$, DatFile$, IDXFile$, Argum$)
		GOTO GetHelp

' Because of MS QBasic quirks, GetIDX routine has to be placed before the rest of the code.

' Get .IDX file values into an array, that is, 
' Get Array Parameters from Index (IDX) file
GetIDX:         
		OPEN IDXFile$ FOR RANDOM ACCESS READ AS #3 LEN = LEN(IDXRecord)
		GET #3, , IDXRecord
		TLines% = IDXRecord.StartRec' First record is special: total records that follow
		
		
		REDIM IDXSect$(TLines%)
		REDIM IdxStart(TLines%)
		REDIM IdxLength(TLines%)
		FOR t = 1 TO TLines%
		GET #3, , IDXRecord
		IDXSect$(t) = LTRIM$(IDXRecord.Section)
		IdxStart(t) = IDXRecord.StartRec
		IdxLength(t) = IDXRecord.RecLength
		IDXSect$(t) = LTRIM$(RTRIM$(IDXSect$(t)))
		NEXT t
		CLOSE #3
		
		RETURN
		

		

GetHelp:        CLS
		LOCATE 1, 26: PRINT Banner$
		InizRw% = 2
		TotScrRws% = 12
		CurrScrRw% = 1
		
		GOSUB RedrawBox
		GOSUB GetIDX
		FOR Arg% = 1 TO TLines%
		IF Argum$ = IDXSect$(Arg%) THEN GOTO ArgFnd
		NEXT Arg%
		Arg% = 1
		
ArgFnd:         CurntLine% = Arg%
		RcLen% = 77 + 2
		OPEN DatFile$ FOR RANDOM ACCESS READ AS #59 LEN = RcLen%
		FIELD #59, RcLen% - 2 AS DL$
		FIELD #59, 2 AS CRLF$
		
'===================================
' MAIN LOOP STARTS HERE
'===================================       
NextLineName:
		COLOR 7, 0
		
		IF CurrScrRw% = 1 THEN FstLine% = CurntLine%   ' Get Number of first Line only
		GOSUB DisplayRw
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		CurrScrRw% = CurrScrRw% + 1  ' Next Screen Row
		IF CurrScrRw% < TotScrRws% + 1 AND CurntLine% <= TLines% THEN GOTO NextLineName
'===================================
' MAIN LOOP ENDS HERE
'===================================
'           
		GOSUB BotLine              ' Clear Unused Bottom Lines
		LastLine% = CurntLine% - 1
		CurntLine% = FstLine%  ' Current Line is now first Line in screen
		
		CurrScrRw% = 1
		IF KeepCursBot% = 0 THEN GOTO LocCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last Line in Screen
		CurrScrRw% = TotScrRws%: KeepCursBot% = 0: CurntLine% = LastLine%
		GOTO LocCursor2
		
LocCursor:
		GOSUB HeRestColor

LocCursor2:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		COLOR 0, 7: GOSUB DisplayRw: COLOR 7, 0 ' Display Current Row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		OldScrRw% = CurrScrRw%
		OldLine% = CurntLine%
		IF GoToThisDir% <> 0 THEN CurntLine% = GoToThisDir%: GoToThisDir% = 0: GOTO Exekit
		'GOSUB ShowValues    ' My little Debugger
		
		
DoHeAgain:      GOSUB GetChar

		' IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO DoHeAgain

		' ESCape Key
		IF UH$ = CHR$(27) THEN GOTO HAbort
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO IsArrDown
EnterKey:       CALL FISCHIO
		GOSUB ThisSect
		GOSUB RePaintHelp
		GOTO NMatch

IsArrDown:     ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO OthKey0
		IF CurrScrRw% < LastScrRw% THEN CurrScrRw% = CurrScrRw% + 1: CurntLine% = CurntLine% + 1: GOTO LocCursor
		IF CurntLine% = TLines% THEN GOTO LocCursor
		CurntLine% = FstLine% + 1
		KeepCursBot% = 1
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
OthKey0:         'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO OthKey1
		IF CurntLine% = 1 THEN GOTO NMatch
		IF CurrScrRw% > 1 THEN CurrScrRw% = CurrScrRw% - 1: CurntLine% = CurntLine% - 1: GOTO LocCursor
		CurntLine% = FstLine% - 1: IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
		
OthKey1:         ' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO OthKey2
		CurntLine% = FstLine% - TotScrRws%
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO OthKey7
		IF LastLine% + 1 + TotScrRws% > TLines% THEN CurntLine% = TLines% - TotScrRws% + 1: IF CurntLine% < 1 THEN CurntLine% = 1: GOTO Exekit
		CurntLine% = FstLine% + TotScrRws%
		IF CurntLine% > TLines% THEN CurntLine% = FstLine%
		GOTO Exekit
		
OthKey7:         ' Home Key : simply move cursor to top
		IF UH$ <> CHR$(0) + CHR$(71) THEN GOTO OthKey8
		CurrScrRw% = 1: CurntLine% = FstLine%: GOTO LocCursor

OthKey8:         ' End Key : simply move cursor to bottom
		IF UH$ <> CHR$(0) + CHR$(79) THEN GOTO OthKey9
		CurrScrRw% = LastScrRw%: CurntLine% = LastLine%
		GOTO LocCursor
		
OthKey9:        ' F3 = Show Error List
		IF UH$ <> CHR$(0) + CHR$(61) THEN GOTO OthKey10
		GOSUB RePaintHelp
		GOTO NMatch

OthKey10:       ' F7 = Show Sector as Hex
		IF UH$ <> CHR$(0) + CHR$(65) THEN GOTO OthKey11
		GOSUB RePaintHelp
		GOTO NMatch
		
OthKey11:       'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO OthKey12
		GOTO EnterKey
OthKey12:           
		GOTO NMatch


Exekit:         CurrScrRw% = 1     ' Cursor on first screen row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GOTO NextLineName   ' Start next round

NMatch:         GOTO LocCursor
		
RePaintHelp:     
		GOSUB RedrawBox
		SaveCurrLine% = CurntLine%
		SavCurrScrRw% = CurrScrRw%
		CurntLine% = FstLine%
		FOR CurrScrRw% = 1 TO TotScrRws%
		GOSUB DisplayRw  ' Display Current Row
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		IF CurntLine% > TLines% THEN CurrScrRw% = CurrScrRw% + 1: GOTO RePaintHelp2
		NEXT CurrScrRw%   ' Next Screen Row
		
RePaintHelp2:          
		
		CurntLine% = SaveCurrLine%
		CurrScrRw% = SavCurrScrRw%
		RETURN

HeRestColor:    TempScreenRw% = CurrScrRw%
		TempLine% = CurntLine%
		CurrScrRw% = OldScrRw%
		CurntLine% = OldLine%
		COLOR 7, 0: GOSUB DisplayRw ' Display Current Row
		CurrScrRw% = TempScreenRw%
		CurntLine% = TempLine%
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRw:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GET #59, IdxStart(CurntLine%)
		TL$ = DL$
		FOR t = 1 TO LEN(TL$): IF MID$(TL$, t, 1) <> " " AND MID$(TL$, t, 1) <> "*" THEN GOTO StrtFound
		NEXT t
StrtFound:      TL$ = RIGHT$(TL$, LEN(TL$) - t + 1)
		
		FOR t = LEN(TL$) TO 1 STEP -1: IF MID$(TL$, t, 1) <> " " AND MID$(TL$, t, 1) <> "*" THEN GOTO EndFnd
		NEXT t
EndFnd:         TL$ = LEFT$(TL$, t)
		PRINT IDXSect$(CurntLine%); TAB(12); TL$; SPACE$(79 - 12 - LEN(TL$));
		RETURN
		
'====================
' CLEAR BOTTOM LINES
'====================       
BotLine: 
		
		LOCATE InizRw% + CurrScrRw%, 2, 1

		IF CurrScrRw% >= TotScrRws% THEN GOTO HlpClear ' Blank all unused screen rows, if any

		FOR V = CurrScrRw% TO TotScrRws%
		LOCATE InizRw% + V, 2, 1
		PRINT "                                                                              "
		NEXT V
		
HlpClear:       LOCATE 23, 1: PRINT "Enter=Get Doc. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		RETURN

		
' Create Box
RedrawBox:      CALL box(2, 1, 80, TotScrRws% + 2)
		RETURN
Pranyk:

		PRINT "                         - press any key to return -"
		GOSUB GetChar
		RETURN
		
GetChar:
		DO: UH$ = INKEY$: LOOP UNTIL UH$ <> ""
		RETURN


ThisSect:       TotSectRws% = 19
		SectInizRw% = 2
		SectCurrRw% = 1
		SectStart# = IdxStart(CurntLine%)
		SectCount# = IdxLength(CurntLine%)
		SectCurr# = 0
		Blank$ = SPACE$(78)
		LOCATE 23, 1: PRINT "Enter=Line Down. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		CALL box(2, 1, 80, TotSectRws% + 2)
NewRound:             
		FirstRec# = SectCurr#
SectNewLine:             
		GET #59, SectStart# + SectCurr#
		LOCATE SectInizRw% + SectCurrRw%, 2, 1
		PRINT DL$;
		SectCurr# = SectCurr# + 1
		LastSectRw% = SectCurrRw%      ' Save last Screen Row used
		SectCurrRw% = SectCurrRw% + 1
		IF SectCurrRw% < TotSectRws% + 1 AND SectCurr# < SectCount# THEN GOTO SectNewLine
		
		FOR V = SectCurrRw% TO TotSectRws%
		LOCATE SectInizRw% + V, 2
		PRINT Blank$;
		NEXT V
		
GetAnother:     GOSUB GetChar
		'IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO GetAnother
		SectCurr# = FirstRec#
		SectCurrRw% = 1
		' ESC Key
		IF UH$ = CHR$(27) THEN GOTO SectExit
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO SectArrowDown
SectEnter:      IF SectCurr# < SectCount# - 6 THEN SectCurr# = SectCurr# + 1
		GOTO NewRound
		
SectArrowDown:  ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO SectKey0
		GOTO SectEnter
		
SectKey0:       'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO SectKey1
		IF SectCurr# > 0 THEN SectCurr# = SectCurr# - 1
		GOTO NewRound
SectKey1:           
		' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO SectKey2
SectPageUp:     SectCurr# = SectCurr# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO SectKey11
SectPageDown:   SectCurr# = SectCurr# + TotSectRws%
		IF SectCurr# > SectCount# - TotSectRws% THEN SectCurr# = SectCount# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey11:      'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO SectKey12
		GOTO SectPageDown
		
SectKey12:      'CTRL Page Up
		IF UH$ <> CHR$(0) + CHR$(132) THEN GOTO SectKey13
		GOTO SectPageUp
SectKey13:          
		GOTO NewRound
SectExit:               
		V = InizRw% + TotScrRws%
		LOCATE V, 1, 1
		IF V >= 22 THEN GOTO DontDoit ' Blank all unused screen rows, if any

		FOR V = V TO 23
		LOCATE V, 1, 1
		PRINT SPACE$(80)
		NEXT V
DontDoit:
		
		RETURN
HAbort:             
		CLOSE #59
END SUB


DEFINT A-Z
FUNCTION Normalize$(Value,length)
		A$=STR$(Value)
		A$=SPACE$(Length-LEN(A$))+A$
		Normalize$=A$
END FUNCTION 

DEFINT A-Z
FUNCTION Xinput$ (Row%, Col%, FieldLen%, Default$, AllowCharsMask$, EndingKeys$, ExitKey$, RealStrLen%) STATIC

'Ŀ
'         XINPUT 2.1:  A Powerful Replacement for standard QBasic INPUT       
'                 
'                              First written                                  
'                                   by                                        
'          Frederick Volking, QBNews, Volume  1, Number  3  May 22, 1990      
'                                                                             
'                    ͻ                      
'                             Paolo Bagnaresi                               
'                           Via J.F. Kennedy 17                             
'                      20097 San Donato Milanese (MI)                       
'                                Italy                                      
'                          Tel. ++39-2-514.202                              
'                                                     
'                    e-mail: paolo_bagnaresi@libero.it
'                    ͼ                      
'                                                                             
'          Almost entirely rewritten and deeply enhanced on June 1995         
'                                                                             
' Vers. 2.0 : Some bad bugs corrected on March 1996 (cursor position and      
'             returned string length)                                         
' Vers. 2.1 : May 2000. FieldLen% bug fixed.                                  
'Ĵ
'SYNTAX:Xinput$(Row%,Col%,FLen%,Default$,Allow$,EndKeys$,ExitKey$,RealStrLen%)
'WHERE: Row% & Col% - where input to occur                                    
'         FLen% - Field Length - maximum allowable                            
'         Default$ - Field's beginning default value                          
'         Allow$ - Character Set allowable for input                          
'         EndKeys$ - Keystrokes acceptable for finishing.                     
'            SUCH: [Enter] is CHR$(13)                                        
'                  [Esc] is CHR$(27)                                          
'                  [F1] is CHR$(255)+CHR$(59)                                 
'                  [Ctrl+PgUp] is CHR$(255)+CHR$(132)                         
'                  ... etc                                                    
'         ExitKey$ - The keystroke (from above EndKeys$)                      
'                    which was struck at function end.                        
'         RealStrLen% - The Real String Length, not counting unused space     
'                       at the string end. However, Spaces added manually     
'                       do count!                                             
'  SIMPLEST USE:  A$ = Xinput$(0,0,0,"","","",Any$,RealStrLen%)               
'         Will default to cursor's current row/col, length is                 
'         autoset to right margin, allowable chars are ALL,                   
'         only ending key is [Enter].                                         
'Ĵ
'                                                                             
'   Instructions and enhancements discussion after the end of program         
'                           ***  see below ***                                
'                                                                             
'
'  Discussion 
'
'                 XINPUT program eXtends the standard QBasic INPUT.
'
'     Unlike QB INPUT, XINPUT allows editing a previously created string.
'     This is the strongest feature of Xinput and the very reason why this
'     task was undertaken. I just could not bear any longer the tedious
'     retyping of any string change that was needed in some program
'     I developed through the years.
'     The original routine written by Frederick Volking on QBNews, named
'     ENPUT,  did not alllow a string editing, which is why I felt compelled
'     to rewrite the Volking routine.
'
'     Other valuable features are:
'
'- Exit keys (Xinput terminators) are user selectable, and detectable by caller.
'- All the user allowed keys are also pre-selectable. Caller can create a mask
'  containing the all the keys that the callee will be allowed to use.
'  A low sound will signal hitting an unselected key.
'
'- Insert key remains active until you deselect it by pressing it again.
'- Backspace pressed 8 times at 1st string position reverts you to start string.
'- Screen start position is user selectable.
'- Cursor Up key and Cursor Down key will move you through the rows.
'- Page Up will moves you to first row. Page Down to the last row.
'- CTRL+Home erases all the field from cursor position up to 1st string char.
'- All the standard QB Input features are emulated, including CTRL+End,
'  CTRL+R, CTRL+E, Tab and CTRL+I...
'- Escape key or CTRL+U, if aren't redefined as an exit key, will entirely
'  blank the string field.
'- Source code in plain QBasic is here, waiting for your enhancements.
'  BTW, I would gladly receive your enhancements, if you can send them to my
'  address:                   Paolo Bagnaresi
'                           Via J.F. Kennedy 17
'                      20097 San Donato Milanese (MI)
'                                Italy
'                          Tel. ++39-2-514.202
'                   e-mail: paolo_bagnaresi@libero.it

		SHARED ScreenWidth%, EmptySpaceChar$

' 1 character Key vakues
		CtrlB$ = CHR$(2)         ' Ctrl+ B = Cursor to the word on the left
		CtrlE$ = CHR$(5)         ' Ctrl+ E = Cancel all chars from Cursor Posit. to end
		CtrlF$ = CHR$(6)         ' Ctrl+ F = Cursor to the word on the right
		BackS$ = CHR$(8)         ' Backspace
		Tabul$ = CHR$(9)         ' Tabulator
		CtrlI$ = CHR$(9)         ' Ctrl+ I = Tabulator
		CtrlK$ = CHR$(11)        ' Ctrl+ K = Cursor to start of field (= Home)
		Enter$ = CHR$(13)        ' Enter
		CtrlN$ = CHR$(14)        ' Ctrl+ N = Cursor to end of field (= End)
		CtrlR$ = CHR$(18)        ' Ctrl+ R = Insert mode toggle
		CtrlU$ = CHR$(21)        ' Ctrl+ U = Clear all input field
		Esc$ = CHR$(27)          ' Escape
		CtrlRevSlash$ = CHR$(28) ' Ctrl+ \ = Cursor Right
		CtrlClSquare$ = CHR$(29) ' Ctrl+ ] = Cursor Left

' 2 character Key vakues
		CursLeft$ = CHR$(0) + CHR$(75)
		CursRight$ = CHR$(0) + CHR$(77)
		CursUp$ = CHR$(0) + CHR$(72)
		CursDown$ = CHR$(0) + CHR$(80)

		Insert$ = CHR$(0) + CHR$(82)
		Delete$ = CHR$(0) + CHR$(83)
		Home$ = CHR$(0) + CHR$(71)
		End$ = CHR$(0) + CHR$(79)
		PageUp$ = CHR$(0) + CHR$(73)
		PageDown$ = CHR$(0) + CHR$(81)

		CtrlHome$ = CHR$(0) + CHR$(119)
		CtrlEnd$ = CHR$(0) + CHR$(117)
		CtrlPageUp$ = CHR$(0) + CHR$(132)
		CtrlPageDown$ = CHR$(0) + CHR$(118)
		CtrlCursLeft$ = CHR$(0) + CHR$(115)
		CtrlCursRight$ = CHR$(0) + CHR$(116)

' Other Key vakues, currently unused
		F1$ = CHR$(59)           'F1
		F2$ = CHR$(60)           'F2
		F3$ = CHR$(61)           'F3
		F4$ = CHR$(62)           'F4
		F5$ = CHR$(63)           'F5
		F6$ = CHR$(64)           'F6
		F7$ = CHR$(65)           'F7
		F8$ = CHR$(66)           'F8
		F9$ = CHR$(67)           'F9
		F10$ = CHR$(68)          'F10
		F10$ = CHR$(133)         'F11
		F10$ = CHR$(134)         'F12

' Verify if SHARED globals are set
		IF ScreenWidth% = 0 THEN ScreenWidth% = 80
		IF LastRow% = 0 THEN LastRow% = 24
		TotalScreenLength% = LastRow% * ScreenWidth%
		IF EmptySpaceChar$ = "" THEN EmptySpaceChar$ = CHR$(32)

' If not specified then supply defaults to incoming vars
		IF AllowCharsMask$ = "" THEN AllowCharsMask$ = CHR$(34) + " !#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~"
		IF EndingKeys$ = "" THEN EndingKeys$ = CHR$(13)
		IF Row% = 0 THEN Row% = CSRLIN
		IF Col% = 0 THEN Col% = POS(0)
		ReturnVar$ = Default$
		IF FieldLen% = 0 THEN FieldLen% = LEN(ReturnVar$)
		IF FieldLen% <= LEN(ReturnVar$) THEN GOTO FieldLenOk
		ReturnVar$ = ReturnVar$ + STRING$(FieldLen% - LEN(ReturnVar$), EmptySpaceChar$)
		FieldLen% = LEN(ReturnVar$)
		Default$ = ReturnVar$
		
FieldLenOk:
' Define internal defaults

		CursPos% = 1
		ReturnVar$ = Default$
		Separator$ = " !#$%&'()*+,-./:;<=>?@[\]^_`{|}~" + CHR$(34) ' Valid separators for CTRL+LEFT or CTRL+RIGHT
		IF TabLen% = 0 THEN TabLen% = 8 ' Tabulator lenght
		NotDone% = 1
		standard% = 6 'Cursor Shape if in Standard Mode
		Insert% = 4   'Cursor Shape if in Insert Mode
		CurShape% = standard%

'  MAIN LOOP STARTS HERE 
		Riga% = Row%: Lonna% = Col%
		DO
		LOCATE Riga%, Lonna%, 0
		IF Lonna% + LEN(ReturnVar$) > ScreenWidth% THEN
		Part1$ = LEFT$(ReturnVar$, ScreenWidth% - Lonna% + 1)
		Part2$ = RIGHT$(ReturnVar$, LEN(ReturnVar$) - (ScreenWidth% - Lonna% + 1))
		ELSE
		Part1$ = ReturnVar$: Part2$ = ""
		END IF
		PRINT Part1$; Part2$;

		RowCurs% = INT((Lonna% + CursPos% - 1) / ScreenWidth%)
		ColCurs% = (Lonna% + CursPos% - 1) MOD ScreenWidth%
		IF ColCurs% = 0 THEN ColCurs% = ScreenWidth%: RowCurs% = RowCurs% - 1
		VirtPos% = (Riga% * ScreenWidth% - 1) + Lonna% + FieldLen%
		IF VirtPos% > TotalScreenLength% THEN
		Riga% = Riga% - (INT((VirtPos% - TotalScreenLength% - 1) / ScreenWidth%))

		LOCATE Riga%, Lonna%, 0
		END IF
		LOCATE Riga% + RowCurs%, ColCurs%, 1, CurShape%, 7
		DO
		KeyStroke$ = INKEY$
		LOOP WHILE KeyStroke$ = ""


		IF INSTR(AllowCharsMask$, KeyStroke$) > 0 THEN
		Mark% = 0'No Backspace at Posit. 0
		IF CurShape% = standard% THEN
		MID$(ReturnVar$, CursPos%, 1) = KeyStroke$

		ELSE
		ReturnVar$ = LEFT$(ReturnVar$, CursPos% - 1) + KeyStroke$ + MID$(ReturnVar$, CursPos%, FieldLen% - CursPos%)
		END IF

		IF CursPos% < FieldLen% THEN
		CursPos% = CursPos% + 1
		ELSE
		BEEP
		END IF
		ELSE
		
		IF (INSTR(EndingKeys$, KeyStroke$) > 0) THEN
		IF KeyStroke$ = CHR$(0) + CHR$(75) AND CursPos% > 1 THEN
		GOTO SELCASE
		
		ELSE
		ExitKey$ = KeyStroke$
		NotDone% = 0
		GOTO FExit
		END IF
		END IF
		
'  Check for other keys  
SELCASE:
		SELECT CASE KeyStroke$
		CASE CursLeft$
		IF CursPos% > 1 THEN
		CursPos% = CursPos% - 1
		END IF
		CASE CursRight$
		IF CursPos% < FieldLen% THEN
		CursPos% = CursPos% + 1
		END IF
		CASE BackS$
		IF CursPos% > 1 THEN
		Mark% = 0'No Backspace at Posit. 0
		ReturnVar$ = LEFT$(ReturnVar$, CursPos% - 2) + RIGHT$(ReturnVar$, FieldLen% - CursPos% + 1) + EmptySpaceChar$
		CursPos% = CursPos% - 1
		ELSE
		Mark% = Mark% + 1:
		SOUND Mark% * 400 + 500, 1
		IF Mark% > 7 THEN
		Mark% = 0
		ReturnVar$ = Default$
		' IF LEN(ReturnVar$) < FieldLen% THEN
		'    ReturnVar$ = ReturnVar$ + SPACE$(FieldLen% - LEN(ReturnVar$))
		' END IF
		END IF
		END IF
		CASE Delete$
		ReturnVar$ = LEFT$(ReturnVar$, CursPos% - 1) + RIGHT$(ReturnVar$, FieldLen% - CursPos%) + EmptySpaceChar$
		CASE Insert$, CtrlR$
		IF CurShape% = standard% THEN
		CurShape% = Insert%
		ELSE CurShape% = standard%
		END IF

		CASE Home$, CtrlK$  ' Cursor to field start
		CursPos% = 1

		CASE End$, CtrlN$  ' Cursor to field end
		CursPos% = LEN(ReturnVar$)

		CASE CursUp$  ' Cursor 1 line up
		IF CursPos% > ScreenWidth% THEN CursPos% = CursPos% - ScreenWidth%

		CASE CursDown$ ' Cursor 1 line down
		IF CursPos% + ScreenWidth% < LEN(ReturnVar$) + 1 THEN CursPos% = CursPos% + ScreenWidth%

		CASE CtrlHome$  ' Cancel all chars from Cursor Position -1  up to start
		ReturnVar$ = RIGHT$(ReturnVar$, FieldLen% - CursPos% + 1) + STRING$(CursPos% - 1, EmptySpaceChar$)
		CursPos% = 1

		CASE CtrlEnd$, CtrlE$ ' Ctrl+ E = Cancel all chars from Cursor Posit. up to end
		ReturnVar$ = LEFT$(ReturnVar$, CursPos% - 1) + STRING$(FieldLen% - CursPos% + 1, EmptySpaceChar$)

		CASE PageUp$  ' Cursor to 1st line
		DO WHILE CursPos% > ScreenWidth%
		CursPos% = CursPos% - ScreenWidth%
		LOOP

		CASE PageDown$ ' Cursor to last line
		DO WHILE CursPos% + ScreenWidth% < LEN(ReturnVar$) + 1
		CursPos% = CursPos% + ScreenWidth%
		LOOP

		CASE CtrlCursLeft$, CtrlB$ ' Ctrl+ B = Cursor to the word on the left
		IF CursPos% > 1 THEN
		P% = CursPos% - 1
		DO WHILE (P% > 1) AND INSTR(Separator$, MID$(ReturnVar$, P%, 1)) > 0
		P% = P% - 1
		LOOP

		DO WHILE (P% > 1) AND INSTR(Separator$, MID$(ReturnVar$, P%, 1)) = 0
		P% = P% - 1
		LOOP
		CursPos% = P%
		IF CursPos% < 1 THEN CursPos% = 1
		IF CursPos% > 1 THEN CursPos% = CursPos% + 1
		END IF

		CASE CtrlCursRight$, CtrlF$ ' Ctrl+ F = Cursor to the word on the right
		P% = CursPos% + 1
		
		DO WHILE (P% < FieldLen%) AND INSTR(Separator$, MID$(ReturnVar$, P%, 1)) = 0
		P% = P% + 1
		LOOP
		'DO WHILE (P% < FieldLen%) AND INSTR(Separator$, MID$(ReturnVar$, P%, 1)) > 0
		'P% = P% + 1
		'LOOP

		CursPos% = P%
		IF CursPos% > FieldLen% THEN CursPos% = FieldLen%

		CASE Esc$, CtrlU$  ' Ctrl+ U = Clear all input field, if Escape is not
		' activate to exit by XINPUT caller
		ReturnVar$ = STRING$(FieldLen%, EmptySpaceChar$)
		CursPos% = 1

		CASE Tabul$  ' Tabulator in QBasic works in the following way:
		' Cursor moves to past the NEXT 8th character,
		'   character 1 in string being 1st character.
		' I.e., to 9th, 17th, 25th, 33rd character and so on.
		' If INSERT key is not active, up to 8 character will be blanked.
		' If INSERT key is ACTIVE, up to 8 blanks will be INSERTED.

		P% = (INT((CursPos% - 1 + TabLen%) / TabLen%) * TabLen%) + 1 ' Find Cursor position of next tabulation
		IF P% > FieldLen% + 1 THEN P% = FieldLen% + 1
		IF CursPos% > 1 THEN R1$ = LEFT$(ReturnVar$, CursPos% - 1) ELSE R1$ = ""
		IF CurShape% = standard% THEN
		IF CursPos% < P% THEN R2$ = RIGHT$(ReturnVar$, FieldLen% - P% + 1) ELSE R2$ = ""
		ELSE
		IF CursPos% < FieldLen% THEN R2$ = MID$(ReturnVar$, CursPos%, FieldLen% + 1 - P%) ELSE R2$ = ""
		END IF
		ReturnVar$ = R1$ + STRING$(P% - CursPos%, CHR$(32)) + R2$
		IF P% > FieldLen% THEN P% = FieldLen%
		CursPos% = P%

		CASE ELSE
		SOUND 500, 1
		END SELECT
		
		END IF

		LOOP WHILE NotDone%

'  Exit from here  
FExit:
		RealStrLen% = LEN(ReturnVar$)
		Xinput$ = ReturnVar$
		END FUNCTION

DEFSNG A-Z
' READ A SECTOR FROM ANY OF THE FOLLOWING : PC99 DISK, V9T9 DISK, TI99-PC DISK, MESS HARD DISK
SUB GetVirtualSect (FileNum%, Sektor&, d$)
		Sekr& = Sektor& - 1

		IF FType$ <> "MH" THEN GOTO NoMHDisk            ' See if it is a Mess Hard Disk
		ByteOff& = Sekr& + 1
		ByteOff& = ByteOff& * MHSecLen% + MHSectZero&
		SELECT CASE MHSecLen%
		CASE 256
		GET #FileNum%, ByteOff& + 1, MHSekt256(1)
		d$ = MHSekt256(1)
		CASE 512
		GET #FileNum%, ByteOff& + 1, MHSekt512(1)
		d$ = MHSekt512(1)
		END SELECT
		GOTO GetSectExit



NoMHDisk: 
		IF FType$ <> "VS" THEN GOTO PC99disk            ' V-9T9 S-ingle density
		ByteOff& = Sekr&
		ByteOff& = ByteOff& * MHSecLen%
		GET #FileNum%, ByteOff& + 1, V9T9Sekt(1)
		d$ = V9T9Sekt(1)
		GOTO GetSectExit

PC99disk:       Trk& = INT(Sekr& / SekTrack%)
		DskSide& = 0
		IF Trk& > 39 THEN Trk& = 79 - Trk&: DskSide& = 1
		Skt% = Sekr& MOD SekTrack%

		IF FType$ = "PD" THEN GOTO GetSectD
		IF FType$ = "PS" THEN GOTO GetSectS

'*** SINGLE DENSITY DISK ***
GetSectS:       IF Trk& = OldTrack& AND DskSide& = OldDskSide& THEN GOTO GetSectS03
		ByteOff& = SideLen& * DskSide& + Trk& * TrkLen&
		GET #FileNum%, ByteOff& + 1, TrackSing(1)
		OldTrack& = Trk&: OldDskSide& = DskSide&

GetSectS03:     FOR WHT% = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (WHT% - 1))
		A$ = MID$(TrackSing(1), P, 4)

		IF A$ <> CHR$(Trk&) + CHR$(DskSide&) + CHR$(Skt%) + CHR$(1) THEN GOTO GetSectS05
		d$ = MID$(TrackSing(1), 1 + Gap1% + PreDatGap% + (SLength% * (WHT% - 1)), 256)
		GOTO GetSectExit

GetSectS05:     NEXT WHT%

		GOTO GetSectBad:

'*** DOUBLE DENSITY DISK ***
GetSectD:       IF Trk& = OldTrack& AND DskSide& = OldDskSide& THEN GOTO GetSectD03
		ByteOff& = SideLen& * DskSide& + Trk& * TrkLen&
		GET #FileNum%, ByteOff& + 1, TrackDoub(1)
		OldTrack& = Trk&: OldDskSide& = DskSide&

GetSectD03:     FOR WHT% = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (WHT% - 1))
		A$ = MID$(TrackDoub(1), P, 4)

		IF A$ <> CHR$(Trk&) + CHR$(DskSide&) + CHR$(Skt%) + CHR$(1) THEN GOTO GetSectD05
		d$ = MID$(TrackDoub(1), 1 + Gap1% + PreDatGap% + (SLength% * (WHT% - 1)), 256)
		GOTO GetSectExit

GetSectD05:     NEXT WHT%

GetSectBad:     d$ = ""

GetSectExit:
END SUB


' ESTABLISH MEDIA OF A PC99 OR V9T9 DISK AND GET SECTOR ZERO
' Ex. Call GetVirtualZero (1, d$)
'       .... will return
'FType$ = "VS" if V9T9 disk
'FType$ = "PS" if PC99 Single density disk
'FType$ = "PD" if PC99 Double density disk
'FType$ = "MH" if Messa Hard Disk
SUB GetVirtualZero (FileNum%, d$)
		ByteOff& = 1
		MHSecLen% = 256
		DIM DAT(1) AS STRING * 256

		GET #FileNum%, ByteOff&, DAT(1)
		IF MID$(DAT(1), 1, 8) <> "MComprHD" THEN GOTO DSKDetect

		ERASE V9T9Sekt
		ERASE TrackSing
		ERASE TrackDoub

		FType$ = "MH" ' Mess Hard Disk
		MHTB& = CalcDWord&(DAT(1), 28 + 1)  ' Get Total # of Blocks
		MHMapStart& = CalcDWord&(DAT(1), 8 + 1)  ' Get Hard Disk Header Size
		MHMapEnd& = MHTB& * 8 + MHMapStart&  ' Get Total # of Blocks * 8 + Hard Disk Header Size
		MHSectZero& = MHMapEnd& + 8
		MHSecLen% = CalcDWord&(DAT(1), 76 + 1) ' Get Hard Disk Sector Len

		ByteOff& = MHSectZero&
		IF MHSecLen% = 256 THEN ERASE MHSekt512 ELSE ERASE MHSekt256
		SELECT CASE MHSecLen%

		CASE 256
		GET #FileNum%, ByteOff& + 1, MHSekt256(1)
		d$ = MHSekt256(1)

		CASE 512
		GET #FileNum%, ByteOff& + 1, MHSekt512(1)
		d$ = MHSekt512(1)
		CASE ELSE
		PRINT "Unexpected Sector Length in Mess Hard Disk": SYSTEM
		END SELECT
		GOTO EstMedExit


DSKDetect: 



		IF MID$(DAT(1), 14, 3) <> "DSK" THEN GOTO PC99Detect
		FType$ = "VS"          ' V-9T9 S-ingle density
		d$ = MID$(DAT(1), 1, 256)
		GOTO V9T9Found


PC99Detect:     ERASE V9T9Sekt
		ERASE MHSekt256
		ERASE MHSekt512

		P = INSTR(DAT(1), CHR$(&HFE)): IF P = 0 THEN GOTO EstMedAbort
		A$ = MID$(DAT(1), P + 4, 1)
		IF A$ <> CHR$(&H1) THEN GOTO EstMedAbort
		A$ = MID$(DAT(1), P - 3, 3)
		IF A$ = CHR$(&HA1) + CHR$(&HA1) + CHR$(&HA1) THEN GOTO DDens
		IF A$ <> CHR$(0) + CHR$(0) + CHR$(0) THEN GOTO EstMedAbort
'*** SINGLE DENSITY DISK ***
SDens:
		A$ = MID$(DAT(1), P + 4, 1)
		IF A$ <> CHR$(1) THEN GOTO EstMedAbort
		IF P <> 23 THEN GOTO EstMedAbort
		Gap1% = 16             ' Start of track Gap
		PreIDGap% = 7          '
		PreDatGap% = 31
		SLength% = 334
		SekTrack% = 9

		CONST TrkLenS% = 3253
		TrkLen& = TrkLenS%
		'REDIM TrackSing(1) AS STRING * TrkLenS
		GET #FileNum%, 1, TrackSing(1)
		d$ = TrackSing(1)
		FType$ = "PS"          ' P-C99 S-ingle density
		GOTO GetSZero1

'*** DOUBLE DENSITY DISK ***  
DDens:
		IF P <> 54 THEN GOTO EstMedAbort
		Gap1% = 40             ' Start of track Gap
		PreIDGap% = 14
		PreDatGap% = 58
		SLength% = 340
		SekTrack% = 18
		ERASE TrackSing
		CONST TrkLenD% = 6872
		TrkLen& = 6872
		'REDIM TrackDoub(1) AS STRING * TrkLenD
		GET #FileNum%, 1, TrackDoub(1)
		d$ = TrackDoub(1)
		FType$ = "PD"          ' P-C99 D-ouble density
		GOTO GetSZero2
GetSZero1:      ERASE TrackDoub
GetSZero2:
		OldTrack& = 0
		OldDskSide& = 0
		SideLen& = TrkLen& * 40
		FOR T = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (T - 1))
		A$ = MID$(d$, P, 4)

		IF A$ = CHR$(0) + CHR$(0) + CHR$(0) + CHR$(1) THEN GOTO SZeroFnd
		NEXT T
		GOTO EstMedAbort
SZeroFnd:       P = 1 + Gap1% + PreDatGap% + (SLength% * (T - 1))
		d$ = MID$(d$, P, 256)
		'A$=MID$(DAT,14,3)
		'IF A$<>"DSK" THEN GOTO EstMedAbort
		GOTO EstMedExit

V9T9Found:      ERASE TrackSing
		ERASE TrackDoub
		ERASE MHSekt256
		ERASE MHSekt512
		GOTO EstMedExit

EstMedAbort:    FType$ = ""  : d$ = ""
EstMedExit:     ERASE DAT
END SUB


FUNCTION CalcDWord& (A$, P%)
		IF LEN(A$) < P% + 3 THEN INPUT "Wrong String in CalcDoubleWord Subroutine", C$: V& = 0: GOTO CalcDWord1

		B1& = ASC(MID$(A$, P%, 1))
		B2& = ASC(MID$(A$, P% + 1, 1))
		B3& = ASC(MID$(A$, P% + 2, 1))
		B4& = ASC(MID$(A$, P% + 3, 1))
		V& = (B1& * 16777216) + (B2& * 65536) + (B3& * 256) + B4&

CalcDWord1:     CalcDWord& = (V&)

END FUNCTION