' IMPORT DOS FILES TO TI-99/4A DISK IMAGE FILE. Assign TI Filenames and TI File Types
' - Paolo Bagnaresi, August 2000 - e-mail: paolo_bagnaresi@libero.it
'
' This module can be Launched with a CHAIN qbasic instruction by a different qbasic program.
' Just add the same COMMON arrays to your launcher. (DIM Vector, MyName$, MyVal and the 3 corresponding COMMON Shared declarations).
' These arrays are used only as a parameter passing between chained qbasic programs.
DECLARE SUB box (Y%, X%, W%, H%)
DECLARE SUB ERRSOUND ()
DECLARE SUB Fischio ()
DECLARE SUB IncName (A$, B$)
DECLARE SUB ShortName (A$)
DECLARE SUB ShowDOSSector (FileSect$, ToShow$)
DECLARE SUB ShowHex (A$, K$)
DECLARE SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
DECLARE SUB TIGName (A$)
DECLARE SUB Canonize (A$)
DECLARE FUNCTION Shrink$ (In$)
DECLARE FUNCTION DoAway$ (Strig$, Char$)
DECLARE FUNCTION CalcWord (A$, P%)
DECLARE FUNCTION Xinput$ (Row%, Col%, FieldLen%, Default$, AllowCharsMask$, EndingKeys$, ExitKey$, RealStrLen%)
DIM Vector(0 TO 10)      AS INTEGER
DIM MyName$(0 TO 30)
DIM MyVal(0 TO 10)      AS INTEGER
DEFINT A-Z
COMMON SHARED Vector() AS INTEGER
COMMON SHARED MyName$()
COMMON SHARED MyVal() AS INTEGER

DIM DiskSize(1 TO 5)  AS INTEGER    ' Sectors per Disk. 360, 720, 1440, 2880
DIM SecTrack(1 TO 5)  AS INTEGER    ' Sector per Track. 9 or 18
DIM TrackSide(1 TO 5)  AS INTEGER   ' Track/side 40 or 80
DIM NumSides(1 TO 5)  AS INTEGER    ' Number of Sides. 1= Single Side, 2=Double Side
DIM DskDens(1 TO 5)  AS INTEGER     ' Disk Density. 1=Single Density, 2=Double Density
DIM LowestSect(1 TO 5)  AS INTEGER  ' Lowest sector where to begin to copy Data Sectors
DIM UpperABM(1 TO 5)  AS INTEGER    ' Highest byte in Allocation Bit Map in sector zero
		
		DiskSize(1) = 360  ' Sectors per Disk. 360, 720, 1440, 2880, 5760
		DiskSize(2) = 720
		DiskSize(3) = 1440
		DiskSize(4) = 2880
		DiskSize(5) = 5760
		
		SecTrack(1) = 9    ' Sector per Track. 9, 18 or 36
		SecTrack(2) = 9
		SecTrack(3) = 18
		SecTrack(4) = 18
		SecTrack(5) = 36
		
		TrackSide(1) = 40  ' Track/side 40 or 80
		TrackSide(2) = 40
		TrackSide(3) = 40
		TrackSide(4) = 80
		TrackSide(5) = 80
		
		
		NumSides(1) = 1    ' Number of Sides. 1= Single Side, 2=Double Side
		NumSides(2) = 2
		NumSides(3) = 2
		NumSides(4) = 2
		NumSides(5) = 2
		
		DskDens(1) = 1     ' Disk Density. 1=Single Density, 2=Double Density
		DskDens(2) = 1
		DskDens(3) = 2
		DskDens(4) = 2
		DskDens(5) = 2
		
		LowestSect(1) = 34 ' Lowest sector where to begin to copy Data Sectors
		LowestSect(2) = 34
		LowestSect(3) = 34
		LowestSect(4) = 258
		LowestSect(5) = 258
		
		UpperABM(1) = 45   ' Highest byte in Allocation Bit Map in sector zero
		UpperABM(2) = 90
		UpperABM(3) = 180
		UpperABM(4) = 180   ' With 2880 sectors each bit counts for 2 adjacent sectors
		UpperABM(5) = 180   ' With 5760 sectors each bit counts for 4 adjacent sectors
		
		DummyRec$ = STRING$(256, CHR$(&HE5))

Endk$ = CHR$(13) + CHR$(27) + CHR$(9) + CHR$(0) + CHR$(72) + CHR$(0) + CHR$(80) + CHR$(9) + CHR$(0) + CHR$(75) + CHR$(0) + CHR$(73)
Endk$ = Endk$ + CHR$(0) + CHR$(81) + CHR$(0) + CHR$(115) + CHR$(0) + CHR$(59) + CHR$(0) + CHR$(115) + CHR$(0) + CHR$(116)
Endk$ = Endk$ + CHR$(0) + CHR$(75) + CHR$(0) + CHR$(77) + CHR$(0) + CHR$(132) + CHR$(0) + CHR$(118) + CHR$(0) + CHR$(65)
Endk$ = Endk$ + CHR$(0) + CHR$(63) + CHR$(0) + CHR$(64) + CHR$(0) + CHR$(66)
Number$ = "1234567890"
Allowed$ = Number$ + "ABCDEFGHIJKLMNOPQRSTUVWYXZabcdefghijklmnopqrstuvwyxz.+-\/[]_#@_`^~{}'"

CA53$ = CHR$(&HCA) + CHR$(&H53)
CA5310$ = CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$ + CA53$
CA5364$ = CA5310$ + CA5310$ + CA5310$ + CA5310$ + CA5310$ + CA5310$ + CA53$ + CA53$ + CA53$ + CA53$
		


DEFINT A-Z
		TYPE IDXType
		Section AS STRING * 20
		StartRec AS DOUBLE
		RecLength AS SINGLE
		END TYPE
		DIM SHARED IDXRecord AS IDXType
		TempArk$ = "~ARKTMP.TMP"
		
		TYPE FHead
		Pntr AS STRING * 20
		TFIL AS STRING * 20
		TSIZ AS STRING * 20
		TDir AS STRING * 20
		Noth AS STRING * 16
		END TYPE
		DIM SHARED FiHeader AS FHead
		
		TYPE SelecType
		CpyMark AS STRING * 1
		SL AS STRING * 79
		DTyp AS STRING * 1
		DLen AS STRING * 1
		DArk AS STRING * 1
		DFre1 AS STRING * 1
		DFre2 AS STRING * 1
		TINAME AS STRING * 11
		END TYPE
		DIM SHARED Sel AS SelecType
		TabPos% = 1
		CursrPos% = 52
		TogLonName% = 1
		CLS
		SourcePath$ = MyName$(3)
		DestinPath$ = MyName$(5)
		'PRINT  "SourcePath$=";  SourcePath$ ;"  - DestinPath$= " ;DestinPath$
		'INPUT "",c$
		
		REDIM FilName$(1)
		REDIM DSEC(1) AS STRING * 512
		FOR T = LEN(DestinPath$) TO 1 STEP -1
		IF MID$(DestinPath$, T, 1) = "\" THEN GOTO BackFound
		NEXT T
	
		Path$ = DestinPath$
		GOTO BackFound2
BackFound:
		Path$ = LEFT$(DestinPath$, T)
BackFound2:
		GOTO OpenFile

' Exit point with F9
Abort:          'MyName$(2) = ""
		ERASE FilName$
		CLOSE #1
		CHAIN MyName$(0)

Leaveit:        'MyName$(2) = SourcePath$
LeaveIt2:       ERASE FilName$
		CLOSE #1
		
		CLS
		'SYSTEM
		CHAIN "DOS2I3.BAS"
		CHAIN MyName$(0)

OpenFile:       ' Read the Default Type from FileType.def file
		DefaultT$ = "f"' Default file type: INT VAR
		DefaultL% = 128' Default file reclen: 128
		ON ERROR GOTO NoUserInfo
		OPEN "FileType.def" FOR INPUT ACCESS READ AS #5   ' Avoid creation of file is file doesn't exist
		LINE INPUT #5, A$
		P = INSTR(A$, "=")
		IF P = 0 THEN GOTO FileTypeInf2
		A$ = UCASE$(RTRIM$(LTRIM$(MID$(A$, P + 1, LEN(A$)))))
		C$ = "": P = INSTR(A$, " ")
		IF P > 0 THEN C$ = UCASE$(RTRIM$(LTRIM$(MID$(A$, P + 1, LEN(A$))))): A$ = UCASE$(RTRIM$(LTRIM$(MID$(A$, 1, P - 1))))
		IF C$ <> "" THEN DefaultL% = VAL(C$): IF DefaultL% = 0 THEN DefaultL% = 128
		SELECT CASE A$
		CASE "PROGRAM"
		DefaultT$ = "P"
		CASE "DIS/VAR"
		DefaultT$ = "V"
		CASE "DIS/FIX"
		DefaultT$ = "F"
		CASE "INT/VAR"
		DefaultT$ = "v"
		CASE "INT/FIX"
		DefaultT$ = "f"
		CASE ELSE
		DefaultT$ = "f"
		
		END SELECT
		
FileTypeInf2:   CLOSE #5
		
		GOTO NoUserInfoGoOn
		
NoUserInfo:     RESUME NoUserInfoGoOn
NoUserInfoGoOn: ON ERROR GOTO Abort
		Selected$ = "~DOS2IB.TMP"
		OPEN Selected$ FOR INPUT ACCESS READ AS #5   ' Avoid creation of file is file doesn't exist
		CLOSE #5
		COLOR 14, 0
		ON ERROR GOTO 0
		
		OPEN Selected$ FOR RANDOM ACCESS READ WRITE AS #5 LEN = LEN(Sel)
		GET #5, 1, FiHeader
		PntLastUsed% = VAL(FiHeader.Pntr)
		OldTotFnames% = VAL(FiHeader.TFIL)
		OldTotSize& = VAL(FiHeader.TSIZ)
		TotDirs% = VAL(FiHeader.TDir)
		PRINT "Please wait while the file/type is being checked for DIS/VAR 80 on"; PntLastUsed%; "files..."
		
		'FOR CrrntFilename% = 2 TO PntLastUsed%	
		'NEXT CrrntFilename%
		
		FOR CrrntFilename% = 2 TO PntLastUsed%
		DU$ = INKEY$
		IF DU$ = CHR$(27) THEN GOTO Abort
		GET #5, CrrntFilename%, Sel
		
		IF Sel.DArk = "X" THEN GOTO NoCpy
		IF Sel.CpyMark <> " " THEN GOTO Cpy
		IF Sel.CpyMark = " " AND LEFT$(Sel.SL, 5) = "<ARK>" THEN GOTO ARKFilename
		
		CDIR$ = MID$(Sel.SL, 7, LEN(Sel.SL))
		CDIR$ = LTRIM$(RTRIM$(CDIR$))
		
		GOTO NoCpy
		
ARKFilename:    KDIR$ = MID$(Sel.SL, 7, LEN(Sel.SL))
		KDIR$ = LTRIM$(RTRIM$(KDIR$))
		GOTO NoCpy
		
		
Cpy:            IF Sel.DTyp <> " " AND Sel.DLen <> CHR$(32) THEN GOTO Cpy7
		
		'Sel.DTyp = "f"
		'Sel.DLen = CHR$(128)
		Sel.DTyp = DefaultT$
		Sel.DLen = CHR$(DefaultL%)
		
		N = N + 1
		Mystring$ = LEFT$(Sel.SL, 12)
		Mystring$ = Shrink(Mystring$)
		P = INSTR(1, Mystring$, " "): IF P > 0 THEN MID$(Mystring$, P) = "."
		FileSect$ = CDIR$ + Mystring$
	
		CALL ShortName(FileSect$)
		OPEN FileSect$ FOR BINARY ACCESS READ SHARED AS #6

' Check if file is a true text file (DIS/VAR 80)
		B = 0: C = 0: E = 0: F = 0
		tlen& = LOF(6)
		BytePos& = 1
		TrueText% = 0
		LOCATE 2, 1
		IF 5120 < tlen& THEN tlen& = 5120
		FOR BytePos& = 1 TO tlen& STEP 512
		GET #6, BytePos&, DSEC(1)
		
		' Some TI Uncompressed Object files may exceed 32767 bytes, be Text Only  and yet not be really Dis/Var.
		' If they were worked upon as if they were real Text Files they will crash the program DOS2I3.bas when it
		' tries to INPUT$ them (the string will not fit in any QBasic variable).
		' Those files will have to be handled as DIS/FIX 80.
		IF INSTR(DSEC(1), CHR$(13)) > 0 THEN TrueText% = TrueText% + 1
		
		' Check If TI FILES Header
		IF BytePos& > 1 THEN GOTO Cpy1
		IF LEFT$(DSEC(1), 8) <> CHR$(7) + "TIFILES" THEN GOTO Cpy1
		Sel.DLen = CHR$(128) : Sel.DTyp = "F"
		IF MID$(DSEC(1),129,1)=CHR$(&H80) THEN Sel.DTyp = "f"
		GOTO Cpy6
Cpy1:           
		FOR Z = 1 TO LEN(DSEC(1))
		A = ASC(MID$(DSEC(1), Z, 1))
		' B = Lumps of Normal ASCII
		' C= Strings with more than 3 chars of Normal ASCII
		' E = Lumps ASCII above 127
		' F = Strings with more than 2 chars of ASCII above 127
		' Logic: Chars 27, 9, 10, 13 are ignored.
		'        Chars 128-255, 0-31  are non text chars.
		'        More than 9 non text chars in a row will mark the file as "non text file", that is INT/FIX 128.
		'        Duplicated (consecutive) non text chars are ignored, to avoid counting DOS chars used to build boxes.
		'        Chars 32-127 are text chars. More than 3 text chars in a row will form a string.
		'        Only more than 2 text chars in a row will break the non text chars sequence.
		'
		'        File will marked as a Text File (DIS/VAR 80) only if it has at least one string and
		'        no more than 9 non text chars in a row.
		SELECT CASE A
		'CASE  0       '
		' GOTO Cpy5
		CASE 27        ' EOF
		CASE 9         ' TAB
		CASE 10        ' Carriage Return
		CASE 13        ' Line Feed

		CASE 32 TO 127
		B = B + 1
		IF E > 9 THEN F = F + 1: IF F > 1 THEN GOTO Cpy5
		IF B > 2 THEN E = 0
		V = A
		CASE ELSE ' Chars below 32 OR above 128
		IF B > 3 THEN C = C + 1
		B = 0
		IF A = V THEN GOTO Cpy2
		E = E + 1:
		V = A
		END SELECT
		
Cpy2:
		
Cpy4:           NEXT Z
		
Cpy5:           NEXT BytePos&

		IF B > 3 THEN C = C + 1
		IF E > 9 THEN F = F + 1
		IF C < 1 OR F > 0 THEN GOTO Cpy6
		IF LOF(6) > 2048 AND TrueText% = 0 THEN Sel.DTyp = "F": Sel.DLen = CHR$(80): GOTO Cpy6
		' PRINT FileSect$; " is DIS/VAR 80."; : INPUT "", C$
		Sel.DTyp = "V"
		Sel.DLen = CHR$(80)

Cpy6:           CLOSE #6
Cpy7:
		IF LEFT$(Sel.TINAME, 1) <> " " THEN GOTO Cpy8

		My$ = DoAway(LEFT$(Sel.SL, 12), " ")
		Sel.TINAME = LEFT$(My$, 10)
 
Cpy8:           PUT #5, CrrntFilename%, Sel
NoCpy:          NEXT CrrntFilename%
		
		LOCATE 3, 1
		PRINT "Please wait while the duplicated filenames are being resolved on"; PntLastUsed%; "files..."
		GOSUB NoDupNames ' Solve all duplicated names
		' Prepare to show all filenames
		LOCATE 2, 1, 1
		CrrScrnRow% = 1
		TotlScrnRows% = 16     ' Rows to display Filenames
		StrtRow% = 4  ' Screen Start Row
		CrrntFilename% = 1
		AllwdKey$ = CHR$(27)                         ' ESC
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(72) ' Arrow Up
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(80) ' Arrow Down
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(75) ' Arrow Left
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(77) ' Arrow Right
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(115)' CTRL Arrow Left
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(116)' CTRL Arrow Right
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(132)' CTRL Page Up
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(118)' CTRL Page Down
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(73) ' Page Up
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(81) ' Page Down
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(83) ' Del
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(71) ' Home
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(79) ' End
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(59) ' F1 = Help
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(61) ' F3 = Show Bad Sector
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(64) ' F6 = Proceed
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(65) ' F7 = Show Sector
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(66) ' F8 = Show ARK file directory, if applicable
		AllwdKey$ = AllwdKey$ + CHR$(21)           ' CTRL U = Unmark All
		AllwdKey$ = AllwdKey$ + CHR$(1)            ' CTRL A = Copy All
		AllwdKey$ = AllwdKey$ + CHR$(9)            ' TAB
		AllwdKey$ = AllwdKey$ + CHR$(20)           ' CTRL T
		AllwdKey$ = AllwdKey$ + CHR$(3)            ' CTRL C
		AllwdKey$ = AllwdKey$ + CHR$(13)           ' Enter = Execute
		AllwdKey$ = AllwdKey$ + "CcMmTt "            ' Cc + Blank
		
		GOSUB TopScrn
' MAIN LOOP STARTS HERE

NxtFileName:
		COLOR 14, 0
		GOSUB ViewFiles2Copy
		IF CrrScrnRow% = 1 THEN FstFilename% = CrrntFilename%   ' Get Number of first filename only
		GOSUB DsplRow  ' Display Crrent Row

		CrrntFilename% = CrrntFilename% + 1 ' Next Fielename


		LstScrnRow% = CrrScrnRow%      ' Save last Screen Row used
		CrrScrnRow% = CrrScrnRow% + 1  ' Next Screen Row
		IF CrrScrnRow% < TotlScrnRows% + 1 AND CrrntFilename% <= PntLastUsed% - 1 THEN GOTO NxtFileName

' MAIN LOOP ENDS HERE
' End of filenames
		GOSUB BottmLine:

		
		LstFilename% = CrrntFilename% - 1' Get Number of Last used filename
		CrrntFilename% = FstFilename%  ' Current filename is now first filename in screen

		CrrScrnRow% = 1
		IF KeapCursBttom% = 0 THEN GOTO LcateCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last filename in Screen
		CrrScrnRow% = TotlScrnRows%: KeapCursBttom% = 0: CrrntFilename% = LstFilename%
		GOTO LcateCursor2
LcateCursor:
		GOSUB RstoreColor

LcateCursor2:
		LOCATE StrtRow% + CrrScrnRow%, CursrPos%, 1
		COLOR 0, 15: GOSUB DsplRow: COLOR 14, 0 ' Display Current Row
		LOCATE StrtRow% + CrrScrnRow%, CursrPos%, 1
		OwldScreenRow% = CrrScrnRow%
		OwldFilename% = CrrntFilename%

DooetAgain:
		
		
OtroKey4b:      COLOR 0, 7
		GET #5, CrrntFilename% + 1, Sel
		
		
		' IF Sel.CpyMark = " " THEN TabPos% = 0: GOTO OtroKey12c
		IF TabPos% = 0 THEN GOSUB GetPRIORTY: GOTO OtroKey4b2
		IF TabPos% = 1 THEN GOSUB GetTIName: GOTO OtroKey4b2
		IF TabPos% = 2 THEN GOSUB GetFILETYPE: GOTO OtroKey4b2
		IF TabPos% = 3 THEN GOSUB GetFILELEN: GOTO OtroKey4b2

		
OtroKey4b2:     PUT #5, CrrntFilename% + 1, Sel
		COLOR 7, 0
		
		SELECT CASE Exitk$
		
		' Arrow Up
		CASE CHR$(0) + CHR$(72)
		FOR FF% = CrrntFilename% - 1 TO ActiveDirs% + 1 STEP -1' Check all the lower filenames
		GET #5, FF% + 1, Sel
		K = CrrntFilename% - FF%
		IF CrrScrnRow% - K > 0 THEN
		CrrScrnRow% = CrrScrnRow% - K: CrrntFilename% = FF%
		GOSUB GoToThatLine
		GOTO OtroKey4b
		ELSE
		
		GOSUB RstoreColor
		COLOR 7, 0
		CrrntFilename% = FF%
		FstFilename% = FF%
		CrrScrnRow% = 1     ' Cursor on first screen row
		GOSUB PntScrShort

		COLOR 0, 7
		GOSUB DsplRow
		LOCATE StrtRow% + CrrScrnRow%, 2, 1
		OwldScreenRow% = CrrScrnRow%
		OwldFilename% = CrrntFilename%
		GOTO OtroKey4b
		END IF
		
		GOTO KeineMatch
		
		NEXT FF%: GOTO KeineMatch
		
		' Arrow Down
		CASE CHR$(0) + CHR$(80)
		FOR FF% = CrrntFilename% + 1 TO PntLastUsed% - 1' Check all the UPPER filenames
		GET #5, FF% + 1, Sel
		
		
		K = FF% - CrrntFilename%
		IF CrrScrnRow% + K <= TotlScrnRows% THEN
		CrrScrnRow% = CrrScrnRow + K: CrrntFilename% = FF%
		GOSUB GoToThatLine
		GOTO OtroKey4b
		ELSE
		GOSUB RstoreColor
		COLOR 7, 0
		CrrntFilename% = FF%
		FstFilename% = FF% - TotlScrnRows% + 1
		IF FstFilename% < ActiveDirs% + 1 THEN FstFilename% = ActiveDirs% + 1
		CrrScrnRow% = TotlScrnRows%   ' Cursor on first screen row
		GOSUB PntScrShort
		
		
		LOCATE StrtRow% + CrrScrnRow%, 2, 1
		COLOR 0, 7
		GOSUB DsplRow
		LOCATE StrtRow% + CrrScrnRow%, 2, 1
		OwldScreenRow% = CrrScrnRow%
		OwldFilename% = CrrntFilename%
		GOTO OtroKey4b
		END IF
		GOTO KeineMatch
		
		NEXT FF%: GOTO KeineMatch
		
		' Page Up
		CASE CHR$(0) + CHR$(73)
		CrrntFilename% = FstFilename% - TotlScrnRows%
		IF CrrntFilename% < 1 THEN CrrntFilename% = 1
		GOTO GoExecutit
		
		' Page Down
		CASE CHR$(0) + CHR$(81)
		IF LstFilename% + 1 + TotlScrnRows% > PntLastUsed% - 1 THEN CrrntFilename% = PntLastUsed% - TotlScrnRows% + 1: IF CrrntFilename% < 1 THEN CrrntFilename% = 1: GOTO GoExecutit
		CrrntFilename% = FstFilename% + TotlScrnRows%
		IF CrrntFilename% > PntLastUsed% - 1 THEN CrrntFilename% = FstFilename%
		GOTO GoExecutit
		
		' F1 = Help
		CASE CHR$(0) + CHR$(59)
		CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "18.04.02")
		GOSUB NewPaintScreen
		GOTO OtroKey4b
		
		
		' TAB key
		CASE CHR$(9)
		GOTO OtroKey12b
		' Right Key
		CASE CHR$(0) + CHR$(116)
		GOTO OtroKey12b
		' CTRL Right Key
		CASE CHR$(0) + CHR$(77)
		GOTO OtroKey12b
		
		' Left Key
		CASE CHR$(0) + CHR$(115)
		GOTO OtroKey13b
		' CTRL Left Key
		CASE CHR$(0) + CHR$(75)
		GOTO OtroKey13b
		
		
		' ESC Key
		CASE CHR$(27)
		CLOSE #5
		GOTO Abort
		
		' Left Key
		CASE CHR$(0) + CHR$(75)
		GOTO OtroKey13b

		' CTRL Page Up
		CASE CHR$(0) + CHR$(132)
		GOTO OtroKey14b
		
		
		' CTRL Page Down
		CASE CHR$(0) + CHR$(118)
		GOTO OtroKey15b
		
		' F7 = Sector viewer
		CASE CHR$(0) + CHR$(65)
		
		GET #5, CrrntFilename% + 1, Sel
		P = INSTR(Sel.SL, "<DIR>"): IF P > 0 THEN BEEP: GOTO KeineMatch
		P = INSTR(Sel.SL, "<ARK>"): IF P > 0 THEN BEEP: GOTO KeineMatch
		Mystring$ = LEFT$(Sel.SL, 12)
		Mystring$ = Shrink(Mystring$)
		P = INSTR(1, Mystring$, " "): IF P > 0 THEN MID$(Mystring$, P) = "."
		SArkFilName$ = ""
		FOR T = CrrntFilename% TO 1 STEP -1
		GET #5, T + 1, Sel
		IF SArkFilName$ <> "" THEN GOTO OtroKey4n0
		P = INSTR(Sel.SL, "<ARK>"): IF P = 0 THEN GOTO OtroKey4n0
		' Found ARK main file
		SArkFilName$ = LTRIM$(RTRIM$(MID$(Sel.SL, 7, 12)))
		CALL Canonize(SArkFilName$)
		GOTO OtroKey4n2 ' Go and find the File Directory
		
OtroKey4n0:     P = INSTR(Sel.SL, "<DIR>"): IF P = 0 THEN GOTO OtroKey4n2
		' Found Directory
		A$ = MID$(Sel.SL, 7, LEN(Sel.SL))
		A$ = LTRIM$(RTRIM$(A$))
		IF SArkFilName$ = "" THEN GOTO OtroKey4n1
		
		GOSUB GetSUBArk: IF P > 0 THEN GOTO KeineMatch' GetSUBArk file=Mystring$ ("~subark.tmp")
		GOTO OtroKey4n3

OtroKey4n1:     Mystring$ = A$ + Mystring$
		ToShow$ = Mystring$
		GOTO OtroKey4n3
		
OtroKey4n2:     NEXT T
		GOTO KeineMatch
		
OtroKey4n3:     CALL ShowDOSSector(Mystring$, ToShow$)
		GOSUB NewPaintScreen
		GOTO KeineMatch

		'F8 = Show ARK File
		CASE CHR$(0) + CHR$(66)
		
		GET #5, CrrntFilename% + 1, Sel
		P = INSTR(Sel.SL, "<DIR>"): IF P > 0 THEN BEEP: GOTO KeineMatch
		Mystring$ = LEFT$(Sel.SL, 12)
		Mystring$ = Shrink(Mystring$)
		P = INSTR(1, Mystring$, " "): IF P > 0 THEN MID$(Mystring$, P) = "."
		FOR T = CrrntFilename% TO 1 STEP -1
		GET #5, T + 1, Sel
		P = INSTR(Sel.SL, "<DIR>"): IF P = 0 THEN GOTO OtroKey4Q2
		A$ = MID$(Sel.SL, 7, LEN(Sel.SL))
		A$ = LTRIM$(RTRIM$(A$))
		Mystring$ = A$ + Mystring$
		GOTO OtroKey4Q3
		
OtroKey4Q2:     NEXT T
		GOTO KeineMatch
		
OtroKey4Q3:
		
		CLS
		COLOR 14, 0
		
		PRINT TAB(15); "Catalog of Archive File: "; MID$(FilName$(CurrentFilename%), 1, 10)
		Exec$ = "Decomp4.com " + Mystring$ + " /s"
		SHELL Exec$
		COLOR 7, 0
		CLS
		GOSUB NewPaintScreen
		GOTO KeineMatch

		
		' F5 = Long/Short Filename Toggle
		CASE CHR$(0) + CHR$(63)
		TogLonName% = TogLonName% * -1
		GOSUB NewPaintScreen
		GOTO KeineMatch
		
		' F6= Proceed
		CASE CHR$(0) + CHR$(64)
		GOTO StrtCopying
		
		CASE ELSE
		GOTO KeineMatch
		END SELECT
		

OtroKey12b:     ' Arrow Rigth OR CTRL Arrow Rigth key = Move cursor to rightmost field
		TabPos% = TabPos% + 1: IF TabPos% > 3 THEN TabPos% = 0
OtroKey12c:     SELECT CASE TabPos%
		CASE 0
		CursrPos% = 2
		CASE 1
		CursrPos% = 52
		CASE 2
		CursrPos% = 65
		CASE 3
		CursrPos% = 75
		END SELECT
		
		IF TabPos% = 1 THEN GET #5, CrrntFilename% + 1, Sel
		GOSUB NewPaintScreen: GOTO KeineMatch
		GOTO KeineMatch
		
		'Arrow Left OR CTRL Arrow Left key = Move cursor to leftmost field
OtroKey13b:     TabPos% = TabPos% - 1: IF TabPos% < 0 THEN TabPos% = 3
		GOTO OtroKey12c
		
		' CTRL Page Up : Toggle File Type
OtroKey14b:     IF TogLonName% = -1 THEN GOTO KeineMatch
		GET #5, CrrntFilename% + 1, Sel
		
		P = INSTR("VFvfP ", Sel.DTyp) + 1
		IF P = 1 THEN P = 4
		IF P = 6 OR P = 7 THEN P = 1
		
		A$ = MID$("VFvfP ", P, 1)
OtroKey14c:     Sel.DTyp = A$
		PUT #5, CrrntFilename% + 1, Sel
		GOTO KeineMatch
		
		
		' CTRL Page Down : Toggle File Type
OtroKey15b:     GET #5, CrrntFilename% + 1, Sel
		P = INSTR("VFvfP ", Sel.DTyp) - 1
		IF P = -1 THEN P = 4
		IF P = 0 THEN P = 5
		
		A$ = MID$("VFvfP ", P, 1)
		GOTO OtroKey14c
		
		
		
GoExecutit:     ' Put current filename as first on top of screen, fill up the screen with next filenames
		CrrScrnRow% = 1     ' Cursor on first screen row
		LOCATE StrtRow% + CrrScrnRow%, CursrPos%, 1
		GOTO NxtFileName   ' Start next round

KeineMatch:     GOTO LcateCursor

' Input File Priority (Cpy.Mark)
GetPRIORTY:
		Prior$ = Sel.CpyMark
		
		IF Prior$ = "N" OR Sel.CpyMark = " " THEN Prior$ = " "
		
GetPRIORTY2:    IF Sel.DArk  <> "X" THEN C$="CcKkTt " ELSE C$="Cc "
		Prior$ = LTRIM$(RTRIM$(Xinput$(StrtRow% + CrrScrnRow%, 2, 1, Prior$, Number$ + C$, Endk$, Exitk$, RealStrLen%)))
		Prior$ = UCASE$(Prior$)
		
GetPRIORTY2c:   IF Exitk$ = CHR$(27) OR Sel.CpyMark = " " THEN GOTO GetPRIORTY3
		IF Prior$ = "" THEN Prior$ = "N"
		
		Sel.CpyMark = Prior$
GetPRIORTY3:    RETURN

' Input TI Filename
GetTIName:
		OutRec$ = Sel.TINAME
		IF Sel.CpyMark = " " THEN OutRec$ = " "
GetTIName1:     LOCATE StrtRow% + CrrScrnRow%, 52, 1
		IF TogLonName% = -1 THEN DO: Exitk$ = INKEY$: LOOP UNTIL Exitk$ <> "": GOTO GetTIName3
		OutRec$ = UCASE$(RTRIM$(Xinput$(StrtRow% + CrrScrnRow%, 52, 10, OutRec$, Allowed$, Endk$, Exitk$, RealStrLen%)))
		IF LEN(OutRec$) < 11 THEN GOTO GetTIName2
		BEEP
		LOCATE StrtRow% + CrrScrnRow%, 68, 1: PRINT "Max 10 char";
		WHILE INKEY$ = "": WEND
		LOCATE StrtRow% + CrrScrnRow%, 68, 1: PRINT "            ";
		GOTO GetTIName1
		
GetTIName2:     IF Sel.CpyMark = " " THEN GOTO GetTIName3
		
		GOSUB AvoidDupNam
		Sel.TINAME = OutRec$
GetTIName3:     RETURN
		
' Input File Type
GetFILETYPE:
		SELECT CASE Sel.DTyp
		CASE "V"       ' DIS VAR
		FType$ = "DIS/VAR"
		CASE "F"       ' DIS FIX
		FType$ = "DIS/FIX"
		CASE "v"       ' INT VAR
		FType$ = "INT/VAR"
		CASE "f"       ' INT FIX
		FType$ = "INT/FIX"
		CASE IS = " "  '
		FType$ = "INT/FIX"
		CASE "P"       ' PROGRAM
		FType$ = "PROGRAM"
		END SELECT
		COLOR 0, 7
		IF Sel.CpyMark = " " THEN FType$ = " "
		LOCATE StrtRow% + CrrScrnRow%, 65, 1
		IF TogLonName% = -1 THEN DO: Exitk$ = INKEY$: LOOP UNTIL Exitk$ <> "": GOTO GetFILETYPE3
GetFILETYPE2:   FType$ = RTRIM$(Xinput$(StrtRow% + CrrScrnRow%, 65, 7, FType$, Allowed$, Endk$, Exitk$, RealStrLen%))
		IF Exitk$ = CHR$(27) OR Sel.CpyMark = " " OR TogLonName% = -1 THEN GOTO GetFILETYPE3
		FType$ = UCASE$(FType$)
		SELECT CASE FType$
		CASE "DIS/VAR"       ' DIS VAR
		A$ = "V"
		CASE "DIS/FIX"       ' DIS FIX
		A$ = "F"
		CASE "INT/VAR"       ' INT VAR
		A$ = "v"
		CASE "INT/FIX"       ' INT FIX
		A$ = "f"
		CASE "PROGRAM"       ' PROGRAM
		A$ = "P"
		CASE ELSE
		A$ = ""
		END SELECT
		IF A$ = "" THEN BEEP: GOTO GetFILETYPE2
		Sel.DTyp = A$
		PUT #5, CrrntFilename% + 1, Sel
GetFILETYPE3:   RETURN
		
' Input Record Length
GetFILELEN:     LOCATE StrtRow% + CrrScrnRow%, 75, 1
		IF TogLonName% = -1 THEN DO: Exitk$ = INKEY$: LOOP UNTIL Exitk$ <> "": GOTO GetFILELEN3
		IF Sel.DTyp = "P" OR Sel.CpyMark = " " OR TogLonName% = -1 THEN Flen$ = "   ": GOTO GetFILELEN2
		Flen$ = RTRIM$(LTRIM$(STR$(ASC(Sel.DLen))))
		
GetFILELEN2:    Flen$ = LTRIM$(RTRIM$(Xinput$(StrtRow% + CrrScrnRow%, 75, 3, Flen$, Number$, Endk$, Exitk$, RealStrLen%)))
		IF Exitk$ = CHR$(27) OR Sel.CpyMark = " " OR TogLonName% = -1 THEN GOTO GetFILELEN3
		
		IF Sel.DTyp = "P" THEN Flen$ = CHR$(0)
		IF ABS(VAL(Flen$)) > 255 THEN BEEP: GOTO GetFILELEN2
		Sel.DLen = CHR$(VAL(Flen$))
GetFILELEN3:    RETURN


' Display Current Row
DsplRow:
		LOCATE StrtRow% + CrrScrnRow%, 1, 1
		GET #5, CrrntFilename% + 1, Sel
		PRINT "";
		IF Sel.CpyMark <> "N" THEN PRINT Sel.CpyMark;  ELSE PRINT " ";
		PRINT "";
		PRINT USING "###"; CrrntFilename%;
		PRINT ""; LEFT$(Sel.SL, 44);
		IF Sel.CpyMark = " " THEN PRINT SPACE$(28); : GOTO DsplRowEnd
		IF TogLonName% = -1 THEN PRINT MID$(Sel.SL, 45, 23); SPACE$(5); : GOTO DsplRowEnd ELSE PRINT TAB(52); Sel.TINAME; "  ";
		'PRINT TAB(52); Sel.TINAME; "  ";
		
		Flen% = 0
		SELECT CASE Sel.DTyp
		CASE "V"       ' DIS VAR
		FType$ = "DIS/VAR": Flen% = ASC(Sel.DLen)
		CASE "F"       ' DIS FIX
		FType$ = "DIS/FIX": Flen% = ASC(Sel.DLen)
		CASE "v"       ' INT VAR
		FType$ = "INT/VAR": Flen% = ASC(Sel.DLen)
		CASE "f"       ' INT FIX
		FType$ = "INT/FIX": Flen% = ASC(Sel.DLen)
		CASE IS = " "  '
		FType$ = "INT/FIX": Flen% = 128
		CASE "P"       ' PROGRAM
		FType$ = "PROGRAM"
		END SELECT
		Flen$ = RTRIM$(LTRIM$(STR$(Flen%)))
		IF Sel.DTyp = "P" THEN Flen$ = " "
		LOCATE StrtRow% + CrrScrnRow%, 65
		PRINT FType$; "   "
		LOCATE StrtRow% + CrrScrnRow%, 75
		PRINT Flen$; "  " + SPACE$(3 - LEN(Flen$));
DsplRowEnd:
		LOCATE StrtRow% + CrrScrnRow%, 80
		PRINT TAB(80); "";
		
		LOCATE StrtRow% + CrrScrnRow%, CursrPos%, 1
		RETURN


RstoreColor:    TmpScreenRow% = CrrScrnRow%
		TmpFilename% = CrrntFilename%
		CrrScrnRow% = OwldScreenRow%
		CrrntFilename% = OwldFilename%
		COLOR 14, 0: GOSUB DsplRow ' Display Crrent Row
		CrrScrnRow% = TmpScreenRow%
		CrrntFilename% = TmpFilename%
		RETURN

ViewFiles2Copy: ' Display total files to be copied
		
		LOCATE 3, 24
		PRINT RTRIM$(LTRIM$(STR$(TotDirs%)));
		LOCATE 3, 33, 1
		PRINT RTRIM$(LTRIM$(STR$(OldTotFnames%)));
		LOCATE 3, 42, 1
		PRINT RTRIM$(LTRIM$(STR$(OldTotSize&)));
		RETURN


'=================================
' DISPLAY TOP PART OF TITLE SCREEN
'=================================
TopScrn:        CLS
		PRINT "=========  ASSIGN TI-99/4A FILE TYPE AND FILENAME TO COLLECTED FILES  =========="
		PRINT "Ŀ"
		'PRINT "  n.DOS Fname DIRs=   Files=     Size=          TI Filename   Type   RecLen "
		PRINT "  n.DOS Fname DIRs=   Files=     Size=           12                         "
		PRINT "Ĵ"
		GOSUB TINameWinName
		GOSUB ViewFiles2Copy
		RETURN

TINameWinName:  LOCATE 3, 52, 1
		IF TogLonName% = 1 THEN PRINT "TI Filename   Type   RecLen" ELSE PRINT "DOS Long Filename          "
		LOCATE 5, 1, 1
		RETURN
		
BottmLine:
		PRINT
		PRINT ""
		LOCATE 22, 1
		PRINT " Keys: TAB=Change Field, CTRL+PageUp,+PageDwn=Change FileType, F5=Long Filenames"
		PRINT TAB(18); " Arrow+Up,+Dwn, Page+Up,+Dwn=Change File"
		PRINT TAB(5); " F6=Proceed, F1=Help, F7= File Hex Sector Viewer, F8= Cat ARK File.";


		LOCATE StrtRow% + CrrScrnRow% + 1, 1, 1

		IF CrrScrnRow% > TotlScrnRows% THEN GOTO SkpClear ' Blank all unused screen rows, if any

		FOR V = CrrScrnRow% TO TotlScrnRows%
		PRINT "                                                                                "
		NEXT V
SkpClear:
		RETURN

'=========================
' REDRAW THE ENTIRE SCREEN
'=========================
NewPaintScreen:
		COLOR 14, 0
		GOSUB TopScrn ' Display Top Part of Title Screen
PntScrShort:    COLOR 14, 0
		SaveCrrFilename% = CrrntFilename%
		SaveCrrScreenRow% = CrrScrnRow%
		CrrntFilename% = FstFilename%
		FOR CrrScrnRow% = 1 TO TotlScrnRows%
		GOSUB DsplRow  ' Display Crrent Row
		CrrntFilename% = CrrntFilename% + 1 ' Next Filename
		LstScrnRow% = CrrScrnRow%      ' Save last Screen Row used
		IF CrrntFilename% > PntLastUsed% - 1 THEN CrrScrnRow% = CrrScrnRow% + 1: GOTO NewPaintScreen2
		NEXT CrrScrnRow%   ' Next Screen Row
NewPaintScreen2:
		GOSUB BottmLine        ' Display Bottom Line
		CrrntFilename% = SaveCrrFilename%
		CrrScrnRow% = SaveCrrScreenRow%
		COLOR 0, 7: GOSUB DsplRow
		RETURN
'=====================================
' GO TO THAT LINE
' ====================================
GoToThatLine:
		GOSUB RstoreColor
		COLOR 7, 0
		LOCATE StrtRow% + CrrScrnRow%, 2, 1
		COLOR 0, 7
		GOSUB DsplRow:
		LOCATE StrtRow% + CrrScrnRow%, 2, 1
		OwldScreenRow% = CrrScrnRow%
		OwldFilename% = CrrntFilename%
		
		RETURN

'======================
' START COPY FILES
'======================
' ENTER key pressed
StrtCopying:
		CALL box(9, 20, 50, 5)
         	LOCATE 11, 22
		PRINT " Ready to go ahead with Importing? (Y/N) ";
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		PRINT K$;
		IF UCASE$(K$) = "Y" OR K$ = CHR$(13) OR K$ = CHR$(0) + CHR$(64) THEN GOTO StrtCopying2
		
NoCopying:      GOSUB NewPaintScreen
		GOTO KeineMatch
		
StrtCopying2:   FOR CrrntFilename% = 2 TO PntLastUsed%
		GET #5, CrrntFilename%, Sel
		IF Sel.CpyMark = "K" THEN GOTO StrtCopying3  ' "K" File to be ARKed found
		NEXT CrrntFilename%
		GOTO GoGeIt
StrtCopying3:		
		ON ERROR GOTO StrtCopying4
		OPEN "ARKNAME.DEF" FOR INPUT AS #99   ' Avoid creation of file is file doesn't exist
		IF EOF(99)<> 0 THEN GOTO StrtCopying6
		LINE INPUT #99, TIArkFilName$
		IF EOF(99)<> 0 THEN GOTO StrtCopying7
		LINE INPUT #99, Compression$
		
		IF LTRIM$(RTRIM$(TIArkFilName$))="" THEN GOTO StrtCopying6
		IF LTRIM$(RTRIM$(Compression$))="" THEN GOTO StrtCopying7
		GOTO StrtCopying9
		
StrtCopying4:   RESUME StrtCopying6
StrtCopying6:	TIArkFilName$="ARKFILE"
StrtCopying7:   Compression$="C" 	' C= Compressed, U=Uncompressed
StrtCopying9:   CLOSE #99
		ON ERROR GOTO 0		
		
		CALL box(4, 14, 60, 19)
		LOCATE 6, 20 : PRINT "An ARK TI file will be created, collecting"
		LOCATE 7, 20 : PRINT "all the files you marked with a ";CHR$(34);"K";CHR$(34);" character."
		LOCATE 9, 20 : PRINT "Please type in the TI name you want to give it: "
		
		
StrtCopying21:  A$ = LTRIM$(RTRIM$(Xinput$(11, 20, 10, TIArkFilName$, Allowed$, CHR$(13) + CHR$(27) + CHR$(0) + CHR$(64) + CHR$(0) + CHR$(80) , Exitk$, RealStrLen%)))
		IF Exitk$=CHR$(27) THEN GOTO GOABORT
		A$ = RTRIM$(LTRIM$(A$)) 
		IF LEN(A$) = 0 THEN GOTO StrtCopying21 ELSE TIArkFilName$=A$
		TIArkFilName$=LEFT$(TIArkFilName$,10)
		IF LEN(TIArkFilName$)< 10 THEN TIArkFilName$=TIArkFilName$ + SPACE$(10-LEN(TIArkFilName$))
		 
		LOCATE 13, 20 : PRINT ""
		LOCATE 15, 20 : PRINT "Now choose the type of ARK file you want:"
		LOCATE 17, 28 : PRINT "C = Compressed"
		LOCATE 18, 28 : PRINT "U = Uncompressed"
		LOCATE 20, 28 : PRINT "Your choice: (C/U) ";Compression$
		
		LOCATE 20, 47
UnKomp:		DO: K$ = UCASE$(INKEY$): LOOP UNTIL K$ <> ""
		IF K$=CHR$(27) THEN GOTO GOABORT
		IF K$=CHR$(0) + CHR$(72) THEN GOTO StrtCopying21 ' Arrow Up
		IF K$=CHR$(13) OR K$=CHR$(0) + CHR$(64) THEN GOTO DefaultSelect
		IF K$= "C" OR K$= "U" THEN Compression$ = K$ : GOTO DefaultSelect
		GOTO UnKomp
		
DefaultSelect:	OPEN "ARKNAME.DEF" FOR OUTPUT AS #99   
		PRINT #99, TIArkFilName$
		PRINT #99, Compression$
		CLOSE #99

GoGeIt:		GOTO Leaveit
GOABORT:	CLOSE #5 
		GOTO ABORT
		

'===============================================
' CALCULATE CURRENT ENTRY IN CHAIN POINTER TABLE
'===============================================
' The second 3 nibble block contains the highest OFFSET within each Chain Block.
' This value must never be higher than SectorCnt% - 1, which is the file total length - 2,
' as it appears on Disk Catalog.
' This corrects the bug on 80 track disks, that have the last second 3 nibble block wrong on
' ODD LENGTH FILES (1 sector longer).
' If not corrected, this bug would create an error on lower size disks.

CalcClusters:
		A = ASC(MID$(FHeader$, 28 + 1 + Z, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z, 1))
		BA% = B MOD 16
		BB% = INT(B / 16)
		StSec% = BA% * 256 + A
		IF TotSect% > 3000 THEN StSec% = StSec% * 4
		Offs% = C * 16 + BB
		IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		OffsVal% = 0               ' Offset in EACH Input  File Chain Pointer Block
		
		GOTO CalcClustend      ' Skip the below check, which has been superseeded by the simpler
		' above approach:  IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		' Nonetheless, I leave it where it is because it might be still needed for some
		' 80 track disks that have a wrong file length, besides having
		' a wrong chain point table length.
		
' 
' Special case: in a 80 track Double Side Disk, when file length is EVEN (SectorLength# in my code), the
' Chain Point Table reports 1 sector more than what it should. When copying, we have to use avoid using
' that extra sector. Method: always check if there is a next Data Chain. If there is, do nothing. Otherwise,
' that means we are are the end of the Data Chain, and we have to use a sector less.
' SectorLength#
		
		
		IF Dens% < 2 OR Tracks < 80 THEN GOTO CalcClustend
		IF SectorLength# <> (INT(SectorLength# / 2)) * 2 THEN GOTO CalcClustend
		A = ASC(MID$(FHeader$, 28 + 1 + Z + 3, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z + 3, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z + 3, 1))
		IF A <> 0 OR B <> 0 OR C <> 0 THEN GOTO CalcClustend
		Offs% = Offs% - 1
CalcClustend:
		
		RETURN
		
'===========================
' AVOID DUPLICATED FILENAMES
' ==========================
AvoidDupNam:    UF% = CrrntFilename%
		AL1$ = ""
AvoidDupNames:  FOR KK% = ActiveDirs% + 1 TO PntLastUsed% - 1
		
		GET #5, KK% + 1, Sel
		IF Sel.CpyMark = " " OR KK% = CrrntFilename% THEN GOTO AvoidDupNamesb
		IF RTRIM$(OutRec$) <> RTRIM$(Sel.TINAME) THEN GOTO AvoidDupNamesb
		AL1$ = "Y": BEEP

		CALL IncName(OutRec$, B$): IF B$ = "" THEN GOTO AvoidDupNames
		
		GOSUB RstoreColor
		COLOR 7, 0
		'CrrntFilename% = UF%
		'CrrScrnRow% = 2     ' Cursor on second screen row
		'FstFilename% = UF% - 1: IF FstFilename% <= ActiveDirs% + 1 THEN FstFilename% = UF%: CrrScrnRow% = 1
		'GOSUB NewPaintScreen

		COLOR 0, 7
		'GOSUB DsplRow
		'LOCATE StrtRow% + CrrScrnRow%, 2, 1
		'OwldScreenRow% = CrrScrnRow%
		BEEP
		LOCATE StrtRow% + CrrScrnRow%, 65, 1: PRINT "is Dupl. of"; KK%;
		' WHILE INKEY$ = "": WEND
		OutRec$ = UCASE$(RTRIM$(Xinput$(StrtRow% + CrrScrnRow%, 52, 10, OutRec$, Allowed$, Endk$, Exitk$, RealStrLen%)))
		
		GOSUB RstoreColor
		COLOR 7, 0
		GOTO AvoidDupNames
AvoidDupNamesb: NEXT KK%
		CrrntFilename% = UF%
		GET #5, CrrntFilename% + 1, Sel
		IF AL1$ = "Y" THEN GOSUB NewPaintScreen
		RETURN
		
' SOLVE ALL DUPLICATED NAMES      
NoDupNames:  
		FOR CrrntFilename% = ActiveDirs% + 1 TO PntLastUsed% - 1
		GET #5, CrrntFilename% + 1, Sel
		'IF Sel.CpyMark = " "  THEN GOTO SolveCrrntNxt
		LOCATE 4, 1
		PRINT CrrntFilename%; Sel.TINAME; SPACE$(70 - LEN(FileSect$))
		OutRec$ = RTRIM$(Sel.TINAME)
SolveDupNames:  FOR KK% = ActiveDirs% + 1 TO PntLastUsed% - 1
		
		GET #5, KK% + 1, Sel
		IF Sel.CpyMark = " " OR KK% = CrrntFilename% THEN GOTO SolveDupNxt
		IF OutRec$ <> RTRIM$(Sel.TINAME) THEN GOTO SolveDupNxt
  
		CALL IncName(Sel.TINAME, B$): PUT #5, KK% + 1, Sel: GOTO SolveDupNames
SolveDupNxt:    NEXT KK%
SolveCrrntNxt:  NEXT CrrntFilename%
		RETURN

'==SUBARK START===============================================================        
' Create TEMP Ark File. Extract ArkFile, extract the needed file from it and
' feed it to ShowDOSSector.
'
GetSUBArk:      ToShow$ = Mystring$ + SPACE$(10 - LEN(Mystring$))
		FileSect$ = A$ + SArkFilName$
		CALL ShortName(FileSect$): IF FileSect$ = "" THEN GOTO GetSUBArkErr
		Exec$ = "Decomp4.com " + FileSect$ + " ~tmpfile.tmp >NULL"
		SHELL Exec$
		
		OPEN "~tmpfile.tmp" FOR RANDOM ACCESS READ AS #7 LEN = 256
		Sectors2Skip = 0: ArkRecord = 0
		TmpFileSects% = 0' Count of Temporary File Sectors
		ArkRecord = 0
		
		FIELD #7, 256 AS Kd$
		' Search Filename in SubArkFile
		WHILE NOT EOF(7)
		ArkRecord = ArkRecord + 1
		GET #7, ArkRecord
		FOR KT = 1 TO 14 * 18 STEP 18
		TmpFileSects% = CalcWord(Kd$, KT + 12)
		IF MID$(Kd$, KT, 10) = ToShow$ THEN GOTO TxferArk10
		Sectors2Skip = Sectors2Skip + TmpFileSects%
		NEXT KT
		WEND
		CLOSE #7: KILL "~tmpfile.tmp": GOTO GetSUBArkErr
		
TxferArk10:     ON ERROR GOTO TxferArk12
		KILL "~subark.tmp"
		GOTO TxferArk14
		
TxferArk12:     RESUME TxferArk14
TxferArk14:     ON ERROR GOTO 0
		OPEN "~subark.tmp" FOR BINARY ACCESS WRITE AS #82
		BytePos& = 1  ' Start of TmpFilName$
		TotRec% = 0
		
		' Search the first sector with Data (first sector after "END!" End of File Table Marker)
		IF MID$(Kd$, 253, 4) = "END!" THEN GOTO TxferArk20
		WHILE NOT EOF(7)
		GET #7: ArkRecord = ArkRecord + 1
		IF MID$(Kd$, 253, 4) = "END!" THEN GOTO TxferArk20
		WEND
		PRINT : PRINT "Error. END! (End of Files Marker) not found for SubArk File " + SArkFilName$ + "  inside " + CurrArk$ + " ARK file!": INPUT CCC$
		GOTO TxferArk60

TxferArk20:    ' Actually extract SubArkFile Data
		ArkRecord = ArkRecord + Sectors2Skip
		FOR KT = 1 TO TmpFileSects%
		GET #7, ArkRecord + KT
		PUT #82, BytePos&, Kd$: BytePos& = BytePos& + 256
		NEXT KT
		GOTO TxferArk60

TxferArk40:     PRINT : PRINT "Error. Sub Ark File " + SArkFilName$ + " not found inside " + CurrArk$ + " ARK file!": INPUT CCC$
		CLOSE #7:   GOTO GetSUBArkErr
TxferArk60:     CLOSE #82: Mystring$ = "~subark.tmp":
		CLOSE #7
		P = 0
		GOTO GetSUBArkEnd
GetSUBArkErr:   P = 1
GetSUBArkEnd:   RETURN
		
'==SUBARK END=================================================================        


		
'========SHOW SECTORS - ADD START
ShowSector:     CALL box(8, 3, 76, 13)
		LOCATE 8, 30: COLOR 0, 7: PRINT " - HEX SECTOR VIEWER - "; : COLOR 7, 0
		GET #1, StartSect%(CrrntFilename%) + 1
		FHeader$ = d$
		LOCATE 9, 5:  PRINT "File: "; MID$(FHeader$, 1, 10); "-Length:"; CalcWord(FHeader$, 15);
		SectorCnt% = CalcWord(FHeader$, 15)
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		Z = 0                      ' Offset in Input File Chain Pointer Block
		K$ = "Y"
ShowSector2:
		GOSUB CalcClusters
		IF StSec% > 0 THEN GOTO ShowSector3
		LOCATE 19, 30: PRINT " = End of File =";
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		IF K$ = CHR$(27) THEN GOTO ShowSectorEnd
		
ShowSector3:
		IF GlobalInpOffset% > Offs% THEN Z = Z + 3: GOTO ShowSector2
		GET #1, StSec% + OffsVal% + 1

		LOCATE 9, 35: PRINT " -This Skt: "; StSec% + OffsVal%; " >"; HEX$(StSec% + OffsVal%); " - Skt Off.:"; GlobalInpOffset%;

		CALL ShowHex(d$, K$)
		IF K$ = CHR$(27) THEN GOTO ShowSectorEnd
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO ShowSector4
		IF GlobalInpOffset% > 0 THEN K$ = ""
		IF GlobalInpOffset% = 0 THEN GOTO ShowSector3
		GlobalInpOffset% = GlobalInpOffset% - 1
		OffsVal% = OffsVal% - 1
		IF OffsVal% < 0 THEN Z = Z - 3: GOTO ShowSector2
		GOTO ShowSector3
ShowSector4:
		OffsVal% = OffsVal% + 1           ' Offset in EACH Input  File Chain Pointer Block
		GlobalInpOffset% = GlobalInpOffset% + 1
		GOTO ShowSector3
		
ShowSectorEnd:
		RETURN

'========SHOW SECTORS - ADD END


DEFINT A-Z

SUB box (Y, X, W, H)

		' Call Box(StartRow, StartColumn, Width, Hight)
		' Y=StartRow,X=StartColumn; W=Width,H=Hight)
		LOCATE Y, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";
		
		FOR V = 1 TO H - 2
		LOCATE Y + V, X
		PRINT ""; TAB(X + W - 1); : PRINT "";
		NEXT V
		
		LOCATE Y + H - 1, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";
		

END SUB

DEFSNG A-Z
FUNCTION CalcWord (A$, P%)
		IF LEN(A$) < P% + 1 THEN INPUT "Wrong String in CalcWord Subroutine", C$: V% = 0: GOTO CalcWord1
		B1% = ASC(MID$(A$, P%, 1))
		B2% = ASC(MID$(A$, P% + 1, 1))
		V% = (B1% * 256) + B2%
CalcWord1:      CalcWord = (V%)
END FUNCTION

'================================
' Get valid DOS filename from a filename of the kind "FILE   ARK"
'================================
SUB Canonize (A$)
		A$ = Shrink(A$)
		P = INSTR(A$, " ")
		IF P > 0 THEN MID$(A$, P) = "."
END SUB

DEFINT A-Z
FUNCTION DoAway$ (Strig$, Char$)
		A$ = ""
		FOR T = 1 TO LEN(Strig$): C$ = MID$(Strig$, T, 1): IF C$ = Char$ THEN GOTO prossimo
		A$ = A$ + C$
		
prossimo:
		NEXT T
		DoAway$ = A$

END FUNCTION

SUB ERRSOUND
		SOUND 110, 4

END SUB

SUB Fischio
		IF MyVal(1) = 0 THEN EXIT SUB
		FOR i% = 3000 TO 4000 STEP 200
		SOUND i%, .1  'i% / 1000
		NEXT i%
		
END SUB

DEFSNG A-Z
'=====================================================
' INCREMENT A  FILENAME, TO AVOID DUPLICATED FILENAMES
'=====================================================
SUB IncName (A$, B$)
		
		A$ = RTRIM$(A$)
		P = INSTR(A$, ".")
		IF P > 0 THEN P = P - 1 ELSE P = LEN(A$) - 1
		C = ASC(UCASE$(MID$(A$, P, 1)))
		IF C = ASC("9") THEN C = ASC("A"): GOTO IncName6
		IF C >= ASC("0") AND C <= ASC("9") THEN C = C + 1: GOTO IncName6
		IF C = ASC("Z") THEN C = ASC("_"): GOTO IncName6
		IF C >= ASC("A") AND C <= ASC("Z") THEN C = C + 1: GOTO IncName6
		Replace$ = "_-#@`^~{}"
		P2 = INSTR(Replace$, CHR$(C))
		IF P2 = LEN(Replace$) THEN B$ = "X": GOTO IncName7
		C = ASC(MID$(Replace$, P2 + 1, 1))

IncName6:       MID$(A$, P, 1) = CHR$(C): B$ = ""

IncName7:
END SUB

SUB ShortName (A$)
' Get short filename (8.3 characters)
		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT7160.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO ShortName2
		LINE INPUT #71, A$
ShortName2:     CLOSE #71
		KILL "--"
ShortNameEnd:
END SUB

DEFINT A-Z
SUB ShowDOSSector (FileSect$, ToShow$)
		
		CALL box(8, 3, 76, 13)
		LOCATE 8, 30: COLOR 0, 7: PRINT " - HEX SECTOR VIEWER - "; : COLOR 7, 0
		CALL ShortName(FileSect$): IF FileSect$ = "" THEN GOTO ShowDOSSectorEnd' Get Short Filename (8.3 characters)
		
		OPEN FileSect$ FOR BINARY ACCESS READ SHARED AS #6
		REDIM DSEC(1) AS STRING * 512
		tlen& = LOF(6)
		BytePos& = 1
		SectorCnt& = tlen& / 512
		GET #6, 1, DSEC(1)
		LOCATE 9, 5:  PRINT "File: "; ToShow$; " -Length:"; INT((tlen& / 512) + 1);
		K$ = "Y"
		
ShowDOSSector2: LOCATE 19, 30: PRINT "                ";
		IF BytePos& < tlen& THEN GOTO ShowDOSSector3
		BytePos& = BytePos& - (512): IF BytePos& < 1 THEN BytePos& = 1
		K$ = ""
		LOCATE 19, 30: PRINT " = End of File =";
		DO: KUK$ = INKEY$: LOOP UNTIL KUK$ <> ""
		IF KUK$ = CHR$(27) THEN GOTO ShowDOSSectorEnd
		
ShowDOSSector3:
		GET #6, BytePos&, DSEC(1):  BytePos& = BytePos& + 512

		LOCATE 9, 50: PRINT " - Sect.Offset: "; (BytePos& - 1) / 512; " >"; HEX$((BytePos& - 1) / 512);
		CALL ShowHex(DSEC(1), K$)
		IF K$ = CHR$(27) THEN GOTO ShowDOSSectorEnd
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO ShowDOSSector2
		K$ = ""
		BytePos& = BytePos& - (512 * 2)
		IF BytePos& < 1 THEN BytePos& = 1: K$ = "Y"
		GOTO ShowDOSSector2
		
ShowDOSSectorEnd:
		CLOSE #6
END SUB

SUB ShowHex (A$, K$)
' This is simply to help during debugging
' Syntax: CALL ShowHex(A$,K$) ' A$ usually contains an entire TI Sector (256 bytes)
		Col% = 3
		B$ = ""
		FOR T = 1 TO LEN(A$)
		C$ = HEX$(ASC(MID$(A$, T, 1))): IF LEN(C$) = 1 THEN C$ = "0" + C$
		B$ = B$ + C$ + " "
		NEXT T
		
		LOCATE 10, Col% + 2
		PRINT "Addr. 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ";
		
		IF K$ = "" THEN T = LEN(B$) - (8 * 16 * 3 - 1) ELSE T = 1
'===============LOOP STARTS HERE
		
Repeat:
		T$ = MID$(B$, T, 16 * 3)
		LOCATE 10 + 1 + Row%, Col% + 2:
		H$ = HEX$(T / 3): IF LEN(H$) = 1 THEN H$ = "0" + H$
		IF LEN(H$) = 2 THEN H$ = "0" + H$
		PRINT USING "\  \"; H$;
		LOCATE 10 + 1 + Row%, Col% + 5
		PRINT " - "; T$;
		PRINT "  ";
		FOR J = 1 TO 16
		J$ = MID$(A$, (T - 1) / 3 + J, 1)
		IF ASC(J$) < 32 OR ASC(J$) > 126 THEN PRINT " ";  ELSE PRINT J$;
		
		NEXT J
		
		Row% = Row% + 1: IF Row% < 8 THEN GOTO NextRow ELSE Row% = 0
		'LOCATE 21, 1: PRINT LEN(B$)
		'LOCATE 22, 1: PRINT T
		'LOCATE 23, 1: PRINT (T - 1) / (3 * 16)
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO GEXIT
		
		' Arrow Down
		IF K$ <> CHR$(0) + CHR$(80) THEN GOTO ArrowUPkey
		T = T - (16 * 3 * 6): IF T < 1 THEN T = 1
		GOTO Repeat
		
ArrowUPkey:      ' Arrow UP
		IF K$ <> CHR$(0) + CHR$(72) AND K$ <> CHR$(0) + CHR$(73) THEN GOTO NextRow
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO PageUPKey
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 8): IF T < 1 THEN T = 1
		GOTO Repeat
PageUPKey:
		' Page UP
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 15): IF T < 1 THEN T = 1
		GOTO Repeat

NextRow:
		T = T + (16 * 3)
		IF T < LEN(B$) THEN GOTO Repeat
		K$ = "Y"
'===============LOOP ENDS HERE
GEXIT:
END SUB

FUNCTION Shrink$ (In$)
		A$ = "": c1$ = " "
		FOR T = 1 TO LEN(In$): C$ = MID$(In$, T, 1): IF C$ = " " AND c1$ = " " THEN GOTO SKIP
		A$ = A$ + C$: c1$ = C$
SKIP:
		NEXT T
		A$ = LTRIM$(RTRIM$(A$))
		Shrink$ = A$
END FUNCTION

DEFSNG A-Z
SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
		GOTO GetHelp

' Will use Chapter 7 from help file "Manual.dat", indexed in "Manual.idx" file.
' Because of MS QBasic quirks, GetIDX routine has to be placed before the rest of the code.
'
' Get .IDX file values into an array, that is,
' Get Array Parameters from Index (IDX) file
GetIDX:
		
		OPEN IDXFile$ FOR RANDOM ACCESS READ AS #3 LEN = LEN(IDXRecord)
		GET #3, , IDXRecord
		TLines% = IDXRecord.StartRec' First record is special: total records that follow
		
		
		REDIM IDXSect$(TLines%)
		REDIM IdxStart(TLines%)
		REDIM IdxLength(TLines%)
		FOR T = 1 TO TLines%
		GET #3, , IDXRecord
		IDXSect$(T) = LTRIM$(IDXRecord.Section)
		IdxStart(T) = IDXRecord.StartRec
		IdxLength(T) = IDXRecord.RecLength
		IDXSect$(T) = LTRIM$(RTRIM$(IDXSect$(T)))
		NEXT T
		CLOSE #3
		
		RETURN
		

GetHelp:        CLS
		LOCATE 1, 26: PRINT Banner$
		InizRw% = 2
		TotScrRws% = 12
		CurrScrRw% = 1
		
		GOSUB RedrawBox
		GOSUB GetIDX
		FOR Arg% = 1 TO TLines%
		IF Argum$ = IDXSect$(Arg%) THEN GOTO ArgFnd
		NEXT Arg%
		Arg% = 1
		
ArgFnd:         CurntLine% = Arg%
		RcLen% = 77 + 2
		OPEN DatFile$ FOR RANDOM ACCESS READ AS #59 LEN = RcLen%
		FIELD #59, RcLen% - 2 AS DL$
		FIELD #59, 2 AS CRLF$
		
'===================================
' MAIN LOOP STARTS HERE
'===================================
NextLineName:
		COLOR 7, 0
		
		IF CurrScrRw% = 1 THEN FstLine% = CurntLine%   ' Get Number of first Line only
		GOSUB DisplayRw
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		CurrScrRw% = CurrScrRw% + 1  ' Next Screen Row
		IF CurrScrRw% < TotScrRws% + 1 AND CurntLine% <= TLines% THEN GOTO NextLineName
'===================================
' MAIN LOOP ENDS HERE
'===================================
'
		GOSUB BotLine              ' Clear Unused Bottom Lines
		LastLine% = CurntLine% - 1
		CurntLine% = FstLine%  ' Current Line is now first Line in screen
		
		CurrScrRw% = 1
		IF KeepCursBot% = 0 THEN GOTO LocCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last Line in Screen
		CurrScrRw% = TotScrRws%: KeepCursBot% = 0: CurntLine% = LastLine%
		GOTO LocCursor2
		
LocCursor:
		GOSUB HeRestColor

LocCursor2:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		COLOR 0, 7: GOSUB DisplayRw: COLOR 7, 0 ' Display Current Row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		OldScrRw% = CurrScrRw%
		OldLine% = CurntLine%
		IF GoToThisDir% <> 0 THEN CurntLine% = GoToThisDir%: GoToThisDir% = 0: GOTO Exekit
		'GOSUB ShowValues    ' My little Debugger
		
		
DoHeAgain:      GOSUB GetChar

		' IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO DoHeAgain

		' ESCape Key
		IF UH$ = CHR$(27) THEN GOTO HAbort
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO IsArrDown
EnterKey:       CALL Fischio
		GOSUB ThisSect
		GOSUB RePaintHelp
		GOTO NMatch

IsArrDown:     ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO OthKey0
		IF CurrScrRw% < LastScrRw% THEN CurrScrRw% = CurrScrRw% + 1: CurntLine% = CurntLine% + 1: GOTO LocCursor
		IF CurntLine% = TLines% THEN GOTO LocCursor
		CurntLine% = FstLine% + 1
		KeepCursBot% = 1
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
OthKey0:         'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO OthKey1
		IF CurntLine% = 1 THEN GOTO NMatch
		IF CurrScrRw% > 1 THEN CurrScrRw% = CurrScrRw% - 1: CurntLine% = CurntLine% - 1: GOTO LocCursor
		CurntLine% = FstLine% - 1: IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
		
OthKey1:         ' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO OthKey2
		CurntLine% = FstLine% - TotScrRws%
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO OthKey7
		IF LastLine% + 1 + TotScrRws% > TLines% THEN CurntLine% = TLines% - TotScrRws% + 1: IF CurntLine% < 1 THEN CurntLine% = 1: GOTO Exekit
		CurntLine% = FstLine% + TotScrRws%
		IF CurntLine% > TLines% THEN CurntLine% = FstLine%
		GOTO Exekit
		
OthKey7:         ' Home Key : simply move cursor to top
		IF UH$ <> CHR$(0) + CHR$(71) THEN GOTO OthKey8
		CurrScrRw% = 1: CurntLine% = FstLine%: GOTO LocCursor

OthKey8:         ' End Key : simply move cursor to bottom
		IF UH$ <> CHR$(0) + CHR$(79) THEN GOTO OthKey9
		CurrScrRw% = LastScrRw%: CurntLine% = LastLine%
		GOTO LocCursor
		
OthKey9:        ' F3 = Show Error List
		IF UH$ <> CHR$(0) + CHR$(61) THEN GOTO OthKey10
		GOSUB RePaintHelp
		GOTO NMatch

OthKey10:       ' F7 = Show Sector as Hex
		IF UH$ <> CHR$(0) + CHR$(65) THEN GOTO OthKey11
		GOSUB RePaintHelp
		GOTO NMatch
		
OthKey11:       'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO OthKey13
		GOTO EnterKey

OthKey13:
		GOTO NMatch


Exekit:         CurrScrRw% = 1     ' Cursor on first screen row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GOTO NextLineName   ' Start next round

NMatch:         GOTO LocCursor
		
RePaintHelp:
		GOSUB RedrawBox
		SaveCurrLine% = CurntLine%
		SavCurrScrRw% = CurrScrRw%
		CurntLine% = FstLine%
		FOR CurrScrRw% = 1 TO TotScrRws%
		GOSUB DisplayRw  ' Display Current Row
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		IF CurntLine% > TLines% THEN CurrScrRw% = CurrScrRw% + 1: GOTO RePaintHelp2
		NEXT CurrScrRw%   ' Next Screen Row
		
RePaintHelp2:
		
		CurntLine% = SaveCurrLine%
		CurrScrRw% = SavCurrScrRw%
		RETURN

HeRestColor:    TempScreenRw% = CurrScrRw%
		TempLine% = CurntLine%
		CurrScrRw% = OldScrRw%
		CurntLine% = OldLine%
		COLOR 7, 0: GOSUB DisplayRw ' Display Current Row
		CurrScrRw% = TempScreenRw%
		CurntLine% = TempLine%
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRw:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GET #59, IdxStart(CurntLine%)
		TL$ = DL$
		FOR T = 1 TO LEN(TL$): IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO StrtFound
		NEXT T
StrtFound:      TL$ = RIGHT$(TL$, LEN(TL$) - T + 1)
		
		FOR T = LEN(TL$) TO 1 STEP -1: IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO EndFnd
		NEXT T
EndFnd:         TL$ = LEFT$(TL$, T)
		PRINT IDXSect$(CurntLine%); TAB(12); TL$; SPACE$(79 - 12 - LEN(TL$));
		RETURN
		
'====================
' CLEAR BOTTOM LINES
'====================
BotLine:
		
		LOCATE InizRw% + CurrScrRw%, 2, 1

		IF CurrScrRw% >= TotScrRws% THEN GOTO HlpClear ' Blank all unused screen rows, if any

		FOR V = CurrScrRw% TO TotScrRws%
		LOCATE InizRw% + V, 2, 1
		PRINT "                                                                              "
		NEXT V
		
HlpClear:       LOCATE 23, 1: PRINT "Enter=Get Doc. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		RETURN
		
' Create Box
RedrawBox:      CALL box(2, 1, 80, TotScrRws% + 2)
		RETURN
Pranyk:

		PRINT "                         - press any key to return -"
		GOSUB GetChar
		RETURN
		
GetChar:
		DO: UH$ = INKEY$: LOOP UNTIL UH$ <> ""
		RETURN


ThisSect:       TotSectRws% = 19
		SectInizRw% = 2
		SectCurrRw% = 1
		SectStart# = IdxStart(CurntLine%)
		SectCount# = IdxLength(CurntLine%)
		SectCurr# = 0
		Blank$ = SPACE$(78)
		LOCATE 23, 1: PRINT "Enter=Line Down. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		CALL box(2, 1, 80, TotSectRws% + 2)
NewRound:
		FirstRec# = SectCurr#
SectNewLine:
		GET #59, SectStart# + SectCurr#
		LOCATE SectInizRw% + SectCurrRw%, 2, 1
		PRINT DL$;
		SectCurr# = SectCurr# + 1
		LastSectRw% = SectCurrRw%      ' Save last Screen Row used
		SectCurrRw% = SectCurrRw% + 1
		IF SectCurrRw% < TotSectRws% + 1 AND SectCurr# < SectCount# THEN GOTO SectNewLine
		
		FOR V = SectCurrRw% TO TotSectRws%
		LOCATE SectInizRw% + V, 2
		PRINT Blank$;
		NEXT V
		
GetAnother:     GOSUB GetChar
		'IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO GetAnother
		SectCurr# = FirstRec#
		SectCurrRw% = 1
		' ESC Key
		IF UH$ = CHR$(27) THEN GOTO SectExit
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO SectArrowDown
SectEnter:      IF SectCurr# < SectCount# - 6 THEN SectCurr# = SectCurr# + 1
		GOTO NewRound
		
SectArrowDown:  ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO SectKey0
		GOTO SectEnter
		
SectKey0:       'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO SectKey1
		IF SectCurr# > 0 THEN SectCurr# = SectCurr# - 1
		GOTO NewRound
SectKey1:
		' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO SectKey2
SectPageUp:     SectCurr# = SectCurr# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO SectKey11
SectPageDown:   SectCurr# = SectCurr# + TotSectRws%
		IF SectCurr# > SectCount# - TotSectRws% THEN SectCurr# = SectCount# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey11:      'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO SectKey12
		GOTO SectPageDown
		
SectKey12:      'CTRL Page Up
		IF UH$ <> CHR$(0) + CHR$(132) THEN GOTO SectKey13
		GOTO SectPageUp
SectKey13:
		GOTO NewRound
SectExit:
		V = InizRw% + TotScrRws%
		LOCATE V, 1, 1
		IF V >= 22 THEN GOTO DontDoit ' Blank all unused screen rows, if any

		FOR V = V TO 23
		LOCATE V, 1, 1
		PRINT SPACE$(80)
		NEXT V
DontDoit:
		
		RETURN
HAbort:
		CLOSE #59
END SUB

'================================
' ADD .TIG TO A FILENAME
'================================
SUB TIGName (A$)
		A$ = RTRIM$(A$)
		P = INSTR(A$, ".")
		IF P > 0 AND P <= 9 THEN A$ = LEFT$(A$, P - 1): GOTO TIGName2 ELSE IF P > 0 AND P > 9 THEN A$ = LEFT$(A$, 8): GOTO TIGName2
		IF LEN(A$) > 8 THEN A$ = LEFT$(A$, 8)
		
TIGName2:       A$ = A$ + ".TIG"

END SUB

FUNCTION Xinput$ (Row%, Col%, FieldLen%, Default$, AllowCharsMask$, EndingKeys$, ExitKey$, RealStrLen%) STATIC

'Ŀ
'         XINPUT 2.1:  A Powerful Replacement for standard QBasic INPUT       
'                 
'                              First written                                  
'                                   by                                        
'          Frederick Volking, QBNews, Volume  1, Number  3  May 22, 1990      
'                                                                             
'                    ͻ                      
'                             Paolo Bagnaresi                               
'                           Via J.F. Kennedy 17                             
'                      20097 San Donato Milanese (MI)                       
'                                Italy                                      
'                          Tel. ++39-2-514.202                              
'                                                     
'                    e-mail: paolo_bagnaresi@libero.it
'                    ͼ                      
'                                                                             
'          Almost entirely rewritten and deeply enhanced on June 1995         
'                                                                             
' Vers. 2.0 : Some bad bugs corrected on March 1996 (cursor position and      
'             returned string length)                                         
' Vers. 2.1 : May 2000. FieldLen% bug fixed.                                  
'Ĵ
'SYNTAX:Xinput$(Row%,Col%,FLen%,Default$,Allow$,EndKeys$,ExitKey$,RealStrLen%)
'WHERE: Row% & Col% - where input to occur                                    
'         FLen% - Field Length - maximum allowable                            
'         Default$ - Field's beginning default value                          
'         Allow$ - Character Set allowable for input                          
'         EndKeys$ - Keystrokes acceptable for finishing.                     
'            SUCH: [Enter] is CHR$(13)                                        
'                  [Esc] is CHR$(27)                                          
'                  [F1] is CHR$(255)+CHR$(59)                                 
'                  [Ctrl+PgUp] is CHR$(255)+CHR$(132)                         
'                  ... etc                                                    
'         ExitKey$ - The keystroke (from above EndKeys$)                      
'                    which was struck at function end.                        
'         RealStrLen% - The Real String Length, not counting unused space     
'                       at the string end. However, Spaces added manually     
'                       do count!                                             
'  SIMPLEST USE:  A$ = Xinput$(0,0,0,"","","",Any$,RealStrLen%)               
'         Will default to cursor's current row/col, length is                 
'         autoset to right margin, allowable chars are ALL,                   
'         only ending key is [Enter].                                         
'Ĵ
'                                                                             
'   Instructions and enhancements discussion after the end of program         
'                           ***  see below ***                                
'                                                                             
'
'  Discussion 
'
'                 XINPUT program eXtends the standard QBasic INPUT.
'
'     Unlike QB INPUT, XINPUT allows editing a previously created string.
'     This is the strongest feature of Xinput and the very reason why this
'     task was undertaken. I just could not bear any longer the tedious
'     retyping of any string change that was needed in some program
'     I developed through the years.
'     The original routine written by Frederick Volking on QBNews, named
'     ENPUT,  did not alllow a string editing, which is why I felt compelled
'     to rewrite the Volking routine.
'
'     Other valuable features are:
'
'- Exit keys (Xinput terminators) are user selectable, and detectable by caller.
'- All the user allowed keys are also pre-selectable. Caller can create a mask
'  containing the all the keys that the callee will be allowed to use.
'  A low sound will signal hitting an unselected key.
'
'- Insert key remains active until you deselect it by pressing it again.
'- Backspace pressed 8 times at 1st string position reverts you to start string.
'- Screen start position is user selectable.
'- Cursor Up key and Cursor Down key will move you through the rows.
'- Page Up will moves you to first row. Page Down to the last row.
'- CTRL+Home erases all the field from cursor position up to 1st string char.
'- All the standard QB Input features are emulated, including CTRL+End,
'  CTRL+R, CTRL+E, Tab and CTRL+I...
'- Escape key or CTRL+U, if aren't redefined as an exit key, will entirely
'  blank the string field.
'- Source code in plain QBasic is here, waiting for your enhancements.
'  BTW, I would gladly receive your enhancements, if you can send them to my
'  address:                   Paolo Bagnaresi
'                           Via J.F. Kennedy 17
'                      20097 San Donato Milanese (MI)
'                                Italy
'                          Tel. ++39-2-514.202
'                   e-mail: paolo_bagnaresi@libero.it

		SHARED ScreenWidth%, EmptySpaceChar$

' 1 character Key vakues
		CtrlB$ = CHR$(2)         ' Ctrl+ B = Cursor to the word on the left
		CtrlE$ = CHR$(5)         ' Ctrl+ E = Cancel all chars from Cursor Posit. to end
		CtrlF$ = CHR$(6)         ' Ctrl+ F = Cursor to the word on the right
		BackS$ = CHR$(8)         ' Backspace
		Tabul$ = CHR$(9)         ' Tabulator
		CtrlI$ = CHR$(9)         ' Ctrl+ I = Tabulator
		CtrlK$ = CHR$(11)        ' Ctrl+ K = Cursor to start of field (= Home)
		Enter$ = CHR$(13)        ' Enter
		CtrlN$ = CHR$(14)        ' Ctrl+ N = Cursor to end of field (= End)
		CtrlR$ = CHR$(18)        ' Ctrl+ R = Insert mode toggle
		CtrlU$ = CHR$(21)        ' Ctrl+ U = Clear all input field
		Esc$ = CHR$(27)          ' Escape
		CtrlRevSlash$ = CHR$(28) ' Ctrl+ \ = Cursor Right
		CtrlClSquare$ = CHR$(29) ' Ctrl+ ] = Cursor Left

' 2 character Key vakues
		CursLeft$ = CHR$(0) + CHR$(75)
		CursRight$ = CHR$(0) + CHR$(77)
		CursUp$ = CHR$(0) + CHR$(72)
		CursDown$ = CHR$(0) + CHR$(80)

		Insert$ = CHR$(0) + CHR$(82)
		Delete$ = CHR$(0) + CHR$(83)
		Home$ = CHR$(0) + CHR$(71)
		End$ = CHR$(0) + CHR$(79)
		PageUp$ = CHR$(0) + CHR$(73)
		PageDown$ = CHR$(0) + CHR$(81)

		CtrlHome$ = CHR$(0) + CHR$(119)
		CtrlEnd$ = CHR$(0) + CHR$(117)
		CtrlPageUp$ = CHR$(0) + CHR$(132)
		CtrlPageDown$ = CHR$(0) + CHR$(118)
		CtrlCursLeft$ = CHR$(0) + CHR$(115)
		CtrlCursRight$ = CHR$(0) + CHR$(116)

' Other Key vakues, currently unused
		F1$ = CHR$(59)           'F1
		F2$ = CHR$(60)           'F2
		F3$ = CHR$(61)           'F3
		F4$ = CHR$(62)           'F4
		F5$ = CHR$(63)           'F5
		F6$ = CHR$(64)           'F6
		F7$ = CHR$(65)           'F7
		F8$ = CHR$(66)           'F8
		F9$ = CHR$(67)           'F9
		F10$ = CHR$(68)          'F10
		F10$ = CHR$(133)         'F11
		F10$ = CHR$(134)         'F12

' Verify if SHARED globals are set
		IF ScreenWidth% = 0 THEN ScreenWidth% = 80
		IF LastRow% = 0 THEN LastRow% = 24
		TotalScreenLength% = LastRow% * ScreenWidth%
		IF EmptySpaceChar$ = "" THEN EmptySpaceChar$ = CHR$(32)

' If not specified then supply defaults to incoming vars
		IF AllowCharsMask$ = "" THEN AllowCharsMask$ = CHR$(34) + " !#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~"
		IF EndingKeys$ = "" THEN EndingKeys$ = CHR$(13)
		IF Row% = 0 THEN Row% = CSRLIN
		IF Col% = 0 THEN Col% = POS(0)
		ReturnVar$ = Default$
		IF FieldLen% = 0 THEN FieldLen% = LEN(ReturnVar$)
		IF FieldLen% <= LEN(ReturnVar$) THEN GOTO FieldLenOk
		ReturnVar$ = ReturnVar$ + STRING$(FieldLen% - LEN(ReturnVar$), EmptySpaceChar$)
		FieldLen% = LEN(ReturnVar$)
		Default$ = ReturnVar$
		
FieldLenOk:
' Define internal defaults

		CursPos% = 1
		ReturnVar$ = Default$
		Separator$ = " !#$%&'()*+,-./:;<=>?@[\]^_`{|}~" + CHR$(34) ' Valid separators for CTRL+LEFT or CTRL+RIGHT
		IF TabLen% = 0 THEN TabLen% = 8 ' Tabulator lenght
		NotDone% = 1
		standard% = 2 ' Cursor Shape if in Standard Mode: Now it's 2, but real Starndard is 6.
		Insert% = 4   'Cursor Shape if in Insert Mode
		CurShape% = standard%

'  MAIN LOOP STARTS HERE 
		Riga% = Row%: Lonna% = Col%
		DO
		LOCATE Riga%, Lonna%, 0
		IF Lonna% + LEN(ReturnVar$) > ScreenWidth% THEN
		Part1$ = LEFT$(ReturnVar$, ScreenWidth% - Lonna% + 1)
		Part2$ = RIGHT$(ReturnVar$, LEN(ReturnVar$) - (ScreenWidth% - Lonna% + 1))
		ELSE
		Part1$ = ReturnVar$: Part2$ = ""
		END IF
		PRINT Part1$; Part2$;

		RowCurs% = INT((Lonna% + CursPos% - 1) / ScreenWidth%)
		ColCurs% = (Lonna% + CursPos% - 1) MOD ScreenWidth%
		IF ColCurs% = 0 THEN ColCurs% = ScreenWidth%: RowCurs% = RowCurs% - 1
		VirtPos% = (Riga% * ScreenWidth% - 1) + Lonna% + FieldLen%
		IF VirtPos% > TotalScreenLength% THEN
		Riga% = Riga% - (INT((VirtPos% - TotalScreenLength% - 1) / ScreenWidth%))

		LOCATE Riga%, Lonna%, 0
		END IF
		LOCATE Riga% + RowCurs%, ColCurs%, 1, CurShape%, 7
		DO
		KeyStroke$ = INKEY$
		LOOP WHILE KeyStroke$ = ""


		IF INSTR(AllowCharsMask$, KeyStroke$) > 0 THEN
		Mark% = 0'No Backspace at Posit. 0
		IF CurShape% = standard% THEN
		MID$(ReturnVar$, CursPos%, 1) = KeyStroke$

		ELSE
		ReturnVar$ = LEFT$(ReturnVar$, CursPos% - 1) + KeyStroke$ + MID$(ReturnVar$, CursPos%, FieldLen% - CursPos%)
		END IF

		IF CursPos% < FieldLen% THEN
		CursPos% = CursPos% + 1
		ELSE
		IF MyVal(1) <> 0 THEN BEEP
		END IF
		ELSE
		
		IF (INSTR(EndingKeys$, KeyStroke$) > 0) THEN
		IF KeyStroke$ = CHR$(0) + CHR$(75) AND CursPos% > 1 OR KeyStroke$ = CHR$(0) + CHR$(77) AND CursPos% < FieldLen% THEN
		GOTO SELCASE
		
		ELSE
		ExitKey$ = KeyStroke$
		NotDone% = 0
		GOTO FExit
		END IF
		END IF
		
'  Check for other keys  
SELCASE:
		SELECT CASE KeyStroke$
		CASE CursLeft$
		IF CursPos% > 1 THEN
		CursPos% = CursPos% - 1
		END IF
		CASE CursRight$
		IF CursPos% < FieldLen% THEN
		CursPos% = CursPos% + 1
		END IF
		CASE BackS$
		IF CursPos% > 1 THEN
		Mark% = 0'No Backspace at Posit. 0
		ReturnVar$ = LEFT$(ReturnVar$, CursPos% - 2) + RIGHT$(ReturnVar$, FieldLen% - CursPos% + 1) + EmptySpaceChar$
		CursPos% = CursPos% - 1
		ELSE
		Mark% = Mark% + 1:
		SOUND Mark% * 400 + 500, 1
		IF Mark% > 7 THEN
		Mark% = 0
		ReturnVar$ = Default$
		' IF LEN(ReturnVar$) < FieldLen% THEN
		'    ReturnVar$ = ReturnVar$ + SPACE$(FieldLen% - LEN(ReturnVar$))
		' END IF
		END IF
		END IF
		CASE Delete$
		ReturnVar$ = LEFT$(ReturnVar$, CursPos% - 1) + RIGHT$(ReturnVar$, FieldLen% - CursPos%) + EmptySpaceChar$
		CASE Insert$, CtrlR$
		IF CurShape% = standard% THEN
		CurShape% = Insert%
		ELSE CurShape% = standard%
		END IF

		CASE Home$, CtrlK$  ' Cursor to field start
		CursPos% = 1

		CASE End$, CtrlN$  ' Cursor to field end
		CursPos% = LEN(ReturnVar$)

		CASE CursUp$  ' Cursor 1 line up
		IF CursPos% > ScreenWidth% THEN CursPos% = CursPos% - ScreenWidth%

		CASE CursDown$ ' Cursor 1 line down
		IF CursPos% + ScreenWidth% < LEN(ReturnVar$) + 1 THEN CursPos% = CursPos% + ScreenWidth%

		CASE CtrlHome$  ' Cancel all chars from Cursor Position -1  up to start
		ReturnVar$ = RIGHT$(ReturnVar$, FieldLen% - CursPos% + 1) + STRING$(CursPos% - 1, EmptySpaceChar$)
		CursPos% = 1

		CASE CtrlEnd$, CtrlE$ ' Ctrl+ E = Cancel all chars from Cursor Posit. up to end
		ReturnVar$ = LEFT$(ReturnVar$, CursPos% - 1) + STRING$(FieldLen% - CursPos% + 1, EmptySpaceChar$)

		CASE PageUp$  ' Cursor to 1st line
		DO WHILE CursPos% > ScreenWidth%
		CursPos% = CursPos% - ScreenWidth%
		LOOP

		CASE PageDown$ ' Cursor to last line
		DO WHILE CursPos% + ScreenWidth% < LEN(ReturnVar$) + 1
		CursPos% = CursPos% + ScreenWidth%
		LOOP

		CASE CtrlCursLeft$, CtrlB$ ' Ctrl+ B = Cursor to the word on the left
		IF CursPos% > 1 THEN
		P% = CursPos% - 1
		DO WHILE (P% > 1) AND INSTR(Separator$, MID$(ReturnVar$, P%, 1)) > 0
		P% = P% - 1
		LOOP

		DO WHILE (P% > 1) AND INSTR(Separator$, MID$(ReturnVar$, P%, 1)) = 0
		P% = P% - 1
		LOOP
		CursPos% = P%
		IF CursPos% < 1 THEN CursPos% = 1
		IF CursPos% > 1 THEN CursPos% = CursPos% + 1
		END IF

		CASE CtrlCursRight$, CtrlF$ ' Ctrl+ F = Cursor to the word on the right
		P% = CursPos% + 1
		
		DO WHILE (P% < FieldLen%) AND INSTR(Separator$, MID$(ReturnVar$, P%, 1)) = 0
		P% = P% + 1
		LOOP
		'DO WHILE (P% < FieldLen%) AND INSTR(Separator$, MID$(ReturnVar$, P%, 1)) > 0
		'P% = P% + 1
		'LOOP

		CursPos% = P%
		IF CursPos% > FieldLen% THEN CursPos% = FieldLen%

		CASE Esc$, CtrlU$  ' Ctrl+ U = Clear all input field, if Escape is not
		' activate to exit by XINPUT caller
		ReturnVar$ = STRING$(FieldLen%, EmptySpaceChar$)
		CursPos% = 1

		CASE Tabul$  ' Tabulator in QBasic works in the following way:
		' Cursor moves to past the NEXT 8th character,
		'   character 1 in string being 1st character.
		' I.e., to 9th, 17th, 25th, 33rd character and so on.
		' If INSERT key is not active, up to 8 character will be blanked.
		' If INSERT key is ACTIVE, up to 8 blanks will be INSERTED.

		P% = (INT((CursPos% - 1 + TabLen%) / TabLen%) * TabLen%) + 1 ' Find Cursor position of next tabulation
		IF P% > FieldLen% + 1 THEN P% = FieldLen% + 1
		IF CursPos% > 1 THEN R1$ = LEFT$(ReturnVar$, CursPos% - 1) ELSE R1$ = ""
		IF CurShape% = standard% THEN
		IF CursPos% < P% THEN R2$ = RIGHT$(ReturnVar$, FieldLen% - P% + 1) ELSE R2$ = ""
		ELSE
		IF CursPos% < FieldLen% THEN R2$ = MID$(ReturnVar$, CursPos%, FieldLen% + 1 - P%) ELSE R2$ = ""
		END IF
		ReturnVar$ = R1$ + STRING$(P% - CursPos%, CHR$(32)) + R2$
		IF P% > FieldLen% THEN P% = FieldLen%
		CursPos% = P%

		CASE ELSE
		SOUND 500, 1
		END SELECT
		
		END IF

		LOOP WHILE NotDone%

'  Exit from here  
FExit:
		RealStrLen% = LEN(ReturnVar$)
		Xinput$ = ReturnVar$
		END FUNCTION

