DECLARE SUB ShortName (A$)
DECLARE SUB Fischio ()
DECLARE SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
DECLARE SUB ViewChosen ()
DECLARE SUB box (Y%, X%, W%, H%)
DECLARE SUB ShowDOSSector (FileSect$,ToShow$)
DECLARE SUB ShowHex (A$, K$)
DECLARE SUB Canonize (A$)
' Directory listing Paolo Bagnaresi, May 2000 - e-mail: paolo_bagnaresi@libero.it
'
' This module can Launch different qbasic programs with a CHAIN qbasic instruction.
' Just add the same COMMON arrays to your launcher. (DIM Vector, MyName$, MyVal and the 3 corresponding COMMON Shared declarations).
' These arrays are used only as a parameter passing between chained qbasic programs.

DECLARE FUNCTION Shrink$ (In$)
DIM Vector(0 TO 10)      AS INTEGER
DIM MyName$(0 TO 30)
DIM MyVal(0 TO 10)      AS INTEGER

COMMON SHARED Vector() AS INTEGER
COMMON SHARED MyName$()
COMMON SHARED MyVal() AS INTEGER

'Logic of this program:

'1) A shelled "DIR" is issued and its output will be redirected to a file(Inf$).
'2) This file, containing the file list, is read and transferred to a Random file (Inffixed$), for easier access.
'3) The content of the Random file is shown to the user, who can see the directory by moving back and forth in the Random file,
'   using direction keys.
'4) The user can also select files, using the C,M, 0-9, X keys.
'5) When the user presses Enter or ESC, the selected files will be added to a virtual "trolley", which is the user final selection
'   file (Selected$).
'6) When Enter is pressed on a directory name, the new directory will be shown, and user can add more files to his virtual "trolley".
'7) If Enter has been pressed on a file name, the program exits, returning the selected files to the user.
'8) If ESC has been pressed, all the his virtual "trolley" will be erased and no selection will be returned to caller.
'9) If F6 is pressed, the next program (DOS2I2.bas) will be launched.  DOS2I2.bas will show all the files previously selected in DOS2I1.bas
'   and give you the chance to choose what TI filename should be used on the file to be transferred to the TI image file.
'   Also, you can assign a file type, i.e. PROGRAM, DIS/VAR, etc.. 

' Structure of RECORD 1 (96 bytes) in "Selected$" file
'+----------------+----------------+----------------+----------------+----------------+
'|  byte  1-20    |  byte  21-40   |  byte  41-60   |  byte  61-80   |  byte  81-96   |
'+----------------+----------------+----------------+----------------+----------------+
'|Pointer to Last | Total FILES    | Total SIZE     |     Total      |    Dummy       |
'| Used record    |                |                |  Directories   |    Field       |
'| as plain ASCII | as plain ASCII | as plain ASCII | as plain ASCII |                |
'+----------------+----------------+----------------+----------------+----------------+
'|  PntLastUsed%  | TotFiles2Copy% | TotSize2Copy&  |   TotDirs%     |                |
'|     Pntr       |      TFIL      |     TSIZ      |       TDir      |                |
'+----------------+----------------+----------------+----------------+----------------+

' Structure of Other Records (96 bytes) in "Selected$" file
'+----------------+----------------+-------+-------+-------+-------+-------+----------------+
'|  byte  1       |  byte  2-80    |   81  |   82  |   83  |   84  |   85  |  byte  86-96   |
'+----------------+----------------+---------------------------------------+----------------+
'| Field Length=1 |      79        |    1  |    1  |    1  |    1  |    1  |       11       |
'+----------------+----------------+---------------------------------------+----------------+
'|   Copy Mark    |  DOS Filename  | File  | File  |  ARK  |Unused |Unused |   TI Filename  |
'| as plain ASCII | as plain ASCII | Type  | Length|SubFile|       |       |                |
'+----------------+----------------+-------+-------+-------+-------+-------+----------------+
'|  CpyMark       |       SL       | DTyp  | DLen  | DArk  | DFre1 | DFre2 |   TINAME       |
'+----------------+----------------+-------+-------+-------+-------+-------+----------------+

' CpyMark = C,X, or 0-9. C=Copy; X=UnArk an Ark file. 
' DArk    = Blank or K.  X=ARK Sub File, that is a TI file contained in an ARK or TIFILES Structure.
'                        Blank = Current File is not an Ark Subfile
' DTyp    = P=PROGRAM, V=DIS/VAR, F=DIS/FIX, v=INT/VAR, f=INT/FIX, TI File Type




DEFINT A-Z
' F1 help file. Record structure definition

		TYPE IDXType
		Section AS STRING * 20
		StartRec AS DOUBLE
		RecLength AS SINGLE
		END TYPE
		DIM SHARED IDXRecord AS IDXType
		TempArk$ = "~ARKTMP.TMP"

		TYPE FHead
		Pntr AS STRING * 20
		TFIL AS STRING * 20
		TSIZ AS STRING * 20
		TDir AS STRING * 20
		Noth AS STRING * 16
		END TYPE

		DIM SHARED FiHeader AS FHead

		TYPE SelecType
		CpyMark AS STRING * 1
		SL AS STRING * 79
		DTyp AS STRING * 1
		DLen AS STRING * 1
		DArk AS STRING * 1
		DFre1 AS STRING * 1
		DFre2 AS STRING * 1
		
		TINAME AS STRING * 11
		END TYPE
		DIM SHARED Sel AS SelecType

		Inf$ = "~DOS2IA.TMP"
		Inffixed$ = "~DOSDIR.TMP"
		Selected$ = "~DOS2IB.TMP"
		
		CLS
		UserPath$ = MyName$(3)         ' PC Directory that user wants to Catalog

		FOR T = LEN(UserPath$) TO 1 STEP -1
		IF MID$(UserPath$, T, 1) = "\" THEN GOTO BackFound
		NEXT T
		UserPath$ = UserPath$
		GOTO BackFound2
BackFound:
		UserPath$ = LEFT$(UserPath$, T - 1)
BackFound2:
		' If there is Selected file, open it
		ON ERROR GOTO BackFound4:
		OPEN Selected$ FOR INPUT AS #5
		ON ERROR GOTO 0
		CLOSE #5
		CALL box(8, 20, 50, 5)
		LOCATE 9, 22
		PRINT "== Importing Single Files from DOS =="
		LOCATE 10, 22
		PRINT "Found previous selection."
		LOCATE 11, 22
		PRINT "Do you want to add to it? (Y/N) Y";
		LOCATE 11, 54
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		PRINT K$;
		IF K$=CHR$(27) THEN GOTO Abort4
		IF UCASE$(K$) = "Y" OR K$ = CHR$(13) OR K$ = CHR$(0) + CHR$(64) THEN GOTO BackFound21
		KILL Selected$
		GOTO BackFound3
		
BackFound21:               
		OPEN Selected$ FOR RANDOM ACCESS READ AS #5 LEN = LEN(Sel)
		GET #5, 1, FiHeader
		PntLastUsed% = VAL(FiHeader.Pntr)
		TotFiles2Copy% = VAL(FiHeader.TFIL)
		TotSize2Copy& = VAL(FiHeader.TSIZ)
		TotDirs% = VAL(FiHeader.TDir)

		CLOSE #5
BackFound3:     ON ERROR GOTO 0
		GOTO NewDir
		
BackFound4:      RESUME BackFound3:
		
		' REDIM FilName$(1)
		
' Exit point
Abort:           MyName$(3) = CurrDir$
		KILL MyPath$ + Inf$
		CLOSE #4: KILL Inffixed$
Abort4:		CHAIN MyName$(0)

FoundIt:         MyName$(3) = CurrDir$ + Mystring$

FoundIt2:        KILL MyPath$ + Inf$
		CLOSE #4: KILL Inffixed$
		'ERASE FilName$
		'CHAIN MyName$(0)
		'CHAIN MyName$(10)
		CHAIN "DOS2I2.BAS"

'*******************************
NewDir:          OldTotFnames% = TotFiles2Copy%  ' Save Total filenames so far
		OldTotSize& = TotSize2Copy&' Save total size so far
		TFNames% = 0           ' Total Filenames(incl. directories, ...)
		FFile% = 0             ' First real Filename #
		LFile% = 0             ' Last real Filename
		CurrDir$ = ""

		MyPath$ = MyName$(1)   ' Install directory where TI99-PC.BAS resides

		SHELLSTR$ = "dir " + UserPath$ + " /OGEN /-P >" + MyPath$ + Inf$
		IF MyVal(0) = -1 THEN SHELLSTR$ = "dir " + CHR$(34) + UserPath$ + CHR$(34) + " /OGEN /-P >" + MyPath$ + Inf$
		SHELL SHELLSTR$

		OPEN Inffixed$ FOR RANDOM ACCESS READ WRITE AS #4 LEN = 80
		FIELD #4, 80 AS L$
		FixCnt% = 1
		' Fill it with directory output
		OPEN Inf$ FOR INPUT AS #1
		WHILE NOT EOF(1)
		LINE INPUT #1, In$: TFNames% = TFNames% + 1
		IF INSTR(1, In$, "<DIR>") > 0 THEN In$ = "\" + In$
		'IF TFNames% < 6 THEN FilName$(TFNames%) = In$: GOTO GoOn1
		'IF Lungh > 15000 THEN FilName$(TFNames%) = LEFT$(In$, 12) ELSE FilName$(TFNames%) = LEFT$(In$, 72): GOTO GoOn1

		IF TFNames% > 6 THEN IF LEFT$(In$, 1) = " " THEN In$ = "": TFNames% = TFNames% - 1: GOTO GoOnEnd
GoOn1:

		' Get Current Directory
		IF TFNames% > 6 THEN GOTO GoOn2
		IF CurrDir$ <> "" OR UCASE$(LEFT$(In$, 10)) <> " DIRECTORY" THEN GOTO GoOn2
		P = INSTR(1, In$, ":"): IF P = 0 THEN GOTO GoOn2
		CurrDir$ = MID$(In$, P - 1, LEN(In$))
		CurrDir$ = Shrink$(CurrDir$)
		IF RIGHT$(CurrDir$, 1) <> "\" THEN CurrDir$ = CurrDir$ + "\"

GoOn2:
		IF TFNames% = 1 THEN In$ = "\.."


GoOn3:           IF TFNames% > 6 AND FFile% = 0 AND LEFT$(In$, 1) <> "\" THEN FFile% = TFNames%' Get First Filename #
		LSET L$ = In$
		PUT #4

GoOnEnd:         WEND

		IF FFile% = 0 THEN RealFiles% = 0 ELSE RealFiles% = LFile% - FFile%

		CLOSE #1

		LFile% = TFNames%' Last real Filename
		TFNames% = TFNames% + 26


		' Now, DIM an array that contains all the lines
		'REDIM FilName$(TFNames%)
		REDIM CopyMark$(TFNames%)
		FOR T = 1 TO TFNames%    ' Assume users doesn't want to Extract any file
		CopyMark$(T) = " "
		NEXT T

		FOR T = ASC("a") TO ASC("z")
		In$ = "\" + CHR$(T) + ":"
		LSET L$ = In$
		PUT #4      ' ,FixCnt%: FixCnt%=FixCn
		NEXT T
		'CLOSE #4
		' input "End of this segment", c$ : goto Foundit


		' Prepare to show all filenames
		LOCATE 2, 1, 1
		CurrentScreenRow% = 1
		TotalScreenRows% = 16     ' Rows to display Filenames
		StartRow% = 4  ' Screen Start Row
		CurrentFilename% = 1
		AllowedKey$ = CHR$(27)                         ' ESC
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(72) ' Arrow Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(80) ' Arrow Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(73) ' Page Up
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(81) ' Page Down
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(83) ' Del
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(71) ' Home
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(79) ' End
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(59) ' F1 = Help
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(64) ' F6
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(65) ' F7
		AllowedKey$ = AllowedKey$ + CHR$(0) + CHR$(66) ' F8 = Show ARK file directory, if applicable
		AllowedKey$ = AllowedKey$ + CHR$(21)           ' CTRL U = Unmark All
		AllowedKey$ = AllowedKey$ + CHR$(1)            ' CTRL A = Copy All
		AllowedKey$ = AllowedKey$ + CHR$(13)           ' Enter = Execute
		AllowedKey$ = AllowedKey$ + CHR$(9)            ' TAB -><- = Toggle Screen
		AllowedKey$ = AllowedKey$ + "KTXCM0123456789 " ' Cc + Blank

		GOSUB TopScreen

' MAIN LOOP STARTS HERE

NextFileName:
		COLOR 7, 0
		GOSUB DispFilestoCopy
		IF CurrentScreenRow% = 1 THEN FirstFilename% = CurrentFilename%   ' Get Number of first filename only
		GOSUB DisplayRow  ' Display Current Row

		CurrentFilename% = CurrentFilename% + 1 ' Next Fielename


		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		CurrentScreenRow% = CurrentScreenRow% + 1  ' Next Screen Row
		IF CurrentScreenRow% < TotalScreenRows% + 1 AND CurrentFilename% <= TFNames% THEN GOTO NextFileName

' MAIN LOOP ENDS HERE
' End of filenames
		GOSUB BottomLine:


		LastFilename% = CurrentFilename% - 1' Get Number of Last used filename
		CurrentFilename% = FirstFilename%  ' Current filename is now first filename in screen

		CurrentScreenRow% = 1
		IF KeepCursBottom% = 0 THEN GOTO LocateCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last filename in Screen
		CurrentScreenRow% = TotalScreenRows%: KeepCursBottom% = 0: CurrentFilename% = LastFilename%
		GOTO LocateCursor2
LocateCursor:
		GOSUB RestoreColor

LocateCursor2:
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		COLOR 0, 7: GOSUB DisplayRow: COLOR 7, 0 ' Display Current Row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		OldScreenRow% = CurrentScreenRow%
		OldFilename% = CurrentFilename%


		'GOSUB ShowValues    ' My little Debugger

DoitAgain:       DO: U$ = UCASE$(INKEY$): LOOP UNTIL U$ <> ""
		IF INSTR(AllowedKey$, U$) = 0 THEN GOTO DoitAgain
		
		
		' ESCape Key
		IF U$ = CHR$(27) THEN GOTO Abort

		' ENTER Key
		IF U$ <> CHR$(13) THEN GOTO ArrowDwn
		IF FFile% = 0 OR CurrentFilename% < FFile% OR CurrentFilename% > LFile% THEN GOTO StartCopying
		GET #4, CurrentFilename%
		IF LEFT$(L$, 1) = "\" THEN GOTO StartCopying
		U$ = "C": GOTO OtherKey4a

		' Arrow Down Key
ArrowDwn:                IF U$ <> CHR$(0) + CHR$(80) THEN GOTO OtherKey0
ArrowDown:       IF CurrentScreenRow% < LastScreenRow% THEN CurrentScreenRow% = CurrentScreenRow% + 1: CurrentFilename% = CurrentFilename% + 1: GOTO LocateCursor
		IF CurrentFilename% = TFNames% THEN GOTO LocateCursor
		CurrentFilename% = FirstFilename% + 1
		' IF CurrentFilename% > TFNames% - TotalScreenRows% + 1 THEN CurrentFilename% = FirstFilename% - 1 : goto LocateCursor
		KeepCursBottom% = 1
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey0:         'Arrow up Key
		IF U$ <> CHR$(0) + CHR$(72) THEN GOTO OtherKey1
		IF CurrentFilename% = 1 THEN GOTO NoMatch
		IF CurrentScreenRow% > 1 THEN CurrentScreenRow% = CurrentScreenRow% - 1: CurrentFilename% = CurrentFilename% - 1: GOTO LocateCursor
		CurrentFilename% = FirstFilename% - 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey1:         ' Page Up Key
		IF U$ <> CHR$(0) + CHR$(73) THEN GOTO OtherKey2
		CurrentFilename% = FirstFilename% - TotalScreenRows%
		IF CurrentFilename% < 1 THEN CurrentFilename% = 1
		GOTO Executit

OtherKey2:         ' Page Down Key
		IF U$ <> CHR$(0) + CHR$(81) THEN GOTO OtherKey3
		IF LastFilename% + 1 + TotalScreenRows% > TFNames% THEN CurrentFilename% = TFNames% - TotalScreenRows% + 1: IF CurrentFilename% < 1 THEN CurrentFilename% = 1: GOTO Executit
		CurrentFilename% = FirstFilename% + TotalScreenRows%
		IF CurrentFilename% > TFNames% THEN CurrentFilename% = FirstFilename%
		GOTO Executit

OtherKey3:       ' Blank or Del
		IF U$ <> " " AND U$ <> CHR$(0) + CHR$(83) THEN GOTO OtherKey4
		IF FFile% = 0 OR CopyMark$(CurrentFilename%) = " " THEN GOTO LocateCursor
		CopyMark$(CurrentFilename%) = " "
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		PRINT CopyMark$(CurrentFilename%) = " ";
		GOSUB SectorLength
		TotFiles2Copy% = TotFiles2Copy% - 1
		TotSize2Copy& = TotSize2Copy& - SectorLength#
		GOSUB DispFilestoCopy
		GOTO LocateCursor

OtherKey4:       ' C, M, X   
		IF INSTR("CMXTK", U$) = 0 THEN GOTO OtherKey4b
		'IF U$ <> "C" AND U$ <> "M" AND U$ <> "X" AND U$ <> "T" THEN GOTO OtherKey4b
OtherKey4a:      IF FFile% = 0 OR CopyMark$(CurrentFilename%) = "X" THEN GOTO ArrowDown
		IF U$ = "M" THEN U$ = "C"
OtherKey4a2:
		IF CurrentFilename% < FFile% OR CurrentFilename% > LFile% THEN BEEP: GOTO LocateCursor
		IF CopyMark$(CurrentFilename%) <> " " THEN CopyMark$(CurrentFilename%) = U$: GOTO ArrowDown
		GOSUB SectorLength
		TotFiles2Copy% = TotFiles2Copy% + 1:  TotSize2Copy& = TotSize2Copy& + SectorLength#
		CopyMark$(CurrentFilename%) = U$
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		PRINT CopyMark$(CurrentFilename%) = " ";
		GOSUB DispFilestoCopy
		GOTO ArrowDown
		
OtherKey4b:      ' 0-9
		IF U$ < "0" OR U$ > "9" THEN GOTO OtherKey5
		GOTO OtherKey4a2

OtherKey5:       ' CTRL U = Unmark all
		IF U$ <> CHR$(21) THEN GOTO OtherKey6
		IF FFile% = 0 THEN GOTO LocateCursor
		FOR T = 1 TO TFNames%    ' Assume users wants to Copy all files
		CopyMark$(T) = " "
		NEXT T
		FOR T% = 1 TO LastScreenRow%
		LOCATE StartRow% + T%, 2, 1
		PRINT " ";
		NEXT T%
		TotFiles2Copy% = OldTotFnames%
		TotSize2Copy& = OldTotSize&
		GOSUB RePaintScreen
		GOTO LocateCursor

OtherKey6:       ' CTRL A = Mark all
		IF U$ <> CHR$(1) OR RealFiles% = 0 THEN GOTO OtherKey7
		IF FFile% = 0 THEN GOTO LocateCursor
		' PRINT FFile%; LFile%; RealFiles%
		FOR CF% = FFile% TO LFile%    ' Assume users wants to Copy all files
		IF CopyMark$(CF%) = " " THEN GOSUB SectorLen: TotSize2Copy& = TotSize2Copy& + SectorLength#
		IF CopyMark$(CF%) = " " THEN CopyMark$(CF%) = "C": TotFiles2Copy% = TotFiles2Copy% + 1: GOSUB DispFilestoCopy
		NEXT CF%

		FOR T% = 1 TO LastScreenRow%
		IF FirstFilename% - 1 + T < FFile% OR FirstFilename% - 1 + T > LFile% THEN GOTO OtherKey6b
		LOCATE StartRow% + T%, 2, 1
		PRINT "C";
OtherKey6b:
		NEXT T%

		GOSUB RePaintScreen
		GOTO LocateCursor

OtherKey7:         ' Home Key : simply move cursor to top
		IF U$ <> CHR$(0) + CHR$(71) THEN GOTO OtherKey8
		CurrentScreenRow% = 1: CurrentFilename% = FirstFilename%: GOTO LocateCursor


OtherKey8:         ' End Key : simply move cursor to bottom
		IF U$ <> CHR$(0) + CHR$(79) THEN GOTO OtherKey9
		CurrentScreenRow% = LastScreenRow%: CurrentFilename% = LastFilename%
		GOTO LocateCursor

OtherKey9:         ' Tab key: display list of files selected from previous directories
		IF U$ <> CHR$(9) THEN GOTO OtherKey10
		
		IF TotDirs% = 0 THEN BEEP: GOTO NoMatch
		CALL ViewChosen
OtherKey9b:      GOSUB RePaintScreen
		GOTO NoMatch

OtherKey10:      ' F7 = Sector Viewer
		IF U$ <> CHR$(0) + CHR$(65) THEN GOTO OtherKey11
		IF CurrentFilename% < 7 THEN BEEP: GOTO NoMatch
		GET #4, CurrentFilename%
		IF LEFT$(L$, 1) = "\" THEN BEEP: GOTO NoMatch
		Mystring$ = LEFT$(L$, 12)
		Mystring$ = Shrink$(Mystring$)
		P = INSTR(1, Mystring$, " "): IF P > 0 THEN MID$(Mystring$, P) = "."
		Mystring$ = CurrDir$ + Mystring$
		
		CALL ShowDOSSector(Mystring$,Mystring$)
		GOSUB RePaintScreen
		GOTO NoMatch


OtherKey11:      ' F6 = Proceed
		IF U$ <> CHR$(0) + CHR$(64) THEN GOTO OtherKey12
		GOSUB OutNames ' Output Selected names to a file, if any
		GOTO FoundIt

		
'========SHOW ARK FILE
		' F8 = I ARK file, display it
OtherKey12:      IF U$ <> CHR$(0) + CHR$(66) THEN GOTO OtherKey13
		IF CurrentFilename% <= ActiveDirs% THEN GOTO NoMatch
		GET #4, CurrentFilename%: Mystring$ = LEFT$(L$, 12)
		'Mystring$ = LEFT$(FilName$(CurrentFilename%), 12)

		Mystring$ = Shrink$(Mystring$)
		P = INSTR(1, Mystring$, " "): IF P > 0 THEN MID$(Mystring$, P) = "."
		IF LEFT$(Mystring$, 1) = "\" THEN GOTO NoMatch
		IF INSTR(Mystring$, ":") = 0 THEN UsrPth$ = CurrDir$ + Mystring$
		CALL ShortName(UsrPth$)
		CLS
		COLOR 14, 0
		PRINT TAB(5); "Catalog of Archive File: "; UsrPth$
		Exec$ = "Decomp4.com " + UsrPth$ + " /s"
		SHELL Exec$
		Exec$ = "Decomp4.com " + UsrPth$ + " /s"
		
		COLOR 7, 0
		CLS
		
		' GOSUB ShowSector
		GOSUB RePaintScreen
		GOTO NoMatch

		

OtherKey13:      ' F1 (Help) key
		IF U$ <> CHR$(0) + CHR$(59) THEN GOTO OtherKey14
		CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "18.04.01")
		GOSUB RePaintScreen
		GOTO LocateCursor
OtherKey14:
		GOTO NoMatch

Executit:
		CurrentScreenRow% = 1     ' Cursor on first screen row
		LOCATE StartRow% + CurrentScreenRow%, 2, 1
		GOTO NextFileName   ' Start next round

NoMatch:         GOTO LocateCursor

' ENTER key pressed

StartCopying:    LOCATE 4, 50
		GET #4, CurrentFilename%: Mystring$ = LEFT$(L$, 12)
		Mystring$ = Shrink$(Mystring$)
		P = INSTR(1, Mystring$, " "): IF P > 0 THEN MID$(Mystring$, P) = "."
		IF LEFT$(Mystring$, 1) <> "\" THEN GOSUB RePaintScreen: GOTO NoMatch
		GOSUB OutNames ' Output Selected names to a file, if any


ChangeDir:       UserPath$ = RIGHT$(Mystring$, LEN(Mystring$) - 1)
		IF INSTR(Mystring$, ":") = 0 THEN UserPath$ = CurrDir$ + UserPath$

		CLOSE #4: KILL Inffixed$

		GOTO NewDir

' OUTPUT SELECTED NAMES TO A FILE, IF ANY
OutNames:        ' Any Marked file in this session?
		IF OldTotFnames% = TotFiles2Copy% THEN GOTO OutNames8
		TotDirs% = TotDirs% + 1
		OPEN Selected$ FOR RANDOM ACCESS READ WRITE AS #5 LEN = LEN(Sel)

		IF PntLastUsed% = 0 THEN PntLastUsed% = 1
		Sel.CpyMark = ""
		Sel.SL = "<DIR> " + CurrDir$
		Sel.DTyp = ""
		Sel.TINAME = ""
		Sel.DArk = CHR$(0)		
		PUT #5, PntLastUsed% + 1, Sel: PntLastUsed% = PntLastUsed% + 1

		FOR CF% = FFile% TO LFile%    ' Assume users wants to Copy all files
		IF CopyMark$(CF%) = " " THEN GOTO OutNames4

		
		IF CopyMark$(CF%) <> "X" THEN GOTO OutNames2c

' "X" Command key
		GET #4, CF%
		' CHECK HERE IF FILE IS A TRUE ARK FILE
		GOSUB Path2ARK ' Get path to ARK file in UsrPth$
		
		Exec$ = "Decomp4.com " + UsrPth$ + " ~tmpfile.tmp  /c >NULL"
		SHELL Exec$
		
		ON ERROR GOTO OutNaqmes2 
		OPEN "~tmpfile.tmp" FOR RANDOM ACCESS READ AS #12 LEN = 18
		ON ERROR GOTO 0
		FIELD #12, 18 AS TMP$
		GET #12, 1
		' Decomp4 will issue HBABA as first 2 bytes in case a file is not ARK type.
		IF  LEFT$(TMP$,2)=CHR$(&HBA)+CHR$(&HBA) OR LEFT$(TMP$,2)=CHR$(&H0)+CHR$(&H0) THEN GOTO OutNaqmes2b
		CLOSE #12
		GOTO OutNames4
		
OutNaqmes2:     RESUME OutNaqmes2a
OutNaqmes2a:    ON ERROR GOTO 0  
OutNaqmes2b:    CLOSE #12
		CopyMark$(CF%)="C"
		
OutNames2c:     GET #4, CF%
OutNames3:      Sel.CpyMark = CopyMark$(CF%)
		Sel.SL = L$

		PUT #5, PntLastUsed% + 1, Sel: PntLastUsed% = PntLastUsed% + 1
		
OutNames4:       NEXT CF%

' This time check the ARK types 
		
		FOR CF% = FFile% TO LFile%    ' Assume users wants to Copy all files
 		IF CopyMark$(CF%) <> "X" THEN GOTO OutNames6
		
		GET #4, CF%
		Sel.CpyMark = " " ' CopyMark$(CF%)
		Sel.SL = "<ARK> " + L$
		
		Sel.DTyp =  ""
		Sel.TINAME = ""

		PUT #5, PntLastUsed% + 1, Sel: PntLastUsed% = PntLastUsed% + 1
		
		GOSUB Path2ARK ' Get path to ARK file in UsrPth$
		Exec$ = "Decomp4.com " + UsrPth$ + " ~tmpfile.tmp  /c >NULL"
		SHELL Exec$
		ON ERROR GOTO OutNames5:
		OPEN "~tmpfile.tmp" FOR RANDOM ACCESS READ AS #12 LEN = 256
		ON ERROR GOTO 0
		FIELD #12, 256 AS RKRD$
		RecCnt=1
		
		WHILE NOT EOF(12)
		GET #12, RecCnt
		
		FOR T=1 TO 14*18 STEP 18
		TMP$=MID$(RKRD$,T,18)
		IF  LEFT$(TMP$,2)= CHR$(&H0)+CHR$(&H0) THEN GOTO OutNames4c
		Sel.CpyMark = "C" ' CopyMark$(CF%)
		Sel.DArk = "X" ' This marks the file as an ARK SubFile
		FileType%=ASC(MID$(TMP$,11,1)) : GOSUB GetFileType
		Sel.DTyp =  FileType$: Sel.Dlen = MID$(TMP$,16,1)
		
		' Calculate TI file length, in Bytes
		FileLength# = CalcWord(TMP$,13 )
		UsedLS%=0
		IF INSTR("VvP",FileType$)=0 then GOTO OutNames4b ' only Variable and Program files have EOF offset
		UsedLS%=ASC(MID$(TMP$,15,1))
		FileLength#=FileLength#-1
		
OutNames4b:      FileLength#=FileLength#*256+UsedLS%
		TMP2$=AddThousand$(STR$(FileLength#))
		
		Sel.SL = LEFT$(TMP$,10) + SPACE$(16-LEN( TMP2$))+TMP2$
		Sel.TINAME = LEFT$(TMP$,10)
		IF Sel.TINAME <> "TIFILES    " OR T <> 1  THEN GOTO OutNames4b1
		Sel.TINAME = LEFT$(DoAway$ (LEFT$(L$,20)," "),10)
		
OutNames4b1:		
		PUT #5, PntLastUsed% + 1, Sel: PntLastUsed% = PntLastUsed% + 1
		NEXT T
		RecCnt=RecCnt+1
		WEND
OutNames4c:      CLOSE #12
		GOTO OutNames6
		
OutNames5:       RESUME OutNames5B
OutNames5B:      ON ERROR GOTO 0
		
		'Sel.CpyMark = CopyMark$(CF%)
		'Sel.SL = L$

		'PUT #5, PntLastUsed% + 1, Sel: PntLastUsed% = PntLastUsed% + 1

OutNames6:       NEXT CF%



		FiHeader.Pntr = STR$(PntLastUsed%)
		FiHeader.TFIL = STR$(TotFiles2Copy%)
		FiHeader.TSIZ = STR$(TotSize2Copy&)
		FiHeader.TDir = STR$(TotDirs%)
		FiHeader.Noth = ""
		PUT #5, 1, FiHeader
		CLOSE #5

		CALL box(8, 3, 76, 7)
		LOCATE 9, 4: PRINT "Files selected in the "; RIGHT$(CurrDir$, 40);
		LOCATE 10, 4: PRINT "directory have been stored in a file for later use. You can view them";
		LOCATE 11, 4: PRINT "any time by pressing TAB key from the next screen."
		LOCATE 13, 20: PRINT "====== Press any key to continue ======"
		WHILE INKEY$ = "": WEND

OutNames8:
		RETURN

' Get path to ARK file in UsrPth$
Path2ARK:
		Mystring$ = LEFT$(L$, 12)
		'Mystring$ = LEFT$(FilName$(CurrentFilename%), 12)

		Mystring$ = Shrink$(Mystring$)
		P = INSTR(1, Mystring$, " "): IF P > 0 THEN MID$(Mystring$, P) = "."
		IF LEFT$(Mystring$, 1) = "\" THEN CopyMark$(CF%)="C":GOTO OutNames3
		IF INSTR(Mystring$, ":") = 0 THEN UsrPth$ = CurrDir$ + Mystring$
		CALL ShortName(UsrPth$)
		OPEN "~tmpfile.tmp" FOR OUTPUT AS #12
		CLOSE #12
		
		RETURN

GetFileType:
		FileType% = FileType% AND &H8B        ' Get rid of reserved bits: 2,4-6
		'IF FileType% AND 8 THEN FileProt$ = "P" ELSE FileProt$ = "_"
		FileType% = FileType% AND 247

		SELECT CASE FileType%
		CASE 0
		FileType$ = "F"        ' "Dis/Fix"
		CASE 1
		FileType$ = "P"        ' "Program"
		CASE 2
		FileType$ = "f"        ' "Int/Fix"
		CASE 128
		FileType$ = "V"        ' "Dis/Var"
		CASE 130
		FileType$ = "v"        ' "Int/Var"
		CASE ELSE
		FileType$ = "U"        ' "unknown"
		END SELECT
		RETURN

' Display Current Row
DisplayRow:
		LOCATE StartRow% + CurrentScreenRow%, 1, 1
		PRINT ""; CopyMark$(CurrentFilename%); "";
		PRINT USING "###"; CurrentFilename%;
		'PRINT ""; FilName$(CurrentFilename%);
		GET #4, CurrentFilename%: PRINT ""; LEFT$(L$, 68);
		LOCATE StartRow% + CurrentScreenRow%, , 1

		PRINT TAB(80); "";
		RETURN


RestoreColor:    TempScreenRow% = CurrentScreenRow%
		TempFilename% = CurrentFilename%
		CurrentScreenRow% = OldScreenRow%
		CurrentFilename% = OldFilename%
		COLOR 7, 0: GOSUB DisplayRow ' Display Current Row
		CurrentScreenRow% = TempScreenRow%
		CurrentFilename% = TempFilename%
		RETURN

DispFilestoCopy: ' Display total files to be copied
		LOCATE 3, 39
		PRINT "    ";
		LOCATE 3, 39
		PRINT TotDirs%;
		LOCATE 3, 57, 1
		PRINT "    ";
		LOCATE 3, 57, 1
		PRINT TotFiles2Copy%;
		LOCATE 3, 69, 1
		PRINT "          ";
		LOCATE 3, 69, 1
		PRINT TotSize2Copy&;
		RETURN

		' My Little Debugger
ShowValues:
		CCursR = CSRLIN
		CCursC = POS(0)
		LOCATE 6, 55
		PRINT FirstFilename%; CurrentFilename%; LastFilename%; "   "
		LOCATE CCursR, CCursC

		RETURN
'=================================
' DISPLAY TOP PART OF TITLE SCREEN
'=================================
TopScreen:       CLS
		PRINT TAB(10); "========    DOS Directory  Listing : Collect Files   ========"
		PRINT "Ŀ"
		PRINT "  n. Filename          Length DIRs=     Marked Files=       Size=           "
		PRINT "Ĵ"
		GOSUB DispFilestoCopy

		RETURN


BottomLine:
		PRINT
		PRINT ""
		LOCATE 22, 1
		PRINT "C,M,0-9,Enter=Add File. Space,Del=Unmark. CTRL A,U=Mark,Unmark All. F6=Proceed"
		PRINT "ESC= Exit. TAB=Collected files. Enter on Dir=Change Dir. F7= File Hex Viewer. "
		PRINT "F8= Cat ARK. T=Trim TIFILES Header. X=Extract ARK files. K=Import as ARK File";



		LOCATE StartRow% + CurrentScreenRow% + 1, 1, 1

		IF CurrentScreenRow% > TotalScreenRows% THEN GOTO SkipClear ' Blank all unused screen rows, if any

		FOR V = CurrentScreenRow% TO TotalScreenRows%
		PRINT "                                                                                "
		NEXT V
SkipClear:
		RETURN

'=========================
' REDRAW THE ENTIRE SCREEN
'=========================
RePaintScreen:
		COLOR 7, 0
		GOSUB TopScreen ' Display Top Part of Title Screen
		SaveCurrFilename% = CurrentFilename%
		SavCurrScreenRow% = CurrentScreenRow%
		CurrentFilename% = FirstFilename%
		FOR CurrentScreenRow% = 1 TO TotalScreenRows%
		GOSUB DisplayRow  ' Display Current Row
		CurrentFilename% = CurrentFilename% + 1 ' Next Filename
		LastScreenRow% = CurrentScreenRow%      ' Save last Screen Row used
		IF CurrentFilename% > TFNames% THEN CurrentScreenRow% = CurrentScreenRow% + 1: GOTO RePaintScreen2
		NEXT CurrentScreenRow%   ' Next Screen Row
RePaintScreen2:
		GOSUB BottomLine        ' Display Bottom Line
		CurrentFilename% = SaveCurrFilename%
		CurrentScreenRow% = SavCurrScreenRow%
		RETURN
SectorLength:   CF% = CurrentFilename%
SectorLen:      SectorLength# = 0
		'IF LEN(FilName$(CF%)) < 26 THEN GOTO SectorLenEND
		A$ = ""
		GET #4, CF%:
		FOR T = 13 TO 26
		B$ = MID$(L$, T, 1)
		IF B$ >= "0" AND B$ <= "9" THEN A$ = A$ + B$ ELSE IF A$<>"" THEN GOTO SectorLnz
		NEXT T
SectorLnz:	IF A$ <> "" THEN SectorLength# = VAL(A$)
SectorLenEND:

		RETURN


FlNotFnd:        CALL box(1, 10, 66, 6)

		LOCATE 2, 12
		PRINT "QBasic Error Code:"; ERR;
		LOCATE 3, 12
		PRINT "This file cannot be opened. If you are viewing files"
		LOCATE 4, 12
		PRINT "selected from previous directory, this will abort it."
		LOCATE 5, 12
		PRINT "Press any key to continue"
		BEEP
		WHILE INKEY$ = "": WEND
		RESUME FlNotFnd2


FlNotFnd2:       CLOSE #5
		ON ERROR GOTO 0
		GOTO OtherKey9b

SUB box (Y, X, W, H)

		' Call Box(StartRow, StartColumn, Width, Hight)
		' Y=StartRow,X=StartColumn; W=Width,H=Hight)
		LOCATE Y, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";

		FOR V = 1 TO H - 2
		LOCATE Y + V, X
		PRINT ""; TAB(X + W - 1); : PRINT "";
		NEXT V

		LOCATE Y + H - 1, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";


END SUB

DEFSNG A-Z
FUNCTION CalcWord (A$, P%)
		IF LEN(A$) < P%+1 THEN INPUT "Wrong String in CalcWord Subroutine",C$: V%=0 : GOTO CalcWord1
		B1% = ASC(MID$(A$, P%, 1))
		B2% = ASC(MID$(A$, P% + 1, 1))
		V% = (B1% * 256) + B2%
CalcWord1:       CalcWord = (V%)
END FUNCTION

FUNCTION AddThousand$(A$)
		A$=RTRIM$(LTRIM$(A$))
		L1=LEN(A$)/3
		L=INT(L1)
		IF L1=L THEN L=L-1
		FOR T=L TO 1 STEP -1
		A$=LEFT$(A$,LEN(A$)-T*3)+ "," + RIGHT$(A$,T*3)
		NEXT T
		AddThousand$=A$
END FUNCTION            

DEFSNG A-Z
SUB Fischio
		IF MyVal(1) = 0 THEN EXIT SUB
		FOR i% = 3000 TO 4000 STEP 200
		SOUND i%, .1  'i% / 1000
		NEXT i%

END SUB

SUB ShortName (A$)
' Get short filename (8.3 characters)
		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT7160.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO ShortName2
		LINE INPUT #71, A$
ShortName2:     CLOSE #71
		KILL "--"
ShortNameEnd:
END SUB

SUB ShowDOSSector (FileSect$,ToShow$)

		CALL box(8, 3, 76, 13)
		LOCATE 8, 30: COLOR 0, 7: PRINT " - HEX SECTOR VIEWER - "; : COLOR 7, 0
		CALL ShortName(FileSect$): IF FileSect$ = "" THEN GOTO ShowDOSSectorEnd' Get Short Filename (8.3 characters)

		OPEN FileSect$ FOR BINARY ACCESS READ SHARED AS #6
		REDIM DSEC(1) AS STRING * 512
		tlen& = LOF(6)
		BytePos& = 1
		SectorCnt& = tlen& / 512
		GET #6, 1, DSEC(1)
		LOCATE 9, 5:  PRINT "File: "; ToShow$; " -Length:"; INT((tlen& / 512) + 1);
		K$ = "Y"

ShowDOSSector2:  LOCATE 19, 30: PRINT "                ";
		IF BytePos& < tlen& THEN GOTO ShowDOSSector3
		BytePos& = BytePos& - (512): IF BytePos& < 1 THEN BytePos& = 1
		K$ = ""
		LOCATE 19, 30: PRINT " = End of File =";
		DO: KUK$ = INKEY$: LOOP UNTIL KUK$ <> ""
		IF KUK$ = CHR$(27) THEN GOTO ShowDOSSectorEnd

ShowDOSSector3:
		GET #6, BytePos&, DSEC(1):  BytePos& = BytePos& + 512

		LOCATE 9, 50: PRINT " - Sect.Offset: "; (BytePos& - 1) / 512; " >"; HEX$((BytePos& - 1) / 512);

		CALL ShowHex(DSEC(1), K$)
		IF K$ = CHR$(27) THEN GOTO ShowDOSSectorEnd
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO ShowDOSSector2
		K$ = ""
		BytePos& = BytePos& - (512 * 2)
		IF BytePos& < 1 THEN BytePos& = 1: K$ = "Y"
		GOTO ShowDOSSector2

ShowDOSSectorEnd: CLOSE #6
END SUB

DEFINT A-Z
SUB ShowHex (A$, K$)
' This is simply to help during debugging
' Syntax: CALL ShowHex(A$,K$) ' A$ usually contains an entire TI Sector (256 bytes)
		Col% = 3
		B$ = ""
		FOR T = 1 TO LEN(A$)
		C$ = HEX$(ASC(MID$(A$, T, 1))): IF LEN(C$) = 1 THEN C$ = "0" + C$
		B$ = B$ + C$ + " "
		NEXT T

		LOCATE 10, Col% + 2
		PRINT "Addr. 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ";

		IF K$ = "" THEN T = LEN(B$) - (8 * 16 * 3 - 1) ELSE T = 1
'===============LOOP STARTS HERE

Repeat:
		T$ = MID$(B$, T, 16 * 3)
		LOCATE 10 + 1 + Row%, Col% + 2:
		H$ = HEX$(T / 3): IF LEN(H$) = 1 THEN H$ = "0" + H$
		IF LEN(H$) = 2 THEN H$ = "0" + H$
		PRINT USING "\  \"; H$;
		LOCATE 10 + 1 + Row%, Col% + 5
		PRINT " - "; T$;
		PRINT "  ";
		FOR J = 1 TO 16
		J$ = MID$(A$, (T - 1) / 3 + J, 1)
		IF ASC(J$) < 32 OR ASC(J$) > 126 THEN PRINT " ";  ELSE PRINT J$;

		NEXT J

		Row% = Row% + 1: IF Row% < 8 THEN GOTO NextRow ELSE Row% = 0
		'LOCATE 21, 1: PRINT LEN(B$)
		'LOCATE 22, 1: PRINT T
		'LOCATE 23, 1: PRINT (T - 1) / (3 * 16)
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO GEXIT

		' Arrow Down
		IF K$ <> CHR$(0) + CHR$(80) THEN GOTO ArrowUPkey
		T = T - (16 * 3 * 6): IF T < 1 THEN T = 1
		GOTO Repeat

ArrowUPkey:      ' Arrow UP
		IF K$ <> CHR$(0) + CHR$(72) AND K$ <> CHR$(0) + CHR$(73) THEN GOTO NextRow
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO PageUPKey
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 8): IF T < 1 THEN T = 1
		GOTO Repeat
PageUPKey:
		' Page UP
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 15): IF T < 1 THEN T = 1
		GOTO Repeat

NextRow:
		T = T + (16 * 3)
		IF T < LEN(B$) THEN GOTO Repeat
		K$ = "Y"
'===============LOOP ENDS HERE
GEXIT:
END SUB

FUNCTION Shrink$ (In$)
		A$ = "": c1$ = " "
		FOR T = 1 TO LEN(In$): C$ = MID$(In$, T, 1): IF C$ = " " AND c1$ = " " THEN GOTO SKIP
		A$ = A$ + C$: c1$ = C$
SKIP:
		NEXT T
		A$ = LTRIM$(RTRIM$(A$))
		Shrink$ = A$
END FUNCTION

DEFINT A-Z
FUNCTION DoAway$ (Strig$, Char$)
		A$ = ""
		FOR T = 1 TO LEN(Strig$): C$ = MID$(Strig$, T, 1): IF C$ = Char$ THEN GOTO prossimo
		A$ = A$ + C$
		
prossimo:
		NEXT T
		DoAway$ = A$
END FUNCTION

'================================
' Get valid DOS filename from a filename of the kind "FILE   ARK"
'================================
SUB Canonize (A$)
		A$ = Shrink(A$)
		P = INSTR(A$, " ")
		IF P > 0 THEN MID$(A$, P) = "."
END SUB

DEFSNG A-Z
SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
		GOTO GetHelp

' Will use Chapter 7 from help file "Manual.dat", indexed in "Manual.idx" file.
' Because of MS QBasic quirks, GetIDX routine has to be placed before the rest of the code.
'
' Get .IDX file values into an array, that is,
' Get Array Parameters from Index (IDX) file
GetIDX:

		OPEN IDXFile$ FOR RANDOM ACCESS READ AS #3 LEN = LEN(IDXRecord)
		GET #3, , IDXRecord
		TLines% = IDXRecord.StartRec' First record is special: total records that follow


		REDIM IDXSect$(TLines%)
		REDIM IdxStart(TLines%)
		REDIM IdxLength(TLines%)
		FOR T = 1 TO TLines%
		GET #3, , IDXRecord
		IDXSect$(T) = LTRIM$(IDXRecord.Section)
		IdxStart(T) = IDXRecord.StartRec
		IdxLength(T) = IDXRecord.RecLength
		IDXSect$(T) = LTRIM$(RTRIM$(IDXSect$(T)))
		NEXT T
		CLOSE #3

		RETURN


GetHelp:        CLS
		LOCATE 1, 26: PRINT Banner$
		InizRw% = 2
		TotScrRws% = 12
		CurrScrRw% = 1

		GOSUB RedrawBox
		GOSUB GetIDX
		FOR Arg% = 1 TO TLines%
		IF Argum$ = IDXSect$(Arg%) THEN GOTO ArgFnd
		NEXT Arg%
		Arg% = 1

ArgFnd:         CurntLine% = Arg%
		RcLen% = 77 + 2
		OPEN DatFile$ FOR RANDOM ACCESS READ AS #59 LEN = RcLen%
		FIELD #59, RcLen% - 2 AS DL$
		FIELD #59, 2 AS CRLF$

'===================================
' MAIN LOOP STARTS HERE
'===================================
NextLineName:
		COLOR 7, 0

		IF CurrScrRw% = 1 THEN FstLine% = CurntLine%   ' Get Number of first Line only
		GOSUB DisplayRw
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		CurrScrRw% = CurrScrRw% + 1  ' Next Screen Row
		IF CurrScrRw% < TotScrRws% + 1 AND CurntLine% <= TLines% THEN GOTO NextLineName
'===================================
' MAIN LOOP ENDS HERE
'===================================
'
		GOSUB BotLine              ' Clear Unused Bottom Lines
		LastLine% = CurntLine% - 1
		CurntLine% = FstLine%  ' Current Line is now first Line in screen

		CurrScrRw% = 1
		IF KeepCursBot% = 0 THEN GOTO LocCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last Line in Screen
		CurrScrRw% = TotScrRws%: KeepCursBot% = 0: CurntLine% = LastLine%
		GOTO LocCursor2

LocCursor:
		GOSUB HeRestColor

LocCursor2:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		COLOR 0, 7: GOSUB DisplayRw: COLOR 7, 0 ' Display Current Row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		OldScrRw% = CurrScrRw%
		OldLine% = CurntLine%
		IF GoToThisDir% <> 0 THEN CurntLine% = GoToThisDir%: GoToThisDir% = 0: GOTO Exekit
		'GOSUB ShowValues    ' My little Debugger


DoHeAgain:      GOSUB GetChar

		' IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO DoHeAgain

		' ESCape Key
		IF UH$ = CHR$(27) THEN GOTO HAbort

		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO IsArrDown
EnterKey:       CALL Fischio
		GOSUB ThisSect
		GOSUB RePaintHelp
		GOTO NMatch

IsArrDown:     ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO OthKey0
		IF CurrScrRw% < LastScrRw% THEN CurrScrRw% = CurrScrRw% + 1: CurntLine% = CurntLine% + 1: GOTO LocCursor
		IF CurntLine% = TLines% THEN GOTO LocCursor
		CurntLine% = FstLine% + 1
		KeepCursBot% = 1
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
OthKey0:         'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO OthKey1
		IF CurntLine% = 1 THEN GOTO NMatch
		IF CurrScrRw% > 1 THEN CurrScrRw% = CurrScrRw% - 1: CurntLine% = CurntLine% - 1: GOTO LocCursor
		CurntLine% = FstLine% - 1: IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey1:         ' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO OthKey2
		CurntLine% = FstLine% - TotScrRws%
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO OthKey7
		IF LastLine% + 1 + TotScrRws% > TLines% THEN CurntLine% = TLines% - TotScrRws% + 1: IF CurntLine% < 1 THEN CurntLine% = 1: GOTO Exekit
		CurntLine% = FstLine% + TotScrRws%
		IF CurntLine% > TLines% THEN CurntLine% = FstLine%
		GOTO Exekit

OthKey7:         ' Home Key : simply move cursor to top
		IF UH$ <> CHR$(0) + CHR$(71) THEN GOTO OthKey8
		CurrScrRw% = 1: CurntLine% = FstLine%: GOTO LocCursor

OthKey8:         ' End Key : simply move cursor to bottom
		IF UH$ <> CHR$(0) + CHR$(79) THEN GOTO OthKey9
		CurrScrRw% = LastScrRw%: CurntLine% = LastLine%
		GOTO LocCursor

OthKey9:        ' F3 = Show Error List
		IF UH$ <> CHR$(0) + CHR$(61) THEN GOTO OthKey10
		GOSUB RePaintHelp
		GOTO NMatch

OthKey10:       ' F7 = Show Sector as Hex
		IF UH$ <> CHR$(0) + CHR$(65) THEN GOTO OthKey11
		GOSUB RePaintHelp
		GOTO NMatch

OthKey11:       'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO OthKey12
		GOTO EnterKey
OthKey12:
		GOTO NMatch


Exekit:         CurrScrRw% = 1     ' Cursor on first screen row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GOTO NextLineName   ' Start next round

NMatch:         GOTO LocCursor

RePaintHelp:
		GOSUB RedrawBox
		SaveCurrLine% = CurntLine%
		SavCurrScrRw% = CurrScrRw%
		CurntLine% = FstLine%
		FOR CurrScrRw% = 1 TO TotScrRws%
		GOSUB DisplayRw  ' Display Current Row
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		IF CurntLine% > TLines% THEN CurrScrRw% = CurrScrRw% + 1: GOTO RePaintHelp2
		NEXT CurrScrRw%   ' Next Screen Row

RePaintHelp2:

		CurntLine% = SaveCurrLine%
		CurrScrRw% = SavCurrScrRw%
		RETURN

HeRestColor:    TempScreenRw% = CurrScrRw%
		TempLine% = CurntLine%
		CurrScrRw% = OldScrRw%
		CurntLine% = OldLine%
		COLOR 7, 0: GOSUB DisplayRw ' Display Current Row
		CurrScrRw% = TempScreenRw%
		CurntLine% = TempLine%
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRw:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GET #59, IdxStart(CurntLine%)
		TL$ = DL$
		FOR T = 1 TO LEN(TL$): IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO StrtFound
		NEXT T
StrtFound:      TL$ = RIGHT$(TL$, LEN(TL$) - T + 1)

		FOR T = LEN(TL$) TO 1 STEP -1: IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO EndFnd
		NEXT T
EndFnd:         TL$ = LEFT$(TL$, T)
		PRINT IDXSect$(CurntLine%); TAB(12); TL$; SPACE$(79 - 12 - LEN(TL$));
		RETURN

'====================
' CLEAR BOTTOM LINES
'====================
BotLine:

		LOCATE InizRw% + CurrScrRw%, 2, 1

		IF CurrScrRw% >= TotScrRws% THEN GOTO HlpClear ' Blank all unused screen rows, if any

		FOR V = CurrScrRw% TO TotScrRws%
		LOCATE InizRw% + V, 2, 1
		PRINT "                                                                              "
		NEXT V

HlpClear:        LOCATE 23, 1: PRINT "Enter=Get Doc. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		RETURN


' Create Box
RedrawBox:      CALL box(2, 1, 80, TotScrRws% + 2)
		RETURN
Pranyk:

		PRINT "                         - press any key to return -"
		GOSUB GetChar
		RETURN

GetChar:
		DO: UH$ = INKEY$: LOOP UNTIL UH$ <> ""
		RETURN


ThisSect:       TotSectRws% = 19
		SectInizRw% = 2
		SectCurrRw% = 1
		SectStart# = IdxStart(CurntLine%)
		SectCount# = IdxLength(CurntLine%)
		SectCurr# = 0
		Blank$ = SPACE$(78)
		LOCATE 23, 1: PRINT "Enter=Line Down. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		CALL box(2, 1, 80, TotSectRws% + 2)
NewRound:
		FirstRec# = SectCurr#
SectNewLine:
		GET #59, SectStart# + SectCurr#
		LOCATE SectInizRw% + SectCurrRw%, 2, 1
		PRINT DL$;
		SectCurr# = SectCurr# + 1
		LastSectRw% = SectCurrRw%      ' Save last Screen Row used
		SectCurrRw% = SectCurrRw% + 1
		IF SectCurrRw% < TotSectRws% + 1 AND SectCurr# < SectCount# THEN GOTO SectNewLine

		FOR V = SectCurrRw% TO TotSectRws%
		LOCATE SectInizRw% + V, 2
		PRINT Blank$;
		NEXT V

GetAnother:     GOSUB GetChar
		'IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO GetAnother
		SectCurr# = FirstRec#
		SectCurrRw% = 1
		' ESC Key
		IF UH$ = CHR$(27) THEN GOTO SectExit

		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO SectArrowDown
SectEnter:      IF SectCurr# < SectCount# - 6 THEN SectCurr# = SectCurr# + 1
		GOTO NewRound

SectArrowDown:  ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO SectKey0
		GOTO SectEnter

SectKey0:       'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO SectKey1
		IF SectCurr# > 0 THEN SectCurr# = SectCurr# - 1
		GOTO NewRound
SectKey1:
		' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO SectKey2
SectPageUp:     SectCurr# = SectCurr# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound

SectKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO SectKey11
SectPageDown:   SectCurr# = SectCurr# + TotSectRws%
		IF SectCurr# > SectCount# - TotSectRws% THEN SectCurr# = SectCount# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound

SectKey11:      'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO SectKey12
		GOTO SectPageDown

SectKey12:      'CTRL Page Up
		IF UH$ <> CHR$(0) + CHR$(132) THEN GOTO SectKey13
		GOTO SectPageUp
SectKey13:
		GOTO NewRound
SectExit:
		V = InizRw% + TotScrRws%
		LOCATE V, 1, 1
		IF V >= 22 THEN GOTO DontDoit ' Blank all unused screen rows, if any

		FOR V = V TO 23
		LOCATE V, 1, 1
		PRINT SPACE$(80)
		NEXT V
DontDoit:

		RETURN
HAbort:
		CLOSE #59
END SUB

' ***  TAB KEY: ViewChosen - DISPLAY LIST OF FILES SELECTED FROM PREVIOUS DIRECTORIES
SUB ViewChosen

		COLOR 14, 0
		Selected$ = "~DOS2IB.TMP"
		OPEN Selected$ FOR RANDOM ACCESS READ AS #5 LEN = LEN(Sel)

		GET #5, 1, FiHeader
		PntLastUsed% = VAL(FiHeader.Pntr)
		OldTotFnames% = VAL(FiHeader.TFIL)
		OldTotSize& = VAL(FiHeader.TSIZ)
		TotDirs% = VAL(FiHeader.TDir)

		' Prepare to show all filenames
		LOCATE 2, 1, 1
		CrrScrnRow% = 1
		TotlScrnRows% = 16     ' Rows to display Filenames
		StrtRow% = 4  ' Screen Start Row
		CrrntFilename% = 1
		AllwdKey$ = CHR$(27)                         ' ESC
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(72) ' Arrow Up
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(80) ' Arrow Down
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(73) ' Page Up
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(81) ' Page Down
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(83) ' Del
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(71) ' Home
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(79) ' End
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(59) ' F1 = Help
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(64) ' F6 = Proceed
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(65) ' F7 = Show Sector
		AllwdKey$ = AllwdKey$ + CHR$(0) + CHR$(66) ' F8 = Show ARK file directory, if applicable
		AllwdKey$ = AllwdKey$ + CHR$(9)            ' TAB -><- = Toggle Screen

		GOSUB TopScrn
' MAIN LOOP STARTS HERE

NxtFileName:
		COLOR 14, 0
		GOSUB ViewFiles2Copy
		IF CrrScrnRow% = 1 THEN FstFilename% = CrrntFilename%   ' Get Number of first filename only
		GOSUB DsplRow  ' Display Crrent Row

		CrrntFilename% = CrrntFilename% + 1 ' Next Fielename


		LstScrnRow% = CrrScrnRow%      ' Save last Screen Row used
		CrrScrnRow% = CrrScrnRow% + 1  ' Next Screen Row
		IF CrrScrnRow% < TotlScrnRows% + 1 AND CrrntFilename% <= PntLastUsed% - 1 THEN GOTO NxtFileName

' MAIN LOOP ENDS HERE
' End of filenames
		GOSUB BottmLine:


		LstFilename% = CrrntFilename% - 1' Get Number of Last used filename
		CrrntFilename% = FstFilename%  ' Current filename is now first filename in screen

		CrrScrnRow% = 1
		IF KeapCursBttom% = 0 THEN GOTO LcateCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last filename in Screen
		CrrScrnRow% = TotlScrnRows%: KeapCursBttom% = 0: CrrntFilename% = LstFilename%
		GOTO LcateCursor2
LcateCursor:
		GOSUB RstoreColor

LcateCursor2:
		LOCATE StrtRow% + CrrScrnRow%, 2, 1
		COLOR 0, 15: GOSUB DsplRow: COLOR 14, 0 ' Display Current Row
		LOCATE StrtRow% + CrrScrnRow%, 2, 1
		OwldScreenRow% = CrrScrnRow%
		OwldFilename% = CrrntFilename%


		'GOSUB ShowValues    ' My little Debugger

DooetAgain:       DO: DU$ = INKEY$: LOOP UNTIL DU$ <> ""
		IF INSTR(AllwdKey$, DU$) = 0 THEN GOTO DooetAgain


		' Arrow Down Key
		IF DU$ <> CHR$(0) + CHR$(80) THEN GOTO OtroKey0
GoDown:         IF CrrScrnRow% < LstScrnRow% THEN CrrScrnRow% = CrrScrnRow% + 1: CrrntFilename% = CrrntFilename% + 1: GOTO LcateCursor
		IF CrrntFilename% = PntLastUsed% - 1 THEN GOTO LcateCursor
		CrrntFilename% = FstFilename% + 1
		' IF CrrntFilename% > PntLastUsed% - TotlScrnRows% + 1 THEN CrrntFilename% = FstFilename% - 1 : goto LcateCursor
		KeapCursBttom% = 1
		IF CrrntFilename% < 1 THEN CrrntFilename% = 1
		GOTO GoExecutit

OtroKey0:         'Arrow up Key
		IF DU$ <> CHR$(0) + CHR$(72) THEN GOTO OtroKey1
		IF CrrntFilename% = 1 THEN GOTO KeineMatch
		IF CrrScrnRow% > 1 THEN CrrScrnRow% = CrrScrnRow% - 1: CrrntFilename% = CrrntFilename% - 1: GOTO LcateCursor
		CrrntFilename% = FstFilename% - 1: IF CrrntFilename% < 1 THEN CrrntFilename% = 1
		GOTO GoExecutit

OtroKey1:         ' Page Up Key
		IF DU$ <> CHR$(0) + CHR$(73) THEN GOTO OtroKey2
		CrrntFilename% = FstFilename% - TotlScrnRows%
		IF CrrntFilename% < 1 THEN CrrntFilename% = 1
		GOTO GoExecutit

OtroKey2:         ' Page Down Key
		IF DU$ <> CHR$(0) + CHR$(81) THEN GOTO OtroKey3
		IF LstFilename% + 1 + TotlScrnRows% > PntLastUsed% - 1 THEN CrrntFilename% = PntLastUsed% - TotlScrnRows% + 1: IF CrrntFilename% < 1 THEN CrrntFilename% = 1: GOTO GoExecutit
		CrrntFilename% = FstFilename% + TotlScrnRows%
		IF CrrntFilename% > PntLastUsed% - 1 THEN CrrntFilename% = FstFilename%
		GOTO GoExecutit

OtroKey3:        GOTO OtroKey7

OtroKey7:         ' Home Key : simply move cursor to top
		IF DU$ <> CHR$(0) + CHR$(71) THEN GOTO OtroKey8
		CrrScrnRow% = 1: CrrntFilename% = FstFilename%: GOTO LcateCursor


OtroKey8:         ' End Key : simply move cursor to bottom
		IF DU$ <> CHR$(0) + CHR$(79) THEN GOTO OtroKey9
		CrrScrnRow% = LstScrnRow%: CrrntFilename% = LstFilename%
		GOTO LcateCursor

OtroKey9:         ' Tab key or ESC key: display list of files selected from previous directories
		IF DU$ <> CHR$(9) AND DU$ <> CHR$(27) AND DU$ <> CHR$(0) + CHR$(64) THEN GOTO OtroKey10
		CLOSE #5
		GOTO ExitViewChosen


OtroKey10:       ' F7 = Sector viewer
		IF DU$ <> CHR$(0) + CHR$(65) THEN GOTO OtroKey11
		GOSUB GetName: IF P <> 0 THEN GOTO KeineMatch

		CALL ShowDOSSector(Mystring$,ToShow$)
		GOSUB NewPaintScreen
		GOTO KeineMatch

'========SHOW ARK FILE
OtroKey11:      IF DU$ <> CHR$(0) + CHR$(66) THEN GOTO OtroKey12     ' F8 = I ARK file, display it
		GOSUB GetName: IF P <> 0 THEN GOTO KeineMatch
		CLS
		COLOR 14, 0
		
		PRINT TAB(5); "Catalog of Archive File: "; Mystring$
		Exec$ = "Decomp4.com " + Mystring$ + " /s"
		SHELL Exec$
		COLOR 7, 0
		CLS
		
		GOSUB NewPaintScreen
		GOTO KeineMatch


OtroKey12:      ' F1 (Help) key
		IF DU$ <> CHR$(0) + CHR$(59) THEN GOTO OtroKey13
		CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "18.04.01")
		GOSUB NewPaintScreen
		GOTO KeineMatch
OtroKey13:
		GOTO KeineMatch
GoExecutit:
		CrrScrnRow% = 1     ' Cursor on first screen row
		LOCATE StrtRow% + CrrScrnRow%, 2, 1
		GOTO NxtFileName   ' Start next round

KeineMatch:         GOTO LcateCursor


' Get Full Path Name of current filename.
' Upon Return, if P=0 then Mystring$ contains the Full Path Name
GetName:                
		GET #5, CrrntFilename% + 1, Sel
		P = INSTR(Sel.SL, "<DIR>"): IF P > 0 THEN BEEP: GOTO GetName4
		P = INSTR(Sel.SL, "<ARK>"): IF P > 0 THEN BEEP: GOTO GetName4
		Mystring$ = LEFT$(Sel.SL, 12)
		Mystring$ = Shrink(Mystring$)
		P = INSTR(1, Mystring$, " "): IF P > 0 THEN MID$(Mystring$, P) = "."
		SArkFilName$ = ""
		FOR T = CrrntFilename% TO 1 STEP -1
		GET #5, T + 1, Sel
		IF SArkFilName$<>"" THEN GOTO GetName0n0
		P = INSTR(Sel.SL, "<ARK>"): IF P = 0 THEN GOTO GetName0n0
		' Found ARK main file
		SArkFilName$ = LTRIM$(RTRIM$(MID$(Sel.SL, 7, 12)))
		CALL Canonize(SArkFilName$)
		GOTO GetName0n2 ' Go and find the File Directory
		
GetName0n0:     P = INSTR(Sel.SL, "<DIR>"): IF P = 0 THEN GOTO GetName0n2
		' Found Directory
		A$ = MID$(Sel.SL, 7, LEN(Sel.SL))
		A$ = LTRIM$(RTRIM$(A$))
		IF SArkFilName$ = "" THEN GOTO GetName0n1
		
		GOSUB GetSUBArk : IF P>0 THEN GOTO GetName4 ' GetSUBArk file=Mystring$ ("~subark.tmp")
		GOTO GetName3

GetName0n1:     Mystring$ = A$ + Mystring$
		ToShow$ = Mystring$
		GOTO GetName3
		
GetName0n2:     NEXT T

GetName2:        P = 1  ' Not found
		GOTO GetName4
GetName3:       
		P = 0' OK, Mystring$ contains the Full Path Name
GetName4:
		RETURN

'==SUBARK START===============================================================         
' Create TEMP Ark File. Extract ArkFile, extract the needed file from it and
' feed it to ShowDOSSector.
'
GetSUBArk:      ToShow$ = Mystring$+SPACE$(10-LEN(Mystring$))
		FileSect$ = A$ + SArkFilName$
		CALL ShortName(FileSect$): IF FileSect$ = "" THEN GOTO GetSUBArkErr
		Exec$ = "Decomp4.com " + FileSect$ + " ~tmpfile.tmp >NULL"
		SHELL Exec$
		
		OPEN "~tmpfile.tmp" FOR RANDOM ACCESS READ AS #7 LEN = 256
		Sectors2Skip = 0: ArkRecord = 0
		TmpFileSects% = 0' Count of Temporary File Sectors
		ArkRecord=0
		
		FIELD #7, 256 AS Kd$
		' Search Filename in SubArkFile
		WHILE NOT EOF(7)
		ArkRecord = ArkRecord + 1
		GET #7, ArkRecord
		FOR KT = 1 TO 14 * 18 STEP 18
		TmpFileSects% = CalcWord(Kd$, KT + 12)
		IF MID$(Kd$, KT, 10) = ToShow$ THEN GOTO TxferArk10
		Sectors2Skip = Sectors2Skip + TmpFileSects%
		NEXT KT
		WEND
		CLOSE #7: KILL "~tmpfile.tmp": GOTO GetSUBArkErr
TxferArk10:     
		KILL "~subark.tmp"
		OPEN "~subark.tmp" FOR BINARY ACCESS WRITE AS #82
		BytePos& = 1  ' Start of TmpFilName$
		TotRec% = 0
		
		' Search the first sector with Data (first sector after "END!" End of File Table Marker)
		IF MID$(Kd$, 253, 4) = "END!" THEN GOTO TxferArk20
		WHILE NOT EOF(7)
		GET #7: ArkRecord = ArkRecord + 1
		IF MID$(Kd$, 253, 4) = "END!" THEN GOTO TxferArk20
		WEND
		PRINT : PRINT "Error. END! (End of Files Marker) not found for SubArk File " + SArkFilName$ + "  inside " + CurrArk$ + " ARK file!": INPUT CCC$
		GOTO TxferArk60

TxferArk20:    ' Actually extract SubArkFile Data
		ArkRecord = ArkRecord + Sectors2Skip
		FOR KT = 1 TO TmpFileSects%
		GET #7, ArkRecord + KT
		PUT #82, BytePos&, Kd$: BytePos& = BytePos& + 256
		NEXT KT
		GOTO TxferArk60

TxferArk40:     PRINT : PRINT "Error. Sub Ark File " + SArkFilName$ + " not found inside " + CurrArk$ + " ARK file!": INPUT CCC$
		CLOSE #7:   GOTO GetSUBArkErr
TxferArk60:     CLOSE #82: Mystring$ = "~subark.tmp":
		CLOSE #7
		P=0
		GOTO GetSUBArkEnd
GetSUBArkErr:   P=1             
GetSUBArkEnd:   RETURN          
		
'==SUBARK END=================================================================         


' ENTER key pressed
' Display Current Row
DsplRow:
		LOCATE StrtRow% + CrrScrnRow%, 1, 1
		GET #5, CrrntFilename% + 1, Sel
		PRINT ""; Sel.CpyMark; "";
		PRINT USING "###"; CrrntFilename%;
		'PRINT ""; FilName$(CrrntFilename%);
		PRINT ""; LEFT$(Sel.SL, 68);
		LOCATE StrtRow% + CrrScrnRow%, , 1

		PRINT TAB(80); "";
		RETURN


RstoreColor:     TmpScreenRow% = CrrScrnRow%
		TmpFilename% = CrrntFilename%
		CrrScrnRow% = OwldScreenRow%
		CrrntFilename% = OwldFilename%
		COLOR 14, 0: GOSUB DsplRow ' Display Crrent Row
		CrrScrnRow% = TmpScreenRow%
		CrrntFilename% = TmpFilename%
		RETURN

ViewFiles2Copy: ' Display total files to be copied

		LOCATE 3, 39
		PRINT TotDirs%;
		LOCATE 3, 57, 1
		PRINT OldTotFnames%;
		LOCATE 3, 69, 1
		PRINT OldTotSize&;
		RETURN


'=================================
' DISPLAY TOP PART OF TITLE SCREEN
'=================================
TopScrn:         CLS
		PRINT "   ===========  LIST FILES COLLECTED FROM PREVIOUS DIRECTORIES  ============"
		PRINT "Ŀ"
		PRINT "  n. Filename          Length DIRs=     Marked Files=       Size=           "
		PRINT "Ĵ"
		GOSUB ViewFiles2Copy
		RETURN


BottmLine:
		PRINT
		PRINT ""
		LOCATE 22, 1
		PRINT "  Keys: Arrow-Up,-Down, Page-Up,-Down. TAB or F6 or ESC to return to main screen"
		PRINT " "



		LOCATE StrtRow% + CrrScrnRow% + 1, 1, 1

		IF CrrScrnRow% > TotlScrnRows% THEN GOTO SkpClear ' Blank all unused screen rows, if any

		FOR V = CrrScrnRow% TO TotlScrnRows%
		PRINT "                                                                                "
		NEXT V
SkpClear:
		RETURN

'=========================
' REDRAW THE ENTIRE SCREEN
'=========================
NewPaintScreen:
		COLOR 14, 0
		GOSUB TopScrn ' Display Top Part of Title Screen
		SaveCrrFilename% = CrrntFilename%
		SavCrrScreenRow% = CrrScrnRow%
		CrrntFilename% = FstFilename%
		FOR CrrScrnRow% = 1 TO TotlScrnRows%
		GOSUB DsplRow  ' Display Crrent Row
		CrrntFilename% = CrrntFilename% + 1 ' Next Filename
		LstScrnRow% = CrrScrnRow%      ' Save last Screen Row used
		IF CrrntFilename% > PntLastUsed% - 1 THEN CrrScrnRow% = CrrScrnRow% + 1: GOTO NewPaintScreen2
		NEXT CrrScrnRow%   ' Next Screen Row
NewPaintScreen2:
		GOSUB BottmLine        ' Display Bottom Line
		CrrntFilename% = SaveCrrFilename%
		CrrScrnRow% = SavCrrScreenRow%
		RETURN





' *** SHOW DOS FILE SECTOR


ExitViewChosen: COLOR 7, 0
END SUB

