' - Paolo Bagnaresi, March 2002 - e-mail: paolo_bagnaresi@libero.it
' THIS PROGRAM CREATES THE HELP.DAT FILE STARTING FROM A 77 COLUMN TEXT FILE (MANUAL.TXT)
' The help.dat file is a 79 byte fixed length file, with CR and LF attached
' at the end of each record.
' It also creates help.idx file, the help index file. Each line in Help.idx
' file will contain the section markers, lines with a leading "##" in Help.txt file, the
' starting sector number and the number of records that belong to that
' section.
		
		PRINT "Please wait while the On-Line Help files are being built..."
		OPEN "Manual.txt" FOR INPUT ACCESS READ AS #1
		RecLen% = 77 + 2
		TYPE IDXType
		Section AS STRING * 20
		StartRec AS DOUBLE
		RecLength AS SINGLE
		END TYPE
		DIM IDXRecord AS IDXType
		OPEN "Manual.idx" FOR RANDOM ACCESS READ WRITE AS #3 LEN = LEN(IDXRecord)
		PUT #3, , IDXRecord
		
		OPEN "Manual.dat" FOR RANDOM ACCESS READ WRITE AS #2 LEN = RecLen%
		CLOSE #2
		KILL "Manual.dat"
		OPEN "Manual.dat" FOR RANDOM ACCESS READ WRITE AS #2 LEN = RecLen%
		FIELD #2, RecLen% AS DL$
		
		WHILE EOF(1) = 0
		LINE INPUT #1, InpRec$
		TRec# = TRec# + 1
		Titl$=LEFT$(InpRec$, 2) 
		
' Replace TAB characters [CHR$(9)] with blanks                 
' Rule: each TAB adds as many blanks as they are missing from the next 8th position 

TAB10:          P=INSTR(InpRec$,CHR$(9)) 
		IF P=0 THEN GOTO TAB30
		Howmany=P-1
		IF Howmany<8 THEN GOTO TAB20
		Howmany=Howmany MOD 8
		
TAB20:          Howmany=8-Howmany
		InpRec$=LEFT$(InpRec$,P-1)+SPACE$(Howmany)+MID$(InpRec$,P+1,LEN(InpRec$))
		GOTO TAB10
		
		
		
TAB30:		IF TitleLine$="" THEN GOTO TAB33 ' was last record a Title Line? No, jump 

' Special Lines. First Line following Title Lines may not be longer than 65 Characters
 		
		IF LEN(InpRec$)<=65 THEN GOTO BELOW
		U$= InpRec$
 		FOR t = 1 TO LEN(U$): IF MID$(U$, t, 1) <> " " AND MID$(U$, t, 1) <> "*" THEN GOTO StrtFound
		NEXT t
		
StrtFound:      U$ = RIGHT$(U$, LEN(U$) - t + 1)
		
		FOR t = LEN(U$) TO 1 STEP -1: IF MID$(U$, t, 1) <> " " AND MID$(U$, t, 1) <> "*" THEN GOTO EndFnd
		NEXT t
		
		
EndFnd:         U$ = LEFT$(U$, t)
		IF LEN(U$)<=65 THEN GOTO BELOW
		
		
		PRINT InpRec$:BEEP
		InpRec$=LEFT$(U$,65)
		GOSUB TitleLineTooLong
		GOTO BELOW

' Standard Lines 
		
TAB33:		IF LEN(InpRec$)<=RecLen%-2 THEN GOTO BELOW
		
		U$=MID$(InpRec$,RecLen%-2, LEN(InpRec$))
		FOR T=1 TO LEN(U$)
		T$=MID$(U$,T,1)
		IF T$<>" " AND T$<>CHR$(9)THEN GOTO ERROR20
		NEXT T
		InpRec$=MID$(InpRec$,1,RecLen%-2)
		GOTO BELOW
		
ERROR20:        


		PRINT InpRec$:BEEP
		PRINT
		PRINT
		PRINT "          === CRManDat.Bas error message ===="
		PRINT "Error: the above line ";TREC#;" is longer than 77 characters and the "
		PRINT "exceeding part below will be Truncated (Press ENTER to continue):"
		PRINT
		PRINT MID$(InpRec$,RecLen%-2,LEN(InpRec$))
		InpRec$=LEFT$(InpRec$,RecLen%-2)
		PRINT
		PRINT
		DO: UTK$ = INKEY$: LOOP UNTIL UTK$ <> ""
		PRINT
BELOW:          
		IF LEFT$(InpRec$, 2) <> "##" THEN GOTO NoIndex
		Entry = Entry + 1
		
		InpRec$ = RIGHT$(InpRec$, LEN(InpRec$) - 2)
		AR$ = InpRec$: InpRec$ = ""
		FOR T = 1 TO LEN(AR$)
		T$ = MID$(AR$, T, 1)
		IF T$ = "." OR (T$ => "0" AND T$ <= "9") OR (T$ => "A" AND T$ <= "Z") THEN GOTO Addit ELSE GOTO SKIPIT
Addit:          InpRec$ = InpRec$ + T$
SKIPIT:         NEXT T
		
		IF Entry = 1 THEN GOTO Skip1
		Length = TRec# - OTrec#
		IDXRecord.Section = OInpRec$
		IDXRecord.StartRec = OTrec# + 1
		IDXRecord.RecLength = Length - 1
		PUT #3, , IDXRecord: TotRec = TotRec + 1
		
Skip1:          OInpRec$ = InpRec$: OTrec# = TRec#
		
NoIndex:        IF (RecLen% - 2) > LEN(InpRec$ )  THEN 
	        	InpRec$ = InpRec$ + SPACE$(RecLen% - LEN(InpRec$) - 2) 
	        	ELSE
	        	PRINT InpRec$ 
	        	PRINT LEN(InpRec$)
			InpRec$ = LEFT$(InpRec$ , RecLen% - 2)
			GOSUB TitleLineTooLong
	        END IF 
	        
		InpRec$ = InpRec$ + CHR$(&HD) + CHR$(&HA)
		LSET DL$ = InpRec$
		PUT #2, TRec#
		
		TitleLine$="" : IF Titl$= "##" THEN TitleLine$="Y"  
		' PRINT DL$
		'INPUT "",c$
		WEND
		CLOSE #1
		CLOSE #2
		Length = TRec# - OTrec#
		IDXRecord.Section = OInpRec$
		IDXRecord.StartRec = OTrec# + 1
		IDXRecord.RecLength = Length
		PUT #3, , IDXRecord: TotRec = TotRec + 1
		
		IDXRecord.Section = STR$(TotRec)
		IDXRecord.StartRec = TotRec
		IDXRecord.RecLength = 0
		PUT #3, 1, IDXRecord
		CLOSE #3
		PRINT
		PRINT "Done! Returning to Main program.."
		RUN "MAIN-02.BAS"
		SYSTEM
		END


TitleLineTooLong: 		
		PRINT
		PRINT "          === CRManDat.Bas error message ===="
		PRINT 
		PRINT "Error: The Above Title Line ";TREC#;" is longer than 65 characters and the "
		PRINT "exceeding part below will be Truncated as follows (Press ENTER to continue):"
		PRINT
		PRINT InpRec$
		
		PRINT
		PRINT
		DO: UTK$ = INKEY$: LOOP UNTIL UTK$ <> ""
		PRINT
		RETURN 