/**********************************************************************
UK101 Memory map

	CPU: 6502 @ 1.0Mhz

Interrupts:	None.

Video:		Memory mapped

Sound:		None

Hardware:	MC6850

		0000-0FFF	RAM (standard)
		1000-1FFF	RAM (expanded)
		2000-9FFF	RAM	(emulator only)
		A000-BFFF	ROM (basic)
		C000-CFFF	NOP
		D000-D3FF	RAM (video)
		D400-DEFF	NOP
		DF00-DF00	H/W (Keyboard)
		DF01-EFFF	NOP
		F000-F001	H/W (MC6850)
		F002-F7FF	NOP
		F800-FFFF	ROM (monitor)
**********************************************************************/
#include "driver.h"
#include "cpu/m6502/m6502.h"
#include "vidhrdw/generic.h"
#include "machine/mc6850.h"
#include "includes/uk101.h"

/* memory w/r functions */

MEMORY_READ_START( uk101_readmem )
	{0x0000, 0x0fff, MRA_RAM},
	{0x1000, 0x1fff, MRA_RAM},
	{0x2000, 0x9fff, MRA_RAM},
	{0xa000, 0xbfff, MRA_ROM},
	{0xc000, 0xcfff, MRA_NOP},
	{0xd000, 0xd3ff, videoram_r},
	{0xd400, 0xdeff, MRA_NOP},
	{0xdf00, 0xdf00, uk101_keyb_r},
	{0xdf01, 0xefff, MRA_NOP},
	{0xf000, 0xf001, acia6850_0_r},
	{0xf002, 0xf7ff, MRA_NOP},
	{0xf800, 0xffff, MRA_ROM},
MEMORY_END

MEMORY_WRITE_START( uk101_writemem )
	{0x0000, 0x0fff, MWA_RAM},
	{0x1000, 0x1fff, MWA_RAM},
	{0x2000, 0x9fff, MWA_RAM},
	{0xa000, 0xbfff, MWA_ROM},
	{0xc000, 0xcfff, MWA_NOP},
	{0xd000, 0xd3ff, videoram_w, &videoram, &videoram_size},
	{0xd400, 0xdeff, MWA_NOP},
	{0xdf00, 0xdf00, uk101_keyb_w},
	{0xdf01, 0xefff, MWA_NOP},
	{0xf000, 0xf001, acia6850_0_w},
	{0xf002, 0xf7ff, MWA_NOP},
	{0xf800, 0xffff, MWA_ROM},
MEMORY_END

MEMORY_READ_START( superbrd_readmem )
	{0x0000, 0x0fff, MRA_RAM},
	{0x1000, 0x1fff, MRA_RAM},
	{0x2000, 0x9fff, MRA_RAM},
	{0xa000, 0xbfff, MRA_ROM},
	{0xc000, 0xcfff, MRA_NOP},
	{0xd000, 0xd7ff, videoram_r},
	{0xd800, 0xdeff, MRA_NOP},
	{0xdf00, 0xdf00, uk101_keyb_r},
	{0xdf01, 0xefff, MRA_NOP},
	{0xf000, 0xf001, acia6850_0_r},
	{0xf002, 0xf7ff, MRA_NOP},
	{0xf800, 0xffff, MRA_ROM},
MEMORY_END

MEMORY_WRITE_START( superbrd_writemem )
	{0x0000, 0x0fff, MWA_RAM},
	{0x1000, 0x1fff, MWA_RAM},
	{0x2000, 0x9fff, MWA_RAM},
	{0xa000, 0xbfff, MWA_ROM},
	{0xc000, 0xcfff, MWA_NOP},
	{0xd000, 0xd7ff, videoram_w, &videoram, &videoram_size},
	{0xd800, 0xdeff, MWA_NOP},
	{0xdf00, 0xdf00, uk101_keyb_w},
	{0xdf01, 0xefff, MWA_NOP},
	{0xf000, 0xf001, acia6850_0_w},
	{0xf002, 0xf7ff, MWA_NOP},
	{0xf800, 0xffff, MWA_ROM},
MEMORY_END

/* graphics output */

struct GfxLayout uk101_charlayout =
{
	8, 16,
	256,
	1,
	{ 0 },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0*8, 0*8, 1*8, 1*8, 2*8, 2*8, 3*8, 3*8,
	  4*8, 4*8, 5*8, 5*8, 6*8, 6*8, 7*8, 7*8 },
	8 * 8
};

static struct	GfxDecodeInfo uk101_gfxdecodeinfo[] =
{
	{ REGION_GFX1, 0x0000, &uk101_charlayout, 0, 1},
MEMORY_END

static unsigned char uk101_palette[2 * 3] =
{
	0x00, 0x00, 0x00,	/* Black */
	0xff, 0xff, 0xff	/* White */
};

static unsigned short uk101_colortable[] =
{
	0,1
};

static PALETTE_INIT( uk101 )
{
	palette_set_colors(0, uk101_palette, sizeof(uk101_palette) / 3);
	memcpy(colortable, uk101_colortable, sizeof (uk101_colortable));
}

/* keyboard input */
INPUT_PORTS_START( uk101 )
	PORT_START	/* 0: DF00 & 0x80 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_KEYBOARD, "7", KEYCODE_7, IP_JOY_NONE )
	PORT_BITX( 0x04, IP_ACTIVE_LOW, IPT_KEYBOARD, "6", KEYCODE_6, IP_JOY_NONE )
	PORT_BITX( 0x08, IP_ACTIVE_LOW, IPT_KEYBOARD, "5", KEYCODE_5, IP_JOY_NONE )
	PORT_BITX( 0x10, IP_ACTIVE_LOW, IPT_KEYBOARD, "4", KEYCODE_4, IP_JOY_NONE )
	PORT_BITX( 0x20, IP_ACTIVE_LOW, IPT_KEYBOARD, "3", KEYCODE_3, IP_JOY_NONE )
	PORT_BITX( 0x40, IP_ACTIVE_LOW, IPT_KEYBOARD, "2", KEYCODE_2, IP_JOY_NONE )
	PORT_BITX( 0x80, IP_ACTIVE_LOW, IPT_KEYBOARD, "1", KEYCODE_1, IP_JOY_NONE )
	PORT_START /* 1: DF00 & 0x40 */
	PORT_BIT( 0x03, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX( 0x04, IP_ACTIVE_LOW, IPT_KEYBOARD, "Backspace", KEYCODE_BACKSPACE, IP_JOY_NONE )
	PORT_BITX( 0x08, IP_ACTIVE_LOW, IPT_KEYBOARD, "-", KEYCODE_MINUS, IP_JOY_NONE )
	PORT_BITX( 0x10, IP_ACTIVE_LOW, IPT_KEYBOARD, ":", KEYCODE_COLON, IP_JOY_NONE )
	PORT_BITX( 0x20, IP_ACTIVE_LOW, IPT_KEYBOARD, "0", KEYCODE_0, IP_JOY_NONE )
	PORT_BITX( 0x40, IP_ACTIVE_LOW, IPT_KEYBOARD, "9", KEYCODE_9, IP_JOY_NONE )
	PORT_BITX( 0x80, IP_ACTIVE_LOW, IPT_KEYBOARD, "8", KEYCODE_8, IP_JOY_NONE )
	PORT_START /* 2: DF00 & 0x20 */
	PORT_BIT( 0x07, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX( 0x08, IP_ACTIVE_LOW, IPT_KEYBOARD, "Enter", KEYCODE_ENTER, IP_JOY_NONE )
	PORT_BITX( 0x10, IP_ACTIVE_LOW, IPT_KEYBOARD, "\\", KEYCODE_BACKSLASH, IP_JOY_NONE )
	PORT_BITX( 0x20, IP_ACTIVE_LOW, IPT_KEYBOARD, "O", KEYCODE_O, IP_JOY_NONE )
	PORT_BITX( 0x40, IP_ACTIVE_LOW, IPT_KEYBOARD, "L", KEYCODE_L, IP_JOY_NONE )
	PORT_BITX( 0x80, IP_ACTIVE_LOW, IPT_KEYBOARD, ".", KEYCODE_STOP, IP_JOY_NONE )
	PORT_START /* 3: DF00 & 0x10 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_KEYBOARD, "I", KEYCODE_I, IP_JOY_NONE )
	PORT_BITX( 0x04, IP_ACTIVE_LOW, IPT_KEYBOARD, "U", KEYCODE_U, IP_JOY_NONE )
	PORT_BITX( 0x08, IP_ACTIVE_LOW, IPT_KEYBOARD, "Y", KEYCODE_Y, IP_JOY_NONE )
	PORT_BITX( 0x10, IP_ACTIVE_LOW, IPT_KEYBOARD, "T", KEYCODE_T, IP_JOY_NONE )
	PORT_BITX( 0x20, IP_ACTIVE_LOW, IPT_KEYBOARD, "R", KEYCODE_R, IP_JOY_NONE )
	PORT_BITX( 0x40, IP_ACTIVE_LOW, IPT_KEYBOARD, "E", KEYCODE_E, IP_JOY_NONE )
	PORT_BITX( 0x80, IP_ACTIVE_LOW, IPT_KEYBOARD, "W", KEYCODE_W, IP_JOY_NONE )
	PORT_START /* 4: DF00 & 0x08 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_KEYBOARD, "K", KEYCODE_K, IP_JOY_NONE )
	PORT_BITX( 0x04, IP_ACTIVE_LOW, IPT_KEYBOARD, "J", KEYCODE_J, IP_JOY_NONE )
	PORT_BITX( 0x08, IP_ACTIVE_LOW, IPT_KEYBOARD, "H", KEYCODE_H, IP_JOY_NONE )
	PORT_BITX( 0x10, IP_ACTIVE_LOW, IPT_KEYBOARD, "G", KEYCODE_G, IP_JOY_NONE )
	PORT_BITX( 0x20, IP_ACTIVE_LOW, IPT_KEYBOARD, "F", KEYCODE_F, IP_JOY_NONE )
	PORT_BITX( 0x40, IP_ACTIVE_LOW, IPT_KEYBOARD, "D", KEYCODE_D, IP_JOY_NONE )
	PORT_BITX( 0x80, IP_ACTIVE_LOW, IPT_KEYBOARD, "S", KEYCODE_S, IP_JOY_NONE )
	PORT_START /* 5: DF00 & 0x04 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_KEYBOARD, ",", KEYCODE_COMMA, IP_JOY_NONE )
	PORT_BITX( 0x04, IP_ACTIVE_LOW, IPT_KEYBOARD, "M", KEYCODE_M, IP_JOY_NONE )
	PORT_BITX( 0x08, IP_ACTIVE_LOW, IPT_KEYBOARD, "N", KEYCODE_N, IP_JOY_NONE )
	PORT_BITX( 0x10, IP_ACTIVE_LOW, IPT_KEYBOARD, "B", KEYCODE_B, IP_JOY_NONE )
	PORT_BITX( 0x20, IP_ACTIVE_LOW, IPT_KEYBOARD, "V", KEYCODE_V, IP_JOY_NONE )
	PORT_BITX( 0x40, IP_ACTIVE_LOW, IPT_KEYBOARD, "C", KEYCODE_C, IP_JOY_NONE )
	PORT_BITX( 0x80, IP_ACTIVE_LOW, IPT_KEYBOARD, "X", KEYCODE_X, IP_JOY_NONE )
	PORT_START /* 6: DF00 & 0x02 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_KEYBOARD, "P", KEYCODE_P, IP_JOY_NONE )
	PORT_BITX( 0x04, IP_ACTIVE_LOW, IPT_KEYBOARD, "'", KEYCODE_QUOTE, IP_JOY_NONE )
	PORT_BITX( 0x08, IP_ACTIVE_LOW, IPT_KEYBOARD, "/", KEYCODE_SLASH, IP_JOY_NONE )
	PORT_BITX( 0x10, IP_ACTIVE_LOW, IPT_KEYBOARD, "Space", KEYCODE_SPACE, IP_JOY_NONE )
	PORT_BITX( 0x20, IP_ACTIVE_LOW, IPT_KEYBOARD, "Z", KEYCODE_Z, IP_JOY_NONE )
	PORT_BITX( 0x40, IP_ACTIVE_LOW, IPT_KEYBOARD, "A", KEYCODE_A, IP_JOY_NONE )
	PORT_BITX( 0x80, IP_ACTIVE_LOW, IPT_KEYBOARD, "Q", KEYCODE_Q, IP_JOY_NONE )
	PORT_START /* 7: DF00 & 0x01 */
	PORT_BITX( 0x01, IP_ACTIVE_LOW, IPT_KEYBOARD | IPF_TOGGLE, "Caps Lock", KEYCODE_CAPSLOCK, IP_JOY_NONE )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_KEYBOARD, "Right Shift", KEYCODE_RSHIFT, IP_JOY_NONE )
	PORT_BITX( 0x04, IP_ACTIVE_LOW, IPT_KEYBOARD, "Left Shift", KEYCODE_LSHIFT, IP_JOY_NONE )
	PORT_BIT( 0x18, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BITX( 0x20, IP_ACTIVE_LOW, IPT_KEYBOARD, "Escape", KEYCODE_ESC, IP_JOY_NONE )
	PORT_BITX( 0x40, IP_ACTIVE_LOW, IPT_KEYBOARD, "Control", KEYCODE_LCONTROL, IP_JOY_NONE )
	PORT_BITX( 0x40, IP_ACTIVE_LOW, IPT_KEYBOARD, "Control", KEYCODE_RCONTROL, IP_JOY_NONE )
	PORT_BITX( 0x80, IP_ACTIVE_LOW, IPT_KEYBOARD, "~", KEYCODE_TILDE, IP_JOY_NONE )
	PORT_START	/* 8: Machine config */
	PORT_DIPNAME( 0x03, 0, "RAM Size" )
	PORT_DIPSETTING( 0, "4Kb" )
	PORT_DIPSETTING( 1, "8Kb" )
	PORT_DIPSETTING( 2, "40Kb" )
INPUT_PORTS_END

static INTERRUPT_GEN( uk101_interrupt )
{
	cpu_set_irq_line(0, 0, PULSE_LINE);
}

/* machine definition */
static MACHINE_DRIVER_START( uk101 )
	/* basic machine hardware */
	MDRV_CPU_ADD_TAG("main", M6502, 1000000)
	MDRV_CPU_MEMORY( uk101_readmem, uk101_writemem )
	MDRV_CPU_VBLANK_INT(uk101_interrupt, 1)
	MDRV_FRAMES_PER_SECOND(50)
	MDRV_VBLANK_DURATION(2500)
	MDRV_INTERLEAVE(1)

	MDRV_MACHINE_INIT( uk101 )

    /* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(32 * 8, 25 * 16)
	MDRV_VISIBLE_AREA(0, 32 * 8 - 1, 0, 25 * 16 - 1)
	MDRV_GFXDECODE( uk101_gfxdecodeinfo )
	MDRV_PALETTE_LENGTH(2)
	MDRV_COLORTABLE_LENGTH(2)
	MDRV_PALETTE_INIT( uk101 )

	MDRV_VIDEO_START( generic )
	MDRV_VIDEO_UPDATE( uk101 )
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( superbrd )
	MDRV_IMPORT_FROM( uk101 )
	MDRV_CPU_MODIFY( "main" )
	MDRV_CPU_MEMORY( superbrd_readmem, superbrd_writemem )
	MDRV_SCREEN_SIZE(64 * 8, 16 * 16)
	MDRV_VISIBLE_AREA(0, 64 * 8 - 1, 0, 16 * 16 - 1)
	MDRV_VIDEO_UPDATE( superbrd )
MACHINE_DRIVER_END

ROM_START(uk101)
	ROM_REGION(0x10000, REGION_CPU1,0)
	ROM_LOAD("basuk01.rom", 0xa000, 0x0800, CRC(9d3caa92))
	ROM_LOAD("basuk02.rom", 0xa800, 0x0800, CRC(0039ef6a))
	ROM_LOAD("basuk03.rom", 0xb000, 0x0800, CRC(0d011242))
	ROM_LOAD("basuk04.rom", 0xb800, 0x0800, CRC(667223e8))
	ROM_LOAD("monuk02.rom", 0xf800, 0x0800, CRC(04ac5822))
	ROM_REGION(0x800, REGION_GFX1,0)
	ROM_LOAD("chguk101.rom", 0x0000, 0x0800, CRC(fce2c84a))
ROM_END

ROM_START(superbrd)
	ROM_REGION(0x10000, REGION_CPU1,0)
	ROM_LOAD("basus01.rom", 0xa000, 0x0800, CRC(f4f5dec0))
	ROM_LOAD("basuk02.rom", 0xa800, 0x0800, CRC(0039ef6a))
	ROM_LOAD("basus03.rom", 0xb000, 0x0800, CRC(ca25f8c1))
	ROM_LOAD("basus04.rom", 0xb800, 0x0800, CRC(8ee6030e))
	ROM_LOAD("monus02.rom", 0xf800, 0x0800, CRC(e5b7028d))
	ROM_REGION(0x800, REGION_GFX1,0)
	ROM_LOAD("chgsuper.rom", 0x0000, 0x0800, BAD_DUMP CRC(136b5018))
ROM_END

SYSTEM_CONFIG_START(uk101)
	CONFIG_DEVICE_LEGACY(IO_CASSETTE, 1, "bas\0", DEVICE_LOAD_RESETS_NONE, OSD_FOPEN_READ, NULL, NULL, device_load_uk101_cassette, device_unload_uk101_cassette, NULL)
SYSTEM_CONFIG_END

/*    YEAR	NAME		PARENT	COMPAT	MACHINE		INPUT	INIT	CONFIG  COMPANY				FULLNAME */
COMP( 1979,	uk101,		0,		0,		uk101,		uk101,	0,		uk101,	"Compukit",			"UK101" )
COMP( 1979, superbrd,	uk101,	0,		superbrd,	uk101,	0,		uk101,	"Ohio Scientific",	"Superboard II" )

