unit DATable;

interface

 { /-tabulation }
 { *-data16 }
 { #-data08 }
 { $-128 replacement }
 { &-code address }
 { %-memory address }
 { ~-(HL), (IX), (IY) }
 { ^-HL, IX, IY }
 { @xx-Prefix CB(0), ED(1), DD(2), FD(3) }
 { !-invalid instruction}
 { `-alternate command daa, das}
const
 Instr : array[$00..$FF] of string[12]=
 (
 {00-3F}
 'nop'      ,'ld/BC, *'  ,'ld/"(BC), A','inc/BC','inc/B' ,'dec/B' ,'ld/B, #' ,'rlca',
 'ex/A, A''','add/^, BC' ,'ld/A, "(BC)','dec/BC','inc/C' ,'dec/C' ,'ld/C, #' ,'rrca',
 'djnz/$'   ,'ld/DE, *'  ,'ld/"(DE), A','inc/DE','inc/D' ,'dec/D' ,'ld/D, #' ,'rla',
 'jr/$'     ,'add/^, DE' ,'ld/A, "(DE)','dec/DE','inc/E' ,'dec/E' ,'ld/E, #' ,'rra',
 'jr/nz, $' ,'ld/^, *'   ,'ld/"(%), ^' ,'inc/^' ,'inc/H' ,'dec/H' ,'ld/H, #' ,'daa',
 'jr/z, $'  ,'add/^, ^'  ,'ld/^, "(%)' ,'dec/^' ,'inc/L' ,'dec/L' ,'ld/L, #' ,'cpl',
 'jr/nc, $' ,'ld/SP, *'  ,'ld/"(%), A' ,'inc/SP','inc/"~','dec/"~','ld/"~, #','scf',
 'jr/c, $'  ,'add/^, SP' ,'ld/A, "(%)' ,'dec/SP','inc/A' ,'dec/A' ,'ld/A, #' ,'ccf',
 {40-7F}
 'ld/B, B' ,'ld/B, C' ,'ld/B, D' ,'ld/B, E' ,'ld/B, H' ,'ld/B, L' ,'ld/B, "~','ld/B, A',
 'ld/C, B' ,'ld/C, C' ,'ld/C, D' ,'ld/C, E' ,'ld/C, H' ,'ld/C, L' ,'ld/C, "~','ld/C, A',
 'ld/D, B' ,'ld/D, C' ,'ld/D, D' ,'ld/D, E' ,'ld/D, H' ,'ld/D, L' ,'ld/D, "~','ld/D, A',
 'ld/E, B' ,'ld/E, C' ,'ld/E, D' ,'ld/E, E' ,'ld/E, H' ,'ld/E, L' ,'ld/E, "~','ld/E, A',
 'ld/H, B' ,'ld/H, C' ,'ld/H, D' ,'ld/H, E' ,'ld/H, H' ,'ld/H, L' ,'ld/H, "~','ld/H, A',
 'ld/L, B' ,'ld/L, C' ,'ld/L, D' ,'ld/L, E' ,'ld/L, H' ,'ld/L, L' ,'ld/L, "~','ld/L, A',
 'ld/"~, B','ld/"~, C','ld/"~, D','ld/"~, E','ld/"~, H','ld/"~, L','halt'    ,'ld/"~, A',
 'ld/A, B' ,'ld/A, C' ,'ld/A, D' ,'ld/A, E' ,'ld/A, H' ,'ld/A, L' ,'ld/A, "~','ld/A, A',
 {80-BF}
 'add/A, B','add/A, C','add/A, D','add/A, E','add/A, H','add/A, L','add/A, "~','add/A, A',
 'adc/A, B','adc/A, C','adc/A, D','adc/A, E','adc/A, H','adc/A, L','adc/A, "~','adc/A, A',
 'sub/B'   ,'sub/C'   ,'sub/D'   ,'sub/E'   ,'sub/H'   ,'sub/L'   ,'sub/"~'   ,'sub/A'   ,
 'sbc/A, B','sbc/A, C','sbc/A, D','sbc/A, E','sbc/A, H','sbc/A, L','sbc/A, "~','sbc/A, A',
 'and/B'   ,'and/C'   ,'and/D'   ,'and/E'   ,'and/H'   ,'and/L'   ,'and/"~'   ,'and/A'   ,
 'xor/B'   ,'xor/C'   ,'xor/D'   ,'xor/E'   ,'xor/H'   ,'xor/L'   ,'xor/"~'   ,'xor/A'   ,
 'or/B'    ,'or/C'    ,'or/D'    ,'or/E'    ,'or/H'    ,'or/L'    ,'or/"~'    ,'or/A'    ,
 'cp/B'    ,'cp/C'    ,'cp/D'    ,'cp/E'    ,'cp/H'    ,'cp/L'    ,'cp/"~'    ,'cp/A'    ,
 {C0-FF}
 'ret/nz','pop/BC'   ,'jp/nz, &','jp/&'       ,'call/nz, &','push/BC','add/A, #','rst/00',
 'ret/z' ,'ret'      ,'jp/z, &' ,'@0'         ,'call/z, &' ,'call/&' ,'adc/A, #','rst/08',
 'ret/nc','pop/DE'   ,'jp/nc, &','out/(#), A' ,'call/nc, &','push/DE','sub/#'   ,'rst/10',
 'ret/c' ,'exx'      ,'jp/c, &' ,'in/A, (#)'  ,'call/c, &' ,'@2'     ,'sbc/A, #','rst/18',
 'ret/po','pop/^'    ,'jp/po, &','ex/"(SP), ^','call/po, &','push/^' ,'and/#'   ,'rst/20',
 'ret/pe','jp/(^)'   ,'jp/pe, &','ex/DE, ^'   ,'call/pe, &','@1'     ,'xor/#'   ,'rst/28',
 'ret/p' ,'pop/AF'   ,'jp/p, &' ,'di'         ,'call/p, &' ,'push/AF','or/#'    ,'rst/30',
 'ret/m' ,'ld/SP, ^' ,'jp/m, &' ,'ei'         ,'call/m, &' ,'@3'     ,'cp/#'    ,'rst/38' );

 InstrCB : array[$00..$FF] of string[12]=
 (
 {00-3F}
 'rlc/B','rlc/C','rlc/D','rlc/E','rlc/H','rlc/L','rlc/"~','rlc/A',
 'rrc/B','rrc/C','rrc/D','rrc/E','rrc/H','rrc/L','rrc/"~','rrc/A',
 'rl/B' ,'rl/C' ,'rl/D' ,'rl/E' ,'rl/H' ,'rl/L' ,'rl/"~' ,'rl/A' ,
 'rr/B' ,'rr/C' ,'rr/D' ,'rr/E' ,'rr/H' ,'rr/L' ,'rr/"~' ,'rr/A' ,
 'sla/B','sla/C','sla/D','sla/E','sla/H','sla/L','sla/"~','sla/A',
 'sra/B','sra/C','sra/D','sra/E','sra/H','sra/L','sra/"~','sra/A',
 'sll/B','sll/C','sll/D','sll/E','sll/H','sll/L','sll/"~','sll/A',
 'srl/B','srl/C','srl/D','srl/E','srl/H','srl/L','srl/"~','srl/A',
 {40-7F}
 'bit/0, B','bit/0, C','bit/0, D','bit/0, E','bit/0, H','bit/0, L','bit/0, "~','bit/0, A',
 'bit/1, B','bit/1, C','bit/1, D','bit/1, E','bit/1, H','bit/1, L','bit/1, "~','bit/1, A',
 'bit/2, B','bit/2, C','bit/2, D','bit/2, E','bit/2, H','bit/2, L','bit/2, "~','bit/2, A',
 'bit/3, B','bit/3, C','bit/3, D','bit/3, E','bit/3, H','bit/3, L','bit/3, "~','bit/3, A',
 'bit/4, B','bit/4, C','bit/4, D','bit/4, E','bit/4, H','bit/4, L','bit/4, "~','bit/4, A',
 'bit/5, B','bit/5, C','bit/5, D','bit/5, E','bit/5, H','bit/5, L','bit/5, "~','bit/5, A',
 'bit/6, B','bit/6, C','bit/6, D','bit/6, E','bit/6, H','bit/6, L','bit/6, "~','bit/6, A',
 'bit/7, B','bit/7, C','bit/7, D','bit/7, E','bit/7, H','bit/7, L','bit/7, "~','bit/7, A',
 {80-BF}
 'res/0, B','res/0, C','res/0, D','res/0, E','res/0, H','res/0, L','res/0, "~','res/0, A',
 'res/1, B','res/1, C','res/1, D','res/1, E','res/1, H','res/1, L','res/1, "~','res/1, A',
 'res/2, B','res/2, C','res/2, D','res/2, E','res/2, H','res/2, L','res/2, "~','res/2, A',
 'res/3, B','res/3, C','res/3, D','res/3, E','res/3, H','res/3, L','res/3, "~','res/3, A',
 'res/4, B','res/4, C','res/4, D','res/4, E','res/4, H','res/4, L','res/4, "~','res/4, A',
 'res/5, B','res/5, C','res/5, D','res/5, E','res/5, H','res/5, L','res/5, "~','res/5, A',
 'res/6, B','res/6, C','res/6, D','res/6, E','res/6, H','res/6, L','res/6, "~','res/6, A',
 'res/7, B','res/7, C','res/7, D','res/7, E','res/7, H','res/7, L','res/7, "~','res/7, A',
 {C0-FF}
 'set/0, B','set/0, C','set/0, D','set/0, E','set/0, H','set/0, L','set/0, "~','set/0, A',
 'set/1, B','set/1, C','set/1, D','set/1, E','set/1, H','set/1, L','set/1, "~','set/1, A',
 'set/2, B','set/2, C','set/2, D','set/2, E','set/2, H','set/2, L','set/2, "~','set/2, A',
 'set/3, B','set/3, C','set/3, D','set/3, E','set/3, H','set/3, L','set/3, "~','set/3, A',
 'set/4, B','set/4, C','set/4, D','set/4, E','set/4, H','set/4, L','set/4, "~','set/4, A',
 'set/5, B','set/5, C','set/5, D','set/5, E','set/5, H','set/5, L','set/5, "~','set/5, A',
 'set/6, B','set/6, C','set/6, D','set/6, E','set/6, H','set/6, L','set/6, "~','set/6, A',
 'set/7, B','set/7, C','set/7, D','set/7, E','set/7, H','set/7, L','set/7, "~','set/7, A' );

 InstrED : array[$00..$FF] of string[12]=
 (
 {00-3F}
 '','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 {40-7F}
 'in/B, (C)','out/(C), B','sbc/^, BC','ld/"(%), BC','neg','retn','im/0','ld/I, A',
 'in/C, (C)','out/(C), C','adc/^, BC','ld/BC, "(%)','!'  ,'reti','!'   ,'ld/R, A',
 'in/D, (C)','out/(C), D','sbc/^, DE','ld/"(%), DE','!'  ,'!'   ,'im/1','ld/A, I',
 'in/E, (C)','out/(C), E','adc/^, DE','ld/DE, "(%)','!'  ,'!'   ,'im/2','ld/A, R',
 'in/H, (C)','out/(C), H','sbc/^, ^' ,'ld/"(%), ^' ,'!'  ,'!'   ,'!'   ,'rrd',
 'in/L, (C)','out/(C), L','adc/^, ^' ,'ld/^, "(%)' ,'!'  ,'!'   ,'!'   ,'rld',
 'in/?, (C)','!'         ,'sbc/^, SP','ld/"(%), SP','!'  ,'!'   ,'!'   ,'!',
 'in/A, (C)','out/(C), A','adc/^, SP','ld/SP, "(%)','!'  ,'!'   ,'!'   ,'!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 {A0-BF}
 'ldi'   ,'cpi' ,'ini' ,'outi','!','!','!','!',
 'ldd'   ,'cpd' ,'ind' ,'outd','!','!','!','!',
 'ldir "','cpir','inir','otir','!','!','!','!',
 'lddr "','cpdr','indr','otdr','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','WaitInts');

 Stat : array[$00..$FF] of byte=
 (
{00} $00,$12,$00,$00,$00,$00,$01,$00,
     $00,$00,$00,$00,$00,$00,$01,$00,
{10} $C1,$12,$00,$00,$00,$00,$01,$00,
     $B1,$00,$00,$00,$00,$00,$01,$00,
{20} $C1,$12,$A2,$00,$00,$00,$01,$00,
     $C1,$00,$22,$00,$00,$00,$01,$00,
{30} $C1,$12,$02,$00,$30,$30,$31,$00,
     $C1,$00,$02,$00,$00,$00,$01,$00,

{40} $00,$00,$00,$00,$00,$00,$30,$00, $00,$00,$00,$00,$00,$00,$30,$00,
{50} $00,$00,$00,$00,$00,$00,$30,$00, $00,$00,$00,$00,$00,$00,$30,$00,
{60} $00,$00,$00,$00,$00,$00,$30,$00, $00,$00,$00,$00,$00,$00,$30,$00,
{70} $30,$30,$30,$30,$30,$30,$00,$30, $00,$00,$00,$00,$00,$00,$30,$00,

{80} $00,$00,$00,$00,$00,$00,$30,$00, $00,$00,$00,$00,$00,$00,$30,$00,
{90} $00,$00,$00,$00,$00,$00,$30,$00, $00,$00,$00,$00,$00,$00,$30,$00,
{A0} $00,$00,$00,$00,$00,$00,$30,$00, $00,$00,$00,$00,$00,$00,$30,$00,
{B0} $00,$00,$00,$00,$00,$00,$30,$00, $00,$00,$00,$00,$00,$00,$30,$00,
     {8} {9} {A} {B} {C} {D} {E} {F}
{C0} $00,$00,$D2,$92,$D2,$00,$01,$00,
     $00,$F0,$D2,$50,$D2,$E2,$01,$00,
{D0} $00,$00,$D2,$01,$D2,$00,$01,$00,
     $00,$00,$D2,$01,$D2,$70,$01,$00,
{E0} $00,$00,$D2,$00,$D2,$00,$01,$00,
     $00,$F0,$D2,$00,$D2,$60,$01,$00,
{F0} $00,$00,$D2,$00,$D2,$00,$01,$00,
     $00,$00,$D2,$00,$D2,$80,$01,$00 );

 StatED : array[$00..$FF] of byte=
 (
 {00-3F}
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
             {03}
 $00,$00,$00,$A2,$00,$00,$00,$00,
 $00,$00,$00,$22,$00,$00,$00,$00,
 $00,$00,$00,$A2,$00,$00,$00,$00,
 $00,$00,$00,$22,$00,$00,$00,$00,
 $00,$00,$00,$A2,$00,$00,$00,$00,
 $00,$00,$00,$22,$00,$00,$00,$00,
 $00,$00,$00,$A2,$00,$00,$00,$00,
 $00,$00,$00,$22,$00,$00,$00,$00,

 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,

 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
 $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 );

 Instr8088 : array[$00..$FF] of string[20]=
 (
 {00-3F}
 'nop'   ,'mov/cx, *','MOV_CX_al_"'  ,'inc_cx','inc/ch','dec/ch','mov/ch, #','rol/al, 1',
 'EX_A_A','add/^, cx','MOV_al_CX_"'  ,'dec_cx','inc/cl','dec/cl','mov/cl, #','ror/al, 1',
 'DJNZ/$','mov/dx, *','mov_DX_al_"'  ,'inc_dx','inc/dh','dec/dh','mov/dh, #','rcl/al, 1',
 'jmp/$' ,'add/^, dx','mov_al_DX_"'  ,'dec_dx','inc/dl','dec/dl','mov/dl, #','rcr/al, 1',
 'jnz/$' ,'mov/^, *' ,'mov/":[%], ^' ,'inc_^' ,'inc/bh','dec/bh','mov/bh, #','`'{daa},
 'jz/$'  ,'add/^, ^' ,'mov/^, ":[%]' ,'dec_^' ,'inc/bl','dec/bl','mov/bl, #','not/al',
 'jnc/$' ,'mov/sp, *','mov/":[%], al','inc_sp','inc/byte ptr ":~','dec/byte ptr ":~','mov/byte ptr ":~, #','stc',
 'jc/$'  ,'add/^, sp','mov/al, ":[%]','dec_sp','inc/al','dec/al','mov/al, #','cmc',
 {40-7F}
 'mov/ch, ch'  ,'mov/ch, cl'  ,'mov/ch, dh'  ,'mov/ch, dl'  ,'mov/ch, bh'  ,'mov/ch, bl'  ,'mov/ch, ":~','mov/ch, al',
 'mov/cl, ch'  ,'mov/cl, cl'  ,'mov/cl, dh'  ,'mov/cl, dl'  ,'mov/cl, bh'  ,'mov/cl, bl'  ,'mov/cl, ":~','mov/cl, al',
 'mov/dh, ch'  ,'mov/dh, cl'  ,'mov/dh, dh'  ,'mov/dh, dl'  ,'mov/dh, bh'  ,'mov/dh, bl'  ,'mov/dh, ":~','mov/dh, al',
 'mov/dl, ch'  ,'mov/dl, cl'  ,'mov/dl, dh'  ,'mov/dl, dl'  ,'mov/dl, bh'  ,'mov/dl, bl'  ,'mov/dl, ":~','mov/dl, al',
 'mov/bh, ch'  ,'mov/bh, cl'  ,'mov/bh, dh'  ,'mov/bh, dl'  ,'mov/bh, bh'  ,'mov/bh, bl'  ,'mov/bh, ":~','mov/bh, al',
 'mov/bl, ch'  ,'mov/bl, cl'  ,'mov/bl, dh'  ,'mov/bl, dl'  ,'mov/bl, bh'  ,'mov/bl, bl'  ,'mov/bl, ":~','mov/bl, al',
 'mov/":~, ch' ,'mov/":~, cl' ,'mov/":~, dh' ,'mov/":~, dl' ,'mov/":~, bh' ,'mov/":~, bl','halt'        ,'mov/":~, al',
 'mov/al, ch'  ,'mov/al, cl'  ,'mov/al, dh'  ,'mov/al, dl'  ,'mov/al, bh'  ,'mov/al, bl'  ,'mov/al, ":~','mov/al, al',
 {80-BF}
 'add/al, ch','add/al, cl','add/al, dh','add/al, dl','add/al, bh','add/al, bl','add/al, ":~','add/al, al',
 'adc/al, ch','adc/al, cl','adc/al, dh','adc/al, dl','adc/al, bh','adc/al, bl','adc/al, ":~','adc/al, al',
 'sub/al, ch','sub/al, cl','sub/al, dh','sub/al, dl','sub/al, bh','sub/al, bl','sub/al, ":~','sub/al, al',
 'sbb/al, ch','sbb/al, cl','sbb/al, dh','sbb/al, dl','sbb/al, bh','sbb/al, bl','sbb/al, ":~','sbb/al, al',
 'and/al, ch','and/al, cl','and/al, dh','and/al, dl','and/al, bh','and/al, bl','and/al, ":~','and/al, al',
 'xor/al, ch','xor/al, cl','xor/al, dh','xor/al, dl','xor/al, bh','xor/al, bl','xor/al, ":~','xor/al, al',
 'or/al, ch' ,'or/al, cl' ,'or/al, dh' ,'or/al, dl' ,'or/al, bh' ,'or/al, bl' ,'or/al, ":~' ,'or/al, al' ,
 'cmp/al, ch','cmp/al, cl','cmp/al, dh','cmp/al, dl','cmp/al, bh','cmp/al, bl','cmp/al, ":~','cmp/al, al',
 {C0-FF}
 'RETNZ','pop/cx'    ,'jnz/&','jmp/&'          ,'CALNZ/&','push/cx','add/al, #','RST_00',
 'RETZ' ,'ret'       ,'jz/&' ,'@0'             ,'CALZ/&' ,'call/&' ,'adc/al, #','RST_08',
 'RETNC','pop/dx'    ,'jnc/&','out_#_al'       ,'CALNC/&','push/dx','sub/al, #','RST_10',
 'RETC' ,'EXX'       ,'jc/&' ,'in_al_#'        ,'CALC/&' ,'@2'     ,'sbb/al, #','RST_18',
 'RETPO','pop/^'     ,'jpo/&','xchg/":[esp], ^','CALPO/&','push/^' ,'and/al, #','RST_20',
 'RETPE','jmp/^'     ,'jpe/&','xchg/dx, ^'     ,'CALPE/&','@1'     ,'xor/al, #','RST_28',
 'RETP' ,'POP_AF'    ,'jns/&','_DI'            ,'CALP/&' ,'PUSH_AF','or/al, #' ,'RST_30',
 'RETM' ,'mov/sp, ^' ,'js/&' ,'_EI'            ,'CALM/&' ,'@3'     ,'cmp/al, #','RST_38' );

 InstrCB8088 : array[$00..$FF] of string[25]=
 (
 {00-3F}
 'rol/ch, 1','rol/cl, 1','rol/dh, 1','rol/dl, 1','rol/bh, 1','rol/bl, 1','rol/byte ptr ":~, 1','rol/al, 1',
 'ror/ch, 1','ror/cl, 1','ror/dh, 1','ror/dl, 1','ror/bh, 1','ror/bl, 1','ror/byte ptr ":~, 1','ror/al, 1',
 'rcl/ch, 1','rcl/cl, 1','rcl/dh, 1','rcl/dl, 1','rcl/bh, 1','rcl/bl, 1','rcl/byte ptr ":~, 1','rcl/al, 1',
 'rcr/ch, 1','rcr/cl, 1','rcr/dh, 1','rcr/dl, 1','rcr/bh, 1','rcr/bl, 1','rcr/byte ptr ":~, 1','rcr/al, 1',
 'sal/ch, 1','sal/cl, 1','sal/dh, 1','sal/dl, 1','sal/bh, 1','sal/bl, 1','sal/byte ptr ":~, 1','sal/al, 1',
 'sar/ch, 1','sar/cl, 1','sar/dh, 1','sar/dl, 1','sar/bh, 1','sar/bl, 1','sar/byte ptr ":~, 1','sar/al, 1',
 'shl/ch, 1','shl/cl, 1','shl/dh, 1','shl/dl, 1','shl/bh, 1','shl/bl, 1','shl/byte ptr ":~, 1','shl/al, 1',
 'shr/ch, 1','shr/cl, 1','shr/dh, 1','shr/dl, 1','shr/bh, 1','shr/bl, 1','shr/byte ptr ":~, 1','shr/al, 1',
 {40-7F}
 'test/ch, 001h','test/cl, 001h','test/dh, 001h','test/dl, 001h',
   'test/bh, 010h','test/bl, 001h','test/byte ptr ":~, 001h','test/al, 001h',
 'test/ch, 002h','test/cl, 002h','test/dh, 002h','test/dl, 002h',
   'test/bh, 020h','test/bl, 002h','test/byte ptr ":~, 002h','test/al, 002h',
 'test/ch, 004h','test/cl, 004h','test/dh, 004h','test/dl, 004h',
   'test/bh, 040h','test/bl, 004h','test/byte ptr ":~, 004h','test/al, 004h',
 'test/ch, 008h','test/cl, 008h','test/dh, 008h','test/dl, 008h',
   'test/bh, 080h','test/bl, 008h','test/byte ptr ":~, 008h','test/al, 008h',
 'test/ch, 010h','test/cl, 010h','test/dh, 010h','test/dl, 010h',
   'test/bh, 010h','test/bl, 010h','test/byte ptr ":~, 010h','test/al, 010h',
 'test/ch, 020h','test/cl, 020h','test/dh, 020h','test/dl, 020h',
   'test/bh, 020h','test/bl, 020h','test/byte ptr ":~, 020h','test/al, 020h',
 'test/ch, 040h','test/cl, 040h','test/dh, 040h','test/dl, 040h',
   'test/bh, 040h','test/bl, 040h','test/byte ptr ":~, 040h','test/al, 040h',
 'test/ch, 080h','test/cl, 080h','test/dh, 080h','test/dl, 080h',
   'test/bh, 080h','test/bl, 080h','test/byte ptr ":~, 080h','test/al, 080h',
 {80-BF}
 'and/ch, 0FEh','and/cl, 0FEh','and/dh, 0FEh','and/dl, 0FEh',
   'and/bh, 0FEh','and/bl, 0FEh','and/byte ptr ":~, 0FEh','and/al, 0FEh',
 'and/ch, 0FDh','and/cl, 0FDh','and/dh, 0FDh','and/dl, 0FDh',
   'and/bh, 0FDh','and/bl, 0FDh','and/byte ptr ":~, 0FDh','and/al, 0FDh',
 'and/ch, 0FBh','and/cl, 0FBh','and/dh, 0FBh','and/dl, 0FBh',
   'and/bh, 0FBh','and/bl, 0FBh','and/byte ptr ":~, 0FBh','and/al, 0FBh',
 'and/ch, 0F7h','and/cl, 0F7h','and/dh, 0F7h','and/dl, 0F7h',
   'and/bh, 0F7h','and/bl, 0F7h','and/byte ptr ":~, 0F7h','and/al, 0F7h',
 'and/ch, 0EFh','and/cl, 0EFh','and/dh, 0EFh','and/dl, 0EFh',
   'and/bh, 0EFh','and/bl, 0EFh','and/byte ptr ":~, 0EFh','and/al, 0EFh',
 'and/ch, 0DFh','and/cl, 0DFh','and/dh, 0DFh','and/dl, 0DFh',
   'and/bh, 0DFh','and/bl, 0DFh','and/byte ptr ":~, 0DFh','and/al, 0DFh',
 'and/ch, 0BFh','and/cl, 0BFh','and/dh, 0BFh','and/dl, 0BFh',
   'and/bh, 0BFh','and/bl, 0BFh','and/byte ptr ":~, 0BFh','and/al, 0BFh',
 'and/ch, 07Fh','and/cl, 07Fh','and/dh, 07Fh','and/dl, 07Fh',
   'and/bh, 07Fh','and/bl, 07Fh','and/byte ptr ":~, 07Fh','and/al, 07Fh',
 {C0-FF}
 'or/ch, 001h','or/cl, 001h','or/dh, 001h','or/dl, 001h','or/bh, 010h','or/bl, 001h','or/byte ptr ":~, 001h','or/al, 001h',
 'or/ch, 002h','or/cl, 002h','or/dh, 002h','or/dl, 002h','or/bh, 020h','or/bl, 002h','or/byte ptr ":~, 002h','or/al, 002h',
 'or/ch, 004h','or/cl, 004h','or/dh, 004h','or/dl, 004h','or/bh, 040h','or/bl, 004h','or/byte ptr ":~, 004h','or/al, 004h',
 'or/ch, 008h','or/cl, 008h','or/dh, 008h','or/dl, 008h','or/bh, 080h','or/bl, 008h','or/byte ptr ":~, 008h','or/al, 008h',
 'or/ch, 010h','or/cl, 010h','or/dh, 010h','or/dl, 010h','or/bh, 010h','or/bl, 010h','or/byte ptr ":~, 010h','or/al, 010h',
 'or/ch, 020h','or/cl, 020h','or/dh, 020h','or/dl, 020h','or/bh, 020h','or/bl, 020h','or/byte ptr ":~, 020h','or/al, 020h',
 'or/ch, 040h','or/cl, 040h','or/dh, 040h','or/dl, 040h','or/bh, 040h','or/bl, 040h','or/byte ptr ":~, 040h','or/al, 040h',
 'or/ch, 080h','or/cl, 080h','or/dh, 080h','or/dl, 080h','or/bh, 080h','or/bl, 080h','or/byte ptr ":~, 080h','or/al, 080h');

 InstrED8088 : array[$00..$FF] of string[16]=
 (
 {00-3F}
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 {40-7F}
 'in_B_C','out_C_B','sbb/^, cx','mov/":[%], cx','neg/al','RETN','IM_0','MOV_I_A',
 'in_C_C','out_C_C','adc/^, cx','mov/cx, ":[%]','!'     ,'RETI','!'   ,'MOV_R_A',
 'in_D_C','out_C_D','sbb/^, dx','mov/":[%], dx','!'     ,'!'   ,'IM_1','MOV_A_I',
 'in_E_C','out_C_E','adc/^, dx','mov/dx, ":[%]','!'     ,'!'   ,'IM_2','MOV_A_R',
 'in_H_C','out_C_H','sbb/^, ^' ,'mov/":[%], ^' ,'!'     ,'!'   ,'!'   ,'RRD',
 'in_L_C','out_C_L','adc/^, ^' ,'mov/^, ":[%]' ,'!'     ,'!'   ,'!'   ,'RLD',
 'in_?_C','!'      ,'sbb/^, sp','mov/":[%], sp','!'     ,'!'   ,'!'   ,'!',
 'in_A_C','out_C_A','adc/^, sp','mov/sp, ":[%]','!'     ,'!'   ,'!'   ,'!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 {A0-BF}
 'LDI_"_DS' ,'CPI' ,'INI' ,'OUTI','!','!','!','!',
 'LDD_"_DS' ,'CPD' ,'IND' ,'OUTD','!','!','!','!',
 'LDIR_"_DS','CPIR','INIR','OTIR','!','!','!','!',
 'LDDR_"_DS','CPDR','INDR','OTDR','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','!',
 '!','!','!','!','!','!','!','!',   '!','!','!','!','!','!','!','WaitInts');

implementation end.