MenuStartAddr   =       160 * 6 + 9 * 2
ONOFFaddr       =       160 * 15 + 72 * 2
atMenuLine      =       00Eh
atSelLine       =       030h
atEditLine      =       01Eh
atCursor        =       0F0h
btSaveY         =       5
btLoadY         =       8
btDeleteY       =       11
btSoundY        =       14
btBossKeyY      =       17
btQuitY         =       20
btX             =       63
btW             =       14
GameDescSize    =       50

aaaMenu         segment byte use16
                assume  ds:aaaMenu, cs:aaaMenu

sgMask          db      GameID,'??.sav',0
                .386c
BossKeyMessage  db      'C:\BP\PROJECTS\WORK>compile.bat /b /q /i\BP\INCLUDE;\BP\COMMON /e\BP\EXE',13,10
                db      'Turbo Pascal  Version 7.0  Copyright (c) 1983,92 Borland International',13,10
                db      'WORK.PAS($'
sgNames         db      16 * GameDescSize dup (?)
SelBarY         db      0
MusicFlag       db      1
TextVRAM        dw      ?
_VideoChip      dw      ?

;* In:  BX = file handle (file is already opened for read) *;
;*      DO NOT SEEK INTO FILE! /'cause it has a header/    *;
;* Out: CF = 0 if all right; otherwise CF = 1.             *;
msxLoadState    proc    near
                push    ds
                mov     dx, seg ZDatSeg
                mov     ds, dx
                mov     dx, 0C000h
                mov     ah, 3Fh
                call    rlUnpack
                jc      @@Fail
                mov     dx, seg _VRAM
                mov     ds, dx
                xor     dx, dx
                mov     ah, 3Fh
                call    rlUnpack
                jc      @@Fail
                mov     dx, seg MainSeg
                mov     ds, dx
                mov     dx, offset BorderCol
                mov     cx, 1
                mov     ah, 3Fh
                int     21h
                jc      @@Fail
                mov     dx, offset VoiceAfreq
                mov     cx, 14
                mov     ah, 3Fh
                int     21h
                mov     dx, offset ProgramSS
                mov     cx, 4
                mov     ah, 3Fh
                int     21h
                jc      @@Fail
@@Fail:         pop     ds
                ret
msxLoadState    endp

;* In: BX = file handle (file is already opened for write) *;
msxSaveState    proc    near
                push    ds
                mov     dx, seg ZDatSeg
                mov     ds, dx
                mov     dx, 0C000h
                mov     cx, 4000h
                mov     ah, 40h
                call    rlPack
                jc      @@Fail
                mov     dx, seg _VRAM
                mov     ds, dx
                mov     dx, 0
                mov     cx, 16384
                mov     ah, 40h
                call    rlPack
                jc      @@Fail
                mov     dx, seg MainSeg
                mov     ds, dx
                mov     dx, offset BorderCol
                mov     cx, 1
                mov     ah, 40h
                int     21h
                jc      @@Fail
                mov     dx, offset VoiceAfreq
                mov     cx, 14
                mov     ah, 40h
                int     21h
                mov     dx, offset ProgramSS
                mov     cx, 4
                mov     ah, 40h
                int     21h
@@Fail:         pop     ds
                ret
msxSaveState    endp

;* When (Q)uit button is pressed *;
msxShutDown     proc    near
                mov     ax, 0
                jmp     HaltProc
msxShutDown     endp

textMainMenu    db      2,16,' ',15,26,'M',24,' ',19,'  ',25,4,26,6,' '
                db      26,6,' ',26,5,'',25,5,' ',26,6,' ',26,6,' '
                db      '  ',26,6,'',25,2,1,16,'',24,' ',15,'',19,'  ',23
                db      ' ',8,'',19,25,4,15,'',23,' ',8,' ',19,' ',15,''
                db      23,'  ',8,'',19,' ',15,23,' ',8,' ',15,'',8,''
                db      19,25,2,15,'',23,'',8,'',19,' ',15,'',23,' ',8,26
                db      3,'',19,' ',15,'',23,'  ',8,'',19,' ',15,23,''
                db      ' ',8,'',19,' ',15,23,' ',8,'',19,' ',15,23,' ',8
                db      26,3,'',19,25,2,1,16,'',24,' ',15,'',19,'  ',23,''
                db      ' ',8,'',15,19,26,3,' ',23,' ',8,'',15,19,'',23
                db      ' ',8,'',19,' ',15,'',23,' ',8,' ',19,' ',15,23
                db      ' ',8,'',15,19,'',23,' ',8,'',19,' ',15,'',23,''
                db      8,'',19,'  ',15,'',23,26,3,' ',8,'',19,' ',15,''
                db      23,' ',8,' ',19,' ',15,23,'',8,'',15,'',8,''
                db      '',19,' ',15,23,' ',8,'',19,'',25,2,1,16,'',24
                db      ' ',15,'',19,'  ',23,'',8,26,4,'',19,' ',15,'',8
                db      23,26,4,'',19,' ',15,'',8,23,'',19,' ',23,'',19
                db      ' ',15,23,'',8,26,3,'',19,' ',15,23,'',8,'',19
                db      '',25,3,15,'',8,23,26,4,'',19,' ',15,'',8,23,''
                db      '',19,' ',23,'',19,'  ',15,'',23,'',8,'',19,''
                db      '  ',15,23,'',8,26,4,'',19,25,2,1,16,'',24,' ',15
                db      '',19,' ',1,26,': ',15,26,13,' ',1,16,'',24,' ',15
                db      '',19,' ',1,'',16,' ',10,'01 ',9,'',25,'3',15,19,''
                db      ' ',23,25,3,14,'S',1,'ave',25,3,8,'',19,' ',1,16,''
                db      24,' ',15,'',19,' ',1,'',16,' ',10,'02 ',9,'',25,'3'
                db      15,19,' ',8,26,12,' ',1,16,'',24,' ',15,'',19,' '
                db      1,'',16,' ',10,'03 ',9,'',25,'3',15,19,' ',26,13,''
                db      ' ',1,16,'',24,' ',15,'',19,' ',1,'',16,' ',10,'0'
                db      '4 ',9,'',25,'3',15,19,' ',23,25,3,14,'L',1,'oad',25
                db      3,8,'',19,' ',1,16,'',24,' ',15,'',19,' ',1,'',16
                db      ' ',10,'05 ',9,'',25,'3',15,19,' ',8,26,12,' ',1,16
                db      '',24,' ',15,'',19,' ',1,'',16,' ',10,'06 ',9,'',25
                db      '3',15,19,' ',26,13,' ',1,16,'',24,' ',15,'',19,' '
                db      1,'',16,' ',10,'07 ',9,'',25,'3',15,19,' ',23,25,2
                db      14,'D',1,'elete',25,2,8,'',19,' ',1,16,'',24,' ',15
                db      '',19,' ',1,'',16,' ',10,'08 ',9,'',25,'3',15,19,''
                db      ' ',8,26,12,' ',1,16,'',24,' ',15,'',19,' ',1,''
                db      16,' ',10,'09 ',9,'',25,'3',15,19,' ',26,13,' ',1,16
                db      '',24,' ',15,'',19,' ',1,'',16,' ',10,'10 ',9,'',25
                db      '3',15,19,' ',23,'  ',14,'M',1,'usic ON  ',8,'',19
                db      ' ',1,16,'',24,' ',15,'',19,' ',1,'',16,' ',10,'1'
                db      '1 ',9,'',25,'3',15,19,' ',8,26,12,' ',1,16,'',24
                db      ' ',15,'',19,' ',1,'',16,' ',10,'12 ',9,'',25,'3',15
                db      19,' ',26,13,' ',1,16,'',24,' ',15,'',19,' ',1,''
                db      16,' ',10,'13 ',9,'',25,'3',15,19,' ',23,'  ',14,'B'
                db      1,'oss key  ',8,'',19,' ',1,16,'',24,' ',15,'',19,' '
                db      1,'',16,' ',10,'14 ',9,'',25,'3',15,19,' ',8,26,12
                db      ' ',1,16,'',24,' ',15,'',19,' ',1,'',16,' ',10,'1'
                db      '5 ',9,'',25,'3',15,19,' ',26,13,' ',1,16,'',24,' '
                db      15,'',19,' ',1,'',16,' ',10,'16 ',9,'',25,'3',15,19
                db      ' ',23,25,3,14,'Q',1,'uit',25,3,8,'',19,' ',1,16,''
                db      24,' ',15,'',19,' ',1,'',15,26,'9 ',8,26,12,' ',1
                db      16,'',24,' ',15,'',1,26,'L',31
                dw      -1

textDelOK       db      15,16,24,24,24,24,24,24,24,24,24,24,30,13,0,17,'',15,16,26
                db      39,'',0,17,'',24,16,30,13,17,'',15,'',25,'%',8,''
                db      0,'',24,16,30,13,17,'',15,' ',14,'Savegame has be'
                db      'en succesfully erased ',8,'',0,'',24,16,30,13,17,''
                db      15,'',25,'%',8,'',0,'',24,16,30,13,17,'',15,'',27
                db      16,26,'&',0,27,17,'',24,16,30,13,17,'',15,'',25,6
                db      10,'press any key to continue',25,5,8,'',0,'',24,16
                db      30,13,17,'',15,16,'',8,26,'&',0,17,'',31
                dw      -1

textDelError    db      15,16,24,24,24,24,24,24,24,24,24,24,30,13,0,20,'',15,16,26
                db      39,'',0,20,'',24,16,30,13,20,'',15,'',25,'%',8,''
                db      0,'',24,16,30,13,20,'',15,'',14,'   Cannot erase inexistent'
                db      ' savegame   ',8,'',0,'',24,16,30,13,20,''
                db      15,'',25,'%',8,'',0,'',24,16,30,13,20,'',15,'',27
                db      16,26,'&',0,27,20,'',24,16,30,13,20,'',15,'',25,6
                db      10,'press any key to continue',25,5,8,'',0,'',24,16
                db      30,13,20,'',15,16,'',8,26,'&',0,20,'',31
                dw      -1

textOpOK        db      15,16,24,24,24,24,24,24,24,24,24,24,30,11,0,17,'',15,16,26
                db      43,'',0,17,'',24,16,30,11,17,'',15,'',25,41,8,''
                db      0,'',24,16,30,11,17,'',15,' ',14,'Operation has be'
                db      'en succesfully completed ',8,'',0,'',24,16,30,11,17,''
                db      15,'',25,41,8,'',0,'',24,16,30,11,17,'',15,'',27
                db      16,26,42,'',0,27,17,'',24,16,30,11,17,'',15,'',25,8
                db      10,'press any key to continue',25,7,8,'',0,'',24,16
                db      30,11,17,'',15,16,'',8,26,42,'',0,17,'',31
                dw      -1

textOpError     db      15,16,24,24,24,24,24,24,24,24,24,24,30,13,0,20,'',15,16,26
                db      39,'',0,20,'',24,16,30,13,20,'',15,'',25,'%',8,''
                db      0,'',24,16,30,13,20,'',15,'',14,'  Disk I/O error - '
                db      'operation failed   ',8,'',0,'',24,16,30,13,20,''
                db      15,'',25,'%',8,'',0,'',24,16,30,13,20,'',15,'',27
                db      16,26,'&',0,27,20,'',24,16,30,13,20,'',15,'',25,6
                db      10,'press any key to continue',25,5,8,'',0,'',24,16
                db      30,13,20,'',15,16,'',8,26,'&',0,20,'',31
                dw      -1

textONOFF       db      'OFFON '
CursorX         db      ?
NumBuff         dq      ?

Uncrunch        proc    near Buffer : dword
                push    bp
                mov     bp,sp
                push    ds
                mov     es,TextVRAM
                lds     si,Buffer
                xor     di,di

                mov     dx,di                   ;Save X coordinate for later.
                xor     ax,ax                   ;Set Current attributes.
                cld

@@LoopA:        lodsb                           ;Get next character.
                cmp     al,32                   ;If a control character, jump.
                jb      @@ForeGround
                stosw                           ;Save letter on screen.
@@Next:         jmp     @@LoopA

@@ForeGround:   cmp     al,16                   ;If less than 16, then change the
                jnc     @@BackGround            ;foreground color.  Otherwise jump.
                and     ah,0F0h                 ;Strip off old foreground.
                or      ah,al
                jmp     @@Next

@@BackGround:   cmp     al,24                   ;If less than 24, then change the
                jz      @@NextLine              ;background color.  If exactly 24,
                jnc     @@FlashBitToggle        ;then jump down to next line.
                sub     al,16                   ;Otherwise jump to multiple output
                shl     al,4                    ;routines.
                and     ah,8Fh                  ;Strip off old background.
                or      ah,al
                jmp     @@Next

@@NextLine:     add     dx,160                  ;If equal to 24,
                mov     di,dx                   ;then jump down to
                jmp     @@Next                  ;the next line.

@@FlashBitToggle:
                cmp     al,27                   ;Does user want to toggle the blink
                jc      @@MultiOutput           ;attribute?
                jnz     @@skipSpaces
                xor     ah,128                  ;Done.
                jmp     @@Next

@@MultiOutput:  cmp     al,25                   ;Set Z flag if multi-space output.
                lodsb                           ;Get count of number of times
                mov     cl,al                   ;to display character.
                mov     al,32
                jz      @@StartOutput           ;Jump here if displaying spaces.
                lodsb                           ;Otherwise get character to use.

@@StartOutput:  xor     ch,ch
                inc     cx
                rep     stosw
                jmp     @@LoopA                 ;Loop if anything else to do...
@@skipSpaces:   cmp     al,31
                je      @@Done
                lodsb
                mov     ah,0
                inc     ax
                add     di,ax
                add     di,ax
                jmp     @@LoopA

@@Done:         lodsw
                pop     ds
                cmp     ax,-1
                je      @@noCursor
                mov     dx,ax
                mov     ah,2
                xor     bx,bx
                int     10h
                jmp     @@locEx
@@noCursor:     mov     ah,1
                mov     cx,2020h
                int     10h
@@locEx:        pop     bp
                ret     4
Uncrunch        endp

InitTextMode    proc    near
                cld
                mov     ax,3
                int     10h
                mov     ax,1003h
                mov     bl,0
                int     10h

                xor     ax,ax
                mov     es,ax
                mov     ax,0B800h
                mov     bx,word ptr es:[0463h]
                cmp     bx,03D0h
                jae     @@IsColor
                mov     ah,0B0h
@@IsColor:      mov     TextVRAM,ax
                mov     _VideoChip,bx
                ret
InitTextMode    endp

FindSavegames   proc    near
                mov     di,offset sgNames
                mov     ax,ds
                mov     es,ax
                push    di
                mov     cx,16 * GameDescSize/2  ;Savegame names table size
                xor     ax,ax
                rep     stosw
                pop     di
                mov     cx,16
@@findNext:     push    cx
                push    di
                mov     al,17
                sub     al,cl
                aam
                add     ax,'00'
                xchg    al,ah
                mov     word ptr sgMask + 4,ax
                mov     ax,3D00h
                mov     dx,offset sgMask
                int     21h
                jc      @@notFound
                mov     bx,ax
                pop     dx
                push    dx
                mov     ah,3Fh
                call    rlUnpack
                mov     ah,3Eh
                int     21h
@@notFound:     pop     di
                pop     cx
                add     di,GameDescSize
                loop    @@findNext
@@searchDone:   ret
FindSavegames   endp

ListSavegames   proc    near
                mov     cx,16
                mov     si,offset sgNames
                mov     es,textVRAM
                mov     di,MenuStartAddr
@@drawNext:     push    cx
                push    di
                push    si
                mov     ch,16
                sub     ch,cl
                mov     ah,atSelLine
                cmp     ch,SelBarY
                je      @@atOK
                mov     ah,atMenuLine
@@atOK:         mov     al,' '
                stosw
                mov     cx,GameDescSize
@@nextChar:     lodsb
                test    al,al
                jz      @@emptyLine
                stosw
                loop    @@nextChar
                jmp     @@lineDone
@@emptyLine:    mov     al,' '
                rep     stosw
@@lineDone:     mov     al,' '
                stosw
                pop     si
                pop     di
                pop     cx
                add     si,GameDescSize         ;Description size
                add     di,160
                loop    @@drawNext
                ret
ListSavegames   endp

EditLine        proc    near
                mov     al,GameDescSize
                mul     SelBarY
                mov     si,offset sgNames
                add     si,ax
                mov     al,160
                mul     SelBarY
                mov     di,MenuStartAddr+2
                add     di,ax
                mov     es,textVRAM

@@keyEnd:       lea     bx,[si-1]
                mov     cx,GameDescSize+1
@@scanLen:      inc     bx
                cmp     byte ptr [bx],0
                loopne  @@scanLen
@@lastChar:     mov     ax,bx
                sub     ax,si
                mov     CursorX,al

@@showString:   push    si
                push    di
                xor     bx,bx
                mov     cx,GameDescSize+1
@@nextChar:     mov     ah,atCursor
                cmp     bl,CursorX
                je      @@isCursor
                mov     ah,atSelLine
                cmp     cl,1
                je      @@isCursor
                mov     ah,atEditLine
@@isCursor:     test    bh,bh
                jne     @@spaceChar
                lodsb
                test    al,al
                jnz     @@putChar
                inc     bh
@@spaceChar:    mov     al,' '
@@putChar:      stosw
                inc     bl
                cmp     cl,2
                adc     bh,0
                loop    @@nextChar
                pop     di
                pop     si

@@waitKey:      mov     ah,0
                int     16h
                cmp     ah,01h
                je      @@endEdit
                cmp     ah,1Ch
                je      @@endEdit
                cmp     ah,4Bh
                je      @@keyLeft
                cmp     ah,4Dh
                je      @@keyRight
                cmp     ah,47h
                je      @@keyHome
                cmp     ah,4Fh
                je      @@keyEnd
                cmp     ah,53h
                je      @@keyDel
                cmp     ah,0Eh
                je      @@keyBackSp
                cmp     al,' '
                jb      @@waitKey
                lea     bx,[si+GameDescSize-1]
                mov     cx,GameDescSize-1
                sub     cl,CursorX
                jb      @@waitKey
                je      @@noIns
                push    ax
@@insChar:      mov     al,[bx-1]
                mov     [bx],al
                dec     bx
                loop    @@insChar
                pop     ax
@@noIns:        mov     [bx],al
                cmp     CursorX,GameDescSize
                je      @@showString
                inc     CursorX
                jmp     @@showString
@@keyLeft:      cmp     CursorX,0
                je      @@waitKey
                dec     CursorX
                jmp     @@showString
@@keyRight:     cmp     CursorX,GameDescSize
                je      @@waitKey
                mov     bx,si
                add     bl,CursorX
                adc     bh,0
                cmp     byte ptr [bx],0
                je      @@waitKey
                inc     CursorX
                jmp     @@showString
@@keyHome:      mov     CursorX,0
                jmp     @@showString
@@keyBackSp:    cmp     al,7Fh
                jne     @@simplyBackSp
                mov     CursorX,0
                mov     cx,GameDescSize/2
                mov     bx,si
@@clearStr:     mov     word ptr [bx],0
                inc     bx
                inc     bx
                loop    @@clearStr
                jmp     @@showString
@@simplyBackSp: cmp     CursorX,0
                je      @@waitKey
                dec     CursorX
@@keyDel:       mov     bx,si
                add     bl,CursorX
                adc     bh,0
                mov     cx,GameDescSize-1
                sub     cl,CursorX
                jc      @@waitKey
                je      @@noDel
@@delChar:      mov     al,[bx+1]
                mov     [bx],al
                inc     bx
                loop    @@delChar
@@noDel:        mov     byte ptr [bx],0
                jmp     @@showString
@@endEdit:      ret
EditLine        endp

SetButtState    proc    near State : byte, Y : byte
                push    bp
                mov     bp,sp
                mov     es,textVRAM
                mov     al,160
                mul     Y
                add     ax,btX * 2 + 1
                mov     di,ax
                mov     dl,es:[di]
                and     dl,0F0h
                mov     dh,dl
                mov     ax,0F08h
                cmp     State,1
                je      @@stPressed
                mov     ax,080Fh
@@stPressed:    or      dx,ax
                mov     cx,btW
                push    di
@@fill1:        mov     es:[di],dl
                inc     di
                inc     di
                loop    @@fill1
                pop     di
                add     di,160
                mov     es:[di],dl
                mov     bx,btW * 2 - 2
                mov     es:[di + bx],dh
                add     di,160
                mov     es:[di],dl
                inc     di
                inc     di
                mov     cx,btW - 1
@@fill2:        mov     es:[di],dh
                inc     di
                inc     di
                loop    @@fill2
                pop     bp
                ret     4
SetButtState    endp

Delay           proc    near
                mov     dx,_VideoChip
                add     dl,6
@@kqW1:         in      al,dx
                test    al,8
                je      @@kqW1
@@kqW2:         in      al,dx
                test    al,8
                jne     @@kqW2
                loop    @@kqW1
                ret
Delay           endp

GetfName        proc    near
                mov     al,SelBarY
                inc     al
                aam
                add     ax,'00'
                xchg    al,ah
                mov     word ptr sgMask + 4,ax
                mov     dx,offset sgMask
                ret
GetfName        endp

SaveGame        proc    near
                call    GetfName
                mov     ah,3Ch
                mov     cx,20h
                int     21h                     ;Open savegame
                jc      @@saveError
                mov     bx,ax
                mov     dx,offset sgNames
                mov     al,GameDescSize
                mul     SelBarY
                add     dx,ax
                mov     si,dx
                cmp     byte ptr [si],0
                jne     @@noEmptyName
                mov     al,SelBarY
                inc     al
                aam
                add     ax,'00'
                xchg    al,ah
                mov     word ptr [si],'n('
                mov     word ptr [si+2],'no'
                mov     word ptr [si+4],'ma'
                mov     word ptr [si+6],'.e'
                mov     word ptr [si+8],ax
                mov     word ptr [si+10],')'
@@noEmptyName:  mov     ah,40h
                mov     cx,GameDescSize
                call    rlPack
                jc      @@accessError
                call    msxSaveState
                jc      @@accessError
                mov     ah,3Eh
                int     21h
                mov     ax,offset textOpOK
                jmp     __ShowMessage

@@accessError:  mov     ah,3Eh
                int     21h
@@saveError:    mov     ax,offset textOpError
                stc
                jmp     __ShowMessage

SaveGame        endp

LoadGame        proc    near
                call    GetfName
                mov     bx,offset sgNames
                mov     al,GameDescSize
                mul     SelBarY
                add     bx,ax
                cmp     byte ptr [bx],0
                je      @@emptySG
                mov     ax,3D00h
                int     21h                     ;Open savegame
                jc      @@loadError
                mov     bx,ax
                push    ds
                mov     dx,seg _VRAM
                mov     ds,dx
                xor     dx,dx
                call    rlUnpack
                pop     ds
                jc      @@accessError
                call    msxLoadState
                jc      @@accessError
                mov     ah,3Eh
                int     21h
                clc
                ret

@@emptySG:      stc
                ret
@@accessError:  mov     ah,3Eh
                int     21h
@@loadError:    mov     ax,offset textOpError
                jmp     __ShowMessage

LoadGame        endp

DeleteGame      proc    near
                call    GetfName
                mov     ah,41h
                int     21h
                pushf
                call    FindSavegames
                popf
                mov     ax,offset textDelOK
                jnc     __ShowMessage
                mov     ax,offset textDelError
__ShowMessage:  pushf
                push    seg textDelOK
                push    ax
                call    Uncrunch
                mov     ah,0
                int     16h
                popf
                ret
DeleteGame      endp

BossKey         proc    near
                mov     ax,3
                int     10h
                mov     dx,offset BossKeyMessage
                mov     ah,9
                int     21h
                mov     ax,1

@@Compile:      push    ax
                xor     si,si

@@decDiv:       xor     dx,dx
                mov     bx,10
                div     bx
                add     dl,'0'
                mov     byte ptr NumBuff[si],dl
                inc     si
                test    ax,ax
                jnz     @@decDiv
                mov     di,si
@@decPrint:     dec     di
                mov     al,byte ptr NumBuff[di]
                int     29h
                test    di,di
                jnz     @@decPrint

                mov     al,')'
                int     29h
                mov     cx,30
                call    Delay
                lea     cx,[si+1]
@@backSp:       mov     al,8
                int     29h
                dec     cl
                jne     @@backSp
                mov     ah,1
                int     16h
                jnz     @@keyPressed

@@continue:     in      al,40h
                mov     cl,al
                in      al,40h
                pop     ax
                add     ax,cx
                jmp     @@Compile

@@keyPressed:   mov     ah,0
                int     16h
                cmp     ah,1
                jne     @@continue
                pop     ax
                ret
BossKey         endp

ShowMusicState  proc    near
                mov     al,3
                mul     MusicFlag
                add     ax,offset textONOFF
                mov     si,ax
                mov     di,ONOFFaddr
                mov     es,textVRAM
                cld
                lodsb
                stosb
                inc     di
                lodsb
                stosb
                inc     di
                lodsb
                stosb
                ret
ShowMusicState  endp

LoadSaveMenu    proc    far
                mov     ax,seg ProgramDS
                mov     fs,ax
                assume  fs:seg ProgramDS
                mov     ProgramDS,ds
                mov     ProgramSS,ss
                mov     ProgramSP,sp
                mov     ax,seg Wave1
                mov     ss,ax
                mov     sp,offset SecureInterval        ; Switch stack
                mov     ax,0C06h
                mov     dl,0FFh
                int     21h
                mov     ax,seg aaaMenu
                mov     ds,ax
@@runAgain:     call    InitTextMode
                call    FindSavegames
                push    seg textMainMenu
                push    offset textMainMenu
                call    Uncrunch
                call    ShowMusicState
@@waitKey:      call    ListSavegames
                mov     ah,0
                int     16h
                xor     bx,bx
                mov     cx,14
@@searchKey:    cmp     ah,byte ptr @@keyTable[bx]
                je      @@keyFound
                inc     bx
                loop    @@searchKey
                jmp     @@waitKey
@@keyFound:     shl     bx,1
                call    word ptr @@keySubs[bx]
                jmp     @@waitKey

@@keyTable:     db      48h,50h,49h,51h,47h,4Fh,1Ch,01h
                db      1Fh,26h,20h,30h,32h,10h
@@keySubs:      dw      offset @@keyUp, offset @@keyDown
                dw      offset @@keyPgUp, offset @@keyPgDn
                dw      offset @@keyPgUp, offset @@keyPgDn
                dw      offset @@keyEnter, offset @@keyEsc
                dw      offset @@keyS, offset @@keyL
                dw      offset @@keyD, offset @@keyB
                dw      offset @@keyM, offset @@keyQ

@@keyUp:        dec     SelBarY
@@CutSBY:       and     SelBarY,15
                retn
@@keyDown:      inc     SelBarY
                jmp     @@CutSBY
@@keyPgUp:      mov     SelBarY,0
                retn
@@keyPgDn:      mov     SelBarY,15
                retn
@@keyEnter:     call    EditLine

@@keyS:         push    btSaveY
                push    btSaveY
                push    1
                call    SetButtState
                call    SaveGame
@@opOK:         push    0
                call    SetButtState
                retn

@@keyL:         push    btLoadY
                push    btLoadY
                push    1
                call    SetButtState
                call    LoadGame
                jnc     @@exToGame
                jmp     @@opOK
@@exToGame:     pop     ax
                jmp     @@keyEsc

@@keyD:         push    btDeleteY
                push    btDeleteY
                push    1
                call    SetButtState
                call    DeleteGame
                jmp     @@opOK

@@keyB:         push    btBossKeyY
                push    1
                call    SetButtState
                mov     cx,8
                call    Delay
                pop     ax
                call    BossKey
                jmp     @@runAgain

@@keyM:         push    btSoundY
                push    1
                call    SetButtState
                xor     MusicFlag,1
                call    ShowMusicState
                mov     cx,8
                call    Delay
                push    btSoundY
                push    0
                call    SetButtState
                retn

@@keyQ:         push    btQuitY
                push    1
                call    SetButtState
                mov     cx,8
                call    Delay
                call    msxShutDown

@@keyEsc:       pop     ax
                mov     al,MusicFlag
                call    msxSetSound
                mov     ax,0C06h
                mov     dl,0FFh
                int     21h
                mov     ds,ProgramDS
                mov     ss,ProgramSS
                mov     sp,ProgramSP
                ret
                assume  fs:Nothing
LoadSaveMenu    endp

aaaMenu         ends

include         \msx\asm\RLpack.asm
