BIT             macro   Reg, value
                push    ax
                lahf
                test    Reg, value
                mov     al, ah
                lahf
                and     ax, 40BFh
                or      ah, al
                sahf
                pop     ax
                endm

BITM            macro   MemRef, Value
                push    ax
                lahf
                test    byte ptr MemRef, Value
                mov     al, ah
                lahf
                and     ax, 40BFh
                or      ah, al
                sahf
                pop     ax
                endm

RES             macro   Reg, Value
                pushf
                and     Reg, Value
                popf
                endm

RESM            macro   MemRef, Value
                pushf
                and     byte ptr MemRef, Value
                popf
                endm

SET             macro   Reg, Value
                pushf
                or      Reg, Value
                popf
                endm

SETM            macro   Reg, Value
                pushf
                or      byte ptr Reg, Value
                popf
                endm

Idle            macro
                local   @@locEx,@@finish
                pusha
                cli
                mov     SuspendRefresh, offset @@locEx
                call    ShowVRAM
                cmp     PrgExit, 0
                je      @@finish
                mov     GameStop, 1
                call    NoSound
                call    LoadSaveMenu
                call    VideoInit
                mov     GameStop, 0
                mov     PrgExit, 0
                jmp     @@finish
@@locEx:        inc     sp
                inc     sp
@@finish:       popa
                endm

Halt            macro   Times
                local   @@wait
ifb <Times>
                mov     Decider,1
else
                mov     Decider,Times
endIf
@@wait:         Idle
                cmp     Decider,0
                jne     @@wait
                endm

HaltEvery       macro   Times
                local   @@endm,@@var
                dec     @@var
                jnz     @@endm
                mov     @@var,Times
                Halt
                jmp     @@endm
@@var           db      0
@@endm:         endm

IdleEvery       macro   Times
                local   @@endm,@@var
                dec     @@var
                jnz     @@endm
                mov     @@var,Times
                Idle
                jmp     @@endm
@@var           db      ?
@@endm:         endm

WaitInts        macro
@@again:        call    RefreshOnce
                jmp     @@again
                endm

_DI             Macro
                mov     IRQdisabled, 1
                endm

_EI             Macro
                mov     IRQdisabled, 0
                endm

EXX             Macro
                xchg    bx,TempBX
                xchg    cx,TempCX
                xchg    dx,TempDX
                endm

EX_A_A          Macro
                lahf
                xchg    ax,TempAX
                sahf
                EndM

PUSH_AF         Macro
                lahf
                xchg    ah, al
                push    ax
                xchg    ah, al
                endm

POP_AF          Macro
                pop     ax
                xchg    ah, al
                sahf
                endm

DJNZ            Macro   Addr
local           @@DJNZ_EXIT
                lahf
                dec     ch
                jz      @@DJNZ_EXIT
                sahf
                jmp     Addr
@@DJNZ_EXIT:    sahf
                endm

MOV_CX_al_DS    Macro
                xchg    bx, cx
                mov     ds:[bx], al
                xchg    bx, cx
                endm

MOV_al_CX_DS    Macro
                xchg    bx, cx
                mov     al, ds:[bx]
                xchg    bx, cx
                endm

MOV_DX_al_DS    Macro
                xchg    bx, dx
                mov     ds:[bx], al
                xchg    bx, dx
                endm

MOV_al_DX_DS    Macro
                xchg    bx, dx
                mov     al, ds:[bx]
                xchg    bx, dx
                endm

MOV_CX_al_CS    Macro
                xchg    bx, cx
                mov     cs:[bx], al
                xchg    bx, cx
                endm

MOV_al_CX_CS    Macro
                xchg    bx, cx
                mov     al, cs:[bx]
                xchg    bx, cx
                endm

MOV_DX_al_CS    Macro
                xchg    bx, dx
                mov     cs:[bx], al
                xchg    bx, dx
                endm

MOV_al_DX_CS    Macro
                xchg    bx, dx
                mov     al, cs:[bx]
                xchg    bx, dx
                endm

RETNZ           Macro
                jz      $+3
                retn
                endm

CALNZ           Macro   Addr
                jz      $+5
                call   Addr
                endm

RETZ            Macro
                jnz     $+3
                retn
                endm

CALZ            Macro   Addr
                jnz     $+5
                call   Addr
                endm

RETNC           Macro
                jc      $+3
                retn
                endm

CALNC           Macro   Addr
                jc      $+5
                call   Addr
                endm

RETC            Macro
                jnc     $+3
                retn
                endm

CALC            Macro   Addr
                jnc     $+5
                call   Addr
                endm

RETPO           Macro
                jpe     $+3
                retn
                endm

CALPO           Macro   Addr
                jpe     $+5
                call   Addr
                endm

RETPE           Macro
                jpo     $+3
                retn
                endm

CALPE           Macro   Addr
                jpo     $+5
                call   Addr
                endm

RETP            Macro
                js      $+3
                retn
                endm

CALP            Macro   Addr
                js      $+5
                call   Addr
                endm

RETM            Macro
                jns     $+3
                retn
                endm

CALM            Macro   Addr
                jns     $+5
                call   Addr
                endm

RST_00          Macro
                EndM

RST_08          Macro
                EndM

RST_10          Macro
                EndM

RST_18          Macro
                EndM

RST_20          Macro
                EndM

RST_28          Macro
                EndM

RST_30          Macro
                EndM

RST_38          Macro
                EndM

; Fuck games which doesnt use IM 1!
IM_0            Macro
                EndM

IM_1            Macro
                EndM

IM_2            Macro
                EndM

LDI_CS_DS       Macro
                EndM

LDI_DS_DS       Macro
                cld
                xchg    bx, si
                xchg    dx, di
                mov     es, DSegAddr
                movsb
                dec     cx
                xchg    dx, di
                xchg    bx, si
                EndM

OUTI            Macro
                push    ax
                mov     al, ds:[bx]
                call    Out98
                inc     bx
                dec     ch
                pop     ax
                EndM

;LDD_CS_DS       Macro
;                EndM

;LDD_DS_DS       Macro
;                EndM

LDIR_CS_DS      Macro
                cld
                xchg    bx, si
                xchg    dx, di
                mov     ds, CSegAddr
                mov     es, DSegAddr
                rep     movsb
                xchg    bx, si
                xchg    dx, di
                mov     ds, DSegAddr
                EndM

LDIR_DS_DS      Macro
                cld
                xchg    bx, si
                xchg    dx, di
                mov     es, DSegAddr
                rep     movsb
                xchg    dx, di
                xchg    bx, si
                EndM

LDDR_CS_DS      Macro
                std
                xchg    bx, si
                xchg    dx, di
                mov     ds, CSegAddr
                mov     es, DSegAddr
                rep     movsb
                xchg    dx, di
                xchg    bx, si
                mov     ds, DSegAddr
                EndM

LDDR_DS_DS      Macro
                std
                xchg    bx, si
                xchg    dx, di
                mov     es, DSegAddr
                rep     movsb
                xchg    bx, si
                xchg    dx, di
                EndM

CPIR            macro
                local   @@search
@@search:       cmp     al,[bx]
                inc_bx
                loopne  @@search
                endm

CPDR            macro
                local   @@search
@@search:       cmp     al,[bx]
                dec_bx
                loopne  @@search
                endm

IN_A_C          Macro
                Call    In98
                endm

OUT_C_A         Macro
                Call    Out98
                endm

OUT_C_B         Macro
                local   @@kbd,@@endm
                cmp     cl,0AAh
                je      @@kbd
                xchg    al, ch
                Call    Out98
                xchg    al, ch
                jmp     @@endm
@@kbd:          mov     port0AAh,ch
@@endm:         endm

OUT_C_D         Macro
                cmp     cl,0A0h
                je      @@outA0
                cmp     cl,098h
                je      @@out98
@@out98:        xchg    al, dh
                Call    Out98
                xchg    al, dh
                jmp     @@endm
@@outA0:        mov     PSGregister,dh
@@endm:         endm

MOV_A_R         Macro
                push    dx
                mov     ax,word ptr RegisterR
                mov     dx,word ptr RegisterR+2
                xor     ax,0DEADh
                rol     ax,7
                add     dh,al
                adc     dl,ah
                rol     dx,3
                xor     dl,ah
                add     dh,al
                xor     ax,dx
                rol     ax,5
                mov     word ptr RegisterR,ax
                mov     word ptr RegisterR+2,dx
                pop     dx
                and     al,07Fh
                EndM

MOV_A_I         Macro
                mov     al, RegisterI
                EndM

MOV_I_A         Macro
                mov     RegisterI, al
                EndM

INC_CX          Macro
                lahf
                inc cx
                sahf
                EndM

DEC_CX          Macro
                lahf
                dec cx
                sahf
                EndM

INC_DX          Macro
                lahf
                inc dx
                sahf
                EndM

DEC_DX          Macro
                lahf
                dec dx
                sahf
                EndM

INC_BX          Macro
                lea bx,[bx+1]
                EndM

DEC_BX          Macro
                lea bx,[bx-1]
                EndM

INC_DI          Macro
                lea di,[di+1]
                EndM

DEC_DI          Macro
                lea di,[di-1]
                EndM

INC_SI          Macro
                lea si,[si+1]
                EndM

DEC_SI          Macro
                lea si,[si-1]
                EndM

INC_SP          Macro
                lahf
                inc     sp
                sahf
                EndM

RRD             macro
                push    cx
                mov     ah,al
                mov     al,[bx]
                mov     cl,al
                shr     ax,4
                shl     ah,4
                and     cl,0Fh
                or      ah,cl
                mov     [bx],al
                mov     al,ah
                pop     cx
                EndM

RLD             Macro
                push    cx
                mov     ah,al
                mov     al,[bx]
                mov     cl,ah
                mov     ch,ah
                shl     ax,4
                and     ah,0Fh
                and     cl,0Fh
                or      al,cl
                and     ch,0F0h
                or      ah,ch
                mov     [bx],al
                mov     al,ah
                pop     cx
                EndM

Out_098h_al     Macro
                call    Out98
                EndM

Out_099h_al     Macro
                call    Out99
                EndM

Out_0A0h_al     Macro
                mov     PSGregister,al
                EndM

Out_0A1h_al     Macro
                push    dx
                push    ax
                mov     dl,al
                mov     al,PSGregister
                call    L0093
                pop     ax
                pop     dx
                EndM

Out_0AAh_al     Macro
                mov     port0AAh,al
                EndM

In_al_098h      Macro
                call    In98
                EndM

In_al_099h      Macro
                call    In99
                EndM

In_al_0A2h      Macro
                push    bx
                mov     bl,PSGregister
                mov     bh,0
                mov     al,byte ptr VoiceAfreq[bx]
                pop     bx
                EndM

In_al_0A9h      Macro
                local @@@1
                push    bx
                mov     bl,Port0AAh
                and     bx,0Fh
                mov     al,byte ptr KeyRow[bx]
                pop     bx
                EndM

; Why play with slots?
IN_AL_0A8h      Macro
                EndM

OUT_0A8h_AL     Macro
                EndM
