WaveW           equ     280
WaveH           equ     116
PresentsH       equ     32
TitleAddr       equ     320 * (200 - WaveH)/2 + (320 - WaveW) / 2
MSXgameW        equ     132
MSXgameH        equ     8
MSXgameAddr     equ     320 * ((200 - WaveH)/2 + 80) + (320 - MSXgameW) / 2 - 10

aaaLogo         segment byte use16

                assume  cs:aaaLogo, ds:aaaLogo, es:Nothing

SetLight        macro   Offs
                mov     al,es:[di+bx+Offs]
                cmp     al,32
                setge   ah
                shl     ah,6
                add     al,ah
                mov     es:[di+bx+Offs],al
                endm

XmodeSetup      db      06Dh,059h,05Ah,090h,060h,08Bh,00Bh,03Eh,000h
                db      001h,000h,000h,000h,000h,000h,000h,0EAh,08Ch
                db      0DFh,02Dh,000h,0E7h,004h,0C3h,00FFh
PalData         db      00,00,00, 00,00,00
                db      02,01,00, 63,20,20
                db      00,01,02, 12,24,48
                db      08,08,08, 63,63,63
                db      00,00,00, 00,00,00
nPalColors      equ     ($ - PalData)/6
Port3D4         dw      ?

SetVideoMode    proc    near
                cld
                mov     ax,13h
                int     10h
                xor     ax,ax
                mov     es,ax
                mov     dx,es:[0463h]
                mov     Port3D4,dx
                add     dl,6
                in      al,dx
                mov     dl,0C0h
                mov     cx,16
@@setLinearPal: mov     al,16
                sub     al,cl
                out     dx,al
                out     dx,al
                loop    @@setLinearPal
                mov     al,20h
                out     dx,al
                ret
SetVideoMode    endp

_InitPalette    proc    near
                mov     dx,03C8h
                mov     al,0
                out     dx,al
                inc     dx
                mov     si,offset cs:PalData
                mov     cl,nPalColors

@@makePal:      mov     ch,32
@@makeRamp:     mov     di,3
                xor     bx,bx
@@makeRGB:      mov     al,32
                sub     al,ch
                mov     ah,[si+bx+3]
                sub     ah,[si+bx]
                mul     ah
                shr     ax,5
                add     al,[si+bx]
                out     dx,al
                inc     bx
                dec     di
                jne     @@makeRGB
                dec     ch
                jne     @@makeRamp
                add     si,6
                dec     cl
                jne     @@makePal
                ret
_InitPalette    endp

                assume  ds:ZZZseg
DrawFriendsSoft proc    near
                mov     ax,seg ZZZZseg
                mov     es,ax
                xor     di,di
                mov     VertCount,WaveH ; Refresh image
                mov     bp,offset pictFRIENDS
                mov     bh,0

@@drawIt2:      mov     dx,WaveW
@@draw2:        mov     ax,fs:[bp]
                mov     cx,ax
                inc     bp
                inc     bp
                shr     cx,1
                rep     movsw
                adc     cl,cl
                rep     movsb
                sub     dx,ax
                jz      @@EOL2
                mov     cl,fs:[bp]
                inc     bp
                mov     bl,cl
                sub     dx,cx
                add     si,cx
                shr     cx,2
                jz      @@noDwords
@@copyDwords:   mov     eax,fs:[bp]
                add     bp,4
                stosd
                loop    @@copyDwords
@@noDwords:     mov     cl,bl
                and     cl,3
                jz      @@noBytes
@@copyBytes:    mov     al,fs:[bp]
                inc     bp
                stosb
                loop    @@copyBytes
@@noBytes:      test    dx,dx
                jnz     @@draw2

@@EOL2:         dec     VertCount
                jne     @@drawIt2

                mov     di,LightPos
                mov     bx,WaveW * 7

                mov     cx,47
@@drawLight:    cmp     di,WaveW - 8
                ja      @@dontDraw
                SetLight 0
                SetLight 1
                SetLight 2
                SetLight 3
                SetLight 4
                SetLight 5
                SetLight 6
                SetLight 7
@@dontDraw:     add     bx,WaveW
                dec     di
                jz      @@endLight
                dec     cx
                jnz     @@drawLight

@@endLight:     mov     si,offset pictSOFTWARE + 42 * 2
                mov     di,42 * WaveW
                mov     bp,LightPos

@@nextSoftwLine:mov     cx,bp
                sub     cx,32
                jbe     @@finitDraw

                mov     bx,WaveW

@@drawSoftw:    lods    word ptr fs:[si]
                add     di,ax
                sub     bx,ax
                jz      @@endSkipLine
                sub     cx,ax
                jbe     @@skipNZ

                movzx   ax,byte ptr fs:[si]
                inc     si
                sub     bx,ax
                xor     dx,dx
                cmp     cx,ax
                ja      @@useAL
                mov     dx,ax
                sub     dx,cx
                mov     al,cl
@@useAL:        sub     cx,ax
                xchg    ax,cx
                rep     movs byte ptr es:[di],fs:[si]
                xchg    ax,cx
                add     di,dx
                add     si,dx
                test    bx,bx
                jz      @@endSkipLine
                test    cx,cx
                jns     @@drawSoftw
@@finitLine:    lods    word ptr fs:[si]
                add     di,ax
                sub     bx,ax
                jz      @@endSkipLine
@@skipNZ:       movzx   ax,byte ptr fs:[si]
                inc     si
                add     di,ax
                add     si,ax
                sub     bx,ax
                jnz     @@finitLine
@@endSkipLine:  dec     bp
                cmp     di,WaveW * 110
                jb      @@nextSoftwLine

@@finitDraw:    ret
DrawFriendsSoft endp

ShowLogo        proc    far
                push    ds
                mov     ax,seg aaaLogo
                mov     ds,ax

                assume  ds:aaaLogo

                call    SetVideoMode
                call    _InitPalette
                mov     ax,seg ZZZseg
                mov     ds,ax
                mov     es,ax
                mov     ax,seg pictFRIENDS
                mov     fs,ax
                xor     ax,ax
                mov     gs,ax

                assume  ds:ZZZseg

                mov     cx,WaveW * WaveH * 2 / 4 + 1
                mov     eax,08080808h
                mov     di,offset WaveImage1
                rep     stosd
                mov     TitleStep,offset @@skipFrames
                mov     Wave1,offset WaveImage1
                mov     Wave2,offset WaveImage2
                mov     FadeStep,0
                mov     dx,0DEADh
                mov     cx,0FACEh

                mov     bp,2000
@@waveStart:    rol     dx,3
                add     dl,dh
                adc     ch,dl
                xor     cl,dh
                sub     cx,dx
                adc     ch,dl
                mov     ax,cx
                push    dx
                mov     ax,cx
                xor     dx,dx
                mov     bx,WaveW * (WaveH - 2)
                div     bx
                mov     bx,dx
                mov     al,ch
                and     al,3
                mov     WaveImage1[bx+WaveW],al
                pop     dx
                dec     bp
                jne     @@waveStart

                mov     ax,0A000h
                mov     es,ax

@@waveLoop:     mov     si,Wave1
                add     si,WaveW - 1
                mov     di,Wave2
                add     di,WaveW
                mov     ebx,[si-WaveW]
                mov     ecx,[si]
                mov     edx,[si+WaveW]
                mov     bl,0
                add     si,4

                mov     bp,WaveW * (WaveH - 2)

@@waveLine:     mov     ah,bl
                add     ah,cl
                add     ah,dl
                mov     al,[si-WaveW]
                shrd    ebx,eax,8
                mov     al,[si]
                shrd    ecx,eax,8
                mov     al,[si+WaveW]
                shrd    edx,eax,8
                inc     si
                add     ah,bl
                add     ah,dl
                add     ah,bh
                add     ah,ch
                add     ah,dh
                test    al,2
                setz    al
                shr     ah,3
                add     ah,al
                mov     [di],ah
                inc     di
                dec     bp
                jnz     @@waveLine

@@WaitTimer:    mov     ax,gs:[046Ch]
                cmp     ax,OldTimer
                je      @@WaitTimer
                mov     OldTimer,ax
                mov     si,Wave1
                xchg    si,Wave2
                mov     Wave1,si

                mov     ah,1
                int     16h
                jnz     @@locEx

                jmp     TitleStep

;************** Skip some frames and fade in the wallpaper
@@skipFrames:   mov     ax,0A000h
                mov     es,ax
                mov     di,TitleAddr
                mov     dx,WaveH
@@refresh0:     mov     cx,WaveW/4
                rep     movsd
                add     di,(320 - WaveW)
                dec     dx
                jne     @@refresh0

                inc     FadeStep
                mov     si,offset PalData
                mov     cx,6
@@fadeInRed:    mov     al,cs:[si + 6]
                mul     FadeStep
                shr     ax,4
                mov     cs:[si], al
                inc     si
                loop    @@fadeInRed

                mov     dx,3C8h
                mov     al,0
                out     dx,al
                inc     dx

                mov     ch,32
@@makeRGB1:     mov     al,32
                sub     al,ch
                mov     ah,byte ptr PalData + 3
                sub     ah,byte ptr PalData
                mul     ah
                shr     ax,5
                add     al,byte ptr PalData
                out     dx,al

                mov     al,32
                sub     al,ch
                mov     ah,byte ptr PalData + 4
                sub     ah,byte ptr PalData + 1
                mul     ah
                shr     ax,5
                add     al,byte ptr PalData + 1
                out     dx,al

                mov     al,32
                sub     al,ch
                mov     ah,byte ptr PalData + 5
                sub     ah,byte ptr PalData + 2
                mul     ah
                shr     ax,5
                add     al,byte ptr PalData + 2
                out     dx,al

                dec     ch
                jne     @@makeRGB1

                cmp     FadeStep,16
                jb      @@waveLoop
                mov     FadeStep,0
                mov     TitleStep,offset @@fadeIn
                jmp     @@waveLoop

;************** Fade in FRIENDS writing
@@fadeIn:       mov     di,offset XLATtable
                mov     cx,256
@@makeXLAT:     mov     ax,256-32
                sub     ax,cx
                cbw
                movzx   dx,FadeStep
                imul    dx
                shr     ax,6
                add     al,32
                mov     [di],al
                inc     di
                loop    @@makeXLAT

                mov     di,TitleAddr
                mov     VertCount,WaveH ; Refresh image
                mov     bp,offset pictFRIENDS
                mov     bh,0

@@drawIt:       mov     dx,WaveW
@@draw1:        mov     ax,fs:[bp]
                mov     cx,ax
                inc     bp
                inc     bp
                shr     cx,1
                rep     movsw
                adc     cl,cl
                rep     movsb
                sub     dx,ax
                jz      @@EOL
                mov     cl,fs:[bp]
                sub     dx,cx
                inc     bp
@@drawStrip:    lodsb
                mov     bl,fs:[bp]
                inc     bp
                sub     bl,al
                add     al,XLATtable[bx]
                stosb
                loop    @@drawStrip

                test    dx,dx
                jnz     @@draw1

@@EOL:          add     di,(320 - WaveW)
                dec     VertCount
                jne     @@drawIt

                inc     FadeStep
                mov     al,20
                mul     FadeStep
                shr     ax,6
                add     al,22
                mov     byte ptr PalData+4,al

                mov     dx,3C8h
                mov     al,32
                out     dx,al
                inc     dx

                mov     ch,32
@@makeRGB2:     mov     al,32
                sub     al,ch
                mov     ah,byte ptr PalData + 3
                sub     ah,byte ptr PalData
                mul     ah
                shr     ax,5
                add     al,byte ptr PalData
                out     dx,al

                mov     al,32
                sub     al,ch
                mov     ah,byte ptr PalData + 4
                sub     ah,byte ptr PalData + 1
                mul     ah
                shr     ax,5
                add     al,byte ptr PalData + 1
                out     dx,al

                mov     al,32
                sub     al,ch
                mov     ah,byte ptr PalData + 5
                sub     ah,byte ptr PalData + 2
                mul     ah
                shr     ax,5
                add     al,byte ptr PalData + 2
                out     dx,al

                dec     ch
                jne     @@makeRGB2

                cmp     FadeStep,64
                jne     @@waveLoop
                mov     LightPos,1
                mov     TitleStep,offset @@moveLight
                jmp     @@waveLoop

;************** Move light along writing
@@moveLight:    call    DrawFriendsSoft
                push    ds
                mov     ax,es
                mov     ds,ax
                xor     si,si
                mov     ax,0A000h
                mov     es,ax
                mov     di,TitleAddr
                mov     dx,WaveH
@@refresh:      mov     cx,WaveW/4
                rep     movsd
                add     di,(320 - WaveW)
                dec     dx
                jne     @@refresh
                pop     ds

                add     LightPos,8

                cmp     LightPos,WaveW + 200
                jb      @@waveLoop

                mov     FadeStep,0
                mov     LightPos,0
                mov     di,offset XLATtable
                mov     ax,seg XLATtable
                mov     es,ax
                mov     cx,(32*3-1)*3
                mov     dx,03C7h
                mov     al,1
                out     dx,al
                inc     dx
                inc     dx
                out     0EEh,ax
@@readPal:      in      al,dx
                stosb
                loop    @@readPal
                push    ds
                mov     ax,seg ZZZZseg
                mov     es,ax
                xor     di,di
                mov     ax,0A000h
                mov     ds,ax
                mov     si,TitleAddr
                mov     dx,WaveH
@@getPict:      mov     cx,WaveW/4
                rep     movsd
                add     si,(320 - WaveW)
                dec     dx
                jne     @@getPict
                pop     ds

;*************************************************
;************** Squeeze title ********************
;*************************************************
@@squeezeTitle: cmp     FadeStep,(WaveH - PresentsH)/2
                jae     @@SkipDraw
                mov     ax,0A000h
                mov     es,ax
                mov     di,TitleAddr
                movzx   ax,FadeStep
                push    ax
                push    di
                sub     ax,WaveH
                neg     ax
                dec     ax
                mov     dx,320
                mul     dx
                add     di,ax
                mov     cx,WaveW / 4
                xor     eax,eax
                rep     stosd
                pop     di
                pop     ax
                mov     dx,320
                mul     dx
                add     di,ax
                mov     cx,WaveW / 4
                xor     eax,eax
                rep     stosd

                inc     FadeStep

                mov     di,TitleAddr
                movzx   ax,FadeStep
                mov     cx,WaveH
                sub     cx,ax
                sub     cx,ax
                mov     dx,320
                mul     dx
                add     di,ax
                xor     dx,dx
                mov     ax,(WaveH*256)
                div     cx
                push    ds
                mov     bx,seg ZZZZseg
                mov     ds,bx

                assume  ds:ZZZZseg

                mov     DeltaY,ax
                mov     Vcount,cx
@@vertSq:       mov     ax,Vcount
                sub     ax,cx
                mul     DeltaY
                shld    dx,ax,8
                mov     ax,WaveW
                mul     dx
                mov     si,ax
                push    cx
                mov     cx,WaveW/4
                rep     movsd
                pop     cx
                add     di,(320 - WaveW)
                loop    @@vertSq

                pop     ds

                assume  ds:ZZZseg

@@SkipDraw:     inc     byte ptr LightPos
                call    FadeToFromWhite

                mov     ah,1
                int     16h
                jnz     @@locEx

                cmp     LightPos,64
                jb      @@squeezeTitle

                mov     ax,0101h
                call    UnpackPresents

@@FadeFromWhite:dec     byte ptr LightPos
                call    FadeToFromWhite

                cmp     LightPos,0
                ja      @@FadeFromWhite

                xor     ax,ax
                call    UnpackPresents

                mov     LightPos,MSXgameW + 25

;*************** A little pause ******************
                mov     cx,70
                call    _Pause
                jc      @@locEx

;*************************************************
;********** Show 'AN MSX GAME' text **************
;*************************************************
@@showMSX:      mov     si,offset pictMSXGAME
                mov     di,MSXgameAddr
                mov     bp,8

@@nextMSXline:  push    si
                push    di
@@drawMSXline:  mov     cx,MSXgameW + 25
                sub     cx,LightPos
                mov     bx,cx
                sub     bx,MSXgameW
                jg      @@SkipBXpix
                xor     bx,bx
@@SkipBXpix:    sub     cx,25
                jbe     @@dontDraw
                shr     cx,1
                rep     movs word ptr es:[di],fs:[si]
                adc     cl,cl
                rep     movs byte ptr es:[di],fs:[si]
@@dontDraw:     add     cx,25
                sub     cx,bx
                jle     @@noTail
                mov     bl,1
@@drawLineEnd:  lods    byte ptr fs:[si]
                test    al,al
                jz      @@skip
                sub     al,bl
                mov     es:[di],al
@@skip:         inc     di
                inc     bl
                loop    @@drawLineEnd
@@noTail:       pop     di
                pop     si
                add     si,MSXgameW
                add     di,320
                dec     bp
                jne     @@nextMSXline

                call    WaitRetrace

                dec     LightPos
                jns     @@showMSX

;*************** A little pause ******************
                mov     cx,140
                call    _Pause
                jc      @@locEx

@@locEx:        pop     ds
                mov     ax,0C06h
                mov     dl,0FFh
                int     21h
                ret
ShowLogo        endp

FadeToFromWhite proc    near
                call    WaitRetrace

                mov     dx,03C8h
                mov     al,1
                out     dx,al
                inc     dx
                mov     cx,(32*3-1)*3
                mov     si,offset XLATtable
                mov     bl,byte ptr LightPos
@@fadeWhite:    lodsb
                mov     bh,al
                mov     al,63
                sub     al,bh
                mul     bl
                shr     ax,6
                add     al,bh
                out     dx,al
                loop    @@fadeWhite
                ret
FadeToFromWhite endp

WaitRetrace     proc    near
                mov     dx,Port3D4
                add     dl,6
@@W4retrace1:   in      al,dx
                test    al,8
                je      @@W4retrace1
@@W4retrace2:   in      al,dx
                test    al,8
                jne     @@W4retrace2
                ret
WaitRetrace     endp

_Pause          proc    near
                call    WaitRetrace
                mov     ah,1
                int     16h
                jnz     @@locEx
                loop    _Pause
                clc
                ret
@@locEx:        stc
                ret
_Pause          endp

UnpackPresents  proc    near
                mov     SpaceColor,ax
                push    ds
                mov     ax,seg pictPRESENTS
                mov     ds,ax
                lea     si,fs:pictPRESENTS
                mov     di,titleAddr + 320*(WaveH - PresentsH)/2

                mov     bp,PresentsH
@@NextLine:     mov     bx,WaveW
@@UnpackLine:   mov     cx,[si]
                mov     dx,cx
                inc     si
                inc     si
                mov     ax,0101h
SpaceColor      equ     word ptr $-2
                shr     cx,1
                rep     stosw
                adc     cl,cl
                rep     stosb
                sub     bx,dx
                je      @@EOL
                mov     cl,[si]
                mov     dx,cx
                inc     si
                shr     cx,1
                rep     movsw
                adc     cl,cl
                rep     movsb
                sub     bx,dx
                jne     @@UnpackLine
@@EOL:          add     di,320-WaveW
                dec     bp
                jne     @@NextLine
                pop     ds
                ret
UnpackPresents  endp

                extrn   pictFRIENDS  : byte
                extrn   pictSOFTWARE : byte
                extrn   pictPRESENTS : byte
                extrn   pictMSXGAME  : byte

aaaLogo         ends

ZZZseg          segment para use16
Wave1           dw      ?                       ;offset WaveImage1
Wave2           dw      ?                       ;offset WaveImage2
WaveImage1      db      WaveW * WaveH dup (?)
WaveImage2      db      WaveW * WaveH dup (?)
SecureInterval  dd      ?
XLATtable       db      (32*3-1)*3 dup (?)
OldTimer        dw      ?
TitleStep       dw      ?
LightPos        dw      ?
VertCount       db      ?
FadeStep        db      ?
ZZZseg          ends

ZZZZseg         segment para use16
ImageBuffer     db      WaveW * WaveH dup (?)
DeltaY          dw      ?
Vcount          dw      ?
ZZZZseg         ends
