SendAdlib       macro  Data
                mov    ax, Data
                call   AdlibWrite
                endm

ReadAdlib       macro
                mov    dx, 388h
                in     al, dx
                endm

FreqD           equ     0E77Dh
BlockN          equ     04        ; Default octave
KeyScaleLevel   equ     00000000b ;
;                       01000000b CoolBass	

; << AH - register, AL - data >> 
AdlibWrite      proc    near
                push    dx
                mov     dx, 388h
                xchg    ah, al
                out     dx, al
                rept    6
                in      al, dx
                endm
                xchg    ah, al
                inc     dx
                out     dx, al
                dec     dx
                rept    36
                in      al, dx
                endm
                pop     dx
                ret
AdlibWrite      endp

AdLibInit       proc    near
                SendAdlib 00120h  ; Enable Wave Form
                SendAdlib 0BD20h  ; set Percussion mode
                call      AdLibNoSound

           ; Voice A initialization
                SendAdlib 02001h
                SendAdlib 02301h
                SendAdlib 04018h ; Oper 1
                SendAdlib 0433Fh ; Oper 2
                SendAdlib 060F0h
                SendAdlib 063F0h
                SendAdlib 08014h
                SendAdlib 08313h
                SendAdlib 0E002h
                SendAdlib 0E300h
                SendAdlib 0C00Ah  ; voice A - FM, FeedBack=4
                SendAdlib 0B000h
           ; Voice B initialization
                SendAdlib 02101h
                SendAdlib 02401h
                SendAdlib 04118h ; Oper 1
                SendAdlib 0443Fh ; Oper 2
                SendAdlib 061F0h
                SendAdlib 064F0h
                SendAdlib 08114h
                SendAdlib 08413h
                SendAdlib 0E102h
                SendAdlib 0E400h
                SendAdlib 0C10Ah  ; voice B - FM, FeedBack=4
                SendAdlib 0B100h
           ; Voice C initialization
                SendAdlib 02201h
                SendAdlib 02501h
                SendAdlib 04218h ; Oper 1
                SendAdlib 0453Fh ; Oper 2
                SendAdlib 062F0h
                SendAdlib 065F0h
                SendAdlib 08214h
                SendAdlib 08513h
                SendAdlib 0E202h
                SendAdlib 0E500h
                SendAdlib 0C20Ah  ; voice C - FM, FeedBack=4
                SendAdlib 0B200h
            ; Voice - Noise Part initialization (HiHat operator)
                SendAdlib 03421h
                SendAdlib 0543Fh
                SendAdlib 07499h
                SendAdlib 09400h
                SendAdlib 0F400h

                SendAdlib 0BD28h ; HiHat - on
                ret
AdLibInit       endp

LocalAvol       db  0
LocalBvol       db  0
LocalCvol       db  0

;                Silence                                        Loud WFselect
; PSG regs 8-10     00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F    10
AdLibVolume     db 255,63,63,63,44,38,34,29,22,18,12,10,07,05,02,00

; ********************Channel 1**********************
AdlibAvoice     proc    near
                mov     bx, offset cs:AdLibVolume
                mov     al, VoiceAVol
                and     al, 15
                segCS   xlat
                or      al, KeyScaleLevel
                mov     ah, 043h    ; Volume
                call    AdlibWrite
                mov     bx, VoiceAfreq
                mov     dx, 001h
                mov     ax, FreqD
                cmp     bx, dx
                jbe     @@TooLow
                div     bx
                mov     bx, ax
                jmp     @@SetFreq
    @@TooLow:   mov     bx, 1
    @@SetFreq:  mov     dl, BlockN
   @@TestAgain: cmp     bx, 0400h
                jl      @@Ok
                inc     dl         ; One Block Higher
                shr     bx, 1      ; divide freq
                jmp     @@TestAgain

      @@Ok:     mov     ah, 0A0h    ; F-Num
                mov     al, bl
                call    AdlibWrite
                mov     ah, 0B0h    ; F-Num, Key-on
                and     bh, 3
                mov     al, bh
                shl     dl, 2
                or      dl, 20h     ; KEY-ON
                or      al, dl
                call    AdlibWrite
                test    MixMode, 08h
                mov     al, LocalAvol
                jz      @@SetAnoise
                mov     al, 3Fh     ; silence
   @@SetAnoise: mov     ah, 054h
                call    AdlibWrite  ; HiHat's volume
                ret
AdlibAvoice     endp

; ********************Channel 2**********************
AdlibBvoice     proc    near
                mov     bx, offset cs:AdLibVolume
                mov     al, VoiceBVol
                and     al, 15
                segCS   xlat
                or      al, KeyScaleLevel
                mov     LocalBvol, al
                test    MixMode, 02h
                jz      @@SetVolume
                mov     al, 3Fh
   @@SetVolume: mov     ah, 044h    ; Volume
                call    AdlibWrite

                mov     bx, VoiceBfreq

                mov     dx, 001h    ;
                mov     ax, FreqD   ; 124797 (1E77Dh)
                cmp     bx, dx
                jbe     @@TooLow

                div     bx
                mov     bx, ax
                jmp     @@SetFreq
    @@TooLow:   mov     bx, 1
    @@SetFreq:  mov     dl, BlockN
   @@TestAgain: cmp     bx, 0400h
                jl      @@Ok
                inc     dl         ; One Block Higher
                shr     bx, 1      ; divide freq
                jmp     @@TestAgain

      @@Ok:     mov     ah, 0A1h    ; F-Num
                mov     al, bl
                call    AdlibWrite
                mov     ah, 0B1h    ; F-Num, Key-on
                and     bh, 3
                mov     al, bh
                shl     dl, 2
                or      dl, 20h     ; KEY-ON
                or      al, dl
                call    AdlibWrite
                test    MixMode, 10h
                mov     al, LocalBvol
                jz      @@SetBnoise
                mov     al, 3Fh     ; silence
   @@SetBnoise: mov     ah, 054h
                call    AdlibWrite  ; HiHat's volume
                ret
AdlibBvoice     endp

; ********************Channel 3**********************
AdlibCvoice     proc    near
                mov     bx, offset cs:AdLibVolume
                mov     al, VoiceCVol
                and     al, 15
                segCS   xlat
                or      al, KeyScaleLevel
                mov     LocalCvol, al
                test    MixMode, 04h
                jz      @@SetVolume
                mov     al, 3Fh
   @@SetVolume: mov     ah, 045h    ; Volume
                call    AdlibWrite

                mov     bx, VoiceCfreq

                mov     dx, 001h    ;
                mov     ax, FreqD   ; 124797 (1E77Dh)
                cmp     bx, dx
                jbe     @@TooLow

                div     bx
                mov     bx, ax
                jmp     @@SetFreq
    @@TooLow:   mov     bx, 1
    @@SetFreq:  mov     dl, BlockN
   @@TestAgain: cmp     bx, 0400h
                jl      @@Ok
                inc     dl         ; One Block Higher
                shr     bx, 1      ; divide freq
                jmp     @@TestAgain

      @@Ok:     mov     ah, 0A2h    ; F-Num
                mov     al, bl
                call    AdlibWrite
                mov     ah, 0B2h    ; F-Num, Key-on
                and     bh, 3
                mov     al, bh
                shl     dl, 2
                or      dl, 20h     ; KEY-ON
                or      al, dl
                call    AdlibWrite
                test    MixMode, 20h
                mov     al, LocalCvol
                jz      @@SetCnoise
                mov     al, 3Fh     ; silence
   @@SetCnoise: mov     ah, 054h
                call    AdlibWrite  ; HiHat's volume
    @@Exit:     ret
AdlibCvoice     endp

NoiseXLAT       dw      0000h,0000h,0000h,0000h,0000h,0000h,0000h,0000h
                dw      0000h,0000h,0000h,0000h,0000h,0000h,0000h,0000h
                dw      0000h,0000h,0000h,0000h,0000h,0000h,0000h,0000h
                dw      0000h,0000h,0000h,0000h,0000h,0000h,0000h,0000h

AdlibSetNoise   proc    near
                mov     bl,NPeriod
                mov     bh,0
                shl     bx,1
                mov     ax,NoiseXLAT[bx]
                mov     bl,ah
                mov     ah,0A7h
                call    AdlibWrite
                mov     al,bl
                mov     ah,0B7h
                call    AdlibWrite
                ret
AdlibSetNoise   endp

; al - reg no (0..13),  dl - data
AdLib           proc    near
                push    bx
                push    dx
                mov     bh, 0
                mov     bl, al
                shl     bx, 1
                jmp     word ptr cs:[@@RegTable+bx]
  @@RegTable:   dw      offset @@Reg00  ; a
                dw      offset @@Reg01  ; a
                dw      offset @@Reg02  ; b
                dw      offset @@Reg03  ; b
                dw      offset @@Reg04  ; c
                dw      offset @@Reg05  ; c
                dw      offset @@Reg06  ; noise period
                dw      offset @@Reg07  ; mix
                dw      offset @@Reg08  ; vol a
                dw      offset @@Reg09  ; vol b
                dw      offset @@Reg0A  ; vol c
                dw      offset @@Reg0B  ;  envelope period lo
                dw      offset @@Reg0C  ;                  hi
                dw      offset @@Reg0D  ; envelope shape
    @@Reg00:
    @@Reg01:    call    AdlibAVoice
                jmp     @@Exit
    @@Reg02:
    @@Reg03:    call    AdlibBvoice
                jmp     @@Exit
    @@Reg04:
    @@Reg05:    call    AdlibCvoice
                jmp     @@Exit

    @@Reg06:    call    AdlibSetNoise
                jmp     @@Exit

    @@Reg07:
                call    AdlibAvoice
                call    AdlibBvoice
                call    AdlibCvoice
                jmp     @@Exit
    @@Reg08:
                call    AdlibAvoice
                jmp     @@Exit
    @@Reg09:
                call    AdlibBvoice
                jmp     @@Exit
    @@Reg0A:
                call    AdlibCvoice
                jmp     @@Exit
    @@Reg0B:
    @@Reg0C:
    @@Reg0D:
     @@Exit:
                pop     dx
                pop     bx
                ret
AdLib           endp

AdLibnosound    proc    near
                mov     cx, 18      ; 18 operators total
                mov     bx, offset OperOfs

  @@NextOper:   mov     ah, cs:[bx] ; Operator's port offset
                add     ah, 40h     ; key scale/volume control
                mov     al, 0FFh    ;   silence
                call    AdlibWrite
                inc     bx
                Loop    @@NextOper
                ret
AdLibnosound    endp

; These are the
;                    00 01 02 03 04 05 BD SD TT CY HH
OperNum         db   02,02,02,02,02,02,02,01,01,01,01

Oper1ofs        db   00,01,02,08,09,10,16,20,18,21,17
Oper2ofs        db   03,04,05,11,12,13,19

OperOfs         db   000h,001h,002h,003h,004h,005h,008h,009h,00Ah
                db   00Bh,00Ch,00Dh,010h,011h,012h,013h,014h,015h
