// msxcore.c -- routines for assembly core
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <mmsystem.h>
#include <commdlg.h>
#include <stdlib.h>
#include <assert.h>
#include "msx.h"
#include "msxcore.h"
#include "document.h"
#include "resource.h"
#include "statbar.h"
#include "tape.h"
#include "dialogs.h"
#include "printer.h"
#include "mem.h"

static const char BASED_CODE chKeyTbl[] = {
		// normal
		'7', '6', '5', '4', '3', '2', '1', '0', 
		';', ']', '[','\\', '=', '-', '9', '8', 
		'b', 'a','\0', '/', '.', ',', '`','\'', 
		'j', 'i', 'h', 'g', 'f', 'e', 'd', 'c', 
		'r', 'q', 'p', 'o', 'n', 'm', 'l', 'k', 
		'z', 'y', 'x', 'w', 'v', 'u', 't', 's', 
		// shift
		'&', '^', '%', '$', '#', '@', '!', ')', 
		':', '}', '{', '|', '+', '_', '(', '*', 
		'B', 'A','\0', '?', '>', '<', '~', '"', 
		'J', 'I', 'H', 'G', 'F', 'E', 'D', 'C', 
		'R', 'Q', 'P', 'O', 'N', 'M', 'L', 'K', 
		'Z', 'Y', 'X', 'W', 'V', 'U', 'T', 'S',
		// control
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\x02','\x01','\0','\0','\0','\0','\0','\0', 
		'\x0a','\x09','\x08','\x07','\x06','\x05','\x04','\x03', 
		'\x12','\x11','\x10','\x0f','\x0e','\x0d','\x0c','\x0b', 
		'\x1a','\x19','\x18','\x17','\x16','\x15','\x14','\x13', 
		// graph
		'\0','\0','','\0','','','','\0', 
		'\0','\0','\0','\0','','','','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'','\0','\0','\0','\0','\0','\0','\0', 
		// graph + shift
		'\0','\0','\0','\0','\0','','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','\0','\0','','','','\0','\0', 
		'\0','\0','\0','\0','\0','\0','\0','', 
		'\0','\0','\0','\0','\0','\0','\0','\0', 
		'\0','','','\0','\0','\0','\0','\0', 
		// code
		'','\0','','','','','','\0', 
		'\0','\0','\0','\0','\0','\0','','\0', 
		'','','\0','','','','\0','\0', 
		'','','','','','','','', 
		'','','','','','','','\0', 
		'','','','','','','','', 
		// code + shift
		'\0','\0','','','\xb6','','','\0', 
		'\0','\0','\0','\0','\0','\0','','\0', 
		'\0','','\0','','\0','','\0','\0', 
		'','\0','','','','\0','\0','\0', 
		'\0','\0','\0','\0','','\0','','\0', 
		'\0','\0','\0','\0','\0','','\0','\0' } ;
BYTE		g_byScanLines[9], g_pKeyState[24], g_chKeyTbl[7*48], g_vkTbl[] = {
		VK_F3, VK_F2, VK_F1, 0, VK_CAPITAL, 0, VK_CONTROL, VK_SHIFT, 
		VK_RETURN, 0, VK_BACK, 0, VK_TAB, VK_ESCAPE, VK_F5, VK_F4, 
		VK_RIGHT, VK_DOWN, VK_UP, VK_LEFT, VK_DELETE, VK_INSERT, VK_HOME, VK_SPACE } ;

int				nCurCh, nCurChCount, nAutoFire ;
int				nTapeRecTimeOut = 0 ;
LPBYTE			lpRAM ;
static BYTE		byJoy1, byJoy2 ;
static BOOL		bIgnoreChar, bKeyChanged, bAutoFire ;
extern char		g_szCartAFile[_MAX_PATH], g_szCartBFile[_MAX_PATH] ;
char			g_szGM2SRAM[_MAX_PATH] ;
extern HINSTANCE	g_hInstance ;
extern UINT		g_uState ;
extern HWND		g_hwndMain ;
extern int		g_nTimerCount ;
extern BOOL		g_bCaps, g_bPasting, g_bTopDown, g_bBitmapA ;
extern LPSTR		g_lpszClipboardText ;
extern const char	g_szAppName[] ;
extern FILESETTINGS	g_fileset ;

// load
BYTE _huge*	g_hpLoadData ;
DWORD		g_dwSizeLoad ;
BOOL			g_bLoading ;
// save
static void NEAR CheckSaveSize () ;
BYTE _huge*	g_hpSaveData ;
BYTE _huge*	g_hpSaveDataPtr ;
BOOL			g_bSaving ;
DWORD		g_dwSizeSubSave ;

static _inline DWORD NEAR SizeTapeSave ()
	{ return (DWORD) (g_hpSaveDataPtr - g_hpSaveData) + 4 ; } 

static void NEAR FileErr (UINT nErr, char *szFile)
	{
	char		szBuf[256], szBuf2[_MAX_PATH] ;
	
	LoadString (g_hInstance, nErr, szBuf, 256) ;
	wsprintf (szBuf2, szBuf, (LPSTR)szFile) ;
	MessageBox (g_hwndMain, szBuf2, g_szAppName, MB_ICONEXCLAMATION) ;
	}

#define MEGAROM_A	(LPBYTE) 0x00000
#define MEGAROM_B	(LPBYTE) 0x10000
#define GMASTER_A	(LPBYTE) 0x20000

static BOOL NEAR OpenSRAM (char *szFile, BYTE _huge* lpMem)
	{
	char		szBuf[_MAX_PATH] ;
	HFILE	hFile ;
	long		l ;
	
	if (!SizeGlobal ((void FAR**)&lpMem, 0x24000) )
		return FALSE ;
	
	strcpy (szBuf, szFile) ;
	strcpy (strrchr (szBuf, '\\') + 1, "GMASTER2.RAM") ;
	strcpy (g_szGM2SRAM, szBuf) ;
	
	hFile = _lopen (szBuf, READ) ;
	if (hFile == HFILE_ERROR)
		{
		_fmemset (lpMem + 0x20000, 0, 0x4000) ;
		// format it
		for (l=0x21000;l<0x21200;l+=8)
			lpMem[l] = 0x10 ;
		lpMem[0x21200] = 0xfa ;
		for (l=0x21201;l<0x21206;l++)
			lpMem[l] = 0xff ;
		
		return TRUE ;
		}
	
	if (_hread (hFile, lpMem + 0x20000, 0x4000) != 0x4000 || 
		_llseek (hFile, 0L, 2) != 0x4000 || 
		lpMem[0x20000] || lpMem[0x22000])
		{
		_fmemset (lpMem + 0x20000, 0, 0x4000) ;
		// format it
		for (l=0x21000;l<0x21200;l+=8)
			lpMem[l] = 0x10 ;
		lpMem[0x21200] = 0xfa ;
		for (l=0x21201;l<0x21206;l++)
			lpMem[l] = 0xff ;
		
		FileErr (IDS_GM2RAMERR, szBuf) ;
		}
	
	_lclose (hFile) ;
	
	return TRUE ;
	}

static BOOL NEAR IsPage1 (LPBYTE lpMem)
	{
	int		i ;
	WORD		w ;
	
	for (i=1;i<5;i++)
		{
		w = ((LPWORD)lpMem)[i] ;
		if (w)
			return (w > 0x4000) ;
		}
	
	return TRUE ;
	}

static BOOL NEAR OpenCart (BOOL bCartA)
	{
	HFILE	hFile, hFiles ;
	OFSTRUCT	of ;
	BYTE		byBuf[9] ;
	HCURSOR	hcurOld ;
	BYTE		_huge* lpMem ;
	char		*szFile ;
	int		i ;
	long		lSize ;
	BOOL		bROM ;
	char		szBuf1[_MAX_PATH], szBuf2[_MAX_PATH] ;
	
	szFile = bCartA ? g_szCartAFile : g_szCartBFile ;
	hFile = OpenFile (szFile, &of, OF_READ) ;
	if (hFile == HFILE_ERROR)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
			case 0x0003:
				FileErr (IDS_FILEREADPATH, szFile) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEREADACCESS, szFile) ;
				break ;
			
			default:
				FileErr (IDS_FILEREADUNEXPECT, szFile) ;
				break ;
			}
		
		return FALSE ;
		}
	
	if (_lread (hFile, byBuf, 9) != 9)
		goto carterr1 ;
	
	lSize = _llseek (hFile, 0L, 2) ;
	_llseek (hFile, 0L, 0) ;
	
	if (byBuf[0] == 0xfe)
		{
		if (byBuf[7] != 'A' || byBuf[8] != 'B')
			{
			_lclose (hFile) ;
			
			FileErr (IDS_FILEBIN, szFile) ;
			
			return FALSE ;
			}
		
		bROM = FALSE ;
		}
	else if (byBuf[0] == 'A' && byBuf[1] == 'B')
		{
		bROM = TRUE ;
		}
	else {
		_lclose (hFile) ;
				
		FileErr (IDS_FILEROMBIN, szFile) ;
				
		return FALSE ;
		}
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	if (bROM == FALSE)
		{
		if (lSize >= 0x4007)
			{
			if (!strcmp (szFile + strlen (szFile) - 4, ".000") )
				{
				if (!NewGlobal ((void FAR**)&lpMem, GMEM_MOVEABLE, 0x4000) )
					goto carterr1 ;
				
				strcpy (szBuf1, szFile) ;
				strcpy (strrchr (szBuf1, '.'), ".%.3X") ;
				for (i=0;i<32;i++)
					{
					wsprintf (szBuf2, szBuf1, i) ;
					hFiles = _lopen (szBuf2, READ) ;
					if (hFiles == HFILE_ERROR)
						break ;
					if (!SizeGlobal ((void FAR**)&lpMem, (long)(i + 1) * 0x4000L) )
						{
						_lclose (hFiles) ;
						goto carterr2 ;
						}
					if (_lread (hFiles, byBuf, 7) != 7 || 
						byBuf[0] != 0xfe || 
						_hread (hFiles, lpMem + (long)i * 0x4000L, 0x4000) != 0x4000)
						{
						_lclose (hFiles) ;
						
						if (i)
							FileErr (IDS_FILEBIN, szBuf2) ;
						
						break ;
						}
					_lclose (hFiles) ;
					}
				
				switch (i)
					{
					case 0:
						FreeGlobal ((void FAR**)&lpMem) ;
						_llseek (hFile, 7L, 0) ;
						goto one16rom ;
						break ;
					
					case 1:
						for (i=(bCartA ? 1 : 2);i<12;i+=4)
							MemTbl[i] = lpMem ;
						
						if (bCartA)
							lpCartA = lpMem ;
						else
							lpCartB = lpMem ;
						
						break ;
					
					case 3:
						MessageID (g_hwndMain, IDS_FILEENOUGH, MB_ICONEXCLAMATION) ;
					case 2:
						if (bCartA)
							{
							// you know, i should fix this...
							if (IsPage1 (lpMem) )
								{
								MemTbl[1]  = lpMem + 0x4000 ;
								MemTbl[5]  = lpMem ;
								MemTbl[9]  = lpMem + 0x4000 ;
								}
							else
								{
								MemTbl[1]  = lpMem ;
								MemTbl[5]  = lpMem + 0x4000 ;
								MemTbl[9]  = lpMem ;
								}
							lpCartA = lpMem ;
							}
						else
							{
							if (IsPage1 (lpMem) )
								{
								MemTbl[2]  = lpMem + 0x4000 ;
								MemTbl[6]  = lpMem ;
								MemTbl[10] = lpMem + 0x4000 ;
								lpCartB = lpMem ;
								}
							else
								{
								MemTbl[2]  = lpMem ;
								MemTbl[6]  = lpMem + 0x4000 ;
								MemTbl[10] = lpMem ;
								lpCartB = lpMem ;
								}
							}
						break ;
					
					default:
						if (i < 32 && i > 16)
							{
							MessageID (g_hwndMain, IDS_FILEENOUGH, MB_ICONEXCLAMATION) ;
							i = 16 ;
							}
						else if (i < 16 && i > 8)
							{
							MessageID (g_hwndMain, IDS_FILEENOUGH, MB_ICONEXCLAMATION) ;
							i = 8 ;
							}
						else if (i < 8 && i > 4)
							{
							MessageID (g_hwndMain, IDS_FILEENOUGH, MB_ICONEXCLAMATION) ;
							i = 4 ;
							}
						
						if (bCartA)
							{
							if (*(LPWORD)(lpMem + 0x10) == 'Y' + 256 * 'Z')
								{
								// it's The Game Master 2 !
								MemTbl[5] = GMASTER_A ;
								MemTbl[9] = GMASTER_A ;
								
								if (!OpenSRAM (szFile, lpMem) )
									goto carterr2 ;
								}
							else
								{
								// normal megaROM
								MemTbl[5] = MEGAROM_A ;
								MemTbl[9] = MEGAROM_A ;
								}
							lpCartA = lpMem ;
							byMegaSizeA = (BYTE) i * 2 - 1 ;
							}
						else
							{
							MemTbl[6] = MEGAROM_B ;
							MemTbl[10] = MEGAROM_B ;
							lpCartB = lpMem ;
							byMegaSizeB = (BYTE) i * 2 - 1 ;
							}
						
						break ;
					}
				
				}
			
			}
		else if (lSize >= 0x2007)
			{
			if (!strcmp (szFile + strlen (szFile) - 4, ".000") )
				{
				if (!NewGlobal ((void FAR**)&lpMem, GMEM_MOVEABLE, 0x2000) )
					goto carterr1 ;
				
				strcpy (szBuf1, szFile) ;
				strcpy (strrchr (szBuf1, '.'), ".%.3X") ;
				for (i=0;i<64;i++)
					{
					wsprintf (szBuf2, szBuf1, i) ;
					hFiles = _lopen (szBuf2, READ) ;
					if (hFiles == HFILE_ERROR)
						break ;
					if (!SizeGlobal ((void FAR**)&lpMem, (long)(i + 1) * 0x2000L) )
						{
						_lclose (hFiles) ;
						goto carterr2 ;
						}
					if (_lread (hFiles, byBuf, 7) != 7 || 
						byBuf[0] != 0xfe || 
						_hread (hFiles, lpMem + (long)i * 0x2000L, 0x2000) != 0x2000)
						{
						_lclose (hFiles) ;
						
						if (i)
							FileErr (IDS_FILEBIN, szBuf2) ;
						
						break ;
						}
					_lclose (hFiles) ;
					}
				
				switch (i)
					{
					case 0:
						FreeGlobal ((void FAR**)&lpMem) ;
						_llseek (hFile, 7L, 0) ;
						goto one8rom ;
						break ;
					
					case 1:
						if (!SizeGlobal ((void FAR**)&lpMem, 0x4000) )
							goto carterr1 ;
						
						_fmemcpy (lpMem + 0x2000, lpMem, 0x2000) ;
						for (i=(bCartA ? 1 : 2);i<12;i+=4)
							MemTbl[i] = lpMem ;
						
						if (bCartA)
							lpCartA = lpMem ;
						else
							lpCartB = lpMem ;
						
						break ;
					
					case 3:
						MessageID (g_hwndMain, IDS_FILEENOUGH, MB_ICONEXCLAMATION) ;
					case 2:
						for (i=(bCartA ? 1 : 2);i<12;i+=4)
							MemTbl[i] = lpMem ;
						
						if (bCartA)
							lpCartA = lpMem ;
						else
							lpCartB = lpMem ;
						
						break ;
					
					case 7:
					case 6:
					case 5:
						MessageID (g_hwndMain, IDS_FILEENOUGH, MB_ICONEXCLAMATION) ;
					case 4:
						if (bCartA)
							{
							// you know, i should fix this...
							if (IsPage1 (lpMem) )
								{
								MemTbl[1]  = lpMem + 0x4000 ;
								MemTbl[5]  = lpMem ;
								MemTbl[9]  = lpMem + 0x4000 ;
								}
							else
								{
								MemTbl[1]  = lpMem ;
								MemTbl[5]  = lpMem + 0x4000 ;
								MemTbl[9]  = lpMem ;
								}
							lpCartA = lpMem ;
							}
						else
							{
							if (IsPage1 (lpMem) )
								{
								MemTbl[2]  = lpMem + 0x4000 ;
								MemTbl[6]  = lpMem ;
								MemTbl[10] = lpMem + 0x4000 ;
								lpCartB = lpMem ;
								}
							else
								{
								MemTbl[2]  = lpMem ;
								MemTbl[6]  = lpMem + 0x4000 ;
								MemTbl[10] = lpMem ;
								lpCartB = lpMem ;
								}
							}
						break ;
					
					default:
						if (i < 64 && i > 32)
							{
							MessageID (g_hwndMain, IDS_FILEENOUGH, MB_ICONEXCLAMATION) ;
							i = 32 ;
							}
						else if (i < 32 && i > 16)
							{
							MessageID (g_hwndMain, IDS_FILEENOUGH, MB_ICONEXCLAMATION) ;
							i = 16 ;
							}
						else if (i < 16 && i > 8)
							{
							MessageID (g_hwndMain, IDS_FILEENOUGH, MB_ICONEXCLAMATION) ;
							i = 8 ;
							}
						
						if (bCartA)
							{
							if (*(LPWORD)(lpMem + 0x10) == 'Y' + 256 * 'Z')
								{
								// it's The Game Master 2 !
								MemTbl[5] = GMASTER_A ;
								MemTbl[9] = GMASTER_A ;
								
								if (!OpenSRAM (szFile, lpMem) )
									goto carterr2 ;
								}
							else
								{
								// normal megaROM
								MemTbl[5] = MEGAROM_A ;
								MemTbl[9] = MEGAROM_A ;
								}
							lpCartA = lpMem ;
							byMegaSizeA = (BYTE) i - 1 ;
							}
						else
							{
							MemTbl[6] = MEGAROM_B ;
							MemTbl[10] = MEGAROM_B ;
							lpCartB = lpMem ;
							byMegaSizeB = (BYTE) i - 1 ;
							}
						
						break ;
					}
				
				}
			
			}
		else goto carterr1 ;
		}
	else
		{
		if (lSize >= 0xc000)
			{
			if (lSize >= 0x80000)
				lSize = 0x80000 ;
			else if (lSize >= 0x40000)
				lSize = 0x40000 ;
			else lSize = 0x20000 ;
			
			if (!NewGlobal ((void FAR**)&lpMem, GHND, lSize + 4) )
				goto carterr1 ;
			_hread (hFile, lpMem, lSize) ;
			
			if (bCartA)
				{
				if (*(LPWORD)(lpMem + 0x10) == 'Y' + 256 * 'Z')
					{
					// it's The Game Master 2 !
					MemTbl[5] = GMASTER_A ;
					MemTbl[9] = GMASTER_A ;
					
					if (!OpenSRAM (szFile, lpMem) )
						goto carterr2 ;
					}
				else
					{
					// normal megaROM
					MemTbl[5] = MEGAROM_A ;
					MemTbl[9] = MEGAROM_A ;
					}
				lpCartA = lpMem ;
				byMegaSizeA = (BYTE) ( (lSize / 0x2000L) - 1) ;
				}
			else
				{
				MemTbl[6] = MEGAROM_B ;
				MemTbl[10] = MEGAROM_B ;
				lpCartB = lpMem ;
				byMegaSizeB = (BYTE) ( (lSize / 0x2000L) - 1) ;
				}
			}
		else if (lSize >= 0x8000)
			{
			if (!NewGlobal ((void FAR**)&lpMem, GMEM_MOVEABLE, 0x8004) )
				goto carterr1 ;
			if (_lread (hFile, lpMem, 0x8000) != 0x8000)
				goto carterr2 ;
			if (bCartA)
				{
				// you know, i should fix this...
				if (IsPage1 (lpMem) )
					{
					MemTbl[1]  = lpMem + 0x4000 ;
					MemTbl[5]  = lpMem ;
					MemTbl[9]  = lpMem + 0x4000 ;
					}
				else
					{
					MemTbl[1]  = lpMem ;
					MemTbl[5]  = lpMem + 0x4000 ;
					MemTbl[9]  = lpMem ;
					}
				lpCartA = lpMem ;
				}
			else
				{
				if (IsPage1 (lpMem) )
					{
					MemTbl[2]  = lpMem + 0x4000 ;
					MemTbl[6]  = lpMem ;
					MemTbl[10] = lpMem + 0x4000 ;
					lpCartB = lpMem ;
					}
				else
					{
					MemTbl[2]  = lpMem ;
					MemTbl[6]  = lpMem + 0x4000 ;
					MemTbl[10] = lpMem ;
					lpCartB = lpMem ;
					}
				}
			}
		else if (lSize >= 0x4000)
			{
one16rom:
			if (!NewGlobal ((void FAR**)&lpMem, GMEM_MOVEABLE, 0x4004) )
				goto carterr1 ;
			if (_lread (hFile, lpMem, 0x4000) != 0x4000)
				goto carterr2 ;
			for (i=(bCartA ? 1 : 2);i<12;i+=4)
				MemTbl[i] = lpMem ;
			
			if (bCartA)
				lpCartA = lpMem ;
			else
				lpCartB = lpMem ;
			}
		else if (lSize >= 0x2000)
			{
one8rom:
			if (!NewGlobal ((void FAR**)&lpMem, GMEM_MOVEABLE, 0x4004) )
				goto carterr1 ;
			if (_lread (hFile, lpMem, 0x2000) != 0x2000)
				goto carterr2 ;
			
			_fmemcpy (lpMem + 0x2000, lpMem, 0x2000) ;
			for (i=(bCartA ? 1 : 2);i<12;i+=4)
				MemTbl[i] = lpMem ;
			
			if (bCartA)
				lpCartA = lpMem ;
			else
				lpCartB = lpMem ;
			}
		else	goto carterr1 ;
		}
	
	_lclose (hFile) ;
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
		
	return TRUE ;

carterr2:
	FreeGlobal ((void FAR**)&lpMem) ;
carterr1:
	_lclose (hFile) ;
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	
	if (bROM)
		FileErr (IDS_FILEROM, szFile) ;
	else
		FileErr (IDS_FILEBIN, szFile) ;
	
	return FALSE ;
	}

static LPBYTE NEAR OpenBios ()
	{
	HFILE		hFile ;
	OFSTRUCT		of ;
	LPBYTE		lpMem ;
	HCURSOR		hcurOld ;
	char			szFile[_MAX_PATH] ;
	static WORD	wPatch[] = { 0xe1, 0xe4, 0xe7, 0xea, 0xed, 0xf0, 0 } ;
	int			i ;
	
	GetModuleFileName (g_hInstance, szFile, sizeof (szFile) ) ;
	strcpy (strrchr (szFile, '\\') + 1, "MSX.ROM") ;
	hFile = OpenFile (szFile, &of, OF_READ) ;
	if (hFile == HFILE_ERROR)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
			case 0x0003:
				FileErr (IDS_FILEBIOSPATH, szFile) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEBIOSACCESS, szFile) ;
				break ;
			
			default:
				FileErr (IDS_FILEBIOSUNEXPECT, szFile) ;
				break ;
			}
		
		return NULL ;
		}
	
	if (!NewGlobal ((void FAR**)&lpMem, GMEM_MOVEABLE, 0x8004) )
		return FALSE ;
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	if (_llseek (hFile, 0L, 2) != 0x8000L)
		goto err ;
	
	_llseek (hFile, 0L, 0) ;
	if (_lread (hFile, lpMem, 0x8000) != 0x8000)
		goto err ;
	
	_lclose (hFile) ;
	
	for (i=0;wPatch[i];i++)
		{
		lpMem[wPatch[i]] = 0xd3 ;     // out (n),a
		lpMem[wPatch[i] + 1] = 0xd0 ; // port d0
		lpMem[wPatch[i] + 2] = 0xc9 ; // ret
		}
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	
	return lpMem ;

err:
	_lclose (hFile) ;
	FreeGlobal ((void FAR**)&lpMem) ;
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
		
	FileErr (IDS_FILEBIOS, szFile) ;
	
	return NULL ;
	}

static LPBYTE NEAR OpenBdos ()
	{
	HFILE		hFile ;
	OFSTRUCT		of ;
	LPBYTE		lpMem ;
	HCURSOR		hcurOld ;
	char			szFile[_MAX_PATH] ;
	static WORD	wPatch[] = { 0x10, 0x13, 0x16, 0x1c, 0 } ;
	int			i ;
	
	GetModuleFileName (g_hInstance, szFile, sizeof (szFile) ) ;
	strcpy (strrchr (szFile, '\\') + 1, "DISK.ROM") ;
	hFile = OpenFile (szFile, &of, OF_READ) ;
	if (hFile == HFILE_ERROR)
		{
		switch (of.nErrCode)
			{
			case 0x0002:
			case 0x0003:
				FileErr (IDS_FILEBIOSPATH, szFile) ;
				break ;
			
			case 0x0005:
				FileErr (IDS_FILEBIOSACCESS, szFile) ;
				break ;
			
			default:
				FileErr (IDS_FILEBIOSUNEXPECT, szFile) ;
				break ;
			}
		
		return NULL ;
		}
	
	if (!NewGlobal ((void FAR**)&lpMem, GMEM_MOVEABLE, 0x4004) )
		return FALSE ;
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	if (_llseek (hFile, 0L, 2) != 0x4000L)
		goto err ;
	
	_llseek (hFile, 0L, 0) ;
	if (_lread (hFile, lpMem, 0x4000) != 0x4000)
		goto err ;
	
	_lclose (hFile) ;
	
	for (i=0;wPatch[i];i++)
		{
		lpMem[wPatch[i]] = 0xd3 ;     // out (n),a
		lpMem[wPatch[i] + 1] = 0xd0 ; // port d0
		lpMem[wPatch[i] + 2] = 0xc9 ; // ret 
		}
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	
	return lpMem ;

err:
	_lclose (hFile) ;
	FreeGlobal ((void FAR**)&lpMem) ;
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
		
	FileErr (IDS_FILEBIOS, szFile) ;
	
	return NULL ;
	}

void SetCarts ()
	{
	HFILE	hFile ;
	int		i ;
	
	// SRAM ?
	if (MemTbl[5] == GMASTER_A)
		{
		hFile = _lcreat (g_szGM2SRAM, 0) ;
		if (HFILE_ERROR == hFile)
			MessageID (g_hwndMain, IDS_SRAMSAVE, MB_ICONEXCLAMATION) ;
		else
			{
			if (_lwrite (hFile, ((BYTE _huge*)lpCartA) + 0x20000, 0x4000) != 0x4000)
				MessageID (g_hwndMain, IDS_SRAMSAVE, MB_ICONEXCLAMATION) ;
			
			_lclose (hFile) ;
			}
				
		}

	for (i=1;i<16;i+=4)
		{
		MemTbl[i] = MemTbl[8] ;
		if (g_fileset.nDisk != 1)
			MemTbl[i+1] = MemTbl[8] ;
		}
	
	// free 'm
	if (lpCartA != NULL)
		FreeGlobal ((void FAR**)&lpCartA) ;
	if (lpCartB != NULL)
		FreeGlobal ((void FAR**)&lpCartB) ;
	
	// now, load the new ones...
	lpCartA = lpCartB = NULL ;
	if (g_szCartAFile[0])
		OpenCart (TRUE) ;
	
	if (g_fileset.nDisk != 1)
		{
		if (g_szCartBFile[0])
			OpenCart (FALSE) ;
		}
	
	ResetMega () ;
	}

BOOL StartEmulator ()
	{
	LPBYTE	lpROM, lpBios, lpBdos ;
	HCURSOR	hcurOld ;
	int		i ;
	
	lpBios = OpenBios () ;
	if (lpBios == NULL)
		return FALSE ;
	
	if (g_fileset.nDisk < 2)
		{
		lpBdos = OpenBdos () ;
		if (lpBdos == NULL)
			{
			FreeGlobal ((void FAR**)&lpBios) ;
			
			return FALSE ;
			}
		}
	
	if ( !SetTimer (g_hwndMain, 1, 1000/20, NULL) )
		{
		DeActivate () ;
		MessageID (g_hwndMain, IDS_MSGTIMER, MB_ICONEXCLAMATION | MB_OK) ;
		goto fail ;
		}
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	// MSX computer main memory
	// always allocate 4 more bytes to prevent errors with thingies like ld (0ffffh),hl
	if (!NewGlobal ((void FAR**)&lpROM, GMEM_MOVEABLE, 0x4004) )
		goto fail ;
	_fmemset (lpROM, 255, 0x4004) ;
	for (i=0;i<16;i++)
		{
		MemTbl[i] = lpROM ;
		ROMTbl[i] = 1 ;
		}
	
	// cartridges
	lpCartA = lpCartB = NULL ;
	if (g_szCartAFile[0] && !OpenCart (TRUE) )
		goto fail ;
	
	if (g_fileset.nDisk != 1)
		{
		if (g_szCartBFile[0] && !OpenCart (FALSE) )
			goto fail ;
		}
	
	// MSX computer video RAM
	if (!NewGlobal ((void FAR**)&lpVideoMem, GHND, 0x4000L) )
		goto fail ;
	
	// bios
	MemTbl[0] = lpBios ;
	MemTbl[4] = lpBios + 0x4000 ;
	if (g_fileset.nDisk == 0)
		MemTbl[7] = lpBdos ;
	else if (g_fileset.nDisk == 1)
		MemTbl[6] = lpBdos ;
	
	// ram
	if (!NewGlobal ((void FAR**)&lpRAM, GHND, 0x10004L) )
		goto fail ;
	
	if (g_fileset.nDisk)
		{
		MemTbl[3]  = lpRAM ;
		MemTbl[7]  = lpRAM + 0x4000 ;
		ROMTbl[3] = ROMTbl[7] = 0 ;
		}
	
	MemTbl[11] = lpRAM + 0x8000 ;
	MemTbl[15] = lpRAM + 0xc000 ;
	ROMTbl[11] = ROMTbl[15] = 0 ;
	
	g_uState = 1 ;
	
	Reset () ;
	ResetKeyb () ;
	
	_fmemset (lpBitmapA, FIRSTENTRY, 0xc000) ;
	_fmemset (lpBitmapB, FIRSTENTRY, 0xc000) ;
	byBackClr = 0 ;
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	
	return TRUE ;

fail:
	StopEmulator () ;
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;

	return FALSE ;
	}

void PauseEmulator ()
	{
	if (g_uState >= 2)
		g_uState = 1 ;		// resume
	else
		{
		g_uState = 2 ;		// pause
		}
	}

void StopEmulator ()
	{
	HCURSOR	hcurOld ;
	HFILE	hFile ;
	
	// SRAM ?
	if (MemTbl[5] == GMASTER_A)
		{
		hFile = _lcreat (g_szGM2SRAM, 0) ;
		if (HFILE_ERROR == hFile)
			MessageID (g_hwndMain, IDS_SRAMSAVE, MB_ICONEXCLAMATION) ;
		else
			{
			if (_lwrite (hFile, ((BYTE _huge*)lpCartA) + 0x20000, 0x4000) != 0x4000)
				MessageID (g_hwndMain, IDS_SRAMSAVE, MB_ICONEXCLAMATION) ;
			
			_lclose (hFile) ;
			}
		}
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	// memory
	if (lpVideoMem != NULL)
		FreeGlobal ((void FAR**)&lpVideoMem) ;
	// ram
	if (MemTbl[3] != NULL)
		FreeGlobal ((void FAR**)&MemTbl[2]) ;
	// bios
	if (MemTbl[0] != NULL)
		FreeGlobal ((void FAR**)&MemTbl[0]) ;
	if (g_fileset.nDisk == 0)
		FreeGlobal ((void FAR**)&MemTbl[7]) ;
	else if (g_fileset.nDisk == 1)
		FreeGlobal ((void FAR**)&MemTbl[6]) ;
	
	// rom
	if (MemTbl[8] != NULL)
		FreeGlobal ((void FAR**)&MemTbl[8]) ;
	// cartridges
	if (lpCartA != NULL)
		FreeGlobal ((void FAR**)&lpCartA) ;
	if (lpCartB != NULL)
		FreeGlobal ((void FAR**)&lpCartB) ;
	
	if (g_bPasting)
		{
		FreeGlobal ((void FAR**)&g_lpszClipboardText) ;
		g_bPasting = FALSE ;
		}
	
	g_uState = 0 ;
	
	g_bCaps = FALSE ;
	SetIndicators () ;
	
	if (g_bLoading)
		GlobalFreePtr (g_hpLoadData) ;
	if (g_bSaving)
		GlobalFreePtr (g_hpSaveData) ;
	
	KillTimer (g_hwndMain, 1) ;
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	}

void ResetEmulator ()
	{
	g_uState = 1 ;
	
	Reset () ;
	ResetKeyb () ;
	}

// keyboard
static BYTE	byAltScan ;

void OnChar (WPARAM wParam, LPARAM lParam)
	{
	int		i ;
	BYTE		scan ;
	
	if (bIgnoreChar)
		{
		bIgnoreChar = FALSE ;
		return ;
		}
	
	scan = LOBYTE (HIWORD (lParam) ) ;
	
	for (i=0;i<(7*48);i++)
		{
		if (chKeyTbl[i] == (char)wParam)
			{
			if (scan != 0 && scan != byAltScan)
				{
				g_chKeyTbl[i] = scan ;
				}
			else
				{
				nCurCh = i ;
				nCurChCount = 4 ;
				}
			
			bKeyChanged = TRUE ;
			
			break ;
			}
		}
	
	return ;
	}

void OnKey (WPARAM wParam, LPARAM lParam)
	{
	int		i ;
	BYTE		scan ;
	
	if (wParam == VK_CAPITAL && !g_fileset.bCaps)
		{
		bIgnoreChar = FALSE ;
		return ;
		}
	
	if (!byAltScan && wParam == VK_MENU)
		byAltScan = LOBYTE (HIWORD (lParam) ) ;
	
	for (i=0;i<24;i++)
		{
		if (g_vkTbl[i] == (BYTE)wParam)
			{
			g_pKeyState[i] = !(lParam & 0x80000000) ;
			
			bIgnoreChar = TRUE ;
			bKeyChanged = TRUE ;
			return ;
			}
		}
	if (lParam & 0x80000000) // key up
		{
		scan = LOBYTE (HIWORD (lParam) ) ;
		
		for (i=0;i<(7*48);i++)
			{
			if (g_chKeyTbl[i] == scan)
				{
				g_chKeyTbl[i] = 0 ;
				
				bIgnoreChar = FALSE ;
				bKeyChanged = TRUE ;
				return ;
				}
			}
		}
	
	bIgnoreChar = FALSE ;
	return ;
	}

void ResetKeyb ()
	{
	memset (g_pKeyState, 0, 24) ;
	memset (g_chKeyTbl, 0, 7*48) ;
	bKeyChanged = TRUE ;
	
	nCurChCount = 0 ;
	nCurCh = -1 ;
	}

static void NEAR AssembleKeyb ()
	{
	int				i, n ;
	BYTE				line ;
	static const BYTE	Key[] = { 0, 1, 2, 4, 5, 16, 17 } ;
	static BOOL		bKeySkip = FALSE ;
	
	if (nCurChCount == 0 || !--nCurChCount)
		{
		if (g_bPasting)
			{
			ResetKeyb () ;
			
			if (*g_lpszClipboardText)
				{
				// if the same pause one key
				if (bKeySkip)
					{
					nCurChCount = 4 ;
					bKeySkip = FALSE ;
					}
				else
					{
					// control codes cannot be passed to SendChar ()
					if (*g_lpszClipboardText <= 0x20)
						{
						nCurChCount = 4 ;
						
						switch (*g_lpszClipboardText++)
							{
							case '\t' :	// tab
								OnKey (VK_TAB, 0L) ; // 0 is key up
								break ;
							
							case ' ' :	// space
								OnKey (VK_SPACE, 0L) ; // 0 is key up
								break ;
							
							case '\n' :	// newline: return
								OnKey (VK_RETURN, 0L) ; // 0 is key up
								break ;
							}
						}
					else 
						{
						bIgnoreChar = FALSE ;
						OnChar (*g_lpszClipboardText++, 0L) ;	// no scan code
						}
					
					bKeySkip = TRUE ;
					}
				}
			else
				{
				GlobalFreePtr (g_lpszClipboardText) ;
				g_bPasting = FALSE ;
				}
			}
		}
	else if (!bKeyChanged && !nAutoFire && !g_pKeyState[23])
		return ;
	
	for (i=0;i<3;i++)
		{
		line=0 ;
		
		for (n=0;n<8;n++)
			{
			line *= 2 ;
			if (g_pKeyState[i * 8 + n])
				line |= 1 ;
			}
		
		g_byScanLines[6 + i] = line ;
		}
	
	for (i=0;i<6;i++)
		g_byScanLines[i] = 0 ;
	
	for (i=0;i<(7*48);i++)
		{
		if (g_chKeyTbl[i])
			{
			n = (i % 48) / 8 ;
			
			g_byScanLines[n] = 0x80 >> (i % 8) ;
				
			if (Key[i / 48] != 1)
				g_byScanLines[6] |= Key[i / 48] ;
			else
				{
				if (n < 2 || (n == 2 && ((i % 8) > 1)) || !g_fileset.bCaps)
					g_byScanLines[6] |= 1 ;
				}
			}
		}
	
	if (g_byScanLines[8] & 1 && nAutoFire && bAutoFire)
		g_byScanLines[8] &= 0xfe ;
	
	if (nCurChCount > 0 && nCurCh != -1)
		{
		n = (nCurCh % 48) / 8 ;
		
		g_byScanLines[n] = 0x80 >> (nCurCh % 8) ;
		
		if (Key[nCurCh / 48] != 1)
			g_byScanLines[6] |= Key[nCurCh / 48] ;
		else
			{
			if (n < 2 || (n == 2 && ((nCurCh % 8) > 1)) || !g_fileset.bCaps || g_bPasting)
				g_byScanLines[6] |= 1 ;
			}
		}
	bKeyChanged = FALSE ;
	}

BOOL	g_bJoyDrv = TRUE, g_bJoyPlug[2] = { TRUE, TRUE } ;

static void NEAR JoystickError (WORD err, int JoyNum)
	{
	char		szBuf1[256], szBuf2[256] ;
	
	if (err == MMSYSERR_NODRIVER)
		{
		DeActivate () ;
		MessageID (g_hwndMain, IDS_NOJOYDRIVER, MB_OK | MB_ICONSTOP) ;
		g_bJoyDrv = FALSE ;
		}
	else
		{
		if (g_bJoyPlug[JoyNum])
			{
			LoadString (g_hInstance, IDS_JOYUNPLUG, szBuf2, 256) ;
			wsprintf (szBuf1, szBuf2, (JoyNum ? g_fileset.nJoy2 : g_fileset.nJoy1) ) ;
			
			DeActivate () ;
			MessageBox (g_hwndMain, szBuf1, g_szAppName, MB_OK | MB_ICONEXCLAMATION) ;
			
			g_bJoyPlug[JoyNum] = FALSE ;
			}
		}
	}

BYTE FAR Joy1 ()
	{
	JOYINFO	joyinfo ;
	int		i ;
	
	if (g_bJoyDrv && g_fileset.nJoy1)
		{
		if (byJoy1 == 0)
			{
			byJoy1 = 0xff ;
			
			i = joyGetPos (g_fileset.nJoy1 - 1, &joyinfo) ;
				
			if (i)
				{
				// error
				JoystickError (i, 0) ;
				}
			else
				{
				// okay, interpret it
				if (joyinfo.wButtons & JOY_BUTTON1 && (!nAutoFire || bAutoFire) )
					byJoy1 &= ~0x10 ;
				if (joyinfo.wButtons & JOY_BUTTON2)
					byJoy1 &= ~0x20 ;
				
				if (joyinfo.wXpos > 0xc000)
					byJoy1 &= ~0x08;
				else if (joyinfo.wXpos < 0x4000)
					byJoy1 &= ~0x04 ;
				
				if (joyinfo.wYpos > 0xc000)
					byJoy1 &= ~0x02 ;
				else if (joyinfo.wYpos < 0x4000)
					byJoy1 &= ~0x01 ;
				}
			}
		
		return byJoy1 ;
		}
	else return 0xff ;
	}

BYTE FAR Joy2 ()
	{
	JOYINFO	joyinfo ;
	int		i ;
	
	if (g_bJoyDrv && g_fileset.nJoy2)
		{
		if (byJoy2 == 0)
			{
			byJoy2 = 0xff ;
			
			i = joyGetPos (g_fileset.nJoy2 - 1, &joyinfo) ;
				
			if (i)
				{
				// error
				JoystickError (i, 1) ;
				}
			else
				{
				// okay, interpret it
				if (joyinfo.wButtons & JOY_BUTTON1 && (!nAutoFire || bAutoFire) )
					byJoy2 &= ~0x10 ;
				if (joyinfo.wButtons & JOY_BUTTON2)
					byJoy2 &= ~0x20 ;
				
				if (joyinfo.wXpos > 0xc000)
					byJoy2 &= ~0x08 ;
				else if (joyinfo.wXpos < 0x4000)
					byJoy2 &= ~0x04 ;
					
				if (joyinfo.wYpos > 0xc000)
					byJoy2 &= ~0x02 ;
				else if (joyinfo.wYpos < 0x4000)
					byJoy2 &= ~0x01 ;
				}
			}
		
		return byJoy2 ;
		}
	else return 0xff ;
	}

void TimeSliceEmulator ()
	{
	static int	nScreenCount = 2 ;
	int			i ;
#ifdef _DEBUG
	DWORD		dw, dwBuild, dwBlt, dwCpu, dwSound ;
	BOOL		bUpdate ;
	char		szBuf[100] ;
	
	bUpdate = FALSE ;
#endif
	
	if (g_uState == 1 && g_nTimerCount)
		{
		g_nTimerCount--;
		
		if (g_byScanLines[8] & 8)
			{
			for (i=0;i<256*3;i++)
				pNameTbl[i] = i & 255 ;
			}
		
		if (g_fileset.nAutoFire)
			{
			if (!nAutoFire--)
				{
				nAutoFire = g_fileset.nAutoFire ;
				bAutoFire = !bAutoFire ;
				}
			}
		
		// tape recording time out
		if (nTapeRecTimeOut)
			if (!--nTapeRecTimeOut)
				{
				assert (g_bSaving) ;
				CheckSaveSize () ;
				*(DWORD _huge*)(g_hpSaveDataPtr - 4L) = (DWORD) -1L ;
				SaveRecording (g_hwndMain, g_hpSaveData, SizeTapeSave () ) ;
				GlobalFreePtr (g_hpSaveData) ;
				g_bSaving = FALSE ;
				}
		
		// keyboard
		AssembleKeyb () ;
		
		// joystick
		byJoy1 = byJoy2 = 0 ;
		
		// cpu
#ifdef _DEBUG
		dw = timeGetTime () ;
#endif
		if (cpu () )
			{
			DeActivate () ;
			MessageID (g_hwndMain, IDS_MSGCRASH, MB_ICONSTOP) ;
			
			StopEmulator () ;
			InvalidateRect (g_hwndMain, NULL, TRUE) ;	// clear client area
			}
		
#ifdef _DEBUG
		dwCpu = timeGetTime () - dw ;
#endif
		
		SetIndicators () ;
		
#ifdef _DEBUG
		dw = timeGetTime () ;

		dwSound = timeGetTime () - dw ;
#endif
		
		// screen
		if (!nScreenCount--)
			{
			if (bScrModified)
				{
#ifdef _DEBUG
				bUpdate = TRUE ;
				dw = timeGetTime () ;
#endif
				// buildscreen generates a interrupt
				g_bBitmapA = !g_bBitmapA ;
				
				if (g_bTopDown)
					BuildScreenTD () ;
				else
					BuildScreenBU () ;
				
#ifdef _DEBUG
				dwBuild = timeGetTime () - dw ;
				dw = timeGetTime () ;
#endif
				DrawFrame () ;
#ifdef _DEBUG
				dwBlt = timeGetTime () - dw ;
#endif
			  	}
			else
				Interrupt () ;
			
			nScreenCount = g_fileset.nFps ;
			}
		else
			Interrupt () ;
		
#ifdef _DEBUG
		if (bUpdate && (g_byScanLines[8] & 8) )
			{
			wsprintf (szBuf, "BuildScreen : %lu ms\n"
				"Screen Blt : %lu ms\n"
				"cpu : %lu ms\nSound : %lu ms\n", dwBuild, dwBlt, dwCpu, dwSound) ;
			MessageBox (g_hwndMain, szBuf, g_szAppName, MB_ICONINFORMATION) ;
			}
#endif
		}
	}

// tape
#define TAPE_SUCCES      0x0000
#define TAPE_ERROR		0x0100

static void NEAR CheckSaveSize ()
	{
	DWORD	dwOffset = (g_hpSaveDataPtr - g_hpSaveData) ;
	DWORD	dwSize   = dwOffset + 4 + g_dwSizeSubSave ;
	
	if (GlobalSize (GlobalPtrHandle (g_hpSaveData) ) < dwSize)
		{
		g_hpSaveData = GlobalLock (GlobalReAlloc (GlobalPtrHandle (g_hpSaveData), 
			dwSize + 4096, GMEM_ZEROINIT) ) ;
		g_hpSaveDataPtr = g_hpSaveData + dwOffset ;
		}
	}

static BOOL NEAR CheckBreak ()
	{
	return (g_byScanLines[6] & 2 && g_byScanLines[7] & 0x10) ;
	}

// disk
#undef _WINDOWS
   #include <bios.h>
#define _WINDOWS
extern char	g_szDiskAFile[], g_szDiskBFile[] ;
BOOL			g_bDriveA, g_bDriveB ;

int ReadSector (int nDisk, LPBYTE lpAddr, int nSec, int nSecs, BYTE byMedia)
	{
	HFILE	hFile ;
	int		i ;
	WORD		w ;
	struct _diskinfo_t	diskinfo ;
	
	if (nDisk > 1)
		return 12 ;
	
	if (nDisk ? !g_fileset.bDrvBDrv : !g_fileset.bDrvADrv)
		{
		// disk file
		if (nDisk ? g_szDiskBFile[0] : g_szDiskAFile[0])
			{
			if (nSec > 1439)
				return 6 ;
			
			hFile = _lopen (nDisk ? g_szDiskBFile : g_szDiskAFile, READ) ;
			if (HFILE_ERROR == hFile)
				return 2 ;
			
			if (HFILE_ERROR == _llseek (hFile, (long)nSec * 512L, 0) )
				{
				_lclose (hFile) ;
				
				return 8 ;
				}
			
			if ((UINT)(nSecs * 512) != _lread (hFile, lpAddr, nSecs * 512) )
				{
				_lclose (hFile) ;
				
				return 8 ;
				}
			
			_lclose (hFile) ;
			
			return -1 ;
			}
		}
	else
		{
		// real drive
		diskinfo.drive = (BYTE)(nDisk ? g_fileset.nDrvB : g_fileset.nDrvA) ;
		if (!diskinfo.drive--)
			return 2 ;
		
		while (nSecs)
			{
			if (nSec > 1439)
				return 6 ;
			
			if (byMedia == 0xf8)
				{
				diskinfo.head = 0 ;
				diskinfo.track = nSec / 9 ;
				diskinfo.sector = nSec % 9 + 1 ;
				}
			else
				{
				diskinfo.head = (nSec / 9) % 2 ;
				diskinfo.track = nSec / 18 ;
				diskinfo.sector = nSec % 9 + 1 ;
				}
			
			diskinfo.nsectors = 1 ;
			diskinfo.buffer = lpAddr ;
			
			i = 0 ;
tryagain:
			w = _bios_disk (_DISK_READ, &diskinfo) / 256 ;
			
			if (w && i < 1)
				{
				i++ ;
				_bios_disk (_DISK_RESET, NULL) ;
				goto tryagain ;
				}
			
			switch (w)
				{
				case 0:
					break ;
				
				case 0x03:
					return 0 ;
				
				case 0x06:
				case 0x80:
				case 0xaa:
					return 2 ;
				
				case 0x10:
				case 0x11:
					return 4 ;
				
				case 0x40:
				case 0x0a:
				case 0x0b:
					return 6 ;
				
				case 0x02:
				case 0x04:
					return 8 ;
				
				case 0xcc:
					return 10 ;
				
				default:
					return 12 ;
				}
			
			lpAddr += 512 ;
			nSec++ ;
			nSecs-- ;
			}
		
		return -1 ;
		}
	}

int WriteSector (int nDisk, LPBYTE lpAddr, int nSec, int nSecs, BYTE byMedia)
	{
	HFILE	hFile ;
	int		i ;
	WORD		w ;
	struct _diskinfo_t	diskinfo ;
	
	if (nDisk > 1)
		return 12 ;
	
	if (nDisk ? !g_fileset.bDrvBDrv : !g_fileset.bDrvADrv)
		{
		// disk file
		if (nDisk ? g_szDiskBFile[0] : g_szDiskAFile[0])
			{
			if (nDisk ? g_fileset.bDrvBProt : g_fileset.bDrvAProt)
				return 0 ;
			
			if (nSec > 1439)
				return 6 ;
			
			hFile = _lopen (nDisk ? g_szDiskBFile : g_szDiskAFile, WRITE) ;
			
			if (HFILE_ERROR == hFile)
				return 2 ;
			
			if (HFILE_ERROR == _llseek (hFile, (long)nSec * 512L, 0) )
				{
				_lclose (hFile) ;
				
				return 8 ;
				}
			
			if ((UINT)(nSecs * 512) != _lwrite (hFile, lpAddr, nSecs * 512) )
				{
				_lclose (hFile) ;
				
				return 10 ;
				}
			
			_lclose (hFile) ;
			
			return -1 ;
			}
		}
	else
		{
		// real drive
		diskinfo.drive = (BYTE)(nDisk ? g_fileset.nDrvB : g_fileset.nDrvA) ;
		if (!diskinfo.drive--)
			return 2 ;
		
		while (nSecs)
			{
			if (nSec > 1439)
				return 6 ;
			
			if (byMedia == 0xf8)
				{
				diskinfo.head = 0 ;
				diskinfo.track = nSec / 9 ;
				diskinfo.sector = nSec % 9 + 1 ;
				}
			else
				{
				diskinfo.head = (nSec / 9) % 2 ;
				diskinfo.track = nSec / 18 ;
				diskinfo.sector = nSec % 9 + 1 ;
				}
			
			diskinfo.nsectors = 1 ;
			diskinfo.buffer = lpAddr ;
			
			i = 0 ;
tryagain:
			w = _bios_disk (_DISK_WRITE, &diskinfo) / 256 ;
			
			if (w && i < 1)
				{
				i++ ;
				_bios_disk (_DISK_RESET, NULL) ;
				goto tryagain ;
				}
			
			switch (w)
				{
				case 0:
					break ;
				
				case 0x03:
					return 0 ;
				
				case 0x06:
				case 0x80:
				case 0xaa:
					return 2 ;
				
				case 0x10:
				case 0x11:
					return 4 ;
				
				case 0x40:
				case 0x0a:
				case 0x0b:
					return 6 ;
				
				case 0x02:
				case 0x04:
					return 8 ;
				
				case 0xcc:
					return 10 ;
				
				default:
					return 12 ;
				}
			
			lpAddr += 512 ;
			nSec++ ;
			nSecs-- ;
			}
		
		return -1 ;
		}
	
	return 2 ;
	}

BOOL CreateDSKfile (BOOL b720Kb, char* szFile)
	{
	HGLOBAL	hglb ;
	HFILE	hFile ;
	BYTE		bySec[512], bySec2[512] ;
	int		i ;
	
	hFile = _lcreat (szFile, 0) ;
	if (HFILE_ERROR == hFile)
		return FALSE ;
	
	if (b720Kb)
		{
		hglb = LoadResource (g_hInstance, FindResource (g_hInstance, 
			MAKEINTRESOURCE (IDSEC_2DD), "SEC") ) ;
		if (512 != _lwrite (hFile, LockResource (hglb), 512) )
			goto err2 ;
		UnlockResource (hglb) ;
		FreeResource (hglb) ;
		
		memset (bySec, 0, 512) ;
		memset (bySec2, 0, 512) ;
		bySec[0] = 0xf9 ;
		bySec[1] = 0xff ;
		bySec[2] = 0xff ;
		
		if  (512 != _lwrite (hFile, bySec, 512) || 
			512 != _lwrite (hFile, bySec2, 512) || 
			512 != _lwrite (hFile, bySec2, 512) || 
			512 != _lwrite (hFile, bySec, 512) || 
			512 != _lwrite (hFile, bySec2, 512) ||
			512 != _lwrite (hFile, bySec2, 512) )
				goto err ;
		
		for (i=0;i<7;i++)
			if (512 != _lwrite (hFile, bySec2, 512) )
				goto err ;
		
		memset (bySec, 0xe5, 512) ;
		
		for (i=0;i<1426;i++)
			if (512 != _lwrite (hFile, bySec, 512) )
				goto err ;
		
		_lclose (hFile) ;
		
		mmioOpen (szFile, NULL, MMIO_PARSE) ;
		
		return TRUE ;
		}
	else
		{
		hglb = LoadResource (g_hInstance, FindResource (g_hInstance, 
			MAKEINTRESOURCE (IDSEC_1DD), "SEC") ) ;
		if (512 != _lwrite (hFile, LockResource (hglb), 512) )
			goto err2 ;
		UnlockResource (hglb) ;
		FreeResource (hglb) ;
		
		memset (bySec, 0, 512) ;
		memset (bySec2, 0, 512) ;
		bySec[0] = 0xf8 ;
		bySec[1] = 0xff ;
		bySec[2] = 0xff ;
		
		if (512 != _lwrite (hFile, bySec, 512) || 
			512 != _lwrite (hFile, bySec2, 512) || 
			512 != _lwrite (hFile, bySec, 512) || 
			512 != _lwrite (hFile, bySec2, 512) )
				goto err ;
		
		for (i=0;i<7;i++)
			if (512 != _lwrite (hFile, bySec2, 512) )
				goto err ;
		
		memset (bySec, 0xe5, 512) ;
		
		for (i=0;i<708;i++)
			if (512 != _lwrite (hFile, bySec, 512) )
				goto err ;
		
		_lclose (hFile) ;
		
		mmioOpen (szFile, NULL, MMIO_PARSE) ;
		
		return TRUE ;
		}
err2:
	UnlockResource (hglb) ;
	FreeResource (hglb) ;
err:
	_lclose (hFile) ;
	OpenFile (szFile, NULL, OF_DELETE) ;
	
	return FALSE ;
	}

int QFormatDisk (int drive, BOOL b720)
	{
	int		i, n ;
	HGLOBAL	hglb ;
	BYTE		bySec[512], bySec2[512] ;
	
	if (b720)
		{
		hglb = LoadResource (g_hInstance, FindResource (g_hInstance, 
			MAKEINTRESOURCE (IDSEC_2DD), "SEC") ) ;
		
		i = WriteSector (drive, LockResource (hglb), 0, 1, 0xf9) ;
				
		UnlockResource (hglb) ;
		FreeResource (hglb) ;
		          
          if (i != -1)
          	goto error ;
				
		memset (bySec, 0, 512) ;
		memset (bySec2, 0, 512) ;
		bySec[0] = 0xf9 ;
		bySec[1] = 0xff ;
		bySec[2] = 0xff ;
				
		if ( (i = WriteSector (drive, bySec, 1, 1, 0xf9) ) != -1 || 
			(i = WriteSector (drive, bySec2, 2, 1, 0xf9) ) != -1 || 
			(i = WriteSector (drive, bySec2, 3, 1, 0xf9) ) != -1 || 
			(i = WriteSector (drive, bySec, 4, 1, 0xf9) ) != -1 || 
			(i = WriteSector (drive, bySec2, 5, 1, 0xf9) ) != -1 || 
			(i = WriteSector (drive, bySec2, 6, 1, 0xf9) ) != -1)
			goto error ;
				
		for (n=7;n<14;n++)
			if ( (i = WriteSector (drive, bySec2, n, 1, 0xf9) ) != -1)
				goto error ;
		}
	else
		{
		hglb = LoadResource (g_hInstance, FindResource (g_hInstance, 
			MAKEINTRESOURCE (IDSEC_1DD), "SEC") ) ;
				
		i = WriteSector (drive, LockResource (hglb), 0, 1, 0xf8) ;
				
		UnlockResource (hglb) ;
		FreeResource (hglb) ;
		          
          if (i != -1)
          	goto error ;
				
		memset (bySec, 0, 512) ;
		memset (bySec2, 0, 512) ;
		bySec[0] = 0xf8 ;
		bySec[1] = 0xff ;
		bySec[2] = 0xff ;
				
		if ( (i = WriteSector (drive, bySec, 1, 1, 0xf8) ) != -1 || 
			(i = WriteSector (drive, bySec2, 2, 1, 0xf8) ) != -1 || 
			(i = WriteSector (drive, bySec, 3, 1, 0xf8) ) != -1 || 
			(i = WriteSector (drive, bySec2, 4, 1, 0xf8) ) != -1)
			goto error ;
				
		for (n=5;n<12;n++)
			if ( (i = WriteSector (drive, bySec2, n, 1, 0xf8) ) != -1)
				goto error ;
		}
	
	return -1 ;
error:
	if (i == 12)
		i = 16 ;
	
	return i ;
	}

static void NEAR FormatDisk ()
	{
	int		drive, i ;
	
	if ( (regAF & 0xff) > 2)
		{
		regAF = 0x0100 + 12 ;
		
		return ;
		}
     
     if (regDE / 256 > 1)
     	{
     	regAF = 0x0100 + 2 ;
		
     	return ;
     	}
     
	if (regDE / 256 ? !g_fileset.bDrvBDrv : !g_fileset.bDrvADrv)
		{
     	if (regDE / 256 ? !g_szDiskBFile[0] : !g_szDiskAFile[0])
	     	{
	     	regAF = 0x0100 + 2 ;
			
	     	return ;
	     	}
		
	     if (regDE / 256 ? g_fileset.bDrvBProt : g_fileset.bDrvAProt)
	     	{
	     	regAF = 0x0100 + 0 ;
			
	     	return ;
	     	}
		
		if (CreateDSKfile ( (regAF & 0xff) == 2, 
			(regDE & 0xff00 ? g_szDiskBFile : g_szDiskAFile) ) )
				regAF = 0 ;
		else
				regAF = 0x0100 + 16 ;
		}
	else
		{
		// real drive
		drive = regDE / 256 ? g_fileset.nDrvB : g_fileset.nDrvA ;
		if (!drive)
			{
			regAF = 0x0100 + 2 ;
			
			return ;
			}
		
		if (i)
			{
			drive-- ;
			
			i = QFormatDisk (drive, (regAF & 0xff) == 2) ;
			
			if (i != -1)
				regAF = 0x0100 + i ;
			else
				regAF = 0 ;
			}
		else
			regAF = 0x0100 + 16 ;
		}
	
	return ;
	}

void FAR Patch (WORD wPatch)
	{
	static	bBlockEnd ;
	BYTE		regA = (BYTE)regAF ;
	BYTE		bySec[512] ;
	int		i ;
	
	switch (wPatch)
		{
		// write
		case 0xea:	// TAPOON
			if (CheckBreak () )
				{
				regAF = TAPE_ERROR ;
				return ;
				}
			
			if (regA)
				{
				// long block
				if (nTapeRecTimeOut)
					{
					assert (g_bSaving) ;
					
					nTapeRecTimeOut = 0 ;
					CheckSaveSize () ;
					*(DWORD _huge*)(g_hpSaveDataPtr - 4) = (DWORD) -1L ;
					
					SaveRecording (g_hwndMain, g_hpSaveData, SizeTapeSave () ) ;
					GlobalFreePtr (g_hpSaveData) ;
					g_bSaving = FALSE ;
					}
				else assert (g_bSaving == FALSE) ;
				
				g_hpSaveData = GlobalAllocPtr (GHND, 4096) ;
				g_hpSaveDataPtr = g_hpSaveData + 4 ;
				g_dwSizeSubSave = 0L ;
				g_bSaving = TRUE ;
				bBlockEnd =  FALSE ;
				
				nTapeRecTimeOut = 0 ;
				}
			else
				{
				// short block
				if (g_bSaving)
					{
					if (!bBlockEnd)
						Patch (0xf0) ;
					bBlockEnd =  FALSE ;
					}
				else
					{
					regAF = TAPE_ERROR ;
					return ;
					}
				
				nTapeRecTimeOut = 0 ;
				}
			
			regAF = TAPE_SUCCES ;
			return ;
		
		case 0xed:	// TAPOUT
			if (CheckBreak () )
				{
				if (g_bSaving)
					{
					GlobalFreePtr (g_hpSaveData) ;
					g_bSaving = FALSE ;
					nTapeRecTimeOut = 0 ;
					}
				
				regAF = TAPE_ERROR ;
				return ;
				}
			
			if (g_bSaving)
				{
				CheckSaveSize () ;
				g_hpSaveDataPtr[g_dwSizeSubSave++] = regA ;
				}
			else
				{
				regAF = TAPE_ERROR ;
				return ;
				}
			
			regAF = TAPE_SUCCES ;
			return ;
		
		case 0xf0:	// TAPOOF
			if (g_bLoading)
				{
				if (g_dwSizeLoad || *((DWORD _huge*)g_hpLoadData) == -1L)
					{
					g_bLoading = FALSE ;
					GlobalFreePtr (g_hpLoadData) ;
					
					regAF = TAPE_ERROR ;
					return ;
					}
				}
			
			if (g_bSaving)
				{
				CheckSaveSize () ;
				*(DWORD _huge*)(g_hpSaveDataPtr - 4L) = g_dwSizeSubSave ;
				g_hpSaveDataPtr += g_dwSizeSubSave + 4L ;
				g_dwSizeSubSave = 0L ;
				
				nTapeRecTimeOut = 30 ; // 0.5 sec time out
				bBlockEnd = TRUE ;
				}
			
			regAF = TAPE_SUCCES ;
			return ;
		
		case 0xe1:	// TAPION
			if (CheckBreak () )
				{
				regAF = TAPE_ERROR ;
				return ;
				}
			
			if (!g_bLoading)
				{
				DeActivate () ;
				DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_TAPELOAD), 
					g_hwndMain, TapeLoadDlgProc) ;
				g_dwSizeLoad = 0L ;
				}
			
			if (g_bLoading)
				{
				if (g_dwSizeLoad)
					{
					g_bLoading = FALSE ;
					GlobalFreePtr (g_hpLoadData) ;
					
					regAF = TAPE_ERROR ;
					return ;
					}
				
				g_dwSizeLoad = *(DWORD _huge*)g_hpLoadData ;
				g_hpLoadData += 4 ;
				
				if (g_dwSizeLoad == -1L)
					{
					g_bLoading = FALSE ;
					GlobalFreePtr (g_hpLoadData) ;
					
					regAF = TAPE_ERROR ;
					return ;
					}
				}
			else
				{
				regAF = TAPE_ERROR ;
				return ;
				}
			
			regAF = TAPE_SUCCES ;
			return ;
		
		// read
		case 0xe4:	// tape byte
			if (CheckBreak () )
				{
				regAF = TAPE_ERROR ;
				return ;
				}
			
			if (g_bLoading)
				{
				if (!g_dwSizeLoad--)
					{
					g_bLoading = FALSE ;
					GlobalFreePtr (g_hpLoadData) ;
					
					regAF = TAPE_ERROR ;
					return ;
					}
				
				regAF = TAPE_SUCCES | *g_hpLoadData++ ;
				return ;
				}
			
			regAF = TAPE_ERROR ;
			return ;
		
		case 0xe7:	// tape in of
			if (g_bSaving)
				Patch (0xf0) ;
			
			if (g_bLoading)
				{
				if (g_dwSizeLoad || *((DWORD _huge*)g_hpLoadData) == -1L)
					{
					g_bLoading = FALSE ;
					GlobalFreePtr (g_hpLoadData) ;
					
					regAF = TAPE_ERROR ;
					return ;
					}
				}
			else
				{
				regAF = TAPE_ERROR ;
				return ;
				}
			
			regAF = TAPE_SUCCES ;
			return ;
		
		case 0x4010:
			if (regAF & 0x0100)
				{
				// write
				if (regBC & 0xff00)
					{
					i = WriteSector (regA, lpRAM + regHL, regDE, HIBYTE (regBC), LOBYTE (regBC) ) ;
					
					if (i != -1)
						{
						regAF = (BYTE)i + 0x0100 ;
						
						return ;
						}
					
					regBC = 0 ;
					}
				
				regAF = 0 ;
				
				return ;
				}
			else
				{
				// read
				if (regBC & 0xff00)
					{
					i = ReadSector (regA, lpRAM + regHL, regDE, HIBYTE (regBC), LOBYTE (regBC) ) ;
					
					if (i != -1)
						{
						regAF = (BYTE)i + 0x0100 ;
						
						return ;
						}
					
					regBC = 0 ;
					}
				
				regAF = 0 ;
				
				return ;
				}
			
		case 0x4013:
		     if (regA > 1)
		     	{
		     	regAF = 0x0100 + 12 ;
		     	
		     	return ;
		     	}
		     
		     if (regA ? 
		     	(g_fileset.bDrvBDrv ? !g_fileset.nDrvB : !g_szDiskBFile[0]) : 
		     	(g_fileset.bDrvADrv ? !g_fileset.nDrvA : !g_szDiskAFile[0]) )
		     	{
		     	regAF = 0x0100 + 2 ;
		     	
		     	return ;
		     	}
		     
		     regAF &= 0xff ;	// reset carry (F reg)
		     regBC &= 0xff00 ;	// B = 0
		     
		     // fall through
		case 0x4016:
		     {
			int		BytesPerSector, SectorsPerDisk, 
					SectorsPerFAT,ReservedSectors, I, J ;
			WORD		wAddress ;
		     
		     i = ReadSector (regA, bySec, 0, 1, HIBYTE (regBC) ) ;
		     
		     if (i != -1)
		     	{
		     	regAF = 0x0100 + i ;
		     	
		     	return ;
		     	}
		     
			BytesPerSector  = (int)bySec[0x0C]*256 + bySec[0x0B] ;
			SectorsPerDisk  = (int)bySec[0x14]*256 + bySec[0x13] ;
			SectorsPerFAT   = (int)bySec[0x17]*256 + bySec[0x16] ;
			ReservedSectors = (int)bySec[0x0F]*256 + bySec[0x0E] ;
			 
			wAddress = regHL + 1 ;
			/* Format ID [F8h-FFh] */
			lpRAM[wAddress++] = bySec[0x15] ;
			/* Sector size         */
			lpRAM[wAddress++] = bySec[0x0B] ;
			lpRAM[wAddress++] = bySec[0x0C] ;
			/* Directory mask/shft */
			J=(BytesPerSector>>5)-1;
			for(I=0;J&(1<<I);I++);
			lpRAM[wAddress++] = (BYTE)J ;
			lpRAM[wAddress++] = (BYTE)I ;
			/* Cluster mask/shift  */
			J=bySec[0x0D]-1;
			for(I=0;J&(1<<I);I++);
			lpRAM[wAddress++] = (BYTE)J ;
			lpRAM[wAddress++] = (BYTE)(I+1) ;
			/* Sector # of 1st FAT */
			lpRAM[wAddress++] = bySec[0x0E] ;
			lpRAM[wAddress++] = bySec[0x0F] ;
			/* Number of FATs      */
			lpRAM[wAddress++] = bySec[0x10] ;
			/* Number of dirent-s  */
			lpRAM[wAddress++] = bySec[0x11] ;
			J=ReservedSectors+bySec[0x10]*SectorsPerFAT;
			if (BytesPerSector)
				J+=32*bySec[0x11]/BytesPerSector ;
			else
				J=0 ;
			/* Sector # of data    */
			lpRAM[wAddress++] = LOBYTE(J) ;
			lpRAM[wAddress++] = HIBYTE(J) ;
			if (bySec[0x0D])
				J=(SectorsPerDisk-J)/bySec[0x0D] ;
			else
				J=0 ;
			/* Number of clusters  */
			lpRAM[wAddress++] = LOBYTE(J) ;
			lpRAM[wAddress++] = HIBYTE(J) ;
			/* Sectors per FAT     */
			lpRAM[wAddress++] = bySec[0x16] ;
			J=ReservedSectors+bySec[0x10]*SectorsPerFAT;
			/* Sector # of dir.    */
			lpRAM[wAddress++] = LOBYTE(J) ;
			lpRAM[wAddress++] = HIBYTE(J) ;
			
			regAF = 0 ;
			
			return ;
			}
		
		case 0x401c:
			// format disk ...
			FormatDisk () ;
			
			return ;
		}
	}

// character conversion
void MsxToAnsiBuf (LPBYTE lpStr, int len)
	{
	static const char BASED_CODE 	szMsxToAnsi[] = {
		' ', ' ', ' ', ' ', ' ', ' ', ' ', '', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', '', 
		' ', ' ', ' ', ' ', ' ', '+', '|', '', 
		' ', ' ', ' ', ' ', '', ' ', ' ', '+', 
		' ', '!', '"', '#', '$', '%', '&','\'', 
		'(', ')', '*', '+', ',', '-', '.', '/', 
		'0', '1', '2', '3', '4', '5', '6', '7', 
		'8', '9', ':', ';', '<', '=', '>', '?', 
		'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 
		'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 
		'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 
		'X', 'Y', 'Z', '[','\\', ']', '^', '_', 
		'`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 
		'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 
		'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 
		'x', 'y', 'z', '{', '|', '}', '~', ' ', 
		'', '', '', '', '', '', '', '', 
		'', '', '', '', '', '', '', '', 
		'', '', '', '', '', '', '', '', 
		'', '', '', '', '', '', ' ', '', 
		'', '', '', '', '', '', '', '', 
		'', ' ', '', '', '', '', '', '', 
		'', '', ' ', ' ', '', '', ' ', ' ', 
		' ', ' ', '', ' ', ' ', '', '', '', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', '', ' ', ' ', ' ', ' ', ' ', ' ', 
		' ', '', ' ', ' ', ' ', ' ', '', ' ', 
		' ', ' ', ' ', ' ', ' ', '', ' ', ' ', 
		' ', '', ' ', ' ', ' ', ' ', '', ' ', 
		'', '', '', ' ', ' ', '', ' ', ' ' } ;
	int		x ;
	
	for (x = 0;x < len;x++)
		{
		lpStr[x] = szMsxToAnsi[lpStr[x]] ;
		}
	}

int DeleteSpaces (LPBYTE lpStr, int len)
	{
	int		x, newlen = 0 ;
	
	for (x = (len - 1);x >= 0;x--)
		{
		if (lpStr[x] == 0x20)
			{
			if (newlen)
				newlen++ ;
			}
		else
			newlen++ ;
		}
	
	lpStr[newlen] = '\0' ;
	
	return newlen ;
	}
