/*--------------------------------------------------------
   MSX.C -- Main file from MSX for Windows
                 (c) The Prodigy, 1995
  --------------------------------------------------------*/
#include <windows.h>
#include <windowsx.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <shellapi.h>
#include <mmsystem.h>
#include <commdlg.h>
#include <assert.h>
#include <ctl3d.h>
#include <wing.h>
#include "msx.h"
#include "resource.h"
#include "msxcore.h"
#include "document.h"
#include "statbar.h"
#include "tape.h"
#include "dialogs.h"
#include "printer.h"
#include "mem.h"
#include "disk.h"

// forward declarations
long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG) ;
static BOOL NEAR InitFirstInstance (void) ;
static void NEAR LoadProfileSettings (int nCmdShow) ;
static void NEAR StoreProfileSettings (void) ;
// screen redrawing functions
static void NEAR PaintScreen (HDC) ;
static void NEAR ClearSystemPalette (void) ;
// screen copying functions
static void NEAR CopyBitmap (PRECT) ;
static void NEAR CopyText (PRECT) ;
static void NEAR ClientToView (PPOINT) ;
static void NEAR SnapToGrid (PPOINT) ;
static void NEAR MoveArea (HDC, POINT) ;
static void NEAR InvertArea (HDC) ;
static void NEAR EndMark (void) ;

// global variables
const char		g_szAppName[] = "Virtual MSX" ;
HINSTANCE			g_hInstance ;
HPALETTE 			g_hpalScreen ;
BOOL 			g_bConReset, g_bConStop, g_bPasting, g_bDeActivated, 
				g_bTxtAsBmp, g_bCaps, g_bTopDown, g_bPrint, g_bExitRun, 
				g_bAskSave, g_bBitmapA = TRUE, g_bContinue, g_bPalette, g_bZoom ;
LPSTR			g_lpszClipboardText ;
UINT				g_uState, // 0=nothing, 1=running, 2=pause, 3=selecting
				WM_HELP ;
static POINT		g_ptBeg, g_ptEnd, g_ptView ;
static SIZE		g_szClient ;
HWND				g_hwndMain ;
int				g_nTimerCount ;
HDC				g_hdcWinG ;
HBITMAP			g_hbmpWinGOld, g_hbmpWinGB, g_hbmpWinGA ;
extern PRINTFONTS	g_prnfnt ;
extern FILESETTINGS	g_fileset ;
extern char		g_szFileName[], g_szFileTitle[], g_szUntitled[], 
				g_szRecentFile[][_MAX_PATH], g_szTapeFile[] ;
extern BYTE 		_huge* g_hpExp ;

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
				LPSTR lpszCmdParam, int nCmdShow)
	{
	MSG		msg ;
	HACCEL	haccel ;
	HDC		hdc ;
	HCURSOR	hcurOld ;
	int		i ;
	
	g_hInstance = hInstance ;
	
	Ctl3dRegister (g_hInstance) ;
	Ctl3dAutoSubclass (g_hInstance) ;
	
	i = DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_SPLASH), NULL, SplashDlgProc) ;
	
	if (i != TRUE)
		{
		Ctl3dUnregister (g_hInstance) ;
		
		return FALSE ;
		}
	
	hcurOld = SetCursor (LoadCursor (NULL, IDC_WAIT) ) ;
	ShowCursor (TRUE) ;
	
	if (!hPrevInstance)
		if (!InitFirstInstance () )
			return FALSE ;
	
	ClearSystemPalette () ;
	hdc = CreateIC ("DISPLAY", NULL, NULL, NULL) ;
	
	i = GetDeviceCaps (hdc, BITSPIXEL) ;
	g_bPalette = (i == 8) ;
	
	DeleteDC (hdc) ;
	
	if (i < 8 && (LOWORD (GetVersion () < 0x400) ) )
		{
		MessageID (NULL, IDS_COLORWRONG, MB_ICONSTOP) ;
		
		return FALSE ;
		}
	
	GetDrives () ;
	
	g_bDeActivated = FALSE ;
	g_hwndMain = CreateWindow (g_szAppName,	g_szAppName, 
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN, 
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, 
		NULL, NULL, hInstance, NULL) ;
	LoadProfileSettings (nCmdShow) ;
	
	if (!lpszCmdParam[0] || !FileLoad (lpszCmdParam) )
		FileNew () ;
	
	DoCaption () ;
	
	haccel = LoadAccelerators (g_hInstance, MAKEINTRESOURCE (IDR_MAINFRAME) ) ;
	
	ShowCursor (FALSE) ;
	SetCursor (hcurOld) ;
	
	if (!g_bPalette)
		MessageID (g_hwndMain, IDS_MSGCOLOR, MB_ICONINFORMATION | MB_OK) ;
	
	while (1)
		{
		if (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE) )
			{
			if (msg.message == WM_QUIT) 
				break ;
			
			if (!TranslateAccelerator (g_hwndMain, haccel, &msg) )
				{
				TranslateMessage (&msg) ;
				DispatchMessage (&msg) ;
				}
			}
		else
			{
			if (g_bDeActivated)
				{
				g_bDeActivated = FALSE ;
				DoCaption () ;
				}
			
			TimeSliceEmulator () ;
			}
		}
	
	ClearPrint (FALSE) ;
	Ctl3dUnregister (g_hInstance) ;
	
	return msg.wParam ;
	}

void DoCaption ()
	{
	const static char *szState[] = {
		"", "(running)", "(paused)", "(mark)" }, 
			szInActive[] = "(inactive)" ;
	char		szCaption[64 + _MAX_FNAME + _MAX_EXT] ;
	
	if ( (g_uState != 1 || (g_bContinue || GetFocus () == g_hwndMain) && !g_bDeActivated) )
		wsprintf (szCaption, "%s - %s %s", (LPCSTR) g_szAppName, 
			(LPCSTR) (g_szFileTitle[0] ? g_szFileTitle : g_szUntitled), 
			(LPCSTR) szState[g_uState]) ;
	else
		wsprintf (szCaption, "%s - %s %s", (LPCSTR) g_szAppName, 
			(LPCSTR) (g_szFileTitle[0] ? g_szFileTitle : g_szUntitled), 
			(LPCSTR) szInActive) ;
     
	SetWindowText (g_hwndMain, szCaption) ;
	}

void DeActivate (void)
	{
	g_bDeActivated = TRUE ;
	DoCaption () ;
	}

static BOOL NEAR InitFirstInstance ()
	{
	char		szExeFileName[_MAX_PATH], 
			szBuf1[256], szBuf2[256] ;
	WNDCLASS	wndclass ;
	
	wndclass.style         = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNCLIENT ;
	wndclass.lpfnWndProc   = WndProc ;
	wndclass.cbClsExtra    = 0 ;
	wndclass.cbWndExtra    = 0 ;
	wndclass.hInstance     = g_hInstance ;
	wndclass.hIcon         = LoadIcon (g_hInstance, MAKEINTRESOURCE (IDR_MAINFRAME) ) ;
	wndclass.hCursor       = NULL ;
	wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1) ;
	wndclass.lpszMenuName  = MAKEINTRESOURCE (IDR_MAINFRAME) ;
	wndclass.lpszClassName = g_szAppName ;
     
	if (!RegisterClass (&wndclass) )
		return FALSE ;
	
	wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
	wndclass.lpfnWndProc   = StatusWndProc ;
	wndclass.cbClsExtra    = 0 ;
	wndclass.cbWndExtra    = 0 ;
	wndclass.hInstance     = g_hInstance ;
	wndclass.hIcon         = NULL ;
	wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
	wndclass.hbrBackground = (HBRUSH) (COLOR_BTNFACE + 1) ;
	wndclass.lpszMenuName  = NULL ;
	wndclass.lpszClassName = "StatusBar" ;
	
	if (!RegisterClass (&wndclass) )
		return FALSE ;
	
     // register msx setup file for File Manager
     GetModuleFileName (g_hInstance, szExeFileName, _MAX_PATH) ;
     strcat (szExeFileName, " %1") ;
	
	LoadString (g_hInstance, IDS_REGFILETYPE, szBuf1, 256) ;
	LoadString (g_hInstance, IDS_REGFILETYPENAME, szBuf2, 256) ;
	RegSetValue (HKEY_CLASSES_ROOT, szBuf1, 
		REG_SZ, szBuf2, strlen (szBuf2) ) ;
	
	LoadString (g_hInstance, IDS_REGOPENSHELL, szBuf1, 256) ;
	RegSetValue (HKEY_CLASSES_ROOT, szBuf1, 
		REG_SZ, szExeFileName, strlen (szExeFileName) ) ;
	
	LoadString (g_hInstance, IDS_REGEXTFILE, szBuf1, 256) ;
	LoadString (g_hInstance, IDS_REGFILETYPE, szBuf2, 256) ;
	RegSetValue (HKEY_CLASSES_ROOT, szBuf1, 
		REG_SZ, szBuf2, strlen (szBuf2) ) ;
	
	return TRUE ;
	}

// initialization file
static const char BASED_CODE g_szIniSectionConfirm[] = "Confirmation" ;
static const char BASED_CODE g_szIniConReset[] = "Reset" ;
static const char BASED_CODE g_szIniConStop[] = "Stop" ;
static const char BASED_CODE g_szIniExitRun[] = "ExitWhileRunning" ;
static const char BASED_CODE g_szIniAskSave[] = "AskToSaveChanges" ;

static const char BASED_CODE g_szIniSectionSettings[] = "Settings" ;
static const char BASED_CODE g_szIniTxtAsBmp[] = "CopyTextAsBitmap" ;
static const char BASED_CODE g_szIniProcessBack[] = "ProcessBackground" ;
static const char BASED_CODE g_szIniWindowPos[] = "WindowPos" ;
static const char g_szIniWindowFormat[] = "%u,%u,%d,%d,%d,%d,%d,%d,%d,%d" ;

static const char BASED_CODE g_szIniSectionSetupMRU[] = "Recent File List" ;
static const char *g_szIniRecentFile[4] = {
	"File1", "File2", "File3", "File4" } ;
static const char BASED_CODE g_szIniRecentTape[] = "TapeFile" ;

static const char BASED_CODE g_szIniSectionFonts[] = "Printing Fonts" ;
static const char BASED_CODE g_szIniFontNormal[] = "NormalFont" ;
static const char BASED_CODE g_szIniFontQuality[] = "QualityFont" ;
static const char BASED_CODE g_szIniFontDefault[] = "NormalDefault" ;
static const char BASED_CODE g_szIniFontStyle[] = "FontStyle" ;
static const char g_szIniFontsFormat[] = "%d,%d,%u" ;

static void NEAR LoadProfileSettings (int nCmdShow)
	{
	char 	szIniFileName[_MAX_PATH] ;
	char		szBuf[256] ;
	static const char 
		BASED_CODE	szTimes[] = "Times New Roman", 
		BASED_CODE	szArial[] = "Arial" ;
	WINDOWPLACEMENT wp ;
	int		i ;
	
	GetModuleFileName (g_hInstance, szIniFileName, _MAX_PATH) ;
	strcpy (szIniFileName + strlen (szIniFileName) - 3, "INI") ;
	
	g_bConReset = (BOOL) GetPrivateProfileInt (g_szIniSectionConfirm, 
		g_szIniConReset, TRUE, szIniFileName) ;
	g_bConStop = (BOOL) GetPrivateProfileInt (g_szIniSectionConfirm, 
		g_szIniConStop, TRUE, szIniFileName) ;
	g_bExitRun = (BOOL) GetPrivateProfileInt (g_szIniSectionConfirm, 
		g_szIniExitRun, TRUE, szIniFileName) ;
	g_bAskSave = (BOOL) GetPrivateProfileInt (g_szIniSectionConfirm, 
		g_szIniAskSave, TRUE, szIniFileName) ;
	
	g_bTxtAsBmp = (BOOL) GetPrivateProfileInt (g_szIniSectionSettings, 
		g_szIniTxtAsBmp, FALSE, szIniFileName) ;
	g_bContinue = (BOOL) GetPrivateProfileInt (g_szIniSectionSettings, 
		g_szIniProcessBack, FALSE, szIniFileName) ;
	
	for (i=0;i<4;i++)
		{
		GetPrivateProfileString (g_szIniSectionSetupMRU, 
			g_szIniRecentFile[i], "", g_szRecentFile[i], 
			_MAX_PATH, szIniFileName) ;
		}

	GetPrivateProfileString (g_szIniSectionSetupMRU, 
		g_szIniRecentTape, "", g_szTapeFile, _MAX_PATH, szIniFileName) ;
	
	// fonts
	GetPrivateProfileString (g_szIniSectionFonts, 
		g_szIniFontNormal, szArial, g_prnfnt.szNormalFaceName, 
		LF_FACESIZE, szIniFileName) ;
	GetPrivateProfileString (g_szIniSectionFonts, 
		g_szIniFontQuality, szTimes, g_prnfnt.szQualityFaceName, 
		LF_FACESIZE, szIniFileName) ;
	g_prnfnt.bNormalDef = GetPrivateProfileInt (g_szIniSectionFonts, 
		g_szIniFontDefault, TRUE, szIniFileName) ;
	GetPrivateProfileString (g_szIniSectionFonts, 
		g_szIniFontStyle, "", szBuf, 256, szIniFileName) ;
	
	// with cl options G3 and Ox, something goes wrong without this euh... stuff
	if (3 != sscanf (szBuf, g_szIniFontsFormat, 
		&g_prnfnt.nSize, &i, &g_prnfnt.nWeight) )
		{
		g_prnfnt.nSize = 10 ;
		g_prnfnt.bItalic = FALSE ;
		g_prnfnt.nWeight = FW_NORMAL ;
		}
	else
		g_prnfnt.bItalic = i ;		
	
	GetPrivateProfileString (g_szIniSectionSettings, g_szIniWindowPos, 
		"", szBuf, sizeof (szBuf), szIniFileName) ;
	
	if (10 == sscanf (szBuf, g_szIniWindowFormat, 
		&wp.flags, &wp.showCmd, 
		&wp.ptMinPosition.x, &wp.ptMinPosition.y, 
		&wp.ptMaxPosition.x, &wp.ptMaxPosition.y, 
		&wp.rcNormalPosition.left, &wp.rcNormalPosition.top, 
		&wp.rcNormalPosition.right, &wp.rcNormalPosition.bottom) )
		{
		wp.length = sizeof (WINDOWPLACEMENT) ;
		
		if (nCmdShow != SW_SHOWNORMAL)
			wp.showCmd = nCmdShow ;
		
		SetWindowPlacement (g_hwndMain, &wp) ;
		ShowWindow (g_hwndMain, wp.showCmd) ;
		}
	else
		{
		ShowWindow (g_hwndMain, nCmdShow) ;
		}
	}

static void NEAR StoreProfileSettings ()
	{
	char 	szIniFileName[_MAX_PATH], 
			szBuf[256] ;
	WINDOWPLACEMENT wp ;
	int		i ;
	
	GetModuleFileName (g_hInstance, szIniFileName, _MAX_PATH) ;
	strcpy (szIniFileName + strlen (szIniFileName) - 3, "INI") ;
	
	wsprintf (szBuf, "%d", g_bConReset) ;
	WritePrivateProfileString (g_szIniSectionConfirm, 
		g_szIniConReset, szBuf, szIniFileName) ;
	wsprintf (szBuf, "%d", g_bConStop) ;
	WritePrivateProfileString (g_szIniSectionConfirm, 
		g_szIniConStop, szBuf, szIniFileName) ;
	wsprintf (szBuf, "%d", g_bExitRun) ;
	WritePrivateProfileString (g_szIniSectionConfirm, 
		g_szIniExitRun, szBuf, szIniFileName) ;
	wsprintf (szBuf, "%d", g_bAskSave) ;
	WritePrivateProfileString (g_szIniSectionConfirm, 
		g_szIniAskSave, szBuf, szIniFileName) ;
	
	wsprintf (szBuf, "%d", g_bTxtAsBmp) ;
	WritePrivateProfileString (g_szIniSectionSettings, 
		g_szIniTxtAsBmp, szBuf, szIniFileName) ;
	wsprintf (szBuf, "%d", g_bContinue) ;
	WritePrivateProfileString (g_szIniSectionSettings, 
		g_szIniProcessBack, szBuf, szIniFileName) ;
	
	wp.length = sizeof (WINDOWPLACEMENT) ;
	GetWindowPlacement (g_hwndMain, &wp) ;
	if (IsZoomed (g_hwndMain) )
		wp.flags = WPF_RESTORETOMAXIMIZED ;
	
	wsprintf (szBuf, g_szIniWindowFormat,
		wp.flags, wp.showCmd, 
		wp.ptMinPosition.x, wp.ptMinPosition.y, 
		wp.ptMaxPosition.x, wp.ptMaxPosition.y, 
		wp.rcNormalPosition.left, wp.rcNormalPosition.top, 
		wp.rcNormalPosition.right, wp.rcNormalPosition.bottom) ;
	
	WritePrivateProfileString (g_szIniSectionSettings, 
		g_szIniWindowPos, szBuf, szIniFileName) ;
	
	for (i=0;i<4;i++)
		{
		WritePrivateProfileString (g_szIniSectionSetupMRU, 
			g_szIniRecentFile[i], g_szRecentFile[i], 
			szIniFileName) ;
		}
	WritePrivateProfileString (g_szIniSectionSetupMRU, 
		g_szIniRecentTape, g_szTapeFile, szIniFileName) ;
	
	// fonts
	WritePrivateProfileString (g_szIniSectionFonts, g_szIniFontNormal, 
		g_prnfnt.szNormalFaceName, szIniFileName) ;
	WritePrivateProfileString (g_szIniSectionFonts, g_szIniFontQuality, 
		g_prnfnt.szQualityFaceName, szIniFileName) ;
	wsprintf (szBuf, "%d", g_prnfnt.bNormalDef) ;
	WritePrivateProfileString (g_szIniSectionFonts, g_szIniFontDefault, 
		szBuf, szIniFileName) ;
	wsprintf (szBuf, g_szIniFontsFormat, 
		g_prnfnt.nSize, g_prnfnt.bItalic, g_prnfnt.nWeight) ;
	WritePrivateProfileString (g_szIniSectionFonts, g_szIniFontStyle, 
		szBuf, szIniFileName) ;
	}

static void NEAR CreateWinGBitmap ()
	{
	struct {
		BITMAPINFOHEADER	bmiHeader ;
		RGBQUAD			bmiColors[256] ;
		} bmi ;
	
	memset (&bmi, 0, sizeof (bmi) ) ;
	if (!WinGRecommendDIBFormat ((LPBITMAPINFO)&bmi) )
		bmi.bmiHeader.biHeight = -1 ;	// topdown is faster at buildup
	
	g_bTopDown = bmi.bmiHeader.biHeight < 0 ;
	
	bmi.bmiHeader.biSize         = sizeof (BITMAPINFOHEADER) ;
	bmi.bmiHeader.biWidth        = 256 ;
	bmi.bmiHeader.biHeight      *= 192 ;
	bmi.bmiHeader.biPlanes       = 1 ;
	bmi.bmiHeader.biBitCount     = 8 ;
	
	g_hdcWinG = WinGCreateDC () ;
	
	g_hbmpWinGA = WinGCreateBitmap (g_hdcWinG, (LPBITMAPINFO)&bmi, &lpBitmapA) ;
	g_hbmpWinGB = WinGCreateBitmap (g_hdcWinG, (LPBITMAPINFO)&bmi, &lpBitmapB) ;
	
	g_hbmpWinGOld = SelectObject (g_hdcWinG, g_hbmpWinGA) ;
	}

long FAR PASCAL _export WndProc (HWND hwnd, UINT message, UINT wParam,
											LONG lParam)
	{
	int			i, n ;
	PAINTSTRUCT 	ps ;
	HDC 			hdc ;
	POINT		pt ;
	RECT			rc ;
	HPALETTE 		hpalOld ;
	char			szBuf[_MAX_PATH] ;
	static HCURSOR	hcurSelect ;
 	
	switch (message)
		{
		case WM_CREATE:
			// status bar
			g_hwndStat = CreateWindow ("StatusBar", NULL, WS_CHILD | WS_VISIBLE | WS_BORDER, 
				0, 0, 0, 0, hwnd, NULL, g_hInstance, NULL) ;
			
			hcurSelect = LoadCursor (g_hInstance, MAKEINTRESOURCE (IDC_SELECT) ) ;
			
			WM_HELP = RegisterWindowMessage (HELPMSGSTRING) ;
			
			CreateWinGBitmap () ;
			
			return 0 ;
		
		case WM_SIZE:
			g_szClient.cx = LOWORD (lParam) ;
			g_szClient.cy = HIWORD (lParam) - StatbarPntData.dyStatbar ;
			
			MoveWindow (g_hwndStat, -1, g_szClient.cy, 
				LOWORD (lParam) + 2, StatbarPntData.dyStatbar + 1, TRUE) ;
			
			g_bZoom = (g_szClient.cx > 512 + 10) &&  (g_szClient.cy > 384 + 10) ;
			
			SetView () ;
			
			return 0 ;
		
		case WM_PAINT:
			hdc = BeginPaint (hwnd, &ps) ;
			
			if (g_uState)
				{
				PaintScreen (hdc) ;
				
				if (g_uState == 3)
					{
					InvertArea (hdc) ;
					}
				}
			
			EndPaint (hwnd, &ps) ;
			
			return 0 ;
		
		case WM_SYSCOLORCHANGE:
			Ctl3dColorChange () ;
			
			return 0 ;
		
		case WM_LBUTTONDOWN:
			if (g_uState == 3)
				{
				hdc = GetDC (hwnd) ;
				
				InvertArea (hdc) ;
				
				// get view coordinates to clip cursor
				rc.left = g_ptView.x ;
				rc.top = g_ptView.y ;
				if (g_bZoom)
					{
					rc.right = rc.left + 513 ;
					rc.bottom = rc.top + 385 ;
					}
				else
					{
					rc.right = rc.left + 257 ;
					rc.bottom = rc.top + 193 ;
					}
				
				if (byScreenMode == 0)
					{
					if (g_bZoom)
						{
						rc.left += 16 ;
						rc.right -= 16 ;
						}
					else
						{
						rc.left += 8 ;
						rc.right -= 8 ;
						}
					}
				
				ClientToScreen (hwnd, (LPPOINT)&rc.left) ;
				ClientToScreen (hwnd, (LPPOINT)&rc.right) ;
				
				ClipCursor (&rc) ;
				GetCursorPos (&pt) ;
				SetCursorPos (pt.x, pt.y) ;	// set cursor in area
				ScreenToClient (hwnd, &pt) ;
				
				ClientToView (&pt) ;
				
				g_ptBeg = g_ptEnd = pt ;
				
				SetCapture (hwnd) ;
				
				ReleaseDC (hwnd, hdc) ;
				}
			
			return 0 ;
		
		case WM_MOUSEMOVE:
			SetCursor ((g_uState == 3) ? 
				hcurSelect : LoadCursor (NULL, IDC_ARROW) ) ;
			
			if (GetCapture () == hwnd)
				{
				pt = MAKEPOINT (lParam) ;
				ClientToView (&pt) ;
				
				if (g_ptEnd.x != pt.x || g_ptEnd.y != pt.y)
					{
					hdc =  GetDC (hwnd) ;
					
					MoveArea (hdc, pt) ;
					
					ReleaseDC (hwnd, hdc) ;
					}
				}
			
			return 0 ;
		
		case WM_LBUTTONUP:
			if (GetCapture() == hwnd)
				{
				ReleaseCapture () ;
				
				ClipCursor (NULL) ;
				}
			
			return 0 ;
		
		case WM_TIMER:
			if ( ( g_uState != 1  )  || 
				(!g_bContinue && (GetFocus () != hwnd) ) )
				return 0 ;
			
			g_nTimerCount = 3 ;
			
			return 0 ;
		
		case WM_PALETTECHANGED:
			if ((HWND) wParam == hwnd)
				break ;
			
		case WM_QUERYNEWPALETTE:
			if (g_hpalScreen)
				{
				hdc = GetDC (hwnd) ;
				hpalOld = SelectPalette (hdc, g_hpalScreen, FALSE) ;
				
				i = RealizePalette (hdc) ;
          		
	          	SelectPalette (hdc, hpalOld, FALSE) ;
				ReleaseDC (hwnd, hdc) ;
				
				if (i)
        				InvalidateRect (hwnd, NULL, FALSE) ;
        			}
        		else
        			i = 0 ;
        		
			return i ;
		
		case WM_KEYDOWN:
		case WM_KEYUP:
			if (!g_bPasting)
				OnKey (wParam, lParam) ;
			
			return 0 ;
		
		case WM_CHAR:
		case WM_DEADCHAR:
			if (!g_bPasting)
				OnChar (wParam, lParam) ;
			
			return 0 ;
		
		case WM_MENUSELECT:
			if (lParam == 0xffffL)	// closed menu
				{
				wParam = 0 ;
				}
			else 
				{
				if (LOWORD (lParam) & MF_POPUP)
					{
					n = GetMenuItemCount (GetMenu (hwnd) ) ;
					
					for (i=0;i<n;i++)
						{
						if (GetSubMenu (GetMenu (hwnd), i) == (HMENU)wParam)
							{
							wParam = IDS_MENUFILE + i ;
							
							break ;
							}
						}
					}
				}
			
			SetStatTextID (wParam) ;
			ResetKeyb () ;
			DeActivate () ;
			
			return 0 ;
		
		case WM_SETFOCUS:
		case WM_KILLFOCUS:
			if (g_uState >= 1)
				{
				ResetKeyb () ;
				DoCaption () ;
				}
			
			return 0 ;
		
		case WM_INITMENUPOPUP:
			if (HIWORD (lParam) )
				return 0 ;
			
			i = g_uState ? MF_ENABLED : MF_GRAYED ;
			
			switch (LOWORD (lParam) )
				{
				case	0:	// file menu, add mru list
					for (i=0;i<4;i++)
						{
						if (!g_szRecentFile[i][0])
							break ;
						
						if (GetMenuItemCount ((HMENU)wParam) < 7)
							AppendMenu ((HMENU)wParam, MF_SEPARATOR, 0, NULL) ;
						
						// there is a problem with this implementation: a filename may not contain a &
						wsprintf (szBuf, "&%d %s", (i + 1), 
							(LPSTR)g_szRecentFile[i]) ;
						
						if (GetMenuItemCount ((HMENU)wParam) <= 7 + i)
							AppendMenu ((HMENU)wParam, MF_STRING, 
								IDM_FILE_MRU1 + i, szBuf) ;
						else
							ModifyMenu ((HMENU)wParam, 7 + i, MF_BYPOSITION | MF_STRING, 
								IDM_FILE_MRU1 + i, szBuf) ;
						}
					
					return 0 ;
				
				case 1: // setup menu
					EnableMenuItem ((HMENU)wParam, IDM_SETUP_DISK, (g_fileset.nDisk < 2 ? MF_ENABLED : MF_GRAYED) ) ;
					
					return 0 ;
				
				case 2:	// edit menu
					if (g_bPasting)
						{
						ModifyMenu ((HMENU)wParam, IDM_EDIT_PASTE, MF_ENABLED, 
							IDM_EDIT_PASTE, "Stop &Pasting\tAlt+V") ;
						}
					else
						{
						ModifyMenu ((HMENU)wParam, IDM_EDIT_PASTE, 
							(g_uState == 1 && IsClipboardFormatAvailable (CF_TEXT) ) ?
							MF_ENABLED : MF_GRAYED, IDM_EDIT_PASTE, "&Paste\tAlt+V") ;
						}
					
					ModifyMenu ((HMENU)wParam, IDM_EDIT_COPY, i, 
						IDM_EDIT_COPY, (byScreenMode <= 1 && !g_bTxtAsBmp) ? "&Copy Text\tAlt+C" : "&Copy Bitmap\tAlt+C") ;
					EnableMenuItem ((HMENU)wParam, IDM_EDIT_MARK, i) ;
					
					CheckMenuItem ((HMENU)wParam, IDM_EDIT_TEXT, 
						g_bTxtAsBmp ? MF_CHECKED : MF_UNCHECKED) ;
					
					return 0 ;
				
				case 3:	// run menu
					ModifyMenu ((HMENU)wParam, IDM_RUN_START, MF_ENABLED | MF_BYCOMMAND, 
						IDM_RUN_START, g_uState ? "S&top\tShift+F12" : "S&tart\tShift+F12") ;
					ModifyMenu ((HMENU)wParam, IDM_RUN_PAUSE, i, 
						IDM_RUN_PAUSE, (g_uState >= 2) ? "Re&sume\tF12" : "Pau&se\tF12") ;
					
					EnableMenuItem ((HMENU)wParam, IDM_RUN_RESET, i) ;
					
					return 0 ;
				
				case 4:	// print menu
					EnableMenuItem ((HMENU)wParam, IDM_PRINT_DELETE, 
						(g_bPrint ? MF_ENABLED : MF_GRAYED) ) ;
					EnableMenuItem ((HMENU)wParam, IDM_PRINT_SAVE, 
						(g_bPrint ? MF_ENABLED : MF_GRAYED) ) ;
					
					return  0 ;
				
				case 5:	// options menu
					CheckMenuItem ((HMENU)wParam, IDM_OPTIONS_BACKGROUND, 
						(g_bContinue ? MF_CHECKED : MF_UNCHECKED) ) ;
					
					return 0 ;
				}
			
			break ;
		
		case WM_COMMAND:
			switch (wParam)
				{
				// file menu
				case IDM_FILE_NEW:
					if (AskSave () )
						{
						FileNew () ;
						
						DoCaption () ;
						}
					
					return 0 ;
					
				case IDM_FILE_OPEN:
					if (AskSave () )
						{
						if (FileLoadDlg (szBuf) )
							{
							FileLoad (szBuf) ;
							}
					
						DoCaption () ;
						}
					
					return 0 ;
					
				case IDM_FILE_SAVE:
					if (g_szFileName[0])
			     		{
			     		FileSave (g_szFileName) ;
				     	
			     		return 0 ;
				     	}
				
				case IDM_FILE_SAVE_AS:
					if (FileSaveDlg (szBuf) )
						{
						FileSave (szBuf) ;
						
						DoCaption () ;
						}
					
					return 0 ;
				
				case IDM_FILE_EXIT:
					SendMessage (hwnd, WM_CLOSE, 0, 0L) ;
					
					return 0 ;

				case IDM_FILE_MRU1:
				case IDM_FILE_MRU2:
				case IDM_FILE_MRU3:
				case IDM_FILE_MRU4:
					if (AskSave () )
						{
						FileLoad (g_szRecentFile[wParam - IDM_FILE_MRU1]) ;
						DoCaption () ;
						}
					
					return 0 ;
				
				// setup menu
				case IDM_SETUP_CART:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_CARTRIDGES), hwnd, CartridgesDlgProc) ;
					
					return 0 ;
				
				case IDM_SETUP_SCREEN:
					DeActivate () ;
					if (DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_SCREENOUTPUT), hwnd, ScreenOutputDlgProc) )
						{
						SetView () ;
						InvalidateRect (hwnd, NULL, FALSE) ;
						}
					
					return 0 ;
				
				case IDM_SETUP_KEYB:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_KEYBOARD), hwnd, KeyboardDlgProc) ;
					
					return 0 ;
				
				case IDM_SETUP_COLOR:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_COLORS), hwnd, ColorsDlgProc) ;
					
					return 0 ;
				
				case IDM_SETUP_JOY:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_JOYSTICKS), hwnd, JoystickDlgProc) ;
					
					return 0 ;
				
				case IDM_SETUP_DISK:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_DISK), hwnd, DiskDlgProc) ;
					
					return 0 ;
				
				// edit menu	
				case IDM_EDIT_TEXT:
					if (g_bTxtAsBmp)
						{
						hdc = GetDC (hwnd) ;
						
						InvertArea (hdc) ;
						
						g_bTxtAsBmp = FALSE ;
						SnapToGrid (&g_ptBeg) ;
						SnapToGrid (&g_ptEnd) ;
						
						InvertArea (hdc) ;
						
						ReleaseDC (hwnd, hdc) ;
						}
					else
						g_bTxtAsBmp = TRUE ;
					
					return 0 ;
				
				case IDM_EDIT_MARK:
					PauseEmulator () ;
					g_uState = 3 ;
					DoCaption () ;
					
					GetCursorPos (&pt) ;
					
					if (hwnd == WindowFromPoint (pt) )
						{
						ScreenToClient (hwnd, &pt) ;
						GetClientRect (hwnd, &rc) ;
						
						if (PtInRect (&rc, pt) )
							{
							SetCursor (hcurSelect) ;
							}
						}
					
					return 0 ;
				
				case IDM_EDIT_COPY:
					if (g_ptBeg.y == g_ptEnd.y || g_ptBeg.x == g_ptEnd.x)
						{
						// notin' selected
						SetRect (&rc, 0, 0, 256, 192) ;
						SnapToGrid ((PPOINT)&rc.left) ;
						SnapToGrid ((PPOINT)&rc.right) ;
						}
					else
						{       
						// area selected
						rc.left = g_ptBeg.x ;
						rc.top = g_ptBeg.y ;
						rc.right = g_ptEnd.x ;
						rc.bottom = g_ptEnd.y ;
						
						if (rc.left > rc.right)
							{
							i = rc.left ;
							rc.left = rc.right ;
							rc.right = i ;
							}
						
						if (rc.top > rc.bottom)
							{
							i = rc.top ;
							rc.top = rc.bottom ;
							rc.bottom = i ;
							}
						}
					
					if (OpenClipboard (hwnd) && EmptyClipboard () )
						{
						if (!g_bTxtAsBmp && byScreenMode <= 1)
							CopyText (&rc) ;
						else
							CopyBitmap (&rc) ;
						
						CloseClipboard () ;
						}
					else
						{
						DeActivate () ;
						MessageID (hwnd, IDS_ERRCLIPBOARD, MB_OK | MB_ICONEXCLAMATION) ;
						}
					
					return 0 ;
				
				case IDM_EDIT_PASTE:
					{
					LPSTR	lpClipboardText ;
					HGLOBAL	hglb ;
					
					if (g_bPasting)
						{
						FreeGlobal ((void FAR**)&g_lpszClipboardText) ;
						g_bPasting = FALSE ;
						}
					else
						{
						if (OpenClipboard (hwnd) && 
							(hglb = GetClipboardData (CF_TEXT)) )
							{
							lpClipboardText = GlobalLock (hglb) ;
							if (NewGlobal (&g_lpszClipboardText, GHND, (DWORD)(UINT) _fstrlen (lpClipboardText) ) )
								{
								_fstrcpy (g_lpszClipboardText, lpClipboardText) ;
								
								g_bPasting = TRUE ;
								}
							
							GlobalUnlock (hglb) ;
							}
						else
							{
							DeActivate () ;
							MessageID (hwnd, IDS_ERRCLIPBOARD, MB_OK | MB_ICONEXCLAMATION) ;
							}
						
						CloseClipboard () ;
						}
					
					return 0 ;
					}
				
				// run menu
				case IDM_RUN_START:
					if (g_uState)
						{
						DeActivate () ;
						if (!g_bConStop || IDYES == MessageID (hwnd, IDS_CONFIRMSTOP, 
							MB_ICONQUESTION | MB_YESNO) )
							{
							EndMark () ;
							
							StopEmulator () ;
							
							InvalidateRect (hwnd, NULL, TRUE) ;
							}
						}
					else
						{
						StartEmulator () ;
						
						InvalidateRect (hwnd, NULL, FALSE) ;
						}
					
					DoCaption () ;
					
					return 0 ;
				
				case IDM_RUN_PAUSE:
					EndMark () ;
					
					PauseEmulator () ;
					
					DoCaption () ;
					ResetKeyb () ;
					
					return 0 ;

				case IDM_RUN_RESET:
					DeActivate () ;
					if (!g_bConReset || IDYES == MessageID (hwnd, IDS_CONFIRMRESET, 
						MB_ICONQUESTION | MB_YESNO) )
						{
						EndMark () ;
						
						ResetEmulator () ;
						DoCaption () ;
						}
					
					return 0 ;
				
				// print menu
				case IDM_PRINT_SAVE:
					SavePrint (hwnd) ;
					
					return 0 ;
				
				case IDM_PRINT_DELETE:
					ClearPrint (TRUE) ;
					
					return 0 ;
				
				case IDM_PRINT_FONTS:
					SetFonts (hwnd) ;
					
					return 0 ;
				
				// help menu
				case IDM_HELP_CONTENTS:
					Help (HELP_CONTENTS, 0L) ;
					
					return 0 ;
				
				case IDM_HELP_SEARCH:
					Help (HELP_PARTIALKEY, (DWORD)(LPSTR) "") ;
					
					return 0 ;
				
				case IDM_HELP_ABOUT:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_ABOUT), hwnd, AboutDlgProc) ;
					
					return 0 ;
				
				// options menu
				case IDM_OPTIONS_CONFIRM:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_CONFIRMATION), hwnd, ConfirmDlgProc) ;
					
					return 0 ;
				
				case IDM_OPTIONS_BACKGROUND:
					g_bContinue = !g_bContinue ;
					
					return 0 ;
				
				case IDM_OPTIONS_TAPEEDIT:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_TAPEEDIT), hwnd, TapeEditDlgProc) ;
					
					return 0 ;
				
				case IDM_OPTIONS_EXPORT:
					DeActivate () ;
					ExportGetROM () ;
					
					return 0 ;
				
				case IDM_OPTIONS_IMPORT:
					DeActivate () ;
					ImportGetROM () ;
					
					return 0 ;
				
				case IDM_OPTIONS_COPY:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_DISKCOPY), hwnd, CopyDiskDlgProc) ;
					
					return 0 ;
				
				case IDM_OPTIONS_FORMAT:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_DISKFORMAT), hwnd, FormatDiskDlgProc) ;
					
					return 0 ;
				
				case IDM_OPTIONS_BOOTSEC:
					DeActivate () ;
					DialogBox (g_hInstance, MAKEINTRESOURCE (IDD_BOOTSECT), hwnd, BootSectorDlgProc) ;
					
					return 0 ;
				}
			
			break ;
		
		case WM_SYSCOMMAND:
			switch (wParam & 0xfff0)
				{
				case SC_SCREENSAVE:
					if (g_uState == 1)
						return 1 ;
				}
			
			break ;
		
		case WM_CLOSE:
			if (g_uState && g_bExitRun)
				{
				DeActivate () ;
				if (IDCANCEL == MessageID (hwnd, IDS_CONFIRMQUIT, 
					MB_ICONINFORMATION | MB_OKCANCEL) )
						return 0 ;
				}
			
			if (AskSave ())
				DestroyWindow (hwnd) ;
			
			return 0 ;
		
		case WM_QUERYENDSESSION:
			if (g_uState && g_bExitRun)
				{
				DeActivate () ;
				if (IDCANCEL == MessageID (hwnd, IDS_CONFIRMQUIT, 
						MB_ICONINFORMATION | MB_OKCANCEL) )
					return 0 ;
				}
			
			return AskSave () ;
		
		case WM_ENDSESSION:
			if (wParam)
				{
				if (g_uState)
					StopEmulator () ;
				ClearPrint (FALSE) ;
				
				StoreProfileSettings () ;
				}
			
			return 0 ;
		
		case WM_DESTROY:
			if (g_uState)
				StopEmulator () ;
			
			StoreProfileSettings () ;
			Help (HELP_QUIT, 0L) ;
			
			DeleteObject (g_hpalScreen) ;
			DestroyCursor (hcurSelect) ;
			SelectObject (g_hdcWinG, g_hbmpWinGOld) ;
			DeleteObject (g_hbmpWinGA) ;
			DeleteObject (g_hbmpWinGB) ;
			DeleteDC (g_hdcWinG) ;
			
			PostQuitMessage (0) ;
			
			return 0 ;
		}
	
	return DefWindowProc (hwnd, message, wParam, lParam) ;
	}

// screen painting functions
void SetView ()
	{
	g_ptView.x = (g_szClient.cx - (g_bZoom ? 512 : 256) ) / 2 ;
	g_ptView.y = (g_szClient.cy - (g_bZoom ? 384 : 192) ) / 2 ;
	}

static void NEAR ClearSystemPalette (void)
	{
	HPALETTE		hPal ;
	HDC			hdcScreen ;
	int			i ;
	
	struct
		{
		WORD			Version ;
		WORD			NumberOfEntries ;
		PALETTEENTRY	aEntries[256] ;
		} Palette =
			{
			0x300, 
			256
			} ;
	
	// Reset everything in the system palette to black
	for (i=0;i<256;i++)
		{
		Palette.aEntries[i].peRed = 0 ;
		Palette.aEntries[i].peGreen = 0 ;
		Palette.aEntries[i].peBlue = 0 ;
		
		Palette.aEntries[i].peFlags = PC_NOCOLLAPSE ;
		}
	
	// Create, select, realize, deselect, and delete the palette
	hdcScreen = GetDC (NULL) ;
	hPal = CreatePalette ((LOGPALETTE*)&Palette) ;
	if (hPal)
		{
		hPal = SelectPalette (hdcScreen, hPal, FALSE) ;
		RealizePalette (hdcScreen) ;
		hPal = SelectPalette (hdcScreen, hPal, FALSE) ;
		DeleteObject (hPal) ;
		}
	ReleaseDC (NULL, hdcScreen);
	}

void CreateIdentityPalette (const PALETTEENTRY* ppalentry)
	{
	RGBQUAD		rgbq[256] ;
	int			i, n ;
	HPALETTE		hpalOld ;
	PALETTEENTRY	ape ;
	struct
		{
		WORD Version;
		WORD NumberOfEntries;
		PALETTEENTRY aEntries[256];
		} Palette =
			{
			0x300,
			256
			} ;
	
	// Just use the screen DC where we need it
	HDC		hdc = GetDC (NULL) ;
	
	// For SYSPAL_NOSTATIC, just copy the color table into
	// a PALETTEENTRY array and replace the first and last entries
	// with black and white
	memset (&Palette.aEntries, 0, sizeof (PALETTEENTRY) * 256) ;
	
	if (GetSystemPaletteUse (hdc) == SYSPAL_NOSTATIC)
		{
		// Make sure the last entry is white
		// This may replace an entry in the array!
		Palette.aEntries[255].peRed = 255 ;
		Palette.aEntries[255].peGreen = 255 ;
		Palette.aEntries[255].peBlue = 255 ;
		Palette.aEntries[255].peFlags = 0 ;
		
		// And the first is black
		// This may replace an entry in the array!
		Palette.aEntries[0].peRed = 0 ;
		Palette.aEntries[0].peGreen = 0 ;
		Palette.aEntries[0].peBlue = 0 ;
		Palette.aEntries[0].peFlags = 0 ;
		
		for (i=1;i<255;i++)
			Palette.aEntries[i].peFlags = PC_NOCOLLAPSE ;
		}
	else
		{
		// For SYSPAL_STATIC, get the twenty static colors into
		// the array, then fill in the empty spaces with the
		// given color table
		
		// Get the static colors from the system palette
		if (g_bPalette)
			{
			GetSystemPaletteEntries (hdc, 0, 256, Palette.aEntries) ;
			
			// Set the peFlags of the static colors to zero
			for (i=0;i<FIRSTENTRY;i++)
				Palette.aEntries[i].peFlags = 0;
			
			for (;i<256 - FIRSTENTRY;i++)
				Palette.aEntries[i].peFlags = PC_NOCOLLAPSE ;
		     
			for (;i<256;i++)
				Palette.aEntries[i].peFlags = 0 ;
			}
		}
	
	// Fill in the entries from the color table
	Palette.aEntries[FIRSTENTRY]         = ppalentry[byBackClr] ;
	Palette.aEntries[FIRSTENTRY].peFlags = PC_RESERVED ;
	Palette.aEntries[255 - FIRSTENTRY].peRed   = 
		~ppalentry[byBackClr].peRed ;
	Palette.aEntries[255 - FIRSTENTRY].peGreen = 
		~ppalentry[byBackClr].peGreen ;
	Palette.aEntries[255 - FIRSTENTRY].peBlue  = 
		~ppalentry[byBackClr].peBlue ;
	Palette.aEntries[255 - FIRSTENTRY].peFlags = PC_RESERVED ;
	
	for (i=1;i<16;i++)
		{
		ape = ppalentry[i - 1] ;
		ape.peFlags = PC_NOCOLLAPSE ;
		for (n=246;n<256;n++)
			{
			if (!memcmp (&ape, &Palette.aEntries[n], 3) )
				{
				ape.peFlags = PC_RESERVED ;
				break ;
				}
			}
		Palette.aEntries[FIRSTENTRY + i] = ape ;
		ape.peRed   = ~ape.peRed ;
		ape.peGreen = ~ape.peGreen ;
		ape.peBlue  = ~ape.peBlue ;
		ape.peFlags = PC_NOCOLLAPSE ;
		for (n=246;n<256;n++)
			{
			if (!memcmp (&ape, &Palette.aEntries[n], 3) )
				{
				ape.peFlags = PC_RESERVED ;
				break ;
				}
			}
		Palette.aEntries[255 - FIRSTENTRY - i] = ape ;
		}
	
	// we're going to use FIRSTENTRY + 16 for animation in the colors dialog
	Palette.aEntries[FIRSTENTRY + 16].peFlags = PC_RESERVED ;
	
	for (i=0;i<256;i++)
		{
		rgbq[i].rgbRed      = Palette.aEntries[i].peRed ;
		rgbq[i].rgbGreen    = Palette.aEntries[i].peGreen ;
		rgbq[i].rgbBlue     = Palette.aEntries[i].peBlue ;
		rgbq[i].rgbReserved = 0 ;
		}
	SelectObject (g_hdcWinG, g_hbmpWinGB) ;
	WinGSetDIBColorTable (g_hdcWinG, 0, 256, rgbq) ;
	SelectObject (g_hdcWinG, g_hbmpWinGA) ;
	WinGSetDIBColorTable (g_hdcWinG, 0, 256, rgbq) ;
	
	// Return the palette
	if (g_hpalScreen) DeleteObject (g_hpalScreen) ;
	
	g_hpalScreen = CreatePalette ((LPLOGPALETTE)&Palette) ;
	
	hpalOld = SelectPalette (hdc, g_hpalScreen, FALSE) ;
	RealizePalette (hdc) ;
	InvalidateRect (g_hwndMain, NULL, FALSE) ;
	SelectPalette (hdc, hpalOld, FALSE) ;
	
	// Remember to release the DC!
	ReleaseDC (g_hwndMain, hdc) ;
	}

static void NEAR PaintScreen (HDC hdc)
	{
	RECT		rc ;
	HBRUSH	hbr ;
	HPALETTE	hpalOld ;
	
	hpalOld = SelectPalette (hdc, g_hpalScreen, FALSE) ;
	RealizePalette (hdc) ;
	
	hbr = CreateSolidBrush (g_bPalette ? 
		PALETTEINDEX (FIRSTENTRY) : GetNearestColor (hdc, PALETTEINDEX (FIRSTENTRY) ) ) ;
	
	if (byScreenMode != 0xff) // screen blank
		{
		rc.left = rc.top = 0 ;
		rc.right = g_ptView.x ;
		rc.bottom = g_szClient.cy ;
		FillRect (hdc, &rc, hbr) ;
		
		rc.left = g_ptView.x + (g_bZoom ? 512 : 256) ;
		rc.right = g_szClient.cx ;
		FillRect (hdc, &rc, hbr) ;
		
		rc.right = rc.left ;
		rc.left = g_ptView.x ;
		rc.bottom = g_ptView.y ;
		FillRect (hdc, &rc, hbr) ;
		
          rc.top = g_ptView.y + (g_bZoom ? 384 : 192) ;
		rc.bottom = g_szClient.cy ;
		FillRect (hdc, &rc, hbr) ;
		
		SelectObject (g_hdcWinG, g_bBitmapA ? g_hbmpWinGA : g_hbmpWinGB) ;
		
		if (!g_bZoom)
			{
			WinGBitBlt (hdc, g_ptView.x, g_ptView.y, 256, 192, 
				g_hdcWinG, 0, 0) ;
			}
		else
			{
			WinGStretchBlt (hdc, g_ptView.x, g_ptView.y, 512, 384, 
				g_hdcWinG, 0, 0, 256, 192) ;
			}
		}
	else
		{
		rc.left   = rc.top = 0 ;
		rc.right  = g_szClient.cx ;
		rc.bottom = g_szClient.cy ;
		
		FillRect (hdc, &rc, hbr) ;
		}
	
	SelectPalette (hdc, hpalOld, FALSE) ;
	DeleteObject (hbr) ;
	}

void DrawFrame ()
	{
	PALETTEENTRY	ape ;
	HPALETTE		hpalOld ;
	HDC			hdc ;
	RGBQUAD		rgbq ;
	static BYTE	byOldBackClr = 0xff ;
	DWORD		dw ;
	int			yTop, yBottom ;
	
	hdc = GetDC (g_hwndMain) ;
	hpalOld = SelectPalette (hdc, g_hpalScreen, FALSE) ;
	
	if (byBackClr != byOldBackClr)
		{
		byOldBackClr = byBackClr ;
		
		ape = g_fileset.ape[byBackClr] ;
		ape.peFlags = PC_RESERVED ;
		
		AnimatePalette (g_hpalScreen, FIRSTENTRY, 1, &ape) ;
		
		rgbq.rgbRed   = ape.peRed ;
		rgbq.rgbGreen = ape.peGreen ;
		rgbq.rgbBlue  = ape.peBlue ;
		rgbq.rgbReserved = 0 ;
		SelectObject (g_hdcWinG, g_hbmpWinGB) ;
		WinGSetDIBColorTable (g_hdcWinG, FIRSTENTRY, 1, &rgbq) ;
		SelectObject (g_hdcWinG, g_hbmpWinGA) ;
		WinGSetDIBColorTable (g_hdcWinG, FIRSTENTRY, 1, &rgbq) ;
		
		if (g_bPalette)
			{
			ape.peRed   = ~g_fileset.ape[byBackClr].peRed ;
			ape.peGreen = ~g_fileset.ape[byBackClr].peGreen ;
			ape.peBlue  = ~g_fileset.ape[byBackClr].peBlue ;
			ape.peFlags = PC_RESERVED ;
			AnimatePalette (g_hpalScreen, 255 - FIRSTENTRY, 1, &ape) ;
			
			rgbq.rgbRed   = ape.peRed ;
			rgbq.rgbGreen = ape.peGreen ;
			rgbq.rgbBlue  = ape.peBlue ;
			rgbq.rgbReserved = 0 ;
			SelectObject (g_hdcWinG, g_hbmpWinGB) ;
			WinGSetDIBColorTable (g_hdcWinG, 255 - FIRSTENTRY, 1, &rgbq) ;
			SelectObject (g_hdcWinG, g_hbmpWinGA) ;
			WinGSetDIBColorTable (g_hdcWinG, 255 - FIRSTENTRY, 1, &rgbq) ;
			}
		else
			{
			InvalidateRect (g_hwndMain, NULL, FALSE) ;
			SelectPalette (hdc, hpalOld, FALSE) ;
			ReleaseDC (g_hwndMain, hdc) ;
			
			return ;
			}
		}
	
	dw = CalcUpdate () ;
	// assembly routine that calculates differences between lpBitmapA and B
	if (dw != -1L)
		{
		if (g_bTopDown)
			{
			yTop    = LOWORD (dw) ;
			yBottom = HIWORD (dw) ;
			}
		else
			{
			yTop    = 191 - HIWORD (dw) ;
			yBottom = 191 - LOWORD (dw) ;
			}
		
		SelectObject (g_hdcWinG, g_bBitmapA ? g_hbmpWinGA : g_hbmpWinGB) ;
		
		if (!g_bZoom)
			{
			WinGBitBlt (hdc, g_ptView.x, g_ptView.y + yTop, 
				256, (yBottom - yTop + 1), g_hdcWinG, 0, yTop) ;
			}
		else
			{
			WinGStretchBlt (hdc, g_ptView.x, 
				g_ptView.y + 2 * yTop, 512, 2 * (yBottom - yTop + 1), 
				g_hdcWinG, 0, yTop, 256, (yBottom - yTop + 1) ) ;
			}
		}
	
	SelectPalette (hdc, hpalOld, FALSE) ;
	ReleaseDC (g_hwndMain, hdc) ;
	}

// screen copying fuctions
static void NEAR SnapToGrid (PPOINT pPT)
	{
	int i ;
	
	assert (pPT->x >= 0 && pPT->x <= 256) ;
	assert (pPT->y >= 0 && pPT->y <= 192) ;
	
	// screen 0 less wide than other screens
	if (byScreenMode == 0)
		{
		if (pPT->x < 8)
			pPT->x = 8 ;
		else
			if (pPT->x > 247)
				pPT->x = 247 ;
		}
	
	if (!g_bTxtAsBmp && byScreenMode <= 1)	// text mode: text grid
		{
		// vertical grid
		i = pPT->y % 8 ;
		pPT->y -= i ;
		
		if (i >= 4)
			pPT->y += 8 ;
		
		// horizontal grid
		if (byScreenMode == 1)
			{
			// screen 1
			i = pPT->x % 8 ;
			pPT->x -= i ;
			
			if (i >= 4)
				pPT->x += 8 ;
			}
		else
			{
			// screen 0
			i = (pPT->x - 8) % 6 ;
			pPT->x -= i ;
			
			if (i >= 3)
				pPT->x += 6 ;
			}
		}
	
	assert (pPT->x >= 0 && pPT->x <= 256) ;
	assert (pPT->y >= 0 && pPT->y <= 192) ;
	}

static void NEAR ClientToView (PPOINT pPT)
	{
	pPT->x -= g_ptView.x ;
	pPT->y -= g_ptView.y ;
	
	if (g_bZoom)
		{
		pPT->x = pPT->x / 2 ;
		pPT->y = pPT->y / 2 ;
		}
	
	assert (pPT->x >= 0 && pPT->x <= 256) ;
	assert (pPT->y >= 0 && pPT->y <= 192) ;
	
	SnapToGrid (pPT) ;
	}

static void NEAR MoveArea (HDC hdc, POINT pt)
	{
	RECT		rc ;
	
	assert (pt.x >= 0 && pt.x <= 256) ;
	assert (pt.y >= 0 && pt.y <= 192) ;
	
	if (g_bZoom)
		{
		rc.left = g_ptView.x + pt.x * 2 ;
		rc.top = g_ptView.y + g_ptEnd.y * 2 ;
		rc.right = g_ptView.x + g_ptEnd.x * 2  ;
		rc.bottom = g_ptView.y + g_ptBeg.y * 2 ;
		InvertRect (hdc, &rc) ;
		
		rc.left = g_ptView.x + pt.x * 2 ;
		rc.top = g_ptView.y + pt.y * 2 ;
		rc.right = g_ptView.x + g_ptBeg.x * 2 ;
		rc.bottom = g_ptView.y + g_ptEnd.y * 2 ;
		InvertRect (hdc, &rc) ;
		}
	else
		{
		rc.left = g_ptView.x + pt.x ;
		rc.top = g_ptView.y + g_ptEnd.y ;
		rc.right = g_ptView.x + g_ptEnd.x ;
		rc.bottom = g_ptView.y + g_ptBeg.y ;
		InvertRect (hdc, &rc) ;
		
		rc.left = g_ptView.x + pt.x ;
		rc.top = g_ptView.y + pt.y ;
		rc.right = g_ptView.x + g_ptBeg.x ;
		rc.bottom = g_ptView.y + g_ptEnd.y ;
		InvertRect (hdc, &rc) ;
		}
	
	g_ptEnd = pt ;
	}

static void NEAR InvertArea (HDC hdc)
	{
	RECT		rc ;
	
	assert (hdc != NULL) ;
	
	if (g_bZoom)
		{
		rc.left   = g_ptView.x + g_ptBeg.x * 2 ;
		rc.top    = g_ptView.y + g_ptBeg.y * 2 ;
		rc.right  = g_ptView.x + g_ptEnd.x * 2 ;
		rc.bottom = g_ptView.y + g_ptEnd.y * 2 ;
		}
	else
		{
		rc.left   = g_ptView.x + g_ptBeg.x ;
		rc.top    = g_ptView.y + g_ptBeg.y ;
		rc.right  = g_ptView.x + g_ptEnd.x ;
		rc.bottom = g_ptView.y + g_ptEnd.y ;
		}
	
	InvertRect (hdc, &rc) ;
	}

static void NEAR CopyBitmap (PRECT pRC)
	{
	int			x, y, width, widthbytes, height, i ;
	LPBYTE		lpDibPtr, lpBitmap, lpDibBits, lpDib ;
	HGLOBAL		hglbDib ;
	HDC			hdc ;
	HPALETTE		hpalOld ;
	struct
		{
		WORD			palVersion ;
		WORD			palNumEntries ;
		PALETTEENTRY	palPalEntry[16] ;
		} palette ;
	struct
		{
		BITMAPINFOHEADER	bmiHeader ;
		WORD				bmiPaletteIndex[16] ;
		} bitmap ;
	
	assert (pRC->left < pRC->right && pRC->left >= 0 && pRC->right <= 256);
	assert (pRC->top < pRC->bottom && pRC->top >= 0 && pRC->bottom <= 192);
	
	width = pRC->right - pRC->left ;
	height = pRC->bottom - pRC->top ;
	
	// round width up on 4 byte boundary
	widthbytes = (width + 7) / 8 * 8 ;
	assert ( (widthbytes % 8) == 0) ;
	
	// dib
	lpDib = lpDibPtr = GlobalLock (hglbDib = GlobalAlloc (
		GMEM_SHARE | GMEM_MOVEABLE | GMEM_ZEROINIT, 
		sizeof (BITMAPINFOHEADER) + 16 * sizeof (RGBQUAD) + 
		(UINT) widthbytes * (UINT) height / 2) ) ;
	
	if (lpDib == NULL)
		{
		MemoryAlert () ;
		return ;
		}
	
	// palette
	palette.palVersion    = 0x300 ;
	palette.palNumEntries = 16 ;
	GetPaletteEntries (g_hpalScreen, FIRSTENTRY, 16, &palette.palPalEntry[0]) ;
	
	SetClipboardData (CF_PALETTE, CreatePalette ((LPLOGPALETTE)&palette) ) ;
	
	// bitmap info
	((LPBITMAPINFOHEADER)lpDibPtr)->biSize = sizeof (BITMAPINFOHEADER) ;
	((LPBITMAPINFOHEADER)lpDibPtr)->biWidth = width ;
	((LPBITMAPINFOHEADER)lpDibPtr)->biHeight = height ;
	((LPBITMAPINFOHEADER)lpDibPtr)->biPlanes = 1 ;
	((LPBITMAPINFOHEADER)lpDibPtr)->biBitCount = 4 ;
	((LPBITMAPINFOHEADER)lpDibPtr)->biClrImportant = 15 ;
	
	lpDibPtr += sizeof (BITMAPINFOHEADER) ;
	
	for (x=0;x<16;x++)
		{
		((LPRGBQUAD)lpDibPtr)->rgbBlue = palette.palPalEntry[x].peBlue ;
		((LPRGBQUAD)lpDibPtr)->rgbGreen = palette.palPalEntry[x].peGreen ;
		((LPRGBQUAD)lpDibPtr)->rgbRed = palette.palPalEntry[x].peRed ;
		((LPRGBQUAD)lpDibPtr)++ ;
		}
	
	lpDibBits = lpDibPtr  ;
	
	// bits
	if (g_bTopDown)
		{
		for (y = height - 1;y >= 0;y--)	// reverse order because dib upside down
			{
			lpBitmap = (g_bBitmapA ? lpBitmapA : lpBitmapB) + 256 * (y + pRC->top) + pRC->left ;
			
			for (x=0,i=0;x<width;x+=2)
				{
				lpDibPtr[i]    = (lpBitmap[x] - FIRSTENTRY) << 4 ;
				if (x+1<width)
					lpDibPtr[i] |= lpBitmap[x+1] - FIRSTENTRY ;
				i++ ;
				}
			lpDibPtr += widthbytes / 2 ;
			}
		}
	else
		{
		for (y = height;y > 0;y--)	// reverse order because dib upside down
			{
			lpBitmap = (g_bBitmapA ? lpBitmapA : lpBitmapB) + 
				256 * (192 - y - pRC->top) + pRC->left ;
			
			for (x=0,i=0;x<width;x+=2)
				{
				lpDibPtr[i]    = (lpBitmap[x] - FIRSTENTRY) << 4 ;
				if (x+1<width)
					lpDibPtr[i] |= lpBitmap[x+1] - FIRSTENTRY ;
				i++ ;
				}
			lpDibPtr += widthbytes / 2 ;
			}
		}
	
	// bitmap (the colors must be relative to the palette, otherwise 
	// Windows maps the colors to the static colors)
	memset (&bitmap, 0, sizeof (bitmap) ) ;
	
	bitmap.bmiHeader.biSize = sizeof (BITMAPINFOHEADER) ;
	bitmap.bmiHeader.biWidth = width ;
	bitmap.bmiHeader.biHeight = height ;
	bitmap.bmiHeader.biPlanes = 1 ;
	bitmap.bmiHeader.biBitCount = 4 ;
	bitmap.bmiHeader.biClrImportant = 15 ;
	for (x=0;x<16;x++)
		bitmap.bmiPaletteIndex[x] = (WORD) (x + FIRSTENTRY) ;
	
	hdc = GetDC (g_hwndMain) ;
	hpalOld = SelectPalette (hdc, g_hpalScreen, FALSE) ;
	
	SetClipboardData (CF_BITMAP, 
		CreateDIBitmap (hdc, (LPBITMAPINFOHEADER)&bitmap, CBM_INIT, 
			lpDibBits, (LPBITMAPINFO)&bitmap, DIB_PAL_COLORS) ) ;
	
	SelectPalette (hdc, hpalOld, FALSE) ;
	ReleaseDC (g_hwndMain, hdc) ;
	
	// set dib
	GlobalUnlock (hglbDib) ;
	
	SetClipboardData (CF_DIB, hglbDib) ;
	}

static void NEAR CopyText (PRECT pRC)
	{
	HGLOBAL	hglbText ;
	LPSTR	lpText ;
	int		y, len ;
	
	assert (pRC->left < pRC->right && pRC->left >= 0 && pRC->right <= 256);
	assert (pRC->top < pRC->bottom && pRC->top >= 0 && pRC->bottom <= 192);
	
	hglbText = GlobalAlloc (GMEM_SHARE | GMEM_MOVEABLE, 42 * 24 + 1) ;
	lpText = GlobalLock (hglbText) ;
	
	if (lpText == NULL)
		{
		MemoryAlert () ;
		return ;
		}
	
	pRC->top /= 8 ;
	pRC->bottom /= 8 ;
	
	assert (byScreenMode == 1 || byScreenMode == 0) ;
	
	if (byScreenMode == 1)
		{
		pRC->left /= 8 ;
		pRC->right /= 8 ;
		
		len = pRC->right - pRC->left ;
		
		for (y = pRC->top;y < pRC->bottom;y++)
			{
			_fmemcpy (lpText, (LPBYTE)&pNameTbl[32 * y + pRC->left], len) ;
			
			MsxToAnsiBuf (lpText, len) ;
			lpText += DeleteSpaces (lpText, len) ;
			
			// add cr-lf
			*lpText++ = '\r' ;
			*lpText++ = '\n' ;
			}
		}
	else
		{
		pRC->left -= 8 ;
		pRC->right -= 8 ;
		pRC->left /= 6 ;
		pRC->right /= 6 ;
		
		len = pRC->right - pRC->left ;
		
		for (y = pRC->top;y < pRC->bottom;y++)
			{
			_fmemcpy (lpText, (LPBYTE)&pNameTbl[40 * y + pRC->left], len) ;
			
			MsxToAnsiBuf (lpText, len) ;
			lpText += DeleteSpaces (lpText, len) ;
			
			// add cr-lf
			*lpText++ = '\r' ;
			*lpText++ = '\n' ;
			}
		}
	
	// null-terminate
	*lpText = 0 ;
	
	GlobalUnlock (hglbText) ;
	
	SetClipboardData (CF_TEXT, hglbText) ;
	}

static void NEAR EndMark ()
	{
	HDC		hdc ;
	RECT		rc ;
	POINT	pt ;
	
	hdc = GetDC (g_hwndMain) ;
	
	InvertArea (hdc) ;
	
	ReleaseDC (g_hwndMain, hdc) ;
	
	g_ptBeg.x = g_ptBeg.y = g_ptEnd.x = g_ptEnd.y = 0 ;
	
	if (g_uState == 3)
		{
		GetCursorPos (&pt) ;
		
		if (g_hwndMain == WindowFromPoint  (pt) )
			{
			ScreenToClient (g_hwndMain, &pt) ;
			GetClientRect (g_hwndMain, &rc) ;
			
			if (PtInRect (&rc, pt) )
				SetCursor (LoadCursor (NULL, IDC_ARROW) ) ;
			}
		}
	}

void Help (UINT n, DWORD dw)
	{
	char		szPath[_MAX_PATH] ;
	
	GetModuleFileName (g_hInstance, szPath, _MAX_PATH) ;
	strcpy (szPath + strlen (szPath) - 3, "HLP") ;
	
	WinHelp (g_hwndMain, szPath, n, dw) ;
	}
